/*!
 Publisher class
 */

function Publisher () {
    this.subscribers = [];
	
    this.addSubscriber = function(subscriber) {
        this.subscribers.push(subscriber)
    }
	
    this.publish = function (message) {
        this.subscribers.forEach(function(subscriber) {
            subscriber.notify(message);
        });
    }
}

/* Subscriber class */
function Subscriber (recipient, types) {
    this.recipient = recipient
    this.types = types;
    
    this.addType = function(type) {
        this.types.push(type)
    }
    
    this.notify = function (message) {
        for (var i in this.types) {
            if (message.type == this.types[i] || "all" == this.types[i]) {
                this.recipient.postMessage(message, window.location.origin);
                break;
            }
        }
    }
}

/* Message class */
function Message(type, data) {
    this.type = type;
    this.data = data;
}

/* Listener class */
function Listener() {
    this.init = function (handler) {
        window.onmessage = handler;
    }
}