/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HAPI;

import COM.hugin.HAPI.ClassCollection;
import COM.hugin.HAPI.ClassList;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionArgumentNotAlive;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.ExceptionObjectNotAlive;
import COM.hugin.HAPI.ExceptionUsage;
import COM.hugin.HAPI.InstanceNode;
import COM.hugin.HAPI.Native.HAPI;
import COM.hugin.HAPI.NetworkModel;
import COM.hugin.HAPI.Node;
import COM.hugin.HAPI.NodeList;
import java.util.ListIterator;

public class Class
extends NetworkModel {
    public Class(ClassCollection classCollection) throws ExceptionHugin {
        this(classCollection, null);
    }

    public Class(ClassCollection classCollection, String string) throws ExceptionHugin {
        if (classCollection == null) {
            throw new ExceptionUsage("Argument is 'null'");
        }
        if (!classCollection.isAlive()) {
            throw new ExceptionArgumentNotAlive();
        }
        this.modelPeer = HAPI.nativeHAPI.hCCNewClass(classCollection.ccPeer);
        if (this.modelPeer == 0) {
            ExceptionHugin.throwException();
        }
        assert (this.modelPeer != 0);
        try {
            ExceptionHugin.throwException(HAPI.nativeHAPI.hClassSetBackpointer(this.modelPeer, this));
            if (string != null) {
                this.setName(string);
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            HAPI.nativeHAPI.hClassDelete(this.modelPeer);
            throw exceptionHugin;
        }
    }

    protected Class(int n) throws ExceptionHugin {
        this.modelPeer = n;
        ExceptionHugin.throwException(HAPI.nativeHAPI.hClassSetBackpointer(n, this));
    }

    protected static Class convert(int n) throws ExceptionHugin {
        if (n == 0) {
            ExceptionHugin.throwException();
            return null;
        }
        Class clazz = (Class)HAPI.nativeHAPI.hClassGetBackpointer(n);
        if (clazz != null) {
            return clazz;
        }
        return new Class(n);
    }

    public ClassCollection getClassCollection() throws ExceptionHugin {
        int n = HAPI.nativeHAPI.hClassGetClassCollection(this.thisPeer());
        if (n == 0) {
            ExceptionHugin.throwException();
        }
        assert (n != 0);
        ClassCollection classCollection = (ClassCollection)HAPI.nativeHAPI.hCCGetBackpointer(n);
        if (classCollection != null) {
            return classCollection;
        }
        return new ClassCollection(n);
    }

    public void delete() throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hClassDelete(this.thisPeer()));
        assert (!this.isAlive());
    }

    public void setName(String string) throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hClassSetName(this.thisPeer(), string));
    }

    public String getName() throws ExceptionHugin {
        String string = HAPI.nativeHAPI.hClassGetName(this.thisPeer());
        if (string == null) {
            ExceptionHugin.throwException();
        }
        return string;
    }

    public NodeList getOutputs() throws ExceptionHugin {
        return new NodeList(HAPI.nativeHAPI.hClassGetOutputs(this.thisPeer()));
    }

    public NodeList getInputs() throws ExceptionHugin {
        return new NodeList(HAPI.nativeHAPI.hClassGetInputs(this.thisPeer()));
    }

    public Domain createDomain() throws ExceptionHugin {
        return new Domain(this);
    }

    public NodeList getInstances() throws ExceptionHugin {
        return new NodeList(HAPI.nativeHAPI.hClassGetInstances(this.thisPeer()));
    }

    protected boolean containsInstanceOf(ClassList classList) throws ExceptionHugin {
        if (!this.isAlive()) {
            throw new ExceptionObjectNotAlive();
        }
        if (classList == null) {
            throw new ExceptionUsage("Argument is 'null'");
        }
        NodeList nodeList = this.getNodes();
        ListIterator listIterator = nodeList.listIterator();
        while (listIterator.hasNext()) {
            Node node = (Node)listIterator.next();
            if (!(node instanceof InstanceNode) || !classList.contains(((InstanceNode)node).getInstanceClass())) continue;
            return true;
        }
        return false;
    }
}

