/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HAPI;

import COM.hugin.HAPI.Clique;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.ExceptionUsage;
import COM.hugin.HAPI.Native.HAPI;
import COM.hugin.HAPI.NetworkModel;
import COM.hugin.HAPI.Node;

public abstract class DiscreteNode
extends Node {
    protected DiscreteNode(NetworkModel networkModel, NetworkModel.Category category, int n) throws ExceptionHugin {
        super(networkModel, category, NetworkModel.H_KIND_DISCRETE, n);
    }

    protected DiscreteNode(int n) throws ExceptionHugin {
        super(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getBelief(int n) throws ExceptionHugin {
        NetworkModel networkModel = this.getHome();
        synchronized (networkModel) {
            double d = HAPI.nativeHAPI.hNodeGetBelief(this.thisPeer(), n);
            if (d < 0.0) {
                ExceptionHugin.throwException();
            }
            return d;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getExpectedUtility(int n) throws ExceptionHugin {
        NetworkModel networkModel = this.getHome();
        synchronized (networkModel) {
            double d = HAPI.nativeHAPI.hNodeGetExpectedUtility(this.thisPeer(), n);
            if (d < 0.0) {
                ExceptionHugin.throwException();
            }
            return d;
        }
    }

    public double getEnteredFinding(int n) throws ExceptionHugin {
        double d = HAPI.nativeHAPI.hNodeGetEnteredFinding(this.thisPeer(), n);
        if (d < 0.0) {
            ExceptionHugin.throwException();
        }
        return d;
    }

    public double getPropagatedFinding(int n) throws ExceptionHugin {
        double d = HAPI.nativeHAPI.hNodeGetPropagatedFinding(this.thisPeer(), n);
        if (d < 0.0) {
            ExceptionHugin.throwException();
        }
        return d;
    }

    public void retractFindings() throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hNodeRetractFindings(this.thisPeer()));
    }

    public int getNumberOfStates() throws ExceptionHugin {
        int n = HAPI.nativeHAPI.hNodeGetNumberOfStates(this.thisPeer());
        if (n < 0) {
            ExceptionHugin.throwException();
        }
        return n;
    }

    public void setNumberOfStates(int n) throws ExceptionHugin {
        if (n <= 0) {
            throw new ExceptionUsage("State count must be positive");
        }
        ExceptionHugin.throwException(HAPI.nativeHAPI.hNodeSetNumberOfStates(this.thisPeer(), n));
    }

    public String getStateLabel(int n) throws ExceptionHugin {
        String string = HAPI.nativeHAPI.hNodeGetStateLabel(this.thisPeer(), n);
        if (string == null) {
            ExceptionHugin.throwException();
        }
        return string;
    }

    public int getStateIndex(String string) throws ExceptionHugin {
        int n = HAPI.nativeHAPI.hNodeGetStateIndexFromLabel(this.thisPeer(), string);
        if (n < 0) {
            ExceptionHugin.throwException();
        }
        return n;
    }

    public void setStateLabel(int n, String string) throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hNodeSetStateLabel(this.thisPeer(), n, string));
    }

    public void selectState(int n) throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hNodeSelectState(this.thisPeer(), n));
    }

    public int getSelectedState() throws ExceptionHugin {
        int n = HAPI.nativeHAPI.hNodeGetSelectedState(this.thisPeer());
        if (n < 0) {
            ExceptionHugin.throwException();
        }
        return n;
    }

    public int getPropagatedState() throws ExceptionHugin {
        int n = HAPI.nativeHAPI.hNodeGetPropagatedState(this.thisPeer());
        if (n < 0) {
            ExceptionHugin.throwException();
        }
        return n;
    }

    public void enterFinding(int n, double d) throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hNodeEnterFinding(this.thisPeer(), n, d));
    }

    public NetworkModel.Kind getKind() {
        return NetworkModel.H_KIND_DISCRETE;
    }

    public void setCaseState(int n, int n2) throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hNodeSetCaseState(this.thisPeer(), n, n2));
    }

    public void unsetCase(int n) throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hNodeUnsetCase(this.thisPeer(), n));
    }

    public boolean caseIsSet(int n) throws ExceptionHugin {
        boolean bl = HAPI.nativeHAPI.hNodeCaseIsSet(this.thisPeer(), n);
        ExceptionHugin.throwException();
        return bl;
    }

    public int getCaseState(int n) throws ExceptionHugin {
        int n2 = HAPI.nativeHAPI.hNodeGetCaseState(this.thisPeer(), n);
        if (n2 < 0) {
            ExceptionHugin.throwException();
        }
        return n2;
    }

    public int getSampledState() throws ExceptionHugin {
        int n = HAPI.nativeHAPI.hNodeGetSampledState(this.thisPeer());
        if (n < 0) {
            ExceptionHugin.throwException();
        }
        return n;
    }

    public void generateTable() throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hNodeGenerateTable(this.thisPeer()));
    }

    public double getEntropy() throws ExceptionHugin {
        double d = HAPI.nativeHAPI.hNodeGetEntropy(this.thisPeer());
        if (d < 0.0) {
            ExceptionHugin.throwException();
        }
        return d;
    }

    public double[] getSensitivityConstants(int n) throws ExceptionHugin {
        return this.getSensitivityConstants(n, 0);
    }

    public double[] getSensitivityConstants(int n, int n2) throws ExceptionHugin {
        double[] dArray = new double[4];
        ExceptionHugin.throwException(HAPI.nativeHAPI.hNodeGetSensitivityConstants(this.thisPeer(), n, n2, dArray));
        return dArray;
    }

    public double[] getSensitivityConstants(int n, int n2, int n3) throws ExceptionHugin {
        double[] dArray = new double[6];
        ExceptionHugin.throwException(HAPI.nativeHAPI.hNodeGetSensitivityConstants2(this.thisPeer(), n, n2, n3, dArray));
        return dArray;
    }

    public Clique getFindingClique() throws ExceptionHugin {
        return Clique.convert(HAPI.nativeHAPI.hNodeGetConflictClique(this.thisPeer()));
    }

    public double computeProbabilityOfIndependence(DiscreteNode discreteNode) throws ExceptionHugin {
        double d = HAPI.nativeHAPI.hComputeProbabilityOfIndependence(this.thisPeer(), Node.getNodePeer(discreteNode));
        if (d < 0.0) {
            ExceptionHugin.throwException();
        }
        return d;
    }
}

