/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HAPI;

import COM.hugin.HAPI.AmbiguousRegion;
import COM.hugin.HAPI.ExceptionArgumentNotAlive;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.ExceptionObjectNotAlive;
import COM.hugin.HAPI.ExceptionUsage;
import COM.hugin.HAPI.Native.HAPI;
import COM.hugin.HAPI.Node;

public class UncertainEdge {
    protected int uncertainEdgePeer = 0;
    protected AmbiguousRegion belongsTo = null;
    protected Node x = null;
    protected Node y = null;
    public static final EdgeDecision H_EDGE_DECISION_INCLUDE = new EdgeDecision(100);
    public static final EdgeDecision H_EDGE_DECISION_EXCLUDE = new EdgeDecision(101);

    protected UncertainEdge(AmbiguousRegion ambiguousRegion, Node node, Node node2, int n) throws ExceptionHugin {
        if (n == 0) {
            ExceptionHugin.throwException();
        }
        if (!(ambiguousRegion.isAlive() && node.isAlive() && node2.isAlive())) {
            throw new ExceptionArgumentNotAlive();
        }
        this.belongsTo = ambiguousRegion;
        this.uncertainEdgePeer = n;
        this.x = node;
        this.y = node2;
    }

    public Node getFirstNode() throws ExceptionObjectNotAlive {
        if (!this.isAlive()) {
            throw new ExceptionObjectNotAlive();
        }
        return this.x;
    }

    public Node getSecondNode() throws ExceptionObjectNotAlive {
        if (!this.isAlive()) {
            throw new ExceptionObjectNotAlive();
        }
        return this.y;
    }

    public void manualDecision(EdgeDecision edgeDecision) throws ExceptionHugin {
        if (!this.isAlive()) {
            throw new ExceptionObjectNotAlive();
        }
        if (edgeDecision == null) {
            throw new ExceptionUsage("Argument 'decision' is 'null'");
        }
        ExceptionHugin.throwException(HAPI.nativeHAPI.hUncertainEdgeManualDecision(this.uncertainEdgePeer, edgeDecision.value));
        this.belongsTo.updateEdgeList();
    }

    public boolean isAlive() {
        return this.uncertainEdgePeer != 0;
    }

    protected void setNotAlive() {
        this.uncertainEdgePeer = 0;
    }

    public static class EdgeDecision {
        protected final int value;

        protected EdgeDecision(int n) {
            this.value = n;
        }
    }
}

