/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.DiscreteChanceNode;
import COM.hugin.HAPI.DiscreteNode;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.ExceptionInconsistencyOrUnderflow;
import COM.hugin.HAPI.ExceptionInvalidEvidence;
import COM.hugin.HAPI.ExceptionParse;
import COM.hugin.HAPI.ParseListener;
import COM.hugin.HAPI.Table;
import COM.hugin.HGUI.CaseBank;
import COM.hugin.HGUI.ExperienceTableModel;
import COM.hugin.HGUI.FadingTableModel;
import COM.hugin.HGUI.GenericTable;
import COM.hugin.HGUI.HelpPanel;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.HuginProjectFrame;
import COM.hugin.HGUI.NetworkPanel;
import COM.hugin.HGUI.Node;
import COM.hugin.HGUI.NodeTable;
import COM.hugin.HGUI.NodeTableColumn;
import COM.hugin.HGUI.NodeTableColumnModel;
import COM.hugin.HGUI.NodeTableFrame;
import COM.hugin.HGUI.TitledPanel;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdaptationWizard
extends JDialog {
    private JDialog window;
    private JPanel windowPanel;
    private JTabbedPane priorPanel;
    private HelpPanel helpPanel;
    private String[] helpPagesFirst = new String[]{"help/Adapt_Data.htm", "help/Adapt_Exp_Fad.htm"};
    private String helpPageConf = "help/Adapt_Conf.htm";
    private String helpPageLast = "help/Adapt_Perform.htm";
    private JPanel buttonPanel;
    private CallBack nextAction;
    private CallBack backAction;
    private HuginProjectFrame projectFrame;
    private DefaultListModel dataSources;
    private JList dataSourceView;
    private NetworkPanel networkPanel;
    private JPanel nodePanel;
    private JPanel nodeActionPanel;
    private CaseBank caseBank;
    private Domain domain = null;
    private JPanel beginPanel;
    private AdaptationWizard adaptWiz = this;
    private JButton nextButton;
    private JButton helpButton;
    private JButton backButton;
    private LinkedList<Data> data;
    private boolean recordExperienceCounts = true;
    private boolean recordPosteriorMarginals = true;
    private JPanel adaptPanel;
    private JLabel processingStatus;
    private JButton cancelButton;
    private Timer adaptationTimer;
    private JButton adaptationRun;
    private JButton adaptationBreak;
    private boolean performingAdaptation = false;
    private int nextCase = 0;
    private ArrayList<PosteriorMarginals> posteriorMarginals = null;
    private ArrayList<ExperienceCounts> experienceCounts = null;
    private Vector<Node> dcNodes;
    private Vector<Node> dcNodesNoExp;
    private JPanel expGraphPanel = null;
    private JPanel expConfPanel = null;
    private JPanel postGraphPanel = null;
    private JPanel postConfPanel = null;
    private Graph expGraph = null;
    private Graph postGraph = null;
    private boolean inconsistency = false;
    private boolean freeWill = false;

    public AdaptationWizard(HuginProjectFrame huginProjectFrame) {
        super(Hugin.mainFrame, HuginGUIConstants.get("ADAPTWIZ_dialog_title"), true);
        this.projectFrame = huginProjectFrame;
        this.networkPanel = this.projectFrame.getNetworkPanel();
        try {
            this.domain = this.projectFrame.getBeliefBarPanel().getDomain();
            this.caseBank = new CaseBank(this.domain);
            this.caseBank.newCase();
            this.caseBank.copyCasesFromDomain();
            this.domain.setNumberOfCases(0);
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
        }
        this.projectFrame.getBeliefBarPanel().tree.paintInconcistent = true;
        Hugin.mainFrame.repaint();
        this.buttonPanel = new JPanel(new FlowLayout(2));
        this.backButton = new JButton(HuginGUIConstants.get("str_back"));
        this.backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdaptationWizard.this.backAction.call();
            }
        });
        this.buttonPanel.add(this.backButton);
        this.nextButton = new JButton(HuginGUIConstants.get("MISCELLANEOUS_Next"));
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdaptationWizard.this.nextAction.call();
            }
        });
        this.buttonPanel.add(this.nextButton);
        this.cancelButton = new JButton(HuginGUIConstants.get("CANCEL_BUTTON_LABEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdaptationWizard.this.window.dispose();
            }
        });
        this.buttonPanel.add(this.cancelButton);
        JPanel jPanel = new JPanel(new FlowLayout(0));
        this.helpPanel = new HelpPanel(this);
        this.helpButton = new JButton(HuginGUIConstants.get("str_help"));
        jPanel.add(this.helpButton);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
        jPanel2.add(jPanel);
        jPanel2.add(this.buttonPanel);
        this.dataSources = new DefaultListModel();
        this.createPriorPanel();
        this.windowPanel = new JPanel(new BorderLayout());
        this.windowPanel.add((Component)this.priorPanel, "Center");
        this.windowPanel.add((Component)jPanel2, "South");
        JPanel jPanel3 = new JPanel(new GridLayout(1, 1));
        jPanel3.add(this.windowPanel);
        this.setPreferredSize(new Dimension(450, 600));
        this.window = this;
        this.window.getContentPane().add(jPanel3);
        this.window.pack();
        HuginGUIUtils.centerComponent(Hugin.mainFrame, (Window)this.window);
        this.window.setDefaultCloseOperation(2);
        this.window.addWindowListener(new CloseListener());
        this.window.setVisible(true);
    }

    private void createPriorPanel() {
        Object object2;
        this.priorPanel = new JTabbedPane();
        ActionListener[] actionListenerArray = this.helpButton.getActionListeners();
        for (ActionListener object22 : actionListenerArray) {
            this.helpButton.removeActionListener(object22);
        }
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = AdaptationWizard.this.priorPanel.getSelectedIndex();
                if (n >= 0 && n < AdaptationWizard.this.helpPagesFirst.length) {
                    AdaptationWizard.this.helpPanel.setHelpPage(AdaptationWizard.this.helpPagesFirst[n]);
                    if (!AdaptationWizard.this.helpPanel.isVisible()) {
                        int n2 = AdaptationWizard.this.getX() - AdaptationWizard.this.helpPanel.getWidth();
                        if (n2 < 5 && (n2 = AdaptationWizard.this.getX() + AdaptationWizard.this.getWidth()) + AdaptationWizard.this.helpPanel.getWidth() > Toolkit.getDefaultToolkit().getScreenSize().width - 5) {
                            n2 = 5;
                        }
                        AdaptationWizard.this.helpPanel.setLocation(n2, AdaptationWizard.this.getY());
                        AdaptationWizard.this.helpPanel.setVisible(true);
                    }
                }
            }
        });
        TitledPanel titledPanel = new TitledPanel(HuginGUIConstants.get("ADAPTWIZ_data_panel_title"));
        titledPanel.setLayout(new BorderLayout());
        this.dataSourceView = new JList(this.dataSources);
        this.dataSourceView.setSelectionMode(1);
        this.dataSourceView.setLayoutOrientation(0);
        titledPanel.add((Component)new JLabel(HuginGUIConstants.get("ADAPTWIZ_data_panel_description")), "North");
        titledPanel.add((Component)new JScrollPane(this.dataSourceView), "Center");
        JButton jButton = new JButton(HuginGUIConstants.get("ADAPTWIZ_data_panel_add_data"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser(Hugin.mainFrame.getMostRecentDataFile());
                FileFilter fileFilter = new FileFilter(){

                    public boolean accept(File file) {
                        if (file.isDirectory()) {
                            return true;
                        }
                        String string = "";
                        String string2 = file.getName();
                        int n = string2.lastIndexOf(46);
                        if (n > 0 && n < string2.length() - 1) {
                            string = string2.substring(n).toLowerCase();
                        }
                        return string.equals(".hcs") || string.equals(".dat");
                    }

                    public String getDescription() {
                        return "*.hcs, *.dat";
                    }
                };
                jFileChooser.setAcceptAllFileFilterUsed(false);
                jFileChooser.setFileFilter(fileFilter);
                jFileChooser.setMultiSelectionEnabled(true);
                int n = jFileChooser.showOpenDialog(AdaptationWizard.this.window);
                if (n == 0) {
                    File[] fileArray = jFileChooser.getSelectedFiles();
                    for (int i = 0; i < fileArray.length; ++i) {
                        boolean bl = true;
                        for (int j = 0; j < AdaptationWizard.this.dataSources.getSize(); ++j) {
                            if (!AdaptationWizard.this.dataSources.get(j).equals(fileArray[i].getPath())) continue;
                            bl = false;
                        }
                        if (!bl) continue;
                        AdaptationWizard.this.dataSources.addElement(fileArray[i].getPath());
                    }
                }
            }
        });
        JButton jButton2 = new JButton(HuginGUIConstants.get("ADAPTWIZ_data_panel_remove_data"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = AdaptationWizard.this.dataSourceView.getSelectedIndices();
                for (int i = nArray.length - 1; i >= 0; --i) {
                    AdaptationWizard.this.dataSources.remove(nArray[i]);
                }
            }
        });
        JButton jButton3 = new JButton(HuginGUIConstants.get("ADAPTWIZ_data_panel_clear_data"));
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdaptationWizard.this.dataSources.clear();
            }
        });
        JPanel jPanel = new JPanel(new FlowLayout(2));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        titledPanel.add((Component)jPanel, "South");
        this.priorPanel.addTab(HuginGUIConstants.get("ADAPTWIZ_data_panel_tab_title"), titledPanel);
        this.nodePanel = new TitledPanel(HuginGUIConstants.get("ADAPTWIZ_prior_exp_panel_nodetable_title"));
        this.nodePanel.setLayout(new GridLayout(1, 1));
        this.nodeActionPanel = new JPanel();
        TitledPanel titledPanel2 = new TitledPanel(HuginGUIConstants.get("ADAPTWIZ_prior_exp_panel_title"));
        titledPanel2.setLayout(new BorderLayout());
        NetworkPanel.ListOfNodes listOfNodes = this.networkPanel.nodeList;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Object object2 : listOfNodes) {
            if (!((Node)object2).isDiscreteChance()) continue;
            arrayList.add((Node)object2);
        }
        JComboBox<Object> jComboBox = new JComboBox<Object>(arrayList.toArray());
        jComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    JComponent jComponent;
                    final JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                    AdaptationWizard.this.nodePanel.removeAll();
                    final Node node = (Node)jComboBox.getSelectedItem();
                    final NodeTable nodeTable = new NodeTable(node);
                    if (nodeTable.getExpressionTable() != null) {
                        nodeTable.getExpressionTable().setEnabled(false);
                    }
                    nodeTable.getTable().setEnabled(false);
                    nodeTable.getStateTable().setEnabled(false);
                    nodeTable.getStateTable().setCellSelectionEnabled(false);
                    nodeTable.addStateTableResizedListener(new NodeTableFrame.StateTableResizedListener(){

                        public void stateTableResized() {
                            nodeTable.resizeTable();
                        }
                    });
                    GenericTable genericTable = nodeTable.getCPT();
                    GenericTable genericTable2 = nodeTable.getStateTable();
                    int n = genericTable.getTrueColumnCount();
                    int n2 = NodeTableColumn.PREFERRED_WIDTH * n;
                    ((NodeTableColumnModel)genericTable.getColumnModel()).setAvailableWidth(n2);
                    genericTable.setVisibleColumns(n);
                    MouseListener[] mouseListenerArray = genericTable.getTableHeader().getMouseListeners();
                    for (int i = 0; i < mouseListenerArray.length; ++i) {
                        genericTable.getTableHeader().removeMouseListener(mouseListenerArray[i]);
                    }
                    MouseMotionListener[] mouseMotionListenerArray = genericTable.getTableHeader().getMouseMotionListeners();
                    for (int i = 0; i < mouseMotionListenerArray.length; ++i) {
                        genericTable.getTableHeader().removeMouseMotionListener(mouseMotionListenerArray[i]);
                    }
                    JPanel jPanel = new JPanel(new BorderLayout(0, 0));
                    JPanel jPanel2 = new JPanel();
                    jPanel2.setLayout(new BoxLayout(jPanel2, 1));
                    JPanel jPanel3 = new JPanel(new GridLayout(1, 1));
                    jPanel3.setPreferredSize(new Dimension(genericTable2.getTableHeader().getPreferredSize().width, genericTable.getTableHeader().getPreferredSize().height));
                    jPanel3.add(genericTable2.getTableHeader());
                    jPanel.add((Component)genericTable.getTableHeader(), "North");
                    jPanel2.add(jPanel3);
                    JPanel jPanel4 = new JPanel();
                    jPanel4.setLayout(new BoxLayout(jPanel4, 1));
                    if (nodeTable.getExperienceTable() != null) {
                        jPanel4.add(nodeTable.getExperienceTable());
                        jComponent = new JTable(new ExperienceTableModel((DiscreteChanceNode)node.getAPINode(), false), genericTable2.getColumnModel());
                        jPanel2.add((Component)jComponent, "Center");
                    }
                    if (nodeTable.getFadingTable() != null) {
                        jPanel4.add(nodeTable.getFadingTable());
                        jComponent = new JTable(new FadingTableModel((DiscreteChanceNode)node.getAPINode(), false), genericTable2.getColumnModel());
                        jPanel2.add((Component)jComponent, "South");
                    }
                    jComponent = new JPanel(new GridLayout(1, 1));
                    jComponent.setPreferredSize(new Dimension(10, genericTable.getRowHeight()));
                    jPanel2.add(jComponent);
                    jPanel.add((Component)jPanel4, "Center");
                    JScrollPane jScrollPane = new JScrollPane(jPanel, 21, 30);
                    jScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
                    JPanel jPanel5 = new JPanel(new BorderLayout(0, 0));
                    jPanel5.add((Component)jScrollPane, "Center");
                    jPanel5.add((Component)jPanel2, "West");
                    String string = "<html><b>";
                    if (nodeTable.getExperienceTable() == null) {
                        string = string + HuginGUIConstants.get("ADAPTWIZ_prior_exp_panel_no_exp") + "<br>";
                    }
                    if (nodeTable.getFadingTable() == null) {
                        string = string + HuginGUIConstants.get("ADAPTWIZ_prior_exp_panel_no_fad");
                    }
                    string = string + "</b><html>";
                    jPanel5.add((Component)new JLabel(string), "South");
                    JPanel jPanel6 = new JPanel(new BorderLayout(0, 0));
                    jPanel6.add((Component)jPanel5, "North");
                    AdaptationWizard.this.nodePanel.add(jPanel6);
                    AdaptationWizard.this.nodeActionPanel.removeAll();
                    JButton jButton = new JButton(HuginGUIConstants.get("ADAPTWIZ_prior_exp_panel_add_exp_table"));
                    jButton.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            AdaptationWizard.this.networkPanel.containsUnsavedChanges(true);
                            try {
                                ((DiscreteChanceNode)node.getAPINode()).getExperienceTable();
                                nodeTable.showExperience(true);
                                jComboBox.setSelectedIndex(jComboBox.getSelectedIndex());
                                AdaptationWizard.this.syncClassToDomain(node);
                                if (node.getTable() != null) {
                                    node.getTable().table.updateExperienceAndFading();
                                }
                            }
                            catch (ExceptionHugin exceptionHugin) {
                                new HuginGUIError(exceptionHugin);
                            }
                        }
                    });
                    JButton jButton2 = new JButton(HuginGUIConstants.get("ADAPTWIZ_prior_exp_panel_rem_exp_table"));
                    jButton2.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            AdaptationWizard.this.networkPanel.containsUnsavedChanges(true);
                            try {
                                ((DiscreteChanceNode)node.getAPINode()).getExperienceTable().delete();
                                nodeTable.showExperience(false);
                                jComboBox.setSelectedIndex(jComboBox.getSelectedIndex());
                                AdaptationWizard.this.syncClassToDomain(node);
                                if (node.getTable() != null) {
                                    node.getTable().table.updateExperienceAndFading();
                                }
                            }
                            catch (ExceptionHugin exceptionHugin) {
                                new HuginGUIError(exceptionHugin);
                            }
                        }
                    });
                    JButton jButton3 = new JButton(HuginGUIConstants.get("ADAPTWIZ_prior_exp_panel_add_fad_table"));
                    jButton3.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            AdaptationWizard.this.networkPanel.containsUnsavedChanges(true);
                            try {
                                ((DiscreteChanceNode)node.getAPINode()).getFadingTable();
                                nodeTable.showFading(true);
                                jComboBox.setSelectedIndex(jComboBox.getSelectedIndex());
                                AdaptationWizard.this.syncClassToDomain(node);
                                if (node.getTable() != null) {
                                    node.getTable().table.updateExperienceAndFading();
                                }
                            }
                            catch (ExceptionHugin exceptionHugin) {
                                new HuginGUIError(exceptionHugin);
                            }
                        }
                    });
                    JButton jButton4 = new JButton(HuginGUIConstants.get("ADAPTWIZ_prior_exp_panel_rem_fad_table"));
                    jButton4.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            AdaptationWizard.this.networkPanel.containsUnsavedChanges(true);
                            try {
                                ((DiscreteChanceNode)node.getAPINode()).getFadingTable().delete();
                                nodeTable.showFading(false);
                                jComboBox.setSelectedIndex(jComboBox.getSelectedIndex());
                                AdaptationWizard.this.syncClassToDomain(node);
                                if (node.getTable() != null) {
                                    node.getTable().table.updateExperienceAndFading();
                                }
                            }
                            catch (ExceptionHugin exceptionHugin) {
                                new HuginGUIError(exceptionHugin);
                            }
                        }
                    });
                    DiscreteChanceNode discreteChanceNode = (DiscreteChanceNode)node.getAPINode();
                    if (discreteChanceNode.hasExperienceTable()) {
                        AdaptationWizard.this.nodeActionPanel.add(jButton2);
                    } else {
                        AdaptationWizard.this.nodeActionPanel.add(jButton);
                    }
                    if (discreteChanceNode.hasFadingTable()) {
                        AdaptationWizard.this.nodeActionPanel.add(jButton4);
                    } else {
                        AdaptationWizard.this.nodeActionPanel.add(jButton3);
                    }
                    if (AdaptationWizard.this.window != null) {
                        AdaptationWizard.this.window.repaint();
                    }
                }
                catch (ExceptionHugin exceptionHugin) {
                    new HuginGUIError(exceptionHugin);
                }
            }
        });
        jComboBox.setSelectedIndex(0);
        object2 = new JPanel(new GridLayout(1, 2));
        ((Container)object2).add(new JLabel(HuginGUIConstants.get("ADAPTWIZ_prior_exp_panel_select_node")));
        ((Container)object2).add(jComboBox);
        titledPanel2.add((Component)object2, "North");
        titledPanel2.add((Component)this.nodePanel, "Center");
        titledPanel2.add((Component)this.nodeActionPanel, "South");
        this.priorPanel.addTab(HuginGUIConstants.get("ADAPTWIZ_prior_exp_panel_tab_title"), titledPanel2);
        this.nextButton.setEnabled(true);
        this.nextAction = new CallBack(){

            public void call() {
                if (AdaptationWizard.this.adaptWiz.createBeginPanel()) {
                    AdaptationWizard.this.windowPanel.remove(AdaptationWizard.this.priorPanel);
                    AdaptationWizard.this.windowPanel.add((Component)AdaptationWizard.this.beginPanel, "Center");
                }
                AdaptationWizard.this.window.validate();
            }
        };
        this.backButton.setEnabled(false);
    }

    private boolean createBeginPanel() {
        ActionListener[] actionListenerArray = this.helpButton.getActionListeners();
        for (ActionListener object2 : actionListenerArray) {
            this.helpButton.removeActionListener(object2);
        }
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdaptationWizard.this.helpPanel.setHelpPage(AdaptationWizard.this.helpPageConf);
                if (!AdaptationWizard.this.helpPanel.isVisible()) {
                    int n = AdaptationWizard.this.getX() - AdaptationWizard.this.helpPanel.getWidth();
                    if (n < 5 && (n = AdaptationWizard.this.getX() + AdaptationWizard.this.getWidth()) + AdaptationWizard.this.helpPanel.getWidth() > Toolkit.getDefaultToolkit().getScreenSize().width - 5) {
                        n = 5;
                    }
                    AdaptationWizard.this.helpPanel.setLocation(n, AdaptationWizard.this.getY());
                    AdaptationWizard.this.helpPanel.setVisible(true);
                }
            }
        });
        this.beginPanel = new TitledPanel(HuginGUIConstants.get("ADAPTWIZ_begin_panel_title"));
        this.beginPanel.setLayout(new GridLayout(1, 2));
        this.dcNodes = new Vector();
        this.dcNodesNoExp = new Vector();
        NetworkPanel.ListOfNodes listOfNodes = this.networkPanel.nodeList;
        Object object3 = listOfNodes.iterator();
        while (object3.hasNext()) {
            Node node = (Node)object3.next();
            if (!node.isDiscreteChance()) continue;
            this.syncClassToDomain(node);
            if (node.hasExperienceTable()) {
                this.dcNodes.add(node);
                continue;
            }
            this.dcNodesNoExp.add(node);
        }
        object3 = new JList<Node>(this.dcNodes);
        ((JList)object3).setLayoutOrientation(0);
        ((JList)object3).addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ((JList)listSelectionEvent.getSource()).clearSelection();
                ((JList)listSelectionEvent.getSource()).transferFocusBackward();
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(new JLabel(HuginGUIConstants.get("ADAPTWIZ_begin_panel_nodes")));
        jPanel.add(new JScrollPane((Component)object3));
        this.data = this.initializeCases();
        if (this.data == null) {
            return false;
        }
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.add(new JLabel(HuginGUIConstants.get("ADAPTWIZ_begin_panel_number_cases") + this.data.size()));
        jPanel2.add(new JLabel(" "));
        jPanel2.add(new JLabel(HuginGUIConstants.get("ADAPTWIZ_begin_panel_rec_opt")));
        JCheckBox jCheckBox = new JCheckBox(HuginGUIConstants.get("ADAPTWIZ_begin_panel_exp"), this.recordExperienceCounts);
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdaptationWizard.this.recordExperienceCounts = !AdaptationWizard.this.recordExperienceCounts;
            }
        });
        jPanel2.add(jCheckBox);
        JCheckBox jCheckBox2 = new JCheckBox(HuginGUIConstants.get("ADAPTWIZ_begin_panel_post_marg"), this.recordPosteriorMarginals);
        jCheckBox2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdaptationWizard.this.recordPosteriorMarginals = !AdaptationWizard.this.recordPosteriorMarginals;
            }
        });
        jPanel2.add(jCheckBox2);
        this.beginPanel.add(jPanel2);
        this.beginPanel.add(jPanel);
        this.nextButton.setEnabled(this.dcNodes.size() > 0 && this.data.size() > 0);
        this.nextAction = new CallBack(){

            public void call() {
                AdaptationWizard.this.adaptWiz.createAdaptPanel();
                AdaptationWizard.this.windowPanel.remove(AdaptationWizard.this.beginPanel);
                AdaptationWizard.this.windowPanel.add((Component)AdaptationWizard.this.adaptPanel, "Center");
                AdaptationWizard.this.window.validate();
            }
        };
        this.backButton.setEnabled(true);
        this.backAction = new CallBack(){

            public void call() {
                AdaptationWizard.this.windowPanel.remove(AdaptationWizard.this.beginPanel);
                AdaptationWizard.this.adaptWiz.createPriorPanel();
                AdaptationWizard.this.createPriorPanel();
                AdaptationWizard.this.windowPanel.add((Component)AdaptationWizard.this.priorPanel, "Center");
                AdaptationWizard.this.window.validate();
            }
        };
        return true;
    }

    private void createAdaptPanel() {
        JComponent jComponent;
        JComponent jComponent2;
        this.adaptPanel = new JPanel(new GridLayout(1, 1));
        JPanel jPanel = new JPanel(new BorderLayout());
        this.adaptPanel.add(jPanel);
        ActionListener[] actionListenerArray = this.helpButton.getActionListeners();
        for (ActionListener object2 : actionListenerArray) {
            this.helpButton.removeActionListener(object2);
        }
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdaptationWizard.this.helpPanel.setHelpPage(AdaptationWizard.this.helpPageLast);
                if (!AdaptationWizard.this.helpPanel.isVisible()) {
                    int n = AdaptationWizard.this.getX() - AdaptationWizard.this.helpPanel.getWidth();
                    if (n < 5 && (n = AdaptationWizard.this.getX() + AdaptationWizard.this.getWidth()) + AdaptationWizard.this.helpPanel.getWidth() > Toolkit.getDefaultToolkit().getScreenSize().width - 5) {
                        n = 5;
                    }
                    AdaptationWizard.this.helpPanel.setLocation(n, AdaptationWizard.this.getY());
                    AdaptationWizard.this.helpPanel.setVisible(true);
                }
            }
        });
        try {
            if (this.recordPosteriorMarginals) {
                this.posteriorMarginals = new ArrayList();
                for (Node node : this.dcNodes) {
                    this.posteriorMarginals.add(new PosteriorMarginals(node, (DiscreteChanceNode)this.projectFrame.beliefBars.getDomainNodeFor(node.getAPINode())));
                }
                for (Node node : this.dcNodesNoExp) {
                    this.posteriorMarginals.add(new PosteriorMarginals(node, (DiscreteChanceNode)this.projectFrame.beliefBars.getDomainNodeFor(node.getAPINode())));
                }
            }
            if (this.recordExperienceCounts) {
                this.experienceCounts = new ArrayList();
                for (Node node : this.dcNodes) {
                    this.experienceCounts.add(new ExperienceCounts(node, (DiscreteChanceNode)this.projectFrame.beliefBars.getDomainNodeFor(node.getAPINode())));
                }
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
            this.window.setEnabled(false);
        }
        this.nextButton.setEnabled(false);
        this.nextButton.setText(HuginGUIConstants.get("ADAPTWIZ_adapt_panel_done"));
        this.nextAction = new CallBack(){

            public void call() {
                AdaptationWizard.this.window.dispose();
            }
        };
        this.backButton.setEnabled(false);
        this.backAction = null;
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        this.processingStatus = new JLabel(HuginGUIConstants.get("ADAPTWIZ_adapt_panel_processed") + "0 / " + this.data.size() + HuginGUIConstants.get("ADAPTWIZ_adapt_panel_cases"));
        jPanel2.add(this.processingStatus);
        this.adaptationBreak = new JButton(HuginGUIConstants.get("ADAPTWIZ_adapt_panel_break"));
        this.adaptationBreak.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdaptationWizard.this.adaptationRun.setEnabled(true);
                AdaptationWizard.this.adaptationBreak.setEnabled(false);
                AdaptationWizard.this.adaptationTimer.stop();
                try {
                    while (AdaptationWizard.this.performingAdaptation) {
                        Thread.sleep(500L);
                    }
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
                AdaptationWizard.this.window.validate();
            }
        });
        this.adaptationBreak.setEnabled(false);
        jPanel2.add(this.adaptationBreak);
        this.adaptationRun = new JButton(HuginGUIConstants.get("ADAPTWIZ_adapt_panel_run"));
        this.adaptationRun.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdaptationWizard.this.adaptationRun.setEnabled(false);
                AdaptationWizard.this.adaptationBreak.setEnabled(true);
                AdaptationWizard.this.adaptationTimer.start();
                AdaptationWizard.this.window.validate();
            }
        });
        this.adaptationRun.setEnabled(true);
        jPanel2.add(this.adaptationRun);
        jPanel.add((Component)jPanel2, "South");
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                block17: {
                    AdaptationWizard.this.performingAdaptation = true;
                    try {
                        if (AdaptationWizard.this.adaptationTimer.isRunning()) {
                            if (AdaptationWizard.this.nextCase < AdaptationWizard.this.adaptWiz.data.size()) {
                                Data data = (Data)AdaptationWizard.this.adaptWiz.data.get(AdaptationWizard.this.nextCase++);
                                try {
                                    data.enterData();
                                    try {
                                        HuginGUIUtils.configureDomain(AdaptationWizard.this.domain);
                                        AdaptationWizard.this.domain.propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
                                        AdaptationWizard.this.domain.adapt();
                                    }
                                    catch (ExceptionInconsistencyOrUnderflow exceptionInconsistencyOrUnderflow) {
                                        AdaptationWizard.this.inconsistency = true;
                                    }
                                    catch (ExceptionInvalidEvidence exceptionInvalidEvidence) {
                                        AdaptationWizard.this.freeWill = true;
                                    }
                                    AdaptationWizard.this.domain.retractFindings();
                                    AdaptationWizard.this.domain.propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
                                    ((AdaptationWizard)AdaptationWizard.this).projectFrame.beliefBars.setTablesChanged(true);
                                    AdaptationWizard.this.networkPanel.containsUnsavedChanges(true);
                                    if (AdaptationWizard.this.posteriorMarginals != null) {
                                        for (Recording recording : AdaptationWizard.this.posteriorMarginals) {
                                            ((PosteriorMarginals)recording).record();
                                        }
                                        if (AdaptationWizard.this.postGraph.isShowing()) {
                                            AdaptationWizard.this.postGraph.incrementalPaint(AdaptationWizard.this.nextCase - 1);
                                        }
                                    }
                                    if (AdaptationWizard.this.experienceCounts != null) {
                                        for (Recording recording : AdaptationWizard.this.experienceCounts) {
                                            ((ExperienceCounts)recording).record();
                                        }
                                        if (AdaptationWizard.this.expGraph.isShowing()) {
                                            AdaptationWizard.this.expGraph.incrementalPaint(AdaptationWizard.this.nextCase - 1);
                                        }
                                    }
                                }
                                catch (ExceptionParse exceptionParse) {
                                    // empty catch block
                                }
                                AdaptationWizard.this.processingStatus.setText(HuginGUIConstants.get("ADAPTWIZ_adapt_panel_processed") + AdaptationWizard.this.nextCase + " / " + AdaptationWizard.this.data.size() + HuginGUIConstants.get("ADAPTWIZ_adapt_panel_cases"));
                                break block17;
                            }
                            AdaptationWizard.this.adaptationBreak.setEnabled(false);
                            AdaptationWizard.this.adaptationRun.setEnabled(false);
                            AdaptationWizard.this.nextButton.setEnabled(true);
                            AdaptationWizard.this.cancelButton.setEnabled(false);
                            AdaptationWizard.this.window.repaint();
                            AdaptationWizard.this.adaptationTimer.stop();
                            if (AdaptationWizard.this.inconsistency) {
                                JOptionPane.showMessageDialog(AdaptationWizard.this.window, HuginGUIConstants.get("adapt_inconsistent"), HuginGUIConstants.get("str_alert"), 1);
                            }
                            if (AdaptationWizard.this.freeWill) {
                                JOptionPane.showMessageDialog(AdaptationWizard.this.window, HuginGUIConstants.get("adapt_freewill"), HuginGUIConstants.get("str_alert"), 1);
                            }
                            break block17;
                        }
                        AdaptationWizard.this.adaptationTimer.stop();
                        AdaptationWizard.this.window.repaint();
                    }
                    catch (Exception exception) {
                        new HuginGUIError(exception);
                        AdaptationWizard.this.adaptationTimer.stop();
                    }
                }
                AdaptationWizard.this.performingAdaptation = false;
            }
        };
        this.adaptationTimer = new Timer(0, abstractAction);
        TitledPanel titledPanel = new TitledPanel(HuginGUIConstants.get("ADAPTWIZ_adapt_panel_title"));
        titledPanel.setLayout(new GridLayout(1, 1));
        this.expGraphPanel = new JPanel(new GridLayout(1, 1));
        this.expGraphPanel.setMinimumSize(new Dimension(0, 0));
        this.expConfPanel = new JPanel(new BorderLayout(0, 0));
        this.expConfPanel.setMinimumSize(new Dimension(0, 0));
        JSplitPane jSplitPane = new JSplitPane(0, this.expGraphPanel, this.expConfPanel);
        jSplitPane.setDividerLocation(250);
        titledPanel.add(jSplitPane);
        if (this.recordExperienceCounts) {
            jComponent2 = new JComboBox<Object>(this.experienceCounts.toArray());
            ((JComboBox)jComponent2).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                        Recording recording = (Recording)jComboBox.getSelectedItem();
                        Node node = recording.getGUINode();
                        AdaptationWizard.this.expConfPanel.removeAll();
                        JPanel jPanel = new JPanel(new GridLayout(1, 2));
                        jPanel.add(new JLabel(HuginGUIConstants.get("ADAPTWIZ_adapt_panel_exp_conf_plot_for")));
                        jPanel.add(jComboBox);
                        int n = ((DiscreteChanceNode)node.getAPINode()).getExperienceTable().getSize();
                        SelectionsModel selectionsModel = new SelectionsModel(n, 2);
                        JTable jTable = new JTable(selectionsModel);
                        jTable.addMouseListener(new MouseAdapter(){

                            public void mouseClicked(MouseEvent mouseEvent) {
                                AdaptationWizard.this.window.validate();
                                AdaptationWizard.this.window.repaint();
                            }
                        });
                        ColorBoolRenderer colorBoolRenderer = new ColorBoolRenderer(jTable.getDefaultRenderer(Boolean.class), selectionsModel);
                        jTable.setDefaultRenderer(Boolean.class, colorBoolRenderer);
                        AdaptationWizard.this.expConfPanel.add((Component)jPanel, "North");
                        AdaptationWizard.this.expConfPanel.add((Component)AdaptationWizard.this.getConfigurationSelector(node, jTable), "Center");
                        AdaptationWizard.this.expGraphPanel.removeAll();
                        AdaptationWizard.this.expGraph = new Graph(recording, selectionsModel, AdaptationWizard.this.data.size(), 100.0);
                        AdaptationWizard.this.expGraphPanel.add(AdaptationWizard.this.expGraph);
                        AdaptationWizard.this.expConfPanel.validate();
                        AdaptationWizard.this.window.validate();
                        AdaptationWizard.this.window.repaint();
                    }
                    catch (ExceptionHugin exceptionHugin) {
                        new HuginGUIError(exceptionHugin);
                    }
                }
            });
            ((JComboBox)jComponent2).setSelectedIndex(0);
        }
        jComponent2 = new TitledPanel(HuginGUIConstants.get("ADAPTWIZ_adapt_panel_title"));
        jComponent2.setLayout(new GridLayout(1, 1));
        this.postGraphPanel = new JPanel(new GridLayout(1, 1));
        this.postGraphPanel.setMinimumSize(new Dimension(0, 0));
        this.postConfPanel = new JPanel(new BorderLayout(0, 0));
        this.postConfPanel.setMinimumSize(new Dimension(0, 0));
        JSplitPane jSplitPane2 = new JSplitPane(0, this.postGraphPanel, this.postConfPanel);
        jSplitPane2.setDividerLocation(250);
        jComponent2.add(jSplitPane2);
        if (this.recordPosteriorMarginals) {
            jComponent = new JComboBox<Object>(this.posteriorMarginals.toArray());
            ((JComboBox)jComponent).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                        Recording recording = (Recording)jComboBox.getSelectedItem();
                        Node node = recording.getGUINode();
                        AdaptationWizard.this.postConfPanel.removeAll();
                        JPanel jPanel = new JPanel(new GridLayout(1, 2));
                        jPanel.add(new JLabel(HuginGUIConstants.get("ADAPTWIZ_adapt_panel_post_conf_plot_for")));
                        jPanel.add(jComboBox);
                        AdaptationWizard.this.postConfPanel.add((Component)jPanel, "North");
                        NodeTable nodeTable = new NodeTable(node);
                        GenericTable genericTable = nodeTable.getStateTable();
                        genericTable.setCellEditor(null);
                        genericTable.setDefaultEditor(Object.class, null);
                        genericTable.setDefaultEditor(String.class, null);
                        genericTable.setCellSelectionEnabled(false);
                        genericTable.setColumnSelectionAllowed(false);
                        genericTable.setRowSelectionAllowed(false);
                        JPanel jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
                        jPanel2.add(genericTable);
                        SelectionsModel selectionsModel = new SelectionsModel(((DiscreteNode)node.getAPINode()).getNumberOfStates(), 1);
                        JTable jTable = new JTable(selectionsModel);
                        jTable.setCellSelectionEnabled(false);
                        jTable.setColumnSelectionAllowed(false);
                        jTable.setRowSelectionAllowed(false);
                        jTable.addMouseListener(new MouseAdapter(){

                            public void mouseClicked(MouseEvent mouseEvent) {
                                AdaptationWizard.this.window.validate();
                                AdaptationWizard.this.window.repaint();
                            }
                        });
                        ColorBoolRenderer colorBoolRenderer = new ColorBoolRenderer(jTable.getDefaultRenderer(Boolean.class), selectionsModel);
                        jTable.setDefaultRenderer(Boolean.class, colorBoolRenderer);
                        jPanel2.add(jTable);
                        JScrollPane jScrollPane = new JScrollPane(jPanel2, 20, 31);
                        jScrollPane.setViewportBorder(BorderFactory.createEtchedBorder());
                        AdaptationWizard.this.postConfPanel.add((Component)jScrollPane, "Center");
                        AdaptationWizard.this.postGraphPanel.removeAll();
                        AdaptationWizard.this.postGraph = new Graph(recording, selectionsModel, AdaptationWizard.this.data.size(), 1.0);
                        AdaptationWizard.this.postGraphPanel.add(AdaptationWizard.this.postGraph);
                        AdaptationWizard.this.postConfPanel.validate();
                        AdaptationWizard.this.window.validate();
                        AdaptationWizard.this.window.repaint();
                    }
                    catch (ExceptionHugin exceptionHugin) {
                        new HuginGUIError(exceptionHugin);
                    }
                }
            });
            ((JComboBox)jComponent).setSelectedIndex(0);
        }
        jComponent = new JTabbedPane();
        if (this.recordExperienceCounts) {
            ((JTabbedPane)jComponent).add(HuginGUIConstants.get("ADAPTWIZ_adapt_exp_title"), titledPanel);
        }
        if (this.recordPosteriorMarginals) {
            ((JTabbedPane)jComponent).add(HuginGUIConstants.get("ADAPTWIZ_adapt_post_title"), jComponent2);
        }
        jPanel.add(jComponent);
    }

    private JPanel getConfigurationSelector(Node node, JTable jTable) {
        try {
            NodeTable nodeTable = new NodeTable(node);
            GenericTable genericTable = nodeTable.getCPT();
            GenericTable genericTable2 = nodeTable.getStateTable();
            int n = genericTable.getTrueColumnCount();
            int n2 = NodeTableColumn.PREFERRED_WIDTH * n;
            ((NodeTableColumnModel)genericTable.getColumnModel()).setAvailableWidth(n2);
            genericTable.setVisibleColumns(n);
            MouseListener[] mouseListenerArray = genericTable.getTableHeader().getMouseListeners();
            for (int i = 0; i < mouseListenerArray.length; ++i) {
                genericTable.getTableHeader().removeMouseListener(mouseListenerArray[i]);
            }
            MouseMotionListener[] mouseMotionListenerArray = genericTable.getTableHeader().getMouseMotionListeners();
            for (int i = 0; i < mouseMotionListenerArray.length; ++i) {
                genericTable.getTableHeader().removeMouseMotionListener(mouseMotionListenerArray[i]);
            }
            JPanel jPanel = new JPanel(new BorderLayout(0, 0));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 1));
            JPanel jPanel3 = new JPanel(new GridLayout(1, 1));
            jPanel3.setPreferredSize(new Dimension(genericTable2.getTableHeader().getPreferredSize().width, genericTable.getTableHeader().getPreferredSize().height));
            jPanel3.add(genericTable2.getTableHeader());
            jPanel.add((Component)genericTable.getTableHeader(), "North");
            jPanel2.add(jPanel3);
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new BoxLayout(jPanel4, 1));
            jTable.setAutoResizeMode(0);
            jTable.setPreferredSize(new Dimension(genericTable.getPreferredSize().width, jTable.getRowHeight()));
            jTable.setMaximumSize(jTable.getPreferredSize());
            jTable.setAlignmentX(0.0f);
            jTable.setCellSelectionEnabled(false);
            jTable.setColumnSelectionAllowed(false);
            jTable.setRowSelectionAllowed(false);
            jPanel4.add(jTable);
            jPanel.add((Component)jPanel4, "Center");
            JTable jTable2 = new JTable(new ExperienceTableModel((DiscreteChanceNode)node.getAPINode(), false), genericTable2.getColumnModel());
            jPanel2.add((Component)jTable2, "Center");
            JPanel jPanel5 = new JPanel(new GridLayout(1, 1));
            jPanel5.setPreferredSize(new Dimension(10, genericTable.getRowHeight()));
            jPanel2.add(jPanel5);
            JScrollPane jScrollPane = new JScrollPane(jPanel, 21, 30);
            jScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
            JPanel jPanel6 = new JPanel(new BorderLayout(0, 0));
            jPanel6.add((Component)jScrollPane, "Center");
            jPanel6.add((Component)jPanel2, "West");
            JPanel jPanel7 = new JPanel(new BorderLayout(0, 0));
            jPanel7.add((Component)jPanel6, "North");
            return jPanel7;
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
            return null;
        }
    }

    private void syncClassToDomain(Node node) {
        try {
            if (node.isDiscreteChance()) {
                DiscreteChanceNode discreteChanceNode = (DiscreteChanceNode)node.getAPINode();
                DiscreteChanceNode discreteChanceNode2 = (DiscreteChanceNode)this.projectFrame.beliefBars.getDomainNodeFor(discreteChanceNode);
                if (discreteChanceNode.hasExperienceTable()) {
                    discreteChanceNode2.getExperienceTable().update(discreteChanceNode.getExperienceTable());
                } else {
                    discreteChanceNode2.getExperienceTable().delete();
                }
                if (discreteChanceNode.hasFadingTable()) {
                    discreteChanceNode2.getFadingTable().update(discreteChanceNode.getFadingTable());
                } else {
                    discreteChanceNode2.getFadingTable().delete();
                }
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
            this.window.setEnabled(false);
        }
    }

    private LinkedList<Data> initializeCases() {
        LinkedList<Data> linkedList = new LinkedList<Data>();
        boolean bl = false;
        try {
            this.domain.setNumberOfCases(0);
            for (int i = 0; i < this.dataSources.size(); ++i) {
                final String string = (String)this.dataSources.getElementAt(i);
                if (string.toLowerCase().endsWith(".hcs")) {
                    linkedList.add(new Data(string));
                    continue;
                }
                if (!string.toLowerCase().endsWith(".dat")) continue;
                int n = this.domain.getNumberOfCases();
                try {
                    this.domain.parseCases(string, new ParseListener(){

                        public void parseError(int n, String string2) {
                            new HuginGUIError(HuginGUIConstants.get("str_ARG0_lb_ARG1_in_line_ARG3", new String[]{string, string2, "" + n}));
                        }
                    });
                }
                catch (ExceptionHugin exceptionHugin) {
                    bl = true;
                }
                int n2 = this.domain.getNumberOfCases() - 1;
                for (int j = n; j <= n2; ++j) {
                    linkedList.add(new Data(j));
                }
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            return null;
        }
        if (bl) {
            return null;
        }
        return linkedList;
    }

    private class CloseListener
    implements WindowListener {
        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
            if (AdaptationWizard.this.adaptationTimer != null) {
                try {
                    while (AdaptationWizard.this.performingAdaptation || AdaptationWizard.this.adaptationTimer.isRunning()) {
                        AdaptationWizard.this.adaptationTimer.stop();
                        Thread.sleep(500L);
                    }
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
            }
            try {
                ((AdaptationWizard)AdaptationWizard.this).projectFrame.beliefBars.transferTablesToClass();
                AdaptationWizard.this.domain.retractFindings();
                AdaptationWizard.this.caseBank.enterCase(0);
                AdaptationWizard.this.domain.setNumberOfCases(0);
                AdaptationWizard.this.caseBank.copyCasesToDomain(1, AdaptationWizard.this.caseBank.getNumberOfCases() - 1);
                ((AdaptationWizard)AdaptationWizard.this).projectFrame.getBeliefBarPanel().tree.paintInconcistent = true;
                AdaptationWizard.this.projectFrame.getBeliefBarPanel().propagateIfNecessary();
                Hugin.mainFrame.repaint();
            }
            catch (ExceptionHugin exceptionHugin) {
                new HuginGUIError(exceptionHugin);
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }
    }

    private static interface CallBack {
        public void call();
    }

    private class PosteriorMarginals
    extends Recording {
        public PosteriorMarginals(Node node, DiscreteChanceNode discreteChanceNode) throws ExceptionHugin {
            super(node, discreteChanceNode, 2);
        }

        public int record() throws ExceptionHugin {
            double[] dArray = new double[this.tableSize];
            for (int i = 0; i < this.tableSize; ++i) {
                dArray[i] = this.node.getBelief(i);
            }
            this.tableRecordings.add(dArray);
            return this.tableRecordings.size() - 1;
        }
    }

    private class ExperienceCounts
    extends Recording {
        public ExperienceCounts(Node node, DiscreteChanceNode discreteChanceNode) throws ExceptionHugin {
            super(node, discreteChanceNode, 1);
        }

        public int record() throws ExceptionHugin {
            Table table = this.node.getExperienceTable();
            this.tableRecordings.add(table.getData());
            return this.tableRecordings.size() - 1;
        }
    }

    private abstract class Recording {
        public static final int EXPERIENCE_COUNTS = 1;
        public static final int POSTERIOR_MARGINALS = 2;
        protected DiscreteChanceNode node = null;
        protected int tableSize = -1;
        protected ArrayList<double[]> tableRecordings = null;
        protected Node guiNode;

        private Recording(Node node, DiscreteChanceNode discreteChanceNode, int n) throws ExceptionHugin {
            this.guiNode = node;
            this.tableRecordings = new ArrayList();
            this.node = discreteChanceNode;
            if (n == 1) {
                this.tableSize = this.node.getTable().getSize();
            } else if (n == 2) {
                this.tableSize = this.node.getNumberOfStates();
            }
        }

        public double getResult(int n, int n2) {
            double[] dArray = this.tableRecordings.get(n);
            return dArray[n2];
        }

        public DiscreteChanceNode getAPINode() {
            return this.node;
        }

        public Node getGUINode() {
            return this.guiNode;
        }

        public int getSize() {
            return this.tableRecordings.size();
        }

        public String toString() {
            return this.guiNode.toString();
        }

        public abstract int record() throws ExceptionHugin;
    }

    private class Data {
        public static final int CASE_FILE = 1;
        public static final int DATA_FILE = 2;
        private int caseNumber = -1;
        private int dataType = -1;
        private String fileName = null;

        public Data(String string) {
            this.dataType = 1;
            this.fileName = string;
        }

        public Data(int n) {
            this.dataType = 2;
            this.caseNumber = n;
        }

        public void enterData() throws ExceptionHugin {
            if (this.dataType == 1) {
                AdaptationWizard.this.domain.parseCase(this.fileName, new ParseListener(){

                    public void parseError(int n, String string) {
                        new HuginGUIError(HuginGUIConstants.get("str_ARG0_lb_ARG1_in_line_ARG3", new String[]{Data.this.fileName, string, "" + n}));
                    }
                });
            } else if (this.dataType == 2) {
                AdaptationWizard.this.domain.enterCase(this.caseNumber);
            }
        }
    }

    private class SelectionsModel
    extends AbstractTableModel {
        boolean[] values;
        Color[] colors = new Color[]{Color.DARK_GRAY, Color.BLUE, Color.CYAN, Color.GREEN, Color.MAGENTA, Color.ORANGE, Color.PINK, Color.RED, Color.YELLOW};
        public static final int ROWS = 1;
        public static final int COLUMNS = 2;
        private int rowsOrColumns = 0;

        public SelectionsModel(int n, int n2) {
            this.rowsOrColumns = n2;
            this.values = new boolean[n];
            this.values[0] = true;
        }

        public int getColumnCount() {
            if (this.rowsOrColumns == 2) {
                return this.values.length;
            }
            return 1;
        }

        public int getRowCount() {
            if (this.rowsOrColumns == 2) {
                return 1;
            }
            return this.values.length;
        }

        public Color getColorAt(int n, int n2) {
            if (this.rowsOrColumns == 2) {
                return this.colors[n2 % this.colors.length];
            }
            return this.colors[n % this.colors.length];
        }

        public Object getValueAt(int n, int n2) {
            if (this.rowsOrColumns == 2) {
                return new Boolean(this.values[n2]);
            }
            return new Boolean(this.values[n]);
        }

        public void setValueAt(Object object, int n, int n2) {
            if (this.rowsOrColumns == 2) {
                this.values[n2] = (Boolean)object;
            } else {
                this.values[n] = (Boolean)object;
            }
            AdaptationWizard.this.expGraphPanel.validate();
            AdaptationWizard.this.postGraphPanel.validate();
        }

        public Class getColumnClass(int n) {
            return Boolean.class;
        }

        public boolean isCellEditable(int n, int n2) {
            return true;
        }
    }

    private class Graph
    extends JPanel {
        private Recording recording;
        private double maxValue;
        double oldMaxValue;
        private int numberOfCases;
        private static final int INTERNAL_HEIGHT = 1200;
        private static final int GRAPH_HEIGHT = 1000;
        private int extraWidth;
        private static final int yOffset = 50;
        private int xOffset;
        private double xScale;
        private double yScale;
        private double xScaleInverse;
        private double yScaleInverse;
        private SelectionsModel whatToPaint;
        private float strokeWidth;

        public Graph(Recording recording, SelectionsModel selectionsModel, int n, double d) {
            this.oldMaxValue = this.maxValue = 0.0;
            this.numberOfCases = 0;
            this.extraWidth = 0;
            this.xOffset = 0;
            this.recording = recording;
            this.whatToPaint = selectionsModel;
            this.numberOfCases = Math.max(10, n);
            this.xOffset = (int)((double)this.numberOfCases / 1000.0 * 150.0);
            this.extraWidth = (int)((double)this.numberOfCases / 1000.0 * 200.0);
            if (this.numberOfCases <= 15) {
                this.xOffset = 2;
                this.extraWidth = 3;
            }
            this.maxValue = d;
            this.setBackground(Color.WHITE);
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            Stroke stroke = graphics2D.getStroke();
            this.xScale = (double)this.getWidth() / (double)(this.numberOfCases + this.extraWidth);
            this.yScale = (double)this.getHeight() / 1200.0;
            this.xScaleInverse = (double)(this.numberOfCases + this.extraWidth) / (double)this.getWidth();
            this.yScaleInverse = 1200.0 / (double)this.getHeight();
            graphics2D.scale(this.xScale, this.yScale);
            this.strokeWidth = (float)Math.min(((double)this.numberOfCases + (double)this.extraWidth) / 1200.0, 1200.0 / ((double)this.numberOfCases + (double)this.extraWidth));
            graphics2D.setStroke(new BasicStroke(this.strokeWidth));
            this.oldMaxValue = this.maxValue;
            this.paintAxes(graphics2D);
            for (int i = 0; i < this.whatToPaint.values.length; ++i) {
                if (!this.whatToPaint.values[i]) continue;
                this.plotAllResults(graphics2D, i, this.whatToPaint.getColorAt(i, i));
            }
            graphics2D.scale(this.xScaleInverse, this.yScaleInverse);
            graphics2D.setStroke(stroke);
            if (this.maxValue != this.oldMaxValue) {
                this.paint(graphics);
            }
        }

        public void incrementalPaint(int n) {
            Graphics2D graphics2D = (Graphics2D)this.getGraphics();
            Stroke stroke = graphics2D.getStroke();
            graphics2D.scale(this.xScale, this.yScale);
            graphics2D.setStroke(new BasicStroke(this.strokeWidth));
            this.oldMaxValue = this.maxValue;
            for (int i = 0; i < this.whatToPaint.values.length; ++i) {
                if (!this.whatToPaint.values[i]) continue;
                this.plotResult(graphics2D, n, i, this.whatToPaint.getColorAt(i, i));
            }
            graphics2D.scale(this.xScaleInverse, this.yScaleInverse);
            graphics2D.setStroke(stroke);
            if (this.maxValue != this.oldMaxValue) {
                this.paint(graphics2D);
            }
        }

        private void paintAxes(Graphics2D graphics2D) {
            int n;
            graphics2D.drawLine(this.xOffset, 1050, this.numberOfCases + this.xOffset, 1050);
            int n2 = this.numberOfCases / 10;
            n2 = n2 <= 2 ? 1 : (n2 <= 10 ? 10 : (n2 <= 100 ? (n2 -= n2 % 10) : (n2 <= 1000 ? (n2 -= n2 % 100) : (n2 <= 10000 ? (n2 -= n2 % 1000) : (n2 <= 100000 ? (n2 -= n2 % 10000) : 1000000)))));
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            Font font = graphics2D.getFont();
            Font font2 = new Font("Courier", 1, 10);
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.scale(this.xScaleInverse, this.yScaleInverse);
            affineTransform.rotate(0.5235987755982988);
            graphics2D.setFont(font2.deriveFont(affineTransform));
            for (n = 0; n < this.numberOfCases; n += n2) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
                graphics2D.drawLine(this.xOffset + n, 1045, this.xOffset + n, 1055);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                if (n2 >= 10) {
                    graphics2D.drawString("" + (n == 0 ? 1 : n), this.xOffset + n, 1100);
                    continue;
                }
                graphics2D.drawString("" + (n + 1), this.xOffset + n, 1100);
            }
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
            affineTransform = new AffineTransform();
            affineTransform.scale(this.xScaleInverse, this.yScaleInverse);
            affineTransform.translate(-50.0, 0.0);
            graphics2D.setFont(font2.deriveFont(affineTransform));
            for (n = 0; n < 11; ++n) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
                graphics2D.drawLine(this.xOffset - this.xOffset / 20, 1000 - n * 100 + 50, this.xOffset + this.xOffset / 20, 1000 - n * 100 + 50);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                String string = "             " + HuginGUIUtils.printDouble(this.maxValue / 10.0 * (double)n, 1);
                string = string.substring(string.length() - 6);
                graphics2D.drawString(string, this.xOffset, 1000 - n * 100 + 50 + 5);
            }
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
            graphics2D.setFont(font);
        }

        private void plotAllResults(Graphics2D graphics2D, int n, Color color) {
            if (this.recording.getSize() == 0) {
                return;
            }
            int[] nArray = new int[this.recording.getSize() + 1];
            int[] nArray2 = new int[this.recording.getSize() + 1];
            for (int i = 0; i < this.recording.getSize(); ++i) {
                nArray[i + 1] = i + this.xOffset;
                double d = this.recording.getResult(i, n);
                this.setNewMaxValue(d);
                nArray2[i + 1] = 1050 - (int)(d * 1000.0 / this.oldMaxValue);
            }
            if (this.recording.getSize() == 1) {
                nArray[0] = nArray[1] + 1;
                nArray2[0] = nArray2[1];
            } else {
                nArray[0] = nArray[1];
                nArray2[0] = nArray2[1];
            }
            graphics2D.setColor(color);
            graphics2D.drawPolyline(nArray, nArray2, nArray.length);
        }

        private void plotResult(Graphics graphics, int n, int n2, Color color) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            int[] nArray = new int[2];
            int[] nArray2 = new int[2];
            nArray[0] = n + this.xOffset;
            double d = this.recording.getResult(n, n2);
            this.setNewMaxValue(d);
            nArray2[0] = 1050 - (int)(d * 1000.0 / this.oldMaxValue);
            nArray[1] = nArray[0];
            nArray2[1] = nArray2[0];
            graphics2D.setColor(color);
            graphics2D.drawPolyline(nArray, nArray2, nArray.length);
        }

        private void setNewMaxValue(double d) {
            if (d < this.maxValue) {
                return;
            }
            this.maxValue = d;
            if (this.maxValue <= 1.0) {
                this.maxValue = 1.0;
            } else if (this.maxValue <= 10.0) {
                this.maxValue = 10.0;
            } else if (this.maxValue <= 100.0) {
                this.maxValue = Math.abs(this.maxValue + 10.0 - this.maxValue % 10.0);
            } else if (this.maxValue <= 1000.0) {
                this.maxValue = Math.abs(this.maxValue + 100.0 - this.maxValue % 100.0);
            } else {
                double d2;
                for (d2 = 0.0; this.maxValue > d2; d2 += 1000.0) {
                }
                this.maxValue = d2;
            }
        }
    }

    private class ColorBoolRenderer
    implements TableCellRenderer {
        private TableCellRenderer orgRenderer;
        private SelectionsModel selectionsModel;

        public ColorBoolRenderer(TableCellRenderer tableCellRenderer, SelectionsModel selectionsModel) {
            this.orgRenderer = tableCellRenderer;
            this.selectionsModel = selectionsModel;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = this.orgRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (((Boolean)object).booleanValue()) {
                component.setBackground(this.selectionsModel.getColorAt(n, n2));
            }
            return component;
        }
    }
}

