/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.BooleanDCNode;
import COM.hugin.HAPI.ContinuousChanceNode;
import COM.hugin.HAPI.DiscreteDecisionNode;
import COM.hugin.HAPI.DiscreteNode;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.ExceptionParse;
import COM.hugin.HAPI.IntervalDCNode;
import COM.hugin.HAPI.LabelledDCNode;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HAPI.NumberedDCNode;
import COM.hugin.HAPI.UtilityNode;
import COM.hugin.HAPIMODELTOOLS.ModelTools;
import COM.hugin.HGUI.AccuracyAnalysis;
import COM.hugin.HGUI.AnalyzeNetworkPanel;
import COM.hugin.HGUI.AnalyzeSlider;
import COM.hugin.HGUI.BeliefBarPanel;
import COM.hugin.HGUI.CaseBank;
import COM.hugin.HGUI.DataViewer;
import COM.hugin.HGUI.DiscreteChanceNode;
import COM.hugin.HGUI.FileLauncher;
import COM.hugin.HGUI.HelpPanel;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginComboBox;
import COM.hugin.HGUI.HuginFileLoader;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIFrame;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.HuginInsets;
import COM.hugin.HGUI.HuginProjectFrame;
import COM.hugin.HGUI.LearningWizard;
import COM.hugin.HGUI.Link;
import COM.hugin.HGUI.NetworkPanel;
import COM.hugin.HGUI.Node;
import COM.hugin.HGUI.PastingTextField;
import COM.hugin.HGUI.StreamData;
import COM.hugin.HGUI.TableSorter;
import COM.hugin.HGUI.TitledPanel;
import COM.hugin.HGUI.ZoomingPane;
import COM.hugin.MODEL.BeliefEngine;
import COM.hugin.MODEL.Case;
import COM.hugin.MODEL.CaseSet;
import COM.hugin.MODEL.ExceptionModelProcessing;
import COM.hugin.MODEL.Network;
import COM.hugin.REPORT.Report;
import COM.hugin.REPORT.ReportTools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class AnalysisWizard
extends JPanel {
    private JPanel scoresPane;
    private JPanel dependenciesPane;
    private JPanel accuracyPane;
    private JPanel samplePane;
    private JPanel dataPane;
    private HelpPanel helpPanel;
    private String[] helpPages = new String[]{"help/AW_DataSource.htm", "help/AW_AIC_BIC_LL.htm", "help/AW_Dependencies.htm", "help/AW_Data_Accuracy.htm", "help/AW_Sampling.htm", "help/AW_Case_Beliefs.htm"};
    private boolean hasContinuous = false;
    private JPanel casePane;
    private ArrayList<COM.hugin.HAPI.DiscreteChanceNode> ddnodes;
    private String databaseName;
    private ArrayList<String> fieldNames;
    private ArrayList<Double> casePanelBeliefs;
    private double[] casePanelConflicts;
    private String seperator;
    protected boolean selectedFlatFile;
    boolean removeEvidence = false;
    private JSpinner spinner;
    private JButton refreshButton;
    private JButton extraDataButton;
    private JCheckBox removeCheckBox;
    private JLabel infoLabel;
    private DataViewer viewer;
    private StreamData streamData;
    private HuginProjectFrame projectFrame;
    private JDialog wizardWindow;
    private Domain domain;
    private File dataFile = null;
    private JLabel dataFileLabel;
    private JLabel databaseNumberOfCasesLabel;
    private JLabel databaseFileLabel;
    private JLabel nodeLabel;
    private JLabel stateLabel;
    private JButton clearData;
    private JButton clearButton;
    private JButton saveCSVButton;
    private JTabbedPane tabbedPane;
    private AnalyzeNetworkPanel networkPanel;
    private JButton zoomIn;
    private JButton zoomOut;
    private JButton zoomFit;
    private JButton stretchScaleButton;
    private JButton compressScaleButton;
    private JLabel depStatusLabel;
    private AnalyzeSlider slider = null;
    private boolean showingCompleteGraph = false;
    private JScrollPane accuracyScroller;
    private JComboBox accuracySelect;
    private JComboBox stateCombo;
    private HuginComboBox nodeCombo;
    private JComboBox caseSelect;
    private JComboBox sampleCaseSelect;
    private JScrollPane accuracyReportPane;
    private JSplitPane accuracyReportAndROCPanel;
    private JTextArea accuracyReport;
    private CaseBank caseBank;
    private String[] depCases;
    private JScrollPane viewDataPane;
    private JScrollPane viewCasePane;
    private JLabel dataNumberOfCasesLabel;
    private NumberField numOfCases = null;
    private NumberField percentMissingValues = null;
    private NumberField ruleSize = null;
    private JRadioButton mar = null;
    private JRadioButton mcar = null;
    private JLabel sampleStatus;
    private HuginGUIFrame guiFrame;
    private COM.hugin.HAPI.Node[] dccApiNodes;
    private AnalysisWizard aw;
    private AccuracyAnalysis accuracyAnalysisTool;
    JButton reportButton;

    public AnalysisWizard(HuginProjectFrame huginProjectFrame, HuginGUIFrame huginGUIFrame) {
        super(new GridLayout(1, 1));
        Object object;
        Object object2;
        Serializable serializable;
        this.projectFrame = huginProjectFrame;
        this.guiFrame = huginGUIFrame;
        this.aw = this;
        this.streamData = null;
        try {
            HuginGUIUtils.configureDomain(this.domain);
            if (!this.projectFrame.runMode || this.projectFrame.getBeliefBarPanel().getDomain() == null || !this.projectFrame.getBeliefBarPanel().getDomain().isCompiled()) {
                JOptionPane.showMessageDialog(this.projectFrame, HuginGUIConstants.get("AW_Dialog_domain_error"));
                return;
            }
            this.domain = this.projectFrame.getBeliefBarPanel().getDomain();
            if (this.projectFrame.getBeliefBarPanel().getDomain().isCompressed()) {
                JOptionPane.showMessageDialog(this.projectFrame, HuginGUIConstants.get("AW_Dialog_domain_compressed_error"));
                return;
            }
            serializable = this.domain.getNodes();
            boolean bl = false;
            object2 = ((AbstractSequentialList)((Object)serializable)).iterator();
            while (object2.hasNext()) {
                object = (COM.hugin.HAPI.Node)object2.next();
                if (object instanceof COM.hugin.HAPI.DiscreteChanceNode) {
                    bl = true;
                }
                if (!(object instanceof ContinuousChanceNode)) continue;
                this.hasContinuous = true;
            }
            if (bl && this.projectFrame.getClassInfo().isClass()) {
                object2 = ((AbstractSequentialList)((Object)serializable)).iterator();
                while (object2.hasNext()) {
                    object = (COM.hugin.HAPI.Node)object2.next();
                    if (!(object instanceof DiscreteDecisionNode) && !(object instanceof UtilityNode)) continue;
                    bl = false;
                    break;
                }
            }
            if (!bl) {
                JOptionPane.showMessageDialog(this.projectFrame, HuginGUIConstants.get("AW_Dialog_domain_no_dcc_nodes"));
                return;
            }
            this.caseBank = new CaseBank(this.domain);
            this.caseBank.newCase();
            this.caseBank.copyCasesFromDomain();
            this.domain.setNumberOfCases(0);
            object2 = new MouseListener(){

                public void mouseClicked(MouseEvent mouseEvent) {
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                }

                public void mouseExited(MouseEvent mouseEvent) {
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    Link link = AnalysisWizard.this.networkPanel.whichLink(mouseEvent.getPoint());
                    if (link != null) {
                        AnalysisWizard.this.networkPanel.deselectLinks();
                        link.select();
                        ((AnalysisWizard)AnalysisWizard.this).networkPanel.selectedLinks.add(link);
                        if (link.parent.getAPINode() instanceof COM.hugin.HAPI.DiscreteChanceNode && link.child.getAPINode() instanceof COM.hugin.HAPI.DiscreteChanceNode) {
                            AnalysisWizard.this.depStatusLabel.setText("I(" + link.parent.getName() + ", " + link.child.getName() + "|e) = " + HuginGUIUtils.formatDouble(link.getStrength()));
                        } else {
                            AnalysisWizard.this.depStatusLabel.setText(" ");
                        }
                    } else {
                        AnalysisWizard.this.networkPanel.deselectLinks();
                        AnalysisWizard.this.depStatusLabel.setText(" ");
                    }
                    AnalysisWizard.this.networkPanel.repaint();
                }
            };
            object = new MouseMotionListener(){

                public void mouseDragged(MouseEvent mouseEvent) {
                }

                public void mouseMoved(MouseEvent mouseEvent) {
                }
            };
            this.networkPanel = new AnalyzeNetworkPanel(this.domain, huginProjectFrame, (MouseListener)object2, (MouseMotionListener)object);
            this.caseBank.enterCase(0);
            this.configureLinkStrengths(false);
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
        }
        this.tabbedPane = new JTabbedPane();
        this.createDataPane();
        this.createScoresPane();
        if (!this.hasContinuous) {
            this.createDependenciesPane();
        }
        this.createAccuracyPane();
        if (!this.hasContinuous) {
            this.createSamplePane();
        }
        this.selectedFlatFile = false;
        this.createCasePane();
        this.tabbedPane.addTab(HuginGUIConstants.get("AW_Tab_data_acquisition"), this.dataPane);
        this.tabbedPane.addTab(HuginGUIConstants.get("AW_Tab_scores"), this.scoresPane);
        if (!this.hasContinuous) {
            this.tabbedPane.addTab(HuginGUIConstants.get("AW_Tab_data_dependencies"), this.dependenciesPane);
        }
        this.tabbedPane.addTab(HuginGUIConstants.get("AW_Tab_accuracy"), this.accuracyPane);
        if (!this.hasContinuous) {
            this.tabbedPane.addTab(HuginGUIConstants.get("AW_Tab_sample"), this.samplePane);
        }
        this.tabbedPane.addTab(HuginGUIConstants.get("AW_Case_title"), this.casePane);
        serializable = new JPanel(new FlowLayout(2));
        JButton jButton = new JButton(HuginGUIConstants.get("MISCELLANEOUS_Close"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AnalysisWizard.this.wizardWindow.dispose();
            }
        });
        ((Container)serializable).add(jButton);
        object2 = new JPanel(new FlowLayout(0));
        object = new JButton(HuginGUIConstants.get("str_help"));
        ((AbstractButton)object).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = AnalysisWizard.this.tabbedPane.getSelectedIndex();
                if (n >= 0 && n < AnalysisWizard.this.helpPages.length) {
                    AnalysisWizard.this.helpPanel.setHelpPage(AnalysisWizard.this.helpPages[n]);
                    if (!AnalysisWizard.this.helpPanel.isVisible()) {
                        int n2 = AnalysisWizard.this.wizardWindow.getX() - AnalysisWizard.this.helpPanel.getWidth();
                        if (n2 < 5 && (n2 = AnalysisWizard.this.wizardWindow.getX() + AnalysisWizard.this.getWidth()) + AnalysisWizard.this.helpPanel.getWidth() > Toolkit.getDefaultToolkit().getScreenSize().width - 5) {
                            n2 = 5;
                        }
                        AnalysisWizard.this.helpPanel.setLocation(n2, AnalysisWizard.this.wizardWindow.getY());
                        AnalysisWizard.this.helpPanel.setVisible(true);
                    }
                }
            }
        });
        ((Container)object2).add((Component)object);
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.add((Component)object2);
        jPanel.add((Component)serializable);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.tabbedPane, "Center");
        jPanel2.add((Component)jPanel, "South");
        this.add(jPanel2);
        this.wizardWindow = new JDialog(Hugin.mainFrame, HuginGUIConstants.get("AW_Title"), true);
        this.helpPanel = new HelpPanel(this.wizardWindow);
        this.wizardWindow.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                AnalysisWizard.this.projectFrame.getNetworkPanel().updateBackpointers();
            }
        });
        this.wizardWindow.getContentPane().add(this);
        this.wizardWindow.pack();
        HuginGUIUtils.centerComponent(Hugin.mainFrame, (Window)this.wizardWindow);
        this.wizardWindow.setDefaultCloseOperation(2);
        this.wizardWindow.addWindowListener(new CloseListener(this.domain, this.projectFrame.getNetworkPanel()));
        this.wizardWindow.setVisible(true);
    }

    private boolean containsInconsistent() throws ExceptionHugin {
        Vector<Long> vector = new Vector<Long>();
        int n = this.domain.getNumberOfCases();
        for (int i = 0; i < n; ++i) {
            try {
                this.domain.enterCase(i);
                this.domain.propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
                continue;
            }
            catch (ExceptionHugin exceptionHugin) {
                vector.add(new Long(i));
            }
        }
        this.domain.retractFindings();
        if (vector.size() > 0) {
            String string = HuginGUIConstants.get("str_inconsistency_detected_impossible_cases");
            for (Long serializable2 : vector) {
                string = string + "\n#" + serializable2;
            }
            JPanel jPanel = new JPanel();
            JTextArea jTextArea = new JTextArea(string);
            JScrollPane jScrollPane = new JScrollPane(jTextArea, 20, 31);
            jScrollPane.setPreferredSize(new Dimension((int)jTextArea.getPreferredSize().getWidth() + 20, 150));
            jPanel.add(jScrollPane);
            JOptionPane.showMessageDialog(this, jPanel);
            return true;
        }
        return false;
    }

    private void updatePanes() {
        int n = this.tabbedPane.indexOfTab(HuginGUIConstants.get("AW_Tab_scores"));
        this.tabbedPane.remove(n);
        this.createScoresPane();
        this.tabbedPane.insertTab(HuginGUIConstants.get("AW_Tab_scores"), null, this.scoresPane, null, n);
        if (!this.hasContinuous) {
            n = this.tabbedPane.indexOfTab(HuginGUIConstants.get("AW_Tab_data_dependencies"));
            this.tabbedPane.remove(n);
            this.createDependenciesPane();
            this.tabbedPane.insertTab(HuginGUIConstants.get("AW_Tab_data_dependencies"), null, this.dependenciesPane, null, n);
        }
        n = this.tabbedPane.indexOfTab(HuginGUIConstants.get("AW_Tab_accuracy"));
        this.tabbedPane.remove(n);
        this.createAccuracyPane();
        this.tabbedPane.insertTab(HuginGUIConstants.get("AW_Tab_accuracy"), null, this.accuracyPane, null, n);
        if (!this.hasContinuous) {
            n = this.tabbedPane.indexOfTab(HuginGUIConstants.get("AW_Tab_sample"));
            this.tabbedPane.remove(n);
            this.createSamplePane();
            this.tabbedPane.insertTab(HuginGUIConstants.get("AW_Tab_sample"), null, this.samplePane, null, n);
        }
        n = this.tabbedPane.indexOfTab(HuginGUIConstants.get("AW_Case_title"));
        this.tabbedPane.remove(n);
        this.createCasePane();
        this.tabbedPane.insertTab(HuginGUIConstants.get("AW_Case_title"), null, this.casePane, null, n);
    }

    public void createSamplePane() {
        int n = 0;
        try {
            n = this.domain.getNodes().size();
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
        }
        this.samplePane = new TitledPanel(HuginGUIConstants.get("AW_Sample_title"));
        this.samplePane.setLayout(new BorderLayout());
        String string = this.numOfCases != null ? this.numOfCases.getText() : "10";
        String string2 = this.percentMissingValues != null ? this.percentMissingValues.getText() : "5";
        String string3 = "";
        string3 = this.ruleSize != null ? this.ruleSize.getText() : "" + (n - 1) / 10;
        this.numOfCases = new NumberField(10000000L);
        this.numOfCases.setText(string);
        this.percentMissingValues = new NumberField(100L);
        this.percentMissingValues.setText(string2);
        this.ruleSize = new NumberField((long)(n - 1));
        this.ruleSize.setText(string3);
        this.ruleSize.setEnabled(false);
        JPanel jPanel = new JPanel(new GridLayout(3, 2));
        jPanel.add(new JLabel(HuginGUIConstants.get("AW_Sample_number_of_cases")));
        jPanel.add(this.numOfCases);
        jPanel.add(new JLabel(HuginGUIConstants.get("AW_Sample_percent_missing_values")));
        jPanel.add(this.percentMissingValues);
        jPanel.add(new JLabel(HuginGUIConstants.get("AW_Sample_rule_size")));
        jPanel.add(this.ruleSize);
        TitledPanel titledPanel = new TitledPanel(HuginGUIConstants.get("AW_Sample_rule_format"));
        titledPanel.setLayout(new GridLayout(2, 1));
        ButtonGroup buttonGroup = new ButtonGroup();
        boolean bl = this.mar != null ? this.mar.isSelected() : false;
        this.mar = new JRadioButton(HuginGUIConstants.get("AW_Sample_MAR"));
        this.mar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AnalysisWizard.this.ruleSize.setEnabled(true);
            }
        });
        this.mcar = new JRadioButton(HuginGUIConstants.get("AW_Sample_MCAR"));
        this.mcar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AnalysisWizard.this.ruleSize.setEnabled(false);
            }
        });
        this.mcar.setSelected(!bl);
        this.mar.setSelected(bl);
        this.ruleSize.setEnabled(bl);
        buttonGroup.add(this.mcar);
        buttonGroup.add(this.mar);
        titledPanel.add(this.mar);
        titledPanel.add(this.mcar);
        if (this.hasContinuous) {
            this.mar.setEnabled(false);
            this.mcar.setSelected(true);
        }
        JButton jButton = new JButton(HuginGUIConstants.get("AW_Sample_simulate"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    AnalysisWizard.this.reportButton.setEnabled(false);
                    if ((int)AnalysisWizard.this.numOfCases.getNumber() <= 0) {
                        AnalysisWizard.this.sampleStatus.setText(HuginGUIConstants.get("str_no_cases_added"));
                        return;
                    }
                    int n = AnalysisWizard.this.domain.getNumberOfCases();
                    if (AnalysisWizard.this.mar.isSelected()) {
                        HuginGUIUtils.simulateMAR(AnalysisWizard.this.domain, null, (int)AnalysisWizard.this.numOfCases.getNumber(), (int)AnalysisWizard.this.percentMissingValues.getNumber(), (int)AnalysisWizard.this.ruleSize.getNumber(), false);
                    } else {
                        HuginGUIUtils.simulateMCAR(AnalysisWizard.this.domain, null, (int)AnalysisWizard.this.numOfCases.getNumber(), (int)AnalysisWizard.this.percentMissingValues.getNumber(), false);
                    }
                    String string = HuginGUIConstants.get("str_simulated_ARG0_cases_added_case_ARG1_to_ARG2", new String[]{"" + AnalysisWizard.this.numOfCases.getNumber(), "" + n, "" + (AnalysisWizard.this.domain.getNumberOfCases() - 1)});
                    int n2 = AnalysisWizard.this.sampleCaseSelect.getSelectedIndex();
                    AnalysisWizard.this.updatePanes();
                    AnalysisWizard.this.sampleStatus.setText(string);
                    AnalysisWizard.this.clearData.setEnabled(true);
                    AnalysisWizard.this.addInfo(HuginGUIConstants.get("AW_Data_file") + HuginGUIConstants.get("AW_Data_using_simulated"), HuginGUIConstants.get("AW_Data_number_of_cases") + AnalysisWizard.this.domain.getNumberOfCases());
                    if (AnalysisWizard.this.domain.getNumberOfCases() > 0) {
                        JTable jTable = new JTable(new ViewCaseModel(AnalysisWizard.this.domain)){

                            public boolean isCellEditable(int n, int n2) {
                                return false;
                            }
                        };
                        jTable.getTableHeader().setDefaultRenderer(new ToolTipHeader());
                        jTable.setAutoResizeMode(0);
                        AnalysisWizard.this.initColumnSizes(jTable);
                        AnalysisWizard.this.viewDataPane.setViewportView(jTable);
                    }
                    AnalysisWizard.this.casePanelBeliefs = null;
                    AnalysisWizard.this.removeViewer();
                    AnalysisWizard.this.displayFlatCases();
                    AnalysisWizard.this.tabbedPane.setSelectedIndex(AnalysisWizard.this.tabbedPane.indexOfTab(HuginGUIConstants.get("AW_Tab_sample")));
                    AnalysisWizard.this.sampleCaseSelect.setSelectedIndex(n2);
                }
                catch (ExceptionHugin exceptionHugin) {
                    new HuginGUIError(exceptionHugin);
                }
            }
        });
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "West");
        jPanel2.add((Component)titledPanel, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)new JLabel(HuginGUIConstants.get("AW_Sample_based_on_case")), "West");
        jPanel3.add((Component)this.sampleCaseSelect, "East");
        this.sampleStatus = new JLabel("   ");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)this.sampleStatus, "West");
        jPanel4.add((Component)jButton, "East");
        jPanel2.add((Component)jPanel3, "South");
        this.samplePane.add((Component)jPanel2, "North");
        this.samplePane.add((Component)jPanel4, "South");
    }

    protected void configureLinkStrengths(boolean bl) {
        this.showingCompleteGraph = bl;
        LinkedList linkedList = this.networkPanel.linkList;
        this.networkPanel.selectedLinks.clear();
        linkedList.clear();
        try {
            this.domain.propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
            if (!bl) {
                for (COM.hugin.HAPI.Node node : this.networkPanel.getHome().getNodes()) {
                    for (COM.hugin.HAPI.Node node2 : node.getChildren()) {
                        linkedList.add(new Link(this.networkPanel.getNode(node), this.networkPanel.getNode(node2), this.networkPanel.scaleFactor));
                    }
                }
            } else {
                Iterator<Node> iterator = new ArrayList();
                for (Node node : this.networkPanel.nodeList) {
                    if (!(node instanceof DiscreteChanceNode)) continue;
                    ((ArrayList)((Object)iterator)).add(node);
                }
                int n = ((ArrayList)((Object)iterator)).size();
                for (int i = 0; i < n - 1; ++i) {
                    for (int j = i + 1; j < n; ++j) {
                        Link link = new Link((Node)((ArrayList)((Object)iterator)).get(i), (Node)((ArrayList)((Object)iterator)).get(j), this.networkPanel.getScaleFactor());
                        link.isDirected(false);
                        linkedList.add(link);
                    }
                }
            }
            for (Link link : linkedList) {
                try {
                    COM.hugin.HAPI.DiscreteChanceNode discreteChanceNode = (COM.hugin.HAPI.DiscreteChanceNode)link.parent.getAPINode();
                    COM.hugin.HAPI.DiscreteChanceNode discreteChanceNode2 = (COM.hugin.HAPI.DiscreteChanceNode)link.child.getAPINode();
                    link.setStrength(discreteChanceNode.getMutualInformation(discreteChanceNode2));
                }
                catch (ClassCastException classCastException) {
                    link.setStrength(Double.MIN_VALUE);
                    link.color = Color.red;
                }
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
        }
        this.networkPanel.repaint();
    }

    private void displayInfo(String string) {
        this.infoLabel.setText(string);
    }

    private void createCasePane() {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        Object object;
        Object object2;
        this.ddnodes = new ArrayList();
        this.casePane = new TitledPanel(HuginGUIConstants.get("AW_Case_title"));
        this.casePane.setLayout(new BorderLayout());
        this.removeEvidence = false;
        JPanel jPanel4 = new JPanel(new GridLayout(1, 1));
        JPanel jPanel5 = new JPanel(new BorderLayout(5, 5));
        jPanel4.add(jPanel5);
        JPanel jPanel6 = new JPanel(new BorderLayout());
        this.nodeLabel = new JLabel(HuginGUIConstants.get("AW_Data_Variable"));
        this.nodeCombo = new HuginComboBox();
        this.stateLabel = new JLabel(HuginGUIConstants.get("AW_Data_State"));
        this.stateLabel.setPreferredSize(this.nodeLabel.getPreferredSize());
        this.stateCombo = new JComboBox();
        try {
            for (COM.hugin.HAPI.Node node : this.domain.getNodes()) {
                if (!(node instanceof COM.hugin.HAPI.DiscreteChanceNode)) continue;
                this.nodeCombo.addItem(HuginGUIUtils.getNodeTitle(node));
                this.ddnodes.add((COM.hugin.HAPI.DiscreteChanceNode)node);
            }
            this.nodeCombo.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        try {
                            int n = AnalysisWizard.this.nodeCombo.getSelectedIndex();
                            COM.hugin.HAPI.DiscreteChanceNode discreteChanceNode = (COM.hugin.HAPI.DiscreteChanceNode)AnalysisWizard.this.ddnodes.get(n);
                            AnalysisWizard.this.stateCombo.removeAllItems();
                            int n2 = discreteChanceNode.getNumberOfStates();
                            for (int i = 0; i < n2; ++i) {
                                AnalysisWizard.this.stateCombo.addItem(HuginGUIUtils.getNodeStateLabel(discreteChanceNode, i));
                            }
                        }
                        catch (ExceptionHugin exceptionHugin) {
                            // empty catch block
                        }
                    }
                }
            });
            this.nodeCombo.setPreferredSize(new Dimension(250, this.nodeCombo.getPreferredSize().height));
            jPanel6.add((Component)this.nodeLabel, "West");
            jPanel6.add((Component)this.nodeCombo, "Center");
            object2 = new JPanel(new BorderLayout());
            int n = this.nodeCombo.getSelectedIndex();
            object = this.ddnodes.get(n);
            int n2 = ((DiscreteNode)object).getNumberOfStates();
            for (int i = 0; i < n2; ++i) {
                this.stateCombo.addItem(HuginGUIUtils.getNodeStateLabel((COM.hugin.HAPI.Node)object, i));
            }
            this.stateCombo.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        AnalysisWizard.this.casePanelBeliefs = null;
                        AnalysisWizard.this.viewCasePane.setViewportView(null);
                        AnalysisWizard.this.removeViewer();
                        AnalysisWizard.this.displayInfo("");
                    }
                }
            });
            ((Container)object2).add((Component)this.stateLabel, "West");
            ((Container)object2).add((Component)this.stateCombo, "Center");
            jPanel3 = new JPanel(new BorderLayout());
            jPanel3.add((Component)jPanel6, "North");
            jPanel3.add((Component)object2, "South");
            jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel3, "North");
            this.removeCheckBox = new JCheckBox(HuginGUIConstants.get("AW_Remove_Evidence"), false);
            this.removeCheckBox.setToolTipText(HuginGUIConstants.get("AW_ToolTip_Remove_Evidence"));
            this.removeCheckBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    AnalysisWizard.this.removeEvidence = AnalysisWizard.this.removeCheckBox.isSelected();
                }
            });
            jPanel = new JPanel(new BorderLayout());
            jPanel6 = new JPanel(new BorderLayout());
            jPanel6.add((Component)this.removeCheckBox, "West");
            jPanel.add((Component)jPanel6, "Center");
            this.spinner = new JSpinner(new SpinnerNumberModel(0.5, 0.0, 1.0, 0.05));
            JLabel jLabel = new JLabel(HuginGUIConstants.get("AW_Color_Threshold") + "  ");
            this.refreshButton = new JButton(new ImageIcon(ClassLoader.getSystemResource("icons/initialize.gif")));
            this.refreshButton.setMargin(new HuginInsets());
            this.spinner.setPreferredSize(new Dimension(50, this.spinner.getPreferredSize().height));
            this.refreshButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AnalysisWizard.this.showCases();
                    AnalysisWizard.this.refreshMoreDataTable();
                    AnalysisWizard.this.displayInfo("");
                }
            });
            this.refreshButton.setToolTipText(HuginGUIConstants.get("AW_ToolTip_Refresh"));
            JPanel jPanel7 = new JPanel(new BorderLayout(5, 5));
            JPanel jPanel8 = new JPanel(new BorderLayout(5, 5));
            jPanel6 = new JPanel(new BorderLayout(5, 5));
            jPanel6.add((Component)this.spinner, "East");
            jPanel8.add((Component)jPanel6, "West");
            jPanel8.add((Component)jLabel, "Center");
            jPanel7.add((Component)jPanel8, "North");
            JPanel jPanel9 = new JPanel(new BorderLayout());
            jPanel6 = new JPanel(new BorderLayout());
            jPanel6.add((Component)this.refreshButton, "South");
            jPanel9.add((Component)jPanel6, "East");
            jPanel6 = new JPanel(new BorderLayout());
            jPanel6.add((Component)jPanel, "North");
            jPanel6.add((Component)jPanel7, "South");
            JPanel jPanel10 = new JPanel(new GridLayout(1, 1));
            jPanel10.add(jPanel6);
            jPanel10.add(jPanel9);
            jPanel10.setBorder(BorderFactory.createEtchedBorder());
            jPanel5.add((Component)jPanel3, "West");
            jPanel5.add((Component)jPanel10, "Center");
            jPanel5.add((Component)new JSeparator(), "South");
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin.getMessage());
        }
        this.databaseFileLabel = new JLabel("---");
        this.databaseNumberOfCasesLabel = new JLabel(HuginGUIConstants.get("AW_Data_number_of_cases") + "0", 4);
        object2 = new JPanel(new GridLayout(1, 2));
        ((Container)object2).add(this.databaseFileLabel);
        ((Container)object2).add(this.databaseNumberOfCasesLabel);
        this.viewCasePane = new JScrollPane();
        this.viewCasePane.setPreferredSize(new Dimension(450, 300));
        JButton jButton = new JButton(HuginGUIConstants.get("AW_Data_Connect"));
        this.extraDataButton = new JButton(HuginGUIConstants.get("AW_Extra_Data"));
        this.extraDataButton.setToolTipText(HuginGUIConstants.get("AW_ToolTip_Extra_Data"));
        this.extraDataButton.addActionListener(new MoreDataListener());
        this.extraDataButton.setEnabled(this.streamData != null && this.streamData.hasExtraData() && this.viewCasePane.getViewport().getView() != null);
        this.clearButton = new JButton(HuginGUIConstants.get("AW_Data_clear_data"));
        this.clearButton.setToolTipText(HuginGUIConstants.get("AW_ToolTip_Clear_Data"));
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AnalysisWizard.this.clearData();
                AnalysisWizard.this.tabbedPane.setSelectedIndex(AnalysisWizard.this.tabbedPane.indexOfTab(HuginGUIConstants.get("AW_Case_title")));
            }
        });
        this.clearButton.setEnabled(false);
        this.saveCSVButton = new JButton(HuginGUIConstants.get("AW_export_csv"));
        this.saveCSVButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                block12: {
                    JTable jTable;
                    JTable jTable2 = jTable = AnalysisWizard.this.viewCasePane.getViewport() != null && AnalysisWizard.this.viewCasePane.getViewport().getView() != null && AnalysisWizard.this.viewCasePane.getViewport().getView() instanceof JTable ? (JTable)AnalysisWizard.this.viewCasePane.getViewport().getView() : null;
                    if (jTable != null) {
                        int n = jTable.getColumnCount();
                        int n2 = jTable.getRowCount();
                        try {
                            int n3;
                            HuginFileLoader huginFileLoader = new HuginFileLoader(11, Hugin.mainFrame.getMostRecentDataFile(), 5);
                            if (huginFileLoader.showSaveDialog(Hugin.mainFrame) != 0) break block12;
                            File file = huginFileLoader.getSelectedFile();
                            PrintStream printStream = new PrintStream(file);
                            String string = ";";
                            for (n3 = 0; n3 < n; ++n3) {
                                if (n3 > 0) {
                                    printStream.print(" " + string + " ");
                                }
                                String string2 = "" + jTable.getColumnName(n3);
                                if ((string2 = string2.replaceAll("\n", " ")).indexOf(",") > 0 || string2.indexOf(".") > 0 || string2.indexOf(";") > 0 || string2.indexOf("\"") > 0) {
                                    string2 = "\"" + string2 + "\"";
                                }
                                printStream.print(string2);
                            }
                            printStream.print("\r\n");
                            for (n3 = 0; n3 < n2; ++n3) {
                                for (int i = 0; i < n; ++i) {
                                    String string3;
                                    block13: {
                                        if (i > 0) {
                                            printStream.print(" " + string + " ");
                                        }
                                        string3 = "" + jTable.getValueAt(n3, i);
                                        try {
                                            Double.parseDouble(string3);
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            string3 = string3.replaceAll("\n", " ");
                                            if (string3.indexOf(",") <= 0 && string3.indexOf(".") <= 0 && string3.indexOf(";") <= 0 && string3.indexOf("\"") <= 0) break block13;
                                            string3 = "\"" + string3 + "\"";
                                        }
                                    }
                                    printStream.print(string3);
                                }
                                printStream.print("\r\n");
                            }
                            printStream.close();
                            new FileLauncher((Dialog)((JDialog)SwingUtilities.getWindowAncestor(AnalysisWizard.this)), AnalysisWizard.this.guiFrame, file);
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            new HuginGUIError(fileNotFoundException.getMessage());
                        }
                        catch (Exception exception) {
                            new HuginGUIError(exception);
                        }
                    }
                }
            }
        });
        object = new JButton(HuginGUIConstants.get("AW_Data_select_file"));
        jPanel3 = new JPanel(new BorderLayout());
        jPanel2 = new JPanel(new GridLayout(1, 3));
        jPanel2.add(this.extraDataButton);
        jPanel2.add(this.clearButton);
        jPanel2.add(this.saveCSVButton);
        this.infoLabel = new JLabel("");
        jPanel3.add((Component)this.infoLabel, "West");
        jPanel3.add((Component)jPanel2, "East");
        jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)object2, "North");
        jPanel.add((Component)this.viewCasePane, "Center");
        jPanel.add((Component)jPanel3, "South");
        this.casePane.add((Component)jPanel4, "North");
        this.casePane.add((Component)jPanel, "Center");
    }

    private boolean isSelected(String string) {
        try {
            int n = this.nodeCombo.getSelectedIndex();
            COM.hugin.HAPI.Node node = this.ddnodes.get(n);
            String string2 = node.getName();
            boolean bl = false;
            boolean bl2 = bl = string2.equals(string) || string2.toLowerCase().equals(string.toLowerCase()) || string2.toLowerCase() == string.toLowerCase();
            if (!bl) {
                bl = node.getLabel() == string || node.getLabel().equals(string) || node.getLabel().toLowerCase().equals(string.toLowerCase()) || node.getLabel().toLowerCase() == string.toLowerCase();
            }
            return bl;
        }
        catch (ExceptionHugin exceptionHugin) {
            return false;
        }
    }

    private void createDataPane() {
        this.dataPane = new TitledPanel(HuginGUIConstants.get("AW_Data_title"));
        this.dataFileLabel = new JLabel(HuginGUIConstants.get("AW_Data_file") + "---");
        this.dataNumberOfCasesLabel = new JLabel(HuginGUIConstants.get("AW_Data_number_of_cases") + "0", 4);
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.add(this.dataFileLabel);
        jPanel.add(this.dataNumberOfCasesLabel);
        this.viewDataPane = new JScrollPane();
        this.viewDataPane.setPreferredSize(new Dimension(450, 300));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 4));
        JButton jButton = new JButton(HuginGUIConstants.get("AW_Data_database"));
        jButton.setToolTipText(HuginGUIConstants.get("SA_ToolTip_Load_Cases"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LearningWizard learningWizard = new LearningWizard(AnalysisWizard.this.wizardWindow, ((AnalysisWizard)AnalysisWizard.this).guiFrame.preferences, AnalysisWizard.this.domain, new DomainCasesListener());
                learningWizard.setLocation(100, 100);
                learningWizard.setVisible(true);
                AnalysisWizard.this.reportButton.setEnabled(AnalysisWizard.this.streamData != null);
            }
        });
        JButton jButton2 = new JButton(HuginGUIConstants.get("AW_Data_current"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    AnalysisWizard.this.domain.setNumberOfCases(0);
                    AnalysisWizard.this.caseBank.copyCasesToDomain(1, AnalysisWizard.this.caseBank.getNumberOfCases() - 1);
                    AnalysisWizard.this.clearData.setEnabled(true);
                    AnalysisWizard.this.updatePanes();
                    AnalysisWizard.this.addInfo(HuginGUIConstants.get("AW_Data_file") + HuginGUIConstants.get("AW_Data_using_network"), HuginGUIConstants.get("AW_Data_number_of_cases") + AnalysisWizard.this.domain.getNumberOfCases());
                    AnalysisWizard.this.configureLinkStrengths(false);
                    if (AnalysisWizard.this.domain.getNumberOfCases() > 0) {
                        JTable jTable = new JTable(new ViewCaseModel(AnalysisWizard.this.domain)){

                            public boolean isCellEditable(int n, int n2) {
                                return false;
                            }
                        };
                        jTable.getTableHeader().setDefaultRenderer(new ToolTipHeader());
                        jTable.setAutoResizeMode(0);
                        AnalysisWizard.this.initColumnSizes(jTable);
                        AnalysisWizard.this.viewDataPane.setViewportView(jTable);
                    }
                    AnalysisWizard.this.casePanelBeliefs = null;
                    AnalysisWizard.this.removeViewer();
                    AnalysisWizard.this.displayFlatCases();
                }
                catch (ExceptionHugin exceptionHugin) {
                    new HuginGUIError(exceptionHugin);
                }
            }
        });
        jButton2.setEnabled(this.caseBank.getNumberOfCases() > 1);
        this.clearData = new JButton(HuginGUIConstants.get("AW_Data_clear_data"));
        this.clearData.setToolTipText(HuginGUIConstants.get("AW_ToolTip_Clear_Data"));
        this.clearData.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AnalysisWizard.this.clearData();
            }
        });
        this.clearData.setEnabled(false);
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel2.add(this.clearData);
        this.reportButton = new JButton("Generate report");
        this.reportButton.setEnabled(this.streamData != null);
        jPanel2.add(this.reportButton);
        this.reportButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    String string = AnalysisWizard.this.domain.getAttribute("HR_Report");
                    System.out.println(string);
                    if (string != null) {
                        Network network = ModelTools.createModel(AnalysisWizard.this.domain.getFileName(), AnalysisWizard.this.domain, 1);
                        if (AnalysisWizard.this.streamData == null) {
                            return;
                        }
                        final Vector<StreamData.ColumnData> vector = new Vector<StreamData.ColumnData>();
                        for (StreamData.ColumnData object2 : AnalysisWizard.this.streamData.getData()) {
                            if (vector.contains(object2)) continue;
                            vector.add(object2);
                        }
                        for (StreamData.ColumnData columnData : AnalysisWizard.this.streamData.getExtraColumns()) {
                            if (vector.contains(columnData)) continue;
                            vector.add(columnData);
                        }
                        ModelTools.DataProvider dataProvider = new ModelTools.DataProvider(){

                            public String[] getColumnNames() {
                                int n = 0;
                                String[] stringArray = new String[vector.size()];
                                for (StreamData.ColumnData columnData : vector) {
                                    stringArray[n++] = columnData.getNodeName();
                                }
                                return stringArray;
                            }

                            public String[] getCase(int n) {
                                String[] stringArray = new String[vector.size()];
                                int n2 = 0;
                                for (StreamData.ColumnData columnData : vector) {
                                    Object object = columnData.getValueFromCase(n);
                                    stringArray[n2++] = object == null ? "" : (object instanceof String ? (String)object : "" + object);
                                }
                                return stringArray;
                            }
                        };
                        CaseSet caseSet = ModelTools.loadDataFromProviderAndCasesFromDomain(dataProvider, network, AnalysisWizard.this.domain);
                        Vector<Report> vector2 = ReportTools.XMLToReport(string, network);
                        BeliefEngine beliefEngine = new BeliefEngine(){

                            public void propagate(Network network) throws ExceptionModelProcessing {
                            }

                            public double[][][] batchPropagate(Network network, COM.hugin.MODEL.Node[] nodeArray, COM.hugin.MODEL.DiscreteNode[] discreteNodeArray, Case[] caseArray) {
                                try {
                                    double[][][] dArrayArray = new double[caseArray.length][][];
                                    for (int i = 0; i < caseArray.length; ++i) {
                                        Object object;
                                        int n;
                                        double[][] dArrayArray2 = new double[discreteNodeArray.length][];
                                        AnalysisWizard.this.domain.initialize();
                                        for (n = 0; n < nodeArray.length; ++n) {
                                            object = AnalysisWizard.this.domain.getNodeByName(nodeArray[n].getName());
                                            if (object instanceof DiscreteNode) {
                                                int n2 = caseArray[i].disc_states[n];
                                                if (n2 <= -1) continue;
                                                ((DiscreteNode)object).selectState(n2);
                                                continue;
                                            }
                                            if (!(object instanceof ContinuousChanceNode) || !caseArray[i].cont_flags[n]) continue;
                                            ((ContinuousChanceNode)object).enterValue(caseArray[i].cont_values[n]);
                                        }
                                        try {
                                            AnalysisWizard.this.domain.propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
                                            for (n = 0; n < discreteNodeArray.length; ++n) {
                                                object = discreteNodeArray[n].getName();
                                                DiscreteNode discreteNode = (DiscreteNode)AnalysisWizard.this.domain.getNodeByName((String)object);
                                                double[] dArray = new double[discreteNode.getNumberOfStates()];
                                                for (int j = 0; j < discreteNode.getNumberOfStates(); ++j) {
                                                    dArray[j] = discreteNode.getBelief(j);
                                                }
                                                dArrayArray2[n] = dArray;
                                            }
                                            dArrayArray[i] = dArrayArray2;
                                            continue;
                                        }
                                        catch (Exception exception) {
                                            dArrayArray[i] = null;
                                            System.err.println("Failed Propagating #" + i);
                                            exception.printStackTrace();
                                        }
                                    }
                                    AnalysisWizard.this.domain.initialize();
                                    return dArrayArray;
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                    return null;
                                }
                            }
                        };
                        ModelTools.generateReport(AnalysisWizard.this.wizardWindow, vector2, caseSet, beliefEngine, network);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.dataPane.setLayout(new BorderLayout());
        this.dataPane.add((Component)jPanel, "North");
        this.dataPane.add((Component)this.viewDataPane, "Center");
        this.dataPane.add((Component)jPanel2, "South");
    }

    private void addInfo(String string, String string2) {
        if (string.length() > 0 && string2.length() > 0) {
            this.dataFileLabel.setText(string);
            this.dataNumberOfCasesLabel.setText(string2);
            this.databaseFileLabel.setText(string);
            this.databaseNumberOfCasesLabel.setText(string2);
        } else {
            this.dataFileLabel.setText(HuginGUIConstants.get("AW_Data_file") + "---");
            this.dataNumberOfCasesLabel.setText(HuginGUIConstants.get("AW_Data_number_of_cases") + "0");
            this.databaseFileLabel.setText(HuginGUIConstants.get("AW_Data_file") + ": " + "---");
            this.databaseNumberOfCasesLabel.setText(HuginGUIConstants.get("AW_Data_number_of_cases") + "0");
        }
    }

    private void clearData() {
        try {
            this.domain.setNumberOfCases(0);
            this.addInfo("", "");
            this.dataFile = null;
            this.clearData.setEnabled(false);
            this.viewDataPane.setViewportView(null);
            this.removeViewer();
            this.viewCasePane.setViewportView(null);
            this.clearButton.setEnabled(false);
            this.selectedFlatFile = false;
            this.reportButton.setEnabled(false);
            this.updatePanes();
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
        }
    }

    public void showData(String string, StreamData streamData) {
        try {
            if (this.containsInconsistent()) {
                this.clearData();
                return;
            }
            this.clearData.setEnabled(true);
            this.updatePanes();
            this.addInfo(HuginGUIConstants.get("AW_Data_file") + string, HuginGUIConstants.get("AW_Data_number_of_cases") + this.domain.getNumberOfCases());
            this.configureLinkStrengths(false);
            if (this.domain.getNumberOfCases() > 0) {
                ViewCaseModel viewCaseModel = new ViewCaseModel(this.domain);
                JTable jTable = new JTable(viewCaseModel){

                    public boolean isCellEditable(int n, int n2) {
                        return false;
                    }
                };
                jTable.getTableHeader().setDefaultRenderer(new ToolTipHeader());
                jTable.setAutoResizeMode(0);
                this.initColumnSizes(jTable);
                this.viewDataPane.setViewportView(jTable);
            }
            this.casePanelBeliefs = null;
            this.removeViewer();
            this.displayFlatCases();
            if (streamData != null && !streamData.isEmpty() && streamData.hasExtraData()) {
                this.streamData = streamData;
                this.extraDataButton.setEnabled(true);
            }
        }
        catch (ExceptionParse exceptionParse) {
        }
        catch (ExceptionHugin exceptionHugin) {
            // empty catch block
        }
    }

    private void createDependenciesPane() {
        this.dependenciesPane = new JPanel();
        JScrollPane jScrollPane = new JScrollPane(this.networkPanel);
        jScrollPane.setPreferredSize(new Dimension(450, 300));
        JToolBar jToolBar = new JToolBar();
        JCheckBox jCheckBox = new JCheckBox(HuginGUIConstants.get("AW_Dep_complete_graph"));
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AnalysisWizard.this.configureLinkStrengths(!AnalysisWizard.this.showingCompleteGraph);
                AnalysisWizard.this.readSlider();
                if (AnalysisWizard.this.showingCompleteGraph) {
                    AnalysisWizard.this.depStatusLabel.setText(HuginGUIConstants.get("str_complete_graph"));
                } else {
                    AnalysisWizard.this.depStatusLabel.setText(HuginGUIConstants.get("str_original_graph"));
                }
            }
        });
        jToolBar.add(jCheckBox);
        JButton jButton = new JButton(new ImageIcon(ClassLoader.getSystemResource("icons/magnify-plus.gif")));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    double d = AnalysisWizard.this.networkPanel.zoom(1.1111111111111112);
                    AnalysisWizard.this.zoomOut.setEnabled(AnalysisWizard.this.networkPanel.getScaleFactor() > 0.1);
                    AnalysisWizard.this.zoomIn.setEnabled(AnalysisWizard.this.networkPanel.getScaleFactor() < 10.0);
                    AnalysisWizard.this.depStatusLabel.setText(HuginGUIConstants.get("str_zoom_ARG0_percent", new String[]{"" + Math.round(d * 100.0)}));
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
            }
        });
        jButton.setText("");
        jButton.setToolTipText(HuginGUIConstants.get("str_zoom_in_by_ten_percent"));
        jButton.setMargin(new HuginInsets());
        this.zoomIn = jButton;
        jToolBar.add(jButton);
        jButton = new JButton(new ImageIcon(ClassLoader.getSystemResource("icons/magnify-minus.gif")));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    double d = AnalysisWizard.this.networkPanel.zoom(0.9);
                    AnalysisWizard.this.zoomOut.setEnabled(AnalysisWizard.this.networkPanel.getScaleFactor() > 0.1);
                    AnalysisWizard.this.zoomIn.setEnabled(AnalysisWizard.this.networkPanel.getScaleFactor() < 10.0);
                    AnalysisWizard.this.depStatusLabel.setText(HuginGUIConstants.get("str_zoom_ARG0_percent", new String[]{"" + Math.round(d * 100.0)}));
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
            }
        });
        jButton.setText("");
        jButton.setToolTipText("Zoom out by 10%");
        jButton.setMargin(new HuginInsets());
        this.zoomOut = jButton;
        jToolBar.add(jButton);
        jButton = new JButton(new ImageIcon(ClassLoader.getSystemResource("icons/zoom-fit.gif")));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    double d = 0.0;
                    d = ZoomingPane.computeFitFactor(AnalysisWizard.this.networkPanel);
                    AnalysisWizard.this.networkPanel.setScaleFactor(d);
                    AnalysisWizard.this.zoomOut.setEnabled(true);
                    AnalysisWizard.this.zoomIn.setEnabled(true);
                    AnalysisWizard.this.depStatusLabel.setText(HuginGUIConstants.get("str_scaled_to_fit"));
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
            }
        });
        jButton.setText("");
        jButton.setToolTipText(HuginGUIConstants.get("str_zoom_to_fit"));
        jButton.setMargin(new HuginInsets());
        this.zoomFit = jButton;
        jToolBar.add(jButton);
        jToolBar.addSeparator(new Dimension(10, 0));
        jButton = new JButton(new ImageIcon(ClassLoader.getSystemResource("icons/stretch-scale.gif")));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AnalysisWizard.this.stretchScaleButton.setEnabled(AnalysisWizard.this.slider.stretchScale());
                AnalysisWizard.this.compressScaleButton.setEnabled(true);
                AnalysisWizard.this.depStatusLabel.setText("Slider scale stretched by a factor of 1.0E10");
            }
        });
        jButton.setText("");
        jButton.setToolTipText(HuginGUIConstants.get("str_stretch_slider_scale"));
        jButton.setMargin(new HuginInsets());
        this.stretchScaleButton = jButton;
        jToolBar.add(jButton);
        jButton = new JButton(new ImageIcon(ClassLoader.getSystemResource("icons/compress-scale.gif")));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AnalysisWizard.this.compressScaleButton.setEnabled(AnalysisWizard.this.slider.compressScale());
                AnalysisWizard.this.stretchScaleButton.setEnabled(true);
                AnalysisWizard.this.depStatusLabel.setText("Slider scale compressed by a factor of 1.0E10");
            }
        });
        jButton.setText("");
        jButton.setToolTipText(HuginGUIConstants.get("str_compress_slider_scale"));
        jButton.setMargin(new HuginInsets());
        this.compressScaleButton = jButton;
        jToolBar.add(jButton);
        jToolBar.setFloatable(false);
        this.depStatusLabel = new JLabel("             ");
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                AnalysisWizard.this.readSlider();
            }
        };
        this.slider = new AnalyzeSlider(this.networkPanel.getMinMutualInformation(), this.networkPanel.getMaxMutualInformation(), changeListener, this.stretchScaleButton, this.compressScaleButton, this.depStatusLabel);
        this.slider.setValue(1.0);
        try {
            this.depCases = new String[this.domain.getNumberOfCases() + 2];
            this.depCases[0] = HuginGUIConstants.get("AW_Dep_evidence_entered_prior");
            this.depCases[1] = HuginGUIConstants.get("AW_Dep_no_evidence");
            for (int i = 0; i < this.domain.getNumberOfCases(); ++i) {
                this.depCases[i + 2] = "" + i;
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
        }
        this.caseSelect = new JComboBox<String>(this.depCases);
        this.caseSelect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (AnalysisWizard.this.caseSelect.getSelectedItem().equals(HuginGUIConstants.get("AW_Dep_no_evidence"))) {
                        AnalysisWizard.this.domain.retractFindings();
                    } else if (AnalysisWizard.this.caseSelect.getSelectedItem().equals(HuginGUIConstants.get("AW_Dep_evidence_entered_prior"))) {
                        AnalysisWizard.this.caseBank.enterCase(0);
                    } else {
                        int n = Integer.parseInt((String)AnalysisWizard.this.caseSelect.getSelectedItem());
                        AnalysisWizard.this.domain.enterCase(n);
                    }
                    AnalysisWizard.this.domain.propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
                    AnalysisWizard.this.configureLinkStrengths(AnalysisWizard.this.showingCompleteGraph);
                    AnalysisWizard.this.slider.setMinIndependence(AnalysisWizard.this.networkPanel.getMinMutualInformation());
                    AnalysisWizard.this.stretchScaleButton.setEnabled(AnalysisWizard.this.slider.stretchScale());
                    AnalysisWizard.this.compressScaleButton.setEnabled(AnalysisWizard.this.slider.compressScale());
                    AnalysisWizard.this.slider.setValue(0.0);
                    AnalysisWizard.this.readSlider();
                    AnalysisWizard.this.depStatusLabel.setText(HuginGUIConstants.get("str_case_entered"));
                    if (AnalysisWizard.this.caseSelect.getSelectedIndex() != AnalysisWizard.this.sampleCaseSelect.getSelectedIndex()) {
                        AnalysisWizard.this.sampleCaseSelect.setSelectedIndex(AnalysisWizard.this.caseSelect.getSelectedIndex());
                    }
                }
                catch (ExceptionHugin exceptionHugin) {
                    new HuginGUIError(exceptionHugin);
                }
            }
        });
        this.sampleCaseSelect = new JComboBox<String>(this.depCases);
        this.sampleCaseSelect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (AnalysisWizard.this.caseSelect.getSelectedIndex() != AnalysisWizard.this.sampleCaseSelect.getSelectedIndex()) {
                    AnalysisWizard.this.caseSelect.setSelectedIndex(AnalysisWizard.this.sampleCaseSelect.getSelectedIndex());
                }
            }
        });
        this.caseSelect.setSelectedIndex(0);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.depStatusLabel, "South");
        jPanel.add((Component)new JLabel(HuginGUIConstants.get("AW_Dep_enter_case")), "West");
        jPanel.add((Component)this.caseSelect, "Center");
        TitledPanel titledPanel = new TitledPanel(HuginGUIConstants.get("AW_Dep_title"));
        titledPanel.setLayout(new BorderLayout());
        titledPanel.add((Component)jToolBar, "North");
        titledPanel.add((Component)jScrollPane, "Center");
        titledPanel.add((Component)this.slider, "East");
        titledPanel.add((Component)jPanel, "South");
        this.dependenciesPane.setLayout(new BorderLayout());
        this.dependenciesPane.add((Component)titledPanel, "Center");
    }

    protected void readSlider() {
        if (this.slider != null && this.networkPanel != null) {
            double d = this.slider.getValue();
            this.networkPanel.setThreshold(d);
            this.depStatusLabel.setText(HuginGUIConstants.get("str_threshold_set_to_ARG0", new String[]{"" + HuginGUIUtils.formatDouble(d)}));
        }
    }

    private void createScoresPane() {
        JLabel jLabel = new JLabel(HuginGUIConstants.get("AW_Scores_AIC"));
        JLabel jLabel2 = new JLabel(HuginGUIConstants.get("AW_Scores_BIC"));
        JLabel jLabel3 = new JLabel(HuginGUIConstants.get("AW_Scores_ll"));
        JTextArea jTextArea = new JTextArea("---");
        jTextArea.setBackground(this.getBackground());
        jTextArea.setEditable(false);
        JTextArea jTextArea2 = new JTextArea("---");
        jTextArea2.setBackground(this.getBackground());
        jTextArea2.setEditable(false);
        JTextArea jTextArea3 = new JTextArea("---");
        jTextArea3.setEditable(false);
        jTextArea3.setBackground(this.getBackground());
        try {
            if (this.domain != null && this.domain.getNumberOfCases() > 0) {
                jTextArea.setText("" + this.domain.getAIC());
                jTextArea2.setText("" + this.domain.getBIC());
                jTextArea3.setText("" + this.domain.getLogLikelihood());
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
        }
        JPanel jPanel = new JPanel(new GridLayout(3, 2, 10, 5));
        jPanel.add(jLabel);
        jPanel.add(jTextArea);
        jPanel.add(jLabel2);
        jPanel.add(jTextArea2);
        jPanel.add(jLabel3);
        jPanel.add(jTextArea3);
        this.scoresPane = new TitledPanel(HuginGUIConstants.get("AW_Scores_title"));
        this.scoresPane.setLayout(new FlowLayout(0));
        this.scoresPane.add(jPanel);
    }

    private void createAccuracyPane() {
        this.accuracyPane = new JPanel();
        this.accuracyPane.setLayout(new BorderLayout());
        try {
            ArrayList<COM.hugin.HAPI.Node> arrayList = new ArrayList<COM.hugin.HAPI.Node>();
            for (COM.hugin.HAPI.Node node : this.domain.getNodes()) {
                if (!(node instanceof COM.hugin.HAPI.DiscreteChanceNode)) continue;
                arrayList.add(node);
            }
            int n = arrayList.size();
            this.dccApiNodes = new COM.hugin.HAPI.Node[n];
            for (int i = 0; i < n; ++i) {
                this.dccApiNodes[i] = (COM.hugin.HAPI.Node)arrayList.get(i);
            }
            DiscreteNode discreteNode = null;
            if (n > 0) {
                discreteNode = (DiscreteNode)this.dccApiNodes[n - 1];
            }
            this.accuracyAnalysisTool = new AccuracyAnalysis(this.domain, discreteNode, -1.0, null);
            JTable jTable = this.accuracyAnalysisTool.getDataAccuracyTable();
            this.initColumnSizes(jTable);
            this.accuracyScroller = new JScrollPane();
            this.accuracyScroller.setViewportView(jTable);
            String[] stringArray = new String[this.dccApiNodes.length];
            for (int i = 0; i < this.dccApiNodes.length; ++i) {
                stringArray[i] = this.getNodeName(this.dccApiNodes[i]);
            }
            this.accuracySelect = new JComboBox<String>(stringArray);
            this.accuracySelect.setSelectedIndex(stringArray.length - 1);
            this.accuracySelect.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AnalysisWizard.this.switchAccuracyTableTo(AnalysisWizard.this.dccApiNodes[AnalysisWizard.this.accuracySelect.getSelectedIndex()]);
                }
            });
            JPanel jPanel = this.makeROCPanel(discreteNode);
            this.accuracyReport = new JTextArea(this.accuracyAnalysisTool.getAccuracyReport());
            this.accuracyReport.setFont(HuginGUIConstants.defaultFont);
            this.accuracyReportPane = new JScrollPane(this.accuracyReport);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)this.accuracyReportPane, "Center");
            JButton jButton = new JButton(HuginGUIConstants.get("str_calculate_using_max"));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AnalysisWizard.this.accuracyAnalysisTool.performComputations(-1.0);
                    AnalysisWizard.this.accuracyReport.setText(AnalysisWizard.this.accuracyAnalysisTool.getAccuracyReport());
                    AnalysisWizard.this.accuracyReport.setCaretPosition(0);
                }
            });
            jPanel2.add((Component)jButton, "South");
            this.accuracyReportAndROCPanel = new JSplitPane(1, jPanel2, jPanel);
            this.accuracyReportAndROCPanel.setDividerLocation(300);
            this.accuracyPane.add((Component)this.accuracySelect, "North");
            JPanel jPanel3 = new JPanel(new GridLayout(2, 1));
            jPanel3.setPreferredSize(new Dimension(200, 200));
            jPanel3.add(this.accuracyReportAndROCPanel);
            jPanel3.add(this.accuracyScroller);
            this.accuracyPane.add((Component)jPanel3, "Center");
            if (!this.hasContinuous) {
                this.caseSelect.setSelectedIndex(this.caseSelect.getSelectedIndex());
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
        }
    }

    public JPanel makeROCPanel(DiscreteNode discreteNode) throws ExceptionHugin {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.accuracyAnalysisTool.getROCCurve(), "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)new JLabel(HuginGUIConstants.get("str_display_curve_for_")), "West");
        jPanel2.add((Component)this.accuracyAnalysisTool.getROCStateSelector(), "Center");
        jPanel2.add((Component)this.accuracyAnalysisTool.getROCCutoffSlider(), "North");
        JButton jButton = new JButton(HuginGUIConstants.get("str_compute_confusion"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AnalysisWizard.this.accuracyAnalysisTool.performComputations(AnalysisWizard.this.accuracyAnalysisTool.getROCSliderThreshold());
                AnalysisWizard.this.accuracyReport.setText(AnalysisWizard.this.accuracyAnalysisTool.getAccuracyReport());
                AnalysisWizard.this.accuracyReport.setCaretPosition(0);
            }
        });
        jPanel2.add((Component)jButton, "East");
        jPanel2.add((Component)this.accuracyAnalysisTool.getAUCLabel(), "South");
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    private String getNodeName(COM.hugin.HAPI.Node node) {
        String string = "";
        try {
            String string2 = this.domain.getAttribute("HR_Node_Label_Style");
            string = string2 == null ? (!node.getLabel().equals("") ? node.getLabel() : node.getName()) : (string2.equals("1") ? node.getName() : (string2.equals("2") ? (!node.getLabel().equals("") ? node.getLabel() + " (" + node.getName() + ")" : node.getName()) : (!node.getLabel().equals("") ? node.getLabel() : node.getName())));
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
        }
        return string;
    }

    private void switchAccuracyTableTo(COM.hugin.HAPI.Node node) {
        try {
            this.accuracyAnalysisTool = new AccuracyAnalysis(this.domain, node, -1.0, null);
            JTable jTable = this.accuracyAnalysisTool.getDataAccuracyTable();
            this.initColumnSizes(jTable);
            this.accuracyScroller.setViewportView(jTable);
            this.accuracyReport = new JTextArea(this.accuracyAnalysisTool.getAccuracyReport());
            this.accuracyReport.setFont(HuginGUIConstants.defaultFont);
            this.accuracyReportPane.setViewportView(this.accuracyReport);
            if (!this.hasContinuous) {
                this.caseSelect.setSelectedIndex(this.caseSelect.getSelectedIndex());
            }
            this.accuracyReportAndROCPanel.setRightComponent(this.makeROCPanel((DiscreteNode)node));
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
        }
    }

    private void initColumnSizes(JTable jTable) {
        jTable.doLayout();
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        TableModel tableModel = jTable.getModel();
        TableColumn tableColumn = null;
        Component component = null;
        int n = 0;
        int n2 = 0;
        TableCellRenderer tableCellRenderer = jTable.getTableHeader().getDefaultRenderer();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            tableColumn = jTable.getColumnModel().getColumn(i);
            component = tableCellRenderer.getTableCellRendererComponent(null, tableColumn.getHeaderValue(), false, false, 0, 0);
            n = component.getPreferredSize().width;
            n2 = 0;
            for (int j = 0; j < jTable.getRowCount(); ++j) {
                component = jTable.getDefaultRenderer(tableModel.getColumnClass(i)).getTableCellRendererComponent(jTable, jTable.getValueAt(0, i), false, false, 0, i);
                n2 = Math.max(n2, component.getPreferredSize().width + 15);
            }
            tableColumn.setPreferredWidth(Math.max(n, n2));
        }
    }

    private void showCases() {
        this.displayFlatCases();
    }

    private void displayFlatCases() {
        try {
            if (this.domain.getNumberOfCases() > 0) {
                this.selectedFlatFile = true;
                ViewCaseModel viewCaseModel = new ViewCaseModel(this.domain, true, this.removeEvidence);
                TableSorter tableSorter = new TableSorter(viewCaseModel);
                tableSorter.doubleLargerThanString(true);
                JTable jTable = new JTable(tableSorter){

                    public boolean isCellEditable(int n, int n2) {
                        return false;
                    }
                };
                jTable.getTableHeader().setDefaultRenderer(new ToolTipHeader());
                jTable.addMouseListener(new RightClickListener(jTable));
                jTable.setAutoResizeMode(0);
                tableSorter.setTableHeader(jTable.getTableHeader());
                jTable.setDefaultRenderer(Object.class, new CaseColorTableCellRenderer(jTable));
                ListSelectionModel listSelectionModel = jTable.getSelectionModel();
                listSelectionModel.setSelectionMode(2);
                jTable.setRowSelectionAllowed(true);
                this.initColumnSizes(jTable);
                this.viewCasePane.setViewportView(jTable);
                this.clearButton.setEnabled(true);
                this.extraDataButton.setEnabled(this.streamData != null && this.streamData.hasExtraData() && this.viewCasePane.getViewport().getView() != null);
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            this.clearButton.setEnabled(false);
        }
    }

    private StreamData.ColumnData createColumnFromModel(ViewCaseModel viewCaseModel, StreamData streamData, int n, String string) {
        COM.hugin.HAPI.Node node = null;
        try {
            node = this.domain.getNodeByName(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        StreamData.ColumnData columnData = streamData.createColumnData(string, node);
        for (int i = 0; i < viewCaseModel.getRowCount(); ++i) {
            columnData.addCase(i, viewCaseModel.getValueAt(i, n));
        }
        return columnData;
    }

    private StreamData.ColumnData joinModelStreamColumns(ViewCaseModel viewCaseModel, StreamData streamData, int n, String string) {
        COM.hugin.HAPI.Node node = null;
        try {
            node = this.domain.getNodeByName(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        StreamData.ColumnData columnData = streamData.getColumn(string);
        StreamData.ColumnData columnData2 = streamData.createColumnData(string, node);
        for (int i = 0; i < viewCaseModel.getRowCount(); ++i) {
            Object object = columnData.getValueFromCase(i);
            if (object == null || this.removeCheckBox.isSelected()) {
                object = viewCaseModel.getValueAt(i, n);
            }
            columnData2.addCase(i, object);
        }
        return columnData2;
    }

    private StreamData prepareJoinedData(ViewCaseModel viewCaseModel) {
        Object object;
        Vector<StreamData.ColumnData> vector;
        Vector<StreamData.ColumnData> vector2 = new Vector<StreamData.ColumnData>();
        if (this.streamData != null && this.streamData.getSize() != 0) {
            this.streamData.removeCaseNumbers();
            vector = this.streamData.getData();
            object = viewCaseModel.getColumnNames();
            for (int i = 0; i < ((Object)object).length; ++i) {
                StreamData.ColumnData columnData = this.streamData.getColumn((String)object[i]);
                if (columnData != null) {
                    if (this.nodeCombo.getSelectedItem().equals(object[i])) {
                        vector2.add(this.joinModelStreamColumns(viewCaseModel, this.streamData, i, (String)object[i]));
                        continue;
                    }
                    vector2.add(columnData);
                    continue;
                }
                columnData = this.createColumnFromModel(viewCaseModel, this.streamData, i, (String)object[i]);
                if (columnData == null) continue;
                vector2.add(columnData);
            }
        }
        vector = this.streamData.getExtraColumns();
        for (StreamData.ColumnData columnData : vector) {
            vector2.add(columnData);
        }
        object = new StreamData();
        ((StreamData)object).createTemplate(vector2);
        return object;
    }

    private void viewMoreData(StreamData streamData, Point point, Dimension dimension) {
        block3: {
            Window window = null;
            try {
                window = new DataViewer((JDialog)this.getTopLevelAncestor(), streamData, point, dimension);
                ((DataViewer)window).addCloseListener(new ViewerCloseListener());
                this.extraDataButton.setEnabled(false);
                this.viewer = window;
                JTable jTable = (JTable)this.viewCasePane.getViewport().getView();
                if (window != null) {
                    InterSelectionListener interSelectionListener = new InterSelectionListener(jTable, (DataViewer)window);
                    ListSelectionModel listSelectionModel = jTable.getSelectionModel();
                    listSelectionModel.addListSelectionListener(interSelectionListener);
                    ViewInterSelectionListener viewInterSelectionListener = new ViewInterSelectionListener(((DataViewer)window).getTable(), jTable);
                    ListSelectionModel listSelectionModel2 = ((DataViewer)window).getTable().getSelectionModel();
                    listSelectionModel2.addListSelectionListener(viewInterSelectionListener);
                }
                window.pack();
                ((Dialog)window).setVisible(true);
            }
            catch (Exception exception) {
                if (window == null) break block3;
                window.dispose();
            }
        }
    }

    private void removeViewer() {
        if (this.viewer != null) {
            this.viewer.dispose();
            this.viewer = null;
        }
        this.extraDataButton.setEnabled(this.streamData != null && this.streamData.hasExtraData() && this.viewCasePane.getViewport().getView() != null);
    }

    private int getCaseNumberColumnIndex(JTable jTable) {
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            String string = jTable.getColumnName(i);
            if (!string.equals(HuginGUIConstants.get("AW_Accuracy_case_no"))) continue;
            return i;
        }
        return -1;
    }

    private void refreshMoreDataTable() {
        Point point = null;
        Dimension dimension = null;
        if (this.viewer != null) {
            point = this.viewer.getLocation();
            dimension = this.viewer.getSize();
            this.viewer.dispose();
            this.viewer = null;
        }
        if (this.streamData != null && this.streamData.hasExtraData() && !this.extraDataButton.isEnabled()) {
            StreamData streamData = new StreamData();
            streamData.createTemplate(this.streamData.getExtraColumns());
            this.viewMoreData(streamData, point, dimension);
        }
    }

    static /* synthetic */ double[] access$4902(AnalysisWizard analysisWizard, double[] dArray) {
        analysisWizard.casePanelConflicts = dArray;
        return dArray;
    }

    private class ToolTipHeader
    implements TableCellRenderer {
        private ToolTipHeader() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = new JLabel(" " + object.toString() + " ");
            jLabel.setToolTipText(object.toString());
            jLabel.setHorizontalAlignment(0);
            jLabel.setBorder(BorderFactory.createRaisedBevelBorder());
            return jLabel;
        }
    }

    private class ViewerCloseListener
    implements ChangeListener {
        private ViewerCloseListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            AnalysisWizard.this.extraDataButton.setEnabled(AnalysisWizard.this.streamData != null && AnalysisWizard.this.streamData.hasExtraData() && AnalysisWizard.this.viewCasePane.getViewport().getView() != null);
        }
    }

    private class ViewInterSelectionListener
    implements ListSelectionListener {
        JTable viewTable;
        JTable dataTable;

        public ViewInterSelectionListener(JTable jTable, JTable jTable2) {
            this.dataTable = jTable2;
            this.viewTable = jTable;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            try {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (!listSelectionModel.isSelectionEmpty() && !listSelectionModel.getValueIsAdjusting()) {
                    int n = this.viewTable.getSelectedRow();
                    int n2 = AnalysisWizard.this.getCaseNumberColumnIndex(this.viewTable);
                    Object object = this.viewTable.getValueAt(n, n2);
                    int n3 = -1;
                    n3 = object instanceof String ? new Integer((String)object).intValue() : ((Integer)object).intValue();
                    int n4 = this.dataTable.getSelectedRow();
                    int n5 = -1;
                    if (n4 != -1) {
                        int n6 = AnalysisWizard.this.getCaseNumberColumnIndex(this.dataTable);
                        object = this.dataTable.getValueAt(n4, n6);
                        n5 = object instanceof String ? new Integer((String)object).intValue() : ((Integer)object).intValue();
                    }
                    if (n3 != n5 && (n4 = this.getRowByCaseNumber(n3)) != -1) {
                        this.dataTable.getSelectionModel().setSelectionInterval(n4, n4);
                        JViewport jViewport = AnalysisWizard.this.viewCasePane.getViewport();
                        Rectangle rectangle = this.dataTable.getCellRect(n4, 1, true);
                        jViewport.setViewPosition(new Point(0, (int)rectangle.getY()));
                        AnalysisWizard.this.viewCasePane.validate();
                    }
                    AnalysisWizard.this.displayInfo(HuginGUIConstants.get("AW_selected_rows") + this.dataTable.getSelectedRowCount());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private int getRowByCaseNumber(int n) {
            int n2 = this.dataTable.getRowCount();
            int n3 = AnalysisWizard.this.getCaseNumberColumnIndex(this.dataTable);
            for (int i = 0; i < n2; ++i) {
                int n4 = new Integer((String)this.dataTable.getValueAt(i, n3));
                if (n != n4) continue;
                return i;
            }
            return -1;
        }
    }

    private class InterSelectionListener
    implements ListSelectionListener {
        JTable table;
        JTable targetTable;
        DataViewer viewer;

        public InterSelectionListener(JTable jTable, DataViewer dataViewer) {
            this.table = jTable;
            this.viewer = dataViewer;
            this.targetTable = dataViewer.getTable();
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            try {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (!listSelectionModel.isSelectionEmpty() && !listSelectionModel.getValueIsAdjusting()) {
                    int n = this.table.getSelectedRow();
                    int n2 = AnalysisWizard.this.getCaseNumberColumnIndex(this.table);
                    Object object = this.table.getValueAt(n, n2);
                    int n3 = -1;
                    n3 = object instanceof String ? new Integer((String)object).intValue() : ((Integer)object).intValue();
                    int n4 = this.targetTable.getSelectedRow();
                    int n5 = -1;
                    if (n4 != -1) {
                        int n6 = AnalysisWizard.this.getCaseNumberColumnIndex(this.targetTable);
                        object = this.targetTable.getValueAt(n4, n6);
                        n5 = object instanceof String ? new Integer((String)object).intValue() : ((Integer)object).intValue();
                    }
                    if (n3 != n5) {
                        this.targetTable.getSelectionModel().setSelectionInterval(n3, n3);
                        JScrollPane jScrollPane = this.viewer.getScrollPane();
                        JViewport jViewport = jScrollPane.getViewport();
                        Rectangle rectangle = this.targetTable.getCellRect(n3, 1, true);
                        jViewport.setViewPosition(new Point(0, (int)rectangle.getY()));
                        jScrollPane.validate();
                        this.viewer.validate();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class MoreDataListener
    implements ActionListener {
        private MoreDataListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (AnalysisWizard.this.streamData != null) {
                StreamData streamData = new StreamData();
                streamData.createTemplate(AnalysisWizard.this.streamData.getExtraColumns());
                Point point = null;
                Dimension dimension = null;
                if (AnalysisWizard.this.viewer != null) {
                    point = AnalysisWizard.this.viewer.getLocation();
                    dimension = AnalysisWizard.this.viewer.getSize();
                    AnalysisWizard.this.viewer.dispose();
                    AnalysisWizard.this.viewer = null;
                }
                AnalysisWizard.this.viewMoreData(streamData, point, dimension);
            }
        }
    }

    class JoinedDataListener
    implements ActionListener {
        JTable table;

        public JoinedDataListener(JTable jTable) {
            this.table = jTable;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                int[] nArray = this.table.getSelectedRows();
                StreamData streamData = AnalysisWizard.this.prepareJoinedData((ViewCaseModel)((TableSorter)this.table.getModel()).getTableModel());
                if (nArray.length != 0) {
                    int[] nArray2 = new int[nArray.length];
                    int n = AnalysisWizard.this.getCaseNumberColumnIndex(this.table);
                    for (int i = 0; i < nArray.length; ++i) {
                        nArray2[i] = new Integer((String)this.table.getValueAt(nArray[i], n));
                    }
                    Vector<StreamData.ColumnData> vector = streamData.getSelectedData(nArray2);
                    StreamData streamData2 = new StreamData();
                    streamData2.createTemplate(vector);
                    Point point = null;
                    Dimension dimension = null;
                    if (AnalysisWizard.this.viewer != null) {
                        point = AnalysisWizard.this.viewer.getLocation();
                        dimension = AnalysisWizard.this.viewer.getSize();
                        AnalysisWizard.this.viewer.dispose();
                        AnalysisWizard.this.viewer = null;
                    }
                    AnalysisWizard.this.viewer = new DataViewer((JDialog)AnalysisWizard.this.getTopLevelAncestor(), streamData2, point, dimension);
                    AnalysisWizard.this.viewer.addCloseListener(new ViewerCloseListener());
                    AnalysisWizard.this.extraDataButton.setEnabled(false);
                    AnalysisWizard.this.viewer.pack();
                    AnalysisWizard.this.viewer.setVisible(true);
                }
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }
    }

    class SaveSelectedCasesListener
    implements ActionListener {
        JTable table;

        public SaveSelectedCasesListener(JTable jTable) {
            this.table = jTable;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                HuginFileLoader huginFileLoader;
                int[] nArray = this.table.getSelectedRows();
                if (nArray.length != 0 && (huginFileLoader = new HuginFileLoader(1, Hugin.mainFrame.getMostRecentCaseFile(), 5)).showSaveDialog(Hugin.mainFrame) == 0) {
                    File file = huginFileLoader.getSelectedFile();
                    Hugin.mainFrame.setMostRecentCaseFile(file);
                    BeliefBarPanel beliefBarPanel = Hugin.mainFrame.getSelectedProjectFrame().getBeliefBarPanel();
                    int[] nArray2 = new int[nArray.length];
                    int n = AnalysisWizard.this.getCaseNumberColumnIndex(this.table);
                    for (int i = 0; i < nArray.length; ++i) {
                        nArray2[i] = new Integer((String)this.table.getValueAt(nArray[i], n));
                    }
                    AnalysisWizard.this.domain.saveCases(file.getAbsolutePath(), AnalysisWizard.this.domain.getNodes(), nArray2, false, ",", "");
                }
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }
    }

    class SaveCaseListener
    implements ActionListener {
        JTable table;

        public SaveCaseListener(JTable jTable) {
            this.table = jTable;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                HuginFileLoader huginFileLoader;
                int n = this.table.getSelectedRow();
                if (n != -1 && (huginFileLoader = new HuginFileLoader(9, Hugin.mainFrame.getMostRecentCaseFile(), 5)).showSaveDialog(Hugin.mainFrame) == 0) {
                    File file = huginFileLoader.getSelectedFile();
                    Hugin.mainFrame.setMostRecentCaseFile(file);
                    BeliefBarPanel beliefBarPanel = Hugin.mainFrame.getSelectedProjectFrame().getBeliefBarPanel();
                    int n2 = AnalysisWizard.this.getCaseNumberColumnIndex(this.table);
                    int n3 = new Integer((String)this.table.getValueAt(n, n2));
                    AnalysisWizard.this.domain.enterCase(n3);
                    AnalysisWizard.this.domain.propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
                    AnalysisWizard.this.projectFrame.repaint();
                    AnalysisWizard.this.domain.saveCase(file.getAbsolutePath());
                }
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }
    }

    class RightClickListener
    extends MouseAdapter {
        JPopupMenu popup;
        JTable table;

        public RightClickListener(JTable jTable) {
            this.table = jTable;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.showPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            AnalysisWizard.this.displayInfo(HuginGUIConstants.get("AW_selected_rows") + this.table.getSelectedRowCount());
            this.showPopup(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        private void showPopup(MouseEvent mouseEvent) {
            int n = this.table.rowAtPoint(mouseEvent.getPoint());
            this.createPopup(mouseEvent);
            if (mouseEvent.isPopupTrigger() && n != -1) {
                this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        private void createPopup(MouseEvent mouseEvent) {
            boolean bl = false;
            boolean bl2 = false;
            int[] nArray = this.table.getSelectedRows();
            if (nArray.length != 0) {
                if (nArray.length == 1) {
                    bl2 = true;
                }
                if (nArray.length > 1) {
                    bl = true;
                }
            }
            this.popup = new JPopupMenu();
            JMenuItem jMenuItem = new JMenuItem(HuginGUIConstants.get("MENU_FILE_Save_Case"));
            jMenuItem.addActionListener(new SaveCaseListener(this.table));
            jMenuItem.setEnabled(bl2);
            this.popup.add(jMenuItem);
            jMenuItem = new JMenuItem(HuginGUIConstants.get("AW_Save_Selected_Cases"));
            jMenuItem.addActionListener(new SaveSelectedCasesListener(this.table));
            jMenuItem.setEnabled(bl);
            this.popup.add(jMenuItem);
            jMenuItem = new JMenuItem(HuginGUIConstants.get("AW_Joined"));
            jMenuItem.setToolTipText(HuginGUIConstants.get("AW_Tip_Joined"));
            if (AnalysisWizard.this.streamData != null) {
                jMenuItem.addActionListener(new JoinedDataListener(this.table));
            }
            jMenuItem.setEnabled(AnalysisWizard.this.streamData != null && (bl || bl2));
            this.popup.add(jMenuItem);
        }
    }

    private class CaseColorTableCellRenderer
    extends DefaultTableCellRenderer {
        private JTable theTable;

        public CaseColorTableCellRenderer(JTable jTable) {
            this.theTable = jTable;
            this.setOpaque(true);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            String string = jTable.getColumnName(n2);
            if (AnalysisWizard.this.isSelected(string)) {
                if (object instanceof Double) {
                    Double d = (Double)object;
                    if (d >= (Double)AnalysisWizard.this.spinner.getValue()) {
                        float f = d.floatValue();
                        Color color = f <= 1.0f ? new Color(0.0f, 0.0f, 1.0f, f) : new Color(1.0f, 0.0f, 0.0f, 1.0f);
                        component.setBackground(color);
                        if (d < 0.25) {
                            component.setForeground(Color.black);
                        } else {
                            component.setForeground(Color.white);
                        }
                    } else {
                        component.setBackground(Color.white);
                        component.setForeground(Color.black);
                    }
                    object = HuginGUIUtils.printDouble((Double)object, 2);
                } else {
                    component.setBackground(Color.white);
                    component.setForeground(Color.black);
                }
            } else {
                component.setBackground(Color.white);
                component.setForeground(Color.black);
            }
            if (bl) {
                component.setBackground(new Color(0.0f, 0.0f, 1.0f, 0.25f));
                component.setForeground(Color.black);
            }
            return component;
        }
    }

    private class ViewCaseModel
    extends DefaultTableModel {
        Domain domain;
        ArrayList<Double> beliefList;
        double[] conflicts;
        COM.hugin.HAPI.Node[] nodes;
        int numRows;
        boolean displayBeliefs = false;
        boolean removeEvidence = false;

        public ViewCaseModel(Domain domain) throws ExceptionHugin {
            this.domain = domain;
            this.numRows = domain.getNumberOfCases();
            this.nodes = domain.getNodes().toArray(new COM.hugin.HAPI.Node[0]);
            if (!AnalysisWizard.this.hasContinuous) {
                this.computeConflicts();
            }
        }

        public ViewCaseModel(Domain domain, boolean bl, boolean bl2) throws ExceptionHugin {
            COM.hugin.HAPI.Node node;
            this.domain = domain;
            this.numRows = domain.getNumberOfCases();
            this.displayBeliefs = bl;
            this.removeEvidence = bl2;
            NodeList nodeList = domain.getNodes();
            COM.hugin.HAPI.Node node2 = (COM.hugin.HAPI.Node)AnalysisWizard.this.ddnodes.get(AnalysisWizard.this.nodeCombo.getSelectedIndex());
            if (node2 != null && (node = (COM.hugin.HAPI.Node)nodeList.getFirst()) != node2) {
                nodeList.add(nodeList.indexOf(node2), node);
                nodeList.remove(node2);
                nodeList.remove(0);
                nodeList.addFirst(node2);
            }
            this.nodes = nodeList.toArray(new COM.hugin.HAPI.Node[nodeList.size()]);
            if (AnalysisWizard.this.casePanelBeliefs != null) {
                this.beliefList = AnalysisWizard.this.casePanelBeliefs;
                this.conflicts = AnalysisWizard.this.casePanelConflicts;
            } else {
                try {
                    this.computeBeliefs((COM.hugin.HAPI.Node)AnalysisWizard.this.ddnodes.get(AnalysisWizard.this.nodeCombo.getSelectedIndex()));
                    AnalysisWizard.this.casePanelBeliefs = this.beliefList;
                    AnalysisWizard.access$4902(AnalysisWizard.this, this.conflicts);
                }
                catch (ExceptionHugin exceptionHugin) {
                    // empty catch block
                }
            }
        }

        private void computeConflicts() throws ExceptionHugin {
            this.conflicts = new double[this.numRows];
            for (int i = 0; i < this.numRows; ++i) {
                this.domain.resetInferenceEngine();
                this.domain.enterCase(i);
                this.domain.propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
                this.conflicts[i] = Math.log(this.domain.getConflict());
            }
            AnalysisWizard.access$4902(AnalysisWizard.this, this.conflicts);
        }

        private void computeBeliefs(COM.hugin.HAPI.Node node) throws ExceptionHugin {
            this.conflicts = new double[this.numRows];
            this.beliefList = new ArrayList(this.numRows);
            for (int i = 0; i < this.numRows; ++i) {
                this.domain.resetInferenceEngine();
                Double d = this.removeEvidenceAndGetBeliefs(node, i);
                this.beliefList.add(d);
                if (AnalysisWizard.this.hasContinuous) continue;
                this.conflicts[i] = Math.log(this.domain.getConflict());
            }
        }

        private Double removeEvidenceAndGetBeliefs(COM.hugin.HAPI.Node node, int n) throws ExceptionHugin {
            if (node instanceof COM.hugin.HAPI.DiscreteChanceNode) {
                COM.hugin.HAPI.DiscreteChanceNode discreteChanceNode = (COM.hugin.HAPI.DiscreteChanceNode)node;
                double d = 0.0;
                int n2 = -1;
                if (((String)AnalysisWizard.this.nodeCombo.getSelectedItem()).equals(HuginGUIUtils.getNodeTitle(discreteChanceNode))) {
                    this.domain.enterCase(n);
                    if (discreteChanceNode.caseIsSet(n)) {
                        discreteChanceNode.retractFindings();
                    }
                    this.domain.propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
                    d = new Double(HuginGUIUtils.printDouble(discreteChanceNode.getBelief(AnalysisWizard.this.stateCombo.getSelectedIndex()), 2));
                    return d;
                }
            }
            if (node instanceof ContinuousChanceNode) {
                // empty if block
            }
            return null;
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return "" + n;
            }
            if (n2 == 1) {
                if (this.conflicts == null) {
                    return "N/A";
                }
                return HuginGUIUtils.printDouble(this.conflicts[n], 5);
            }
            --n2;
            --n2;
            try {
                if (this.nodes[n2] instanceof COM.hugin.HAPI.DiscreteChanceNode) {
                    if (((COM.hugin.HAPI.DiscreteChanceNode)this.nodes[n2]).caseIsSet(n)) {
                        Double d;
                        COM.hugin.HAPI.DiscreteChanceNode discreteChanceNode = (COM.hugin.HAPI.DiscreteChanceNode)this.nodes[n2];
                        if (this.removeEvidence && this.displayBeliefs && ((String)AnalysisWizard.this.nodeCombo.getSelectedItem()).equals(HuginGUIUtils.getNodeTitle(discreteChanceNode)) && (d = this.beliefList.get(n)) != null) {
                            return d;
                        }
                        boolean bl = false;
                        String string = discreteChanceNode.getAttribute("HR_Node_states");
                        if (string != null && string.toLowerCase().trim().equals("labels") || discreteChanceNode instanceof BooleanDCNode || discreteChanceNode instanceof LabelledDCNode) {
                            bl = true;
                        }
                        if (bl) {
                            return ((COM.hugin.HAPI.DiscreteChanceNode)this.nodes[n2]).getStateLabel(((COM.hugin.HAPI.DiscreteChanceNode)this.nodes[n2]).getCaseState(n));
                        }
                        if (discreteChanceNode instanceof IntervalDCNode) {
                            return "" + HuginGUIUtils.printInf(((IntervalDCNode)this.nodes[n2]).getStateValue(((IntervalDCNode)this.nodes[n2]).getCaseState(n))) + " - " + HuginGUIUtils.printInf(((IntervalDCNode)this.nodes[n2]).getStateValue(((IntervalDCNode)this.nodes[n2]).getCaseState(n) + 1));
                        }
                        return HuginGUIUtils.printInf(((NumberedDCNode)this.nodes[n2]).getStateValue(((COM.hugin.HAPI.DiscreteChanceNode)this.nodes[n2]).getCaseState(n)));
                    }
                    if (this.displayBeliefs) {
                        COM.hugin.HAPI.DiscreteChanceNode discreteChanceNode = (COM.hugin.HAPI.DiscreteChanceNode)this.nodes[n2];
                        if (((String)AnalysisWizard.this.nodeCombo.getSelectedItem()).equals(HuginGUIUtils.getNodeTitle(discreteChanceNode))) {
                            return this.beliefList.get(n);
                        }
                    }
                    return HuginGUIConstants.get("str_NA");
                }
                if (this.nodes[n2] instanceof ContinuousChanceNode) {
                    if (((ContinuousChanceNode)this.nodes[n2]).caseIsSet(n)) {
                        return new Double(((ContinuousChanceNode)this.nodes[n2]).getCaseValue(n)).toString();
                    }
                    return HuginGUIConstants.get("str_NA");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return "-";
        }

        public String getColumnName(int n) {
            if (n == 0) {
                return HuginGUIConstants.get("AW_Accuracy_case_no");
            }
            if (n == 1) {
                return "Conflict";
            }
            --n;
            --n;
            String string = HuginGUIConstants.get("str_error_detected");
            try {
                String string2;
                string = string2 = AnalysisWizard.this.getNodeName(this.nodes[n]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return string;
        }

        public String[] getColumnNames() {
            String[] stringArray = new String[this.getColumnCount()];
            for (int i = 0; i < this.getColumnCount(); ++i) {
                stringArray[i] = this.getColumnName(i);
            }
            return stringArray;
        }

        public int getColumnCount() {
            return this.nodes.length + 2;
        }

        public int getRowCount() {
            return this.numRows;
        }
    }

    private class CloseListener
    implements WindowListener {
        private Domain domain;
        private NetworkPanel networkPanel;

        public CloseListener(Domain domain, NetworkPanel networkPanel) {
            this.domain = domain;
            this.networkPanel = networkPanel;
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
            try {
                this.domain.retractFindings();
                AnalysisWizard.this.caseBank.enterCase(0);
                this.domain.propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
                this.domain.setNumberOfCases(0);
                AnalysisWizard.this.caseBank.copyCasesToDomain(1, AnalysisWizard.this.caseBank.getNumberOfCases() - 1);
            }
            catch (ExceptionHugin exceptionHugin) {
                new HuginGUIError(exceptionHugin);
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }
    }

    private class DomainCasesListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            AnalysisWizard.this.streamData = (StreamData)changeEvent.getSource();
            String string = AnalysisWizard.this.streamData.getSourceName();
            AnalysisWizard.this.showData(string, AnalysisWizard.this.streamData);
        }
    }

    private class NumberField
    extends PastingTextField {
        long maxValue;
        long oldValue;

        public NumberField(long l) {
            super(10);
            this.maxValue = l;
            this.setHorizontalAlignment(4);
            this.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent keyEvent) {
                    try {
                        long l = Long.parseLong(NumberField.this.getText());
                        if (l > NumberField.this.maxValue) {
                            NumberField.this.setText("" + NumberField.this.oldValue);
                        } else {
                            NumberField.this.oldValue = l;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        NumberField.this.setText("" + NumberField.this.oldValue);
                    }
                }
            });
        }

        public long getNumber() {
            return Long.parseLong(this.getText());
        }
    }
}

