/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.WizardConstants;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeListener;

public class AnalyzeSlider
extends JPanel {
    private JSlider slider;
    private TicksPanel ticks;
    private boolean isEnabled = true;
    private boolean canStretch;
    private boolean canCompress;
    private static final double MINLOG = -100.0;
    protected static final double SCALE_FACTOR = 1.0E10;
    private double minValue;
    private double minLog10;
    private double logBase;
    protected static final double MIN_INITIAL_MIN = 1.0E-50;
    protected static final double MAX_MIN_VALUE = 1.0E-10;
    private JButton stretchButton;
    private JButton compressButton;
    private JLabel statusLabel;

    public AnalyzeSlider(double d, double d2, ChangeListener changeListener, JButton jButton, JButton jButton2, JLabel jLabel) {
        this.setMinIndependence(d);
        this.slider = new JSlider(1);
        this.slider.setInverted(true);
        this.slider.addChangeListener(changeListener);
        this.slider.setMinimum(-100);
        this.slider.setMaximum(0);
        this.slider.setValue((int)Math.rint(this.log(d2)));
        this.slider.setPaintTicks(false);
        this.slider.setPaintLabels(false);
        this.ticks = new TicksPanel();
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.slider);
        this.add(this.ticks);
        this.stretchButton = jButton;
        this.compressButton = jButton2;
        this.statusLabel = jLabel;
        this.canStretch = this.stretchScale();
        this.stretchButton.setEnabled(this.canStretch);
        this.canCompress = this.compressScale();
        this.compressButton.setEnabled(this.canCompress);
    }

    public void setEnabled(boolean bl) {
        this.isEnabled = bl;
        this.slider.setEnabled(this.isEnabled);
        this.ticks.setEnabled(this.isEnabled);
    }

    protected JSlider getSlider() {
        return this.slider;
    }

    protected double getValue() {
        if (this.slider.getValue() == this.slider.getMinimum()) {
            return 0.0;
        }
        return Math.pow(this.logBase, this.slider.getValue());
    }

    protected void setValue(double d) {
        this.slider.setValue((int)Math.rint(this.log(d)));
    }

    public void setMinIndependence(double d) {
        if (d <= 4.9406564584E-314) {
            d = 4.9406564584E-314;
        }
        this.minLog10 = 10.0 * Math.ceil((this.log10(d) - 10.0) / 10.0);
        this.canStretch = d < 1.0E-10;
        this.canCompress = d < 1.0E-50;
        this.minValue = this.canCompress ? 1.0E-50 : this.alog10(this.minLog10);
        this.logBase = Math.exp(Math.log(this.minValue) / -100.0);
    }

    private double log(double d) {
        return Math.log(d) / Math.log(this.logBase);
    }

    private double alog(double d) {
        return Math.pow(this.logBase, d);
    }

    private double log10(double d) {
        return Math.log(d) / Math.log(10.0);
    }

    private double alog10(double d) {
        return Math.pow(10.0, d);
    }

    protected boolean stretchScale() {
        this.reScale(1.0E10);
        return Math.rint(this.log10(this.minValue)) < -10.0;
    }

    protected boolean compressScale() {
        this.reScale(1.0E-10);
        return Math.rint(this.log10(this.minValue)) > this.minLog10;
    }

    private void reScale(double d) {
        double d2 = this.getValue();
        this.minValue *= d;
        this.logBase = Math.exp(Math.log(this.minValue) / -100.0);
        if (d2 < this.minValue) {
            d2 = this.minValue;
            this.setValue(d2);
        } else {
            this.setValue(d2);
        }
        this.repaint();
    }

    private class TicksPanel
    extends JPanel {
        static final int MAJOR_TICK = 10;
        static final int MINOR_TICK = 5;
        static final int Y_OFFSET = 7;
        private Color ticksColor = Color.black;
        int lastY;
        int stretchDegree;
        Cursor defaultCursor;
        Cursor scaleCursor;

        public TicksPanel() {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Point point = WizardConstants.SCALE_CURSOR_HOTSPOT;
            Image image = WizardConstants.SCALE_CURSOR_IMAGE;
            this.scaleCursor = toolkit.createCustomCursor(image, point, HuginGUIConstants.get("str_scale_cursor"));
            this.defaultCursor = Cursor.getDefaultCursor();
            this.addMouseListener(new MouseListener());
            this.addMouseMotionListener(new DragListener());
        }

        public void paintComponent(Graphics graphics) {
            double d = -AnalyzeSlider.this.log10(AnalyzeSlider.this.minValue);
            double d2 = 0.95 * ((double)AnalyzeSlider.this.slider.getHeight() / d);
            double d3 = Math.rint(d);
            int n = 0;
            graphics.setColor(this.ticksColor);
            for (double d4 = 0.0; d4 <= d3; d4 += 10.0) {
                int n2 = (int)(d2 * d4) + 7;
                graphics.drawLine(n, n2, n + 10, n2);
                for (double d5 = d4 + 1.0; d5 < d4 + 10.0 && d5 < d3; d5 += 1.0) {
                    n2 = (int)(d2 * d5) + 7;
                    graphics.drawLine(n, n2, n + 5, n2);
                }
            }
        }

        public void setEnabled(boolean bl) {
            this.ticksColor = bl ? Color.black : Color.gray;
        }

        private class DragListener
        extends MouseMotionAdapter {
            private DragListener() {
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                if (!AnalyzeSlider.this.canCompress && !AnalyzeSlider.this.canStretch) {
                    return;
                }
                int n = mouseEvent.getY() - TicksPanel.this.lastY;
                if (AnalyzeSlider.this.isEnabled && Math.abs(n) > 9) {
                    if (n > 0 && AnalyzeSlider.this.canStretch) {
                        AnalyzeSlider.this.stretchButton.setEnabled(AnalyzeSlider.this.canStretch = AnalyzeSlider.this.stretchScale());
                        AnalyzeSlider.this.compressButton.setEnabled(AnalyzeSlider.this.canCompress = true);
                        ++TicksPanel.this.stretchDegree;
                        this.writeStatus();
                    }
                    if (n < 0 && AnalyzeSlider.this.canCompress) {
                        AnalyzeSlider.this.compressButton.setEnabled(AnalyzeSlider.this.canCompress = AnalyzeSlider.this.compressScale());
                        AnalyzeSlider.this.stretchButton.setEnabled(AnalyzeSlider.this.canStretch = true);
                        --TicksPanel.this.stretchDegree;
                        this.writeStatus();
                    }
                    TicksPanel.this.lastY = mouseEvent.getY();
                }
            }

            private void writeStatus() {
                String string;
                double d = Math.pow(1.0E10, Math.abs(TicksPanel.this.stretchDegree));
                String string2 = string = TicksPanel.this.stretchDegree > 0 ? HuginGUIConstants.get("str_stretched") : HuginGUIConstants.get("str_compressed");
                if (d == 1.0) {
                    AnalyzeSlider.this.statusLabel.setText("");
                } else {
                    AnalyzeSlider.this.statusLabel.setText(HuginGUIConstants.get("str_slider_scale_ARG0_by_a_factor_of_ARG1", new String[]{string, "" + d}));
                }
            }
        }

        private class MouseListener
        extends MouseAdapter {
            private MouseListener() {
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (AnalyzeSlider.this.isEnabled) {
                    TicksPanel.this.lastY = mouseEvent.getY();
                    TicksPanel.this.stretchDegree = 0;
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                if (AnalyzeSlider.this.isEnabled && mouseEvent.getModifiers() == 0 && (AnalyzeSlider.this.canCompress || AnalyzeSlider.this.canStretch)) {
                    TicksPanel.this.setCursor(TicksPanel.this.scaleCursor);
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                if (AnalyzeSlider.this.isEnabled && mouseEvent.getModifiers() == 0 && (AnalyzeSlider.this.canCompress || AnalyzeSlider.this.canStretch)) {
                    TicksPanel.this.setCursor(TicksPanel.this.defaultCursor);
                }
            }
        }
    }
}

