/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.Clique;
import COM.hugin.HAPI.ContinuousChanceNode;
import COM.hugin.HAPI.DiscreteChanceNode;
import COM.hugin.HAPI.DiscreteNode;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.IntervalDCNode;
import COM.hugin.HAPI.JunctionTree;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HGUI.BeliefBarCC;
import COM.hugin.HGUI.BeliefBarCCNode;
import COM.hugin.HGUI.BeliefBarCompNode;
import COM.hugin.HGUI.BeliefBarD;
import COM.hugin.HGUI.BeliefBarDNode;
import COM.hugin.HGUI.BeliefBarNode;
import COM.hugin.HGUI.BeliefBarRootNode;
import COM.hugin.HGUI.BeliefBarTree;
import COM.hugin.HGUI.CDVTLink;
import COM.hugin.HGUI.CompilationAbortedException;
import COM.hugin.HGUI.ConflictResolutionHypothesis;
import COM.hugin.HGUI.EMLearningSetupPane;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIFrame;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.HuginHelpConstants;
import COM.hugin.HGUI.HuginProjectFrame;
import COM.hugin.HGUI.Link;
import COM.hugin.HGUI.NetworkPanel;
import COM.hugin.HGUI.Node;
import COM.hugin.HGUI.Preferences;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeliefBarPanel
extends JPanel {
    BeliefBarTree tree;
    JScrollPane scroll;
    BeliefBarRootNode root;
    HuginGUIFrame hugin;
    Preferences preferences;
    HuginProjectFrame project;
    private HuginGUIUtils.PolicyBackup tempPolicyBackup = null;
    private HuginGUIUtils.PolicyBackup policyStorage = null;
    protected boolean PMIPropagation = false;
    HashMap<JunctionTree, Clique> rootCliques;
    double[] priors;
    private NodeList traverseRootPath;
    LinkedList<PolicyUpdateListener> policyListeners = new LinkedList();
    LinkedList<BeliefBarTree.Evidence> allEvidence = null;
    boolean doPropagation = false;
    LinkedList<EvidenceListener> evidenceListeners = null;

    public BeliefBarPanel(HuginGUIFrame huginGUIFrame, HuginProjectFrame huginProjectFrame, Domain domain, NodeList nodeList) throws ExceptionHugin, OutOfMemoryError, CompilationAbortedException {
        this.traverseRootPath = nodeList;
        this.hugin = huginGUIFrame;
        this.preferences = this.hugin.preferences;
        this.project = huginProjectFrame;
        if (domain == null) {
            huginProjectFrame.getCaseNames().clear();
        }
        this.root = new BeliefBarRootNode(huginProjectFrame.getNetworkPanel(), this.preferences, domain, nodeList);
        this.root.initialize();
        this.tree = new BeliefBarTree(this.root, this.hugin, huginGUIFrame.preferences, huginProjectFrame);
        Hugin.helpManager.registerComponent(this.tree, HuginHelpConstants.HELP_FILE_node_list);
        this.scroll = new JScrollPane(this.tree);
        this.scroll.setPreferredSize(new Dimension(200, 200));
        this.setLayout(new BorderLayout());
        this.add((Component)this.scroll, "Center");
        huginProjectFrame.getRunButton(HuginGUIConstants.get("MENU_NETWORK_Enter_Likelihood")).setEnabled(false);
        this.rootCliques = new HashMap();
        for (JunctionTree junctionTree : this.root.domain.getJunctionTrees()) {
            this.rootCliques.put(junctionTree, junctionTree.getRoot());
        }
        this.setTablesChanged(false);
        this.priors = this.getAllProbabilities();
    }

    public BeliefBarPanel(HuginGUIFrame huginGUIFrame) throws ExceptionHugin, OutOfMemoryError, CompilationAbortedException {
        this(huginGUIFrame, (HuginProjectFrame)huginGUIFrame.desktop.getSelectedFrame(), null, null);
    }

    private double[] getCachedProbabilitiesInDomain() {
        Object object = this.root.domain.getUserData();
        if (object != null && object instanceof double[]) {
            return (double[])object;
        }
        return null;
    }

    private void setCachedProbabilitiesInDomain(double[] dArray) {
        this.root.domain.setUserData(dArray);
    }

    protected void setTablesChanged(boolean bl) {
        try {
            this.root.domain.setAttribute("HR_Tmp_Tables_Changed", bl ? "1" : null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean tablesChanged() {
        boolean bl = false;
        try {
            return this.root.domain.getAttribute("HR_Tmp_Tables_Changed") == null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.tree.getPreferredSize();
    }

    public void updateDomain(NetworkPanel networkPanel) throws ExceptionHugin, CompilationAbortedException {
        Domain domain = this.root.domain;
        BeliefBarRootNode beliefBarRootNode = this.root;
        BeliefBarTree beliefBarTree = this.tree;
        try {
            this.root = new BeliefBarRootNode(((HuginProjectFrame)this.hugin.desktop.getSelectedFrame()).getNetworkPanel(), this.preferences, null, this.traverseRootPath);
            this.root.initialize();
            this.tree = new BeliefBarTree(this.root, this.hugin, this.preferences, this.project);
            Hugin.helpManager.registerComponent(this.tree, HuginHelpConstants.HELP_FILE_node_list);
            this.scroll.setViewportView(this.tree);
            this.copyCases(domain, this.root.domain);
            if (domain != networkPanel.getHome()) {
                domain.delete();
            }
            for (Node node : networkPanel.nodeList) {
                if (node.monitor != null) {
                    node.monitor.updateApiNode();
                }
                if (node.policiesWindow == null) continue;
                node.policiesWindow.updateApiNode();
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            this.root = beliefBarRootNode;
            this.root.domain = domain;
            this.tree = beliefBarTree;
            this.scroll.setViewportView(this.tree);
            throw exceptionHugin;
        }
    }

    public void copyCases(Domain domain, Domain domain2) throws ExceptionHugin {
        if (domain != null && domain.isAlive()) {
            int n = domain.getNumberOfCases();
            domain2.setNumberOfCases(n);
            for (COM.hugin.HAPI.Node node : domain.getNodes()) {
                try {
                    int n2;
                    COM.hugin.HAPI.Node node2;
                    COM.hugin.HAPI.Node node3;
                    if (node instanceof DiscreteChanceNode) {
                        node3 = (DiscreteChanceNode)domain2.getNodeByName(node.getName());
                        node2 = (DiscreteChanceNode)node;
                        for (n2 = 0; n2 < n; ++n2) {
                            if (!((DiscreteNode)node2).caseIsSet(n2)) continue;
                            ((DiscreteNode)node3).setCaseState(n2, ((DiscreteNode)node2).getCaseState(n2));
                        }
                        continue;
                    }
                    if (!(node instanceof ContinuousChanceNode)) continue;
                    node3 = (ContinuousChanceNode)domain2.getNodeByName(node.getName());
                    node2 = (ContinuousChanceNode)node;
                    for (n2 = 0; n2 < n; ++n2) {
                        if (!((ContinuousChanceNode)node2).caseIsSet(n2)) continue;
                        ((ContinuousChanceNode)node3).setCaseValue(n2, ((ContinuousChanceNode)node2).getCaseValue(n2));
                    }
                }
                catch (ExceptionHugin exceptionHugin) {
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (ClassCastException classCastException) {
                }
            }
        }
    }

    public void initialize() throws ExceptionHugin {
        this.root.domain.initialize();
        HuginGUIUtils.setUseSampledValue(this.root.domain, false);
        this.project.getNetworkPanel().containsUncompiledChanges(false);
        String string = this.root.homeClass.getAttribute("HR_Monitor_AutoUpdGraph");
        boolean bl = string != null && string.equals("1");
        this.project.getNetworkPanel().updateMonitors(bl);
        this.update(!bl);
        this.fireEvidenceRetracted(null);
        for (Link link : this.project.getNetworkPanel().linkList) {
            if (!(link instanceof CDVTLink)) continue;
            this.propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
            break;
        }
        this.firePolicyUpdated();
    }

    public double getLogLikelihood() {
        double d = 0.0;
        try {
            d = this.root.domain.getLogLikelihood();
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        return d;
    }

    public String getNormalizationConstant() {
        double d = 0.0;
        try {
            d = this.root.domain.getNormalizationConstant();
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        if (d >= 0.001) {
            return HuginGUIUtils.printDouble(d, 6);
        }
        return HuginGUIUtils.printDouble(d, 6, true);
    }

    public void adapt() throws ExceptionHugin {
        HuginGUIUtils.configureDomain(this.root.domain);
        this.root.domain.propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
        this.root.domain.adapt();
        HuginGUIUtils.setUseSampledValue(this.root.domain, false);
        this.update();
        this.setTablesChanged(true);
        this.firePolicyUpdated();
    }

    public void emLearning(Preferences preferences) throws ExceptionHugin {
        EMLearningSetupPane eMLearningSetupPane = new EMLearningSetupPane(this.root.domain, preferences);
        int n = this.hugin.getWidth() / 2 - eMLearningSetupPane.getPreferredSize().width / 2;
        int n2 = this.hugin.getHeight() / 2 - eMLearningSetupPane.getPreferredSize().height / 2;
        eMLearningSetupPane.setLocation(this.hugin.getX() + n, this.hugin.getY() + n2);
        eMLearningSetupPane.pack();
        eMLearningSetupPane.setVisible(true);
        this.update();
        this.setTablesChanged(true);
    }

    public boolean transferTablesToClass() throws ExceptionHugin {
        boolean bl = this.tablesChanged();
        if (this.tablesChanged()) {
            this.root.transferTableToClass();
            this.project.getNetworkPanel().redisplayTables();
        }
        this.setTablesChanged(false);
        return bl;
    }

    public void updateColors() {
        this.root.updateColors();
        this.tree.repaint();
    }

    public void updateBeliefPrecision() {
        this.root.updateBeliefPrecision();
        ((HuginProjectFrame)this.hugin.desktop.getSelectedFrame()).getNetworkPanel().updateMonitors(false);
        this.tree.repaint();
    }

    public COM.hugin.HAPI.Node getDomainNodeFor(COM.hugin.HAPI.Node node) {
        return this.root.getDomainNodeFor(node);
    }

    public COM.hugin.HAPI.Node getSelectedNode() {
        BeliefBarNode beliefBarNode = this.tree.getSelected();
        if (beliefBarNode instanceof BeliefBarDNode || beliefBarNode instanceof BeliefBarCCNode) {
            return beliefBarNode.node;
        }
        if (beliefBarNode instanceof BeliefBarD) {
            return ((BeliefBarD)beliefBarNode).owner.node;
        }
        if (beliefBarNode instanceof BeliefBarCC) {
            return ((BeliefBarCC)beliefBarNode).owner.node;
        }
        if (beliefBarNode instanceof BeliefBarCompNode) {
            return ((BeliefBarCompNode)beliefBarNode).instanceNode;
        }
        return null;
    }

    public void setSelectedNode(COM.hugin.HAPI.Node node) {
        this.tree.selected = null;
        this.root.setSelectedNode(node, this.tree);
    }

    public void propagateIfNecessary() {
        this.tree.propagateIfNecessary();
        this.project.getNetworkPanel().updateButtonAndMenuStates();
    }

    public void writePropagationMessage(Domain.Equilibrium equilibrium, Domain.EvidenceMode evidenceMode) throws ExceptionHugin {
        double d = this.root.domain.getNormalizationConstant();
        String string = Math.abs(d) < 1.0E-4 ? HuginGUIUtils.printDouble(d, 4, true) : HuginGUIUtils.printDouble(d, 6, false);
        if (this.project.getNetworkPanel().isLIMIDs()) {
            string = string + ", EU(\u0394) = " + (Math.abs(this.root.domain.getExpectedUtility()) < 1.0E-4 ? HuginGUIUtils.printDouble(this.root.domain.getExpectedUtility(), 4, true) : HuginGUIUtils.printDouble(this.root.domain.getExpectedUtility(), 6, true));
        }
        if (equilibrium == Domain.H_EQUILIBRIUM_SUM) {
            if (evidenceMode == Domain.H_EVIDENCE_MODE_NORMAL) {
                Hugin.mainFrame.statusBar.write(HuginGUIConstants.get("PROPAGATION_sum_normal") + string);
            } else {
                Hugin.mainFrame.statusBar.write(HuginGUIConstants.get("PROPAGATION_sum_fast") + string);
            }
        } else {
            boolean bl = this.root.domain.evidenceIsPropagated();
            if (evidenceMode == Domain.H_EVIDENCE_MODE_NORMAL) {
                Hugin.mainFrame.statusBar.write((bl ? HuginGUIConstants.get("PROPAGATION_max_normal") : HuginGUIConstants.get("PROPAGATION_max_normal_no_evidence")) + string);
            } else {
                Hugin.mainFrame.statusBar.write((bl ? HuginGUIConstants.get("PROPAGATION_max_fast") : HuginGUIConstants.get("PROPAGATION_max_fast_no_evidence")) + string);
            }
        }
    }

    public void propagate(Domain.Equilibrium equilibrium, Domain.EvidenceMode evidenceMode) throws ExceptionHugin {
        HuginGUIUtils.configureDomain(this.root.domain);
        this.root.domain.resetInferenceEngine();
        if (this.project.getJunctionForest() != null) {
            for (JunctionTree junctionTree : this.root.domain.getJunctionTrees()) {
                this.rootCliques.get(junctionTree).propagate(equilibrium, evidenceMode);
            }
        } else {
            this.root.domain.propagate(equilibrium, evidenceMode);
        }
        HuginGUIUtils.setUseSampledValue(this.root.domain, false);
        String string = this.root.homeClass.getAttribute("HR_Monitor_AutoUpdGraph");
        boolean bl = string != null && string.equals("1");
        this.update(!bl);
        if (!this.PMIPropagation) {
            this.PMIPropagation = true;
            HuginGUIUtils.propagateAllCDVTLinks(this.project);
            this.PMIPropagation = false;
            this.root.update();
        }
        this.setCachedProbabilitiesInDomain(null);
        this.project.getNetworkPanel().updateButtonAndMenuStates();
        this.writePropagationMessage(equilibrium, evidenceMode);
        this.tree.paintInconcistent = false;
        this.firePolicyUpdated();
    }

    public void backupPolicies() throws ExceptionHugin {
        this.tempPolicyBackup = new HuginGUIUtils.PolicyBackup(this.root.domain);
    }

    public void clearPolicyBackup() {
        this.tempPolicyBackup = null;
    }

    public void restorePolicies() throws Exception {
        if (this.tempPolicyBackup != null) {
            this.tempPolicyBackup.restorePolicies(this.root.domain);
        }
    }

    public void storePolicies() throws ExceptionHugin {
        this.policyStorage = new HuginGUIUtils.PolicyBackup(this.root.domain);
        this.project.getNetworkPanel().updateButtonAndMenuStates();
    }

    public void recallPolicies() throws Exception {
        if (this.policyStorage != null) {
            this.policyStorage.restorePolicies(this.root.domain);
        }
        this.update();
        this.firePolicyUpdated();
        this.project.getNetworkPanel().updateButtonAndMenuStates();
    }

    public boolean storedPoliciesCompatible() throws ExceptionHugin {
        return this.policyStorage != null && this.policyStorage.compatible(this.root.domain);
    }

    public void updatePolicies() throws ExceptionHugin {
        this.root.domain.updatePolicies();
        this.update();
        this.setTablesChanged(true);
        this.firePolicyUpdated();
        this.project.getNetworkPanel().updateButtonAndMenuStates();
        this.writePropagationMessage(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
    }

    public void addPolicyUpdateListener(PolicyUpdateListener policyUpdateListener) {
        if (!this.policyListeners.contains(policyUpdateListener)) {
            this.policyListeners.add(policyUpdateListener);
        }
    }

    public void removePolicyUpdateListener(PolicyUpdateListener policyUpdateListener) {
        this.policyListeners.remove(policyUpdateListener);
    }

    protected void firePolicyUpdated() {
        for (PolicyUpdateListener policyUpdateListener : this.policyListeners) {
            policyUpdateListener.policyUpdated();
        }
    }

    public COM.hugin.HAPI.Node retractSelectedNode() {
        COM.hugin.HAPI.Node node = this.getSelectedNode();
        try {
            if (node instanceof DiscreteNode) {
                ((DiscreteNode)node).retractFindings();
            } else if (node instanceof ContinuousChanceNode) {
                ((ContinuousChanceNode)node).retractFindings();
                for (Link link : this.project.getNetworkPanel().linkList) {
                    if (!(link instanceof CDVTLink) || this.getDomainNodeFor(link.parent.getAPINode()) != node) continue;
                    IntervalDCNode intervalDCNode = (IntervalDCNode)this.getDomainNodeFor(link.child.getAPINode());
                    intervalDCNode.retractFindings();
                    this.repaint();
                    ((HuginProjectFrame)this.project.guiFrame.desktop.getSelectedFrame()).getNetworkPanel().repaint();
                }
            }
            this.propagateIfNecessary();
            this.fireEvidenceRetracted(node);
            this.firePolicyUpdated();
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        return node;
    }

    public void storeSettings() throws ExceptionHugin {
        this.allEvidence = new LinkedList();
        this.allEvidence = this.tree.storeEvidence();
        this.doPropagation = !this.root.domain.evidenceToPropagate();
    }

    public void recompileDomain(boolean bl) throws ExceptionHugin, CompilationAbortedException {
        if (this.root.domain.isCompiled()) {
            this.storeSettings();
        }
        if (bl) {
            this.root.domain.uncompile();
        }
        try {
            this.updateDomain(this.project.getNetworkPanel());
        }
        catch (ExceptionHugin exceptionHugin) {
            if (bl) {
                try {
                    HuginGUIUtils.configureDomain(this.root.domain);
                    this.root.domain.compile();
                }
                catch (ExceptionHugin exceptionHugin2) {
                    HuginGUIUtils.configureDomain(this.root.domain);
                    this.root.domain.retractFindings();
                    this.root.domain.compile();
                    this.tree.restoreEvidence(this.allEvidence);
                }
            }
            throw exceptionHugin;
        }
        this.rootCliques.clear();
        for (JunctionTree object : this.root.domain.getJunctionTrees()) {
            this.rootCliques.put(object, object.getRoot());
        }
        this.tree.restoreEvidence(this.allEvidence);
        if (this.doPropagation) {
            boolean bl2 = this.doPropagation = !this.root.domain.tablesToPropagate();
        }
        if (this.doPropagation && this.root.domain.evidenceToPropagate()) {
            HuginGUIUtils.configureDomain(this.root.domain);
            this.root.domain.resetInferenceEngine();
            this.root.domain.propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
        }
        this.project.getNetworkPanel().containsUncompiledChanges(false);
        try {
            HuginGUIUtils.setUseSampledValue(this.root.domain, false);
            this.root.update();
            this.repaint();
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        for (Link link : this.project.getNetworkPanel().linkList) {
            if (!(link instanceof CDVTLink)) continue;
            this.propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
            break;
        }
    }

    public void updateWithRecompiledDomain(Domain domain, NetworkPanel networkPanel) throws ExceptionHugin, CompilationAbortedException {
        this.root = new BeliefBarRootNode(networkPanel, this.preferences, domain, this.traverseRootPath);
        this.root.initialize();
        this.tree = new BeliefBarTree(this.root, this.hugin, this.preferences, this.project);
        Hugin.helpManager.registerComponent(this.tree, HuginHelpConstants.HELP_FILE_node_list);
        this.scroll.setViewportView(this.tree);
        for (Object object : networkPanel.nodeList) {
            if (((Node)object).monitor != null) {
                ((Node)object).monitor.updateApiNode();
            }
            if (((Node)object).policiesWindow == null) continue;
            ((Node)object).policiesWindow.updateApiNode();
        }
        this.rootCliques.clear();
        for (Object object : this.root.domain.getJunctionTrees()) {
            this.rootCliques.put((JunctionTree)object, ((JunctionTree)object).getRoot());
        }
        this.project.getNetworkPanel().containsUncompiledChanges(false);
        try {
            HuginGUIUtils.setUseSampledValue(this.root.domain, false);
            this.root.update();
            this.repaint();
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    public void recreateDomain() throws ExceptionHugin, CompilationAbortedException {
        this.recompileDomain(false);
        HuginGUIUtils.writeCliqueSize(this.root.domain);
    }

    public void update() throws ExceptionHugin {
        this.update(false);
    }

    public void update(boolean bl) throws ExceptionHugin {
        this.root.update();
        ((HuginProjectFrame)this.hugin.desktop.getSelectedFrame()).getNetworkPanel().updateMonitors(bl);
        if (bl) {
            this.project.getNetworkPanel().graphsToUpdate(true);
        }
        if (this.project.getJunctionForest() != null) {
            this.project.getJunctionForest().update();
        }
        this.repaint();
    }

    protected boolean isCompressed() throws ExceptionHugin {
        return this.root.domain.isCompressed();
    }

    public boolean evidenceIsEntered() throws ExceptionHugin {
        return this.root.domain.evidenceToPropagate() || this.root.domain.evidenceIsPropagated();
    }

    public void collapseTree() {
        this.tree.collapse();
        this.project.getNetworkPanel().deselectAllNodes(true);
    }

    public void expandTree() {
        this.tree.expand();
        this.project.getNetworkPanel().selectAllNodes(false);
    }

    public void expandNode(COM.hugin.HAPI.Node node) {
        this.expandNode(node, true);
    }

    public void expandNode(COM.hugin.HAPI.Node node, boolean bl) {
        this.tree.scrollToVisible = false;
        this.tree.ignoreExpansion = bl;
        try {
            String string = HuginGUIUtils.getNodeTitle(node);
            TreePath treePath = this.tree.treePaths.get(string);
            if (this.tree.isCollapsed(treePath)) {
                this.tree.expandPath(treePath);
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        this.tree.ignoreExpansion = false;
        this.tree.scrollToVisible = false;
    }

    public void collapseNode(COM.hugin.HAPI.Node node) {
        this.tree.scrollToVisible = false;
        this.tree.ignoreExpansion = true;
        try {
            String string = HuginGUIUtils.getNodeTitle(node);
            TreePath treePath = this.tree.treePaths.get(string);
            if (this.tree.isExpanded(treePath)) {
                this.tree.collapsePath(treePath);
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        this.tree.ignoreExpansion = false;
        this.tree.scrollToVisible = false;
    }

    public Domain getDomain() {
        return this.root.domain;
    }

    public void setRootName(String string) {
        this.root.name = string;
    }

    protected boolean isSeparated(COM.hugin.HAPI.Node node, COM.hugin.HAPI.Node node2) throws ExceptionHugin {
        return this.getDomain().areNodesSeparated(this.getDomainNodeFor(node), this.getDomainNodeFor(node2));
    }

    protected boolean isSeparated(COM.hugin.HAPI.Node node, COM.hugin.HAPI.Node node2, NodeList nodeList) throws ExceptionHugin {
        return this.getDomain().areNodesSeparated(this.getDomainNodeFor(node), this.getDomainNodeFor(node2), nodeList);
    }

    protected boolean hasEvidence(COM.hugin.HAPI.Node node) throws ExceptionHugin {
        return this.getDomainNodeFor(node).evidenceIsEntered();
    }

    protected boolean hasLikelihood(COM.hugin.HAPI.Node node) throws ExceptionHugin {
        return this.getDomainNodeFor(node).likelihoodIsEntered();
    }

    private double[] getAllProbabilities() throws ExceptionHugin {
        double[] dArray = this.getCachedProbabilitiesInDomain();
        if (dArray != null) {
            return dArray;
        }
        int n = 0;
        NodeList nodeList = this.getDomain().getNodes();
        for (COM.hugin.HAPI.Node node : nodeList) {
            if (!(node instanceof DiscreteChanceNode)) continue;
            n += ((DiscreteNode)node).getNumberOfStates();
        }
        Object object = new double[n];
        int n2 = 0;
        for (COM.hugin.HAPI.Node node : nodeList) {
            if (!(node instanceof DiscreteChanceNode)) continue;
            int n3 = ((DiscreteChanceNode)node).getNumberOfStates();
            for (int i = 0; i < n3; ++i) {
                object[n2++] = ((DiscreteChanceNode)node).getBelief(i);
            }
        }
        this.setCachedProbabilitiesInDomain((double[])object);
        return object;
    }

    public LinkedList<ConflictResolutionHypothesis> getConflictResolutions(double d) throws ExceptionHugin {
        double[] dArray = this.getAllProbabilities();
        ListIterator listIterator = this.getDomain().getNodes().listIterator();
        COM.hugin.HAPI.Node node = (COM.hugin.HAPI.Node)listIterator.next();
        int n = 0;
        LinkedList<ConflictResolutionHypothesis> linkedList = new LinkedList<ConflictResolutionHypothesis>();
        for (int i = 0; i < this.priors.length; ++i) {
            double d2;
            while (!(node instanceof DiscreteChanceNode) && listIterator.hasNext()) {
                node = (COM.hugin.HAPI.Node)listIterator.next();
            }
            if (this.priors[i] != 0.0 && dArray[i] != 0.0 && !node.evidenceIsEntered() && (d2 = Math.log(dArray[i] / this.priors[i])) > d) {
                linkedList.add(new ConflictResolutionHypothesis(this, (DiscreteChanceNode)node, n, d2, d));
            }
            if (++n < ((DiscreteNode)node).getNumberOfStates() || i >= this.priors.length - 1) continue;
            n = 0;
            node = (COM.hugin.HAPI.Node)listIterator.next();
        }
        return linkedList;
    }

    public void setRootClique(JunctionTree junctionTree, Clique clique) throws ExceptionHugin {
        this.rootCliques.put(junctionTree, clique);
        this.propagateIfNecessary();
    }

    public void showPrivateForSelected(boolean bl) throws ExceptionHugin {
        this.tree.showPrivateForSelected(bl);
    }

    public boolean showPrivateForSelected() throws ExceptionHugin {
        return this.tree.showPrivateForSelected();
    }

    public HuginProjectFrame getProjectFrame() {
        return this.project;
    }

    public void addEvidenceListener(EvidenceListener evidenceListener) {
        if (this.evidenceListeners == null) {
            this.evidenceListeners = new LinkedList();
        }
        this.evidenceListeners.add(evidenceListener);
    }

    public void removeEvidenceListener(EvidenceListener evidenceListener) {
        if (this.evidenceListeners != null) {
            this.evidenceListeners.remove(evidenceListener);
        }
    }

    protected void fireEvidenceEntered(COM.hugin.HAPI.Node node) {
        if (this.evidenceListeners != null) {
            for (EvidenceListener evidenceListener : this.evidenceListeners) {
                evidenceListener.evidenceEntered(node);
            }
        }
    }

    protected void fireEvidenceRetracted(COM.hugin.HAPI.Node node) {
        if (this.evidenceListeners != null) {
            for (EvidenceListener evidenceListener : this.evidenceListeners) {
                evidenceListener.evidenceRetracted(node);
            }
        }
    }

    protected static interface EvidenceListener {
        public void evidenceEntered(COM.hugin.HAPI.Node var1);

        public void evidenceRetracted(COM.hugin.HAPI.Node var1);
    }

    public static interface PolicyUpdateListener {
        public void policyUpdated();
    }
}

