/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.ContinuousChanceNode;
import COM.hugin.HAPI.DiscreteChanceNode;
import COM.hugin.HAPI.DiscreteNode;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.ExceptionObjectNotAlive;
import COM.hugin.HGUI.BeliefBarCC;
import COM.hugin.HGUI.BeliefBarCCNode;
import COM.hugin.HGUI.BeliefBarCompNode;
import COM.hugin.HGUI.BeliefBarD;
import COM.hugin.HGUI.BeliefBarDNode;
import COM.hugin.HGUI.BeliefBarFunction;
import COM.hugin.HGUI.BeliefBarFunctionNode;
import COM.hugin.HGUI.BeliefBarNode;
import COM.hugin.HGUI.BeliefBarNodePainter;
import COM.hugin.HGUI.BeliefBarPopupMenu;
import COM.hugin.HGUI.BeliefBarRootNode;
import COM.hugin.HGUI.BeliefBarTreeModel;
import COM.hugin.HGUI.BeliefBarUtility;
import COM.hugin.HGUI.BeliefBarUtilityNode;
import COM.hugin.HGUI.BeliefMonitor;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIFrame;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.HuginProjectFrame;
import COM.hugin.HGUI.InsertContinuousFindingPanel;
import COM.hugin.HGUI.NetworkPanel;
import COM.hugin.HGUI.Node;
import COM.hugin.HGUI.Preferences;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeliefBarTree
extends JTree {
    HuginGUIFrame huginFrame;
    HuginProjectFrame huginProjectFrame;
    BeliefBarRootNode root;
    BeliefBarNode selected;
    BeliefBarPopupMenu popup;
    int evidence;
    int treeWidth = 0;
    Domain domain;
    Preferences preferences;
    Hashtable<String, TreePath> treePaths;
    Collection<TreePath> allTreePaths;
    boolean ignoreExpansion = false;
    boolean scrollToVisible = false;
    boolean paintInconcistent = false;

    public BeliefBarTree(BeliefBarRootNode beliefBarRootNode, HuginGUIFrame huginGUIFrame, Preferences preferences, HuginProjectFrame huginProjectFrame) {
        super(new BeliefBarTreeModel(beliefBarRootNode));
        this.root = beliefBarRootNode;
        this.huginFrame = huginGUIFrame;
        this.preferences = preferences;
        beliefBarRootNode.theTree = this;
        this.selected = null;
        this.evidence = 0;
        this.huginProjectFrame = huginProjectFrame;
        this.allTreePaths = this.getAllPaths();
        this.popup = new BeliefBarPopupMenu(huginGUIFrame);
        this.setRowHeight(0);
        this.setShowsRootHandles(true);
        this.setToggleClickCount(1000000);
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.setCellRenderer(new BeliefBarNodeRenderer());
        BeliefBarMouseListener beliefBarMouseListener = new BeliefBarMouseListener(this, this.huginProjectFrame);
        this.addMouseListener(beliefBarMouseListener);
        this.addMouseMotionListener(beliefBarMouseListener);
        this.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                TreePath treePath = treeExpansionEvent.getPath();
                if (treePath.getPathCount() == 2) {
                    BeliefBarTree.this.selected = (BeliefBarNode)treePath.getLastPathComponent();
                }
                BeliefBarNode beliefBarNode = (BeliefBarNode)treePath.getLastPathComponent();
                if (BeliefBarTree.this.ignoreExpansion) {
                    return;
                }
                if (BeliefBarTree.this.scrollToVisible) {
                    BeliefBarTree.this.scrollPathToVisible(treePath);
                    return;
                }
                try {
                    if (treePath.getPathCount() > 2) {
                        return;
                    }
                    if (beliefBarNode.getNode() != null && !BeliefBarTree.this.huginProjectFrame.getNetworkPanel().nodeIsSelected(beliefBarNode.getOriginalNode().getName())) {
                        BeliefBarTree.this.huginProjectFrame.getNetworkPanel().selectNode(beliefBarNode.getOriginalNode().getName());
                    } else if (beliefBarNode instanceof BeliefBarCompNode && !BeliefBarTree.this.huginProjectFrame.getNetworkPanel().nodeIsSelected(beliefBarNode.name)) {
                        BeliefBarTree.this.huginProjectFrame.getNetworkPanel().selectNode(((BeliefBarCompNode)beliefBarNode).instanceNodeName);
                    }
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
            }

            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                if (BeliefBarTree.this.selected != null && BeliefBarTree.this.isCollapsed(new TreePath(BeliefBarTree.this.selected.getPath()))) {
                    BeliefBarTree.this.selected = null;
                }
                if (BeliefBarTree.this.ignoreExpansion) {
                    return;
                }
                try {
                    if (treeExpansionEvent.getPath().getPathCount() > 2) {
                        return;
                    }
                    BeliefBarNode beliefBarNode = (BeliefBarNode)treeExpansionEvent.getPath().getLastPathComponent();
                    NetworkPanel networkPanel = BeliefBarTree.this.huginProjectFrame.getNetworkPanel();
                    if (beliefBarNode.getNode() != null && networkPanel.nodeIsSelected(beliefBarNode.getOriginalNode().getName())) {
                        networkPanel.deselectNode(beliefBarNode.getOriginalNode().getName());
                    } else if (beliefBarNode instanceof BeliefBarCompNode && networkPanel.nodeIsSelected(((BeliefBarCompNode)beliefBarNode).instanceNodeName)) {
                        networkPanel.deselectNode(((BeliefBarCompNode)beliefBarNode).instanceNodeName);
                    }
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
            }
        });
        this.mapPaths();
        this.setBackground(Color.white);
        this.setForeground(Color.white);
    }

    @Override
    public Enumeration<TreePath> getExpandedDescendants(TreePath treePath) {
        return null;
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent) {
        keyEvent.consume();
    }

    private void mapPaths() {
        this.treePaths = new Hashtable();
        TreeModel treeModel = this.getModel();
        BeliefBarNode beliefBarNode = (BeliefBarNode)treeModel.getRoot();
        this.mapNode(beliefBarNode, this.treePaths, "");
    }

    private void mapNode(BeliefBarNode beliefBarNode, Hashtable<String, TreePath> hashtable, String string) {
        Object object;
        try {
            if (beliefBarNode.getNode() != null) {
                object = HuginGUIUtils.getNodeTitle(beliefBarNode.getOriginalNode());
                hashtable.put((String)object, new TreePath(beliefBarNode.getPath()));
            }
            if (beliefBarNode instanceof BeliefBarCompNode) {
                hashtable.put(beliefBarNode.name, new TreePath(beliefBarNode.getPath()));
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        if (beliefBarNode.getPath().length == 1) {
            object = beliefBarNode.children();
            while (object.hasMoreElements()) {
                this.mapNode((BeliefBarNode)object.nextElement(), hashtable, string);
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Rectangle rectangle = this.getRowBounds(this.getRowCount() - 1);
        if (this.treeWidth == 0) {
            this.treeWidth = this.getMaxWidth(this.root, 0, 1);
        }
        return new Dimension(this.treeWidth + 10, rectangle.y + 16 + 10);
    }

    private int getMaxWidth(BeliefBarNode beliefBarNode, int n, int n2) {
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return 0;
        }
        int n3 = n2 * 20;
        int n4 = beliefBarNode.getWidth(graphics);
        if (n3 + n4 > n) {
            n = n3 + n4;
        }
        Enumeration<TreeNode> enumeration = beliefBarNode.children();
        while (enumeration.hasMoreElements()) {
            n4 = this.getMaxWidth((BeliefBarNode)enumeration.nextElement(), n, n2 + 1);
            if (n4 <= n) continue;
            n = n4;
        }
        return n;
    }

    void collapse() {
        Enumeration<TreeNode> enumeration = this.root.children();
        while (enumeration.hasMoreElements()) {
            this.collapseNode((BeliefBarNode)enumeration.nextElement());
        }
    }

    private void collapseNode(BeliefBarNode beliefBarNode) {
        Object object = beliefBarNode.children();
        while (object.hasMoreElements()) {
            this.collapseNode((BeliefBarNode)object.nextElement());
        }
        object = new TreePath(beliefBarNode.getPath());
        if (!this.isCollapsed((TreePath)object)) {
            this.collapsePath((TreePath)object);
        }
    }

    void expand() {
        this.ignoreExpansion = true;
        Date date = new Date();
        long l = date.getTime();
        for (TreePath treePath : this.allTreePaths) {
            if (!this.isCollapsed(treePath)) continue;
            this.expandPath(treePath);
        }
        date = new Date();
        long l2 = date.getTime();
        this.ignoreExpansion = false;
    }

    private Collection<TreePath> getAllPaths() {
        LinkedList<TreePath> linkedList = new LinkedList<TreePath>();
        this.root.getAllPaths(this, linkedList);
        return linkedList;
    }

    public BeliefBarNode getSelected() {
        return this.selected;
    }

    boolean propagateIfNecessary() {
        boolean bl = false;
        try {
            String string = this.root.homeClass.getAttribute("HR_Propagate_Auto");
            if (string != null && string.equals("1")) {
                this.propagate();
                bl = true;
            }
        }
        catch (ExceptionObjectNotAlive exceptionObjectNotAlive) {
            new HuginGUIError(exceptionObjectNotAlive);
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin.getMessage());
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        return bl;
    }

    protected void propagate() throws ExceptionHugin {
        String string;
        Domain.Equilibrium equilibrium = Domain.H_EQUILIBRIUM_SUM;
        Domain.EvidenceMode evidenceMode = Domain.H_EVIDENCE_MODE_NORMAL;
        String string2 = this.root.homeClass.getAttribute("HR_Propagate_AutoSum");
        if (string2 != null && string2.equals("0")) {
            equilibrium = Domain.H_EQUILIBRIUM_MAX;
        }
        if ((string = this.root.homeClass.getAttribute("HR_Propagate_AutoNormal")) != null && string.equals("0")) {
            evidenceMode = Domain.H_EVIDENCE_MODE_FAST_RETRACTION;
        }
        this.huginProjectFrame.beliefBars.propagate(equilibrium, evidenceMode);
        HuginGUIUtils.setUseSampledValue(this.root.domain, false);
        this.root.update();
        this.huginProjectFrame.getNetworkPanel().updateMonitors(true);
        this.root.network.updateButtonAndMenuStates();
        if (this.huginProjectFrame.getJunctionForest() != null) {
            this.huginProjectFrame.getJunctionForest().update();
        }
    }

    protected LinkedList<Evidence> storeEvidence() {
        LinkedList<Evidence> linkedList = new LinkedList<Evidence>();
        this.storeEvidence(this.root, linkedList);
        return linkedList;
    }

    private void storeEvidence(BeliefBarNode beliefBarNode, LinkedList<Evidence> linkedList) {
        boolean bl = this.isExpanded(new TreePath(beliefBarNode.getPath()));
        boolean bl2 = beliefBarNode.getChildCount() > 0 ? this.isExpanded(new TreePath(((BeliefBarNode)beliefBarNode.getFirstChild()).getPath())) : false;
        Evidence evidence = null;
        try {
            evidence = new Evidence(beliefBarNode.getNode(), bl, bl2);
        }
        catch (Exception exception) {
            evidence = null;
        }
        if (evidence.evidence != null) {
            linkedList.add(evidence);
        }
        int n = beliefBarNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            this.storeEvidence((BeliefBarNode)beliefBarNode.getChildAt(i), linkedList);
        }
    }

    protected void restoreEvidence(LinkedList<Evidence> linkedList) {
        this.restoreEvidence(this.root, linkedList);
    }

    private void restoreEvidence(BeliefBarNode beliefBarNode, LinkedList<Evidence> linkedList) {
        try {
            COM.hugin.HAPI.Node node = beliefBarNode.getNode();
            if (node != null) {
                String string = node.getName();
                ListIterator listIterator = linkedList.listIterator();
                while (listIterator.hasNext()) {
                    Evidence evidence = (Evidence)listIterator.next();
                    if (!evidence.equals(string)) continue;
                    this.restoreEvidence(beliefBarNode, node, evidence);
                    listIterator.remove();
                }
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        for (int i = 0; i < beliefBarNode.getChildCount(); ++i) {
            this.restoreEvidence((BeliefBarNode)beliefBarNode.getChildAt(i), linkedList);
        }
    }

    private void restoreEvidence(BeliefBarNode beliefBarNode, COM.hugin.HAPI.Node node, Evidence evidence) {
        if (node instanceof DiscreteNode) {
            this.restoreEvidence(beliefBarNode, (DiscreteNode)node, evidence);
        } else if (node instanceof ContinuousChanceNode) {
            this.restoreEvidence(beliefBarNode, (ContinuousChanceNode)node, evidence);
        }
    }

    private void restoreEvidence(BeliefBarNode beliefBarNode, DiscreteNode discreteNode, Evidence evidence) {
        try {
            ListIterator listIterator = evidence.evidence.listIterator();
            if (evidence.expanded) {
                this.expandPath(new TreePath(beliefBarNode.getPath()));
            }
            int n = discreteNode.getNumberOfStates();
            for (int i = 0; i < n && listIterator.hasNext(); ++i) {
                discreteNode.enterFinding(i, (Double)listIterator.next());
                if (!evidence.statesExpanded) continue;
                this.expandPath(new TreePath(((BeliefBarNode)beliefBarNode.getChildAt(i)).getPath()));
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    private void restoreEvidence(BeliefBarNode beliefBarNode, ContinuousChanceNode continuousChanceNode, Evidence evidence) {
        try {
            if (evidence.expanded) {
                this.expandPath(new TreePath(beliefBarNode.getPath()));
            }
            for (int i = 0; i < beliefBarNode.getChildCount(); ++i) {
                if (!evidence.statesExpanded) continue;
                this.expandPath(new TreePath(((BeliefBarNode)beliefBarNode.getChildAt(i)).getPath()));
            }
            if (evidence.evidence.size() > 0) {
                continuousChanceNode.enterValue(evidence.evidence.get(0));
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    public void showPrivateForSelected(boolean bl) throws ExceptionHugin {
        ((BeliefBarTreeModel)this.getModel()).showPrivate(bl, this.getSelected());
    }

    public boolean showPrivateForSelected() throws ExceptionHugin {
        return this.getSelected().showPrivate();
    }

    private class BeliefBarMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        BeliefBarTree root;
        HuginProjectFrame huginProjectFrame;

        public BeliefBarMouseListener(BeliefBarTree beliefBarTree2, HuginProjectFrame huginProjectFrame) {
            this.huginProjectFrame = huginProjectFrame;
            this.root = beliefBarTree2;
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n = this.root.getClosestRowForLocation(0, mouseEvent.getY());
            TreePath treePath = this.root.getPathForRow(n);
            BeliefBarNode beliefBarNode = (BeliefBarNode)treePath.getPathComponent(treePath.getPathCount() - 1);
            if (beliefBarNode instanceof BeliefBarD || beliefBarNode instanceof BeliefBarUtility) {
                Rectangle rectangle = this.root.getRowBounds(n);
                BeliefBarNodePainter.width = mouseEvent.getX() - rectangle.x;
                if (BeliefBarNodePainter.width < 50) {
                    BeliefBarNodePainter.width = 50;
                }
                this.root.repaint();
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            DiscreteNode discreteNode;
            int n = this.root.getClosestRowForLocation(0, mouseEvent.getY());
            TreePath treePath = this.root.getPathForRow(n);
            BeliefBarNode beliefBarNode = (BeliefBarNode)treePath.getPathComponent(treePath.getPathCount() - 1);
            COM.hugin.HAPI.Node node = null;
            Node node2 = null;
            boolean bl = false;
            this.root.setSelectionPath(treePath);
            this.root.selected = beliefBarNode;
            if (beliefBarNode instanceof BeliefBarDNode && mouseEvent.getClickCount() % 1 == 0 && ((BeliefBarDNode)beliefBarNode).node instanceof DiscreteChanceNode) {
                try {
                    discreteNode = (DiscreteChanceNode)((BeliefBarDNode)beliefBarNode).node;
                    Domain domain = discreteNode.getHomeDomain();
                    if (domain.equilibriumIs(Domain.H_EQUILIBRIUM_SUM) && domain.evidenceModeIs(Domain.H_EVIDENCE_MODE_NORMAL)) {
                        String string = HuginGUIUtils.getNodeTitle(discreteNode);
                        try {
                            double d = discreteNode.getEntropy();
                            NetworkPanel networkPanel = this.huginProjectFrame.getNetworkPanel();
                            int n2 = networkPanel.guiFrame.preferences.precision;
                            String string2 = HuginGUIUtils.printDouble(d, n2);
                            String string3 = "H(" + string + ") = " + string2;
                            Double d2 = HuginGUIUtils.average((DiscreteChanceNode)discreteNode, networkPanel, false);
                            if (!d2.isNaN()) {
                                string3 = string3 + ", " + HuginGUIConstants.get("Avg") + " (" + string + ") = " + HuginGUIUtils.printDouble(d2, n2);
                                Double d3 = HuginGUIUtils.variance((DiscreteChanceNode)discreteNode, networkPanel);
                                if (!d3.isNaN()) {
                                    string3 = string3 + ", " + HuginGUIConstants.get("Var") + " (" + string + ") = " + HuginGUIUtils.printDouble(d3, n2);
                                }
                            }
                            networkPanel.writeStatus(string3);
                        }
                        catch (Exception exception) {
                            this.huginProjectFrame.getNetworkPanel().writeStatus("");
                        }
                    }
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
            }
            if (mouseEvent.getClickCount() % 2 == 0) {
                if (beliefBarNode instanceof BeliefBarDNode || beliefBarNode instanceof BeliefBarCompNode || beliefBarNode instanceof BeliefBarUtilityNode || beliefBarNode instanceof BeliefBarCCNode || beliefBarNode instanceof BeliefBarFunctionNode) {
                    if (this.root.isExpanded(n)) {
                        this.root.collapseRow(n);
                    } else {
                        this.root.expandRow(n);
                    }
                }
                if (beliefBarNode instanceof BeliefBarD) {
                    try {
                        discreteNode = (DiscreteNode)((BeliefBarD)beliefBarNode).owner.node;
                        if (discreteNode.evidenceIsEntered() && discreteNode.getEnteredFinding(((BeliefBarD)beliefBarNode).state) > 0.0) {
                            discreteNode.retractFindings();
                            BeliefBarTree.this.huginProjectFrame.getBeliefBarPanel().fireEvidenceRetracted(discreteNode);
                        } else {
                            discreteNode.selectState(((BeliefBarD)beliefBarNode).state);
                            BeliefBarTree.this.huginProjectFrame.getBeliefBarPanel().fireEvidenceEntered(discreteNode);
                        }
                        BeliefBarTree.this.huginProjectFrame.getBeliefBarPanel().firePolicyUpdated();
                        this.root.propagateIfNecessary();
                        bl = true;
                    }
                    catch (Exception exception) {
                        new HuginGUIError(exception);
                    }
                }
                if (beliefBarNode instanceof BeliefBarCC) {
                    new InsertContinuousFindingPanel((ContinuousChanceNode)((BeliefBarCC)beliefBarNode).owner.node, BeliefBarTree.this.huginProjectFrame);
                    BeliefBarTree.this.huginProjectFrame.getBeliefBarPanel().fireEvidenceEntered(((BeliefBarCC)beliefBarNode).owner.node);
                    this.root.propagateIfNecessary();
                    bl = true;
                }
                Hugin.mainFrame.repaint();
            }
            if (mouseEvent.getModifiers() == 4) {
                if (beliefBarNode instanceof BeliefBarDNode) {
                    node = ((BeliefBarDNode)beliefBarNode).node;
                    node2 = beliefBarNode.guiNode;
                } else if (beliefBarNode instanceof BeliefBarD) {
                    node = ((BeliefBarD)beliefBarNode).owner.node;
                    node2 = ((BeliefBarD)beliefBarNode).owner.guiNode;
                } else if (beliefBarNode instanceof BeliefBarCCNode) {
                    node = ((BeliefBarCCNode)beliefBarNode).node;
                    node2 = beliefBarNode.guiNode;
                } else if (beliefBarNode instanceof BeliefBarCC) {
                    node = ((BeliefBarCC)beliefBarNode).owner.node;
                    node2 = ((BeliefBarCC)beliefBarNode).owner.guiNode;
                } else if (beliefBarNode instanceof BeliefBarUtilityNode) {
                    node = ((BeliefBarUtilityNode)beliefBarNode).node;
                    node2 = beliefBarNode.guiNode;
                } else if (beliefBarNode instanceof BeliefBarUtility) {
                    node = ((BeliefBarUtility)beliefBarNode).owner.node;
                    node2 = ((BeliefBarUtility)beliefBarNode).owner.guiNode;
                } else if (beliefBarNode instanceof BeliefBarFunctionNode) {
                    node = ((BeliefBarFunctionNode)beliefBarNode).node;
                    node2 = beliefBarNode.guiNode;
                } else if (beliefBarNode instanceof BeliefBarFunction) {
                    node = ((BeliefBarFunction)beliefBarNode).owner.node;
                    node2 = ((BeliefBarFunction)beliefBarNode).owner.guiNode;
                }
                try {
                    this.root.popup.prepareFor(node, node2, this.root.root.domain);
                    this.root.popup.pack();
                    BeliefMonitor.showPopupCorrectly(this.root.popup, mouseEvent);
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
            }
            this.root.repaint();
            if (bl) {
                this.huginProjectFrame.getNetworkPanel().updateMonitors();
            }
            this.huginProjectFrame.getNetworkPanel().updateButtonAndMenuStates();
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }
    }

    protected class Evidence {
        boolean expanded;
        boolean statesExpanded;
        LinkedList<Double> evidence;
        String name;

        public Evidence(COM.hugin.HAPI.Node node, boolean bl, boolean bl2) {
            if (node == null || !node.isAlive()) {
                return;
            }
            try {
                ContinuousChanceNode continuousChanceNode;
                this.expanded = bl;
                this.statesExpanded = bl2;
                this.name = node.getName();
                this.evidence = new LinkedList();
                if (node instanceof DiscreteNode) {
                    DiscreteNode discreteNode = (DiscreteNode)node;
                    int n = discreteNode.getNumberOfStates();
                    for (int i = 0; i < n; ++i) {
                        this.evidence.add(new Double(discreteNode.getEnteredFinding(i)));
                    }
                } else if (node instanceof ContinuousChanceNode && (continuousChanceNode = (ContinuousChanceNode)node).evidenceIsEntered()) {
                    this.evidence.add(new Double(continuousChanceNode.getEnteredValue()));
                }
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }

        public boolean equals(Object object) {
            return object.equals(this.name);
        }
    }

    class BeliefBarNodeRenderer
    implements TreeCellRenderer {
        BeliefBarNodeRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            BeliefBarNodePainter beliefBarNodePainter = ((BeliefBarNode)object).getPainter();
            beliefBarNodePainter.theTree = (BeliefBarTree)jTree;
            beliefBarNodePainter.setSelected(bl);
            return beliefBarNodePainter;
        }
    }
}

