/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.DiscreteChanceNode;
import COM.hugin.HAPI.DiscreteDecisionNode;
import COM.hugin.HAPI.DiscreteNode;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionCGLIMIDsNotSupported;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.IntervalDCNode;
import COM.hugin.HAPI.NumberedDCNode;
import COM.hugin.HAPI.Table;
import COM.hugin.HGUI.BeliefBarNodePainter;
import COM.hugin.HGUI.BeliefBarPanel;
import COM.hugin.HGUI.ContinuousChanceNode;
import COM.hugin.HGUI.ContinuousChanceNodeMonitorModel;
import COM.hugin.HGUI.DiscreteChanceNodeMonitorModel;
import COM.hugin.HGUI.DiscreteDecisionNodeMonitorModel;
import COM.hugin.HGUI.FunctionNode;
import COM.hugin.HGUI.FunctionNodeMonitorModel;
import COM.hugin.HGUI.HStroke;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIEventHandler;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.HuginProjectFrame;
import COM.hugin.HGUI.JLongMenu;
import COM.hugin.HGUI.NetworkPanel;
import COM.hugin.HGUI.Node;
import COM.hugin.HGUI.PastingTextField;
import COM.hugin.HGUI.Preferences;
import COM.hugin.HGUI.UtilityNode;
import COM.hugin.HGUI.UtilityNodeMonitorModel;
import COM.hugin.HGUI.zoom.ZoomableButton;
import COM.hugin.HGUI.zoom.ZoomableCombobox;
import COM.hugin.HGUI.zoom.ZoomableScrollPane;
import COM.hugin.HGUI.zoom.ZoomableSlider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.basic.BasicInternalFrameUI;

public class BeliefMonitor
extends JInternalFrame {
    Node node;
    COM.hugin.HAPI.Node apiNode;
    BeliefMonitorPanel panel;
    static final int BELIEF_BAR = 0;
    static final int FINDING_BAR = 1;
    static final int INCONSISTENT_BAR = 2;
    static final int LIKELIHOOD_BAR = 3;
    static final int LOCKED_EVIDENCE_BAR = 4;
    static final int UTILITY_BAR = 5;
    private static final int SAFETY_MARGIN = 10;
    int initialMaxHeight = 16;
    int initialMaxWidth = 200;
    int sizePerState = 12;
    double scaleFactor = 1.0;
    HuginProjectFrame project;
    ZoomableScrollPane scroller;
    JPanel interior = null;
    int barsLayout = -1;
    boolean chanceHasUtility = false;
    boolean displayMeanVariance = false;
    private boolean printVisibleMonitor = false;
    int mouseX;
    int mouseY;
    int actualHeight;
    int actualWidth;
    private Dimension maxSize;
    public static final int NORMAL = 0;
    public static final int ABS_DELTA = 1;
    public static final int PERCENTAGE_DELTA = 2;
    public static final int MIXED_MODE = 3;
    public static final int DENSITY_MODE = 4;
    BeliefMonitor outer = this;

    public BeliefMonitor(Node node, HuginProjectFrame huginProjectFrame) throws ExceptionHugin {
        super(HuginGUIUtils.getNodeTitle(node.getAPINode(), (short)0), true, true);
        this.node = node;
        this.project = huginProjectFrame;
        this.setUI(new BeliefMonitorUI(this));
        this.scaleFactor = this.scaleFactor;
        BeliefBarPanel beliefBarPanel = huginProjectFrame.getBeliefBarPanel();
        Domain domain = beliefBarPanel.getDomain();
        this.addComponentListener(new ComponentAdapter(){

            public void componentMoved(ComponentEvent componentEvent) {
                BeliefMonitor.this.node.setMonitorLocation(componentEvent.getComponent().getLocation());
                BeliefMonitor.this.repaint();
            }
        });
        this.apiNode = beliefBarPanel.getDomainNodeFor(node.getAPINode());
        if (node instanceof UtilityNode) {
            this.createUtilityMonitor((UtilityNode)node, huginProjectFrame);
        } else if (node instanceof FunctionNode) {
            this.createFunctionMonitor((FunctionNode)node, huginProjectFrame);
        } else if (node instanceof ContinuousChanceNode) {
            this.createContMonitor((ContinuousChanceNode)node, huginProjectFrame);
        } else {
            this.createDiscMonitor(node, huginProjectFrame);
        }
    }

    private void createDiscMonitor(Node node, HuginProjectFrame huginProjectFrame) throws ExceptionHugin {
        int n;
        if (!(this.apiNode instanceof DiscreteNode)) {
            return;
        }
        this.panel = new BeliefMonitorDPanel((DiscreteNode)this.apiNode, huginProjectFrame, node);
        String string = huginProjectFrame.getNetworkPanel().getHome().getAttribute("HR_Monitor_InitStates");
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            n = 2;
        }
        this.scroller = new ZoomableScrollPane(this.panel);
        this.scroller.getVerticalScrollBar().setUnitIncrement(5);
        this.scroller.setBackground(Color.white);
        this.scroller.getViewport().setBackground(Color.white);
        this.setBackground(Color.white);
        this.getContentPane().add(this.scroller);
        this.setMinimumSize(this.calculateMinSize());
        int n2 = (int)Math.rint(this.scaleFactor * (double)(this.sizePerState * n + this.initialMaxHeight)) + ((BeliefMonitorUI)this.getUI()).getTitleHeight();
        int n3 = this.getPreferredSize().width;
        this.pack();
        if (this.getPreferredSize().height > n2) {
            this.setSize(new Dimension(n3 += this.scroller.getVerticalScrollBar().getPreferredSize().width, n2));
        }
        this.setSelected(false);
    }

    private void createUtilityMonitor(Node node, HuginProjectFrame huginProjectFrame) throws ExceptionHugin {
        int n;
        if (!(this.apiNode instanceof COM.hugin.HAPI.UtilityNode)) {
            return;
        }
        this.panel = new BeliefMonitorUtilityPanel((COM.hugin.HAPI.UtilityNode)this.apiNode, huginProjectFrame, node);
        String string = huginProjectFrame.getNetworkPanel().getHome().getAttribute("HR_Monitor_InitStates");
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            n = 2;
        }
        this.scroller = new ZoomableScrollPane(this.panel);
        this.scroller.getVerticalScrollBar().setUnitIncrement(5);
        this.scroller.setBackground(Color.white);
        this.scroller.getViewport().setBackground(Color.white);
        this.setBackground(Color.white);
        this.getContentPane().add(this.scroller);
        this.setMinimumSize(this.calculateMinSize());
        int n2 = (int)Math.rint(this.scaleFactor * (double)(this.sizePerState * n + this.initialMaxHeight)) + ((BeliefMonitorUI)this.getUI()).getTitleHeight();
        int n3 = this.getPreferredSize().width;
        this.pack();
        if (this.getPreferredSize().height > n2) {
            this.setSize(new Dimension(n3 += this.scroller.getVerticalScrollBar().getPreferredSize().width, n2));
        }
        this.setSelected(false);
    }

    private void createFunctionMonitor(Node node, HuginProjectFrame huginProjectFrame) throws ExceptionHugin {
        int n;
        if (!(this.apiNode instanceof COM.hugin.HAPI.FunctionNode)) {
            return;
        }
        this.panel = new BeliefMonitorFunctionPanel((COM.hugin.HAPI.FunctionNode)this.apiNode, huginProjectFrame, node);
        String string = huginProjectFrame.getNetworkPanel().getHome().getAttribute("HR_Monitor_InitStates");
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            n = 2;
        }
        this.scroller = new ZoomableScrollPane(this.panel);
        this.scroller.getVerticalScrollBar().setUnitIncrement(5);
        this.scroller.setBackground(Color.white);
        this.scroller.getViewport().setBackground(Color.white);
        this.setBackground(Color.white);
        this.getContentPane().add(this.scroller);
        this.setMinimumSize(this.calculateMinSize());
        int n2 = (int)Math.rint(this.scaleFactor * (double)(this.sizePerState * n + this.initialMaxHeight)) + ((BeliefMonitorUI)this.getUI()).getTitleHeight();
        int n3 = this.getPreferredSize().width;
        this.pack();
        if (this.getPreferredSize().height > n2) {
            this.setSize(new Dimension(n3 += this.scroller.getVerticalScrollBar().getPreferredSize().width, n2));
        }
        this.setSelected(false);
    }

    private void createContMonitor(ContinuousChanceNode continuousChanceNode, HuginProjectFrame huginProjectFrame) throws ExceptionHugin {
        this.setResizable(false);
        this.panel = new BeliefMonitorCCPanel((COM.hugin.HAPI.ContinuousChanceNode)this.apiNode, huginProjectFrame, continuousChanceNode);
        ((BeliefMonitorCCPanel)this.panel).initialize();
        this.setBackground(Color.white);
        this.setSize(this.getPreferredSize());
        this.setSelected(false);
        this.pack();
    }

    private Dimension calculateMaxSize() {
        Dimension dimension = this.getPreferredSize();
        dimension.width += this.scroller.getVerticalScrollBar().getPreferredSize().width;
        dimension.height += this.scroller.getHorizontalScrollBar().getPreferredSize().height;
        return dimension;
    }

    private Dimension calculateMinSize() {
        int n = (int)Math.rint(this.scaleFactor * (double)this.initialMaxWidth / 2.0);
        int n2 = (int)Math.rint(this.scaleFactor * (double)(this.sizePerState * 2 + this.initialMaxHeight)) + ((BeliefMonitorUI)this.getUI()).getTitleHeight();
        return new Dimension(n, n2);
    }

    private void setMaxSize(Dimension dimension) {
        Dimension dimension2 = new Dimension(dimension);
        this.setMaximumSize(dimension);
    }

    public void setDisplayMode(int n) {
        this.panel.setDisplayMode(n);
    }

    public int getDisplayMode() {
        return this.panel.getDisplayMode();
    }

    public void setNotAlive() {
        this.panel.setIsAlive(false);
    }

    public void setSelected(boolean bl) {
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.updateApiNode();
        }
        if (this.panel != null) {
            try {
                this.panel.repaint();
                this.panel.setSize(this.panel.getPreferredSize());
                this.revalidate();
                int n = this.getPreferredSize().width;
                int n2 = this.getSize().height;
                if (this.getPreferredSize().height > n2) {
                    n += this.scroller.getVerticalScrollBar().getPreferredSize().width;
                }
                if (this.getPreferredSize().height < n2) {
                    n2 = this.getPreferredSize().height;
                    Dimension dimension = this.calculateMinSize();
                    if (this.getPreferredSize().height < dimension.height) {
                        n2 = dimension.height;
                    }
                }
                this.setSize(new Dimension(n, n2));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.scroller != null) {
            this.maxSize = this.calculateMaxSize();
            this.setMaxSize(this.maxSize);
        }
        super.setVisible(bl);
        Dimension dimension = this.getSize();
        this.setSize(dimension.width, dimension.height + 100);
        this.setSize(dimension.width, dimension.height);
    }

    protected void arrangeBars() {
        if (this.panel instanceof BeliefMonitorDPanel) {
            int n;
            ((BeliefMonitorDPanel)this.panel).arrangeBars();
            this.setVisible(true);
            try {
                String string = this.project.getNetworkPanel().getHome().getAttribute("HR_Monitor_InitStates");
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                n = 2;
            }
            int n2 = (int)Math.rint(this.scaleFactor * (double)(this.sizePerState * n + this.initialMaxHeight)) + ((BeliefMonitorUI)this.getUI()).getTitleHeight();
            int n3 = this.getPreferredSize().width;
            if (this.getPreferredSize().height > n2) {
                n3 += this.scroller.getVerticalScrollBar().getPreferredSize().width;
            }
            this.setSize(new Dimension(n3, n2));
        }
    }

    protected void updateApiNode() {
        try {
            Domain domain = this.project.getBeliefBarPanel().getDomain();
            this.apiNode = domain.getNodeByName(this.node.getName());
            this.panel.setNode(this.apiNode);
            this.panel.setIsAlive(true);
            this.repaint();
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    protected void changeInterior(JPanel jPanel) {
        if (this.interior != null) {
            this.getContentPane().remove(this.interior);
        }
        this.getContentPane().add(jPanel);
        this.interior = jPanel;
        this.revalidate();
        this.pack();
    }

    public void setScaleFactor(double d) {
    }

    public void setScaleFactorPrint(double d) {
        double d2 = d / this.scaleFactor;
        this.scaleFactor = d;
        if (!(this.panel instanceof BeliefMonitorCCPanel)) {
            ((BeliefMonitorUI)this.getUI()).setScaleFactor(d);
        }
        if (this.panel.isContinuous()) {
            return;
        }
        this.panel.setScaleFactor(d);
        if (this.scroller != null) {
            this.scroller.setScaleFactor(d);
        }
        int n = (int)Math.rint((double)this.getWidth() * d2);
        int n2 = (int)Math.rint((double)this.getHeight() * d2);
        this.setSize(n, n2);
        this.setMinimumSize(this.calculateMinSize());
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public void paintComponent(Graphics graphics) {
        if (this.barsLayout != this.panel.getBarsArrangement() || this.chanceHasUtility != this.panel.getChanceHasUtility() || this.displayMeanVariance != this.panel.getDisplayMeanVariance()) {
            this.arrangeBars();
        }
        if (graphics instanceof Graphics2D) {
            ((Graphics2D)graphics).setStroke(HStroke.BASIC_STROKE);
        }
        super.paintComponent(graphics);
        this.node.panel.setGraphicsSize(this.getBounds());
    }

    public void update(boolean bl) {
        this.panel.update(bl);
    }

    public void updateGraph() {
        this.panel.updateGraph();
    }

    public void printVisibleMonitor(Graphics graphics, double d) {
        this.setScaleFactorPrint(d);
        this.printVisibleMonitor = true;
        this.print(graphics);
        this.printVisibleMonitor = false;
        this.setScaleFactorPrint(1.0);
    }

    public void print(Graphics graphics) {
        if (this.panel == null) {
            return;
        }
        int n = ((BeliefMonitorUI)this.getUI()).getTitleHeight();
        int n2 = this.panel.getHeight();
        int n3 = this.getWidth() - 10;
        if (n3 == 0) {
            n3 = 150;
        }
        int n4 = 0;
        int n5 = 0;
        if (this.printVisibleMonitor) {
            if (this.scroller != null) {
                n2 = this.scroller.getViewport().getViewRect().height;
                n4 = this.scroller.getViewport().getViewPosition().x;
                n5 = this.scroller.getViewport().getViewPosition().y;
            } else if (this.interior != null) {
                n2 = this.interior.getBounds().height;
                n4 = this.interior.getBounds().x;
                n5 = this.interior.getBounds().y;
            }
            n2 = this.getHeight() - n;
            graphics.setClip(-1, 0, n3 + 3, n2 + n);
        } else {
            graphics.setClip(-1, -1, n3 + 4, n + n2 + 10);
        }
        graphics.setColor(Color.white);
        graphics.fillRect(-1, n, n3 + 2, n + n2 + 4);
        if (this.printVisibleMonitor) {
            graphics.translate(0, n + 1 - n5);
            this.panel.print(graphics);
            graphics.translate(0, -(n + 1 - n5));
            graphics.setColor(Color.black);
            graphics.drawLine(0, n2 + n - 1, n3, n2 + n - 1);
        } else {
            graphics.translate(0, n + 2);
            graphics.setColor(Color.black);
            this.panel.setSize(this.getWidth(), this.panel.getHeight());
            this.panel.print(graphics);
            graphics.translate(0, -(n + 2));
            graphics.setClip(-1, -1, n3 + 4, n + n2 + 10);
        }
        ((BeliefMonitorUI)this.getUI()).setTitleWidth(this.getWidth());
        ((BeliefMonitorUI)this.getUI()).printTitle(graphics);
        graphics.setColor(Color.black);
        graphics.drawRect(-1, 0, n3 + 2, n + n2 + 4);
        graphics.drawLine(-1, n, n3, n);
    }

    public int getFullHeight() {
        int n = ((BeliefMonitorUI)this.getUI()).getTitleHeight();
        int n2 = this.panel.getHeight();
        return n + n2;
    }

    public static void showPopupCorrectly(JPopupMenu jPopupMenu, MouseEvent mouseEvent) {
        int n = 0;
        int n2 = 0;
        if (BeliefMonitor.popupExceedsHeight(jPopupMenu, mouseEvent)) {
            n = -(jPopupMenu.getPreferredSize().height - 2);
        }
        if (BeliefMonitor.popupExceedsWidth(jPopupMenu, mouseEvent)) {
            n2 = -(jPopupMenu.getPreferredSize().width - 2);
        }
        jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX() + n2, mouseEvent.getY() + n);
    }

    private static boolean popupExceedsHeight(JPopupMenu jPopupMenu, MouseEvent mouseEvent) {
        return mouseEvent.getPoint().y + mouseEvent.getComponent().getLocationOnScreen().y + jPopupMenu.getPreferredSize().height >= Toolkit.getDefaultToolkit().getScreenSize().height;
    }

    private static boolean popupExceedsWidth(JPopupMenu jPopupMenu, MouseEvent mouseEvent) {
        return mouseEvent.getPoint().x + mouseEvent.getComponent().getLocationOnScreen().x + jPopupMenu.getPreferredSize().width >= Toolkit.getDefaultToolkit().getScreenSize().width;
    }

    private class BeliefMonitorUI
    extends BasicInternalFrameUI {
        public BeliefMonitorUI(BeliefMonitor beliefMonitor2) {
            super(beliefMonitor2);
        }

        public JComponent createNorthPane(JInternalFrame jInternalFrame) {
            return new BeliefMonitorTitle(((BeliefMonitor)jInternalFrame).node, (BeliefMonitor)jInternalFrame);
        }

        public void setScaleFactor(double d) {
            ((BeliefMonitorTitle)this.getNorthPane()).setScaleFactor(d);
        }

        public void paintTitle(Graphics graphics) {
            ((BeliefMonitorTitle)this.getNorthPane()).paintComponent(graphics);
        }

        public void printTitle(Graphics graphics) {
            ((BeliefMonitorTitle)this.getNorthPane()).removeButton();
            ((BeliefMonitorTitle)this.getNorthPane()).paintComponent(graphics);
            ((BeliefMonitorTitle)this.getNorthPane()).addButton();
        }

        public void setTitleWidth(int n) {
            this.northPane.setSize(n, this.northPane.getHeight());
        }

        public int getTitleHeight() {
            return ((BeliefMonitorTitle)this.getNorthPane()).getHeight();
        }

        public int getTitleWidth() {
            return ((BeliefMonitorTitle)this.getNorthPane()).getWidth();
        }

        private class BeliefMonitorTitle
        extends JPanel {
            Node node;
            int height = 14;
            double scaleFactor = 1.0;
            BeliefMonitor monitor;
            boolean overButton;
            boolean buttonOn = true;

            public BeliefMonitorTitle(Node node, BeliefMonitor beliefMonitor) {
                this.node = node;
                this.monitor = beliefMonitor;
                this.addMouseListener(new MouseAdapter(){

                    public void mouseClicked(MouseEvent mouseEvent) {
                        if ((double)mouseEvent.getX() > Math.rint((double)BeliefMonitorTitle.this.getWidth() - (double)(BeliefMonitorTitle.this.height - 1) * BeliefMonitorTitle.this.scaleFactor)) {
                            BeliefMonitorTitle.this.monitor.node.closeMonitor();
                        }
                        BeliefMonitor.this.moveToFront();
                    }
                });
                this.addMouseMotionListener(new MouseMotionAdapter(){

                    public void mouseMoved(MouseEvent mouseEvent) {
                        boolean bl = BeliefMonitorTitle.this.overButton;
                        boolean bl2 = BeliefMonitorTitle.this.overButton = (double)mouseEvent.getX() > Math.rint((double)BeliefMonitorTitle.this.getWidth() - (double)(BeliefMonitorTitle.this.height - 1) * BeliefMonitorTitle.this.scaleFactor);
                        if (bl != BeliefMonitorTitle.this.overButton) {
                            BeliefMonitorTitle.this.repaint();
                        }
                    }
                });
            }

            public void setScaleFactor(double d) {
                this.scaleFactor = d;
            }

            public int getHeight() {
                return (int)Math.rint((double)this.height * this.scaleFactor);
            }

            public Dimension getPreferredSize() {
                return new Dimension(0, (int)((double)this.height * this.scaleFactor));
            }

            protected void removeButton() {
                this.buttonOn = false;
            }

            protected void addButton() {
                this.buttonOn = true;
            }

            public void paintComponent(Graphics graphics) {
                try {
                    int n = this.getWidth();
                    int n2 = this.getHeight();
                    if (n == 0) {
                        n = 150;
                        n2 = this.height;
                    }
                    String string = HuginGUIUtils.getNodeTitle(this.node.getAPINode(), (short)0);
                    String string2 = "";
                    graphics.setFont(this.getFont().deriveFont((float)(12.0 * this.scaleFactor)));
                    Rectangle2D.Float float_ = (Rectangle2D.Float)graphics.getFontMetrics().getStringBounds(string, graphics);
                    while (float_.getWidth() > (double)(n - 8) && string.length() != 0) {
                        string2 = "...";
                        string = string.length() >= 2 ? string.substring(0, string.length() - 2) : "";
                        float_ = (Rectangle2D.Float)graphics.getFontMetrics().getStringBounds(string + string2, graphics);
                    }
                    graphics.setColor(this.node.getColor());
                    graphics.fillRect(0, 0, (int)Math.rint(n), (int)Math.rint((double)this.height * this.scaleFactor));
                    graphics.setColor(this.node.getTextColor());
                    graphics.drawString(string + string2, (int)Math.rint(((double)n - float_.getWidth()) / 2.0), (int)Math.rint((double)(this.height - 2) * this.scaleFactor));
                    if (this.buttonOn) {
                        int n3 = (int)Math.min((double)this.height, (double)this.height * this.scaleFactor);
                        int n4 = n - (n3 + 2);
                        int n5 = 1;
                        graphics.setColor(this.node.getColor());
                        graphics.fillRect(n4 - 1, n5 - 1, n3 + 2, n3 + 2);
                        graphics.setColor(Color.black);
                        graphics.drawRect(n4, n5, n3, n3);
                        graphics.drawLine(n4, n5, n4 + n3, n5 + n3);
                        graphics.drawLine(n4, n5 + n3, n4 + n3, n5);
                    }
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
            }
        }
    }

    private class MonitorCCListener
    extends MouseInputAdapter {
        private MonitorCCListener() {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 0) {
                return;
            }
            if (BeliefMonitor.this.project.getBeliefBarPanel().getSelectedNode() != ((BeliefMonitorCCPanel)BeliefMonitor.this.panel).node) {
                BeliefMonitor.this.project.getBeliefBarPanel().setSelectedNode(((BeliefMonitorCCPanel)BeliefMonitor.this.panel).node);
            }
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                this.showPopup(mouseEvent);
                return;
            }
            if (mouseEvent.getClickCount() >= 2) {
                new JButton(new HuginGUIEventHandler.MENU_NETWORK_InsertContinuousFindingAction(((BeliefMonitorCCPanel)BeliefMonitor.this.panel).node)).doClick();
            }
            BeliefMonitor.this.panel.repaint();
            try {
                BeliefMonitor.this.project.getBeliefBarPanel().update();
                Hugin.mainFrame.repaint();
            }
            catch (ExceptionCGLIMIDsNotSupported exceptionCGLIMIDsNotSupported) {
                new HuginGUIError(exceptionCGLIMIDsNotSupported.getMessage());
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (BeliefMonitor.this.project.getBeliefBarPanel().getSelectedNode() != ((BeliefMonitorCCPanel)BeliefMonitor.this.panel).node) {
                BeliefMonitor.this.project.getBeliefBarPanel().setSelectedNode(((BeliefMonitorCCPanel)BeliefMonitor.this.panel).node);
            }
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                this.showPopup(mouseEvent);
                return;
            }
            BeliefMonitor.this.mouseX = mouseEvent.getX();
            BeliefMonitor.this.mouseY = mouseEvent.getY();
        }

        private void showPopup(MouseEvent mouseEvent) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            try {
                JMenuItem jMenuItem = new JMenuItem(HuginGUIConstants.get("MISCELLANEOUS_Close_monitor"));
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        BeliefMonitor.this.node.closeMonitor();
                    }
                });
                jPopupMenu.add(jMenuItem);
                if (((BeliefMonitorCCPanel)BeliefMonitor.this.panel).node.evidenceIsEntered()) {
                    jPopupMenu.add(new JMenuItem(new HuginGUIEventHandler.MENU_NETWORK_Retract_NodeAction(BeliefMonitor.this.project.guiFrame)));
                }
                jPopupMenu.add(new JMenuItem(new HuginGUIEventHandler.MENU_VIEW_Lock_EvidenceAction(BeliefMonitor.this.project.guiFrame)));
                jPopupMenu.add(new JMenuItem(new HuginGUIEventHandler.MENU_EDIT_Node_PropertiesAction(BeliefMonitor.this.project.guiFrame)));
                JMenu jMenu = new JMenu(new HuginGUIEventHandler.MONITOR_POPUP_Set_Display_Mode());
                JMenuItem jMenuItem2 = new JMenuItem(new HuginGUIEventHandler.MONITOR_POPUP_Set_Display_Mode_Normal(BeliefMonitor.this));
                jMenuItem2.setEnabled(BeliefMonitor.this.panel.displayMode != 0);
                jMenu.add(jMenuItem2);
                jMenuItem2 = new JMenuItem(new HuginGUIEventHandler.MONITOR_POPUP_Set_Display_Mode_Mixed(BeliefMonitor.this));
                jMenuItem2.setEnabled(BeliefMonitor.this.panel.displayMode != 3);
                jMenu.add(jMenuItem2);
                jPopupMenu.add(jMenu);
                BeliefMonitor.showPopupCorrectly(jPopupMenu, mouseEvent);
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }
    }

    private class MonitorDDListener
    extends MouseInputAdapter {
        private MonitorDDListener() {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            BeliefMonitorPanel beliefMonitorPanel;
            BeliefMonitorPanel beliefMonitorPanel2 = beliefMonitorPanel = BeliefMonitor.this.outer.panel instanceof BeliefMonitorDPanel ? ((BeliefMonitorDPanel)BeliefMonitor.this.outer.panel).DDPanel : BeliefMonitor.this.outer.panel;
            if (mouseEvent.getClickCount() == 0) {
                return;
            }
            if (BeliefMonitor.this.project.getBeliefBarPanel().getSelectedNode() != ((BeliefMonitorDDPanel)beliefMonitorPanel).node) {
                BeliefMonitor.this.project.getBeliefBarPanel().setSelectedNode(((BeliefMonitorDDPanel)beliefMonitorPanel).node);
            }
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                this.showPopup(mouseEvent);
                return;
            }
            int n = ((BeliefMonitorDDPanel)beliefMonitorPanel).getRow(mouseEvent.getX(), mouseEvent.getY());
            try {
                if (n >= ((DiscreteNode)BeliefMonitor.this.apiNode).getNumberOfStates()) {
                    return;
                }
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return;
            }
            ((BeliefMonitorDDPanel)beliefMonitorPanel).selectedState = n;
            if (mouseEvent.getClickCount() % 2 == 0) {
                try {
                    if (n >= 0) {
                        if (((BeliefMonitorDDPanel)beliefMonitorPanel).node.evidenceIsEntered() && ((BeliefMonitorDDPanel)beliefMonitorPanel).node.getEnteredFinding(n) > 0.0) {
                            ((BeliefMonitorDDPanel)beliefMonitorPanel).node.retractFindings();
                            BeliefMonitor.this.project.getBeliefBarPanel().fireEvidenceRetracted(((BeliefMonitorDDPanel)beliefMonitorPanel).node);
                            beliefMonitorPanel.repaint();
                        } else {
                            ((BeliefMonitorDDPanel)beliefMonitorPanel).node.selectState(n);
                            BeliefMonitor.this.project.getBeliefBarPanel().fireEvidenceEntered(((BeliefMonitorDDPanel)beliefMonitorPanel).node);
                        }
                        BeliefMonitor.this.project.getBeliefBarPanel().firePolicyUpdated();
                    }
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
            }
            beliefMonitorPanel.repaint();
            try {
                BeliefMonitor.this.project.getBeliefBarPanel().propagateIfNecessary();
                BeliefMonitor.this.project.getBeliefBarPanel().update();
                Hugin.mainFrame.repaint();
            }
            catch (ExceptionCGLIMIDsNotSupported exceptionCGLIMIDsNotSupported) {
                new HuginGUIError(exceptionCGLIMIDsNotSupported.getMessage());
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            BeliefMonitorPanel beliefMonitorPanel;
            BeliefMonitorPanel beliefMonitorPanel2 = beliefMonitorPanel = BeliefMonitor.this.outer.panel instanceof BeliefMonitorDPanel ? ((BeliefMonitorDPanel)BeliefMonitor.this.outer.panel).DDPanel : BeliefMonitor.this.outer.panel;
            if (BeliefMonitor.this.project.getBeliefBarPanel().getSelectedNode() != ((BeliefMonitorDDPanel)beliefMonitorPanel).node) {
                BeliefMonitor.this.project.getBeliefBarPanel().setSelectedNode(((BeliefMonitorDDPanel)beliefMonitorPanel).node);
            }
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                this.showPopup(mouseEvent);
                return;
            }
            BeliefMonitor.this.mouseX = mouseEvent.getX();
            BeliefMonitor.this.mouseY = mouseEvent.getY();
        }

        private void showPopup(MouseEvent mouseEvent) {
            BeliefMonitorPanel beliefMonitorPanel = BeliefMonitor.this.outer.panel instanceof BeliefMonitorDPanel ? ((BeliefMonitorDPanel)BeliefMonitor.this.outer.panel).DDPanel : BeliefMonitor.this.outer.panel;
            JPopupMenu jPopupMenu = new JPopupMenu();
            try {
                JMenuItem jMenuItem = new JMenuItem(HuginGUIConstants.get("MISCELLANEOUS_Close_monitor"));
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        BeliefMonitor.this.node.closeMonitor();
                    }
                });
                jPopupMenu.add(jMenuItem);
                if (((BeliefMonitorDDPanel)beliefMonitorPanel).node.evidenceIsEntered()) {
                    jPopupMenu.add(new JMenuItem(new HuginGUIEventHandler.MENU_NETWORK_Retract_NodeAction(BeliefMonitor.this.project.guiFrame)));
                }
                jPopupMenu.add(new JMenuItem(new HuginGUIEventHandler.MENU_VIEW_Lock_EvidenceAction(BeliefMonitor.this.project.guiFrame)));
                jPopupMenu.add(new JMenuItem(new HuginGUIEventHandler.MENU_EDIT_Node_PropertiesAction(BeliefMonitor.this.project.guiFrame)));
                JMenu jMenu = new JMenu(new HuginGUIEventHandler.MONITOR_POPUP_Set_Display_Mode());
                JMenuItem jMenuItem2 = new JMenuItem(new HuginGUIEventHandler.MONITOR_POPUP_Set_Display_Mode_Normal(BeliefMonitor.this));
                jMenuItem2.setEnabled(BeliefMonitor.this.panel.displayMode != 0);
                jMenu.add(jMenuItem2);
                jMenuItem2 = new JMenuItem(new HuginGUIEventHandler.MONITOR_POPUP_Set_Display_Mode_Delta_Absolute(BeliefMonitor.this));
                jMenuItem2.setEnabled(BeliefMonitor.this.panel.displayMode != 1);
                jMenu.add(jMenuItem2);
                jPopupMenu.add(jMenu);
                BeliefMonitor.showPopupCorrectly(jPopupMenu, mouseEvent);
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }
    }

    private class MonitorDCListener
    extends MouseAdapter {
        private MonitorDCListener() {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            BeliefMonitorPanel beliefMonitorPanel;
            BeliefMonitorPanel beliefMonitorPanel2 = beliefMonitorPanel = BeliefMonitor.this.outer.panel instanceof BeliefMonitorDPanel ? ((BeliefMonitorDPanel)BeliefMonitor.this.outer.panel).DCPanel : BeliefMonitor.this.outer.panel;
            if (mouseEvent.getClickCount() == 0) {
                return;
            }
            if (BeliefMonitor.this.project.getBeliefBarPanel().getSelectedNode() != ((BeliefMonitorDCPanel)beliefMonitorPanel).node) {
                BeliefMonitor.this.project.getBeliefBarPanel().setSelectedNode(((BeliefMonitorDCPanel)beliefMonitorPanel).node);
            }
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                this.showPopup(mouseEvent);
                return;
            }
            BeliefMonitorPanel beliefMonitorPanel3 = BeliefMonitor.this.outer.panel instanceof BeliefMonitorDPanel ? (mouseEvent.getSource() instanceof BeliefMonitorDCPanel ? ((BeliefMonitorDPanel)BeliefMonitor.this.outer.panel).DCPanel : ((BeliefMonitorDPanel)BeliefMonitor.this.outer.panel).DDPanel) : BeliefMonitor.this.outer.panel;
            int n = beliefMonitorPanel3.getRow(mouseEvent.getX(), mouseEvent.getY());
            try {
                if (n >= ((DiscreteNode)BeliefMonitor.this.apiNode).getNumberOfStates()) {
                    return;
                }
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return;
            }
            ((BeliefMonitorDCPanel)beliefMonitorPanel).selectedState = n;
            if (mouseEvent.getClickCount() % 2 == 0) {
                try {
                    if (n >= 0) {
                        if (((BeliefMonitorDCPanel)beliefMonitorPanel).node.evidenceIsEntered() && !((BeliefMonitorDCPanel)beliefMonitorPanel).node.likelihoodIsEntered() && ((BeliefMonitorDCPanel)beliefMonitorPanel).node.getEnteredFinding(n) > 0.0) {
                            ((BeliefMonitorDCPanel)beliefMonitorPanel).node.retractFindings();
                            BeliefMonitor.this.project.getBeliefBarPanel().fireEvidenceRetracted(((BeliefMonitorDCPanel)beliefMonitorPanel).node);
                        } else {
                            ((BeliefMonitorDCPanel)beliefMonitorPanel).node.selectState(n);
                            BeliefMonitor.this.project.getBeliefBarPanel().fireEvidenceEntered(((BeliefMonitorDCPanel)beliefMonitorPanel).node);
                        }
                        BeliefMonitor.this.project.getBeliefBarPanel().firePolicyUpdated();
                        BeliefMonitor.this.project.getBeliefBarPanel().propagateIfNecessary();
                        BeliefMonitor.this.project.getBeliefBarPanel().update();
                        beliefMonitorPanel.repaint();
                        Hugin.mainFrame.repaint();
                        return;
                    }
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
            }
            BeliefMonitor.this.moveToFront();
            beliefMonitorPanel.repaint();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            BeliefMonitorPanel beliefMonitorPanel;
            BeliefMonitorPanel beliefMonitorPanel2 = beliefMonitorPanel = BeliefMonitor.this.outer.panel instanceof BeliefMonitorDPanel ? ((BeliefMonitorDPanel)BeliefMonitor.this.outer.panel).DCPanel : BeliefMonitor.this.outer.panel;
            if (BeliefMonitor.this.project.getBeliefBarPanel().getSelectedNode() != ((BeliefMonitorDCPanel)beliefMonitorPanel).node) {
                BeliefMonitor.this.project.getBeliefBarPanel().setSelectedNode(((BeliefMonitorDCPanel)beliefMonitorPanel).node);
            }
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                this.showPopup(mouseEvent);
                return;
            }
            BeliefMonitor.this.mouseX = mouseEvent.getX();
            BeliefMonitor.this.mouseY = mouseEvent.getY();
        }

        private void showPopup(MouseEvent mouseEvent) {
            BeliefMonitorPanel beliefMonitorPanel = BeliefMonitor.this.outer.panel instanceof BeliefMonitorDPanel ? ((BeliefMonitorDPanel)BeliefMonitor.this.outer.panel).DCPanel : BeliefMonitor.this.outer.panel;
            JPopupMenu jPopupMenu = new JPopupMenu();
            try {
                JMenuItem jMenuItem = new JMenuItem(HuginGUIConstants.get("MISCELLANEOUS_Close_monitor"));
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        BeliefMonitor.this.node.closeMonitor();
                    }
                });
                jPopupMenu.add(jMenuItem);
                if (((BeliefMonitorDCPanel)beliefMonitorPanel).node.evidenceIsEntered()) {
                    jPopupMenu.add(new JMenuItem(new HuginGUIEventHandler.MENU_NETWORK_Retract_NodeAction(BeliefMonitor.this.project.guiFrame)));
                }
                jPopupMenu.add(new JMenuItem(new HuginGUIEventHandler.MENU_NETWORK_Enter_LikelihoodAction(BeliefMonitor.this.project.guiFrame)));
                jPopupMenu.add(new JMenuItem(new HuginGUIEventHandler.MENU_VIEW_Lock_EvidenceAction(BeliefMonitor.this.project.guiFrame)));
                jPopupMenu.add(new JMenuItem(new HuginGUIEventHandler.MENU_EDIT_Node_PropertiesAction(BeliefMonitor.this.project.guiFrame)));
                JMenu jMenu = new JMenu(new HuginGUIEventHandler.MONITOR_POPUP_Set_Display_Mode());
                JMenuItem jMenuItem2 = new JMenuItem(new HuginGUIEventHandler.MONITOR_POPUP_Set_Display_Mode_Normal(BeliefMonitor.this));
                jMenuItem2.setEnabled(BeliefMonitor.this.panel.displayMode != 0);
                jMenu.add(jMenuItem2);
                jMenuItem2 = new JMenuItem(new HuginGUIEventHandler.MONITOR_POPUP_Set_Display_Mode_Delta_Relative(BeliefMonitor.this));
                jMenuItem2.setEnabled(BeliefMonitor.this.panel.displayMode != 2);
                jMenu.add(jMenuItem2);
                jMenuItem2 = new JMenuItem(new HuginGUIEventHandler.MONITOR_POPUP_Set_Display_Mode_Delta_Absolute(BeliefMonitor.this));
                jMenuItem2.setEnabled(BeliefMonitor.this.panel.displayMode != 1);
                jMenu.add(jMenuItem2);
                jMenuItem2 = new JMenuItem(new HuginGUIEventHandler.MONITOR_POPUP_Set_Display_Mode_Mixed(BeliefMonitor.this));
                jMenuItem2.setEnabled(BeliefMonitor.this.panel.displayMode != 3);
                jMenu.add(jMenuItem2);
                JLongMenu jLongMenu = new JLongMenu(new HuginGUIEventHandler.MENU_NETWORK_belief_bar_notation());
                JMenuItem jMenuItem3 = new JMenuItem(new HuginGUIEventHandler.MENU_NETWORK_belief_bar_notation_normal());
                jMenuItem3.setEnabled(BeliefBarNodePainter.forceScientific);
                jLongMenu.add(jMenuItem3);
                jMenuItem3 = new JMenuItem(new HuginGUIEventHandler.MENU_NETWORK_belief_bar_notation_scientific());
                jMenuItem3.setEnabled(!BeliefBarNodePainter.forceScientific);
                jLongMenu.add(jMenuItem3);
                jPopupMenu.add(jLongMenu);
                jPopupMenu.add(jMenu);
                jPopupMenu.pack();
                BeliefMonitor.showPopupCorrectly(jPopupMenu, mouseEvent);
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }
    }

    private class MonitorDListener
    extends MouseAdapter {
        private MonitorDListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            BeliefMonitorPanel beliefMonitorPanel = BeliefMonitor.this.outer.panel;
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                this.showPopup(mouseEvent);
                return;
            }
            BeliefMonitor.this.mouseX = mouseEvent.getX();
            BeliefMonitor.this.mouseY = mouseEvent.getY();
        }

        private void showPopup(MouseEvent mouseEvent) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            try {
                JMenuItem jMenuItem = new JMenuItem(HuginGUIConstants.get("MISCELLANEOUS_Close_monitor"));
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        BeliefMonitor.this.node.closeMonitor();
                    }
                });
                jPopupMenu.add(jMenuItem);
                jPopupMenu.add(new JMenuItem(new HuginGUIEventHandler.MENU_EDIT_Node_PropertiesAction(BeliefMonitor.this.project.guiFrame)));
                JLongMenu jLongMenu = new JLongMenu(new HuginGUIEventHandler.MENU_NETWORK_belief_bar_notation());
                JMenuItem jMenuItem2 = new JMenuItem(new HuginGUIEventHandler.MENU_NETWORK_belief_bar_notation_normal());
                jMenuItem2.setEnabled(BeliefBarNodePainter.forceScientific);
                jLongMenu.add(jMenuItem2);
                jMenuItem2 = new JMenuItem(new HuginGUIEventHandler.MENU_NETWORK_belief_bar_notation_scientific());
                jMenuItem2.setEnabled(!BeliefBarNodePainter.forceScientific);
                jLongMenu.add(jMenuItem2);
                jPopupMenu.add(jLongMenu);
                BeliefMonitor.showPopupCorrectly(jPopupMenu, mouseEvent);
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }
    }

    private class BeliefMonitorCCPanel
    extends BeliefMonitorPanel {
        COM.hugin.HAPI.ContinuousChanceNode node;
        HuginProjectFrame project;
        ContinuousPanel contPanel;
        int initialBarWidth;
        boolean closed;
        ZoomableSlider zoom;
        ZoomableCombobox leftVariance;
        ZoomableCombobox rightVariance;
        ZoomableButton switcher;
        ZoomableButton updateGraph;
        GraphPainter graphPainter;
        Preferences preferences;
        boolean updateNeeded;
        boolean graphUpdated;
        boolean updateFirst;
        ContinuousChanceNodeMonitorModel model;

        public BeliefMonitorCCPanel() {
            this.initialBarWidth = 40;
        }

        public BeliefMonitorCCPanel(COM.hugin.HAPI.ContinuousChanceNode continuousChanceNode, HuginProjectFrame huginProjectFrame, Node node) throws ExceptionHugin {
            this.initialBarWidth = 40;
            this.node = continuousChanceNode;
            this.project = huginProjectFrame;
            this.guiNode = node;
            this.model = new ContinuousChanceNodeMonitorModel(continuousChanceNode);
            this.preferences = Hugin.mainFrame.preferences;
            this.setLayout(new BorderLayout());
            this.addMouseMotionListener(new MouseMotionAdapter(){
                int x;
                int y;

                public void mouseDragged(MouseEvent mouseEvent) {
                    if (BeliefMonitorCCPanel.this.project.getBeliefBarPanel().getSelectedNode() != BeliefMonitorCCPanel.this.node) {
                        BeliefMonitorCCPanel.this.project.getBeliefBarPanel().setSelectedNode(BeliefMonitorCCPanel.this.node);
                    }
                    if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                        return;
                    }
                    this.x = (int)(BeliefMonitor.this.getLocation().getX() + (double)(mouseEvent.getX() - BeliefMonitor.this.mouseX));
                    this.y = (int)(BeliefMonitor.this.getLocation().getY() + (double)(mouseEvent.getY() - BeliefMonitor.this.mouseY));
                    BeliefMonitor.this.setLocation(this.x, this.y);
                }
            });
            this.updateNeeded = false;
            this.updateFirst = false;
            this.graphUpdated = true;
        }

        public void setNode(COM.hugin.HAPI.Node node) {
            try {
                this.node = (COM.hugin.HAPI.ContinuousChanceNode)node;
                if (this.model != null) {
                    this.model.setNode(this.node);
                } else {
                    this.model = new ContinuousChanceNodeMonitorModel(this.node);
                }
                if (this.graphPainter != null) {
                    this.graphPainter.setNode(this.node);
                }
                if (this.contPanel != null) {
                    this.contPanel.setNode(this.node);
                }
            }
            catch (ExceptionHugin exceptionHugin) {
                new HuginGUIError(exceptionHugin);
            }
        }

        public void update(boolean bl) {
            Object object;
            if (bl) {
                this.updateNeeded = true;
                this.graphUpdated = false;
                if (this.updateGraph != null) {
                    this.updateGraph.setEnabled(true);
                }
                object = null;
                try {
                    object = this.project.getNetworkPanel().getHome().getAttribute("HR_Monitor_AutoUpdGraph");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (object != null && ((String)object).equals("1")) {
                    this.updateGraph();
                }
            }
            if ((object = this.getGraphics()) != null) {
                this.paint((Graphics)object);
            }
            if (this.contPanel != null) {
                this.contPanel.repaint();
            }
            if (this.graphPainter != null) {
                this.graphPainter.repaint();
            }
        }

        public void updateGraph() {
            this.graphUpdated = true;
            this.updateNeeded = false;
            this.updateFirst = false;
            if (this.updateGraph != null) {
                this.updateGraph.setEnabled(false);
            }
            this.update(false);
        }

        public void initialize() {
            String string;
            try {
                string = this.project.getNetworkPanel().getHome().getAttribute("HR_Monitor_OpenGraph");
            }
            catch (Exception exception) {
                string = "0";
            }
            if (string.equals("1")) {
                this.closed = false;
                this.showContinuousGraph();
            } else {
                this.closed = true;
                this.hideContinuousGraph();
            }
        }

        public boolean isContinuous() {
            return true;
        }

        private void showContinuousGraph() {
            JPanel jPanel = new JPanel(new BorderLayout());
            JPanel jPanel2 = new JPanel(new BorderLayout());
            this.contPanel = new ContinuousPanel(this.node, this.project, this.guiNode);
            this.contPanel.setBorder(BorderFactory.createEtchedBorder(1));
            jPanel2.setBackground(Color.white);
            jPanel2.add((Component)this.contPanel, "Center");
            jPanel.setBackground(Color.white);
            this.switcher = new ZoomableButton(new ImageIcon(Toolkit.getDefaultToolkit().createImage(ClassLoader.getSystemResource("icons/hideGraph.gif"))));
            this.switcher.setInsets(new Insets(3, 3, 3, 3));
            this.switcher.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BeliefMonitorCCPanel.this.hideContinuousGraph();
                    BeliefMonitorCCPanel.this.closed = true;
                }
            });
            JPanel jPanel3 = new JPanel(new BorderLayout());
            jPanel3.add((Component)this.switcher, "South");
            jPanel2.add((Component)jPanel3, "East");
            JPanel jPanel4 = new JPanel(new BorderLayout());
            JPanel jPanel5 = new JPanel(new BorderLayout());
            if (this.graphPainter == null) {
                this.graphPainter = new GraphPainter(this.node, this.project);
            }
            this.zoom = new ZoomableSlider(1, 1, 20, 20);
            this.zoom.setPreferredSize(new Dimension(15, 60));
            this.zoom.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    ZoomableSlider zoomableSlider = (ZoomableSlider)changeEvent.getSource();
                    BeliefMonitorCCPanel.this.graphPainter.setZoom(1 + (20 - BeliefMonitorCCPanel.this.zoom.getValue()));
                    BeliefMonitorCCPanel.this.graphPainter.repaint();
                }
            });
            Object[] objectArray = new String[10];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = "" + (i + 1) + "SD";
            }
            if (this.leftVariance == null || this.rightVariance == null) {
                this.leftVariance = new ZoomableCombobox(objectArray);
                this.leftVariance.addItemListener(new ItemListener(){

                    public void itemStateChanged(ItemEvent itemEvent) {
                        if (BeliefMonitorCCPanel.this.leftVariance != null && BeliefMonitorCCPanel.this.rightVariance != null) {
                            BeliefMonitorCCPanel.this.model.recompute(BeliefMonitorCCPanel.this.leftVariance.getSelectedIndex() + 1, BeliefMonitorCCPanel.this.leftVariance.getSelectedIndex() + 1 + BeliefMonitorCCPanel.this.rightVariance.getSelectedIndex() + 1);
                        }
                        BeliefMonitorCCPanel.this.graphUpdated = true;
                        BeliefMonitorCCPanel.this.graphPainter.repaint();
                    }
                });
                int n = 2;
                try {
                    String string = this.project.getNetworkPanel().getHome().getAttribute("HR_Monitor_InitSD");
                    if (string != null) {
                        n = Integer.parseInt(string);
                    }
                }
                catch (Exception exception) {
                    n = 2;
                }
                this.leftVariance.setSelectedIndex(n - 1);
                this.rightVariance = new ZoomableCombobox(objectArray);
                this.rightVariance.addItemListener(new ItemListener(){

                    public void itemStateChanged(ItemEvent itemEvent) {
                        if (BeliefMonitorCCPanel.this.leftVariance != null && BeliefMonitorCCPanel.this.rightVariance != null) {
                            BeliefMonitorCCPanel.this.model.recompute(BeliefMonitorCCPanel.this.leftVariance.getSelectedIndex() + 1, BeliefMonitorCCPanel.this.leftVariance.getSelectedIndex() + 1 + BeliefMonitorCCPanel.this.rightVariance.getSelectedIndex() + 1);
                        }
                        BeliefMonitorCCPanel.this.graphUpdated = true;
                        BeliefMonitorCCPanel.this.graphPainter.repaint();
                    }
                });
                this.rightVariance.setSelectedIndex(n - 1);
            }
            this.updateGraph = new ZoomableButton(new ImageIcon(ClassLoader.getSystemResource("icons/updatemonitorgraphs.gif")));
            this.updateGraph.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BeliefMonitorCCPanel.this.updateGraph();
                }
            });
            this.updateGraph.setInsets(new Insets(3, 3, 3, 3));
            this.updateGraph.setEnabled(this.updateNeeded);
            this.leftVariance.setAlignmentY(0.5f);
            this.rightVariance.setAlignmentY(0.5f);
            JPanel jPanel6 = new JPanel();
            jPanel6.setLayout(new BoxLayout(jPanel6, 0));
            jPanel6.add(this.leftVariance);
            jPanel6.add(this.rightVariance);
            jPanel6.add(this.updateGraph);
            this.graphPainter.setBorder(BorderFactory.createEtchedBorder(1));
            jPanel5.setBackground(Color.white);
            jPanel5.add((Component)this.graphPainter, "Center");
            jPanel5.add((Component)this.zoom, "East");
            jPanel4.add((Component)jPanel5, "Center");
            jPanel4.add((Component)jPanel6, "South");
            this.setLayout(new BorderLayout());
            jPanel.add((Component)jPanel2, "North");
            jPanel.add((Component)jPanel4, "Center");
            BeliefMonitor.this.changeInterior(jPanel);
        }

        private void hideContinuousGraph() {
            JPanel jPanel = new JPanel(new BorderLayout());
            this.contPanel = new ContinuousPanel(this.node, this.project, this.guiNode);
            this.contPanel.setBackground(Color.white);
            this.contPanel.setBorder(BorderFactory.createEtchedBorder(1));
            jPanel.setBackground(Color.white);
            jPanel.add((Component)this.contPanel, "Center");
            this.switcher = new ZoomableButton(new ImageIcon(Toolkit.getDefaultToolkit().createImage(ClassLoader.getSystemResource("icons/showGraph.gif"))));
            this.switcher.setInsets(new Insets(3, 3, 3, 3));
            this.switcher.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BeliefMonitorCCPanel.this.showContinuousGraph();
                    BeliefMonitorCCPanel.this.closed = false;
                }
            });
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)this.switcher, "South");
            jPanel.add((Component)jPanel2, "East");
            BeliefMonitor.this.changeInterior(jPanel);
        }

        public void print(Graphics graphics) {
            if (!this.closed && BeliefMonitor.this.printVisibleMonitor) {
                graphics.translate(5, 40);
                this.graphPainter.paintComponent(graphics);
                graphics.translate(-5, -40);
                graphics.setColor(Color.black);
                graphics.drawLine(0, 30, this.graphPainter.graphWidth + 50, 30);
            }
            this.contPanel.print(graphics);
        }

        public int getHeight() {
            int n = 0;
            if (!this.isAlive) {
                return n;
            }
            try {
                n = this.topMargin + (this.topMargin + this.barHeight) * 2;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
            return n;
        }

        public Dimension getPreferredSize() {
            Dimension dimension = new Dimension(0, 0);
            if (!this.isAlive) {
                return dimension;
            }
            Object var2_2 = null;
            dimension = this.contPanel.getPreferredSize();
            dimension.setSize(dimension.getWidth() + (double)((int)this.switcher.getSize().getWidth()), dimension.getHeight());
            if (!this.closed) {
                dimension.setSize(dimension.getWidth(), dimension.getHeight() + 60.0);
            }
            return dimension;
        }

        public void setScaleFactor(double d) {
            super.setScaleFactor(1.0);
        }

        private class ContinuousPanel
        extends BeliefMonitorCCPanel {
            COM.hugin.HAPI.ContinuousChanceNode node;
            HuginProjectFrame project;

            public ContinuousPanel(COM.hugin.HAPI.ContinuousChanceNode continuousChanceNode, HuginProjectFrame huginProjectFrame, Node node) {
                this.node = continuousChanceNode;
                this.project = huginProjectFrame;
                this.guiNode = node;
                this.addMouseListener(new MonitorCCListener());
                this.addMouseMotionListener(new MouseMotionAdapter(){
                    int x;
                    int y;

                    public void mouseDragged(MouseEvent mouseEvent) {
                        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                            return;
                        }
                        this.x = (int)(BeliefMonitor.this.getLocation().getX() + (double)(mouseEvent.getX() - BeliefMonitor.this.mouseX));
                        this.y = (int)(BeliefMonitor.this.getLocation().getY() + (double)(mouseEvent.getY() - BeliefMonitor.this.mouseY));
                        BeliefMonitor.this.setLocation(this.x, this.y);
                    }
                });
                this.setBackground(Color.white);
            }

            public void print(Graphics graphics) {
                this.paintComponent(graphics);
                int n = this.getWidth();
                if (n == 0) {
                    n = 150;
                }
            }

            public void paintComponent(Graphics graphics) {
                int n;
                if (!this.isAlive) {
                    return;
                }
                if (graphics instanceof Graphics2D) {
                    ((Graphics2D)graphics).setStroke(HStroke.BASIC_STROKE);
                }
                if ((n = this.getWidth()) == 0) {
                    n = 150;
                    graphics.drawRect(-1, -1, n + 2, this.getHeight() + 2);
                }
                graphics.setColor(Color.white);
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                graphics.setColor(Color.black);
                BeliefMonitor.this.scaleFactor = 1.0;
                graphics.setFont(graphics.getFont().deriveFont((float)(12.0 * BeliefMonitor.this.scaleFactor)));
                try {
                    double d = this.node.evidenceIsEntered() ? this.node.getEnteredValue() : this.node.getMean();
                    String string = BeliefBarNodePainter.convertValue(d, this.project.guiFrame.preferences.precision + 2, this.project.guiFrame.preferences.precision);
                    Rectangle2D.Float float_ = (Rectangle2D.Float)graphics.getFontMetrics().getStringBounds(string, graphics);
                    graphics.drawString(HuginGUIConstants.get("MISCELLANEOUS_Mean"), this.barWidth + this.leftMargin + 5, this.topMargin + this.barHeight);
                    graphics.drawString(string, this.barWidth + this.leftMargin - (int)float_.getWidth() - 2, this.topMargin + this.barHeight);
                    d = this.node.evidenceIsEntered() ? 0.0 : this.node.getVariance();
                    string = BeliefBarNodePainter.convertValue(d, this.project.guiFrame.preferences.precision + 2, this.project.guiFrame.preferences.precision);
                    float_ = (Rectangle2D.Float)graphics.getFontMetrics().getStringBounds(string, graphics);
                    graphics.drawString(HuginGUIConstants.get("MISCELLANEOUS_Variance"), this.barWidth + this.leftMargin + 5, (this.topMargin + this.barHeight) * 2);
                    graphics.drawString(string, this.barWidth + this.leftMargin - (int)float_.getWidth() - 2, (this.topMargin + this.barHeight) * 2);
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
            }

            public void setScaleFactor(double d) {
            }

            public Dimension getPreferredSize() {
                Dimension dimension = new Dimension(42, 42);
                if (!this.isAlive) {
                    return dimension;
                }
                Rectangle2D.Float float_ = null;
                this.fullWidth = 0;
                if (this.fullWidth == 0) {
                    if (this.getGraphics() != null) {
                        float_ = (Rectangle2D.Float)this.getGraphics().getFontMetrics().getStringBounds(HuginGUIConstants.get("MISCELLANEOUS_Mean"), this.getGraphics());
                        if (float_.getWidth() > (double)this.fullWidth) {
                            this.fullWidth = (int)float_.getWidth() + 20;
                        }
                    } else {
                        this.fullWidth = 51;
                    }
                }
                dimension.setSize(this.fullWidth + this.leftMargin + 5 + this.barWidth, this.getHeight());
                return dimension;
            }

            public void setNode(COM.hugin.HAPI.ContinuousChanceNode continuousChanceNode) {
                this.node = continuousChanceNode;
            }
        }

        private class GraphPainter
        extends JPanel {
            COM.hugin.HAPI.ContinuousChanceNode node;
            HuginProjectFrame project;
            int graphWidth;
            int graphHeight;
            int axisHeight = 15;
            int allValues = 2000;
            double zoomFactor = 1.0;
            double nodeMean = 0.0;
            double oldNodeMean = 0.0;
            double deriviation = 1.0;
            double oldNodeDeriviation = 1.0;
            int dashLength = 5;

            public GraphPainter(COM.hugin.HAPI.ContinuousChanceNode continuousChanceNode, HuginProjectFrame huginProjectFrame) {
                this.node = continuousChanceNode;
                this.project = huginProjectFrame;
                this.addMouseListener(new MonitorCCListener());
            }

            public void paintComponent(Graphics graphics) {
                int n;
                int n2;
                double d;
                double d2;
                boolean bl;
                int n3;
                int n4;
                if (!BeliefMonitorCCPanel.this.isAlive) {
                    return;
                }
                try {
                    graphics.setColor(Color.white);
                    Rectangle rectangle = graphics.getClipBounds();
                    graphics.fillRect((int)rectangle.getX(), (int)rectangle.getY(), (int)rectangle.getWidth(), (int)rectangle.getHeight());
                    if (BeliefMonitorCCPanel.this.updateFirst) {
                        graphics.setColor(Color.black);
                        Rectangle2D.Float float_ = (Rectangle2D.Float)graphics.getFontMetrics().getStringBounds(HuginGUIConstants.get("MISCELLANEOUS_Update_needed"), graphics);
                        graphics.drawString(HuginGUIConstants.get("MISCELLANEOUS_Update_needed"), (int)(((double)this.getWidth() - float_.getWidth()) / 2.0), (this.getHeight() - 16) / 2);
                        return;
                    }
                    if (this.node.evidenceIsEntered()) {
                        Rectangle2D.Float float_ = (Rectangle2D.Float)graphics.getFontMetrics().getStringBounds(HuginGUIConstants.get("MISCELLANEOUS_Evidence_is_entered"), graphics);
                        graphics.setColor(Color.black);
                        graphics.drawString(HuginGUIConstants.get("MISCELLANEOUS_Evidence_is_entered"), (int)(((double)this.getWidth() - float_.getWidth()) / 2.0), (this.getHeight() - 16) / 2);
                        return;
                    }
                    if (this.node.evidenceToPropagate()) {
                        Rectangle2D.Float float_ = (Rectangle2D.Float)graphics.getFontMetrics().getStringBounds(HuginGUIConstants.get("MISCELLANEOUS_Propagation_needed"), graphics);
                        graphics.drawString(HuginGUIConstants.get("MISCELLANEOUS_Propagation_needed"), (int)(((double)this.getWidth() - float_.getWidth()) / 2.0), (this.getHeight() - 16) / 2);
                        return;
                    }
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
                int n5 = BeliefMonitorCCPanel.this.leftVariance.getSelectedIndex() + 1;
                int n6 = BeliefMonitorCCPanel.this.rightVariance.getSelectedIndex() + 1;
                int n7 = n5 + n6;
                if (BeliefMonitorCCPanel.this.graphUpdated) {
                    try {
                        BeliefMonitorCCPanel.this.model.recompute();
                        this.oldNodeMean = this.nodeMean;
                        this.oldNodeDeriviation = this.deriviation;
                        if (this.node.evidenceIsEntered()) {
                            this.nodeMean = -1.0;
                            this.deriviation = 0.0;
                        } else {
                            this.nodeMean = BeliefMonitorCCPanel.this.model.getValueAt(0);
                            this.deriviation = Math.sqrt(BeliefMonitorCCPanel.this.model.getValueAt(1));
                        }
                        if (this.deriviation == 0.0) {
                            this.deriviation = 1.0;
                        }
                    }
                    catch (Exception exception) {
                        new HuginGUIError(exception);
                    }
                    BeliefMonitorCCPanel.this.graphUpdated = false;
                }
                this.graphWidth = (int)this.getSize().getWidth() - 6;
                this.graphHeight = (int)this.getSize().getHeight() - 6;
                double d3 = (double)n7 * this.deriviation;
                double d4 = (double)this.graphWidth / d3;
                double d5 = this.nodeMean - (double)n5 * this.deriviation;
                double d6 = d3 / 7.0;
                if (d6 == 0.0) {
                    d6 = 1.0;
                }
                if (d6 < 1.0) {
                    n4 = 0;
                    double d7 = 0.1;
                    double d8 = 1.0;
                    if (d6 > 0.7) {
                        d6 = 1.0;
                    }
                    while (d6 < d8) {
                        d8 -= d7;
                        if (n4++ != 8) continue;
                        d7 /= 10.0;
                        n4 = 0;
                    }
                    d6 = d8;
                }
                if (d6 >= 5.0 && d6 < 10.0) {
                    d6 = 5.0;
                }
                if (d6 > 1.0) {
                    n4 = 1;
                    int n8 = 1;
                    while (d6 > (double)n8) {
                        if ((n8 += n4) != n4 * 10) continue;
                        n4 *= 10;
                    }
                    d6 = n8;
                }
                while (d6 < 0.001 && d6 < (double)this.graphWidth / (d4 * 4.0)) {
                    d6 *= 2.0;
                }
                double d9 = d5 - d5 % d6;
                double d10 = 1.0;
                graphics.setColor(Color.blue);
                graphics.setFont(graphics.getFont().deriveFont(10.0f));
                graphics.drawLine(3, this.graphHeight - this.axisHeight + 3, this.graphWidth, this.graphHeight - this.axisHeight + 3);
                boolean bl2 = false;
                int n9 = (int)((d9 - d5) * d4);
                NumberFormat numberFormat = NumberFormat.getInstance();
                int n10 = -((int)this.log10(d6));
                if (n10 > 0) {
                    numberFormat.setMaximumFractionDigits(n10 * 2);
                }
                while (n9 < this.graphWidth) {
                    if (d9 != 0.0 && Math.abs(d10 / d9) > 1000.0 && d9 < 1.0) {
                        d9 = 0.0;
                    }
                    if (bl2) {
                        String string = numberFormat.format(d9);
                        n3 = (int)((Rectangle2D.Float)graphics.getFontMetrics().getStringBounds(string, graphics)).getWidth();
                        graphics.drawString(string, n9 - n3 / 2, this.graphHeight - 2);
                        if (graphics instanceof Graphics2D) {
                            ((Graphics2D)graphics).setStroke(HStroke.STROKES[2]);
                        }
                    } else if (graphics instanceof Graphics2D) {
                        ((Graphics2D)graphics).setStroke(HStroke.STROKES[1]);
                    }
                    graphics.drawLine(3 + n9, this.graphHeight - this.axisHeight + 1, 3 + n9, this.graphHeight - this.axisHeight + 5);
                    bl2 = !bl2;
                    n9 = (int)(((d9 += d6) - d5) * d4);
                }
                double d11 = (double)n7 * this.deriviation / (double)this.graphWidth;
                double d12 = 0.0;
                boolean bl3 = true;
                if (graphics instanceof Graphics2D) {
                    ((Graphics2D)graphics).setStroke(HStroke.BASIC_STROKE);
                }
                try {
                    bl = BeliefMonitorCCPanel.this.displayMode == 3 && this.node.getHomeDomain().evidenceIsPropagated();
                }
                catch (Exception exception) {
                    bl = false;
                }
                if (bl && BeliefMonitorCCPanel.this.model.hasOldFunction()) {
                    try {
                        for (int i = 0; i < this.graphWidth - 1; ++i) {
                            d2 = this.nodeMean - (double)n5 * this.deriviation + (double)i * d11;
                            BeliefMonitorCCPanel.this.model.function(d2 + d11, this.nodeMean, this.deriviation, d11, BeliefMonitorCCPanel.this.preferences.graph_precision);
                        }
                    }
                    catch (ContinuousChanceNodeMonitorModel.UpdateNeededException updateNeededException) {
                        // empty catch block
                    }
                    graphics.setColor(new Color(150, 150, 150));
                    n3 = (int)(BeliefMonitorCCPanel.this.model.oldFunction(this.nodeMean - (double)n5 * this.deriviation, this.oldNodeMean, this.oldNodeDeriviation, d11) * this.zoomFactor * ((double)(this.graphHeight - 2 - this.axisHeight) / BeliefMonitorCCPanel.this.model.maxValue(bl)));
                    for (int i = 1; i < this.graphWidth - 1; ++i) {
                        d2 = this.nodeMean - (double)n5 * this.deriviation + (double)i * d11;
                        d = BeliefMonitorCCPanel.this.model.oldFunction(d2 + d11, this.oldNodeMean, this.oldNodeDeriviation, d11);
                        n2 = (int)(d * this.zoomFactor * ((double)(this.graphHeight - 2 - this.axisHeight) / BeliefMonitorCCPanel.this.model.maxValue(bl)));
                        n = Math.abs(n3 - n2);
                        if (BeliefMonitorCCPanel.this.updateNeeded && (d12 += (double)(1 + n)) > (double)this.dashLength) {
                            d12 = 0.0;
                            boolean bl4 = bl3 = !bl3;
                        }
                        if (!BeliefMonitorCCPanel.this.updateNeeded && d > BeliefMonitorCCPanel.this.model.maxValue(bl)) {
                            graphics.drawLine(3 + i, this.graphHeight - n3 - this.axisHeight, 3 + i, this.graphHeight - n2 - this.axisHeight);
                            n2 = n3;
                        } else if ((!BeliefMonitorCCPanel.this.updateNeeded || bl3) && n3 >= 0 && n2 >= 0) {
                            if (n > 1) {
                                graphics.drawLine(3 + i, this.graphHeight - n3 - this.axisHeight, 3 + i + 1, this.graphHeight - n2 - this.axisHeight);
                            } else {
                                graphics.drawLine(3 + i + 1, this.graphHeight - n2 - this.axisHeight, 3 + i + 1, this.graphHeight - n2 - this.axisHeight);
                            }
                        }
                        n3 = n2;
                    }
                }
                graphics.setColor(Color.black);
                try {
                    n3 = (int)(BeliefMonitorCCPanel.this.model.function(this.nodeMean - (double)n5 * this.deriviation, this.nodeMean, this.deriviation, d11, BeliefMonitorCCPanel.this.preferences.graph_precision) * this.zoomFactor * ((double)(this.graphHeight - 2 - this.axisHeight) / BeliefMonitorCCPanel.this.model.maxValue(bl)));
                    for (int i = 1; i < this.graphWidth - 1; ++i) {
                        d2 = this.nodeMean - (double)n5 * this.deriviation + (double)i * d11;
                        d = BeliefMonitorCCPanel.this.model.function(d2 + d11, this.nodeMean, this.deriviation, d11, BeliefMonitorCCPanel.this.preferences.graph_precision);
                        n2 = (int)(d * this.zoomFactor * ((double)(this.graphHeight - 2 - this.axisHeight) / BeliefMonitorCCPanel.this.model.maxValue(bl)));
                        n = Math.abs(n3 - n2);
                        if (BeliefMonitorCCPanel.this.updateNeeded && (d12 += (double)(1 + n)) > (double)this.dashLength) {
                            d12 = 0.0;
                            boolean bl5 = bl3 = !bl3;
                        }
                        if (!BeliefMonitorCCPanel.this.updateNeeded && d > BeliefMonitorCCPanel.this.model.maxValue(bl)) {
                            graphics.drawLine(3 + i, this.graphHeight - n3 - this.axisHeight, 3 + i, this.graphHeight - n2 - this.axisHeight);
                            n2 = n3;
                        } else if (!BeliefMonitorCCPanel.this.updateNeeded || bl3) {
                            if (n > 1) {
                                graphics.drawLine(3 + i, this.graphHeight - n3 - this.axisHeight, 3 + i + 1, this.graphHeight - n2 - this.axisHeight);
                            } else {
                                graphics.drawLine(3 + i + 1, this.graphHeight - n2 - this.axisHeight, 3 + i + 1, this.graphHeight - n2 - this.axisHeight);
                            }
                        }
                        n3 = n2;
                    }
                    BeliefMonitorCCPanel.this.updateFirst = false;
                }
                catch (ContinuousChanceNodeMonitorModel.UpdateNeededException updateNeededException) {
                    graphics.setColor(Color.white);
                    Rectangle rectangle = graphics.getClipBounds();
                    graphics.fillRect((int)rectangle.getX(), (int)rectangle.getY(), (int)rectangle.getWidth(), (int)rectangle.getHeight());
                    graphics.setColor(Color.black);
                    Rectangle2D.Float float_ = (Rectangle2D.Float)graphics.getFontMetrics().getStringBounds(HuginGUIConstants.get("MISCELLANEOUS_Update_needed"), graphics);
                    graphics.drawString(HuginGUIConstants.get("MISCELLANEOUS_Update_needed"), (int)(((double)this.getWidth() - float_.getWidth()) / 2.0), (this.getHeight() - 16) / 2);
                    BeliefMonitorCCPanel.this.updateFirst = true;
                }
            }

            private double log10(double d) {
                return Math.log(d) * 0.4342944819032518;
            }

            public Dimension getPreferredSize() {
                return new Dimension(this.graphWidth, this.graphHeight);
            }

            public void setZoom(double d) {
                this.zoomFactor = d;
            }

            public void setNode(COM.hugin.HAPI.ContinuousChanceNode continuousChanceNode) {
                this.node = continuousChanceNode;
            }
        }
    }

    private class BeliefMonitorDDPanel
    extends BeliefMonitorPanel {
        DiscreteNode node;
        HuginProjectFrame project;
        DiscreteDecisionNodeMonitorModel model;

        public BeliefMonitorDDPanel(DiscreteDecisionNode discreteDecisionNode, HuginProjectFrame huginProjectFrame, Node node) {
            this((DiscreteNode)discreteDecisionNode, huginProjectFrame, node);
        }

        public BeliefMonitorDDPanel(DiscreteNode discreteNode, HuginProjectFrame huginProjectFrame, Node node) {
            this.node = discreteNode;
            this.project = huginProjectFrame;
            this.guiNode = node;
            try {
                this.model = new DiscreteDecisionNodeMonitorModel(this.node);
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
            this.addMouseListener(new MonitorDCListener());
            this.addMouseMotionListener(new MouseMotionAdapter(){
                int x;
                int y;

                public void mouseDragged(MouseEvent mouseEvent) {
                    if (BeliefMonitorDDPanel.this.project.getBeliefBarPanel().getSelectedNode() != BeliefMonitorDDPanel.this.node) {
                        BeliefMonitorDDPanel.this.project.getBeliefBarPanel().setSelectedNode(BeliefMonitorDDPanel.this.node);
                    }
                    if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                        return;
                    }
                    this.x = (int)(BeliefMonitor.this.getLocation().getX() + (double)(mouseEvent.getX() - BeliefMonitor.this.mouseX));
                    this.y = (int)(BeliefMonitor.this.getLocation().getY() + (double)(mouseEvent.getY() - BeliefMonitor.this.mouseY));
                    BeliefMonitor.this.setLocation(this.x, this.y);
                }
            });
        }

        public void setNode(COM.hugin.HAPI.Node node) throws ExceptionHugin {
            this.node = (DiscreteNode)node;
            this.model.setNode(this.node);
        }

        public void print(Graphics graphics) {
            this.paintComponent(graphics);
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
        }

        public void paintComponent(Graphics graphics) {
            if (!this.isAlive) {
                return;
            }
            double d = Double.NEGATIVE_INFINITY;
            String string = "";
            if (graphics instanceof Graphics2D) {
                ((Graphics2D)graphics).setStroke(HStroke.BASIC_STROKE);
            }
            int n = this.getWidth();
            int n2 = this.getHeight();
            if (n == 0) {
                n = 150;
                graphics.setClip(0, 0, n - 10, n2);
            }
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (BeliefMonitor.this.displayMeanVariance && (BeliefMonitor.this.apiNode instanceof IntervalDCNode || BeliefMonitor.this.apiNode instanceof NumberedDCNode) && this.getBarsArrangement() == 0) {
                graphics.translate(0, this.meanVarianceMargin);
            }
            try {
                double d2;
                int n3;
                boolean bl = this.displayMode == 1 && this.node.getHomeDomain().evidenceIsPropagated();
                int n4 = this.node.getNumberOfStates();
                for (n3 = 0; n3 < n4; ++n3) {
                    d2 = bl ? this.model.getDeltaValueAt(n3) : this.model.getValueAt(n3);
                    d = Math.max(d, Math.abs(d2));
                }
                for (n3 = 0; n3 < n4; ++n3) {
                    String string2;
                    d2 = bl ? this.model.getDeltaValueAt(n3) : this.model.getValueAt(n3);
                    if (HuginGUIUtils.getUseSampledValue(this.node.getHomeDomain())) {
                        string2 = "XXX";
                        string = "";
                    } else if (this.node.evidenceIsEntered()) {
                        if (this.node.getEnteredFinding(n3) > 0.0) {
                            if (this.project.evidenceIsLocked) {
                                graphics.setColor(this.project.guiFrame.preferences.barColors.get(4));
                            } else {
                                graphics.setColor(this.project.guiFrame.preferences.barColors.get(1));
                            }
                            string2 = BeliefBarNodePainter.convertValue(d2, this.project.guiFrame.preferences.precision + 2, this.project.guiFrame.preferences.precision);
                            int n5 = d == 0.0 ? 0 : (int)(d2 / d * (double)(this.barWidth / 2));
                            if (n5 >= 0) {
                                graphics.fillRect(this.leftMargin + this.barWidth / 2, this.topMargin + (this.topMargin + this.barHeight) * n3, n5, this.barHeight);
                            } else {
                                graphics.fillRect(this.leftMargin + this.barWidth / 2 + n5, this.topMargin + (this.topMargin + this.barHeight) * n3, -n5, this.barHeight);
                            }
                            string = "*";
                        } else {
                            string2 = "0.00";
                            string = "";
                        }
                    } else {
                        string2 = BeliefBarNodePainter.convertValue(d2, this.project.guiFrame.preferences.precision + 2, this.project.guiFrame.preferences.precision);
                        try {
                            if (!this.node.evidenceIsEntered() && (this.project.getBeliefBarPanel().tree.paintInconcistent || this.project.getBeliefBarPanel().getDomain().evidenceToPropagate() || this.project.getBeliefBarPanel().getDomain().tablesToPropagate())) {
                                graphics.setColor(this.project.guiFrame.preferences.barColors.get(2));
                            } else {
                                graphics.setColor(this.project.guiFrame.preferences.barColors.get(0));
                            }
                            int n6 = d == 0.0 ? 0 : (int)(d2 / d * (double)(this.barWidth / 2));
                            if (n6 >= 0) {
                                graphics.fillRect(this.leftMargin + this.barWidth / 2, this.topMargin + (this.topMargin + this.barHeight) * n3, n6, this.barHeight);
                            } else {
                                graphics.fillRect(this.leftMargin + this.barWidth / 2 + n6, this.topMargin + (this.topMargin + this.barHeight) * n3, -n6, this.barHeight);
                            }
                        }
                        catch (Exception exception) {
                            graphics.setColor(Color.black);
                        }
                    }
                    graphics.setColor(Color.black);
                    graphics.drawRect(this.leftMargin, this.topMargin + (this.topMargin + this.barHeight) * n3, this.barWidth, this.barHeight);
                    graphics.drawLine(this.leftMargin + this.barWidth / 2, this.topMargin + (this.topMargin + this.barHeight) * n3, this.leftMargin + this.barWidth / 2, (this.topMargin + this.barHeight) * (n3 + 1));
                    graphics.setFont(this.getFont());
                    Rectangle2D.Float float_ = (Rectangle2D.Float)graphics.getFontMetrics().getStringBounds(string2, graphics);
                    graphics.drawString(string + HuginGUIUtils.getNodeStateLabel(this.node, n3), this.barWidth + this.leftMargin + 5, (this.topMargin + this.barHeight) * (n3 + 1));
                    graphics.drawString(string2, this.barWidth + this.leftMargin - (int)float_.getWidth() - 2, (this.topMargin + this.barHeight) * (n3 + 1));
                }
                if (BeliefMonitor.this.displayMeanVariance && (BeliefMonitor.this.apiNode instanceof NumberedDCNode || BeliefMonitor.this.apiNode instanceof IntervalDCNode) && this.getBarsArrangement() == 0) {
                    n3 = this.getWidth();
                    int n7 = this.getHeight() - this.meanVarianceMargin;
                    graphics.translate(0, -this.meanVarianceMargin);
                }
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }

        int getRow(int n, int n2) {
            int n3 = 0;
            if (BeliefMonitor.this.displayMeanVariance && (BeliefMonitor.this.apiNode instanceof IntervalDCNode || BeliefMonitor.this.apiNode instanceof NumberedDCNode) && this.getBarsArrangement() == 0) {
                n3 = this.meanVarianceMargin;
            }
            n2 -= n3;
            if ((n2 -= this.topMargin) < 0) {
                return -1;
            }
            if (n2 % (this.barHeight + this.topMargin) > this.barHeight) {
                return -1;
            }
            return n2 / (this.barHeight + this.topMargin);
        }

        public int getHeight() {
            int n = 0;
            if (!this.isAlive) {
                return n;
            }
            try {
                n = this.topMargin + (this.topMargin + this.barHeight) * this.node.getNumberOfStates();
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
            if (BeliefMonitor.this.displayMeanVariance && (BeliefMonitor.this.apiNode instanceof IntervalDCNode || BeliefMonitor.this.apiNode instanceof NumberedDCNode) && this.getBarsArrangement() == 0) {
                n += this.meanVarianceMargin;
            }
            return n;
        }

        public Dimension getPreferredSize() {
            Dimension dimension = new Dimension(0, 0);
            if (!this.isAlive) {
                return dimension;
            }
            Rectangle rectangle = null;
            try {
                this.fullWidth = 0;
                if (this.fullWidth == 0) {
                    FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                    int n = this.node.getNumberOfStates();
                    for (int i = 0; i < n; ++i) {
                        rectangle = new Rectangle(SwingUtilities.computeStringWidth(fontMetrics, HuginGUIUtils.getNodeStateLabel(this.node, i)), fontMetrics.getHeight());
                    }
                    if (rectangle.getWidth() > (double)this.fullWidth) {
                        this.fullWidth = (int)rectangle.getWidth();
                    }
                }
                dimension.setSize((long)(this.fullWidth + this.leftMargin) + Math.round(5.0 * BeliefMonitor.this.scaleFactor) + (long)this.barWidth, (double)(this.topMargin + (this.topMargin + this.barHeight) * this.node.getNumberOfStates()));
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
            return dimension;
        }
    }

    private class BeliefMonitorDCPanel
    extends BeliefMonitorPanel {
        DiscreteNode node;
        HuginProjectFrame project;
        DiscreteChanceNodeMonitorModel model;

        public BeliefMonitorDCPanel(DiscreteChanceNode discreteChanceNode, HuginProjectFrame huginProjectFrame, Node node) {
            this((DiscreteNode)discreteChanceNode, huginProjectFrame, node);
        }

        public BeliefMonitorDCPanel(DiscreteNode discreteNode, HuginProjectFrame huginProjectFrame, Node node) {
            this.node = discreteNode;
            try {
                this.model = new DiscreteChanceNodeMonitorModel(discreteNode);
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
            this.project = huginProjectFrame;
            this.guiNode = node;
            this.addMouseListener(new MonitorDCListener());
            this.addMouseMotionListener(new MouseMotionAdapter(){
                int x;
                int y;

                public void mouseDragged(MouseEvent mouseEvent) {
                    if (!BeliefMonitorDCPanel.this.isAlive) {
                        return;
                    }
                    if (BeliefMonitorDCPanel.this.project.getBeliefBarPanel().getSelectedNode() != BeliefMonitorDCPanel.this.node) {
                        BeliefMonitorDCPanel.this.project.getBeliefBarPanel().setSelectedNode(BeliefMonitorDCPanel.this.node);
                    }
                    if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                        return;
                    }
                    this.x = (int)(BeliefMonitor.this.getLocation().getX() + (double)(mouseEvent.getX() - BeliefMonitor.this.mouseX));
                    this.y = (int)(BeliefMonitor.this.getLocation().getY() + (double)(mouseEvent.getY() - BeliefMonitor.this.mouseY));
                    BeliefMonitor.this.setLocation(this.x, this.y);
                }
            });
        }

        int getRow(int n, int n2) {
            int n3 = 0;
            if (BeliefMonitor.this.displayMeanVariance && (BeliefMonitor.this.apiNode instanceof IntervalDCNode || BeliefMonitor.this.apiNode instanceof NumberedDCNode)) {
                n3 = this.meanVarianceMargin;
            }
            n2 -= n3;
            if ((n2 -= this.topMargin) < 0) {
                return -1;
            }
            if (n2 % (this.barHeight + this.topMargin) > this.barHeight) {
                return -1;
            }
            return n2 / (this.barHeight + this.topMargin);
        }

        public void setNode(COM.hugin.HAPI.Node node) throws ExceptionHugin {
            this.node = (DiscreteNode)node;
            this.model.setNode(this.node);
        }

        public void print(Graphics graphics) {
            this.paintComponent(graphics);
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (!this.isAlive) {
                return;
            }
            if (graphics instanceof Graphics2D) {
                ((Graphics2D)graphics).setStroke(HStroke.BASIC_STROKE);
            }
            double d = 0.0;
            int n = this.getWidth();
            int n2 = this.getHeight();
            if (n == 0) {
                n = 150;
                if (this.project.networkPanel.isLIMIDs() && this.getBarsArrangement() == 0) {
                    graphics.setClip(0, 0, this.barWidth, n2);
                } else {
                    graphics.setClip(0, 0, n - 10, n2);
                }
            }
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (BeliefMonitor.this.displayMeanVariance && (BeliefMonitor.this.apiNode instanceof IntervalDCNode || BeliefMonitor.this.apiNode instanceof NumberedDCNode)) {
                graphics.translate(0, this.meanVarianceMargin);
            }
            try {
                int n3;
                d = 1.0;
                if (this.displayMode == 2) {
                    for (n3 = 0; n3 < this.model.getBarCount(); ++n3) {
                        d = Math.max(d, Math.abs(this.model.getPercentageDelta(n3)));
                    }
                }
                n3 = this.node.getHomeDomain().evidenceIsPropagated();
                int n4 = this.node.getNumberOfStates();
                for (int i = 0; i < n4; ++i) {
                    double d2;
                    int n5 = n3;
                    if (this.node.evidenceIsEntered()) {
                        d2 = this.node.getHomeDomain().evidenceModeIs(Domain.H_EVIDENCE_MODE_FAST_RETRACTION) && !this.node.evidenceToPropagate() && !this.project.evidenceIsLocked ? this.model.getValueAt(i) : this.model.getFindingAt(i);
                        graphics.setColor(this.project.guiFrame.preferences.barColors.get(1));
                        if (this.node.likelihoodIsEntered() || this.node.getSelectedState() < 0) {
                            graphics.setColor(this.project.guiFrame.preferences.barColors.get(3));
                            if (!this.node.evidenceToPropagate() && !this.project.evidenceIsLocked) {
                                d2 = this.model.getValueAt(i);
                            }
                        }
                        if (this.project.evidenceIsLocked) {
                            graphics.setColor(this.project.guiFrame.preferences.barColors.get(4));
                        }
                    } else {
                        if (this.project.getBeliefBarPanel().tree.paintInconcistent || this.project.getBeliefBarPanel().getDomain().evidenceToPropagate() || this.project.getBeliefBarPanel().getDomain().tablesToPropagate()) {
                            graphics.setColor(this.project.guiFrame.preferences.barColors.get(2));
                        } else {
                            graphics.setColor(this.project.guiFrame.preferences.barColors.get(0));
                        }
                        switch (this.displayMode) {
                            case 1: {
                                d2 = this.model.getDeltaValueAt(i);
                                break;
                            }
                            case 2: {
                                d2 = this.model.getPercentageDelta(i);
                                break;
                            }
                            default: {
                                d2 = this.model.getValueAt(i);
                            }
                        }
                    }
                    if (n5 != 0 && (this.displayMode == 1 || this.displayMode == 2)) {
                        if (d2 < 0.0) {
                            graphics.fillRect(this.leftMargin + this.barWidth / 2 + (int)(d2 / d * (double)this.barWidth / 2.0), this.topMargin + (this.topMargin + this.barHeight) * i, -((int)(d2 / d * (double)this.barWidth / 2.0)), this.barHeight);
                        } else {
                            graphics.fillRect(this.leftMargin + this.barWidth / 2 + 1, this.topMargin + (this.topMargin + this.barHeight) * i, (int)(d2 / d * (double)this.barWidth / 2.0), this.barHeight);
                        }
                        graphics.setColor(Color.black);
                    } else if (this.displayMode == 0 || n5 == 0) {
                        graphics.fillRect(this.leftMargin, this.topMargin + (this.topMargin + this.barHeight) * i, (int)(d2 * (double)this.barWidth), this.barHeight);
                    } else if (this.displayMode == 3) {
                        graphics.fillRect(this.leftMargin, this.topMargin + (this.topMargin + this.barHeight) * i, (int)(d2 * (double)this.barWidth), 2 * this.barHeight / 3);
                        graphics.setColor(graphics.getColor().darker());
                        graphics.fillRect(this.leftMargin, this.topMargin + (this.topMargin + this.barHeight) * i + 2 * this.barHeight / 3, (int)(this.model.getOldValueAt(i) * (double)this.barWidth), this.barHeight / 3);
                    }
                    graphics.setFont(this.getFont());
                    graphics.setColor(Color.black);
                    String string = BeliefBarNodePainter.convertValue(d2 * 100.0, this.project.guiFrame.preferences.precision + 2, this.project.guiFrame.preferences.precision);
                    if (n5 != 0 && this.displayMode == 2) {
                        int n6 = Math.min(4, this.project.guiFrame.preferences.precision);
                        string = BeliefBarNodePainter.convertValue(d2 * 100.0, n6 + 2, n6);
                        string = string + "%";
                    }
                    Rectangle2D.Float float_ = (Rectangle2D.Float)graphics.getFontMetrics().getStringBounds(string, graphics);
                    graphics.drawString(HuginGUIUtils.getNodeStateLabel(this.node, i), this.barWidth + this.leftMargin + 5, (this.topMargin + this.barHeight) * (i + 1));
                    graphics.setColor(Color.black);
                    graphics.drawString(string, this.barWidth + this.leftMargin - (int)float_.getWidth() - 2, (this.topMargin + this.barHeight) * (i + 1));
                }
                if (BeliefMonitor.this.displayMeanVariance && (BeliefMonitor.this.apiNode instanceof NumberedDCNode || BeliefMonitor.this.apiNode instanceof IntervalDCNode)) {
                    graphics.translate(0, -this.meanVarianceMargin);
                }
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }

        public int getHeight() {
            int n = 0;
            if (!this.isAlive) {
                return n;
            }
            try {
                n = this.topMargin + (this.topMargin + this.barHeight) * this.model.getBarCount();
                if (BeliefMonitor.this.displayMeanVariance && (BeliefMonitor.this.apiNode instanceof IntervalDCNode || BeliefMonitor.this.apiNode instanceof NumberedDCNode)) {
                    n += this.meanVarianceMargin;
                }
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
            return n;
        }

        public Dimension getPreferredSize() {
            Dimension dimension = new Dimension(0, 0);
            if (!this.isAlive) {
                return dimension;
            }
            Rectangle rectangle = null;
            try {
                this.fullWidth = 0;
                if (this.fullWidth == 0) {
                    FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                    for (int i = 0; i < this.model.getBarCount(); ++i) {
                        rectangle = new Rectangle(SwingUtilities.computeStringWidth(fontMetrics, HuginGUIUtils.getNodeStateLabel(this.node, i)), fontMetrics.getHeight());
                        if (!(rectangle.getWidth() > (double)this.fullWidth)) continue;
                        this.fullWidth = (int)rectangle.getWidth();
                    }
                }
                if (this.project.networkPanel.isLIMIDs() && this.getChanceHasUtility() && this.getBarsArrangement() == 0) {
                    dimension.setSize((long)this.leftMargin + Math.round(5.0 * BeliefMonitor.this.scaleFactor) + (long)this.barWidth, (double)this.getHeight());
                } else {
                    dimension.setSize((long)(this.fullWidth + this.leftMargin) + Math.round(5.0 * BeliefMonitor.this.scaleFactor) + (long)this.barWidth, (double)this.getHeight());
                }
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
            return dimension;
        }
    }

    private class BeliefMonitorFunctionPanel
    extends BeliefMonitorPanel {
        COM.hugin.HAPI.FunctionNode node;
        HuginProjectFrame project;
        FunctionNodeMonitorModel model;

        public BeliefMonitorFunctionPanel(COM.hugin.HAPI.FunctionNode functionNode, HuginProjectFrame huginProjectFrame, Node node) {
            this.node = functionNode;
            this.project = huginProjectFrame;
            this.guiNode = node;
            try {
                this.model = new FunctionNodeMonitorModel(this.node);
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
            this.addMouseListener(new MonitorDListener());
            this.addMouseMotionListener(new MouseMotionAdapter(){
                int x;
                int y;

                public void mouseDragged(MouseEvent mouseEvent) {
                    if (BeliefMonitorFunctionPanel.this.project.getBeliefBarPanel().getSelectedNode() != BeliefMonitorFunctionPanel.this.node) {
                        BeliefMonitorFunctionPanel.this.project.getBeliefBarPanel().setSelectedNode(BeliefMonitorFunctionPanel.this.node);
                    }
                    if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                        return;
                    }
                    this.x = (int)(BeliefMonitor.this.getLocation().getX() + (double)(mouseEvent.getX() - BeliefMonitor.this.mouseX));
                    this.y = (int)(BeliefMonitor.this.getLocation().getY() + (double)(mouseEvent.getY() - BeliefMonitor.this.mouseY));
                    BeliefMonitor.this.setLocation(this.x, this.y);
                }
            });
        }

        public void setNode(COM.hugin.HAPI.Node node) throws ExceptionHugin {
            this.node = (COM.hugin.HAPI.FunctionNode)node;
            this.model.setNode(this.node);
        }

        public void print(Graphics graphics) {
            this.paintComponent(graphics);
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
        }

        public void paintComponent(Graphics graphics) {
            if (!this.isAlive) {
                return;
            }
            double d = 0.0;
            boolean bl = false;
            String string = "";
            if (graphics instanceof Graphics2D) {
                ((Graphics2D)graphics).setStroke(HStroke.BASIC_STROKE);
            }
            int n = this.getWidth();
            int n2 = this.getHeight();
            if (n == 0) {
                n = 150;
                graphics.setClip(0, 0, n - 10, n2);
            }
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            try {
                try {
                    d = this.model.getValueAt(0);
                    bl = true;
                }
                catch (ExceptionHugin exceptionHugin) {
                    bl = false;
                }
                String string2 = bl ? BeliefBarNodePainter.convertValue(d, this.project.guiFrame.preferences.precision + 2, this.project.guiFrame.preferences.precision) : "XXX";
                graphics.setColor(Color.black);
                graphics.setFont(this.getFont());
                Rectangle2D.Float float_ = (Rectangle2D.Float)graphics.getFontMetrics().getStringBounds(string2, graphics);
                graphics.drawString(string2, this.barWidth + this.leftMargin - (int)float_.getWidth() - 2, this.topMargin + this.barHeight);
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }

        public int getHeight() {
            int n = 0;
            if (!this.isAlive) {
                return n;
            }
            try {
                n = this.topMargin + this.topMargin + this.barHeight;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
            return n;
        }

        public Dimension getPreferredSize() {
            Dimension dimension = new Dimension(0, 0);
            if (!this.isAlive) {
                return dimension;
            }
            Rectangle rectangle = null;
            try {
                FontMetrics fontMetrics;
                this.fullWidth = 0;
                if (this.fullWidth == 0 && (rectangle = new Rectangle(SwingUtilities.computeStringWidth(fontMetrics = this.getFontMetrics(this.getFont()), " "), fontMetrics.getHeight())).getWidth() > (double)this.fullWidth) {
                    this.fullWidth = (int)rectangle.getWidth();
                }
                dimension.setSize((long)(this.fullWidth + this.leftMargin) + Math.round(5.0 * BeliefMonitor.this.scaleFactor) + (long)this.barWidth, (double)(this.topMargin + (this.topMargin + this.barHeight)));
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
            return dimension;
        }
    }

    private class BeliefMonitorUtilityPanel
    extends BeliefMonitorPanel {
        COM.hugin.HAPI.UtilityNode node;
        HuginProjectFrame project;
        UtilityNodeMonitorModel model;

        public BeliefMonitorUtilityPanel(COM.hugin.HAPI.UtilityNode utilityNode, HuginProjectFrame huginProjectFrame, Node node) {
            this.node = utilityNode;
            this.project = huginProjectFrame;
            this.guiNode = node;
            try {
                this.model = new UtilityNodeMonitorModel(this.node);
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
            this.addMouseListener(new MonitorDListener());
            this.addMouseMotionListener(new MouseMotionAdapter(){
                int x;
                int y;

                public void mouseDragged(MouseEvent mouseEvent) {
                    if (BeliefMonitorUtilityPanel.this.project.getBeliefBarPanel().getSelectedNode() != BeliefMonitorUtilityPanel.this.node) {
                        BeliefMonitorUtilityPanel.this.project.getBeliefBarPanel().setSelectedNode(BeliefMonitorUtilityPanel.this.node);
                    }
                    if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                        return;
                    }
                    this.x = (int)(BeliefMonitor.this.getLocation().getX() + (double)(mouseEvent.getX() - BeliefMonitor.this.mouseX));
                    this.y = (int)(BeliefMonitor.this.getLocation().getY() + (double)(mouseEvent.getY() - BeliefMonitor.this.mouseY));
                    BeliefMonitor.this.setLocation(this.x, this.y);
                }
            });
        }

        public void setNode(COM.hugin.HAPI.Node node) throws ExceptionHugin {
            this.node = (COM.hugin.HAPI.UtilityNode)node;
            this.model.setNode(this.node);
        }

        public void print(Graphics graphics) {
            this.paintComponent(graphics);
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
        }

        public void paintComponent(Graphics graphics) {
            if (!this.isAlive) {
                return;
            }
            double d = Double.NEGATIVE_INFINITY;
            String string = "";
            if (graphics instanceof Graphics2D) {
                ((Graphics2D)graphics).setStroke(HStroke.BASIC_STROKE);
            }
            int n = this.getWidth();
            int n2 = this.getHeight();
            if (n == 0) {
                n = 150;
                graphics.setClip(0, 0, n - 10, n2);
            }
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            try {
                int n3;
                boolean bl = this.displayMode == 1 && this.node.getHomeDomain().evidenceIsPropagated();
                Table table = this.node.getTable();
                int n4 = table.getSize();
                for (n3 = 0; n3 < n4; ++n3) {
                    d = Math.max(d, Math.abs(table.getDataItem(n3)));
                }
                double d2 = bl ? this.model.getDeltaValueAt(0) : this.model.getValueAt(0);
                String string2 = BeliefBarNodePainter.convertValue(d2, this.project.guiFrame.preferences.precision + 2, this.project.guiFrame.preferences.precision);
                try {
                    graphics.setColor(this.project.guiFrame.preferences.barColors.get(5));
                    n3 = d == 0.0 ? 0 : (int)(d2 / d * (double)(this.barWidth / 2));
                    if (n3 >= 0) {
                        graphics.fillRect(this.leftMargin + this.barWidth / 2, this.topMargin, n3, this.barHeight);
                    } else {
                        graphics.fillRect(this.leftMargin + this.barWidth / 2 + n3, this.topMargin, -n3, this.barHeight);
                    }
                }
                catch (Exception exception) {
                    graphics.setColor(Color.black);
                }
                graphics.setColor(Color.black);
                graphics.drawRect(this.leftMargin, this.topMargin, this.barWidth, this.barHeight);
                graphics.drawLine(this.leftMargin + this.barWidth / 2, this.topMargin, this.leftMargin + this.barWidth / 2, this.topMargin + this.barHeight);
                graphics.setFont(this.getFont());
                Rectangle2D.Float float_ = (Rectangle2D.Float)graphics.getFontMetrics().getStringBounds(string2, graphics);
                graphics.drawString(string2, this.barWidth + this.leftMargin - (int)float_.getWidth() - 2, this.topMargin + this.barHeight);
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }

        public int getHeight() {
            int n = 0;
            if (!this.isAlive) {
                return n;
            }
            try {
                n = this.topMargin + this.topMargin + this.barHeight;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
            return n;
        }

        public Dimension getPreferredSize() {
            Dimension dimension = new Dimension(0, 0);
            if (!this.isAlive) {
                return dimension;
            }
            Rectangle rectangle = null;
            try {
                FontMetrics fontMetrics;
                this.fullWidth = 0;
                if (this.fullWidth == 0 && (rectangle = new Rectangle(SwingUtilities.computeStringWidth(fontMetrics = this.getFontMetrics(this.getFont()), " "), fontMetrics.getHeight())).getWidth() > (double)this.fullWidth) {
                    this.fullWidth = (int)rectangle.getWidth();
                }
                dimension.setSize((long)(this.fullWidth + this.leftMargin) + Math.round(5.0 * BeliefMonitor.this.scaleFactor) + (long)this.barWidth, (double)(this.topMargin + (this.topMargin + this.barHeight)));
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
            return dimension;
        }
    }

    private class BeliefMonitorDPanel
    extends BeliefMonitorPanel {
        protected BeliefMonitorDCPanel DCPanel;
        protected BeliefMonitorDDPanel DDPanel;
        DiscreteNode node;
        HuginProjectFrame project;

        public BeliefMonitorDPanel(DiscreteNode discreteNode, HuginProjectFrame huginProjectFrame, Node node) {
            this.DCPanel = null;
            this.DDPanel = null;
            this.node = discreteNode;
            this.setLayout(new BorderLayout());
            this.setBackground(Color.WHITE);
            this.DCPanel = new BeliefMonitorDCPanel(discreteNode, huginProjectFrame, node);
            this.add((Component)this.DCPanel, "North");
            if (huginProjectFrame.networkPanel.isLIMIDs()) {
                this.DDPanel = new BeliefMonitorDDPanel(discreteNode, huginProjectFrame, node);
                this.add((Component)this.DDPanel, "Center");
            }
            this.arrangeBars();
            this.project = huginProjectFrame;
            this.guiNode = node;
            this.addMouseListener(new MonitorDListener());
            this.addMouseMotionListener(new MouseMotionAdapter(){
                int x;
                int y;

                public void mouseDragged(MouseEvent mouseEvent) {
                    if (!BeliefMonitorDPanel.this.isAlive) {
                        return;
                    }
                    if (BeliefMonitorDPanel.this.project.getBeliefBarPanel().getSelectedNode() != BeliefMonitorDPanel.this.node) {
                        BeliefMonitorDPanel.this.project.getBeliefBarPanel().setSelectedNode(BeliefMonitorDPanel.this.node);
                    }
                    if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                        return;
                    }
                    this.x = (int)(BeliefMonitor.this.getLocation().getX() + (double)(mouseEvent.getX() - BeliefMonitor.this.mouseX));
                    this.y = (int)(BeliefMonitor.this.getLocation().getY() + (double)(mouseEvent.getY() - BeliefMonitor.this.mouseY));
                    BeliefMonitor.this.setLocation(this.x, this.y);
                }
            });
        }

        public void arrangeBars() {
            BeliefMonitor.this.barsLayout = this.getBarsArrangement();
            BeliefMonitor.this.chanceHasUtility = this.getChanceHasUtility();
            BeliefMonitor.this.displayMeanVariance = this.getDisplayMeanVariance();
            if (this.getChanceHasUtility() && this.DDPanel != null) {
                this.remove(this.DDPanel);
                this.add((Component)this.DDPanel, "Center");
            } else if (this.node instanceof DiscreteChanceNode && this.DDPanel != null) {
                this.remove(this.DDPanel);
            }
            if (this.getBarsArrangement() == 1) {
                this.remove(this.DCPanel);
                this.add((Component)this.DCPanel, "North");
            } else {
                this.remove(this.DCPanel);
                this.add((Component)this.DCPanel, "West");
            }
        }

        public void setNode(COM.hugin.HAPI.Node node) throws ExceptionHugin {
            this.node = (DiscreteNode)node;
            this.DCPanel.setNode(node);
            boolean bl = this.project.networkPanel.isLIMIDs();
            if (bl && this.DDPanel != null) {
                this.DDPanel.setNode(node);
            } else if (bl && this.DDPanel == null) {
                this.DDPanel = new BeliefMonitorDDPanel((DiscreteNode)node, this.project, this.guiNode);
                this.add((Component)this.DDPanel, "Center");
            } else if (!bl && this.DDPanel != null) {
                this.remove(this.DDPanel);
                this.DDPanel = null;
            }
        }

        public void print(Graphics graphics) {
            this.arrangeBars();
            this.setSize(this.getPreferredSize());
            this.DCPanel.setSize(this.getPreferredSize());
            this.DCPanel.print(graphics);
            if ((this.node instanceof DiscreteChanceNode && BeliefMonitor.this.chanceHasUtility || this.node instanceof DiscreteDecisionNode) && this.project.networkPanel.isLIMIDs()) {
                if (this.getBarsArrangement() == 0) {
                    graphics.translate(this.DCPanel.barWidth, 0);
                    this.DDPanel.setSize(this.getPreferredSize());
                    this.DDPanel.print(graphics);
                    graphics.translate(-this.DCPanel.barWidth, 0);
                } else {
                    this.DDPanel.setSize(this.DDPanel.getPreferredSize());
                    graphics.translate(0, (int)this.DCPanel.getPreferredSize().getHeight());
                    this.DDPanel.print(graphics);
                    graphics.translate(0, -((int)this.DCPanel.getPreferredSize().getHeight()));
                }
            }
            if (BeliefMonitor.this.displayMeanVariance && (BeliefMonitor.this.apiNode instanceof NumberedDCNode || BeliefMonitor.this.apiNode instanceof IntervalDCNode)) {
                try {
                    this.paintMeanVariance(graphics);
                }
                catch (ExceptionHugin exceptionHugin) {
                    new HuginGUIError(exceptionHugin);
                }
            }
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (BeliefMonitor.this.displayMeanVariance && (BeliefMonitor.this.apiNode instanceof NumberedDCNode || BeliefMonitor.this.apiNode instanceof IntervalDCNode)) {
                try {
                    this.paintMeanVariance(graphics);
                }
                catch (ExceptionHugin exceptionHugin) {
                    new HuginGUIError(exceptionHugin);
                }
            }
        }

        public int getHeight() {
            int n = 0;
            if (!this.isAlive) {
                return n;
            }
            n = this.DCPanel.getHeight();
            if (this.DDPanel != null && this.node instanceof DiscreteChanceNode && this.getChanceHasUtility() && this.getBarsArrangement() == 1) {
                n += this.DDPanel.getHeight();
            }
            if (this.DDPanel != null && this.node instanceof DiscreteDecisionNode && this.getBarsArrangement() == 1) {
                n += this.DDPanel.getHeight();
            }
            return n;
        }

        public void setIsAlive(boolean bl) {
            super.setIsAlive(bl);
            this.DCPanel.setIsAlive(bl);
            if (this.DDPanel != null) {
                this.DDPanel.setIsAlive(bl);
            }
        }

        public void setDisplayMode(int n) {
            super.setDisplayMode(n);
            this.DCPanel.setDisplayMode(n);
            if (this.DDPanel != null) {
                if (n == 0 || n == 1) {
                    this.DDPanel.setDisplayMode(n);
                } else {
                    this.DDPanel.setDisplayMode(0);
                }
            }
        }

        public Dimension getPreferredSize() {
            Dimension dimension = new Dimension(0, 0);
            if (!this.isAlive) {
                return dimension;
            }
            dimension = this.DCPanel.getPreferredSize();
            if (this.getBarsArrangement() == 0) {
                if (this.getChanceHasUtility() && this.node instanceof DiscreteChanceNode && this.DDPanel != null) {
                    dimension.setSize(this.DCPanel.getPreferredSize().getWidth() + this.DDPanel.getPreferredSize().getWidth(), dimension.getHeight());
                }
                if (this.node instanceof DiscreteDecisionNode && this.DDPanel != null) {
                    dimension.setSize(this.DCPanel.getPreferredSize().getWidth() + this.DDPanel.getPreferredSize().getWidth(), dimension.getHeight());
                }
            } else {
                if (this.getChanceHasUtility() && this.node instanceof DiscreteChanceNode && this.DDPanel != null) {
                    dimension.setSize(Math.max(dimension.getWidth(), this.DDPanel.getPreferredSize().getWidth()), dimension.getHeight() + this.DDPanel.getPreferredSize().getHeight());
                }
                if (this.node instanceof DiscreteDecisionNode && this.DDPanel != null) {
                    dimension.setSize(Math.max(dimension.getWidth(), this.DDPanel.getPreferredSize().getWidth()), dimension.getHeight() + this.DDPanel.getPreferredSize().getHeight());
                }
            }
            return dimension;
        }
    }

    private abstract class BeliefMonitorPanel
    extends JPanel {
        static final int initialBarWidth = 90;
        static final int initialBarHeight = 10;
        static final int initialMeanVarianceMargin = 17;
        static final int initialLeftMargin = 2;
        static final int initialTopMargin = 2;
        int barWidth;
        int barHeight;
        int leftMargin;
        int topMargin;
        int meanVarianceMargin;
        COM.hugin.HAPI.Node node;
        Node guiNode;
        int selectedState;
        int fullWidth;
        int displayMode;
        Font orgFont;
        boolean isAlive;

        public BeliefMonitorPanel() {
            this.barWidth = (int)(90.0 * BeliefMonitor.this.scaleFactor);
            this.barHeight = (int)(10.0 * BeliefMonitor.this.scaleFactor);
            this.leftMargin = (int)(2.0 * BeliefMonitor.this.scaleFactor);
            this.topMargin = (int)(2.0 * BeliefMonitor.this.scaleFactor);
            this.meanVarianceMargin = (int)(17.0 * BeliefMonitor.this.scaleFactor);
            this.selectedState = -1;
            this.fullWidth = 0;
            this.displayMode = 0;
            this.orgFont = new PastingTextField().getFont().deriveFont(12.0f);
            this.isAlive = true;
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    BeliefMonitor.this.moveToFront();
                }
            });
        }

        int getRow(int n, int n2) {
            if ((n2 -= this.topMargin) < 0) {
                return -1;
            }
            if (n2 % (this.barHeight + this.topMargin) > this.barHeight) {
                return -1;
            }
            return n2 / (this.barHeight + this.topMargin);
        }

        public abstract int getHeight();

        public int getBarHeight() {
            return this.barHeight;
        }

        public void setScaleFactor(double d) {
            this.barWidth = (int)Math.round(90.0 * d);
            this.barHeight = (int)Math.round(10.0 * d);
            this.leftMargin = (int)Math.round(2.0 * d);
            this.topMargin = (int)Math.round(2.0 * d);
            this.fullWidth = 0;
            this.setFont(this.orgFont.deriveFont((float)(12.0 * d)));
        }

        public abstract void setNode(COM.hugin.HAPI.Node var1) throws ExceptionHugin;

        public boolean isContinuous() {
            return false;
        }

        protected void update(boolean bl) {
            this.repaint();
        }

        public void updateGraph() {
        }

        public void print(Graphics graphics) {
        }

        public void setDisplayMode(int n) {
            this.displayMode = n;
        }

        public int getDisplayMode() {
            return this.displayMode;
        }

        public void setIsAlive(boolean bl) {
            this.isAlive = bl;
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
        }

        public int getBarsArrangement() {
            try {
                String string = BeliefMonitor.this.project.getNetworkPanel().getHome().getAttribute("HR_Monitor_Utility_Arrange");
                return Integer.parseInt(string);
            }
            catch (Exception exception) {
                return Integer.parseInt("0");
            }
        }

        public boolean getDisplayMeanVariance() {
            try {
                String string = BeliefMonitor.this.project.getNetworkPanel().getHome().getAttribute("HR_Monitor_Mean_Variance");
                return Integer.parseInt(string) == 1;
            }
            catch (Exception exception) {
                return Integer.parseInt("1") == 1;
            }
        }

        public boolean getChanceHasUtility() {
            try {
                String string = BeliefMonitor.this.project.getNetworkPanel().getHome().getAttribute("HR_Monitor_Chance_Utility");
                return Integer.parseInt(string) == 1;
            }
            catch (Exception exception) {
                return Integer.parseInt("1") == 1;
            }
        }

        public void paintMeanVariance(Graphics graphics) throws ExceptionHugin {
            int n = this.getWidth();
            int n2 = this.getHeight() - this.meanVarianceMargin;
            graphics.setColor(Color.black);
            graphics.drawLine(0, this.meanVarianceMargin, n, this.meanVarianceMargin);
            NetworkPanel networkPanel = BeliefMonitor.this.project.getNetworkPanel();
            int n3 = networkPanel.guiFrame.preferences.precision;
            Double d = HuginGUIUtils.average((DiscreteChanceNode)networkPanel.projectFrame.beliefBars.getDomainNodeFor(this.guiNode.getAPINode()), networkPanel, false, null);
            String string = HuginGUIUtils.printDouble(d, n3);
            Double d2 = HuginGUIUtils.variance((DiscreteChanceNode)networkPanel.projectFrame.beliefBars.getDomainNodeFor(this.guiNode.getAPINode()), networkPanel);
            String string2 = HuginGUIUtils.printDouble(d2, n3);
            String string3 = "\u03bc=" + string + ", \u03c32=" + string2;
            Font font = graphics.getFont();
            GlyphVector glyphVector = font.createGlyphVector(((Graphics2D)graphics).getFontRenderContext(), string3);
            Rectangle2D.Float float_ = (Rectangle2D.Float)graphics.getFontMetrics().getStringBounds(string3, graphics);
            ((Graphics2D)graphics).drawGlyphVector(glyphVector, (float)((double)(n / 2) - float_.getWidth() / 2.0), (float)(0.0 + float_.getHeight()));
        }
    }
}

