/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.Class;
import COM.hugin.HAPI.ClassList;
import COM.hugin.HAPI.DiscreteChanceNode;
import COM.hugin.HAPI.ExceptionObjectNotAlive;
import COM.hugin.HAPI.NetworkModel;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIFrame;
import COM.hugin.HGUI.HuginProjectFrame;
import COM.hugin.HGUI.Node;
import COM.hugin.HGUI.PastingTextArea;
import COM.hugin.HGUI.PastingTextField;
import COM.hugin.HGUI.TitledPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class BugReport
extends JDialog {
    private HuginGUIFrame frame = Hugin.mainFrame;
    private static String userName = "";
    private static String emailName = "";
    private static File file = null;
    private BugReport self;
    private PastingTextField nameField;
    private PastingTextField emailField;
    private PastingTextField fileNameField;
    private PastingTextArea actionsDescription;
    private PastingTextArea resultDescription;
    private boolean includeNetFile;
    private Exception exception;
    private String message;
    private String additionalMessage;

    public BugReport() {
        super(Hugin.mainFrame, HuginGUIConstants.get("BUG_REPORT_TITLE"), true);
        this.exception = null;
        this.message = null;
        this.init();
    }

    public BugReport(String string) {
        super(Hugin.mainFrame, HuginGUIConstants.get("BUG_REPORT_TITLE"), true);
        this.exception = null;
        this.message = string;
        this.init();
    }

    public BugReport(Exception exception) {
        super(Hugin.mainFrame, HuginGUIConstants.get("BUG_REPORT_TITLE"), true);
        this.exception = exception;
        this.message = null;
        this.init();
    }

    public BugReport(Exception exception, String string) {
        this(exception);
        this.additionalMessage = string;
    }

    private void init() {
        Object object;
        Object object2;
        this.self = this;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JLabel jLabel = new JLabel(HuginGUIConstants.get("BUG_REPORT_HEADER"));
        jLabel.setFont(new Font(HuginGUIConstants.defaultFont.getName(), 1, 16));
        jPanel.add(jLabel);
        jPanel.add(new JLabel(" "));
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JPanel jPanel4 = new JPanel(new GridLayout(3, 2, 5, 5));
        this.nameField = new PastingTextField(userName, 15);
        this.nameField.setHorizontalAlignment(2);
        this.nameField.setBackground(Color.white);
        jPanel4.add(new JLabel(HuginGUIConstants.get("BUG_REPORT_USER_LABEL"), 4));
        jPanel4.add(this.nameField);
        this.emailField = new PastingTextField(emailName, 15);
        this.emailField.setHorizontalAlignment(2);
        this.emailField.setBackground(Color.white);
        jPanel4.add(new JLabel(HuginGUIConstants.get("BUG_REPORT_EMAIL_LABEL"), 4));
        jPanel4.add(this.emailField);
        String string = file != null ? file.getPath() : "";
        this.fileNameField = new PastingTextField(string, 15);
        this.fileNameField.setHorizontalAlignment(2);
        this.fileNameField.setBackground(Color.white);
        JButton jButton = new JButton(HuginGUIConstants.get("BUG_REPORT_SELECT_FILE"));
        jPanel4.add(new JLabel(HuginGUIConstants.get("BUG_REPORT_FILE_LABEL"), 4));
        jPanel4.add(this.fileNameField);
        jPanel3.add((Component)jButton, "South");
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(jPanel4);
        jPanel2.add(jPanel3);
        jPanel.add(jPanel2);
        jPanel.add(new JLabel(" "));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                1 v0 = this;
                JFileChooser jFileChooser = new JFileChooser(file);
                jFileChooser.setDialogTitle(HuginGUIConstants.get("BUG_REPORT_SELECT_FILE"));
                int n = jFileChooser.showDialog(BugReport.this, HuginGUIConstants.get("BUG_REPORT_Select"));
                if (n == 0) {
                    BugReport.file = jFileChooser.getSelectedFile();
                    1 v1 = this;
                    BugReport.this.fileNameField.setText(file.getPath());
                }
            }
        });
        TitledPanel titledPanel = new TitledPanel(HuginGUIConstants.get("BUG_REPORT_ACTIONS"));
        titledPanel.setLayout(new BorderLayout());
        this.actionsDescription = new PastingTextArea(5, 40);
        this.actionsDescription.setLineWrap(true);
        this.actionsDescription.setWrapStyleWord(true);
        this.actionsDescription.setBackground(HuginGUIConstants.BUG_REPORT_TEXT_AREA_COLOR);
        this.actionsDescription.setEditable(true);
        this.actionsDescription.setEnabled(true);
        titledPanel.add((Component)new JScrollPane(this.actionsDescription), "Center");
        jPanel.add(titledPanel);
        TitledPanel titledPanel2 = new TitledPanel(HuginGUIConstants.get("BUG_REPORT_RESULT"));
        titledPanel2.setLayout(new BorderLayout());
        this.resultDescription = new PastingTextArea(5, 40);
        this.resultDescription.setLineWrap(true);
        this.resultDescription.setWrapStyleWord(true);
        this.resultDescription.setBackground(HuginGUIConstants.BUG_REPORT_TEXT_AREA_COLOR);
        this.resultDescription.setEditable(true);
        this.resultDescription.setEnabled(true);
        if (this.exception != null) {
            object2 = this.exception.getMessage();
            object = object2 != null && ((String)object2).length() > 0 ? object2 : "An exception has been caught";
            this.resultDescription.setText((String)object + " (stack trace written in report)");
        } else if (this.message != null) {
            this.resultDescription.setText(this.message);
        }
        titledPanel2.add((Component)new JScrollPane(this.resultDescription), "Center");
        jPanel.add(titledPanel2);
        object2 = new JPanel(new FlowLayout(1, 5, 5));
        object = new JCheckBox(HuginGUIConstants.get("str_include_description_of_network"));
        this.includeNetFile = false;
        ((AbstractButton)object).setSelected(false);
        if (this.frame.desktop == null) {
            if (this.exception != null) {
                this.exception.printStackTrace();
            } else {
                System.err.println("Error: desktop is 'null'");
            }
            return;
        }
        ((AbstractButton)object).setEnabled(this.frame.desktop.getSelectedFrame() != null);
        ((JComponent)object).setToolTipText(HuginGUIConstants.get("str_include_net_file"));
        ((AbstractButton)object).addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                BugReport.this.includeNetFile = itemEvent.getStateChange() == 1;
            }
        });
        JButton jButton2 = new JButton(HuginGUIConstants.get("str_save"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = BugReport.this.fileNameField.getText();
                if (file == null || !file.getName().equals(string)) {
                    if (string.length() == 0) {
                        BugReport.noFileSpecified(BugReport.this);
                        return;
                    }
                    BugReport.file = new File(string);
                }
                BugReport.this.printBugReport(file);
            }
        });
        jButton2.setToolTipText(HuginGUIConstants.get("str_save_bug_report_in_file"));
        JButton jButton3 = new JButton(HuginGUIConstants.get("cancel_button"));
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BugReport.this.self.dispose();
            }
        });
        JButton jButton4 = new JButton(HuginGUIConstants.get("str_send"));
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = BugReport.this.emailField.getText();
                if (string.length() == 0) {
                    BugReport.noEmailSpecified(BugReport.this);
                    return;
                }
                BugReport.this.sendBugReport();
            }
        });
        jButton4.setToolTipText(HuginGUIConstants.get("str_send_bug_report_to_hugin"));
        ((Container)object2).add((Component)object);
        ((Container)object2).add(jButton4);
        ((Container)object2).add(jButton2);
        ((Container)object2).add(jButton3);
        jPanel.add((Component)object2);
        this.getContentPane().setLayout(new BorderLayout(0, 5));
        this.getContentPane().add((Component)jPanel, "Center");
        this.setResizable(true);
        this.setModal(true);
    }

    private void printBugReport(File file) {
        try {
            this.printReport(new PrintWriter(new BufferedWriter(new FileWriter(file.getPath(), true))), false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.self.dispose();
        this.frame.statusBar.write(HuginGUIConstants.get("str_bug_report_saved_in_file_ARG0", new String[]{file.getPath()}));
    }

    private void sendBugReport() {
        File file = BugReport.file != null ? BugReport.file : new File(HuginGUIConstants.get("BUG_REPORT_DEFAULT_FILE"));
        this.printBugReport(file);
        try {
            Socket socket = new Socket("bug.hugin.dk", 3333);
            this.printReport(new PrintWriter(socket.getOutputStream(), true), true);
            socket.close();
        }
        catch (UnknownHostException unknownHostException) {
            new HuginGUIError(HuginGUIConstants.get("str_unknown_host"));
            return;
        }
        catch (IOException iOException) {
            new HuginGUIError(HuginGUIConstants.get("str_could_not_get_io"));
            return;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.self.dispose();
        this.frame.statusBar.write(HuginGUIConstants.get("str_report_send_and_saved_ARG0", new String[]{file.getPath()}));
    }

    private void printReport(PrintWriter printWriter, boolean bl) {
        userName = this.nameField.getText();
        emailName = this.emailField.getText();
        if (bl) {
            printWriter.println("From: " + emailName);
            printWriter.println("Subject: Bug report for HUGIN GUI 7.3");
        }
        printWriter.println("************************************************************");
        printWriter.println("*****************  BUG REPORT FOR HUGIN ********************");
        printWriter.println("* BUILD CONFIGURATION: 7.3, hgui_73 (" + HuginGUIConstants.getImplementationVersion() + ")");
        printWriter.println("* API: " + NetworkModel.getNativeID() + " / " + NetworkModel.getJavaID());
        printWriter.println("************************************************************");
        printWriter.println("************************************************************");
        printWriter.println();
        printWriter.print("Discovered");
        if (userName.length() > 0 || emailName.length() > 0) {
            printWriter.print(" by " + userName);
        }
        if (emailName.length() > 0) {
            printWriter.print(" <" + emailName + ">");
        }
        printWriter.println(" on " + new Date().toString());
        printWriter.println();
        printWriter.println("============================================================");
        printWriter.println("===================  License information  ==================");
        printWriter.println("============================================================");
        printWriter.println();
        printWriter.println("Registered User: " + NetworkModel.getUserName());
        printWriter.println("Registered Company: " + NetworkModel.getOrganization());
        printWriter.println("License Type: " + NetworkModel.getPackageName());
        printWriter.println();
        printWriter.println("============================================================");
        printWriter.println("===================  Description of bug  ===================");
        printWriter.println("============================================================");
        printWriter.println();
        printWriter.println(this.resultDescription.getText());
        printWriter.println();
        printWriter.println("============================================================");
        printWriter.println("=================  Description of actions  =================");
        printWriter.println("============================================================");
        printWriter.println();
        printWriter.println(this.actionsDescription.getText());
        printWriter.println();
        if (this.exception != null) {
            printWriter.println("============================================================");
            printWriter.println("======================  Stack trace  =======================");
            printWriter.println("============================================================");
            printWriter.println();
            this.exception.printStackTrace(printWriter);
            printWriter.println();
            printWriter.println(this.additionalMessage);
            if (this.exception instanceof ExceptionObjectNotAlive) {
                JInternalFrame[] jInternalFrameArray = Hugin.mainFrame.desktop.getAllFrames();
                for (int i = 0; i < jInternalFrameArray.length; ++i) {
                    try {
                        printWriter.println("--------------------------------------------------");
                        printWriter.println("         " + jInternalFrameArray[i].getTitle());
                        printWriter.println("--------------------------------------------------");
                        NodeList nodeList = ((HuginProjectFrame)jInternalFrameArray[i]).getNetworkPanel().getHome().getNodes();
                        printWriter.println("Contains");
                        Object object = nodeList.iterator();
                        while (object.hasNext()) {
                            COM.hugin.HAPI.Node node = (COM.hugin.HAPI.Node)object.next();
                            try {
                                printWriter.println("  " + node.getName() + " of " + node.getClass());
                            }
                            catch (Exception exception) {
                                printWriter.println("Error... Node not alive!!");
                            }
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        printWriter.println("Error... COM.hugin.HAPI.Class not alive!!");
                    }
                }
                printWriter.println("##################################################");
                printWriter.println("             COM.hugin.HAPI.Class listing");
                printWriter.println("##################################################");
                try {
                    ClassList classList = Hugin.mainFrame.cc.getMembers();
                    for (Object object : classList) {
                        printWriter.println("--------------------------------------------------");
                        printWriter.println("         " + ((Class)object).getName());
                        printWriter.println("--------------------------------------------------");
                        printWriter.println("Contains");
                        for (COM.hugin.HAPI.Node node : ((NetworkModel)object).getNodes()) {
                            try {
                                printWriter.println("  " + node.getName() + " of " + node.getClass());
                                if (!(node instanceof DiscreteChanceNode)) continue;
                                printWriter.println("  With " + ((DiscreteChanceNode)node).getNumberOfStates() + " states");
                            }
                            catch (Exception exception) {
                                printWriter.println("Error... Node not alive!!");
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    printWriter.println("Error... COM.hugin.HAPI.Class not alive!!");
                }
                try {
                    printWriter.println("--------------------------------------------------");
                    printWriter.println("          Selected node listing ");
                    printWriter.println("--------------------------------------------------");
                    printWriter.println("         " + Hugin.mainFrame.getSelectedProjectFrame().getTitle());
                    printWriter.println("  Selected node : " + ((Node)Hugin.mainFrame.getSelectedProjectFrame().getNetworkPanel().selectedNodes.get(0)).getName());
                    printWriter.println("  Selected API node : " + ((Node)Hugin.mainFrame.getSelectedProjectFrame().getNetworkPanel().selectedNodes.get(0)).getAPINode().getName());
                }
                catch (Exception exception) {
                    printWriter.println(exception);
                    printWriter.println("Error... Selected node not alive!!");
                }
            }
        }
        if (this.includeNetFile) {
            printWriter.println("============================================================");
            printWriter.println("========================  NET file  ========================");
            printWriter.println("============================================================");
            printWriter.println();
            this.printNet(printWriter);
            printWriter.println();
        }
        printWriter.println();
        printWriter.println("============================================================");
        printWriter.println("======================  debug/info.txt  ====================");
        printWriter.println("============================================================");
        printWriter.println();
        printWriter.println(HuginGUIConstants.getDebugInfoAtMakeTime());
        printWriter.println("*******************  END OF BUG REPORT  ********************");
        printWriter.println();
        printWriter.println();
        printWriter.close();
    }

    private void printNet(PrintWriter printWriter) {
        String string = "hbr" + new Date().getTime() + ".net";
        HuginProjectFrame huginProjectFrame = (HuginProjectFrame)this.frame.desktop.getSelectedFrame();
        try {
            String string2;
            if (huginProjectFrame == null || huginProjectFrame.getNetworkPanel() == null || huginProjectFrame.getNetworkPanel().getHome() == null) {
                return;
            }
            huginProjectFrame.getNetworkPanel().getHome().saveAsNet(string);
            File file = new File(string);
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string2 = bufferedReader.readLine()) != null) {
                printWriter.println(string2);
            }
            bufferedReader.close();
            file.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void noFileSpecified(Component component) {
        new JOptionPane();
        JOptionPane.showMessageDialog(component, HuginGUIConstants.get("BUG_REPORT_NO_FILE_DESC"), HuginGUIConstants.get("BUG_REPORT_NO_FILE_ERROR"), 0);
    }

    private static void noEmailSpecified(Component component) {
        new JOptionPane();
        JOptionPane.showMessageDialog(component, HuginGUIConstants.get("BUG_REPORT_NO_EMAIL_DESC"), HuginGUIConstants.get("BUG_REPORT_NO_EMAIL_ERROR"), 0);
    }
}

