/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.ExceptionObjectNotAlive;
import COM.hugin.HAPI.ExceptionUsage;
import COM.hugin.HAPI.IntervalDCNode;
import COM.hugin.HAPI.Node;
import COM.hugin.HGUI.CaseCountVariable;
import COM.hugin.HGUI.CorruptTemplateException;
import COM.hugin.HGUI.DiscretizeProcess;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.InvalidDataException;
import COM.hugin.HGUI.Variable;
import java.util.HashMap;

public class Case {
    private Variable[] variables;
    private Variable[] missingVar;
    private Domain domain;
    private HashMap<String, double[]> existingIntervals = new HashMap();
    private int caseCountIndex = -1;
    private double caseCount = 1.0;
    public static final int CREATE_NODES_AND_STATES = 0;
    public static final int DONT_CREATE = 1;
    private int mode = 0;

    public Case() {
    }

    public Case(String[] stringArray) throws ExceptionHugin, InvalidDataException {
        this(stringArray, new Domain(), 0);
    }

    public Case(String[] stringArray, Domain domain, int n) throws ExceptionHugin, InvalidDataException {
        int n2;
        this.domain = domain;
        this.mode = n;
        this.setVariables(stringArray, domain, n);
        int n3 = 0;
        for (n2 = 0; n2 < this.variables.length; ++n2) {
            if (this.variables[n2].containsNode()) continue;
            ++n3;
        }
        n2 = 0;
        if (n3 > 0) {
            this.missingVar = new Variable[n3];
            for (int i = 0; i < this.variables.length; ++i) {
                if (this.variables[i].containsNode()) continue;
                this.missingVar[n2++] = this.variables[i];
            }
        }
    }

    public void setMode(int n) {
        this.mode = n;
    }

    public int getMode() {
        return this.mode;
    }

    protected boolean enterValues(String[] stringArray) throws InvalidDataException, CorruptTemplateException {
        boolean bl = false;
        try {
            if (stringArray.length != this.variables.length) {
                throw new InvalidDataException(HuginGUIConstants.get("str_incorrect_number_of_fields_in_data_lb_exptected_ARG0_but_got_ARG1_at_case_ARG2", new String[]{"" + this.variables.length, "" + stringArray.length, "" + (this.domain.getNumberOfCases() + 1)}));
            }
            for (int i = 0; i < this.variables.length; ++i) {
                bl = this.variables[i].setState(stringArray[i], this.domain.getNumberOfCases()) || bl;
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            throw new CorruptTemplateException(HuginGUIConstants.get("str_template_no_longer_valid"));
        }
        catch (InvalidDataException invalidDataException) {
            throw invalidDataException;
        }
        return bl;
    }

    protected Case duplicate() {
        Case case_ = new Case();
        case_.variables = new Variable[this.variables.length];
        for (int i = 0; i < this.variables.length; ++i) {
            case_.variables[i] = (Variable)this.variables[i].clone();
        }
        case_.domain = this.domain;
        case_.caseCountIndex = this.caseCountIndex;
        case_.caseCount = this.caseCount;
        return case_;
    }

    protected void setVariableNode(String string, IntervalDCNode intervalDCNode) throws ExceptionHugin {
        for (int i = 0; i < this.variables.length; ++i) {
            if (this.variables[i].isExcluded() || !this.variables[i].getNodeName().equals(string)) continue;
            this.variables[i].setIntervalNode(intervalDCNode);
            return;
        }
    }

    protected void resetVariableNode(String string) throws ExceptionHugin {
        for (int i = 0; i < this.variables.length; ++i) {
            if (this.variables[i].isExcluded() || !this.variables[i].getNodeName().equals(string)) continue;
            this.variables[i].resetNode(this.domain);
            return;
        }
    }

    protected void updateVariableNodeIntervals(String string, DiscretizeProcess.Interval[] intervalArray) throws ExceptionHugin {
        for (int i = 0; i < this.variables.length; ++i) {
            if (this.variables[i].isExcluded() || !this.variables[i].getNodeName().equals(string)) continue;
            IntervalDCNode intervalDCNode = this.variables[i].getIntervalNode();
            intervalDCNode.setNumberOfStates(intervalArray.length);
            for (int j = 0; j < intervalArray.length; ++j) {
                intervalDCNode.setStateValue(j, intervalArray[j].lower);
                intervalDCNode.setStateLabel(j, intervalArray[j].toString());
            }
            intervalDCNode.setStateValue(intervalArray.length, intervalArray[intervalArray.length - 1].upper);
            return;
        }
    }

    protected void updateVariables() throws ExceptionHugin {
        for (int i = 0; i < this.variables.length; ++i) {
            Node node;
            if (this.variables[i].isExcluded() || this.variables[i] instanceof CaseCountVariable || (node = this.domain.getNodeByName(this.variables[i].getNodeName())) == null) continue;
            this.variables[i].setNode(node);
        }
    }

    protected void setVariables(String[] stringArray, Domain domain, int n) throws ExceptionHugin {
        int n2;
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (!stringArray[n2].trim().equals("#")) continue;
            this.caseCountIndex = n2;
            break;
        }
        this.variables = new Variable[stringArray.length];
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            this.variables[n2] = stringArray[n2].trim().equals("#") ? new CaseCountVariable(domain) : new Variable(stringArray[n2], domain, n);
        }
        if (n == 0) {
            for (Node node : domain.getNodes()) {
                String string = node.getName();
                boolean bl = false;
                for (int i = 0; i < this.variables.length && !bl; ++i) {
                    bl = string.equals(this.variables[i].getNodeName());
                }
                if (bl) continue;
                node.delete();
            }
        }
    }

    protected void reinitialize(String[] stringArray) throws ExceptionHugin {
        for (int i = 0; i < this.variables.length; ++i) {
            if (stringArray[i] == null && !this.variables[i].isExcluded()) {
                double[] dArray;
                if (this.mode == 0 && (dArray = this.variables[i].getIntervals()) != null) {
                    this.existingIntervals.put(this.variables[i].getNodeName(), dArray);
                }
                this.variables[i].exclude();
            }
            if (stringArray[i] == null || !this.variables[i].isExcluded()) continue;
            if (this.mode == 0) {
                if (this.existingIntervals.containsKey(stringArray[i])) {
                    this.variables[i].include(stringArray[i], this.existingIntervals.get(stringArray[i]));
                    this.existingIntervals.remove(stringArray[i]);
                    continue;
                }
                this.variables[i].include(stringArray[i]);
                continue;
            }
            this.variables[i].include(stringArray[i]);
        }
    }

    protected boolean insert() throws ExceptionHugin, InvalidDataException {
        boolean bl = false;
        this.domain.newCase();
        this.domain.setCaseCount(this.domain.getNumberOfCases() - 1, this.caseCount);
        for (int i = 0; i < this.variables.length; ++i) {
            if (this.variables[i] == null) continue;
            bl = this.variables[i].insert() || bl;
        }
        return bl;
    }

    protected boolean insertOrCreate() throws ExceptionHugin, InvalidDataException {
        boolean bl = false;
        this.domain.newCase();
        this.domain.setCaseCount(this.domain.getNumberOfCases() - 1, this.caseCount);
        for (int i = 0; i < this.variables.length; ++i) {
            if (this.variables[i] == null) continue;
            bl = this.variables[i].insertOrCreate() || bl;
        }
        return bl;
    }

    protected Domain getDomain() {
        return this.domain;
    }

    protected boolean hasCaseCounts() {
        return this.caseCountIndex >= 0;
    }

    protected void close() throws ExceptionHugin {
        try {
            this.domain.delete();
        }
        catch (ExceptionObjectNotAlive exceptionObjectNotAlive) {
            // empty catch block
        }
    }

    public String toString() {
        String string = "";
        if (this.variables.length == 0) {
            return HuginGUIConstants.get("str__empty_");
        }
        boolean bl = false;
        for (int i = 0; i < this.variables.length; ++i) {
            String string2 = this.variables[i].toString();
            if (string2 == null) continue;
            if (bl) {
                string = string + ",";
            }
            bl = true;
            string = string + string2;
        }
        return string;
    }

    public String printNames() throws ExceptionHugin {
        String string = "";
        boolean bl = true;
        for (int i = 0; i < this.variables.length; ++i) {
            if (this.variables[i].isExcluded()) continue;
            if (!bl) {
                string = string + ", ";
            }
            string = this.variables[i] instanceof CaseCountVariable ? string + "#" : string + this.variables[i].getName();
            bl = false;
        }
        return string;
    }

    public String printRealNames() throws ExceptionHugin {
        String string = "";
        boolean bl = true;
        for (int i = 0; i < this.variables.length; ++i) {
            if (this.variables[i].isExcluded()) continue;
            if (!bl) {
                string = string + ", ";
            }
            string = this.variables[i] instanceof CaseCountVariable ? string + "#" : string + this.variables[i].getRealName();
            bl = false;
        }
        return string;
    }

    public Variable[] getVariables() {
        return this.variables;
    }

    public String[] getFieldNames() {
        String[] stringArray = new String[this.variables.length];
        for (int i = 0; i < this.variables.length; ++i) {
            stringArray[i] = this.variables[i].getName();
        }
        return stringArray;
    }

    public void relabelVariables(String[][] stringArray) throws ExceptionHugin {
        if (stringArray.length != this.variables.length) {
            throw new ExceptionUsage(HuginGUIConstants.get("str_invalid_number_of_variables"));
        }
        for (int i = 0; i < this.variables.length; ++i) {
            if (!this.variables[i].getNodeName().equals(stringArray[i][0])) {
                throw new ExceptionUsage(HuginGUIConstants.get("str_invalid_order_of_variables"));
            }
            if (stringArray[i][1].trim().length() == 0) continue;
            this.variables[i].relabel(stringArray[i][1].trim());
        }
    }

    public int getCaseCountIndex() {
        return this.caseCountIndex;
    }

    public Variable[] getMissingVariables() {
        return this.missingVar;
    }

    public String[] getMissingFieldNames() {
        String[] stringArray = new String[this.missingVar.length];
        for (int i = 0; i < this.missingVar.length; ++i) {
            stringArray[i] = this.missingVar[i].getName();
        }
        return stringArray;
    }
}

