/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.ContinuousChanceNode;
import COM.hugin.HAPI.DiscreteNode;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.Node;
import java.util.ArrayList;
import java.util.HashMap;

public class CaseBank {
    private Domain domain;
    private int numberOfCases;
    private HashMap<Node, ArrayList<Integer>> DCCNodes;
    private HashMap<Node, ArrayList<Double>> CCNodes;

    public CaseBank(Domain domain) throws ExceptionHugin {
        this.domain = domain;
        this.numberOfCases = 0;
        this.DCCNodes = new HashMap();
        this.CCNodes = new HashMap();
        for (Node node : this.domain.getNodes()) {
            if (node instanceof DiscreteNode) {
                this.DCCNodes.put(node, new ArrayList());
                continue;
            }
            if (!(node instanceof ContinuousChanceNode)) continue;
            this.CCNodes.put(node, new ArrayList());
        }
    }

    public int newCase() throws ExceptionHugin {
        int n = this.numberOfCases++;
        block0: for (Node node : this.domain.getNodes()) {
            ArrayList<Number> arrayList;
            Node node2;
            if (node instanceof DiscreteNode) {
                node2 = (DiscreteNode)node;
                arrayList = this.DCCNodes.get(node2);
                if (node2.evidenceIsEntered()) {
                    int n2 = ((DiscreteNode)node2).getNumberOfStates();
                    for (int i = 0; i < n2; ++i) {
                        if (!(((DiscreteNode)node2).getEnteredFinding(i) > 0.0)) continue;
                        arrayList.add(new Integer(i));
                        continue block0;
                    }
                    continue;
                }
                arrayList.add(null);
                continue;
            }
            if (!(node instanceof ContinuousChanceNode)) continue;
            node2 = (ContinuousChanceNode)node;
            arrayList = this.CCNodes.get(node2);
            if (node2.evidenceIsEntered()) {
                arrayList.add(new Double(((ContinuousChanceNode)node2).getEnteredValue()));
                continue;
            }
            arrayList.add(null);
        }
        return n;
    }

    public void enterCase(int n) throws ExceptionHugin {
        this.domain.retractFindings();
        for (Node node : this.domain.getNodes()) {
            Number number;
            ArrayList<Number> arrayList;
            Node node2;
            if (node instanceof DiscreteNode) {
                node2 = (DiscreteNode)node;
                arrayList = this.DCCNodes.get(node2);
                number = arrayList.get(n);
                if (number == null) {
                    ((DiscreteNode)node2).retractFindings();
                    continue;
                }
                ((DiscreteNode)node2).selectState((Integer)number);
                continue;
            }
            if (!(node instanceof ContinuousChanceNode)) continue;
            node2 = (ContinuousChanceNode)node;
            arrayList = this.CCNodes.get(node2);
            number = (Double)arrayList.get(n);
            if (number == null) {
                ((ContinuousChanceNode)node2).retractFindings();
                continue;
            }
            ((ContinuousChanceNode)node2).enterValue((Double)number);
        }
    }

    public void copyCasesToDomain(int n, int n2) throws ExceptionHugin {
        for (int i = n; i <= n2; ++i) {
            int n3 = this.domain.newCase();
            for (Node node : this.domain.getNodes()) {
                Number number;
                ArrayList<Number> arrayList;
                Node node2;
                if (node instanceof DiscreteNode) {
                    node2 = (DiscreteNode)node;
                    arrayList = this.DCCNodes.get(node2);
                    number = arrayList.get(i);
                    if (number == null) continue;
                    ((DiscreteNode)node2).setCaseState(n3, (Integer)number);
                    continue;
                }
                if (!(node instanceof ContinuousChanceNode) || (number = (Double)(arrayList = this.CCNodes.get(node2 = (ContinuousChanceNode)node)).get(i)) == null) continue;
                ((ContinuousChanceNode)node2).setCaseValue(n3, (Double)number);
            }
        }
    }

    public void copyCasesFromDomain() throws ExceptionHugin {
        int n = this.domain.getNumberOfCases();
        for (int i = 0; i < n; ++i) {
            this.domain.enterCase(i);
            this.newCase();
        }
        this.domain.retractFindings();
    }

    public int getNumberOfCases() {
        return this.numberOfCases;
    }
}

