/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.Link;
import COM.hugin.HGUI.Node;
import COM.hugin.HGUI.UncertainLink;
import java.util.LinkedList;

public class CertainUndirectedLink
extends Link {
    private int regionID;
    private LinkedList<UncertainLink.LinkSelectionListener> listeners;
    public static final int FORWARD = 0;
    public static final int BACKWARD = 1;

    public CertainUndirectedLink(Node node, Node node2, double d) {
        super(node, node2, d);
        this.color = HuginGUIConstants.CERTAIN_UNDIRECTED_LINK_COLOR;
        this.isDirected(false);
        this.listeners = new LinkedList();
    }

    public void directLink(int n) throws ExceptionHugin {
        if (n == 0) {
            this.child.getAPINode().addPdagParent(this.parent.getAPINode());
        }
        if (n == 1) {
            this.parent.getAPINode().addPdagParent(this.child.getAPINode());
        }
    }

    public void addLinkSelectionListener(UncertainLink.LinkSelectionListener linkSelectionListener) {
        this.listeners.add(linkSelectionListener);
    }

    public void removeLinkSelectionListener(UncertainLink.LinkSelectionListener linkSelectionListener) {
        this.listeners.remove(linkSelectionListener);
    }

    protected void fireToolTipChanged() {
        for (UncertainLink.LinkSelectionListener linkSelectionListener : this.listeners) {
            linkSelectionListener.linkSelected(this);
        }
    }

    public void select() {
        super.select();
        this.fireToolTipChanged();
    }

    public boolean equals(Object object) {
        if (!(object instanceof CertainUndirectedLink)) {
            return false;
        }
        return !(!this.parent.getName().equals(((Link)object).parent.getName()) && !this.parent.getName().equals(((Link)object).child.getName()) || !this.child.getName().equals(((Link)object).parent.getName()) && !this.child.getName().equals(((Link)object).child.getName()));
    }

    public String toString() {
        try {
            return this.parent.getName() + " - " + this.child.getName();
        }
        catch (Exception exception) {
            return "Error";
        }
    }
}

