/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.Class;
import COM.hugin.HAPI.ContinuousChanceNode;
import COM.hugin.HAPI.DiscreteNode;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.NetworkModel;
import COM.hugin.HAPI.Node;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIUtils;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.ListIterator;

public class ClassInfo {
    private NetworkModel cls;
    private LinkedList<String> elimOrder;
    private LinkedList<Evidence> evidence;
    private boolean isPre60;
    private boolean isSaved;
    private boolean isCompiled;
    private boolean containsUnpropagatedEvidence;
    private String pathName;
    private int fileType;
    private File logFile;

    public ClassInfo(Class clazz, String string) {
        this.cls = clazz;
        this.isPre60 = false;
        this.isSaved = false;
        this.isCompiled = false;
        this.containsUnpropagatedEvidence = false;
        this.elimOrder = null;
        this.evidence = null;
        this.fileType = 3;
        this.pathName = "";
        try {
            if (string != null && string.length() > 0) {
                this.pathName = string.substring(0, string.lastIndexOf(".hlg")) + ".oobn";
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.logFile = new File(string);
    }

    public ClassInfo(ClassInfo classInfo) {
        this.cls = classInfo.cls;
        this.isPre60 = classInfo.isPre60;
        this.isSaved = classInfo.isSaved;
        this.isCompiled = classInfo.isCompiled;
        this.containsUnpropagatedEvidence = classInfo.containsUnpropagatedEvidence;
        this.elimOrder = classInfo.elimOrder;
        this.evidence = classInfo.evidence;
        this.fileType = classInfo.fileType;
        this.pathName = classInfo.pathName;
        this.logFile = classInfo.logFile;
    }

    public ClassInfo(Class clazz, boolean bl, Domain domain, boolean bl2, int n, String string) throws ExceptionHugin {
        this.cls = clazz != null ? clazz : domain;
        this.isSaved = bl;
        this.isCompiled = false;
        this.containsUnpropagatedEvidence = false;
        this.elimOrder = null;
        this.evidence = null;
        if (domain != null) {
            this.isCompiled = domain.isCompiled();
            if (this.isCompiled) {
                this.createElimOrder(domain.getEliminationOrder());
                this.storeEvidence(domain);
            }
        }
        this.isPre60 = bl2;
        this.fileType = n;
        this.pathName = string;
        this.logFile = new File(this.stripPathNameExtension() + ".hlg");
    }

    private void createElimOrder(NodeList nodeList) throws ExceptionHugin {
        if (this.elimOrder != null) {
            this.elimOrder.clear();
        } else {
            this.elimOrder = new LinkedList();
        }
        for (Node node : nodeList) {
            this.elimOrder.add(node.getName());
        }
    }

    private String stripPathNameExtension() {
        int n = this.pathName.lastIndexOf(".");
        if (n < 0) {
            return this.pathName;
        }
        return this.pathName.substring(0, n);
    }

    public void saveUpdate(String string, int n) {
        try {
            this.fileType = n;
            this.isPre60 = n != 3;
            this.isSaved = true;
            if (!this.pathName.equals(string)) {
                this.setPathName(string);
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
        }
    }

    public void openLogFile(boolean bl) throws ExceptionHugin {
        block7: {
            try {
                this.cls.openLogFile(this.logFile.getCanonicalPath(), bl);
            }
            catch (Exception exception) {
                try {
                    File file = new File(this.stripPathNameExtension());
                    if (!file.canWrite()) {
                        this.logFile = new File(Hugin.mainFrame.getLogFileDir() + file.getName() + ".hlg");
                    }
                    this.cls.openLogFile(this.logFile.getCanonicalPath(), bl);
                }
                catch (Exception exception2) {
                    if (bl) break block7;
                    try {
                        new HuginGUIError(HuginGUIConstants.get("str_unable_to_create_log_file_ARG0", new String[]{this.logFile.getCanonicalPath()}));
                    }
                    catch (Exception exception3) {
                        new HuginGUIError(HuginGUIConstants.get("str_unable_to_create_log_file_ARG0", new String[]{"PATH_ERROR"}));
                    }
                }
            }
        }
    }

    public void closeLogFile() throws ExceptionHugin, IOException {
        this.cls.closeLogFile();
    }

    private void setLogFile(String string) throws ExceptionHugin {
        String string2 = this.cls.getLogFile();
        if (string2 == null || !string2.equals(string)) {
            this.cls.closeLogFile();
            File file = new File(string);
            this.logFile.renameTo(file);
            this.logFile = file;
            this.openLogFile(true);
        }
    }

    public void setPathName(String string) throws ExceptionHugin {
        this.pathName = string;
        while (this.pathName.indexOf("//") >= 0) {
            this.pathName = this.pathName.replaceAll("//", "/");
        }
        this.setLogFile(this.stripPathNameExtension() + ".hlg");
    }

    public void setPathNameWithoutLogfileSideEffect(String string) throws ExceptionHugin {
        this.pathName = string;
        while (this.pathName.indexOf("//") >= 0) {
            this.pathName = this.pathName.replaceAll("//", "/");
        }
    }

    public boolean isClass() {
        return this.cls instanceof Class;
    }

    public Class getCls() {
        return this.isClass() ? (Class)this.cls : null;
    }

    public Domain getDomain() {
        return this.isClass() ? null : (Domain)this.cls;
    }

    public NetworkModel getNetworkModel() {
        return this.cls;
    }

    public void setCls(Class clazz) {
        this.cls = clazz;
    }

    public int getFileType() {
        return this.fileType;
    }

    public void setFileType(int n) {
        this.fileType = n;
    }

    public boolean isSaved() {
        return this.isSaved;
    }

    public void isSaved(boolean bl) {
        this.isSaved = bl;
    }

    public boolean isPre60() {
        return this.isPre60;
    }

    public void isPre60(boolean bl) {
        this.isPre60 = bl;
    }

    public boolean isCompiled() {
        boolean bl = this.isCompiled;
        this.isCompiled = false;
        return bl;
    }

    public boolean containsUnpropagatedEvidence() {
        return this.containsUnpropagatedEvidence;
    }

    public String getPathName() {
        return this.pathName;
    }

    public File getLogFile() {
        return this.logFile;
    }

    public Domain getCompiledDomain() throws ExceptionHugin {
        if (!this.isClass()) {
            Domain domain = this.getDomain();
            HuginGUIUtils.configureDomain(domain);
            if (!domain.isCompiled()) {
                domain.compile(this.getOrder(domain));
            }
            if (domain.getAttribute("HR_Propagate_Auto").equals("1")) {
                domain.propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
            }
            return domain;
        }
        Domain domain = HuginGUIUtils.createDomain(this.getCls());
        this.cls.closeLogFile();
        domain.openLogFile(this.logFile.getPath(), true);
        HuginGUIUtils.configureDomain(domain);
        this.restoreEvidence(domain);
        domain.compile(this.getOrder(domain));
        if (domain.getAttribute("HR_Propagate_Auto").equals("1")) {
            domain.propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
        }
        domain.closeLogFile();
        return domain;
    }

    private NodeList getOrder(Domain domain) throws ExceptionHugin {
        NodeList nodeList = new NodeList();
        for (String string : this.elimOrder) {
            nodeList.add(domain.getNodeByName(string));
        }
        return nodeList;
    }

    private void storeEvidence(Domain domain) throws ExceptionHugin {
        this.evidence = new LinkedList();
        for (Node node : domain.getNodes()) {
            Evidence evidence = new Evidence(node);
            this.evidence.add(evidence);
            this.containsUnpropagatedEvidence = true;
        }
    }

    private void restoreEvidence(Domain domain) {
        try {
            for (Evidence evidence : this.evidence) {
                Node node = domain.getNodeByName(evidence.name);
                if (node instanceof DiscreteNode) {
                    this.restoreEvidence((DiscreteNode)node, evidence);
                    continue;
                }
                if (!(node instanceof ContinuousChanceNode)) continue;
                this.restoreEvidence((ContinuousChanceNode)node, evidence);
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        this.evidence.clear();
    }

    private void restoreEvidence(DiscreteNode discreteNode, Evidence evidence) {
        try {
            ListIterator listIterator = evidence.evidence.listIterator();
            int n = discreteNode.getNumberOfStates();
            for (int i = 0; i < n && listIterator.hasNext(); ++i) {
                discreteNode.enterFinding(i, (Double)listIterator.next());
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    private void restoreEvidence(ContinuousChanceNode continuousChanceNode, Evidence evidence) {
        try {
            if (evidence.evidence.size() > 0) {
                continuousChanceNode.enterValue(evidence.evidence.get(0));
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    private class Evidence {
        LinkedList<Double> evidence;
        String name;

        public Evidence(Node node) {
            try {
                ContinuousChanceNode continuousChanceNode;
                this.name = node.getName();
                this.evidence = new LinkedList();
                if (node instanceof DiscreteNode) {
                    DiscreteNode discreteNode = (DiscreteNode)node;
                    int n = discreteNode.getNumberOfStates();
                    for (int i = 0; i < n; ++i) {
                        this.evidence.add(new Double(discreteNode.getEnteredFinding(i)));
                    }
                } else if (node instanceof ContinuousChanceNode && (continuousChanceNode = (ContinuousChanceNode)node).evidenceIsEntered()) {
                    this.evidence.add(new Double(continuousChanceNode.getEnteredValue()));
                }
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }
    }
}

