/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIFrame;
import COM.hugin.HGUI.HuginProjectFrame;
import COM.hugin.HGUI.InstanceNode;
import COM.hugin.HGUI.NetworkPanel;
import COM.hugin.HGUI.Node;
import COM.hugin.HGUI.zoom.ZoomableComponent;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ComponentTree
extends JPanel
implements ZoomableComponent {
    private int DEFAULT_FONT_SIZE = 12;
    private Font DEFAULT_FONT = new Font(HuginGUIConstants.defaultFont.getName(), 0, this.DEFAULT_FONT_SIZE);
    private Component root = null;
    private HuginGUIFrame guiFrame = null;
    private int fontSize;
    private LinkedList<Component> components = new LinkedList();
    private double scaleFactor = 1.0;
    private JPanel treePanel;
    private HuginProjectFrame projectFrame;
    public NetworkPanel panel;

    public ComponentTree(NetworkPanel networkPanel) {
        this.panel = networkPanel;
        this.guiFrame = networkPanel.guiFrame;
        this.projectFrame = networkPanel.projectFrame;
        this.root = new Component(networkPanel.projectFrame.getTitle(), networkPanel);
        for (Node node : networkPanel.nodeList) {
            if (!(node instanceof InstanceNode)) continue;
            this.root.addChild(new Component(this.root, (InstanceNode)node));
        }
        this.root.grow();
        this.treePanel = new JPanel();
        BoxLayout boxLayout = new BoxLayout(this.treePanel, 1);
        this.treePanel.setLayout(boxLayout);
        this.treePanel.setOpaque(false);
        this.insertComponents();
        this.setOpaque(false);
        this.setLayout(new FlowLayout(0));
        this.add(this.treePanel);
        this.validate();
    }

    public void insertComponents() {
        LinkedList<Component> linkedList = new LinkedList<Component>();
        linkedList.add(this.root);
        int n = 0;
        while (linkedList.size() > 0) {
            JPanel jPanel = new JPanel(new FlowLayout(1));
            jPanel.setOpaque(false);
            this.treePanel.add(jPanel);
            LinkedList<Component> linkedList2 = new LinkedList<Component>();
            for (Component component : linkedList) {
                jPanel.add(component);
                component.setTreeLevel(n);
                linkedList2.addAll(component.getChildren());
            }
            linkedList = linkedList2;
            this.components.addAll(linkedList2);
            ++n;
        }
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(this.getForeground());
        this.paintComponent(graphics);
        this.paintBorder(graphics);
        graphics.setColor(Color.black);
        for (Component component : this.components) {
            graphics.drawLine(component.getX() + component.getWidth() / 2, component.getTreeY() + component.getHeight() / 2, component.getComParent().getX() + component.getComParent().getWidth() / 2, component.getComParent().getTreeY() + component.getComParent().getHeight() / 2);
        }
        this.paintChildren(graphics);
    }

    public HuginProjectFrame getHuginProjectFrame() {
        return this.projectFrame;
    }

    public void setScaleFactor(double d) {
        this.scaleFactor = d;
        for (Component component : this.components) {
            component.setFont(this.DEFAULT_FONT.deriveFont((float)this.scaleFactor * (float)this.DEFAULT_FONT_SIZE));
        }
        this.root.setFont(this.DEFAULT_FONT.deriveFont((float)this.scaleFactor * (float)this.DEFAULT_FONT_SIZE));
        this.repaint(this.getBounds(null));
        this.validate();
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Component
    extends JLabel {
        private Component parent;
        private NetworkPanel netClass;
        private LinkedList<Component> children;
        private String className;
        private int treeLevel = 0;

        public Component(String string, NetworkPanel networkPanel) {
            this.parent = null;
            this.children = new LinkedList();
            this.netClass = networkPanel;
            this.className = string;
            this.configureVisual();
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    try {
                        ((Component)mouseEvent.getComponent()).bringNetworkToFront();
                    }
                    catch (Exception exception) {
                        new HuginGUIError(exception);
                    }
                }
            });
        }

        public Component(Component component, InstanceNode instanceNode) {
            this.parent = component;
            this.children = new LinkedList();
            ComponentTree.this.guiFrame;
            this.netClass = HuginGUIFrame.getNetworkPanel(instanceNode.instanceOf);
            try {
                this.className = this.netClass.getHomeClass().getName();
            }
            catch (ExceptionHugin exceptionHugin) {
                new HuginGUIError(exceptionHugin);
            }
            this.configureVisual();
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    try {
                        ((Component)mouseEvent.getComponent()).bringNetworkToFront();
                    }
                    catch (Exception exception) {
                        new HuginGUIError(exception);
                    }
                }
            });
        }

        public void configureVisual() {
            this.setHorizontalAlignment(0);
            this.setText(this.className);
            this.setBorder(BorderFactory.createLineBorder(Color.black, 2));
            this.setBackground(Color.white);
            this.setOpaque(true);
            this.setMaximumSize(this.getPreferredSize());
        }

        public void bringNetworkToFront() {
            this.netClass.projectFrame.setSelected(true);
        }

        public void grow() {
            for (Component component : this.children) {
                component.findChildren();
            }
        }

        public void findChildren() {
            for (Node node : this.netClass.nodeList) {
                if (!(node instanceof InstanceNode)) continue;
                Component component = new Component(this, (InstanceNode)node);
                this.addChild(component);
                component.findChildren();
            }
        }

        public void addChild(Component component) {
            this.children.add(component);
        }

        public LinkedList<Component> getChildren() {
            return this.children;
        }

        public Component getComParent() {
            return this.parent;
        }

        public void setTreeLevel(int n) {
            this.treeLevel = n;
        }

        public int getTreeY() {
            return this.getY() + this.getParent().getHeight() * this.treeLevel;
        }
    }
}

