/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.DiscreteChanceNode;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HGUI.BeliefBarPanel;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConflictResolutionHypothesis
implements Comparable<ConflictResolutionHypothesis> {
    private DiscreteChanceNode node;
    private int state;
    private double value;
    private double threshold;
    private BeliefBarPanel owner;

    public ConflictResolutionHypothesis(BeliefBarPanel beliefBarPanel, DiscreteChanceNode discreteChanceNode, int n, double d, double d2) {
        this.owner = beliefBarPanel;
        this.node = discreteChanceNode;
        this.state = n;
        this.value = d;
        this.threshold = d2;
    }

    public DiscreteChanceNode getNode() {
        return this.node;
    }

    public int getState() {
        return this.state;
    }

    public double getValue() {
        return this.value;
    }

    public int getNormalizedValue() throws ExceptionHugin {
        return (int)(this.value * 100.0 / this.threshold);
    }

    public double getResultingValue() {
        return this.threshold - this.value;
    }

    public String toString() {
        try {
            return HuginGUIUtils.printDouble(this.getResultingValue(), 2) + ": " + HuginGUIUtils.getNodeTitle(this.node) + " = " + HuginGUIUtils.getNodeStateLabel(this.node, this.state);
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
            return HuginGUIConstants.get("str__error_");
        }
    }

    public void instantiate(boolean bl) throws ExceptionHugin {
        this.node.selectState(this.state);
        if (bl) {
            Domain domain = this.node.getHomeDomain();
            Domain.Equilibrium equilibrium = domain.equilibriumIs(Domain.H_EQUILIBRIUM_SUM) ? Domain.H_EQUILIBRIUM_SUM : Domain.H_EQUILIBRIUM_MAX;
            Domain.EvidenceMode evidenceMode = domain.evidenceModeIs(Domain.H_EVIDENCE_MODE_NORMAL) ? Domain.H_EVIDENCE_MODE_NORMAL : Domain.H_EVIDENCE_MODE_FAST_RETRACTION;
            this.owner.propagate(equilibrium, evidenceMode);
        }
    }

    @Override
    public int compareTo(ConflictResolutionHypothesis conflictResolutionHypothesis) {
        if (this.getValue() < conflictResolutionHypothesis.getValue()) {
            return 1;
        }
        if (this.getValue() > conflictResolutionHypothesis.getValue()) {
            return -1;
        }
        return 0;
    }
}

