/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.DiscreteChanceNode;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HAPI.Table;
import COM.hugin.HGUI.DiscreteNodeTableModel;
import COM.hugin.HGUI.GenericTable;
import COM.hugin.HGUI.HuginComboBox;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.ModeGraphicTable;
import COM.hugin.HGUI.Node;
import COM.hugin.HGUI.NodeTable;
import COM.hugin.HGUI.ParameterSensitivityWizard;
import COM.hugin.HGUI.TableSorter;
import COM.hugin.HGUI.TableWrapper;
import COM.hugin.HGUI.TitledPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintsPanel
extends JPanel {
    private final int NodeComboWidth = 200;
    private final int StateComboWidth = 80;
    private final String GREATER_EQUAL_STRING = ">=";
    private final String EQUAL_STRING = "==";
    private final String LESS_EQUAL_STRING = "<=";
    private final int GREATER_EQUAL = 0;
    private final int EQUAL = 1;
    private final int LESS_EQUAL = 2;
    public static int CONSTRAINT = 0;
    public static int SUGGESTED = 1;
    public static int ABSOLUTE = 2;
    public static int LOGODDS = 3;
    private final String RATIO = "/";
    private final String DIFFERENCE = "-";
    private Domain domain;
    private ParameterSensitivityWizard psw;
    private Vector<String> nodeNameList;
    private HuginComboBox node1Combo;
    private HuginComboBox node2Combo;
    private HuginComboBox state1Combo;
    private HuginComboBox state2Combo;
    private JComboBox constraint1Combo;
    private JComboBox constraint2Combo;
    private JComboBox arithmeticCombo;
    private JCheckBox twoEventsCheckBox;
    private JLabel node1Label;
    private JLabel node2Label;
    private JLabel constraint1Label;
    private JLabel constraint2Label;
    private JLabel state1Label;
    private JLabel state2Label;
    private JLabel output1Label;
    private JLabel output2Label;
    private JLabel resultLabel;
    private JButton computeButton;
    private JButton editButton;
    private JButton adoptButton;
    private JTextField constraint1Field;
    private JTextField constraint2Field;
    private JPanel inputPanel;
    private JPanel buttonPanel;
    private JPanel resultPanel;
    private JPanel infoPanel;
    private TitledPanel mainPanel;
    private JSeparator separator;
    private JScrollPane viewResultPanel;
    private int precision;
    private Constraints constraints = null;

    public ConstraintsPanel(Domain domain, ParameterSensitivityWizard parameterSensitivityWizard) {
        super(new GridLayout(1, 1));
        this.domain = domain;
        this.psw = parameterSensitivityWizard;
        this.nodeNameList = this.getNodeNameList(parameterSensitivityWizard.getDCNodeList());
        this.precision = 6;
        this.initialize();
        this.enableButtons(false);
        this.add(this.mainPanel);
    }

    private void initialize() {
        this.mainPanel = new TitledPanel(HuginGUIConstants.get("PSW_Tab_Constraints"));
        this.mainPanel.setLayout(new BorderLayout(5, 5));
        this.createInputPanel();
        this.createButtonPanel();
        this.createResultPanel();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.inputPanel, "North");
        jPanel.add((Component)this.buttonPanel, "Center");
        this.mainPanel.add((Component)jPanel, "North");
        this.mainPanel.add((Component)this.resultPanel, "Center");
    }

    private void createInputPanel() {
        this.infoPanel = new JPanel(new GridLayout(1, 1));
        this.separator = new JSeparator();
        Dimension dimension = new Dimension(5, 0);
        Dimension dimension2 = new Dimension(0, 5);
        this.inputPanel = new JPanel(new GridLayout(1, 1));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.twoEventsCheckBox = new JCheckBox("<html><B>" + HuginGUIConstants.get("PSW_Check_Two_Events") + "</B></html>");
        this.twoEventsCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ConstraintsPanel.this.enableTwoEvents(ConstraintsPanel.this.twoEventsCheckBox.isSelected());
            }
        });
        this.constraint1Field = new JTextField(5);
        this.constraint1Field.setText("0.0");
        this.constraint1Field.addFocusListener(new ConstraintFocusListener());
        this.constraint1Field.addKeyListener(new ConstraintKeyListener());
        this.constraint2Field = new JTextField(5);
        this.constraint2Field.setText("Infinity");
        this.constraint2Field.addFocusListener(new ConstraintFocusListener());
        this.constraint2Field.addKeyListener(new ConstraintKeyListener());
        this.node1Label = new JLabel("<html><B>" + HuginGUIConstants.get("PSW_Label_Node1") + "</B></html>");
        this.node1Label.setAlignmentX(0.0f);
        this.node2Label = new JLabel("<html><B>" + HuginGUIConstants.get("PSW_Label_Node2") + "</B></html>");
        this.node2Label.setAlignmentX(0.0f);
        this.constraint1Label = new JLabel("<html><B>" + HuginGUIConstants.get("PSW_Label_Constraint1") + "</B></html>");
        this.constraint1Label.setAlignmentX(0.0f);
        this.constraint2Label = new JLabel("<html><B>" + HuginGUIConstants.get("PSW_Label_Constraint2") + "</B></html>");
        this.constraint2Label.setAlignmentX(0.0f);
        this.state1Label = new JLabel("<html><B>" + HuginGUIConstants.get("PSW_Label_State") + "</B></html>");
        this.state1Label.setAlignmentX(0.0f);
        this.state2Label = new JLabel("<html><B>" + HuginGUIConstants.get("PSW_Label_State") + "</B></html>");
        this.state2Label.setAlignmentX(0.0f);
        this.output1Label = new JLabel();
        this.output2Label = new JLabel();
        this.state1Combo = new HuginComboBox();
        this.state2Combo = new HuginComboBox();
        this.state1Combo.setBackground(Color.WHITE);
        this.state2Combo.setBackground(Color.WHITE);
        this.node1Combo = new HuginComboBox((Vector)this.nodeNameList);
        this.node1Combo.setRenderer(new NodeComboRenderer(this.psw.getDCNodeList()));
        this.node1Combo.addItemListener(new NodeComboListener(this.psw, this.state1Combo));
        this.node1Combo.setBackground(Color.WHITE);
        this.node2Combo = new HuginComboBox((Vector)this.nodeNameList);
        this.node2Combo.setRenderer(new NodeComboRenderer(this.psw.getDCNodeList()));
        this.node2Combo.addItemListener(new NodeComboListener(this.psw, this.state2Combo));
        this.node2Combo.setBackground(Color.WHITE);
        this.state1Combo.addItemListener(new StateComboListener(this.psw, this.node1Combo, this.output1Label));
        this.state2Combo.addItemListener(new StateComboListener(this.psw, this.node2Combo, this.output2Label));
        this.populateCombo(this.psw.getDCNodeList().get(this.node1Combo.getSelectedIndex()), this.state1Combo);
        this.populateCombo(this.psw.getDCNodeList().get(this.node2Combo.getSelectedIndex()), this.state2Combo);
        this.node1Combo.setSelectedIndex(0);
        this.node2Combo.setSelectedIndex(0);
        this.constraint1Combo = new JComboBox<String>(this.getComparisonItems());
        this.constraint1Combo.setPreferredSize(new Dimension(10, this.constraint1Combo.getHeight()));
        this.constraint1Combo.setBackground(Color.WHITE);
        this.constraint2Combo = new JComboBox<String>(this.getComparisonItems());
        this.constraint1Combo.addItemListener(new ConstraintComboListener(this.constraint2Combo));
        this.constraint1Combo.setSelectedIndex(1);
        this.constraint1Combo.setSelectedIndex(0);
        this.constraint2Combo.setPreferredSize(new Dimension(10, this.constraint2Combo.getHeight()));
        this.constraint2Combo.setBackground(Color.WHITE);
        this.arithmeticCombo = new JComboBox<String>(this.getArithmeticItems());
        this.arithmeticCombo.setBackground(Color.WHITE);
        this.node1Combo.validatePopupWidth();
        this.node2Combo.validatePopupWidth();
        this.node1Combo.setPreferredSize(new Dimension(200, this.node1Combo.getPreferredSize().height));
        this.node2Combo.setPreferredSize(new Dimension(200, this.node2Combo.getPreferredSize().height));
        this.enableTwoEvents(this.twoEventsCheckBox.isSelected());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)this.node1Label, "West");
        jPanel3.add(jPanel4);
        jPanel3.add(this.node1Combo);
        jPanel2.add(jPanel3);
        jPanel2.add(Box.createRigidArea(dimension));
        jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)this.state1Label, "West");
        jPanel3.add(jPanel4);
        jPanel3.add(this.state1Combo);
        jPanel2.add(jPanel3);
        jPanel2.add(Box.createRigidArea(dimension));
        jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.add(new JLabel("              "));
        jPanel3.add(this.output1Label);
        jPanel2.add(jPanel3);
        jPanel.add(jPanel2);
        jPanel.add(Box.createRigidArea(dimension2));
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)this.twoEventsCheckBox, "West");
        jPanel2.add(jPanel3);
        jPanel2.add(Box.createRigidArea(dimension));
        jPanel.add(jPanel2);
        TitledPanel titledPanel = new TitledPanel(HuginGUIConstants.get("PSW_Label_Optional"));
        titledPanel.setLayout(new BorderLayout());
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel3 = new JPanel(new BorderLayout());
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add((Component)this.arithmeticCombo, "North");
        jPanel3.add((Component)jPanel5, "West");
        jPanel2.add(jPanel3);
        titledPanel.add((Component)jPanel3, "North");
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)this.node2Label, "West");
        jPanel3.add(jPanel4);
        jPanel3.add(this.node2Combo);
        jPanel2.add(jPanel3);
        jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)this.state2Label, "West");
        jPanel3.add(jPanel4);
        jPanel3.add(this.state2Combo);
        jPanel2.add(jPanel3);
        jPanel2.add(Box.createRigidArea(dimension));
        jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.add(new JLabel("              "));
        jPanel3.add(this.output2Label);
        jPanel2.add(jPanel3);
        titledPanel.add((Component)jPanel2, "South");
        jPanel.add(titledPanel);
        jPanel.add(Box.createRigidArea(dimension2));
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)this.constraint1Label, "North");
        jPanel4 = new JPanel(new GridLayout(1, 2));
        jPanel4.add(this.constraint1Combo);
        jPanel4.add(this.constraint1Field);
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jPanel6.add((Component)jPanel4, "West");
        jPanel3.add((Component)jPanel6, "South");
        jPanel2.add(jPanel3);
        jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)new JLabel("  "), "North");
        jPanel4 = new JPanel(new GridLayout(1, 1));
        JLabel jLabel = new JLabel(HuginGUIConstants.get("PSW_Label_And"));
        jPanel4.add(jLabel);
        jPanel6 = new JPanel(new BorderLayout());
        jPanel6.add((Component)jPanel4, "West");
        jPanel3.add((Component)jPanel6, "South");
        jPanel2.add(jPanel3);
        jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)this.constraint2Label, "North");
        jPanel4 = new JPanel(new GridLayout(1, 2));
        jPanel4.add(this.constraint2Combo);
        jPanel4.add(this.constraint2Field);
        jPanel6 = new JPanel(new BorderLayout());
        jPanel6.add((Component)jPanel4, "West");
        jPanel3.add((Component)jPanel6, "South");
        jPanel2.add(jPanel3);
        jPanel.add(jPanel2);
        jPanel.add(Box.createRigidArea(dimension2));
        JPanel jPanel7 = new JPanel(new BorderLayout());
        jPanel7.add((Component)jPanel, "West");
        this.inputPanel.add(jPanel7);
    }

    private void createButtonPanel() {
        this.buttonPanel = new JPanel(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1));
        this.separator = new JSeparator();
        jPanel2.add(this.separator);
        jPanel2.add(new JLabel(""));
        jPanel.add((Component)jPanel2, "North");
        this.computeButton = new JButton(HuginGUIConstants.get("PSW_Compute"));
        this.computeButton.addActionListener(new ComputeActionListener());
        jPanel.add((Component)this.computeButton, "West");
        JPanel jPanel3 = new JPanel(new GridLayout(1, 2));
        this.editButton = new JButton(HuginGUIConstants.get("PSW_Edit"));
        this.editButton.addActionListener(new EditListener());
        this.adoptButton = new JButton(HuginGUIConstants.get("PSW_Adopt"));
        this.adoptButton.addActionListener(new AdoptListener());
        jPanel3.add(this.editButton);
        jPanel3.add(this.adoptButton);
        jPanel.add((Component)jPanel3, "East");
        this.buttonPanel.add((Component)jPanel, "North");
    }

    private void createResultPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.resultPanel = new JPanel(new BorderLayout());
        this.resultPanel.setBorder(BorderFactory.createEtchedBorder());
        this.viewResultPanel = new JScrollPane();
        this.viewResultPanel.setPreferredSize(new Dimension(500, 150));
        this.viewResultPanel.getViewport().setBackground(Color.white);
        this.resultLabel = new JLabel("Results");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add(this.resultLabel);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)this.viewResultPanel, "Center");
        this.resultPanel.add((Component)jPanel, "Center");
    }

    private void enableTwoEvents(boolean bl) {
        this.arithmeticCombo.setEnabled(bl);
        this.node2Combo.setEnabled(bl);
        this.state2Combo.setEnabled(bl);
    }

    private void enableButtons(boolean bl) {
        this.editButton.setEnabled(bl);
        this.adoptButton.setEnabled(bl);
    }

    private Vector<String> getComparisonItems() {
        Vector<String> vector = new Vector<String>();
        vector.add(">=");
        vector.add("==");
        vector.add("<=");
        return vector;
    }

    private Vector<String> getArithmeticItems() {
        Vector<String> vector = new Vector<String>();
        vector.add("/");
        vector.add("-");
        return vector;
    }

    private Vector<String> getNodeNameList(Vector<DiscreteChanceNode> vector) {
        Vector<String> vector2 = new Vector<String>();
        for (DiscreteChanceNode discreteChanceNode : vector) {
            try {
                vector2.add(HuginGUIUtils.getNodeTitle(discreteChanceNode));
            }
            catch (ExceptionHugin exceptionHugin) {}
        }
        return vector2;
    }

    private void populateCombo(DiscreteChanceNode discreteChanceNode, HuginComboBox huginComboBox) {
        Vector<String> vector = this.psw.getNodeStatesDescription(discreteChanceNode);
        huginComboBox.removeAllItems();
        for (String string : vector) {
            huginComboBox.addItem(string);
        }
        if (vector.size() > 1) {
            huginComboBox.setSelectedIndex(1);
        }
        huginComboBox.setSelectedIndex(0);
        huginComboBox.validatePopupWidth();
        huginComboBox.setPreferredSize(new Dimension(80, this.node1Combo.getPreferredSize().height));
    }

    private double getFirstConstraint() {
        double d = 0.0;
        String string = this.constraint1Field.getText();
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            this.constraint1Field.setText("0.0");
        }
        return d;
    }

    private double getSecondConstraint() {
        double d = 0.0;
        String string = this.constraint2Field.getText();
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            this.constraint2Field.setText("0.0");
        }
        return d;
    }

    protected void propagationUpdate() {
        try {
            double d = this.getSelectedNode1().getBelief(this.getSelectedState1());
            double d2 = this.getSelectedNode2().getBelief(this.getSelectedState2());
            this.output1Label.setText("<html><B>" + HuginGUIUtils.printDouble(d, this.precision) + "</B></html>");
            this.output2Label.setText("<html><B>" + HuginGUIUtils.printDouble(d2, this.precision) + "</B></html>");
        }
        catch (ExceptionHugin exceptionHugin) {
            // empty catch block
        }
    }

    private void editTable(Constraint constraint) {
        if (constraint != null) {
            try {
                Node node = this.psw.projectFrame.getNetworkPanel().getNode(constraint.getNode().getName());
                this.psw.syncDomainToClass(node);
                String string = HuginGUIUtils.getNodeTitle(node.getAPINode());
                double[] dArray = constraint.getNode().getTable().getData();
                int n = JOptionPane.showConfirmDialog(this.psw, this.getNodeTable(node), string, 2, -1);
                if (n == 0) {
                    this.psw.projectFrame.getNetworkPanel().containsUnsavedChanges(true);
                    this.psw.syncClassToDomain(node);
                } else {
                    constraint.getNode().getTable().setData(dArray);
                    this.psw.syncDomainToClass(node);
                }
                this.psw.propagate();
                this.clear();
                this.compute();
            }
            catch (Exception exception) {
                new HuginGUIError(exception.getMessage());
            }
        }
    }

    private void adoptChanges(Constraint constraint) {
        if (constraint != null) {
            try {
                DiscreteChanceNode discreteChanceNode = (DiscreteChanceNode)constraint.getNode();
                Node node = this.psw.projectFrame.getNetworkPanel().getNode(constraint.getNode().getName());
                this.psw.syncDomainToClass(node);
                Table table = discreteChanceNode.getTable();
                int n = discreteChanceNode.getNumberOfStates();
                int n2 = constraint.getIndex();
                int[] nArray = this.getColumnIndexes(n, n2);
                double d = 0.0;
                for (int i = 0; i < n; ++i) {
                    d += table.getDataItem(nArray[i]);
                }
                Value value = constraint.getSuggestedValue();
                double d2 = table.getDataItem(n2);
                double d3 = d - d2;
                double d4 = value.getSuggestedValue(d2);
                double d5 = 1.0 - d4;
                for (int i = 0; i < n; ++i) {
                    int n3 = nArray[i];
                    if (n3 == n2) {
                        discreteChanceNode.getTable().setDataItem(n2, d4);
                        continue;
                    }
                    double d6 = table.getDataItem(n3);
                    discreteChanceNode.getTable().setDataItem(n3, d5 * d6 / d3);
                }
                this.psw.syncDomainToClass(node);
                this.psw.projectFrame.getNetworkPanel().containsUnsavedChanges(true);
                this.psw.propagate();
                this.clear();
                this.compute();
            }
            catch (Exception exception) {
                new HuginGUIError(exception.getMessage());
            }
        }
    }

    private int[] getColumnIndexes(int n, int n2) {
        int[] nArray = new int[n];
        int n3 = (int)Math.floor(n2 / n);
        for (int i = 0; i < n; ++i) {
            nArray[i] = n * n3 + i;
        }
        return nArray;
    }

    private Component getNodeTable(Node node) {
        NodeTable nodeTable = null;
        JPanel jPanel = new JPanel(new GridLayout(1, 1));
        try {
            nodeTable = new NodeTable(node);
            if (nodeTable.showExpressions()) {
                nodeTable.generateTable();
                nodeTable.enableDataTable(true);
                ((DiscreteNodeTableModel)nodeTable.getTable().getModel()).setEditable(true);
                nodeTable.getExpressionTable().setEditable(false);
            }
            if (nodeTable.showExperience()) {
                nodeTable.getExperienceTable().setEnabled(false);
            }
            if (nodeTable.showFading()) {
                nodeTable.getFadingTable().setEnabled(false);
            }
            nodeTable.getTable().setColumnSelectionAllowed(true);
            nodeTable.getTable().setRowSelectionAllowed(true);
            GenericTable genericTable = (GenericTable)nodeTable.getTable();
            ModeGraphicTable modeGraphicTable = new ModeGraphicTable(node, 0, genericTable);
            TableWrapper tableWrapper = new TableWrapper(nodeTable, nodeTable, modeGraphicTable);
            tableWrapper.wrapInScrollPane();
            tableWrapper.setPreferredSize(new Dimension(500, 200));
            tableWrapper.contents.setDividerLocation(150);
            JPanel jPanel2 = new JPanel(new GridLayout(1, 1));
            jPanel2.add(tableWrapper);
            JPanel jPanel3 = new JPanel(new GridLayout(1, 1));
            jPanel3.add(jPanel2);
            jPanel.add(tableWrapper);
            jPanel.validate();
        }
        catch (ExceptionHugin exceptionHugin) {
            // empty catch block
        }
        return jPanel;
    }

    private void enableSecondConstraint(boolean bl, String string) {
        this.constraint2Combo.setEnabled(bl);
        this.constraint2Field.setEnabled(bl);
        this.constraint2Field.setText(string);
    }

    private void updateTable(Constraints constraints) {
        if (constraints != null) {
            ConstraintResultsTableSorter constraintResultsTableSorter = new ConstraintResultsTableSorter(new ConstraintsModel(constraints));
            JTable jTable = new JTable(constraintResultsTableSorter){

                public boolean isCellEditable(int n, int n2) {
                    return false;
                }
            };
            ListSelectionModel listSelectionModel = jTable.getSelectionModel();
            listSelectionModel.addListSelectionListener(new SelectionListener(constraintResultsTableSorter));
            jTable.setSelectionMode(0);
            TableColumnModel tableColumnModel = jTable.getColumnModel();
            jTable.getTableHeader().setDefaultRenderer(this.psw.new ParameterSensitivityWizard.RaisedHeader());
            constraintResultsTableSorter.setTableHeader(jTable.getTableHeader());
            jTable.setDefaultRenderer(Object.class, new ColorTableCellRenderer(jTable, constraints.getMaxLogOdds()));
            this.psw.addTableToScrollPane(jTable, this.viewResultPanel);
        } else {
            this.viewResultPanel.setViewportView(null);
        }
        this.enableButtons(false);
    }

    protected void compute() {
        if (!this.inputVerified()) {
            new HuginGUIError(HuginGUIConstants.get("PSW_Impossible_Constraint"));
            return;
        }
        NodeList nodeList = new NodeList();
        this.constraints = null;
        if (!this.twoEventsCheckBox.isSelected()) {
            nodeList.add(this.getSelectedNode1());
            int[] nArray = new int[]{this.getSelectedState1()};
            boolean bl = this.psw.computeSensitivityData(nodeList, nArray);
            if (!bl) {
                return;
            }
            this.constraints = this.computeOneEvent();
        } else {
            nodeList.add(this.getSelectedNode1());
            nodeList.add(this.getSelectedNode2());
            int[] nArray = new int[]{this.getSelectedState1(), this.getSelectedState2()};
            boolean bl = this.psw.computeSensitivityData(nodeList, nArray);
            if (!bl) {
                return;
            }
            this.constraints = this.computeTwoEvents();
        }
        if (this.constraints != null) {
            if (!this.constraints.isEmpty()) {
                this.updateTable(this.constraints);
            } else {
                this.updateTable(null);
            }
        } else {
            this.updateTable(this.constraints);
            new HuginGUIError(HuginGUIConstants.get("PSW_Unsatisfiable_Constraint"));
        }
    }

    private int getConstraint2(int n) {
        switch (n) {
            case 0: {
                return 2;
            }
            case 1: {
                return -1;
            }
            case 2: {
                return 0;
            }
        }
        return -1;
    }

    protected Constraints computeOneEvent() {
        try {
            Vector<Constraint> vector = new Vector<Constraint>();
            double d = this.getFirstConstraint();
            double d2 = this.getSecondConstraint();
            double d3 = this.getSelectedNode1().getBelief(this.getSelectedState1());
            int n = this.constraint1Combo.getSelectedIndex();
            int n2 = this.getConstraint2(n);
            Value value = new Value(n, d, n2, d2, CONSTRAINT);
            boolean bl = value.areConstraintsSatisfied(d3);
            if (bl) {
                JOptionPane.showMessageDialog(this.psw, HuginGUIConstants.get("PSW_Satisfied_Constraint"), HuginGUIConstants.get("PSW_Tab_Constraints"), -1);
                return new Constraints(vector);
            }
            Vector<DiscreteChanceNode> vector2 = this.psw.getDCNodeList();
            for (DiscreteChanceNode discreteChanceNode : vector2) {
                Table table = discreteChanceNode.getTable();
                int n3 = table.getSize();
                for (int i = 0; i < n3; ++i) {
                    try {
                        boolean bl2;
                        double d4 = table.getDataItem(i);
                        double[] dArray = discreteChanceNode.getSensitivityConstants(i, 0);
                        double d5 = this.computeSingleEventAdjustedValue(d, dArray);
                        double d6 = this.computeSingleEventAdjustedValue(d2, dArray);
                        double d7 = this.psw.computeSensitivityValue(dArray, d4);
                        if (d5 == -1.0 && d6 == -1.0) continue;
                        Value value2 = null;
                        if (d7 > 0.0) {
                            switch (n) {
                                case 0: {
                                    value2 = new Value(0, d5, 2, d6, SUGGESTED);
                                    break;
                                }
                                case 1: {
                                    if (d5 == -1.0) break;
                                    value2 = new Value(1, d5, SUGGESTED);
                                    break;
                                }
                                case 2: {
                                    value2 = new Value(2, d5, 0, d6, SUGGESTED);
                                }
                            }
                        } else if (d7 < 0.0) {
                            switch (n) {
                                case 0: {
                                    value2 = new Value(2, d5, 0, d6, SUGGESTED);
                                    break;
                                }
                                case 1: {
                                    if (d5 == -1.0) break;
                                    value2 = new Value(1, d5, -1, -1.0, SUGGESTED);
                                    break;
                                }
                                case 2: {
                                    value2 = new Value(0, d5, 2, d6, SUGGESTED);
                                }
                            }
                        } else {
                            value2 = null;
                        }
                        if (value2 == null || (bl2 = value2.areConstraintsSatisfied(d4))) continue;
                        Value value3 = this.computeLogOddsChange(d4, value2.getValue1(), value2.getValue2());
                        Value value4 = this.computeAbsoluteChange(d4, value2.getValue1(), value2.getValue2());
                        value2.setCurrentValue(d4);
                        Constraint constraint = new Constraint(d4, value2, value4, value3, table, i, discreteChanceNode);
                        vector.add(constraint);
                        continue;
                    }
                    catch (ExceptionHugin exceptionHugin) {
                        // empty catch block
                    }
                }
            }
            if (vector.size() > 0) {
                return new Constraints(vector);
            }
            return null;
        }
        catch (ExceptionHugin exceptionHugin) {
            return null;
        }
    }

    protected Constraints computeTwoEvents() {
        try {
            Vector<Constraint> vector = new Vector<Constraint>();
            double d = this.getFirstConstraint();
            double d2 = this.getSecondConstraint();
            double d3 = this.getSelectedNode1().getBelief(this.getSelectedState1());
            double d4 = this.getSelectedNode2().getBelief(this.getSelectedState2());
            int n = this.constraint1Combo.getSelectedIndex();
            int n2 = this.getConstraint2(n);
            Value value = new Value(n, d, n2, d2, CONSTRAINT);
            double d5 = this.arithmeticCombo.getSelectedItem() == "-" ? d3 - d4 : d3 / d4;
            boolean bl = value.areConstraintsSatisfied(d5);
            if (bl) {
                JOptionPane.showMessageDialog(this.psw, HuginGUIConstants.get("PSW_Satisfied_Constraint"), HuginGUIConstants.get("PSW_Tab_Constraints"), -1);
                return new Constraints(vector);
            }
            Vector<DiscreteChanceNode> vector2 = this.psw.getDCNodeList();
            for (DiscreteChanceNode discreteChanceNode : vector2) {
                Table table = discreteChanceNode.getTable();
                int n3 = table.getSize();
                for (int i = 0; i < n3; ++i) {
                    try {
                        double d6 = table.getDataItem(i);
                        double[] dArray = discreteChanceNode.getSensitivityConstants(i, 0);
                        double[] dArray2 = discreteChanceNode.getSensitivityConstants(i, 1);
                        double d7 = -1.0;
                        double d8 = -1.0;
                        double d9 = this.psw.computeSensitivityValue(dArray, d6);
                        double d10 = this.psw.computeSensitivityValue(dArray2, d6);
                        double d11 = this.computeJointSensitivityValue(dArray, dArray2, d6);
                        if (this.arithmeticCombo.getSelectedItem() == "-") {
                            d7 = this.computeTwoEventDifferenceValue(d, dArray, dArray2);
                            d8 = this.computeTwoEventDifferenceValue(d2, dArray, dArray2);
                        } else {
                            d7 = this.computeTwoEventRatioValue(d, dArray, dArray2);
                            d8 = this.computeTwoEventRatioValue(d2, dArray, dArray2);
                        }
                        if (d7 == -1.0 && d8 == -1.0) continue;
                        Value value2 = null;
                        if (d11 > 0.0) {
                            switch (n) {
                                case 0: {
                                    value2 = new Value(0, d7, 2, d8, SUGGESTED);
                                    break;
                                }
                                case 1: {
                                    if (d7 == -1.0) break;
                                    value2 = new Value(1, d7, SUGGESTED);
                                    break;
                                }
                                case 2: {
                                    value2 = new Value(2, d7, 0, d8, SUGGESTED);
                                }
                            }
                        } else if (d11 < 0.0) {
                            switch (n) {
                                case 0: {
                                    value2 = new Value(2, d7, 0, d8, SUGGESTED);
                                    break;
                                }
                                case 1: {
                                    if (d7 == -1.0) break;
                                    value2 = new Value(1, d7, -1, -1.0, SUGGESTED);
                                    break;
                                }
                                case 2: {
                                    value2 = new Value(0, d7, 2, d8, SUGGESTED);
                                }
                            }
                        } else {
                            value2 = null;
                        }
                        if (value2 == null) continue;
                        boolean bl2 = value2.areConstraintsSatisfied(d6);
                        if (value2.areConstraintsSatisfied(d5)) continue;
                        Value value3 = this.computeLogOddsChange(d6, value2.getValue1(), value2.getValue2());
                        Value value4 = this.computeAbsoluteChange(d6, value2.getValue1(), value2.getValue2());
                        value2.setCurrentValue(d6);
                        Constraint constraint = new Constraint(d6, value2, value4, value3, table, i, discreteChanceNode);
                        vector.add(constraint);
                        continue;
                    }
                    catch (ExceptionHugin exceptionHugin) {
                        // empty catch block
                    }
                }
            }
            if (vector.size() > 0) {
                return new Constraints(vector);
            }
            return null;
        }
        catch (ExceptionHugin exceptionHugin) {
            return null;
        }
    }

    private double computeJointSensitivityValue(double[] dArray, double[] dArray2, double d) {
        double d2 = this.psw.computeSensitivityValue(dArray, d);
        double d3 = this.psw.computeSensitivityValue(dArray2, d);
        return d2 - d3;
    }

    private Value getValueObject(double d, double d2, int n) {
        Value value = null;
        if (d != -1.0 && d2 != -1.0) {
            if (d > d2) {
                value = new Value(2, d, 0, d2, n);
            }
            if (d < d2) {
                value = new Value(0, d, 2, d2, n);
            }
        } else {
            value = new Value(0, d, 0, d2, n);
        }
        return value;
    }

    private Value computeAbsoluteChange(double d, double d2, double d3) {
        double d4 = -1.0;
        double d5 = -1.0;
        if (d2 != -1.0) {
            d4 = Math.abs(d - d2);
        }
        if (d3 != -1.0) {
            d5 = Math.abs(d - d3);
        }
        return this.getValueObject(d4, d5, ABSOLUTE);
    }

    private Value computeLogOddsChange(double d, double d2, double d3) {
        double d4 = -1.0;
        double d5 = -1.0;
        Value value = null;
        if (d2 != -1.0) {
            d4 = Math.abs(Math.log(d2 / (1.0 - d2)) - Math.log(d / (1.0 - d)));
        }
        if (d3 != -1.0) {
            d5 = Math.abs(Math.log(d3 / (1.0 - d3)) - Math.log(d / (1.0 - d)));
        }
        value = this.getValueObject(d4, d5, LOGODDS);
        return value;
    }

    protected void clear() {
        this.enableButtons(false);
        this.viewResultPanel.setViewportView(null);
        this.constraints = null;
        this.propagationUpdate();
    }

    protected double computeSingleEventAdjustedValue(double d, double[] dArray) {
        try {
            double d2 = (d * dArray[3] - dArray[1]) / (dArray[0] - dArray[2] * d);
            if (d2 < 1.0 && d2 > 0.0) {
                return d2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1.0;
    }

    protected double computeTwoEventDifferenceValue(double d, double[] dArray, double[] dArray2) {
        try {
            double d2;
            boolean bl = this.gammaDeltaConfirmed(dArray, dArray2);
            if (bl && (d2 = (d * dArray[3] - dArray[1] + dArray2[1]) / (dArray[0] - dArray2[0] - dArray[2] * d)) < 1.0 && d2 > 0.0) {
                return d2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1.0;
    }

    protected double computeTwoEventRatioValue(double d, double[] dArray, double[] dArray2) {
        try {
            double d2;
            boolean bl = this.gammaDeltaConfirmed(dArray, dArray2);
            if (bl && (d2 = (dArray2[1] * d - dArray[1]) / (dArray[0] - dArray2[0] * d)) < 1.0 && d2 > 0.0) {
                return d2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1.0;
    }

    private boolean gammaDeltaConfirmed(double[] dArray, double[] dArray2) {
        try {
            return dArray[2] == dArray2[2] && dArray[3] == dArray2[3];
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected DiscreteChanceNode getSelectedNode1() {
        String string = (String)this.node1Combo.getSelectedItem();
        Vector<DiscreteChanceNode> vector = this.psw.getDCNodeList();
        DiscreteChanceNode discreteChanceNode = vector.get(this.node1Combo.getSelectedIndex());
        return discreteChanceNode;
    }

    protected int getSelectedState1() {
        return this.state1Combo.getSelectedIndex();
    }

    protected DiscreteChanceNode getSelectedNode2() {
        String string = (String)this.node2Combo.getSelectedItem();
        Vector<DiscreteChanceNode> vector = this.psw.getDCNodeList();
        DiscreteChanceNode discreteChanceNode = vector.get(this.node2Combo.getSelectedIndex());
        return discreteChanceNode;
    }

    protected int getSelectedState2() {
        return this.state2Combo.getSelectedIndex();
    }

    private boolean inputVerified() {
        double d = this.getFirstConstraint();
        double d2 = this.getSecondConstraint();
        int n = this.constraint1Combo.getSelectedIndex();
        int n2 = this.constraint2Combo.getSelectedIndex();
        switch (n) {
            case 0: {
                if (!(d > d2)) break;
                return false;
            }
            case 2: {
                if (!(d2 > d)) break;
                return false;
            }
        }
        return true;
    }

    private class ColorTableCellRenderer
    extends DefaultTableCellRenderer {
        private JTable theTable;
        double maxLogOdd;

        public ColorTableCellRenderer(JTable jTable, double d) {
            this.theTable = jTable;
            this.setOpaque(true);
            this.maxLogOdd = d;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel;
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            String string = jTable.getColumnName(n2);
            if (object instanceof Double) {
                Double d = (Double)object;
                String string2 = HuginGUIUtils.printDouble(d, ConstraintsPanel.this.precision);
                jLabel = new JLabel(string2);
                jLabel.setToolTipText(string2);
                float f = d.floatValue();
                Color color = f <= 1.0f ? new Color(0.0f, 0.0f, 1.0f, f) : new Color(1.0f, 0.0f, 0.0f, 1.0f);
                jLabel.setOpaque(true);
                jLabel.setBackground(color);
                if (d < 0.25) {
                    jLabel.setForeground(Color.black);
                } else {
                    jLabel.setForeground(Color.white);
                }
            } else if (object instanceof Value) {
                Color color;
                Double d;
                String string3 = ((Value)object).toHtmlString();
                jLabel = new JLabel(string3);
                jLabel.setToolTipText(string3);
                Double d2 = ((Value)object).getType() == SUGGESTED ? Double.valueOf(((Value)object).getSuggestedValue()) : Double.valueOf(((Value)object).getSmallestValue());
                float f = d2.floatValue();
                if (((Value)object).getType() != LOGODDS) {
                    d = d2;
                    color = new Color(0.0f, 0.0f, 1.0f, f);
                } else {
                    Double d3;
                    d = this.maxLogOdd == 0.0 ? (d3 = Double.valueOf(1.0)) : (d3 = Double.valueOf(d2 / this.maxLogOdd));
                    color = new Color(0.0f, 0.0f, 1.0f, d3.floatValue());
                }
                jLabel.setOpaque(true);
                jLabel.setBackground(color);
                if (d < 0.6) {
                    jLabel.setForeground(Color.black);
                } else {
                    jLabel.setForeground(Color.white);
                }
            } else {
                jLabel = new JLabel(object.toString());
                jLabel.setToolTipText(object.toString());
                jLabel.setOpaque(true);
                jLabel.setBackground(Color.white);
                jLabel.setForeground(Color.black);
            }
            if (bl) {
                jLabel.setOpaque(true);
                jLabel.setBackground(new Color(0.0f, 0.0f, 1.0f, 0.25f));
                jLabel.setForeground(Color.black);
            }
            return jLabel;
        }
    }

    class ConstraintResultsTableSorter
    extends TableSorter {
        public ConstraintResultsTableSorter() {
        }

        public ConstraintResultsTableSorter(TableModel tableModel) {
            super(tableModel);
        }

        public ConstraintResultsTableSorter(TableModel tableModel, JTableHeader jTableHeader) {
            super(tableModel, jTableHeader);
        }

        private TableSorter.Row[] getViewToModel() {
            if (this.viewToModel == null) {
                int n = this.tableModel.getRowCount();
                this.viewToModel = new ValueRow[n];
                for (int i = 0; i < n; ++i) {
                    this.viewToModel[i] = new ValueRow(i);
                }
                if (this.isSorting()) {
                    Arrays.sort((ValueRow[])this.viewToModel);
                }
            }
            return this.viewToModel;
        }

        public int modelIndex(int n) {
            return this.getViewToModel()[n].modelIndex;
        }

        protected int[] getModelToView() {
            if (this.modelToView == null) {
                int n = this.getViewToModel().length;
                this.modelToView = new int[n];
                for (int i = 0; i < n; ++i) {
                    this.modelToView[this.modelIndex((int)i)] = i;
                }
            }
            return this.modelToView;
        }

        protected class ValueRow
        extends TableSorter.Row {
            public ValueRow(int n) {
                super(ConstraintResultsTableSorter.this, n);
            }

            public int compareTo(TableSorter.Row row) {
                ValueRow valueRow = (ValueRow)row;
                int n = this.modelIndex;
                int n2 = valueRow.modelIndex;
                for (TableSorter.Directive directive : ConstraintResultsTableSorter.this.sortingColumns) {
                    int n3 = directive.column;
                    Object object = ConstraintResultsTableSorter.this.tableModel.getValueAt(n, n3);
                    Object object2 = ConstraintResultsTableSorter.this.tableModel.getValueAt(n2, n3);
                    int n4 = 0;
                    if (object == null && object2 == null) {
                        n4 = 0;
                    } else if (object == null) {
                        n4 = -1;
                    } else if (object2 == null) {
                        n4 = 1;
                    } else if (object instanceof Value && object2 instanceof Value) {
                        n4 = ((Value)object).compareTo((Value)object2);
                    } else {
                        return super.compareTo(row);
                    }
                    if (n4 == 0) continue;
                    return directive.direction == -1 ? -n4 : n4;
                }
                return 0;
            }
        }
    }

    public class SelectionListener
    implements ListSelectionListener {
        ConstraintResultsTableSorter sorter;

        SelectionListener(ConstraintResultsTableSorter constraintResultsTableSorter) {
            this.sorter = constraintResultsTableSorter;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n;
            ConstraintsPanel.this.enableButtons(false);
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            if (!((ListSelectionModel)listSelectionEvent.getSource()).isSelectionEmpty() && !((ListSelectionModel)listSelectionEvent.getSource()).getValueIsAdjusting() && (n = listSelectionModel.getMaxSelectionIndex()) != -1) {
                ConstraintsPanel.this.enableButtons(true);
                ConstraintsPanel.this.constraints.setActiveConstraint(this.sorter.modelIndex(n));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NodeComboRenderer
    extends DefaultListCellRenderer {
        Vector<DiscreteChanceNode> nodeList;

        public NodeComboRenderer(Vector<DiscreteChanceNode> vector) {
            this.setOpaque(true);
            this.nodeList = vector;
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Object object2;
            boolean bl3 = false;
            try {
                if (n <= this.nodeList.size() - 1) {
                    object2 = this.nodeList.get(n);
                    bl3 = ((COM.hugin.HAPI.Node)object2).evidenceIsEntered();
                }
            }
            catch (ExceptionHugin exceptionHugin) {
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!bl3) {
                return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            }
            object2 = object.toString();
            this.setText("<HTML><B><FONT COLOR=RED>(e) </FONT></B><FONT COLOR=BLACK>" + (String)object2 + "</FONT></HTML>");
            this.setBackground(bl ? Color.red : Color.white);
            this.setForeground(bl ? Color.white : Color.black);
            return this;
        }
    }

    private class ConstraintsModel
    extends DefaultTableModel {
        Vector<Constraint> constraints;
        int numRows;
        Vector<String> columnNames;

        public ConstraintsModel(Constraints constraints) {
            this.constraints = constraints.getConstraints();
            this.numRows = this.constraints.size();
            this.columnNames = constraints.getTitles();
        }

        public Object getValueAt(int n, int n2) {
            if (n >= 0 && n < this.constraints.size()) {
                Constraint constraint = this.constraints.elementAt(n);
                Object object = null;
                if (n2 >= 0 && n2 < this.columnNames.size()) {
                    switch (n2) {
                        case 0: {
                            object = constraint.getParameter();
                            if (object != null) {
                                return object;
                            }
                            return new String("");
                        }
                        case 1: {
                            object = new Double(constraint.getCurrentValue());
                            return object;
                        }
                        case 2: {
                            object = constraint.getSuggestedValue();
                            if (object != null) {
                                return object;
                            }
                            return new String("");
                        }
                        case 3: {
                            object = constraint.getAbsoluteValue();
                            if (object != null) {
                                return object;
                            }
                            return new String("");
                        }
                        case 4: {
                            object = constraint.getLogOddsChange();
                            if (object != null) {
                                return object;
                            }
                            return new String("");
                        }
                    }
                }
            }
            return "error";
        }

        public String getColumnName(int n) {
            if (this.columnNames.size() > 0 && n < this.columnNames.size() && n >= 0) {
                return this.columnNames.elementAt(n);
            }
            return " ";
        }

        public Class getColumnClass(int n) {
            return Object.class;
        }

        public int getColumnCount() {
            return this.columnNames.size();
        }

        public int getRowCount() {
            return this.numRows;
        }
    }

    class Value
    implements Comparable {
        int comparison1;
        int comparison2;
        double value1;
        double value2;
        boolean oneValue = true;
        private int type;
        double current = -1.0;

        public Value(int n, double d, int n2, double d2, int n3) {
            this.comparison1 = n;
            this.value1 = d;
            this.comparison2 = n2;
            this.value2 = d2;
            this.type = n3;
        }

        public Value(int n, double d, int n2) {
            this.comparison1 = n;
            this.value1 = d;
            this.comparison2 = -1;
            this.value2 = -1.0;
            this.type = n2;
        }

        public Value(double d, int n) {
            this.comparison1 = -1;
            this.value1 = d;
            this.comparison2 = -1;
            this.value2 = -1.0;
            this.type = n;
        }

        public double getValue1() {
            return this.value1;
        }

        public double getValue2() {
            return this.value2;
        }

        public int getType() {
            return this.type;
        }

        public void setCurrentValue(double d) {
            this.current = d;
        }

        public double getSuggestedValue(double d) {
            double d2;
            if (this.value2 == -1.0 && this.value1 != -1.0) {
                return this.getValue1();
            }
            if (this.value1 == -1.0 && this.value2 != -1.0) {
                return this.getValue2();
            }
            double d3 = Math.abs(this.value1 - d);
            if (d3 <= (d2 = Math.abs(this.value2 - d))) {
                return this.getValue1();
            }
            return this.getValue2();
        }

        public double getSuggestedValue() {
            double d;
            if (this.value2 == -1.0 && this.value1 != -1.0) {
                return this.getValue1();
            }
            if (this.value1 == -1.0 && this.value2 != -1.0) {
                return this.getValue2();
            }
            double d2 = Math.abs(this.value1 - this.current);
            if (d2 <= (d = Math.abs(this.value2 - this.current))) {
                return this.getValue1();
            }
            return this.getValue2();
        }

        public double getSmallestValue() {
            if (this.value2 == -1.0 && this.value1 != -1.0) {
                return this.value1;
            }
            if (this.value1 == -1.0 && this.value2 != -1.0) {
                return this.value2;
            }
            return Math.min(this.value1, this.value2);
        }

        public boolean areConstraintsSatisfied(double d) {
            boolean bl = true;
            double d2 = Math.abs(d - this.value1);
            if (d2 <= 1.0E-6) {
                this.value1 = d;
            }
            if (this.value2 != -1.0 && (d2 = Math.abs(d - this.value2)) <= 1.0E-6) {
                this.value2 = d;
            }
            switch (this.comparison1) {
                case 0: {
                    if (!(d < this.value1)) break;
                    return false;
                }
                case 1: {
                    if (d == this.value1) break;
                    return false;
                }
                case 2: {
                    if (!(d > this.value1)) break;
                    return false;
                }
            }
            if (this.value2 != -1.0) {
                switch (this.comparison2) {
                    case 0: {
                        if (!(d < this.value2)) break;
                        return false;
                    }
                    case 2: {
                        if (!(d > this.value2)) break;
                        return false;
                    }
                }
            }
            return bl;
        }

        public String toString() {
            Vector vector = ConstraintsPanel.this.getComparisonItems();
            String string = "";
            String string2 = "";
            String string3 = "";
            String string4 = "";
            String string5 = "";
            if (this.comparison1 > -1 && this.comparison1 < vector.size() && this.value1 != -1.0) {
                if (this.comparison1 != 1) {
                    string = (String)vector.get(this.comparison1);
                }
                string4 = HuginGUIUtils.printDouble(this.value1, ConstraintsPanel.this.precision);
            }
            if (this.comparison2 > -1 && this.comparison2 < vector.size() && this.value2 != -1.0) {
                if (this.comparison2 != 1) {
                    string2 = (String)vector.get(this.comparison2);
                }
                string3 = HuginGUIUtils.printDouble(this.value2, ConstraintsPanel.this.precision);
            }
            if (this.value1 != -1.0 && this.value2 != -1.0) {
                string5 = ", ";
            }
            return string + string4 + string5 + string2 + string3;
        }

        public String toHtmlString() {
            double d;
            Vector vector = ConstraintsPanel.this.getComparisonItems();
            String string = "";
            String string2 = "";
            String string3 = "";
            String string4 = "";
            String string5 = "";
            if (this.comparison1 > -1 && this.comparison1 < vector.size() && this.value1 != -1.0) {
                if (this.comparison1 != 1) {
                    string = (String)vector.get(this.comparison1);
                }
                string4 = HuginGUIUtils.printDouble(this.value1, ConstraintsPanel.this.precision);
            }
            if (this.comparison2 > -1 && this.comparison2 < vector.size() && this.value2 != -1.0) {
                if (this.comparison2 != 1) {
                    string2 = (String)vector.get(this.comparison2);
                }
                string3 = HuginGUIUtils.printDouble(this.value2, ConstraintsPanel.this.precision);
            }
            if (this.value1 != -1.0 && this.value2 != -1.0) {
                string5 = ", ";
            }
            if (this.value1 == (d = this.type == SUGGESTED ? this.getSuggestedValue() : this.getSmallestValue())) {
                return "<html><b>" + this.getHtmlCode(string) + string4 + "</b>" + this.getHtmlCode(string5) + this.getHtmlCode(string2) + string3 + "</html>";
            }
            return "<html>" + this.getHtmlCode(string) + string4 + this.getHtmlCode(string5) + "<b>" + this.getHtmlCode(string2) + string3 + "</b></html>";
        }

        private String getHtmlCode(String string) {
            if (string.equals("<=")) {
                return "&#60;&#61;";
            }
            if (string.equals(">=")) {
                return "&#62;&#61;";
            }
            if (string.equals("==")) {
                return "&#61;&#61;";
            }
            if (string.equals(", ")) {
                return "&#44;&#32;";
            }
            return string;
        }

        public int compareTo(Object object) throws ClassCastException {
            double d;
            double d2;
            if (!(object instanceof Value)) {
                return 0;
            }
            Value value = (Value)object;
            if (this.type != value.getType()) {
                return 0;
            }
            if (this.type == SUGGESTED) {
                d2 = value.getSuggestedValue();
                d = this.getSuggestedValue();
            } else {
                d2 = value.getSmallestValue();
                d = this.getSmallestValue();
            }
            double d3 = d - d2;
            if (d3 < 0.0) {
                return -1;
            }
            if (d3 == 0.0) {
                return 0;
            }
            return 1;
        }
    }

    class Constraint {
        String parameter = "";
        double currentValue;
        Value suggestedValue;
        Value absoluteValue;
        Value logOddsChange;
        Table table;
        int cptIndex = -1;
        COM.hugin.HAPI.Node node;

        public Constraint(double d, Value value, Value value2, Value value3, Table table, int n, COM.hugin.HAPI.Node node) {
            this.currentValue = d;
            this.suggestedValue = value;
            this.absoluteValue = value2;
            this.logOddsChange = value3;
            this.table = table;
            this.cptIndex = n;
            this.node = node;
            this.parameter = HuginGUIUtils.getCptIndexDescription(table, this.cptIndex);
        }

        public String getParameter() {
            return this.parameter;
        }

        public double getCurrentValue() {
            return this.currentValue;
        }

        public Value getSuggestedValue() {
            return this.suggestedValue;
        }

        public Value getAbsoluteValue() {
            return this.absoluteValue;
        }

        public Value getLogOddsChange() {
            return this.logOddsChange;
        }

        public Table getTable() {
            return this.table;
        }

        public int getIndex() {
            return this.cptIndex;
        }

        public COM.hugin.HAPI.Node getNode() {
            return this.node;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Constraints {
        Vector<String> titles;
        Vector<Constraint> constraints;
        int activeIndex;

        public Constraints(Vector<Constraint> vector) {
            this.constraints = vector;
            this.initializeTitles();
            this.activeIndex = -1;
        }

        private void initializeTitles() {
            this.titles = new Vector();
            this.titles.add(HuginGUIConstants.get("PSW_Parameter"));
            this.titles.add(HuginGUIConstants.get("PSW_Current_Value"));
            this.titles.add(HuginGUIConstants.get("PSW_Suggested_Value"));
            this.titles.add(HuginGUIConstants.get("PSW_Absolute_Change"));
            this.titles.add(HuginGUIConstants.get("PSW_Log_Odds_Change"));
        }

        protected Vector<String> getTitles() {
            return this.titles;
        }

        protected Vector<Constraint> getConstraints() {
            return this.constraints;
        }

        protected Constraint getConstraintAt(int n) {
            if (this.constraints != null && n >= 0 && n < this.constraints.size()) {
                return this.constraints.elementAt(n);
            }
            return null;
        }

        protected void setActiveConstraint(int n) {
            if (this.constraints != null && n >= 0 && n < this.constraints.size()) {
                this.activeIndex = n;
            }
        }

        protected Constraint getActiveConstraint() {
            if (this.constraints != null && this.activeIndex >= 0 && this.activeIndex < this.constraints.size()) {
                return this.constraints.elementAt(this.activeIndex);
            }
            return null;
        }

        protected boolean isEmpty() {
            return this.constraints.size() == 0;
        }

        protected double getMaxLogOdds() {
            double d = 0.0;
            for (int i = 0; i < this.constraints.size(); ++i) {
                double d2;
                Constraint constraint = this.constraints.get(i);
                d = d2 = Math.max(constraint.getLogOddsChange().getSmallestValue(), d);
            }
            return d;
        }
    }

    class ComputeActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ConstraintsPanel.this.compute();
        }
    }

    class AdoptListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Constraint constraint = ConstraintsPanel.this.constraints.getActiveConstraint();
            ConstraintsPanel.this.adoptChanges(constraint);
        }
    }

    class EditListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Constraint constraint = ConstraintsPanel.this.constraints.getActiveConstraint();
            ConstraintsPanel.this.editTable(constraint);
        }
    }

    class ConstraintComboListener
    implements ItemListener {
        JComboBox combo1;
        JComboBox combo2;

        public ConstraintComboListener(JComboBox jComboBox) {
            this.combo2 = jComboBox;
            this.combo1 = null;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            if (object instanceof JComboBox) {
                this.combo1 = (JComboBox)object;
            }
            if (this.combo1 != null && this.combo2 != null && itemEvent.getStateChange() == 1) {
                int n = this.combo1.getSelectedIndex();
                switch (n) {
                    case 0: {
                        this.combo2.removeAllItems();
                        this.combo2.addItem("<=");
                        ConstraintsPanel.this.enableSecondConstraint(true, "Infinity");
                        break;
                    }
                    case 1: {
                        ConstraintsPanel.this.enableSecondConstraint(false, "0.0");
                        break;
                    }
                    case 2: {
                        this.combo2.removeAllItems();
                        this.combo2.addItem(">=");
                        ConstraintsPanel.this.enableSecondConstraint(true, "-Infinity");
                    }
                }
            }
        }
    }

    private class StateComboListener
    implements ItemListener {
        Vector<DiscreteChanceNode> list;
        HuginComboBox nodeCombo;
        ParameterSensitivityWizard wiz;
        JLabel label;

        public StateComboListener(ParameterSensitivityWizard parameterSensitivityWizard, HuginComboBox huginComboBox, JLabel jLabel) {
            this.wiz = parameterSensitivityWizard;
            this.list = parameterSensitivityWizard.getDCNodeList();
            this.nodeCombo = huginComboBox;
            this.label = jLabel;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            try {
                Object object = itemEvent.getSource();
                HuginComboBox huginComboBox = null;
                if (object instanceof HuginComboBox) {
                    huginComboBox = (HuginComboBox)object;
                }
                if (huginComboBox != null && itemEvent.getStateChange() == 1) {
                    DiscreteChanceNode discreteChanceNode = this.list.get(this.nodeCombo.getSelectedIndex());
                    this.label.setText("<html><B>" + HuginGUIUtils.printDouble(discreteChanceNode.getBelief(huginComboBox.getSelectedIndex()), ConstraintsPanel.this.precision) + "</B></html>");
                }
            }
            catch (ExceptionHugin exceptionHugin) {
                // empty catch block
            }
        }
    }

    private class NodeComboListener
    implements ItemListener {
        Vector<DiscreteChanceNode> list;
        HuginComboBox stateCombo;
        ParameterSensitivityWizard wiz;

        public NodeComboListener(ParameterSensitivityWizard parameterSensitivityWizard, HuginComboBox huginComboBox) {
            this.wiz = parameterSensitivityWizard;
            this.list = parameterSensitivityWizard.getDCNodeList();
            this.stateCombo = huginComboBox;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            HuginComboBox huginComboBox = null;
            if (object instanceof HuginComboBox) {
                huginComboBox = (HuginComboBox)object;
            }
            if (huginComboBox != null && itemEvent.getStateChange() == 1) {
                DiscreteChanceNode discreteChanceNode = this.list.get(huginComboBox.getSelectedIndex());
                Vector<String> vector = this.wiz.getNodeStatesDescription(discreteChanceNode);
                this.stateCombo.removeAllItems();
                for (String string : vector) {
                    this.stateCombo.addItem(string);
                }
                if (vector.size() > 1) {
                    this.stateCombo.setSelectedIndex(1);
                }
                this.stateCombo.setSelectedIndex(0);
                this.stateCombo.validatePopupWidth();
                this.stateCombo.setPreferredSize(new Dimension(80, ((ConstraintsPanel)ConstraintsPanel.this).node1Combo.getPreferredSize().height));
            }
        }
    }

    class ConstraintFocusListener
    implements FocusListener {
        ConstraintFocusListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
            Object object = focusEvent.getSource();
            if (object instanceof JTextField) {
                ((JTextField)object).selectAll();
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            Object object = focusEvent.getSource();
            if (object instanceof JTextField) {
                ((JTextField)object).select(0, 0);
            }
        }
    }

    class ConstraintKeyListener
    extends KeyAdapter {
        public void keyTyped(KeyEvent keyEvent) {
            JTextField jTextField = (JTextField)keyEvent.getSource();
            char c = keyEvent.getKeyChar();
            if (!Character.isDigit(c) && c != '\b' && c != '\u007f' && c != '.' && c != '-' && c != '\n') {
                ConstraintsPanel.this.getToolkit().beep();
                keyEvent.consume();
            } else {
                if (c == '.' && jTextField.getText().contains(".")) {
                    keyEvent.consume();
                }
                if (c == '-' && jTextField.getText().contains("-")) {
                    keyEvent.consume();
                }
                if (c == '\n') {
                    ConstraintsPanel.this.computeButton.requestFocus();
                    ConstraintsPanel.this.compute();
                    keyEvent.consume();
                }
            }
        }
    }
}

