/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.ContinuousChanceNode;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.Table;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.NodeMonitorModel;
import java.util.Collections;
import java.util.LinkedList;
import java.util.ListIterator;

public class ContinuousChanceNodeMonitorModel
extends NodeMonitorModel {
    ContinuousChanceNode node;
    public static final int MEAN = 0;
    public static final int VARIANCE = 1;
    private int startVariance = 2;
    private int width = 4;
    private int oldStartVariance = 2;
    private int oldWidth = 4;
    int allValues = 100;
    double[] values = null;
    double[] oldValues = null;
    double maxValue = Double.NEGATIVE_INFINITY;
    double oldMaxValue;

    public ContinuousChanceNodeMonitorModel(ContinuousChanceNode continuousChanceNode) throws ExceptionHugin {
        super(continuousChanceNode);
        this.node = continuousChanceNode;
        this.currentVal = new double[this.getBarCount()];
        this.oldVal = new double[this.getBarCount()];
        for (int i = 0; i < this.currentVal.length; ++i) {
            this.currentVal[i] = this.oldVal[i] = this.getValueAt(i);
        }
    }

    public void setNode(ContinuousChanceNode continuousChanceNode) throws ExceptionHugin {
        this.node = continuousChanceNode;
        this.recompute();
    }

    public int getBarCount() throws ExceptionHugin {
        return 2;
    }

    public double getValueAt(int n) throws ExceptionHugin {
        double d;
        double d2 = d = n == 0 ? this.node.getMean() : this.node.getVariance();
        if (d != this.currentVal[n]) {
            this.oldVal[n] = this.currentVal[n];
            this.currentVal[n] = d;
        }
        return d;
    }

    public double getOldValueAt(int n) throws ExceptionHugin {
        this.getValueAt(n);
        return this.oldVal[n];
    }

    private double log10(double d) {
        return Math.log(d) * 0.4342944819032518;
    }

    public double maxValue(boolean bl) {
        if (bl) {
            return Math.max(this.maxValue, this.oldMaxValue);
        }
        return this.maxValue;
    }

    public void recompute(int n, int n2) {
        this.oldStartVariance = this.startVariance;
        this.oldWidth = this.width;
        this.startVariance = n;
        this.width = n2;
        this.oldValues = null;
        this.values = null;
    }

    public void recompute() {
        if (this.values == null) {
            return;
        }
        this.oldValues = new double[this.values.length];
        this.oldMaxValue = this.maxValue;
        for (int i = 0; i < this.oldValues.length; ++i) {
            this.oldValues[i] = this.values[i];
        }
        this.values = null;
    }

    /*
     * WARNING - void declaration
     */
    public double function(double d, double d2, double d3, double d4, int n) throws UpdateNeededException {
        double d5;
        LinkedList<WeightedDistribution> linkedList = new LinkedList<WeightedDistribution>();
        LinkedList<MeanDistribution> linkedList2 = new LinkedList<MeanDistribution>();
        try {
            if (d3 == 0.0) {
                d3 = 1.0;
            }
            if (this.values == null) {
                Table table = this.node.getDistribution();
                d2 = this.node.getMean();
                d3 = Math.sqrt(this.node.getVariance());
                if (d3 == 0.0) {
                    d3 = 1.0;
                }
                this.maxValue = Double.NEGATIVE_INFINITY;
                this.values = new double[this.allValues];
                if (table.getSize() == 0) {
                    for (int i = 0; i < this.allValues; ++i) {
                        this.values[i] = 1.0;
                    }
                    this.maxValue = 1.0;
                } else {
                    int n2;
                    int n3;
                    for (int i = 0; i < table.getSize(); ++i) {
                        double d6 = table.getMean(i, this.node);
                        double d7 = table.getVariance(i, this.node);
                        double d8 = table.getDataItem(i);
                        linkedList.add(new WeightedDistribution(d6, d7, d8));
                    }
                    Collections.sort(linkedList);
                    for (int i = 0; i < this.allValues; ++i) {
                        void listIterator;
                        d5 = 0.0;
                        double d9 = (double)i * ((double)this.width * d3) / (double)this.allValues + (d2 - (double)this.startVariance * d3);
                        ListIterator n4 = linkedList.listIterator();
                        while (listIterator.hasNext()) {
                            WeightedDistribution weightedDistribution = (WeightedDistribution)listIterator.next();
                            if (weightedDistribution.variance != 0.0) {
                                int n5 = i;
                                this.values[n5] = this.values[n5] + weightedDistribution.weight * (1.0 / Math.sqrt(Math.PI * 2 * weightedDistribution.variance)) * Math.exp(-0.5 * Math.pow(d9 - weightedDistribution.mean, 2.0) / weightedDistribution.variance);
                            }
                            if (!((d5 += weightedDistribution.weight) * 100.0 > (double)n)) continue;
                            ListIterator listIterator2 = linkedList.listIterator(linkedList.size());
                        }
                        if (!(this.values[i] > this.maxValue)) continue;
                        this.maxValue = this.values[i];
                    }
                    for (WeightedDistribution weightedDistribution : linkedList) {
                        linkedList2.add(new MeanDistribution(weightedDistribution));
                    }
                    Collections.sort(linkedList2);
                    if (this.maxValue <= 0.0) {
                        this.maxValue = 0.01;
                    }
                    int n6 = Integer.MAX_VALUE;
                    double d6 = 0.0;
                    boolean bl = false;
                    MeanDistribution meanDistribution = null;
                    ListIterator listIterator = linkedList2.listIterator();
                    while (listIterator.hasNext()) {
                        meanDistribution = (MeanDistribution)listIterator.next();
                        int n5 = (int)((meanDistribution.mean - (d2 - (double)this.startVariance * d3)) * (double)this.allValues / ((double)this.width * d3));
                        if (n5 >= n3) {
                            if (n3 < this.allValues && n3 > 0 && d6 > this.values[n3 - 1]) {
                                this.values[n3 - 1] = d6;
                                if (d6 == Double.POSITIVE_INFINITY) {
                                    bl = true;
                                } else if (this.maxValue < d6) {
                                    this.maxValue = d6;
                                }
                            }
                            d6 = 0.0;
                        }
                        n3 = n5 + 1;
                        d6 += meanDistribution.weight * (1.0 / Math.sqrt(Math.PI * 2 * meanDistribution.variance));
                    }
                    if (meanDistribution != null && (n2 = (int)((meanDistribution.mean - (d2 - (double)this.startVariance * d3)) * (double)this.allValues / ((double)this.width * d3))) < this.allValues && n3 >= 0 && n3 < this.allValues && d6 > this.values[n2]) {
                        this.values[n2] = d6;
                        if (d6 == Double.POSITIVE_INFINITY) {
                            bl = true;
                        } else if (this.maxValue < d6) {
                            this.maxValue = d6;
                        }
                    }
                    if (bl) {
                        this.maxValue *= 2.0;
                    }
                }
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception.getMessage());
        }
        double d11 = (d - (d2 - (double)this.startVariance * d3)) * (double)this.allValues / ((double)this.width * d3);
        d5 = (d + d4 - (d2 - (double)this.startVariance * d3)) * (double)this.allValues / ((double)this.width * d3);
        try {
            double d12 = 0.0;
            if ((int)d11 == this.values.length - 1) {
                return this.values[(int)d11];
            }
            if ((int)d11 < (int)d5) {
                for (int i = 0; i < (int)d5 - (int)d11; ++i) {
                    d12 += this.values[(int)d11 + i];
                }
                d12 /= (double)((int)d5 - (int)d11);
            } else {
                d12 = this.values[(int)d11] * (1.0 - (d11 - (double)((int)d11))) + this.values[(int)d11 + 1] * (d11 - (double)((int)d11));
            }
            if (d12 == Double.POSITIVE_INFINITY) {
                d12 = this.maxValue * 2.0;
            }
            return d12;
        }
        catch (Exception exception) {
            throw new UpdateNeededException();
        }
    }

    public boolean hasOldFunction() {
        return this.oldValues != null;
    }

    public double oldFunction(double d, double d2, double d3, double d4) {
        double d5 = (d - (d2 - (double)this.oldStartVariance * d3)) * (double)this.allValues / ((double)this.oldWidth * d3);
        double d6 = (d + d4 - (d2 - (double)this.oldStartVariance * d3)) * (double)this.allValues / ((double)this.oldWidth * d3);
        double d7 = 0.0;
        if (d5 < 0.0 || d6 > (double)this.allValues) {
            return -1.0;
        }
        try {
            if ((int)d5 < (int)d6) {
                for (int i = 0; i < (int)d6 - (int)d5; ++i) {
                    d7 += this.oldValues[(int)d5 + i];
                }
                d7 /= (double)((int)d6 - (int)d5);
            } else {
                d7 = this.oldValues[(int)d5] * (1.0 - (d5 - (double)((int)d5))) + this.oldValues[(int)d5 + 1] * (d5 - (double)((int)d5));
            }
            if (d7 == Double.POSITIVE_INFINITY) {
                d7 = this.maxValue * 2.0;
            }
            return d7;
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    class UpdateNeededException
    extends Exception {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MeanDistribution
    implements Comparable<MeanDistribution> {
        double mean;
        double variance;
        double weight;

        public MeanDistribution(WeightedDistribution weightedDistribution) {
            this.mean = weightedDistribution.mean;
            this.variance = weightedDistribution.variance;
            this.weight = weightedDistribution.weight;
        }

        @Override
        public int compareTo(MeanDistribution meanDistribution) {
            return new Double(this.mean).compareTo(new Double(meanDistribution.mean));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WeightedDistribution
    implements Comparable<WeightedDistribution> {
        double mean;
        double variance;
        double weight;

        public WeightedDistribution(double d, double d2, double d3) {
            this.mean = d;
            this.variance = d2;
            this.weight = d3;
        }

        @Override
        public int compareTo(WeightedDistribution weightedDistribution) {
            return new Double(this.weight).compareTo(new Double(weightedDistribution.weight));
        }
    }
}

