/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.ContinuousChanceNode;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.Node;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HAPI.Table;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.NodeTableModel;

public class ContinuousChanceNodeTableModel
extends NodeTableModel {
    ContinuousChanceNode node;
    Table table;
    boolean dataMode = true;

    public void setNode(Node node) throws ExceptionHugin {
        this.node = (ContinuousChanceNode)node;
        this.table = this.node.getTable();
        this.fireTableStructureChanged();
    }

    public void setDataMode(boolean bl) {
        this.dataMode = bl;
    }

    public Object getValueAt(int n, int n2) {
        if (!this.dataMode) {
            if (n == 0) {
                int n3 = 0;
                long l = 0L;
                try {
                    NodeList nodeList = this.node.getTable().getNodes();
                    for (Node node : nodeList) {
                        if (node == this.node || !(node instanceof ContinuousChanceNode)) continue;
                        ++l;
                    }
                    n3 = this.node.getTable().getNodes().size() - 1;
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
                if (n3 == 0 || l == 0L) {
                    return HuginGUIConstants.get("str_mean");
                }
                return HuginGUIConstants.get("str_intercept");
            }
            if (n == this.getRowCount() - 1) {
                return HuginGUIConstants.get("str_variance");
            }
            int n4 = 0;
            try {
                for (Node node : this.node.getTable().getNodes()) {
                    if (!(node instanceof ContinuousChanceNode)) continue;
                    if (n == n4) {
                        return HuginGUIUtils.getNodeTitle(node);
                    }
                    ++n4;
                }
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        } else {
            if (n2 < 0) {
                return HuginGUIConstants.get("str_dot_dot_dot");
            }
            try {
                if (n == 0) {
                    return new Double(this.node.getAlpha(n2));
                }
                if (n == this.getRowCount() - 1) {
                    return new Double(this.node.getGamma(n2));
                }
                int n5 = 0;
                for (Node node : this.node.getTable().getNodes()) {
                    if (!(node instanceof ContinuousChanceNode)) continue;
                    if (n == n5) {
                        return new Double(this.node.getBeta((ContinuousChanceNode)node, n2));
                    }
                    ++n5;
                }
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }
        return HuginGUIConstants.get("str_question_mark");
    }

    public void setValueAt(Object object, int n, int n2) {
        if (!this.dataMode) {
            return;
        }
        if (n2 < 0) {
            return;
        }
        this.fireModelDataChanged();
        try {
            if (n == 0) {
                this.node.setAlpha(new Double(object.toString()), n2);
                return;
            }
            if (n == this.getRowCount() - 1) {
                this.node.setGamma(new Double(object.toString()), n2);
                return;
            }
            int n3 = 0;
            for (Node node : this.node.getTable().getNodes()) {
                if (!(node instanceof ContinuousChanceNode)) continue;
                if (n == n3) {
                    this.node.setBeta(new Double(object.toString()), (ContinuousChanceNode)node, n2);
                    return;
                }
                ++n3;
            }
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(HuginGUIConstants.get("str_variance_cannot_be_negative"));
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 >= 0 && this.dataMode;
    }

    public int getRowCount() {
        if (this.node == null) {
            return 0;
        }
        int n = 2;
        try {
            for (Node node : this.node.getParents()) {
                if (!(node instanceof ContinuousChanceNode)) continue;
                ++n;
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        return n;
    }

    public int getColumnCount() {
        if (this.node == null) {
            return 0;
        }
        try {
            return this.table.getSize();
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
            return 0;
        }
    }
}

