/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HGUI.HStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class ControlCurve {
    protected Polygon pts = new Polygon();
    protected int selection = -1;
    protected double scaleFactor = 1.0;
    private int controlPointSize = 8;
    static final int EPSILON = 65;
    private boolean selected = false;
    private static final int END_POINT_DIST = 10;
    private static final int LINE_DIST = 4;

    public void paint(Graphics graphics) {
        if (this.selected) {
            int n;
            Stroke stroke = ((Graphics2D)graphics).getStroke();
            Color color = graphics.getColor();
            graphics.setColor(Color.lightGray);
            ((Graphics2D)graphics).setStroke(HStroke.DASH_STROKE);
            for (n = 0; n < this.pts.npoints - 1; ++n) {
                graphics.drawLine(this.pts.xpoints[n], this.pts.ypoints[n], this.pts.xpoints[n + 1], this.pts.ypoints[n + 1]);
            }
            ((Graphics2D)graphics).setStroke(HStroke.BASIC_STROKE);
            graphics.setColor(Color.lightGray);
            for (n = 0; n < this.pts.npoints; ++n) {
                graphics.drawOval(this.pts.xpoints[n] - this.controlPointSize / 2, this.pts.ypoints[n] - this.controlPointSize / 2, this.controlPointSize, this.controlPointSize);
            }
            graphics.setColor(color);
            ((Graphics2D)graphics).setStroke(stroke);
        }
    }

    public Rectangle getBounds() {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        int n4 = 0;
        for (int i = 2; i < this.pts.npoints - 2; ++i) {
            if (this.pts.xpoints[i] < n) {
                n = this.pts.xpoints[i];
            }
            if (this.pts.ypoints[i] < n2) {
                n2 = this.pts.ypoints[i];
            }
            if (this.pts.xpoints[i] > n3) {
                n3 = this.pts.xpoints[i];
            }
            if (this.pts.ypoints[i] <= n4) continue;
            n4 = this.pts.ypoints[i];
        }
        return new Rectangle(n - this.controlPointSize, n2 - this.controlPointSize, n3 - n + this.controlPointSize * 2, n4 - n2 + this.controlPointSize * 2);
    }

    public int selectPoint(int n, int n2) {
        int n3 = Integer.MAX_VALUE;
        this.selection = -1;
        for (int i = 0; i < this.pts.npoints; ++i) {
            int n4 = ControlCurve.sqr(this.pts.xpoints[i] - n) + ControlCurve.sqr(this.pts.ypoints[i] - n2);
            if (n4 >= n3 || n4 >= 65) continue;
            n3 = n4;
            this.selection = i;
        }
        return this.selection;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    protected void setPts(Polygon polygon) {
        this.pts = new Polygon();
        for (int i = 0; i < polygon.npoints; ++i) {
            this.pts.addPoint(polygon.xpoints[i], polygon.ypoints[i]);
        }
    }

    protected Polygon getPts() {
        return this.pts;
    }

    static int sqr(int n) {
        return n * n;
    }

    public int addPoint(int n, int n2, boolean bl) {
        this.pts.addPoint(n, n2);
        return this.pts.npoints - 1;
    }

    public int addPoint(int n, int n2) {
        this.pts.addPoint(n, n2);
        int n3 = this.getClosestPoint(n, n2);
        if (n3 < 0) {
            return -1;
        }
        for (int i = this.pts.npoints - 1; i > n3; --i) {
            this.pts.xpoints[i] = this.pts.xpoints[i - 1];
            this.pts.ypoints[i] = this.pts.ypoints[i - 1];
        }
        this.pts.xpoints[n3] = n;
        this.pts.ypoints[n3] = n2;
        this.selection = n3;
        return this.selection;
    }

    public void setStart(int n, int n2) {
        for (int i = 0; i < 3; ++i) {
            this.pts.xpoints[i] = n;
            this.pts.ypoints[i] = n2;
        }
    }

    public void setEnd(int n, int n2) {
        for (int i = this.pts.npoints - 3; i < this.pts.npoints; ++i) {
            this.pts.xpoints[i] = n;
            this.pts.ypoints[i] = n2;
        }
    }

    public Point getSecondPoint() {
        return new Point(this.pts.xpoints[3], this.pts.ypoints[3]);
    }

    public Point getSecondLastPoint() {
        return new Point(this.pts.xpoints[this.pts.npoints - 4], this.pts.ypoints[this.pts.npoints - 4]);
    }

    public Point getLastPoint() {
        return new Point(this.pts.xpoints[this.pts.npoints - 1], this.pts.ypoints[this.pts.npoints - 1]);
    }

    private int getClosestPoint(int n, int n2) {
        int n3 = 3;
        Point2D.Float float_ = new Point2D.Float(n, n2);
        Point2D.Float float_2 = new Point2D.Float(n, n2);
        double d = Double.POSITIVE_INFINITY;
        for (int i = 3; i < this.pts.npoints - 4; ++i) {
            double d2 = float_.distance(this.pts.xpoints[i], this.pts.ypoints[i]);
            if (!(d2 <= d)) continue;
            float_2.setLocation(this.pts.xpoints[i], this.pts.ypoints[i]);
            n3 = float_.distance(this.pts.xpoints[i - 1], this.pts.ypoints[i - 1]) < float_2.distance(this.pts.xpoints[i - 1], this.pts.ypoints[i - 1]) ? i : i + 1;
            d = d2;
        }
        return n3;
    }

    public void setPoint(int n, int n2) {
        if (this.selection >= 0) {
            if (this.selection >= this.pts.npoints - 3) {
                this.pts.xpoints[this.pts.npoints - 1] = n;
                this.pts.ypoints[this.pts.npoints - 1] = n2;
                this.pts.xpoints[this.pts.npoints - 2] = n;
                this.pts.ypoints[this.pts.npoints - 2] = n2;
                this.pts.xpoints[this.pts.npoints - 3] = n;
                this.pts.ypoints[this.pts.npoints - 3] = n2;
            } else if (this.selection <= 2) {
                this.pts.xpoints[0] = n;
                this.pts.ypoints[0] = n2;
                this.pts.xpoints[1] = n;
                this.pts.ypoints[1] = n2;
                this.pts.xpoints[2] = n;
                this.pts.ypoints[2] = n2;
            } else {
                this.pts.xpoints[this.selection] = n;
                this.pts.ypoints[this.selection] = n2;
            }
        }
    }

    public void move(int n, int n2) {
        int n3 = 3;
        while (n3 < this.pts.npoints - 3) {
            int n4 = n3;
            this.pts.xpoints[n4] = this.pts.xpoints[n4] + n;
            int n5 = n3++;
            this.pts.ypoints[n5] = this.pts.ypoints[n5] + n2;
        }
    }

    public void trim() {
        int n;
        boolean bl = false;
        int n2 = -1;
        for (n = 3; n < this.pts.npoints - 3 && !bl; ++n) {
            bl = true;
            if (!(Point2D.distance(this.pts.xpoints[n], this.pts.ypoints[n], this.pts.xpoints[2], this.pts.ypoints[2]) < 10.0)) continue;
            bl = false;
            n2 = n;
        }
        if (n2 >= 0) {
            this.selection = n2;
            this.removePoint();
        }
        n2 = -1;
        bl = false;
        for (n = this.pts.npoints - 4; n > 2 && !bl; --n) {
            bl = true;
            if (!(Point2D.distance(this.pts.xpoints[n], this.pts.ypoints[n], this.pts.xpoints[this.pts.npoints - 3], this.pts.ypoints[this.pts.npoints - 3]) < 10.0)) continue;
            bl = false;
            n2 = n;
        }
        if (n2 >= 0) {
            this.selection = n2;
            this.removePoint();
        }
        for (n = 3; n < this.pts.npoints - 3; ++n) {
            if (!(Line2D.ptSegDist(this.pts.xpoints[n - 1], this.pts.ypoints[n - 1], this.pts.xpoints[n + 1], this.pts.ypoints[n + 1], this.pts.xpoints[n], this.pts.ypoints[n]) < 4.0)) continue;
            this.selection = n--;
            this.removePoint();
        }
    }

    public void removePoint() {
        if (this.selection >= 0) {
            --this.pts.npoints;
            for (int i = this.selection; i < this.pts.npoints; ++i) {
                this.pts.xpoints[i] = this.pts.xpoints[i + 1];
                this.pts.ypoints[i] = this.pts.ypoints[i + 1];
            }
        }
    }

    public void reverse() {
        for (int i = 0; i < this.pts.npoints / 2; ++i) {
            int n = this.pts.xpoints[i];
            int n2 = this.pts.ypoints[i];
            this.pts.xpoints[i] = this.pts.xpoints[this.pts.npoints - 1 - i];
            this.pts.ypoints[i] = this.pts.ypoints[this.pts.npoints - 1 - i];
            this.pts.xpoints[this.pts.npoints - 1 - i] = n;
            this.pts.ypoints[this.pts.npoints - 1 - i] = n2;
        }
    }

    public void setScaleFactor(double d) {
        double d2 = d / this.scaleFactor;
        this.scaleFactor = d;
        for (int i = 3; i < this.pts.npoints - 3; ++i) {
            this.pts.xpoints[i] = (int)Math.round((double)this.pts.xpoints[i] * d2);
            this.pts.ypoints[i] = (int)Math.round((double)this.pts.ypoints[i] * d2);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 3; i < this.pts.npoints - 3; ++i) {
            stringBuffer.append("(" + this.pts.xpoints[i] + ", " + this.pts.ypoints[i] + ") ");
        }
        return stringBuffer.toString();
    }
}

