/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.NumberOutOfRangeException;
import COM.hugin.HGUI.PastingTextField;
import java.awt.Dimension;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.EventListener;
import java.util.LinkedList;
import javax.swing.Box;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JOptionPane;
import javax.swing.JScrollBar;

public class CounterField
extends Box {
    PastingTextField field;
    int min;
    int max;
    int actualValue;
    String title;
    SpinnerBar bar;
    LinkedList<ValueListener> valueListeners;

    public CounterField(String string, int n, int n2, int n3) {
        super(0);
        this.initField(string, n, n2, n3, 2);
    }

    public CounterField(String string, int n, int n2, int n3, int n4) {
        super(0);
        this.initField(string, n, n2, n3, n4);
    }

    private void initField(String string, int n, int n2, int n3, int n4) {
        this.min = n;
        this.max = n2;
        this.title = string;
        this.actualValue = n3;
        this.field = new PastingTextField(n4);
        this.field.setText("" + this.actualValue);
        this.field.setMaximumSize(new Dimension(40, 24));
        this.valueListeners = new LinkedList();
        this.bar = new SpinnerBar();
        this.bar.setValue(1);
        this.bar.setModel(new DefaultBoundedRangeModel(n3, 0, n, n2));
        this.bar.setUnitIncrement(-1);
        this.bar.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                try {
                    CounterField.this.setValue(adjustmentEvent.getValue());
                }
                catch (NumberOutOfRangeException numberOutOfRangeException) {
                    new HuginGUIError(numberOutOfRangeException.getMessage());
                }
            }
        });
        this.add(this.field);
        this.add(this.bar);
    }

    public void setToolTipText(String string) {
        this.field.setToolTipText(string);
    }

    public int getValue() throws NumberFormatException, NumberOutOfRangeException {
        int n = 0;
        try {
            n = new Integer(this.field.getText());
            if (n > this.max) {
                JOptionPane.showMessageDialog(this, HuginGUIConstants.get("str_ARG0_not_properly_specified_lb_enter_less_than_ARG1", new String[]{this.title, "" + (this.max + 1)}), HuginGUIConstants.get("str_ARG0_error", new String[]{this.title}), 0);
                this.field.setText("" + this.max);
                throw new NumberOutOfRangeException(HuginGUIConstants.get("str_number_too_high"));
            }
            if (n < this.min) {
                JOptionPane.showMessageDialog(this, HuginGUIConstants.get("str_ARG0_not_properly_specified_lb_enter_greater_than_ARG1", new String[]{this.title, "" + (this.min - 1)}), HuginGUIConstants.get("str_ARG0_error", new String[]{this.title}), 0);
                this.field.setText("" + this.min);
                throw new NumberOutOfRangeException(HuginGUIConstants.get("str_number_too_low"));
            }
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, HuginGUIConstants.get("str_ARG0_not_properly_specified_lb_enter_valid_number", new String[]{this.title}), HuginGUIConstants.get("str_ARG0_error", new String[]{this.title}), 0);
            this.field.setText("" + this.actualValue);
        }
        return n;
    }

    public void setValue(int n) throws NumberOutOfRangeException {
        if (n < this.min || n > this.max) {
            throw new NumberOutOfRangeException(HuginGUIConstants.get("str_number_out_of_range"));
        }
        this.actualValue = n;
        this.field.setText("" + this.actualValue);
    }

    public int getMinimum() {
        return this.min;
    }

    public void setMinimum(int n) {
        this.min = n;
        if (this.actualValue < n) {
            this.actualValue = n;
            this.field.setText("" + this.actualValue);
        }
    }

    public int getMaximum() {
        return this.max;
    }

    public void setMaximum(int n) {
        this.max = n;
        if (this.actualValue > n) {
            this.actualValue = n;
            this.field.setText("" + this.actualValue);
        }
    }

    public float getAlignmentX() {
        return 0.0f;
    }

    public float getAlignmenty() {
        return 0.0f;
    }

    public void addValueListener(ValueListener valueListener) {
        this.valueListeners.add(valueListener);
    }

    public void removeValueListener(ValueListener valueListener) {
        this.valueListeners.remove(valueListener);
    }

    protected void fireValueChanged(int n) throws NumberOutOfRangeException {
        for (ValueListener valueListener : this.valueListeners) {
            valueListener.valueChanged(this.getValue());
        }
    }

    public void setEnabled(boolean bl) {
        this.field.setEnabled(bl);
        this.bar.setEnabled(bl);
    }

    public void setFieldMaximumSize(int n) {
        this.field.setMaximumSize(new Dimension(n, 24));
    }

    public Dimension getMaximumSize() {
        return new Dimension(70, 24);
    }

    private class SpinnerBar
    extends JScrollBar {
        int counter = 0;
        int increment = 0;
        int[] increments = new int[]{1, 5, 10, 100, 1000};
        int maxInc = 3;
        long time;

        SpinnerBar() {
        }

        protected void fireAdjustmentValueChanged(int n, int n2, int n3) {
            long l = this.time;
            this.time = System.currentTimeMillis();
            try {
                int n4;
                CounterField.this.actualValue = n4 = new Integer(CounterField.this.field.getText()).intValue();
                if (this.time - l < 100L) {
                    if (this.increment < this.maxInc - 1) {
                        ++this.counter;
                        if (this.counter > 20) {
                            ++this.increment;
                            CounterField.this.actualValue -= CounterField.this.actualValue % this.increments[this.increment];
                            this.counter = 0;
                        }
                    }
                } else {
                    this.counter = 0;
                    this.increment = 0;
                }
                if (n3 == 0) {
                    CounterField.this.actualValue += this.increments[this.increment];
                }
                if (n3 == 2) {
                    CounterField.this.actualValue -= this.increments[this.increment];
                }
                if (CounterField.this.actualValue > CounterField.this.max) {
                    CounterField.this.actualValue = CounterField.this.max;
                }
                if (CounterField.this.actualValue < CounterField.this.min) {
                    CounterField.this.actualValue = CounterField.this.min;
                }
                CounterField.this.field.setText("" + CounterField.this.actualValue);
                CounterField.this.fireValueChanged(CounterField.this.actualValue);
            }
            catch (NumberFormatException numberFormatException) {
                CounterField.this.field.setText("" + CounterField.this.actualValue);
            }
            catch (NumberOutOfRangeException numberOutOfRangeException) {
                CounterField.this.field.setText("" + CounterField.this.actualValue);
            }
            this.setValue(1);
        }

        public Dimension getMaximumSize() {
            return new Dimension((int)super.getPreferredSize().getWidth(), 24);
        }

        public Dimension getMinimumSize() {
            return new Dimension(10, 10);
        }

        public Dimension getPreferredSize() {
            return new Dimension((int)super.getPreferredSize().getWidth(), 24);
        }
    }

    public static interface ValueListener
    extends EventListener {
        public void valueChanged(int var1);
    }
}

