/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HGUI.NodeGroup;
import COM.hugin.HGUI.PastingTextField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class CustomCellRenderer
extends JLabel
implements ListCellRenderer {
    Font smallFont;

    public CustomCellRenderer() {
        this.setOpaque(true);
        this.smallFont = new PastingTextField().getFont();
        this.setFont(this.smallFont);
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        if (object != null) {
            this.setText(object.toString());
            this.setIcon(new ColorIcon(((NodeGroup)object).getColor(), bl));
        }
        if (bl) {
            this.setBackground(new Color(0, 0, 150));
            this.setForeground(Color.white);
        } else {
            this.setBackground(Color.white);
            this.setForeground(Color.black);
        }
        return this;
    }

    private class ColorIcon
    implements Icon {
        Color color;
        int width = 9;
        int height = 9;
        boolean selected;

        public ColorIcon(Color color) {
            this.color = color;
        }

        public ColorIcon(Color color, boolean bl) {
            this.color = color;
            this.selected = bl;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.color != null) {
                if (this.selected) {
                    graphics.setColor(Color.white);
                } else {
                    graphics.setColor(Color.black);
                }
                graphics.drawRect(n + 3, n2, this.width, this.height);
                graphics.setColor(this.color);
                graphics.fillRect(n + 4, n2 + 1, this.width - 1, this.height - 1);
            } else {
                graphics.setColor(new Color(150, 150, 150));
                graphics.drawRect(n + 3, n2, this.width, this.height);
                graphics.drawLine(n + 3, n2, n + 3 + this.width, n2 + this.height);
                graphics.drawLine(n + 3, n2 + this.height, n + 3 + this.width, n2);
            }
        }

        public Color getColor() {
            return this.color;
        }

        public int getIconWidth() {
            return this.width + 5;
        }

        public int getIconHeight() {
            return this.height + 2;
        }
    }
}

