/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.NetworkModel;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HGUI.BeliefBarPanel;
import COM.hugin.HGUI.FillingFlowLayout;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.HuginProjectFrame;
import COM.hugin.HGUI.NetworkPanel;
import COM.hugin.HGUI.Node;
import COM.hugin.HGUI.NodeSelectorField;
import COM.hugin.HGUI.UtilityNode;
import COM.hugin.HGUI.VerticalFlowLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DSeparationDialog
extends JDialog {
    HuginProjectFrame parent;
    GroupDefiner groupDefiner;
    Dimension minimum = new Dimension(200, 200);
    JRadioButton selected;
    JRadioButton fixed;
    NodeSelectorField selection;
    Node fixedNode;
    JCheckBox[] checks;
    JButton defineGroup;
    JButton addToGroup;
    JButton removeFromGroup;
    JButton defineFakeEvidence;
    JList customGroup;
    Vector<ListItem> customGroupData;
    JCheckBox[] ev_checks;
    JButton ev_defineGroup;
    JButton ev_addToGroup;
    JButton ev_removeFromGroup;
    JList ev_customGroup;
    Vector<ListItem> ev_customGroupData;
    JButton ok;
    JButton cancel;
    JButton perform;

    public DSeparationDialog(HuginProjectFrame huginProjectFrame) {
        super((Frame)Hugin.mainFrame, HuginGUIConstants.get("DSEPARATION"));
        this.parent = huginProjectFrame;
        try {
            huginProjectFrame.addInternalFrameListener(new InternalFrameAdapter(){

                public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
                    DSeparationDialog.this.dispose();
                }
            });
            huginProjectFrame.addModeChangeListener(new HuginProjectFrame.ModeChangeListener(){

                public void modeChanged(int n) {
                    DSeparationDialog.this.dispose();
                }
            });
            this.setContentPane(this.createContent());
            this.groupDefiner = new GroupDefiner(this, huginProjectFrame.getNetworkPanel());
            this.groupDefiner.pack();
            this.readProperties();
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
            this.dispose();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.setSize(Math.max(dimension.getWidth(), this.minimum.getWidth()), Math.max(dimension.getHeight(), this.minimum.getHeight()));
        return dimension;
    }

    private JPanel createContent() throws ExceptionHugin {
        JPanel jPanel = new JPanel(new BorderLayout());
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.add((Component)this.createSourceTab(), HuginGUIConstants.get("str_source"));
        jTabbedPane.add((Component)this.createGroupTab(), HuginGUIConstants.get("str_target_s_"));
        jTabbedPane.add((Component)this.createEvidenceTab(), HuginGUIConstants.get("str_instantiations"));
        jPanel.add(jTabbedPane);
        jPanel.add((Component)this.getButtonPanel(), "South");
        return jPanel;
    }

    private JPanel createSourceTab() {
        JPanel jPanel = new JPanel(new VerticalFlowLayout(false));
        this.selected = new JRadioButton(HuginGUIConstants.get("str_use_selected_node"));
        this.selected.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DSeparationDialog.this.selection.setEnabled(DSeparationDialog.this.fixed.isSelected());
            }
        });
        this.fixed = new JRadioButton(HuginGUIConstants.get("str_use_static_node") + " : ");
        this.fixed.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DSeparationDialog.this.selection.setEnabled(DSeparationDialog.this.fixed.isSelected());
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.selected);
        buttonGroup.add(this.fixed);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        this.selection = new NodeSelectorField(this.parent){

            public void performAction(Node node, int n) {
                if (node == null && n == 2) {
                    DSeparationDialog.this.selection.hidePopup();
                    return;
                }
                if (n == 2) {
                    try {
                        DSeparationDialog.this.selection.setText(HuginGUIUtils.getNodeTitle(node.getAPINode()));
                        DSeparationDialog.this.fixedNode = node;
                    }
                    catch (Exception exception) {
                        new HuginGUIError(exception);
                    }
                    DSeparationDialog.this.selection.hidePopup();
                } else {
                    this.checkForScrolling(n);
                }
            }
        };
        this.selected.setSelected(true);
        this.fixed.setSelected(!this.selected.isSelected());
        this.selection.setEnabled(this.fixed.isSelected());
        jPanel2.add(this.fixed);
        jPanel2.add(this.selection);
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        jPanel3.add(this.selected);
        jPanel.add(jPanel3);
        jPanel.add(jPanel2);
        return jPanel;
    }

    private JPanel createGroupTab() throws ExceptionHugin {
        JPanel jPanel = new JPanel(new BorderLayout());
        String[] stringArray = this.getGroupNames(this.parent.getNetworkPanel().getHome());
        JPanel jPanel2 = new JPanel(new GridLayout(stringArray.length + 2, 1));
        this.checks = new JCheckBox[stringArray.length + 2];
        this.checks[0] = new JCheckBox(HuginGUIConstants.get("DSEPARATION_No_Group"));
        jPanel2.add(this.checks[0]);
        for (int i = 1; i < this.checks.length - 1; ++i) {
            this.checks[i] = new JCheckBox(stringArray[i - 1]);
            jPanel2.add(this.checks[i]);
        }
        this.checks[this.checks.length - 1] = new JCheckBox(HuginGUIConstants.get("DSEPARATION_Custom_Group"));
        this.checks[this.checks.length - 1].addActionListener(new EnableCustomGroupListener(false));
        jPanel2.add(this.checks[this.checks.length - 1]);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel2, "North");
        JScrollPane jScrollPane = new JScrollPane(jPanel3);
        JLabel jLabel = new JLabel(HuginGUIConstants.get("str_include_groups_"));
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)jLabel, "North");
        jPanel4.add(jScrollPane);
        this.customGroupData = new Vector();
        this.customGroup = new JList<ListItem>(this.customGroupData);
        this.customGroup.setBorder(BorderFactory.createLoweredBevelBorder());
        this.customGroup.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DSeparationDialog.this.removeFromGroup.setEnabled(DSeparationDialog.this.customGroup.getSelectedIndex() >= 0);
            }
        });
        this.customGroup.setEnabled(false);
        JPanel jPanel5 = new JPanel(new BorderLayout());
        JScrollPane jScrollPane2 = new JScrollPane(this.customGroup);
        jScrollPane2.setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("str_custom_group")));
        jPanel5.add(jScrollPane2);
        this.addToGroup = new JButton(HuginGUIConstants.get("str_add_selected"));
        this.addToGroup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                for (Node node : DSeparationDialog.this.parent.getNetworkPanel().selectedNodes) {
                    ListItem listItem = new ListItem(node);
                    if (!DSeparationDialog.this.customGroupData.contains(listItem)) {
                        DSeparationDialog.this.customGroupData.add(listItem);
                    }
                    Collections.sort(DSeparationDialog.this.customGroupData);
                    DSeparationDialog.this.customGroup.setListData(DSeparationDialog.this.customGroupData);
                }
            }
        });
        this.addToGroup.setEnabled(false);
        this.defineGroup = new JButton(HuginGUIConstants.get("str_define"));
        this.defineGroup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DSeparationDialog.this.groupDefiner.setGroup(DSeparationDialog.this.customGroupData);
                DSeparationDialog.this.groupDefiner.setExcludeGroup(DSeparationDialog.this.ev_customGroupData);
                DSeparationDialog.this.groupDefiner.setMode(1);
                DSeparationDialog.this.groupDefiner.pack();
                HuginGUIUtils.placeNextTo(DSeparationDialog.this, DSeparationDialog.this.groupDefiner);
                DSeparationDialog.this.groupDefiner.setVisible(true);
            }
        });
        this.defineGroup.setEnabled(false);
        this.removeFromGroup = new JButton(HuginGUIConstants.get("str_remove"));
        this.removeFromGroup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = DSeparationDialog.this.customGroup.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    DSeparationDialog.this.customGroupData.remove(objectArray[i]);
                }
                DSeparationDialog.this.customGroup.setListData(DSeparationDialog.this.customGroupData);
            }
        });
        this.removeFromGroup.setEnabled(false);
        JPanel jPanel6 = new JPanel(new FlowLayout());
        jPanel6.add(this.addToGroup);
        jPanel6.add(this.removeFromGroup);
        jPanel6.add(this.defineGroup);
        jPanel5.add((Component)jPanel6, "South");
        jScrollPane.setMinimumSize(jScrollPane.getPreferredSize());
        JSplitPane jSplitPane = new JSplitPane(1, jScrollPane, jPanel5);
        jPanel.add(jSplitPane);
        return jPanel;
    }

    private JPanel createEvidenceTab() throws ExceptionHugin {
        JPanel jPanel = new JPanel(new BorderLayout());
        String[] stringArray = this.getGroupNames(this.parent.getNetworkPanel().getHome());
        JPanel jPanel2 = new JPanel(new GridLayout(stringArray.length + 3, 1));
        this.ev_checks = new JCheckBox[stringArray.length + 3];
        this.ev_checks[0] = new JCheckBox(HuginGUIConstants.get("DSEPARATION_No_Group"));
        jPanel2.add(this.ev_checks[0]);
        for (int i = 1; i < this.ev_checks.length - 2; ++i) {
            this.ev_checks[i] = new JCheckBox(stringArray[i - 1]);
            jPanel2.add(this.ev_checks[i]);
        }
        this.ev_checks[this.ev_checks.length - 2] = new JCheckBox(HuginGUIConstants.get("DSEPARATION_Custom_Evidence"));
        this.ev_checks[this.ev_checks.length - 2].addActionListener(new EnableCustomGroupListener(true));
        jPanel2.add(this.ev_checks[this.ev_checks.length - 2]);
        this.ev_checks[this.ev_checks.length - 1] = new JCheckBox(HuginGUIConstants.get("DSEPARATION_Actual_Evidence"));
        jPanel2.add(this.ev_checks[this.ev_checks.length - 1]);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel2, "North");
        JScrollPane jScrollPane = new JScrollPane(jPanel3);
        JLabel jLabel = new JLabel(HuginGUIConstants.get("str_include_groups_"));
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)jLabel, "North");
        jPanel4.add(jScrollPane);
        this.ev_customGroupData = new Vector();
        this.ev_customGroup = new JList<ListItem>(this.ev_customGroupData);
        this.ev_customGroup.setBorder(BorderFactory.createLoweredBevelBorder());
        this.ev_customGroup.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DSeparationDialog.this.ev_removeFromGroup.setEnabled(DSeparationDialog.this.ev_customGroup.getSelectedIndex() >= 0);
            }
        });
        this.ev_customGroup.setEnabled(false);
        JPanel jPanel5 = new JPanel(new BorderLayout());
        JScrollPane jScrollPane2 = new JScrollPane(this.ev_customGroup);
        jScrollPane2.setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("str_custom_evidence")));
        jPanel5.add(jScrollPane2);
        this.ev_addToGroup = new JButton(HuginGUIConstants.get("str_add_selected"));
        this.ev_addToGroup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                for (Node node : DSeparationDialog.this.parent.getNetworkPanel().selectedNodes) {
                    ListItem listItem = new ListItem(node);
                    if (!DSeparationDialog.this.ev_customGroupData.contains(listItem)) {
                        DSeparationDialog.this.ev_customGroupData.add(listItem);
                    }
                    Collections.sort(DSeparationDialog.this.ev_customGroupData);
                    DSeparationDialog.this.ev_customGroup.setListData(DSeparationDialog.this.ev_customGroupData);
                }
            }
        });
        this.ev_addToGroup.setEnabled(false);
        this.ev_defineGroup = new JButton(HuginGUIConstants.get("str_define"));
        this.ev_defineGroup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DSeparationDialog.this.groupDefiner.setGroup(DSeparationDialog.this.ev_customGroupData);
                DSeparationDialog.this.groupDefiner.setExcludeGroup(DSeparationDialog.this.customGroupData);
                DSeparationDialog.this.groupDefiner.setMode(0);
                DSeparationDialog.this.groupDefiner.pack();
                HuginGUIUtils.placeNextTo(DSeparationDialog.this, DSeparationDialog.this.groupDefiner);
                DSeparationDialog.this.groupDefiner.setVisible(true);
            }
        });
        this.ev_defineGroup.setEnabled(false);
        this.ev_removeFromGroup = new JButton(HuginGUIConstants.get("str_remove"));
        this.ev_removeFromGroup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = DSeparationDialog.this.ev_customGroup.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    DSeparationDialog.this.ev_customGroupData.remove(objectArray[i]);
                }
                DSeparationDialog.this.ev_customGroup.setListData(DSeparationDialog.this.ev_customGroupData);
            }
        });
        this.ev_removeFromGroup.setEnabled(false);
        JPanel jPanel6 = new JPanel(new FlowLayout());
        jPanel6.add(this.ev_addToGroup);
        jPanel6.add(this.ev_removeFromGroup);
        jPanel6.add(this.ev_defineGroup);
        jPanel5.add((Component)jPanel6, "South");
        jScrollPane.setMinimumSize(jScrollPane.getPreferredSize());
        JSplitPane jSplitPane = new JSplitPane(1, jScrollPane, jPanel5);
        jPanel.add(jSplitPane);
        return jPanel;
    }

    private void readProperties() throws ExceptionHugin {
        LinkedList<Node> linkedList;
        LinkedList<Node> linkedList2;
        Object object;
        NetworkModel networkModel = this.parent.getNetworkPanel().getHome();
        boolean bl = true;
        this.fixedNode = DSeparationDialog.getSourceNode(this.parent.getNetworkPanel());
        boolean bl2 = bl = this.fixedNode == null;
        if (!bl) {
            this.selection.setText(HuginGUIUtils.getNodeTitle(this.fixedNode.getAPINode()));
        }
        this.selected.setSelected(bl);
        this.fixed.setSelected(!bl);
        this.selection.setEnabled(this.fixed.isSelected());
        String string = networkModel.getAttribute("HR_DSep_Groups");
        for (int i = 0; i < this.checks.length; ++i) {
            this.checks[i].setSelected(false);
        }
        if (string != null && string.trim().length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken();
                if (((String)object).equals("(no group)")) {
                    this.checks[0].setSelected(true);
                    continue;
                }
                if (((String)object).equals("(custom)")) {
                    this.checks[this.checks.length - 1].setSelected(true);
                    this.customGroup.setEnabled(true);
                    this.addToGroup.setEnabled(true);
                    this.defineGroup.setEnabled(true);
                    this.removeFromGroup.setEnabled(this.customGroup.getSelectedIndex() >= 0);
                    continue;
                }
                for (int i = 1; i < this.checks.length - 1; ++i) {
                    this.checks[i].setSelected(this.checks[i].isSelected() || this.checks[i].getText().equals(object));
                }
            }
        }
        if ((linkedList2 = DSeparationDialog.getCustomTargetNodes(this.parent.getNetworkPanel())) != null) {
            for (Node node : linkedList2) {
                this.customGroupData.add(new ListItem(node));
            }
        }
        this.customGroup.setListData(this.customGroupData);
        object = networkModel.getAttribute("HR_DSep_Evidence");
        if (object != null && ((String)object).trim().length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, "\t");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.equals("(no group)")) {
                    this.ev_checks[0].setSelected(true);
                    continue;
                }
                if (string2.equals("(actual)")) {
                    this.ev_checks[this.ev_checks.length - 1].setSelected(true);
                    continue;
                }
                if (string2.equals("(custom)")) {
                    this.ev_checks[this.ev_checks.length - 2].setSelected(true);
                    this.ev_customGroup.setEnabled(true);
                    this.ev_addToGroup.setEnabled(true);
                    this.ev_defineGroup.setEnabled(true);
                    this.ev_removeFromGroup.setEnabled(this.ev_customGroup.getSelectedIndex() >= 0);
                    continue;
                }
                for (int i = 1; i < this.ev_checks.length - 2; ++i) {
                    this.ev_checks[i].setSelected(this.ev_checks[i].isSelected() || this.ev_checks[i].getText().equals(string2));
                }
            }
        }
        if ((linkedList = DSeparationDialog.getCustomEvidenceNodes(this.parent.getNetworkPanel())) != null) {
            for (Node node : linkedList) {
                this.ev_customGroupData.add(new ListItem(node));
            }
        }
        this.ev_customGroup.setListData(this.ev_customGroupData);
    }

    private void writeProperties() throws ExceptionHugin {
        NetworkModel networkModel = this.parent.getNetworkPanel().getHome();
        String string = this.selected.isSelected() ? "(selected)" : (this.fixedNode != null ? this.fixedNode.getAPINode().getName() : "(selected)");
        networkModel.setAttribute("HR_DSep_Source", string);
        String string2 = "";
        if (this.checks[0].isSelected()) {
            string2 = string2 + "(no group)\t";
        }
        for (int i = 1; i < this.checks.length - 1; ++i) {
            string2 = string2 + (this.checks[i].isSelected() ? this.checks[i].getText() + "\t" : "");
        }
        if (this.checks[this.checks.length - 1].isSelected()) {
            string2 = string2 + "(custom)";
        }
        if (string2.length() > 0 && string2.charAt(string2.length() - 1) == '\t') {
            string2 = string2.substring(0, string2.length() - 1);
        }
        networkModel.setAttribute("HR_DSep_Groups", string2);
        String string3 = "";
        if (this.checks[this.checks.length - 1].isSelected()) {
            for (int i = 0; i < this.customGroupData.size(); ++i) {
                string3 = string3 + this.customGroupData.get(i).getNode().getAPINode().getName() + "\t";
            }
            if (string3.length() > 0) {
                string3 = string3.substring(0, string3.length() - 1);
            }
        }
        networkModel.setAttribute("HR_DSep_Custom_Group", string3);
        String string4 = "";
        if (this.ev_checks[this.ev_checks.length - 1].isSelected()) {
            string4 = string4 + "(actual)\t";
        }
        if (this.ev_checks[0].isSelected()) {
            string4 = string4 + "(no group)\t";
        }
        for (int i = 1; i < this.ev_checks.length - 2; ++i) {
            string4 = string4 + (this.ev_checks[i].isSelected() ? this.ev_checks[i].getText() + "\t" : "");
        }
        if (this.ev_checks[this.ev_checks.length - 2].isSelected()) {
            string4 = string4 + "(custom)";
        }
        if (string4.length() > 0 && string4.charAt(string4.length() - 1) == '\t') {
            string4 = string4.substring(0, string4.length() - 1);
        }
        networkModel.setAttribute("HR_DSep_Evidence", string4);
        String string5 = "";
        if (this.ev_checks[this.ev_checks.length - 2].isSelected()) {
            for (int i = 0; i < this.ev_customGroupData.size(); ++i) {
                string5 = string5 + this.ev_customGroupData.get(i).getNode().getAPINode().getName() + "\t";
            }
            if (string5.length() > 0) {
                string5 = string5.substring(0, string5.length() - 1);
            }
        }
        networkModel.setAttribute("HR_DSep_Custom_Evidence", string5);
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2));
        this.ok = new JButton(HuginGUIConstants.get("OK_button"));
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    DSeparationDialog.this.writeProperties();
                    DSeparationDialog.this.dispose();
                    DSeparationDialog.this.parent.getNetworkPanel().containsUnsavedChanges(true);
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
            }
        });
        this.perform = new JButton(HuginGUIConstants.get("ANALYSIS_Calculate"));
        this.perform.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    DSeparationDialog.this.writeProperties();
                    DSeparationDialog.this.parent.getNetworkPanel().containsUnsavedChanges(true);
                    DSeparationDialog.this.parent.getNetworkPanel().setDSepMode();
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
            }
        });
        this.cancel = new JButton(HuginGUIConstants.get("cancel_button"));
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DSeparationDialog.this.dispose();
            }
        });
        jPanel.add(this.ok);
        jPanel.add(this.perform);
        jPanel.add(this.cancel);
        return jPanel;
    }

    private String[] getGroupNames(NetworkModel networkModel) throws ExceptionHugin {
        String string = networkModel.getAttribute("HR_Groups_IDs");
        if (string == null || string.trim().length() == 0) {
            int n;
            String string2 = networkModel.getAttribute("HR_Groups_UserGroupsNo");
            int n2 = n = string2 == null || string2.length() == 0 ? 0 : Integer.parseInt(string2);
            if (n == 0) {
                return new String[0];
            }
            String string3 = networkModel.getAttribute("HR_Groups_GroupNames");
            if (string3 == null || string3.length() == 0) {
                return new String[0];
            }
            String[] stringArray = new String[n];
            int n3 = string3.indexOf(9);
            int n4 = 0;
            while (n3 >= 0 && n4 < stringArray.length) {
                stringArray[n4++] = string3.substring(0, n3);
                string3 = string3.substring(n3 + 1);
                n3 = string3.indexOf(9);
            }
            if (n4 < stringArray.length) {
                stringArray[n4] = string3;
            }
            return stringArray;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken());
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = networkModel.getAttribute("HR_Group_" + (String)vector.get(i) + "_Name");
        }
        return stringArray;
    }

    public void setGroup(Vector<ListItem> vector, int n) {
        switch (n) {
            case 1: {
                this.customGroupData = new Vector<ListItem>(vector);
                this.customGroup.setListData(this.customGroupData);
                break;
            }
            case 0: {
                this.ev_customGroupData = new Vector<ListItem>(vector);
                this.ev_customGroup.setListData(this.ev_customGroupData);
            }
        }
    }

    public static Node getSourceNode(NetworkPanel networkPanel) throws ExceptionHugin {
        if (networkPanel.getHome() == null) {
            return null;
        }
        String string = networkPanel.getHome().getAttribute("HR_DSep_Source");
        boolean bl = true;
        if (string != null && string.trim().length() > 0 && !string.equals("(selected)")) {
            return networkPanel.getNode(string);
        }
        return null;
    }

    private static LinkedList<Node> getCustomTargetNodes(NetworkPanel networkPanel) throws ExceptionHugin {
        String string = networkPanel.getHome().getAttribute("HR_DSep_Custom_Group");
        LinkedList<Node> linkedList = null;
        if (string != null && string.trim().length() > 0) {
            linkedList = new LinkedList<Node>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                Node node = networkPanel.getNode(string2);
                if (node == null) continue;
                linkedList.add(node);
            }
        }
        return linkedList;
    }

    public static LinkedList<Node> getTargetNodes(NetworkPanel networkPanel) throws ExceptionHugin {
        String string = networkPanel.getHome().getAttribute("HR_DSep_Groups");
        LinkedList<Node> linkedList = null;
        if (string != null && string.trim().length() > 0) {
            linkedList = new LinkedList<Node>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.equals("(custom)")) {
                    LinkedList<Node> linkedList2 = DSeparationDialog.getCustomTargetNodes(networkPanel);
                    if (linkedList2 == null) continue;
                    linkedList.addAll(linkedList2);
                    continue;
                }
                boolean bl = string2.equals("(no group)");
                for (Node node : networkPanel.nodeList) {
                    if ((!bl || node.getGroupName() != null && !node.getGroupName().equals("") && !node.getGroupName().equalsIgnoreCase("no group")) && (node.getGroupName() == null || !node.getGroupName().equals(string2))) continue;
                    linkedList.add(node);
                }
            }
        }
        return linkedList;
    }

    private static LinkedList<Node> getCustomEvidenceNodes(NetworkPanel networkPanel) throws ExceptionHugin {
        String string = networkPanel.getHome().getAttribute("HR_DSep_Custom_Evidence");
        LinkedList<Node> linkedList = null;
        if (string != null && string.trim().length() > 0) {
            linkedList = new LinkedList<Node>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                Node node = networkPanel.getNode(string2);
                if (node == null) continue;
                linkedList.add(node);
            }
        }
        return linkedList;
    }

    public static NodeGroups getEvidenceNodes(NetworkPanel networkPanel, BeliefBarPanel beliefBarPanel) throws ExceptionHugin {
        String string = networkPanel.getHome().getAttribute("HR_DSep_Evidence");
        NodeGroups nodeGroups = new NodeGroups(networkPanel);
        if (string != null && string.trim().length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.equals("(actual)") && beliefBarPanel != null) {
                    nodeGroups.addApiNodes(DSeparationDialog.getActualEvidenceNodes(networkPanel, beliefBarPanel));
                    continue;
                }
                if (string2.equals("(custom)")) {
                    LinkedList<Node> linkedList = DSeparationDialog.getCustomEvidenceNodes(networkPanel);
                    if (linkedList == null) continue;
                    nodeGroups.addGuiNodes(linkedList);
                    continue;
                }
                boolean bl = string2.equals("(no group)");
                for (Node node : networkPanel.nodeList) {
                    if ((!bl || node.getGroupName() != null && !node.getGroupName().equals("") && !node.getGroupName().toLowerCase().equals("no group")) && (node.getGroupName() == null || !node.getGroupName().equals(string2))) continue;
                    nodeGroups.add(node);
                }
            }
        }
        return nodeGroups;
    }

    private static NodeList getActualEvidenceNodes(NetworkPanel networkPanel, BeliefBarPanel beliefBarPanel) throws ExceptionHugin {
        NodeList nodeList = new NodeList();
        for (COM.hugin.HAPI.Node node : beliefBarPanel.getDomain().getNodes()) {
            if (!node.evidenceIsEntered()) continue;
            nodeList.add(node);
        }
        return nodeList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NodeGroups {
        LinkedList<Node> guiResults = new LinkedList();
        NodeList apiResults = new NodeList();
        NetworkPanel panel;

        public NodeGroups(NetworkPanel networkPanel) {
            this.panel = networkPanel;
        }

        public void addGuiNodes(LinkedList<Node> linkedList) {
            if (linkedList != null) {
                for (Node node : linkedList) {
                    if (this.guiResults.contains(node)) continue;
                    this.guiResults.add(node);
                    this.apiResults.add(node.getAPINode());
                }
            }
        }

        public void addApiNodes(LinkedList<COM.hugin.HAPI.Node> linkedList) {
            if (linkedList != null) {
                for (COM.hugin.HAPI.Node node : linkedList) {
                    Node node2 = this.panel.getNode(node);
                    if (node2 == null) {
                        try {
                            node2 = this.panel.getNode(node.getName());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (node2 == null || this.guiResults.contains(node2)) continue;
                    this.guiResults.add(node2);
                    this.apiResults.add(node);
                }
            }
        }

        public void add(Node node) {
            if (!this.guiResults.contains(node)) {
                this.guiResults.add(node);
                this.apiResults.add(node.getAPINode());
            }
        }

        public void add(COM.hugin.HAPI.Node node) {
        }

        public LinkedList<Node> getGuiNodes() {
            return this.guiResults;
        }

        public NodeList getApiNodes() {
            return this.apiResults;
        }
    }

    private class EnableCustomGroupListener
    implements ActionListener {
        private boolean evidence;

        public EnableCustomGroupListener(boolean bl) {
            this.evidence = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.evidence) {
                boolean bl = DSeparationDialog.this.checks[DSeparationDialog.this.checks.length - 1].isSelected();
                DSeparationDialog.this.customGroup.setEnabled(bl);
                DSeparationDialog.this.addToGroup.setEnabled(bl);
                DSeparationDialog.this.defineGroup.setEnabled(bl);
                DSeparationDialog.this.removeFromGroup.setEnabled(bl && DSeparationDialog.this.customGroup.getSelectedIndex() >= 0);
            } else {
                boolean bl = DSeparationDialog.this.ev_checks[DSeparationDialog.this.ev_checks.length - 2].isSelected();
                DSeparationDialog.this.ev_customGroup.setEnabled(bl);
                DSeparationDialog.this.ev_addToGroup.setEnabled(bl);
                DSeparationDialog.this.ev_defineGroup.setEnabled(bl);
                DSeparationDialog.this.ev_removeFromGroup.setEnabled(bl && DSeparationDialog.this.ev_customGroup.getSelectedIndex() >= 0);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListItem
    implements Comparable<ListItem>,
    Cloneable {
        private Node node;
        boolean empty;

        public ListItem(Node node) {
            this.node = node;
            this.empty = false;
        }

        public String toString() {
            if (this.empty) {
                return " ";
            }
            try {
                return HuginGUIUtils.getNodeTitle(this.node.getAPINode());
            }
            catch (Exception exception) {
                return "-------";
            }
        }

        public boolean isEmpty() {
            return this.empty;
        }

        public Node getNode() {
            return this.node;
        }

        public boolean equals(Object object) {
            return object instanceof ListItem && ((ListItem)object).getNode().equals(this.node);
        }

        @Override
        public int compareTo(ListItem listItem) {
            try {
                return HuginGUIUtils.compareNodes(this.getNode(), listItem.getNode(), 0);
            }
            catch (Exception exception) {
                return -1;
            }
        }

        public void setEmpty(boolean bl) {
            this.empty = bl;
        }

        public Object clone() {
            return new ListItem(this.getNode());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GroupDefiner
    extends JDialog {
        JList customGroup;
        JList allNodes;
        Vector<ListItem> groupData;
        Vector<ListItem> nodeData;
        NetworkPanel.SelectionListener listener;
        NetworkPanel panel;
        JButton add;
        JButton remove;
        JButton addAll;
        JButton removeAll;
        JButton ok;
        JButton cancel;
        int mode;
        public static final int MODE_EVIDENCE = 0;
        public static final int MODE_GROUP = 1;

        public GroupDefiner(JDialog jDialog, NetworkPanel networkPanel) {
            Object object2;
            super((Dialog)jDialog, HuginGUIConstants.get("str_custom_group"));
            this.mode = 1;
            this.groupData = new Vector();
            this.nodeData = new Vector();
            this.panel = networkPanel;
            for (Object object2 : networkPanel.nodeList) {
                this.nodeData.add(new ListItem((Node)object2));
            }
            Collections.sort(this.nodeData);
            this.listener = new NetworkPanel.SelectionListener(){

                public void selectionChanged(NetworkPanel.SelectionEvent selectionEvent) {
                }
            };
            networkPanel.addSelectionListener(this.listener);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            object2 = new JPanel(new FillingFlowLayout());
            this.customGroup = new JList<ListItem>(this.groupData);
            this.allNodes = new JList();
            JPanel jPanel2 = new JPanel(new VerticalFlowLayout());
            this.add = new JButton(">>"){

                public Insets getInsets() {
                    return new Insets(5, 5, 5, 5);
                }
            };
            this.add.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    for (Object object : GroupDefiner.this.allNodes.getSelectedValues()) {
                        if (!(object instanceof ListItem) || GroupDefiner.this.groupData.contains(object)) continue;
                        GroupDefiner.this.groupData.add((ListItem)object);
                        GroupDefiner.this.nodeData.remove((ListItem)object);
                    }
                    Collections.sort(GroupDefiner.this.groupData);
                    GroupDefiner.this.customGroup.setListData(GroupDefiner.this.groupData);
                    GroupDefiner.this.allNodes.setListData(GroupDefiner.this.nodeData);
                }
            });
            this.addAll = new JButton(HuginGUIConstants.get("str_add_all")){

                public Insets getInsets() {
                    return new Insets(5, 5, 5, 5);
                }
            };
            this.addAll.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    for (int i = 0; i < GroupDefiner.this.nodeData.size(); ++i) {
                        ListItem listItem = GroupDefiner.this.nodeData.get(i);
                        if (GroupDefiner.this.groupData.contains(listItem)) continue;
                        GroupDefiner.this.groupData.add(listItem);
                    }
                    GroupDefiner.this.nodeData.clear();
                    Collections.sort(GroupDefiner.this.groupData);
                    GroupDefiner.this.customGroup.setListData(GroupDefiner.this.groupData);
                    GroupDefiner.this.allNodes.setListData(GroupDefiner.this.nodeData);
                }
            });
            this.remove = new JButton("<<"){

                public Insets getInsets() {
                    return new Insets(5, 5, 5, 5);
                }
            };
            this.remove.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Object[] objectArray = GroupDefiner.this.customGroup.getSelectedValues();
                    for (int i = 0; i < objectArray.length; ++i) {
                        if (!(objectArray[i] instanceof ListItem)) continue;
                        GroupDefiner.this.nodeData.add((ListItem)objectArray[i]);
                        GroupDefiner.this.groupData.remove((ListItem)objectArray[i]);
                    }
                    Collections.sort(GroupDefiner.this.nodeData);
                    GroupDefiner.this.customGroup.setListData(GroupDefiner.this.groupData);
                    GroupDefiner.this.allNodes.setListData(GroupDefiner.this.nodeData);
                }
            });
            this.removeAll = new JButton(HuginGUIConstants.get("str_clear")){

                public Insets getInsets() {
                    return new Insets(5, 5, 5, 5);
                }
            };
            this.removeAll.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    GroupDefiner.this.clear();
                }
            });
            jPanel2.add(this.add);
            jPanel2.add(this.remove);
            jPanel2.add(this.addAll);
            jPanel2.add(this.removeAll);
            ((Container)object2).add(new JScrollPane(this.allNodes));
            ((Container)object2).add(jPanel2);
            ((Container)object2).add(new JScrollPane(this.customGroup));
            JPanel jPanel3 = new JPanel(new FlowLayout());
            this.ok = new JButton(HuginGUIConstants.get("OK_button"));
            this.ok.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DSeparationDialog.this.setGroup(GroupDefiner.this.groupData, GroupDefiner.this.mode);
                    GroupDefiner.this.dispose();
                }
            });
            this.cancel = new JButton(HuginGUIConstants.get("cancel_button"));
            this.cancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    GroupDefiner.this.dispose();
                }
            });
            jPanel3.add(this.ok);
            jPanel3.add(this.cancel);
            jPanel.add((Component)object2);
            jPanel.add((Component)jPanel3, "South");
            this.setContentPane(jPanel);
            this.addWindowListener(new WindowAdapter(){

                public void windowClosed(WindowEvent windowEvent) {
                    if (GroupDefiner.this.listener != null) {
                        GroupDefiner.this.panel.removeSelectionListener(GroupDefiner.this.listener);
                    }
                }
            });
            this.allNodes.setListData(this.nodeData);
        }

        public void setGroup(Vector<ListItem> vector) {
            this.clear();
            for (ListItem listItem : vector) {
                this.groupData.add(listItem);
                this.nodeData.remove(listItem);
            }
            Collections.sort(this.groupData);
            this.customGroup.setListData(this.groupData);
            Collections.sort(this.nodeData);
            this.allNodes.setListData(this.nodeData);
        }

        public void setExcludeGroup(Vector<ListItem> vector) {
            for (ListItem listItem : vector) {
                this.groupData.remove(listItem);
                this.nodeData.remove(listItem);
            }
            this.customGroup.setListData(this.groupData);
            this.allNodes.setListData(this.nodeData);
        }

        private void clear() {
            for (ListItem listItem : this.groupData) {
                if (this.nodeData.contains(listItem)) continue;
                this.nodeData.add(listItem);
            }
            this.groupData.clear();
            Collections.sort(this.groupData);
            this.customGroup.setListData(this.groupData);
            this.allNodes.setListData(this.nodeData);
        }

        public Vector<ListItem> getGroup() {
            return this.groupData;
        }

        public void setMode(int n) {
            this.mode = n;
            if (n == 0) {
                int n2 = 0;
                while (n2 < this.nodeData.size()) {
                    if (this.nodeData.get(n2).getNode() instanceof UtilityNode) {
                        this.nodeData.remove(n2);
                        continue;
                    }
                    ++n2;
                }
                this.allNodes.setListData(this.nodeData);
            }
        }
    }
}

