/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HGUI.DataAnalyserModel;
import COM.hugin.HGUI.DataInspector;
import COM.hugin.HGUI.DataStream;
import COM.hugin.HGUI.DiscretizeDialog;
import COM.hugin.HGUI.DiscretizeProcess;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DataAnalyser
extends JDialog {
    private DataAnalyserModel model;
    private DiscretizeDialog discretizer;
    private DataInspector dataInspector;
    private DataStream stream;
    private JList variables;
    private JButton selectAllButton;
    private DistributionDisplay display;
    private JLabel[] dataInfoLabels;
    private int numberOfDataLabels = 4;
    JButton clear;
    JButton clearall;
    JButton apply;
    JButton cancel;
    JButton ok;

    public DataAnalyser(JDialog jDialog, DataStream dataStream) {
        super(jDialog, HuginGUIConstants.get("str_data_analyzer_tool"), true);
        this.model = new DataAnalyserModel(dataStream);
        this.stream = dataStream;
        try {
            this.model.initialize();
            this.setContentPane(this.createContents());
            this.discretizer = new DiscretizeDialog(this);
            this.dataInspector = new DataInspector(this.discretizer);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            new HuginGUIError(exception.getMessage());
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                try {
                    DataAnalyser.this.showDiscretizerFor((DataAnalyserModel.DataHolder)DataAnalyser.this.variables.getSelectedValue());
                }
                catch (Exception exception) {
                    new HuginGUIError(HuginGUIConstants.get("str_unable_to_show_disc_pane_ARG0", new String[]{exception.getMessage()}));
                }
            }
        });
    }

    private JLabel[] createDataInfoLabels(JPanel jPanel) {
        JLabel[] jLabelArray = new JLabel[this.numberOfDataLabels];
        for (int i = 0; i < this.numberOfDataLabels; ++i) {
            jLabelArray[i] = new JLabel("", 2);
            jPanel.add(jLabelArray[i]);
        }
        return jLabelArray;
    }

    private void showDataInfo(DataAnalyserModel.DataHolder dataHolder, JLabel[] jLabelArray) {
        DecimalFormat decimalFormat = new DecimalFormat();
        if (dataHolder == null) {
            jLabelArray[0].setText(HuginGUIConstants.get("str_values_ARG0", new String[]{"--"}));
            jLabelArray[1].setText(HuginGUIConstants.get("str_distinct_values_ARG0", new String[]{"--"}));
            jLabelArray[2].setText(HuginGUIConstants.get("str_percent_missing_values_ARG0", new String[]{"--"}));
            jLabelArray[3].setText("");
            return;
        }
        int[] nArray = dataHolder.getCounts();
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n += nArray[i];
        }
        decimalFormat.setMaximumFractionDigits(0);
        jLabelArray[0].setText(HuginGUIConstants.get("str_values_ARG0", new String[]{"" + decimalFormat.format(n)}));
        jLabelArray[1].setText(HuginGUIConstants.get("str_distinct_values_ARG0", new String[]{"" + decimalFormat.format(nArray.length)}));
        if (nArray.length == 1) {
            jLabelArray[1].setText(HuginGUIConstants.get("str_distinct_values_ARG0", new String[]{"" + decimalFormat.format(nArray.length)}));
        }
        decimalFormat.setMaximumFractionDigits(2);
        jLabelArray[2].setText(HuginGUIConstants.get("str_percent_missing_values_ARG0", new String[]{"" + decimalFormat.format(dataHolder.getMissingDataPercentage())}));
        if (dataHolder.isNumerical() && nArray.length == 1) {
            jLabelArray[3].setText("<HTML><FONT COLOR = RED>" + HuginGUIConstants.get("DATAANALYSER_Unable_to_discretize") + "</FONT></HTML>");
        } else {
            jLabelArray[3].setText("");
        }
    }

    private JPanel createContents() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(4, 1));
        this.dataInfoLabels = this.createDataInfoLabels(jPanel2);
        this.variables = new JList<DataAnalyserModel.DataHolder>(this.model.getVariables());
        this.variables.setCellRenderer(new NumericVariableRenderer());
        this.variables.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (((JList)listSelectionEvent.getSource()).isSelectionEmpty() || ((JList)listSelectionEvent.getSource()).getValueIsAdjusting()) {
                    return;
                }
                try {
                    DataAnalyser.this.processSelections();
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
            }
        });
        this.variables.setSelectedIndex(0);
        this.variables.setSelectionMode(2);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        this.display = new DistributionDisplay();
        DataAnalyserModel.DataHolder dataHolder = (DataAnalyserModel.DataHolder)this.variables.getSelectedValue();
        this.display.setDataHolder(dataHolder, false);
        jPanel3.add(new JScrollPane(this.display){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.height = Math.max(Math.min(dimension.height, 400), 100);
                return dimension;
            }
        });
        jPanel3.add((Component)jPanel2, "South");
        this.showDataInfo(dataHolder, this.dataInfoLabels);
        jPanel.add(jPanel3);
        this.selectAllButton = new JButton(HuginGUIConstants.get("DATAANALYSER_Select_All_Numerical"));
        this.selectAllButton.setToolTipText(HuginGUIConstants.get("DATAANALYSER_Select_All_Numerical"));
        this.selectAllButton.setEnabled(true);
        this.selectAllButton.addActionListener(new SelectAllListener());
        JPanel jPanel4 = new JPanel(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.variables);
        jScrollPane.setPreferredSize(new Dimension(250, 100));
        jPanel4.add((Component)jScrollPane, "Center");
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add((Component)this.selectAllButton, "West");
        jPanel4.add((Component)jPanel5, "South");
        jPanel.add((Component)jPanel4, "North");
        jPanel.add((Component)this.createButtons(), "South");
        return jPanel;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.height = Math.max(Math.min(dimension.height, 400), 275);
        return dimension;
    }

    private void showDiscretizerFor(DataAnalyserModel.DataHolder dataHolder) throws Exception {
        try {
            if (dataHolder.isNumerical() && dataHolder.getNames().length > 1) {
                this.discretizer.setDataHolder(dataHolder);
                this.discretizer.pack();
                HuginGUIUtils.placeNextTo(this, this.discretizer);
                if (!this.discretizer.isVisible()) {
                    this.discretizer.setVisible(true);
                }
            }
            if (!dataHolder.isNumerical() || dataHolder.getNames().length <= 1) {
                this.discretizer.setVisible(false);
            }
            this.setVisible(true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            new HuginGUIError(illegalArgumentException.getMessage());
            dataHolder.setIntervals(null, true);
            dataHolder.setIntervals(null, false);
            this.discretizer.setDataHolder(dataHolder);
            this.discretizer.pack();
            HuginGUIUtils.placeNextTo(this, this.discretizer);
            this.discretizer.setVisible(true);
        }
    }

    private void showDiscretizerFor(DataAnalyserModel.DataHolder[] dataHolderArray) throws Exception {
        if (this.containsNumerical(dataHolderArray)) {
            this.discretizer.setDataHolders(dataHolderArray);
            this.discretizer.pack();
            HuginGUIUtils.placeNextTo(this, this.discretizer);
            this.discretizer.setVisible(true);
        }
        if (!this.containsNumerical(dataHolderArray)) {
            this.discretizer.setVisible(false);
        }
        this.setVisible(true);
    }

    private boolean containsNumerical(DataAnalyserModel.DataHolder[] dataHolderArray) {
        if (dataHolderArray.length > 0) {
            for (DataAnalyserModel.DataHolder dataHolder : dataHolderArray) {
                if (dataHolder.isNumerical() && dataHolder.getNames().length > 1) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private JPanel createButtons() {
        JPanel jPanel = new JPanel(new GridLayout(2, 1));
        JPanel jPanel2 = new JPanel(new FlowLayout());
        JPanel jPanel3 = new JPanel(new FlowLayout());
        boolean bl = this.canClear();
        DataAnalyserModel.DataHolder dataHolder = (DataAnalyserModel.DataHolder)this.variables.getSelectedValue();
        boolean bl2 = dataHolder.isNumerical() && dataHolder.getNames().length > 1 && !dataHolder.applyIntervals();
        this.clear = new JButton(HuginGUIConstants.get("clear_button"));
        this.clear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataAnalyserModel.DataHolder[] dataHolderArray;
                DataAnalyser.this.display.clear();
                for (DataAnalyserModel.DataHolder dataHolder : dataHolderArray = DataAnalyser.this.getSelectedVariables()) {
                    dataHolder.applyIntervals(false);
                }
                DataAnalyser.this.clear.setEnabled(false);
                DataAnalyser.this.apply.setEnabled(true);
                DataAnalyser.this.updateVariables();
                DataAnalyser.this.display.revalidate();
                DataAnalyser.this.display.repaint();
            }
        });
        this.clear.setEnabled(bl);
        this.clearall = new JButton(HuginGUIConstants.get("str_clear_all"));
        this.clearall.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataAnalyser.this.display.clear();
                for (int i = 0; i < DataAnalyser.this.variables.getModel().getSize(); ++i) {
                    DataAnalyserModel.DataHolder dataHolder = (DataAnalyserModel.DataHolder)DataAnalyser.this.variables.getModel().getElementAt(i);
                    dataHolder.applyIntervals(false);
                }
                DataAnalyser.this.clearall.setEnabled(false);
                DataAnalyser.this.clear.setEnabled(false);
                DataAnalyser.this.apply.setEnabled(true);
                DataAnalyser.this.updateVariables();
                DataAnalyser.this.display.revalidate();
                DataAnalyser.this.display.repaint();
            }
        });
        this.apply = new JButton(HuginGUIConstants.get("APPLY_BUTTON_LABEL"));
        this.apply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataAnalyserModel.DataHolder[] dataHolderArray;
                DataAnalyser.this.display.clear();
                for (DataAnalyserModel.DataHolder dataHolder : dataHolderArray = DataAnalyser.this.getSelectedVariables()) {
                    dataHolder.applyIntervals(true);
                }
                DataAnalyser.this.clear.setEnabled(true);
                DataAnalyser.this.clearall.setEnabled(true);
                DataAnalyser.this.apply.setEnabled(false);
                DataAnalyser.this.updateVariables();
                DataAnalyser.this.display.revalidate();
                DataAnalyser.this.display.repaint();
            }
        });
        this.apply.setEnabled(bl2);
        this.cancel = new JButton(HuginGUIConstants.get("cancel_button"));
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataAnalyser.this.dispose();
            }
        });
        this.ok = new JButton(HuginGUIConstants.get("OK_button"));
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = "";
                DataAnalyserModel.DataHolder[] dataHolderArray = DataAnalyser.this.model.getVariables();
                for (int i = 0; i < dataHolderArray.length; ++i) {
                    try {
                        DiscretizeProcess discretizeProcess = dataHolderArray[i].getDiscretizeProcess();
                        if (discretizeProcess != null) {
                            DataAnalyser.this.stream.addPreProcess(discretizeProcess);
                        } else {
                            DataAnalyser.this.stream.removePreProcess(new DiscretizeProcess(dataHolderArray[i].getName()));
                        }
                        dataHolderArray[i].containsDiscretizingError(false);
                        continue;
                    }
                    catch (Exception exception) {
                        string = string + "\n" + dataHolderArray[i] + ": " + exception.getMessage();
                        dataHolderArray[i].containsDiscretizingError(true);
                    }
                }
                if (string != "") {
                    new HuginGUIError(HuginGUIConstants.get("str_unable_to_add_disc_preprocess_to_ARG0", new String[]{string}));
                    DataAnalyser.this.updateVariables();
                    DataAnalyser.this.validate();
                    DataAnalyser.this.repaint();
                } else {
                    DataAnalyser.this.dispose();
                }
            }
        });
        jPanel2.add(this.clear);
        jPanel2.add(this.clearall);
        jPanel2.add(this.apply);
        jPanel3.add(this.cancel);
        jPanel3.add(this.ok);
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        return jPanel;
    }

    private void clearHolder(DataAnalyserModel.DataHolder dataHolder) {
        this.display.clear();
        dataHolder.applyIntervals(false);
        this.clear.setEnabled(false);
        this.apply.setEnabled(true);
        this.display.revalidate();
        this.display.repaint();
    }

    private void updateVariables() {
        this.variables.validate();
        this.variables.repaint();
    }

    private void processSelections() throws Exception {
        if (this.variables.getSelectedIndices().length > 1) {
            DataAnalyserModel.DataHolder[] dataHolderArray = this.getSelectedVariables();
            this.display.reset();
            this.showDiscretizerFor(dataHolderArray);
            this.showDataInfo(null, this.dataInfoLabels);
            this.clear.setEnabled(this.canClear());
            this.apply.setEnabled(this.containsNumerical(dataHolderArray) && !this.canClear());
        } else {
            DataAnalyserModel.DataHolder dataHolder = (DataAnalyserModel.DataHolder)this.variables.getSelectedValue();
            if (this.display != null && dataHolder != null) {
                this.display.setDataHolder(dataHolder, false);
                this.showDiscretizerFor(dataHolder);
                this.showDataInfo(dataHolder, this.dataInfoLabels);
                this.clear.setEnabled(dataHolder.applyIntervals());
                this.apply.setEnabled(dataHolder.isNumerical() && dataHolder.getNames().length > 1 && !dataHolder.applyIntervals());
            }
        }
    }

    private DataAnalyserModel.DataHolder[] getSelectedVariables() {
        Object[] objectArray = this.variables.getSelectedValues();
        LinkedList<DataAnalyserModel.DataHolder> linkedList = new LinkedList<DataAnalyserModel.DataHolder>();
        int n = 0;
        for (Object object : objectArray) {
            DataAnalyserModel.DataHolder dataHolder = (DataAnalyserModel.DataHolder)objectArray[n];
            if (dataHolder.isNumerical() && dataHolder.getNames().length > 1) {
                linkedList.add(dataHolder);
            }
            ++n;
        }
        DataAnalyserModel.DataHolder[] dataHolderArray = linkedList.toArray(new DataAnalyserModel.DataHolder[0]);
        return dataHolderArray;
    }

    private boolean containsAtLeastOneNumerical(DataAnalyserModel.DataHolder[] dataHolderArray) {
        for (DataAnalyserModel.DataHolder dataHolder : dataHolderArray) {
            if (!dataHolder.isNumerical() || dataHolder.getNames().length <= 1) continue;
            return true;
        }
        return false;
    }

    private boolean canClear() {
        DataAnalyserModel.DataHolder[] dataHolderArray;
        for (DataAnalyserModel.DataHolder dataHolder : dataHolderArray = this.getSelectedVariables()) {
            if (!dataHolder.applyIntervals()) continue;
            return true;
        }
        return false;
    }

    class NumericVariableRenderer
    extends JLabel
    implements ListCellRenderer {
        public NumericVariableRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            DataAnalyserModel.DataHolder dataHolder = (DataAnalyserModel.DataHolder)object;
            String string = object.toString();
            if (dataHolder.isNumerical()) {
                if (dataHolder.containsDiscretizingError()) {
                    this.setText("<HTML><B><FONT COLOR=RED>(n) </FONT></B><FONT COLOR=RED>" + string + "</FONT></HTML>");
                } else {
                    this.setText("<HTML><B><FONT COLOR=RED>(n) </FONT></B><FONT COLOR=BLACK>" + string + "</FONT></HTML>");
                }
            } else {
                this.setText(string);
            }
            this.setOpaque(true);
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            return this;
        }
    }

    class SelectAllListener
    implements ActionListener {
        SelectAllListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = DataAnalyser.this.variables.getModel().getSize();
            ListModel listModel = DataAnalyser.this.variables.getModel();
            LinkedList<Integer> linkedList = new LinkedList<Integer>();
            if (DataAnalyser.this.variables != null && n > 0) {
                boolean bl = false;
                for (int i = 0; i < n; ++i) {
                    DataAnalyserModel.DataHolder dataHolder = (DataAnalyserModel.DataHolder)listModel.getElementAt(i);
                    if (!dataHolder.isNumerical() || dataHolder.getNames().length <= 1) continue;
                    linkedList.add(i);
                }
                n = linkedList.size();
                int[] nArray = new int[n];
                for (int i = 0; i < n; ++i) {
                    nArray[i] = (Integer)linkedList.get(i);
                }
                DataAnalyser.this.variables.setSelectedIndices(nArray);
            }
        }
    }

    protected static class DistributionDisplay
    extends JPanel {
        DistributionDisplayModel model;
        int maxLength = -1;
        private static final int SEPARATOR = 5;
        DataAnalyserModel.DataHolder holder;

        public void setDataHolder(DataAnalyserModel.DataHolder dataHolder, boolean bl) {
            if (dataHolder == null) {
                return;
            }
            this.model = new DistributionDisplayModel(dataHolder, bl);
            this.holder = dataHolder;
            dataHolder.addModelChangedListener(new DataAnalyserModel.ModelChangedListener(){

                public void modelChanged(int n) {
                    try {
                        DistributionDisplay.this.update(n);
                    }
                    catch (Exception exception) {
                        new HuginGUIError(exception);
                    }
                }
            });
            try {
                if (dataHolder.applyIntervals()) {
                    this.update(1);
                    return;
                }
            }
            catch (Exception exception) {
                new HuginGUIError(HuginGUIConstants.get("str_unable_to_apply_existing_intervals_ARG0", new String[]{exception.getMessage()}));
            }
            this.maxLength = -1;
            this.revalidate();
            this.repaint();
        }

        public void setIntervals(double[] dArray) {
            if (this.holder != null) {
                this.holder.setIntervals(dArray, false);
            }
            this.maxLength = -1;
            this.revalidate();
            this.repaint();
        }

        public void update(int n) throws Exception {
            if (this.holder == null) {
                this.reset();
                return;
            }
            this.model.update(n);
            this.maxLength = -1;
            this.revalidate();
            this.repaint();
        }

        public void clear() {
            if (this.holder == null) {
                this.reset();
                return;
            }
            this.model.clear();
            this.maxLength = -1;
            this.revalidate();
            this.repaint();
        }

        public void reset() {
            this.holder = null;
            this.model = null;
            this.maxLength = -1;
            this.repaint();
        }

        public void paintComponent(Graphics graphics) {
            int n;
            if (this.holder == null) {
                super.paintComponent(graphics);
                return;
            }
            if (this.maxLength < 0) {
                for (n = 0; n < this.model.getItemCount(); ++n) {
                    this.maxLength = Math.max(this.maxLength, SwingUtilities.computeStringWidth(graphics.getFontMetrics(graphics.getFont()), this.model.getName(n)));
                }
            }
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            int n2 = this.getWidth() - (this.maxLength + SwingUtilities.computeStringWidth(graphics.getFontMetrics(graphics.getFont()), "" + this.model.getMaxCount())) - 20;
            for (int i = 0; i < this.model.getItemCount(); ++i) {
                graphics.setColor(Color.black);
                graphics.drawString(this.model.getName(i), 5, i * 16 + 14);
                graphics.drawString("" + this.model.getCount(i), this.getWidth() - (5 + SwingUtilities.computeStringWidth(graphics.getFontMetrics(graphics.getFont()), "" + this.model.getCount(i))), i * 16 + 14);
                graphics.setColor(Color.gray);
                n = (int)((float)this.model.getCount(i) / (float)this.model.getMaxCount() * (float)n2);
                graphics.fillRect(this.maxLength + 10 + n2 - n, i * 16 + 2, n, 12);
                graphics.setColor(Color.darkGray);
                n = (int)((float)this.model.getCount(i) / (float)this.model.getMaxCount() * (float)n2);
                graphics.drawRect(this.maxLength + 10 + n2 - n, i * 16 + 2, n, 12);
            }
        }

        public Dimension getPreferredSize() {
            if (this.model == null) {
                return new Dimension(200, 50);
            }
            return new Dimension(200, 16 * this.model.getItemCount());
        }

        private class DistributionDisplayModel {
            String[] names;
            int[] counts;
            int maxCount = 0;
            DataAnalyserModel.DataHolder holder;
            private boolean live = false;
            private double[] internalIntervals = null;

            public DistributionDisplayModel(DataAnalyserModel.DataHolder dataHolder, boolean bl) {
                this.names = dataHolder.getNames();
                this.counts = dataHolder.getCounts();
                this.holder = dataHolder;
                this.maxCount = 0;
                for (int i = 0; i < this.counts.length; ++i) {
                    this.maxCount += this.counts[i];
                }
                this.live = bl;
            }

            public void clear() {
                this.internalIntervals = null;
            }

            public void update(int n) throws Exception {
                Object[] objectArray;
                if (this.holder == null) {
                    return;
                }
                if ((this.live || n == 1 && this.holder.applyIntervals()) && (objectArray = this.holder.getIntervals(this.live)) != null) {
                    this.internalIntervals = new double[objectArray.length];
                    for (int i = 0; i < objectArray.length; ++i) {
                        this.internalIntervals[i] = objectArray[i];
                    }
                }
                if (this.internalIntervals == null) {
                    this.names = this.holder.getNames();
                    this.counts = this.holder.getCounts();
                } else {
                    int n2;
                    this.names = new String[this.internalIntervals.length - 1];
                    for (n2 = 0; n2 < this.names.length; ++n2) {
                        this.names[n2] = HuginGUIUtils.printInterval(this.internalIntervals[n2], this.internalIntervals[n2 + 1]);
                    }
                    this.counts = new int[this.names.length];
                    for (n2 = 0; n2 < this.counts.length; ++n2) {
                        this.counts[n2] = 0;
                    }
                    objectArray = this.holder.getNames();
                    int[] nArray = this.holder.getCounts();
                    int n3 = 0;
                    for (int i = 0; i < objectArray.length; ++i) {
                        double d = Double.parseDouble((String)objectArray[i]);
                        while (d > this.internalIntervals[n3 + 1]) {
                            if (++n3 < this.internalIntervals.length) continue;
                            throw new Exception(HuginGUIConstants.get("str_value_ARG0_exceeds_specified_interval", new String[]{"" + d}));
                        }
                        int n4 = n3;
                        this.counts[n4] = this.counts[n4] + nArray[i];
                    }
                }
                this.maxCount = 0;
                for (int i = 0; i < this.counts.length; ++i) {
                    this.maxCount += this.counts[i];
                }
            }

            public int getMaxCount() {
                return this.maxCount;
            }

            public String getName(int n) {
                return this.names[n];
            }

            public int getCount(int n) {
                return this.counts[n];
            }

            public int getItemCount() {
                if (this.names == null) {
                    return 1;
                }
                return this.names.length;
            }
        }
    }
}

