/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.Class;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HGUI.DependenceSlider;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIEventHandler;
import COM.hugin.HGUI.HuginInsets;
import COM.hugin.HGUI.WizardNetworkPanel;
import COM.hugin.HGUI.WizardPanel;
import COM.hugin.HGUI.ZoomFit;
import COM.hugin.HGUI.ZoomIn;
import COM.hugin.HGUI.ZoomOut;
import COM.hugin.HGUI.ZoomingPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DataDependencesPanel
extends WizardPanel {
    private WizardNetworkPanel networkPanel;
    private JPanel mainPanel;
    private JScrollPane networkScroller;
    private Class homeClass;
    private JToggleButton directedLinksButton;
    private JToggleButton undirectedLinksButton;
    private JToggleButton linkConstraintsButton;
    private JToggleButton noLinkConstraintsButton;
    private JButton printNet;
    private JButton importSettings;
    private JButton viewLog;
    private JButton stretchScaleButton;
    private JButton compressScaleButton;
    private DependenceSlider slider;
    private boolean stretchScaleButtonWasEnabled;
    private boolean compressScaleButtonWasEnabled;
    private boolean constraintButtonsActivated = false;

    public DataDependencesPanel(WizardNetworkPanel wizardNetworkPanel, JButton[] jButtonArray) {
        super("Data Dependences", jButtonArray);
        this.setImage(Toolkit.getDefaultToolkit().createImage(ClassLoader.getSystemResource("images/data_dependences.jpg")));
        this.networkPanel = wizardNetworkPanel;
        wizardNetworkPanel.setDataDependencesPanel(this);
        wizardNetworkPanel.readLinks();
        wizardNetworkPanel.showLinkConstraints(false);
        wizardNetworkPanel.showNoLinkConstraints(false);
        wizardNetworkPanel.deselectNodes();
        wizardNetworkPanel.deselectLink();
        wizardNetworkPanel.createDependenceLinks();
        this.setInterior(this.createInterior());
        this.addComponents();
        this.reportModelSize();
    }

    protected void reportModelSize() {
        this.writeStatus(HuginGUIConstants.get("str_model_size_ARG0", new String[]{"" + this.networkPanel.getModelSize()}));
    }

    protected Domain getDomain() {
        return this.networkPanel.domain;
    }

    protected JScrollPane getNetworkScroller() {
        return this.networkScroller;
    }

    protected WizardNetworkPanel getNetworkPanel() {
        return this.networkPanel;
    }

    protected void setNetworkPanel(WizardNetworkPanel wizardNetworkPanel) {
        this.networkPanel = wizardNetworkPanel;
        wizardNetworkPanel.setDataDependencesPanel(this);
        this.mainPanel.remove(this.networkScroller);
        this.createNetworkScroller();
        this.mainPanel.add((Component)this.networkScroller, "Center");
    }

    public void back() {
        this.networkPanel.deselectLinks();
        try {
            this.networkPanel.clearDependences();
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        this.previous.reInitialize();
    }

    public void rereadNodePositions() throws ExceptionHugin {
        this.networkPanel.rereadNodePositions();
    }

    private void createNetworkScroller() {
        this.networkScroller = new JScrollPane(this.networkPanel);
        this.networkScroller.getHorizontalScrollBar().setUnitIncrement(15);
        this.networkScroller.getVerticalScrollBar().setUnitIncrement(15);
        this.networkScroller.setPreferredSize(new Dimension(200, 200));
        this.networkScroller.getViewport().addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                DataDependencesPanel.this.networkPanel.repaint();
            }
        });
    }

    private Component createInterior() {
        this.mainPanel = new JPanel(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        JToolBar jToolBar = new JToolBar();
        this.createNetworkScroller();
        JTextArea jTextArea = new JTextArea("Use the slider to detect the relative strengths of the dependences (links) found in the data.");
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBackground(this.getBackground());
        this.printNet = new JButton(new HuginGUIEventHandler.MENU_FILE_Print_NetworkAction(this.networkPanel));
        this.printNet.setText("");
        this.printNet.setToolTipText(HuginGUIConstants.get("str_print_network"));
        this.printNet.setMargin(new HuginInsets());
        jToolBar.add(this.printNet);
        this.importSettings = new JButton(new HuginGUIEventHandler.MENU_NETWORK_Import_Model_InformationAction(this.networkPanel));
        this.importSettings.setText("");
        this.importSettings.setToolTipText(HuginGUIConstants.get("MENU_NETWORK_Import_Model_Information_Tip"));
        this.importSettings.setMargin(new HuginInsets());
        jToolBar.add(this.importSettings);
        this.viewLog = new JButton(new HuginGUIEventHandler.WIZARD_LogFileAction(this.getDomain()));
        this.viewLog.setText("");
        this.viewLog.setToolTipText(HuginGUIConstants.get("MENU_VIEW_Information_Tip"));
        this.viewLog.setMargin(new HuginInsets());
        jToolBar.add(this.viewLog);
        jToolBar.addSeparator(new Dimension(10, 0));
        this.directedLinksButton = new JToggleButton();
        this.directedLinksButton.setAction(new ShowResultingLinks());
        this.directedLinksButton.setText("");
        this.directedLinksButton.setToolTipText(HuginGUIConstants.get("str_show_directed_graph"));
        this.directedLinksButton.setMargin(new HuginInsets());
        jToolBar.add(this.directedLinksButton);
        this.directedLinksButton.setSelected(true);
        this.directedLinksButton.setEnabled(false);
        this.undirectedLinksButton = new JToggleButton();
        this.undirectedLinksButton.setAction(new ShowMarginalLinks());
        this.undirectedLinksButton.setText("");
        this.undirectedLinksButton.setToolTipText(HuginGUIConstants.get("str_show_marginal_dependence_graph"));
        this.undirectedLinksButton.setMargin(new HuginInsets());
        jToolBar.add(this.undirectedLinksButton);
        this.undirectedLinksButton.setSelected(false);
        this.directedLinksButton.setEnabled(true);
        jToolBar.addSeparator(new Dimension(10, 0));
        this.linkConstraintsButton = new JToggleButton();
        this.linkConstraintsButton.setAction(new ToggleLinkConstraints());
        this.linkConstraintsButton.setText("");
        this.linkConstraintsButton.setToolTipText(HuginGUIConstants.get("str_toggle_show_link_constraints"));
        this.linkConstraintsButton.setMargin(new HuginInsets());
        jToolBar.add(this.linkConstraintsButton);
        this.linkConstraintsButton.setSelected(false);
        this.linkConstraintsButton.setEnabled(this.networkPanel.containsLinkConstraints());
        this.noLinkConstraintsButton = new JToggleButton();
        this.noLinkConstraintsButton.setAction(new ToggleNoLinkConstraints());
        this.noLinkConstraintsButton.setText("");
        this.noLinkConstraintsButton.setToolTipText(HuginGUIConstants.get("str_toggle_show_no_link_constraints"));
        this.noLinkConstraintsButton.setMargin(new HuginInsets());
        jToolBar.add(this.noLinkConstraintsButton);
        this.noLinkConstraintsButton.setSelected(false);
        this.noLinkConstraintsButton.setEnabled(this.networkPanel.containsNoLinkConstraints());
        jToolBar.addSeparator(new Dimension(10, 0));
        JButton jButton = new JButton();
        jButton.setAction(new ZoomIn(this, this.networkPanel));
        jButton.setText("");
        jButton.setToolTipText(HuginGUIConstants.get("str_zoom_in_by_ten_percent"));
        jButton.setMargin(new HuginInsets());
        jToolBar.add(jButton);
        jButton = new JButton();
        jButton.setAction(new ZoomOut(this, this.networkPanel));
        jButton.setText("");
        jButton.setToolTipText(HuginGUIConstants.get("str_zoom_out_by_ten_percent"));
        jButton.setMargin(new HuginInsets());
        jToolBar.add(jButton);
        jButton = new JButton();
        jButton.setAction(new ZoomFit(this, this.networkPanel));
        jButton.setText("");
        jButton.setToolTipText(HuginGUIConstants.get("str_zoom_to_fit"));
        jButton.setMargin(new HuginInsets());
        jToolBar.add(jButton);
        jToolBar.addSeparator(new Dimension(10, 0));
        double d = this.networkPanel.getMinIndependence();
        this.stretchScaleButton = new JButton();
        this.stretchScaleButton.setAction(new StretchScale());
        this.stretchScaleButton.setText("");
        this.stretchScaleButton.setToolTipText(HuginGUIConstants.get("str_stretch_slider_scale"));
        this.stretchScaleButton.setMargin(new HuginInsets());
        jToolBar.add(this.stretchScaleButton);
        this.stretchScaleButtonWasEnabled = d < 1.0E-10;
        this.stretchScaleButton.setEnabled(this.stretchScaleButtonWasEnabled);
        this.compressScaleButton = new JButton();
        this.compressScaleButton.setAction(new CompressScale());
        this.compressScaleButton.setText("");
        this.compressScaleButton.setToolTipText(HuginGUIConstants.get("str_compress_slider_scale"));
        this.compressScaleButton.setMargin(new HuginInsets());
        jToolBar.add(this.compressScaleButton);
        this.compressScaleButtonWasEnabled = d < 1.0E-50;
        this.compressScaleButton.setEnabled(this.compressScaleButtonWasEnabled);
        jToolBar.setFloatable(false);
        this.slider = new DependenceSlider(this, d, this.networkPanel.getSignificanceLevel());
        this.slider.getSlider().addChangeListener(new DependencesChangeListener());
        this.slider.setEnabled(true);
        jPanel.add((Component)jTextArea, "Center");
        jPanel.add((Component)jToolBar, "South");
        this.mainPanel.add((Component)jPanel, "North");
        this.mainPanel.add((Component)this.networkScroller, "Center");
        this.mainPanel.add((Component)this.slider, "East");
        return this.mainPanel;
    }

    private void writeIndependenceThreshold(double d) {
        double d2 = this.networkPanel.getSignificanceLevel();
        boolean bl = this.directedLinksButton.isSelected() && d > d2;
        String string = bl ? HuginGUIConstants.get("str_nb_only_forced_links_added") + this.formatDouble(d2) + HuginGUIConstants.get("str_close_parentheses") : "";
        this.writeStatus("Threshold = " + this.formatDouble(d) + string);
    }

    protected void writePValue(double d) {
        this.writeStatus(HuginGUIConstants.get("str_p_value_equals") + this.formatDouble(d));
    }

    private String formatDouble(double d) {
        try {
            DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance();
            DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
            decimalFormatSymbols.setDecimalSeparator('.');
            decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
            decimalFormat.setGroupingUsed(false);
            if (Math.abs(d) >= 1.0E-4) {
                decimalFormat.setMaximumFractionDigits(4);
            } else {
                decimalFormat.applyPattern("0E0");
            }
            return decimalFormat.format(d);
        }
        catch (NumberFormatException numberFormatException) {
            return "0.0";
        }
    }

    protected void readSlider() {
        double d = this.slider.getValue();
        boolean bl = this.directedLinksButton.isSelected();
        this.networkPanel.setThreshold(d, bl);
        this.writeIndependenceThreshold(d);
    }

    private void setSliderState() {
        boolean bl = !this.linkConstraintsButton.isSelected() && !this.noLinkConstraintsButton.isSelected();
        this.slider.setEnabled(bl);
        if (!bl && !this.constraintButtonsActivated) {
            this.stretchScaleButtonWasEnabled = this.stretchScaleButton.isEnabled();
            this.compressScaleButtonWasEnabled = this.compressScaleButton.isEnabled();
            this.constraintButtonsActivated = true;
        }
        if (bl && this.constraintButtonsActivated) {
            this.constraintButtonsActivated = false;
        }
        if (this.stretchScaleButtonWasEnabled) {
            this.stretchScaleButton.setEnabled(bl);
        }
        if (this.compressScaleButtonWasEnabled) {
            this.compressScaleButton.setEnabled(bl);
        }
    }

    protected void enableCompressButton(boolean bl) {
        this.compressScaleButton.setEnabled(bl);
    }

    protected void enableStretchButton(boolean bl) {
        this.stretchScaleButton.setEnabled(bl);
    }

    protected void receiveKeyEvent(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        try {
            double d;
            if ((n == 40 || n == 98) && keyEvent.isControlDown()) {
                d = this.networkPanel.zoom(0.9);
                if (d > 0.0) {
                    this.writeStatus(HuginGUIConstants.get("str_scale_factor_set_to_ARG0_percent", new String[]{"" + (int)(100.0 * d)}));
                } else {
                    this.writeStatus("Unable to scale network (1 <= scale factor <= 10000)");
                }
            }
            if ((n == 38 || n == 104) && keyEvent.isControlDown()) {
                d = this.networkPanel.zoom(1.1111111111111112);
                if (d > 0.0) {
                    this.writeStatus(HuginGUIConstants.get("str_scale_factor_set_to_ARG0_percent", new String[]{"" + (int)(100.0 * d)}));
                } else {
                    this.writeStatus("Unable to scale network (1 <= scale factor <= 10000)");
                }
            }
            switch (n) {
                case 65: {
                    this.networkPanel.selectAllNodes();
                    if (this.networkPanel.selectedNodes.size() == 1) {
                        this.writeStatus(HuginGUIConstants.get("str_node_selected"));
                        break;
                    }
                    this.writeStatus(HuginGUIConstants.get("str_all_ARG0_nodes_selected", new String[]{"" + this.networkPanel.selectedNodes.size()}));
                    break;
                }
                case 36: {
                    double d2 = 0.0;
                    if (keyEvent.isControlDown()) {
                        d2 = 1.0;
                        this.networkPanel.setScaleFactor(1.0);
                    }
                    if (keyEvent.isShiftDown()) {
                        d2 = ZoomingPane.computeFitFactor(this.networkPanel);
                        this.networkPanel.setScaleFactor(d2);
                    }
                    if (!(d2 > 0.0)) break;
                    this.writeStatus(HuginGUIConstants.get("str_scale_factor_set_to_ARG0_percent", new String[]{"" + (int)Math.rint(100.0 * d2)}));
                    break;
                }
                case 46: {
                    if (!keyEvent.isControlDown()) break;
                    this.networkPanel.showGrid(!this.networkPanel.showGrid());
                    this.writeStatus(this.networkPanel.showGrid() ? HuginGUIConstants.get("str_grid_on") : HuginGUIConstants.get("str_grid_off"));
                    break;
                }
                case 44: {
                    if (keyEvent.isControlDown()) {
                        this.networkPanel.snapToGrid(!this.networkPanel.snapToGrid());
                        this.writeStatus(this.networkPanel.snapToGrid() ? HuginGUIConstants.get("str_snap_to_grid_on") : HuginGUIConstants.get("str_snap_to_grid_off"));
                    }
                    if (!keyEvent.isShiftDown() || !this.networkPanel.snapSelectedNodesToGrid()) break;
                    this.writeStatus(HuginGUIConstants.get("str_selected_nodes_snapped_to_grid"));
                    break;
                }
                case 35: {
                    if (!keyEvent.isShiftDown()) break;
                    this.networkPanel.setScaleFactor((double)ZoomingPane.computeSelectedFitZoom(this.networkPanel) / 100.0);
                    this.networkPanel.scrollToSelected();
                    this.writeStatus(HuginGUIConstants.get("str_zoomed_to_selected_nodes"));
                }
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    private class CompressScale
    extends AbstractAction {
        public CompressScale() {
            super("Compress dependence scale button", new ImageIcon(ClassLoader.getSystemResource("icons/compress-scale.gif")));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DataDependencesPanel.this.compressScaleButton.setEnabled(DataDependencesPanel.this.slider.compressScale());
            DataDependencesPanel.this.stretchScaleButton.setEnabled(true);
            DataDependencesPanel.this.writeStatus("Slider scale compressed by a factor of 1.0E10");
        }
    }

    private class StretchScale
    extends AbstractAction {
        public StretchScale() {
            super("Stretch dependence scale button", new ImageIcon(ClassLoader.getSystemResource("icons/stretch-scale.gif")));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DataDependencesPanel.this.stretchScaleButton.setEnabled(DataDependencesPanel.this.slider.stretchScale());
            DataDependencesPanel.this.compressScaleButton.setEnabled(true);
            DataDependencesPanel.this.writeStatus("Slider scale stretched by a factor of 1.0E10");
        }
    }

    private class ToggleNoLinkConstraints
    extends AbstractAction {
        public ToggleNoLinkConstraints() {
            super("No link constraints button", new ImageIcon(ClassLoader.getSystemResource("icons/no-constraint-link.gif")));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DataDependencesPanel.this.networkPanel.showNoLinkConstraints(DataDependencesPanel.this.noLinkConstraintsButton.isSelected());
            DataDependencesPanel.this.setSliderState();
            DataDependencesPanel.this.writeStatus("Links forced to be absent " + (DataDependencesPanel.this.noLinkConstraintsButton.isSelected() ? "shown." : "hidden."));
        }
    }

    private class ToggleLinkConstraints
    extends AbstractAction {
        public ToggleLinkConstraints() {
            super("Link constraints button", new ImageIcon(ClassLoader.getSystemResource("icons/constraint-link.gif")));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DataDependencesPanel.this.networkPanel.showLinkConstraints(DataDependencesPanel.this.linkConstraintsButton.isSelected());
            DataDependencesPanel.this.setSliderState();
            DataDependencesPanel.this.writeStatus("Links forced to be present " + (DataDependencesPanel.this.linkConstraintsButton.isSelected() ? "shown." : "hidden."));
        }
    }

    private class ShowMarginalLinks
    extends AbstractAction {
        public ShowMarginalLinks() {
            super("Marginal links button", new ImageIcon(ClassLoader.getSystemResource("icons/undir-link.gif")));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DataDependencesPanel.this.networkPanel.showResultingLinks(false);
            DataDependencesPanel.this.networkPanel.showMarginalLinks(true);
            DataDependencesPanel.this.undirectedLinksButton.setSelected(true);
            DataDependencesPanel.this.undirectedLinksButton.setEnabled(false);
            DataDependencesPanel.this.directedLinksButton.setSelected(false);
            DataDependencesPanel.this.directedLinksButton.setEnabled(true);
            DataDependencesPanel.this.writeStatus("Marginal dependence graph shown.");
        }
    }

    private class ShowResultingLinks
    extends AbstractAction {
        public ShowResultingLinks() {
            super("Resulting links button", new ImageIcon(ClassLoader.getSystemResource("icons/dir-link.gif")));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DataDependencesPanel.this.networkPanel.showMarginalLinks(false);
            DataDependencesPanel.this.networkPanel.showResultingLinks(true);
            DataDependencesPanel.this.directedLinksButton.setSelected(true);
            DataDependencesPanel.this.directedLinksButton.setEnabled(false);
            DataDependencesPanel.this.undirectedLinksButton.setSelected(false);
            DataDependencesPanel.this.undirectedLinksButton.setEnabled(true);
            DataDependencesPanel.this.writeStatus("Directed graph shown.");
        }
    }

    private class DependencesChangeListener
    implements ChangeListener {
        private DependencesChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            DataDependencesPanel.this.readSlider();
        }
    }
}

