/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HGUI.AutoIntervalDialog;
import COM.hugin.HGUI.Case;
import COM.hugin.HGUI.DataAnalyser;
import COM.hugin.HGUI.DataSourceException;
import COM.hugin.HGUI.DataStream;
import COM.hugin.HGUI.DataStreamViewer;
import COM.hugin.HGUI.DiscretizeProcess;
import COM.hugin.HGUI.ExcludeProcess;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginFileLoader;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.IEMDiscretizer;
import COM.hugin.HGUI.InvalidDataSourceException;
import COM.hugin.HGUI.InvalidDiscretizationException;
import COM.hugin.HGUI.NoDataSourceException;
import COM.hugin.HGUI.NumberField;
import COM.hugin.HGUI.PreProcess;
import COM.hugin.HGUI.PreProcessingException;
import COM.hugin.HGUI.Preferences;
import COM.hugin.HGUI.ReplaceProcess;
import COM.hugin.HGUI.StreamData;
import COM.hugin.HGUI.TitledPanel;
import COM.hugin.HGUI.Variable;
import COM.hugin.HGUI.WizardError;
import COM.hugin.HGUI.WizardPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.PrintStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.JTextComponent;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataPreprocessingPanel
extends WizardPanel {
    int nextButtonIndex;
    JButton includeAll;
    JButton excludeAll;
    JButton relabel;
    JButton previewData;
    JButton analyseData;
    JButton saveData;
    JButton databaseSave;
    String driverdir = "";
    Preferences prefs;
    boolean existingDomain;
    WizardPanel previous = null;
    DataStream dataStream;
    DataStreamViewer viewer = null;
    JScrollPane tableScroll;
    int loadedTotally = 0;
    String[][] variableNameMap;
    String[] preprocessNames = new String[]{"Value Replace", "Discretize", HuginGUIConstants.get("str_external_plug_ins")};
    JPanel[] preprocessPanels;
    StreamData streamData;
    JScrollPane scrollCheckVariables;
    CheckVariable[] checkVariable;
    JPanel checkBoxes;
    VariableComboBox variable;
    VariableComboBoxModel variableModel;
    JComboBox preprocesses;
    JPanel processInfo;
    JCheckBox useReplace;
    JTable replace;
    ReplaceTableModel replaceModel;
    JButton addReplace;
    JButton removeReplace;
    JTextField replaceFromValue;
    JTextField replaceToValue;
    JLabel replaceFromLabel;
    JLabel replaceToLabel;
    JCheckBox useIntervals;
    JTable intervals;
    IntervalTableModel tableModel;
    JButton addInterval;
    JButton removeInterval;
    JButton autoInterval;
    JButton IEMDiscretize;
    NumberField fromValue;
    NumberField toValue;
    JLabel fromLabel;
    JLabel toLabel;
    JComboBox plugins;
    String pluginDir = "plugins";
    JList processList;
    JButton removeExternal;
    private LinkedList<Component> disabledComponents = null;
    private static DecimalFormat formatter = new DecimalFormat();
    private static DecimalFormat scientificFormat = new DecimalFormat("0.###E0");

    public DataPreprocessingPanel(JButton[] jButtonArray, int n, boolean bl) {
        super("Data Preprocessing");
        this.buttons = jButtonArray;
        this.existingDomain = false;
        this.nextButtonIndex = n;
        this.preprocessPanels = new JPanel[this.preprocessNames.length];
        this.preprocessPanels[0] = this.getValueReplacePanel();
        this.preprocessPanels[1] = this.getDiscretizePanel();
        this.preprocessPanels[2] = this.getExternalPluginPanel();
        this.interior = this.createInterior(bl);
        this.setImage(Toolkit.getDefaultToolkit().createImage(ClassLoader.getSystemResource("images/data_preprocessing.jpg")));
        this.addComponents();
    }

    public DataPreprocessingPanel(JButton[] jButtonArray, int n, boolean bl, boolean bl2) {
        super("Data Preprocessing");
        this.buttons = jButtonArray;
        this.existingDomain = bl2;
        this.nextButtonIndex = n;
        this.preprocessPanels = new JPanel[this.preprocessNames.length];
        this.preprocessPanels[0] = this.getValueReplacePanel();
        this.preprocessPanels[1] = this.getDiscretizePanel();
        this.preprocessPanels[2] = this.getExternalPluginPanel();
        this.interior = this.createInterior(bl);
        this.setImage(Toolkit.getDefaultToolkit().createImage(ClassLoader.getSystemResource("images/data_preprocessing.jpg")));
        this.addComponents();
        this.setEnableLearningComponents(!bl2);
    }

    private Component createInterior(boolean bl) {
        JPanel jPanel = new JPanel(new BorderLayout(5, 10));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JTextArea jTextArea = new JTextArea("Select which variables to include in the dataset");
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setEditable(false);
        jTextArea.setBackground(jPanel2.getBackground());
        JPanel jPanel3 = new JPanel(new GridLayout(3, 1));
        JPanel jPanel4 = new JPanel(new BorderLayout());
        this.includeAll = new JButton("Include All");
        this.includeAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                for (int i = 0; i < DataPreprocessingPanel.this.checkVariable.length; ++i) {
                    DataPreprocessingPanel.this.checkVariable[i].silentSelect(true);
                }
                DataPreprocessingPanel.this.variableModel.enableAll();
                if (DataPreprocessingPanel.this.variableModel.getSelectedItem() == null && DataPreprocessingPanel.this.variableModel.getSize() > 0) {
                    DataPreprocessingPanel.this.variable.setSelectedIndex(0);
                }
                DataPreprocessingPanel.this.buttons[DataPreprocessingPanel.this.nextButtonIndex].setEnabled(true);
                DataPreprocessingPanel.this.writeStatus(HuginGUIConstants.get("str_included_all_variables"));
            }
        });
        this.excludeAll = new JButton("Exclude All");
        this.excludeAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                for (int i = 0; i < DataPreprocessingPanel.this.checkVariable.length; ++i) {
                    DataPreprocessingPanel.this.checkVariable[i].silentSelect(false);
                }
                DataPreprocessingPanel.this.variableModel.disableAll();
                DataPreprocessingPanel.this.buttons[DataPreprocessingPanel.this.nextButtonIndex].setEnabled(false);
                DataPreprocessingPanel.this.previewData.setEnabled(false);
                DataPreprocessingPanel.this.writeStatus(HuginGUIConstants.get("str_excluded_all_variables"));
            }
        });
        this.relabel = new JButton("Label Variables");
        this.relabel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialog jDialog = (JDialog)DataPreprocessingPanel.this.getTopLevelAncestor();
                VariableRelabellingPane variableRelabellingPane = new VariableRelabellingPane(DataPreprocessingPanel.this.variableNameMap, jDialog);
                variableRelabellingPane.pack();
                variableRelabellingPane.setLocation((int)jDialog.getLocation().getX() + (jDialog.getWidth() - variableRelabellingPane.getWidth()) / 2, (int)jDialog.getLocation().getY() + (jDialog.getHeight() - variableRelabellingPane.getHeight()) / 2);
                try {
                    if (variableRelabellingPane.relabelled()) {
                        int n;
                        DataPreprocessingPanel.this.dataStream.getCaseTemplate().relabelVariables(DataPreprocessingPanel.this.variableNameMap);
                        CheckVariable[] checkVariableArray = new CheckVariable[DataPreprocessingPanel.this.variableNameMap.length];
                        DataPreprocessingPanel.this.checkBoxes.removeAll();
                        String[] stringArray = new String[DataPreprocessingPanel.this.variableNameMap.length];
                        for (n = 0; n < DataPreprocessingPanel.this.variableNameMap.length; ++n) {
                            stringArray[n] = DataPreprocessingPanel.this.variableNameMap[n][1];
                            if (stringArray[n] == null || stringArray[n].trim().length() == 0) {
                                stringArray[n] = DataPreprocessingPanel.this.variableNameMap[n][0];
                            }
                            checkVariableArray[n] = new CheckVariable(stringArray[n], n);
                            DataPreprocessingPanel.this.checkBoxes.add(checkVariableArray[n]);
                        }
                        DataPreprocessingPanel.this.variableModel = new VariableComboBoxModel(DataPreprocessingPanel.this.variableNameMap);
                        n = DataPreprocessingPanel.this.variable.getSelectedIndex();
                        DataPreprocessingPanel.this.variable.setModel(DataPreprocessingPanel.this.variableModel);
                        DataPreprocessingPanel.this.variable.setSelectedIndex(n);
                        DataPreprocessingPanel.this.revalidate();
                        DataPreprocessingPanel.this.repaint();
                        DataPreprocessingPanel.this.writeStatus(HuginGUIConstants.get("str_relabelled_variables"));
                    }
                }
                catch (Exception exception) {
                    new HuginGUIError(exception.getMessage());
                }
            }
        });
        jPanel3.add(this.includeAll);
        jPanel3.add(this.excludeAll);
        jPanel3.add(this.relabel);
        jPanel4.add((Component)jPanel3, "North");
        this.scrollCheckVariables = new JScrollPane();
        this.scrollCheckVariables.setPreferredSize(new Dimension(300, 80));
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jTextArea, "North");
        jPanel2.add(this.scrollCheckVariables);
        jPanel2.add((Component)jPanel4, "East");
        JPanel jPanel6 = new JPanel(new BorderLayout());
        JPanel jPanel7 = new JPanel(new FlowLayout(0));
        this.analyseData = new JButton("Analyse");
        this.analyseData.setEnabled(bl);
        this.analyseData.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!DataPreprocessingPanel.this.variableModel.hasEnabledVariables()) {
                    JOptionPane.showMessageDialog(Hugin.mainFrame, HuginGUIConstants.get("LW_Msg_No_Variables"), HuginGUIConstants.get("str_message"), -1);
                    return;
                }
                DataAnalyser dataAnalyser = new DataAnalyser((JDialog)DataPreprocessingPanel.this.getTopLevelAncestor(), DataPreprocessingPanel.this.dataStream);
                dataAnalyser.pack();
                HuginGUIUtils.centerComponent(DataPreprocessingPanel.this, (Window)dataAnalyser);
                dataAnalyser.setVisible(true);
                DataPreprocessingPanel.this.updateProcessesForSelected();
            }
        });
        jPanel7.add(this.analyseData);
        JTextArea jTextArea2 = new JTextArea("Analyse the data with respect to the distribution of the states, and perform discretization of numerical data.");
        jTextArea2.setLineWrap(true);
        jTextArea2.setWrapStyleWord(true);
        jTextArea2.setEditable(false);
        jTextArea2.setBackground(jPanel6.getBackground());
        jPanel6.add(jTextArea2);
        jPanel6.add((Component)jPanel7, "South");
        jPanel2.add((Component)jPanel6, "South");
        JPanel jPanel8 = new JPanel(new BorderLayout());
        JPanel jPanel9 = new JPanel(new GridLayout(2, 1));
        JLabel jLabel = new JLabel("Variable");
        this.variable = new VariableComboBox();
        this.variable.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                DataPreprocessingPanel.this.updateProcessesForSelected();
            }
        });
        jPanel9.add(jLabel);
        jPanel9.add(this.variable);
        JTextArea jTextArea3 = new JTextArea("Define preprocess(es) for each variable");
        jTextArea3.setLineWrap(true);
        jTextArea3.setWrapStyleWord(true);
        jTextArea3.setEditable(false);
        jTextArea3.setBackground(jPanel2.getBackground());
        jPanel8.add((Component)jTextArea3, "North");
        JPanel jPanel10 = new JPanel(new GridLayout(2, 1));
        JLabel jLabel2 = new JLabel("Preprocess type");
        this.preprocesses = new JComboBox<String>(this.preprocessNames);
        this.preprocesses.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                DataPreprocessingPanel.this.processInfo.invalidate();
                DataPreprocessingPanel.this.processInfo.removeAll();
                DataPreprocessingPanel.this.processInfo.add((Component)DataPreprocessingPanel.this.preprocessPanels[DataPreprocessingPanel.this.preprocesses.getSelectedIndex()], "North");
                DataPreprocessingPanel.this.validate();
                DataPreprocessingPanel.this.repaint();
            }
        });
        jPanel10.add(jLabel2);
        jPanel10.add(this.preprocesses);
        JPanel jPanel11 = new JPanel(new BorderLayout(10, 0));
        jPanel11.add((Component)jPanel8, "North");
        jPanel11.add((Component)jPanel9, "West");
        jPanel11.add(jPanel10);
        this.processInfo = new JPanel(new BorderLayout());
        JPanel jPanel12 = this.preprocessPanels[this.preprocesses.getSelectedIndex()];
        this.processInfo.add((Component)jPanel12, "North");
        jPanel5.add((Component)jPanel11, "North");
        jPanel5.add(this.processInfo);
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout(new BoxLayout(jPanel13, 0));
        this.previewData = new JButton("Preview Data");
        this.previewData.addActionListener(new PreviewListener());
        this.saveData = new JButton("Save Data");
        this.saveData.addActionListener(new SaveListener());
        JButton jButton = new JButton("Save process");
        jButton.addActionListener(new SavePreprocessListener());
        JButton jButton2 = new JButton("Load process");
        jButton2.addActionListener(new LoadPreprocessListener());
        jPanel13.add(jButton);
        jPanel13.add(jButton2);
        jPanel13.add(new JLabel(" "));
        jPanel13.add(this.saveData);
        jPanel13.add(this.previewData);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add(jPanel5);
        jPanel.add((Component)jPanel13, "South");
        return jPanel;
    }

    private void updateProcessesForSelected() {
        String string = this.variable.getSelectedName();
        Vector<PreProcess> vector = null;
        if (string != null) {
            vector = this.dataStream.getProcessesForVariable(string);
        }
        this.updateValueReplacePanel(vector);
        this.updateDiscretizePanel(vector);
        this.updateExternalPreprocessPanel(vector);
        this.repaint();
    }

    private TitledPanel getValueReplacePanel() {
        TitledPanel titledPanel = new TitledPanel("Value Replace");
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        this.useReplace = new JCheckBox();
        this.useReplace.addActionListener(new UseReplaceListener());
        this.useReplace.setSelected(true);
        jPanel.add((Component)this.useReplace, "West");
        jPanel.add(new JLabel("Use Replacing"));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.replaceModel = new ReplaceTableModel();
        this.replace = new JTable(this.replaceModel){

            public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
                if (n >= this.getRowCount() || n2 >= this.getColumnCount()) {
                    this.transferFocus();
                    return;
                }
                super.changeSelection(n, n2, bl, bl2);
                DataPreprocessingPanel.this.replaceFromValue.setText("" + this.getValueAt(n, 0));
                DataPreprocessingPanel.this.replaceToValue.setText("" + this.getValueAt(n, 1));
                DataPreprocessingPanel.this.removeReplace.setEnabled(n >= 0);
            }
        };
        this.replace.setEnabled(this.useReplace.isSelected());
        this.replace.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.replace);
        jScrollPane.setPreferredSize(new Dimension(50, 70));
        JPanel jPanel3 = new JPanel(new GridLayout(2, 2));
        InputReplaceListener inputReplaceListener = new InputReplaceListener();
        this.replaceFromValue = new JTextField();
        this.replaceFromValue.setEnabled(this.useReplace.isSelected());
        this.replaceFromValue.addKeyListener(inputReplaceListener);
        this.replaceToValue = new JTextField();
        this.replaceToValue.setEnabled(this.useReplace.isSelected());
        this.replaceToValue.addKeyListener(inputReplaceListener);
        this.replaceFromLabel = new JLabel("From");
        this.replaceFromLabel.setEnabled(this.useReplace.isSelected());
        this.replaceToLabel = new JLabel("To");
        this.replaceToLabel.setEnabled(this.useReplace.isSelected());
        jPanel3.add(this.replaceFromLabel);
        jPanel3.add(this.replaceToLabel);
        jPanel3.add(this.replaceFromValue);
        jPanel3.add(this.replaceToValue);
        jPanel2.add((Component)jPanel3, "North");
        jPanel2.add(jScrollPane);
        JPanel jPanel4 = new JPanel(new GridLayout(2, 1));
        this.addReplace = new JButton("Add");
        this.addReplace.addActionListener(new AddReplaceListener());
        this.addReplace.setEnabled(false);
        this.removeReplace = new JButton("Remove");
        this.removeReplace.addActionListener(new RemoveReplaceListener());
        this.removeReplace.setEnabled(false);
        jPanel4.add(this.addReplace);
        jPanel4.add(this.removeReplace);
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add((Component)jPanel4, "North");
        titledPanel.setLayout(new BorderLayout(5, 5));
        titledPanel.add(jPanel2);
        titledPanel.add((Component)jPanel5, "East");
        return titledPanel;
    }

    private void updateValueReplacePanel(Vector<PreProcess> vector) {
        int n = 0;
        ReplaceProcess replaceProcess = null;
        this.replaceModel.clear();
        if (vector == null) {
            this.replaceFromValue.setEnabled(false);
            this.replaceFromValue.setText("");
            this.replaceFromLabel.setEnabled(false);
            this.replaceToValue.setEnabled(false);
            this.replaceToValue.setText("");
            this.replaceToLabel.setEnabled(false);
            this.addReplace.setEnabled(false);
            this.removeReplace.setEnabled(false);
            return;
        }
        while (n < vector.size()) {
            PreProcess preProcess;
            if (!((preProcess = vector.get(n++)) instanceof ReplaceProcess)) continue;
            replaceProcess = (ReplaceProcess)preProcess;
            this.replaceModel.insertReplace(replaceProcess.getReplaceFrom(), replaceProcess.getReplaceTo());
        }
        this.replaceFromValue.setEnabled(true);
        this.replaceFromLabel.setEnabled(true);
        this.replaceToValue.setEnabled(true);
        this.replaceToLabel.setEnabled(true);
        this.addReplace.setEnabled(false);
        this.removeReplace.setEnabled(false);
        if (this.replace.getSelectedRow() < 0) {
            this.replaceFromValue.setText("");
            this.replaceToValue.setText("");
        } else {
            this.replaceFromValue.setText("" + this.replace.getValueAt(0, this.replace.getSelectedRow()));
            this.replaceToValue.setText("" + this.replace.getValueAt(1, this.replace.getSelectedRow()));
        }
    }

    private TitledPanel getDiscretizePanel() {
        TitledPanel titledPanel = new TitledPanel("Discretize");
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        this.useIntervals = new JCheckBox();
        this.useIntervals.addActionListener(new UseIntervalListener());
        this.useIntervals.setSelected(true);
        jPanel.add((Component)this.useIntervals, "West");
        jPanel.add(new JLabel("Use intervals"));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.tableModel = new IntervalTableModel();
        this.intervals = new JTable(this.tableModel){

            public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
                super.changeSelection(n, n2, bl, bl2);
                DataPreprocessingPanel.this.fromValue.setText("" + this.getValueAt(n, 0));
                DataPreprocessingPanel.this.toValue.setText("" + this.getValueAt(n, 1));
                DataPreprocessingPanel.this.removeInterval.setEnabled(n >= 0);
            }
        };
        this.intervals.setEnabled(this.useIntervals.isSelected());
        this.intervals.setSelectionMode(0);
        this.intervals.setDefaultRenderer(Object.class, new PrettyNumberPrinter());
        JScrollPane jScrollPane = new JScrollPane(this.intervals);
        jScrollPane.setPreferredSize(new Dimension(50, 70));
        JPanel jPanel3 = new JPanel(new GridLayout(2, 2));
        InputIntervalListener inputIntervalListener = new InputIntervalListener();
        this.fromValue = new NumberField();
        this.fromValue.setEnabled(this.useIntervals.isSelected());
        this.fromValue.addKeyListener(inputIntervalListener);
        this.toValue = new NumberField();
        this.toValue.setEnabled(this.useIntervals.isSelected());
        this.toValue.addKeyListener(inputIntervalListener);
        this.fromLabel = new JLabel("From");
        this.fromLabel.setEnabled(this.useIntervals.isSelected());
        this.toLabel = new JLabel("To");
        this.toLabel.setEnabled(this.useIntervals.isSelected());
        jPanel3.add(this.fromLabel);
        jPanel3.add(this.toLabel);
        jPanel3.add(this.fromValue);
        jPanel3.add(this.toValue);
        jPanel2.add((Component)jPanel3, "North");
        jPanel2.add(jScrollPane);
        JPanel jPanel4 = new JPanel(new GridLayout(4, 1));
        this.addInterval = new JButton("Add");
        this.addInterval.addActionListener(new AddIntervalListener());
        this.addInterval.setEnabled(false);
        this.removeInterval = new JButton("Remove");
        this.removeInterval.addActionListener(new RemoveIntervalListener());
        this.removeInterval.setEnabled(false);
        this.autoInterval = new JButton("Auto");
        this.autoInterval.addActionListener(new AutoIntervalListener());
        this.autoInterval.setEnabled(true);
        this.IEMDiscretize = new JButton(HuginGUIConstants.get("str_iem_discretization"));
        this.IEMDiscretize.addActionListener(new IEMDiscretizeListener());
        this.IEMDiscretize.setEnabled(true);
        jPanel4.add(this.addInterval);
        jPanel4.add(this.removeInterval);
        jPanel4.add(this.autoInterval);
        jPanel4.add(this.IEMDiscretize);
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add((Component)jPanel4, "North");
        titledPanel.setLayout(new BorderLayout(5, 5));
        titledPanel.add(jPanel2);
        titledPanel.add((Component)jPanel5, "East");
        return titledPanel;
    }

    private void updateDiscretizePanel(Vector<PreProcess> vector) {
        int n = 0;
        DiscretizeProcess discretizeProcess = null;
        if (vector == null) {
            this.fromValue.setEnabled(false);
            this.fromLabel.setEnabled(false);
            this.toValue.setEnabled(false);
            this.toLabel.setEnabled(false);
            this.addInterval.setEnabled(false);
            this.removeInterval.setEnabled(false);
            this.autoInterval.setEnabled(false);
            this.IEMDiscretize.setEnabled(false);
            this.tableModel.clear();
            return;
        }
        while (n < vector.size()) {
            PreProcess preProcess;
            if (!((preProcess = vector.get(n++)) instanceof DiscretizeProcess)) continue;
            discretizeProcess = (DiscretizeProcess)preProcess;
        }
        this.fromValue.setEnabled(true);
        this.fromLabel.setEnabled(true);
        this.toValue.setEnabled(true);
        this.toLabel.setEnabled(true);
        this.addInterval.setEnabled(false);
        this.removeInterval.setEnabled(false);
        this.autoInterval.setEnabled(true);
        this.IEMDiscretize.setEnabled(this.variableNameMap.length > 1);
        if (discretizeProcess != null) {
            this.tableModel.setIntervals(discretizeProcess.getIntervals());
        } else {
            this.tableModel.clear();
        }
        this.intervals.clearSelection();
        this.fromValue.setText("");
        this.toValue.setText("");
    }

    private JPanel getExternalPluginPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), HuginGUIConstants.get("str_external_plug_ins")));
        String[] stringArray = new File(this.pluginDir).list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                int n = string.lastIndexOf(".");
                if (n < 0) {
                    return false;
                }
                if (string.substring(n).equals(".class")) {
                    try {
                        return PreProcess.class.isAssignableFrom(ClassLoader.getSystemClassLoader().loadClass(string.substring(0, n)));
                    }
                    catch (Exception exception) {
                        new HuginGUIError(exception);
                    }
                }
                return false;
            }
        });
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].substring(0, stringArray[i].lastIndexOf("."));
        }
        this.plugins = new JComboBox<String>(stringArray);
        JPanel jPanel2 = new JPanel(new BorderLayout(10, 0));
        jPanel2.add((Component)new JLabel(HuginGUIConstants.get("str_selected_plug_in")), "West");
        jPanel2.add(this.plugins);
        JButton jButton = new JButton(HuginGUIConstants.get("str_add"));
        jButton.setEnabled(this.plugins.getSelectedItem() != null);
        jButton.addActionListener(new AddExternalPreprocessListener());
        this.removeExternal = new JButton(HuginGUIConstants.get("str_remove"));
        this.removeExternal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    DataPreprocessingPanel.this.dataStream.removePreProcess((PreProcess)DataPreprocessingPanel.this.processList.getSelectedValue());
                    DataPreprocessingPanel.this.processList.setListData(DataPreprocessingPanel.this.dataStream.getProcessesForVariable(DataPreprocessingPanel.this.variable.getSelectedName()));
                }
                catch (PreProcessingException preProcessingException) {
                    new HuginGUIError(HuginGUIConstants.get("str_unable_to_move_preprocess_ARG0", new String[]{preProcessingException.getMessage()}));
                }
            }
        });
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        jPanel3.add(jButton);
        jPanel3.add(this.removeExternal);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)jPanel2, "North");
        jPanel4.add(jPanel3);
        this.processList = new JList();
        this.processList.getSelectionModel().setSelectionMode(0);
        this.processList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DataPreprocessingPanel.this.removeExternal.setEnabled(DataPreprocessingPanel.this.processList.getSelectedValue() != null);
            }
        });
        this.removeExternal.setEnabled(this.processList.getSelectedValue() != null);
        this.tableScroll = new JScrollPane(this.processList);
        this.tableScroll.setPreferredSize(new Dimension(400, 60));
        jPanel.add((Component)jPanel4, "North");
        jPanel.add(this.tableScroll);
        return jPanel;
    }

    public void setEnableComponents(boolean bl) {
        try {
            int n;
            for (n = 0; n < this.buttons.length - 1; ++n) {
                this.buttons[n].setEnabled(bl);
            }
            this.buttons[this.buttons.length - 1].setCursor(Cursor.getPredefinedCursor(0));
            for (n = 0; n < this.checkVariable.length; ++n) {
                this.checkVariable[n].setEnableComponents(bl);
            }
            this.scrollCheckVariables.setEnabled(bl);
            this.previewData.setEnabled(bl);
            this.includeAll.setEnabled(bl);
            this.excludeAll.setEnabled(bl);
            this.saveData.setEnabled(bl);
            this.databaseSave.setEnabled(bl);
            this.tableScroll.setEnabled(bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setEnableLearningComponents(boolean bl) {
        try {
            this.analyseData.setEnabled(bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateExternalPreprocessPanel(Vector<PreProcess> vector) {
        Vector<PreProcess> vector2 = new Vector<PreProcess>();
        if (vector != null) {
            for (PreProcess preProcess : vector) {
                boolean bl = true;
                if (preProcess instanceof ReplaceProcess) {
                    bl = false;
                }
                if (preProcess instanceof DiscretizeProcess) {
                    bl = false;
                }
                if (!bl) continue;
                vector2.add(preProcess);
            }
        }
        this.processList.setListData(vector2);
        this.removeExternal.setEnabled(this.processList.getSelectedValue() != null);
    }

    @Override
    protected WizardPanel getPrevious() {
        return this.previous;
    }

    @Override
    protected void setPrevious(WizardPanel wizardPanel) {
        this.previous = wizardPanel;
    }

    protected void setDataStream(DataStream dataStream) throws NoDataSourceException, DataSourceException {
        int n;
        this.dataStream = dataStream;
        this.variable.removeAllItems();
        this.tableModel.clear();
        String[] stringArray = new String[]{""};
        try {
            stringArray = dataStream.getFieldNames();
            Variable[] variableArray = dataStream.getCaseTemplate().getVariables();
            this.variableNameMap = new String[stringArray.length][2];
            for (int i = 0; i < stringArray.length; ++i) {
                this.variableNameMap[i][0] = variableArray[i].getNodeName();
                this.variableNameMap[i][1] = variableArray[i].getNameOrLabel();
            }
        }
        catch (PreProcessingException preProcessingException) {
            new HuginGUIError(preProcessingException.getMessage());
        }
        this.variableModel = new VariableComboBoxModel(this.variableNameMap);
        this.variable.setModel(this.variableModel);
        this.variable.setSelectedIndex(0);
        this.variable.setPreferredSize(this.variable.getPreferredSize());
        this.variable.setMaximumSize(this.variable.getPreferredSize());
        this.variable.setMinimumSize(this.variable.getPreferredSize());
        this.checkBoxes = new JPanel(new GridLayout(stringArray.length, 1));
        this.checkVariable = new CheckVariable[stringArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            this.checkVariable[n] = new CheckVariable(stringArray[n], n);
            this.checkBoxes.add(this.checkVariable[n]);
        }
        n = 15;
        if (this.checkVariable.length > 0) {
            n = this.checkVariable[0].getPreferredSize().height;
        }
        this.scrollCheckVariables.getVerticalScrollBar().setUnitIncrement(n);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.checkBoxes, "North");
        this.scrollCheckVariables.setViewportView(jPanel);
        if (dataStream.getCaseTemplate().getMode() == 1) {
            for (int i = 0; i < this.preprocesses.getItemCount(); ++i) {
                if (!((String)this.preprocesses.getItemAt(i)).equals("Discretize")) continue;
                this.preprocesses.removeItemAt(i);
                this.preprocessPanels[i] = this.preprocessPanels[this.preprocessPanels.length - 1];
            }
        }
        this.writeStatus(HuginGUIConstants.get("str_data_source_has_ARG0_variables", new String[]{"" + stringArray.length}));
    }

    @Override
    public void back() {
        this.back(true);
    }

    public void back(boolean bl) {
        this.dataStream.close(bl);
        this.getPrevious().reInitialize();
        this.fromValue.setText("");
        this.toValue.setText("");
        this.addInterval.setEnabled(false);
        this.removeInterval.setEnabled(false);
        this.tableModel.clear();
        this.replaceFromValue.setText("");
        this.replaceToValue.setText("");
        this.addReplace.setEnabled(false);
        this.removeReplace.setEnabled(false);
        this.replaceModel.clear();
        this.clearStatus();
    }

    @Override
    public void reInitialize() {
        this.analyseData.setEnabled(false);
        try {
            this.dataStream.reset();
            this.dataStream.getCaseTemplate().updateVariables();
        }
        catch (DataSourceException dataSourceException) {
            WizardError.showError(HuginGUIConstants.get("str_error"), HuginGUIConstants.get("str_unable_to_reset_data_stream_lb") + dataSourceException.getMessage() + HuginGUIConstants.get("str_lb_int_may_not_be_possible_to_cont"), this);
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
        }
    }

    protected int getTotallyLoadedCaseCount() {
        return this.loadedTotally;
    }

    protected void insertCases() throws PreProcessingException, ExceptionHugin, DataSourceException {
        this.streamData = new StreamData();
        try {
            if (this.viewer != null && this.viewer.isVisible()) {
                this.viewer.dispose();
            }
            this.dataStream.getCaseTemplate().getDomain().setNumberOfCases(0);
            this.dataStream.reset();
            Case case_ = this.dataStream.readCase();
            if (case_ == null) {
                if (this.existingDomain) {
                    throw new PreProcessingException(HuginGUIConstants.get("PRE_PROCESSING_PANEL_Msg_empty_data_set"));
                }
                throw new PreProcessingException(HuginGUIConstants.get("str_data_set_is_empty_cannot_be_used"));
            }
            int n = 0;
            while (case_ != null) {
                if (this.dataStream.getCaseTemplate().getMode() == 1) {
                    case_.insert();
                    if (this.existingDomain) {
                        if (!this.streamData.hasTemplate()) {
                            this.createTemplate(this.streamData, case_);
                        }
                        this.loadStreamData(case_, n, this.streamData);
                    }
                } else {
                    case_.insertOrCreate();
                }
                case_ = this.dataStream.readCase();
                if (++n % 100 != 0) continue;
                this.writeStatus(HuginGUIConstants.get("str_loaded_ARG0_cases", new String[]{"" + n}));
                this.messageBox.paintImmediately(0, 0, this.messageBox.getSize().width, this.messageBox.getSize().height);
            }
            if (this.streamData.getSize() == 0) {
                this.streamData = null;
            }
            this.writeStatus(HuginGUIConstants.get("str_loaded_ARG0_cases_totally", new String[]{"" + n}));
            this.loadedTotally = n;
            this.messageBox.paintImmediately(0, 0, this.messageBox.getSize().width, this.messageBox.getSize().height);
        }
        catch (PreProcessingException preProcessingException) {
            try {
                this.dataStream.reset();
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
            throw preProcessingException;
        }
        catch (ExceptionHugin exceptionHugin) {
            try {
                this.dataStream.reset();
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
            throw exceptionHugin;
        }
        catch (DataSourceException dataSourceException) {
            try {
                this.dataStream.reset();
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
            throw dataSourceException;
        }
    }

    private void disableAllComponents() {
        LinkedList<Container> linkedList = new LinkedList<Container>();
        this.disabledComponents = new LinkedList();
        linkedList.add(this);
        while (linkedList.size() > 0) {
            Container container = (Container)linkedList.removeFirst();
            for (Component component : container.getComponents()) {
                if (!(component instanceof Container)) continue;
                linkedList.add((Container)component);
            }
            if (!container.isEnabled()) continue;
            container.setEnabled(false);
            this.disabledComponents.add(container);
        }
    }

    private void enableAllComponents() {
        for (Component component : this.disabledComponents) {
            component.setEnabled(true);
        }
        this.disabledComponents = null;
    }

    protected static String formatDouble(double d) {
        formatter.setMaximumFractionDigits(6);
        try {
            if (Math.abs(d) == Double.POSITIVE_INFINITY) {
                return "" + d;
            }
            if (d != 0.0 && (Math.abs(d) >= 100000.0 || Math.abs(d) <= 1.0E-6)) {
                return scientificFormat.format(d);
            }
            return formatter.format(d);
        }
        catch (NumberFormatException numberFormatException) {
            return "" + d;
        }
    }

    public void setPreferences(Preferences preferences) {
        this.prefs = preferences;
    }

    public Preferences getPreferences() {
        return this.prefs;
    }

    public DataStream getDataStream() {
        return this.dataStream;
    }

    public void selectVariablesNotInDomain() {
        Domain domain = this.dataStream.getCaseTemplate().getDomain();
        for (int i = 0; i < this.checkVariable.length; ++i) {
            String string = this.variableNameMap[i][0];
            try {
                CheckVariable checkVariable = this.checkVariable[i];
                checkVariable.silentSelect(domain.getNodeByName(string.trim()) == null && checkVariable.isSelected());
                continue;
            }
            catch (ExceptionHugin exceptionHugin) {
                this.checkVariable[i].silentSelect(false);
            }
        }
    }

    private void loadStreamData(Case case_, int n, StreamData streamData) {
        Domain domain = this.dataStream.getCaseTemplate().getDomain();
        try {
            Vector<Object> vector = new Vector<Object>();
            if (case_ == null) {
                throw new DataSourceException(HuginGUIConstants.get("str_empty_data_file"));
            }
            Variable[] variableArray = case_.getVariables();
            for (int i = 0; i < variableArray.length; ++i) {
                Variable variable = variableArray[i];
                if (variable.isExcluded()) continue;
                vector.add(variableArray[i].getState());
            }
            if (vector.size() > 0) {
                streamData.addCase(n, vector);
            }
        }
        catch (DataSourceException dataSourceException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void createTemplate(StreamData streamData, Case case_) {
        Domain domain = this.dataStream.getCaseTemplate().getDomain();
        try {
            Vector<StreamData.ColumnData> vector = new Vector<StreamData.ColumnData>();
            if (case_ == null) {
                throw new DataSourceException(HuginGUIConstants.get("str_empty_data_file"));
            }
            Variable[] variableArray = case_.getVariables();
            for (int i = 0; i < variableArray.length; ++i) {
                Variable variable = variableArray[i];
                if (variable.isExcluded()) continue;
                vector.add(streamData.createColumnData(variable.getName().trim(), domain.getNodeByName(variable.getNodeName())));
            }
            if (vector.size() > 0) {
                streamData.createTemplate(vector);
            }
        }
        catch (DataSourceException dataSourceException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public StreamData getStreamData() {
        return this.streamData;
    }

    private class VariableRelabellingPane
    extends JDialog {
        String[][] nameMap;
        boolean pressedOK;
        JTable conversion;

        public VariableRelabellingPane(String[][] stringArray, JDialog jDialog) {
            super(jDialog, "Relabelling Variables", true);
            this.nameMap = stringArray;
            this.setContentPane(this.createInterior());
        }

        private JPanel createInterior() {
            JPanel jPanel = new JPanel(new BorderLayout(10, 10)){

                public Insets getInsets() {
                    return new Insets(10, 10, 10, 10);
                }
            };
            Object[] objectArray = new String[]{"Name", "Label"};
            this.conversion = new JTable(this.nameMap, objectArray){

                public boolean isCellEditable(int n, int n2) {
                    return n2 != 0;
                }

                public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
                    super.changeSelection(n, 1, bl, bl2);
                }
            };
            JScrollPane jScrollPane = new JScrollPane(this.conversion);
            jPanel.add(jScrollPane);
            JButton jButton = new JButton(HuginGUIConstants.get("OK_button"));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    VariableRelabellingPane.this.pressedOK = true;
                    Component component = VariableRelabellingPane.this.conversion.getEditorComponent();
                    if (component != null && component instanceof JTextComponent) {
                        VariableRelabellingPane.this.conversion.setValueAt(((JTextComponent)component).getText(), VariableRelabellingPane.this.conversion.getEditingRow(), VariableRelabellingPane.this.conversion.getEditingColumn());
                    }
                    VariableRelabellingPane.this.dispose();
                }
            });
            JButton jButton2 = new JButton(HuginGUIConstants.get("cancel_button"));
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    VariableRelabellingPane.this.pressedOK = false;
                    VariableRelabellingPane.this.dispose();
                }
            });
            JPanel jPanel2 = new JPanel(new FlowLayout());
            jPanel2.add(jButton2);
            jPanel2.add(jButton);
            jPanel.add((Component)jPanel2, "South");
            return jPanel;
        }

        public Dimension getPreferredSize() {
            return new Dimension(300, 400);
        }

        public boolean relabelled() {
            this.pressedOK = false;
            this.setVisible(true);
            return this.pressedOK;
        }
    }

    private class PrettyNumberPrinter
    extends DefaultTableCellRenderer {
        JTextField renderer = new JTextField();
        Color selectionColor;

        public PrettyNumberPrinter() {
            this.renderer.setBorder(null);
            this.selectionColor = UIManager.getColor("Table.selectionBackground");
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof Double) {
                this.renderer.setText(DataPreprocessingPanel.formatDouble((Double)object));
            } else {
                this.renderer.setText(object.toString());
            }
            if (bl) {
                this.renderer.setBackground(this.selectionColor);
            } else {
                this.renderer.setBackground(Color.white);
            }
            return this.renderer;
        }
    }

    private class InputIntervalListener
    extends KeyAdapter {
        private InputIntervalListener() {
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (!DataPreprocessingPanel.this.fromValue.isNumber() || !DataPreprocessingPanel.this.toValue.isNumber()) {
                DataPreprocessingPanel.this.addInterval.setEnabled(false);
                return;
            }
            double d = DataPreprocessingPanel.this.fromValue.getNumber();
            double d2 = DataPreprocessingPanel.this.toValue.getNumber();
            DataPreprocessingPanel.this.addInterval.setEnabled(d < d2);
        }
    }

    private class IEMDiscretizeListener
    implements ActionListener {
        private IEMDiscretizer discretizer = null;
        private boolean abortData = false;

        private IEMDiscretizeListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            final String string = DataPreprocessingPanel.this.variable.getSelectedName();
            Object[] objectArray = new String[DataPreprocessingPanel.this.variableNameMap.length - 1];
            boolean bl = false;
            for (int i = 0; i < DataPreprocessingPanel.this.variableNameMap.length; ++i) {
                if (DataPreprocessingPanel.this.variableNameMap[i][0].equals(string)) {
                    bl = true;
                    continue;
                }
                if (bl) {
                    objectArray[i - 1] = DataPreprocessingPanel.this.variableNameMap[i][0];
                    continue;
                }
                objectArray[i] = DataPreprocessingPanel.this.variableNameMap[i][0];
            }
            final String string2 = (String)JOptionPane.showInputDialog(null, HuginGUIConstants.get("str_select_target_class"), HuginGUIConstants.get("str_inf_ent_min_disc"), 1, null, objectArray, objectArray[0]);
            if (string2 == null) {
                return;
            }
            DataPreprocessingPanel.this.disableAllComponents();
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    int n;
                    IEMDiscretizeListener.this.abortData = false;
                    final JDialog jDialog = new JDialog(Hugin.mainFrame, "Processing", true);
                    jDialog.addWindowListener(new WindowAdapter(){

                        public void windowClosed(WindowEvent windowEvent) {
                            IEMDiscretizeListener.this.abortData = true;
                            try {
                                Thread.sleep(200L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if (IEMDiscretizeListener.this.discretizer != null && !IEMDiscretizeListener.this.discretizer.finished()) {
                                IEMDiscretizeListener.this.discretizer.cancel();
                            }
                        }
                    });
                    jDialog.setDefaultCloseOperation(2);
                    JLabel jLabel = null;
                    int n2 = 1000;
                    final ArrayList arrayList = new ArrayList();
                    Case case_ = DataPreprocessingPanel.this.dataStream.getCaseTemplate();
                    Variable[] variableArray = case_.getVariables();
                    int n3 = -1;
                    int n4 = -1;
                    for (n = 0; n < variableArray.length; ++n) {
                        if (variableArray[n].getRealName().equals(string)) {
                            n3 = n;
                        }
                        if (!variableArray[n].getRealName().equals(string2)) continue;
                        n4 = n;
                    }
                    n = n3;
                    final int n5 = n4;
                    Thread thread = new Thread(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            try {
                                DataPreprocessingPanel.this.dataStream.removePreProcess(new DiscretizeProcess(string));
                                DataPreprocessingPanel.this.tableModel = new IntervalTableModel();
                                DataPreprocessingPanel.this.intervals.setModel(DataPreprocessingPanel.this.tableModel);
                                DataPreprocessingPanel.this.dataStream.reset();
                                int n3 = 0;
                                HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                                Case case_ = DataPreprocessingPanel.this.dataStream.readCase();
                                while (!IEMDiscretizeListener.this.abortData && case_ != null) {
                                    String string = case_.getVariables()[n5].getState().trim();
                                    String string2 = case_.getVariables()[n].getState().trim();
                                    if (string != null && string2 != null && string.length() > 0 && string2.length() > 0) {
                                        Integer n2 = (Integer)hashMap.get(string);
                                        if (n2 == null) {
                                            n2 = new Integer(n3++);
                                            hashMap.put(string, n2);
                                        }
                                        IEMDiscretizer.ClassValuePair classValuePair = new IEMDiscretizer.ClassValuePair(n2, Double.parseDouble(string2));
                                        arrayList.add(classValuePair);
                                    }
                                    case_ = DataPreprocessingPanel.this.dataStream.readCase();
                                }
                                IEMDiscretizeListener.this.discretizer = new IEMDiscretizer(arrayList);
                                IEMDiscretizeListener.this.discretizer.createHelperThreads(2);
                                if (!IEMDiscretizeListener.this.abortData) {
                                    IEMDiscretizeListener.this.discretizer.performDiscretization();
                                }
                            }
                            catch (PreProcessingException preProcessingException) {
                                IEMDiscretizeListener.this.abortData = true;
                                new HuginGUIError(preProcessingException);
                            }
                            catch (NumberFormatException numberFormatException) {
                                IEMDiscretizeListener.this.abortData = true;
                                new HuginGUIError(HuginGUIConstants.get("str_error_disc_var_ARG0_data_not_num_ARG1", new String[]{string, numberFormatException.getMessage()}));
                            }
                            catch (DataSourceException dataSourceException) {
                                IEMDiscretizeListener.this.abortData = true;
                                new HuginGUIError(dataSourceException);
                            }
                            finally {
                                try {
                                    DataPreprocessingPanel.this.dataStream.reset();
                                }
                                catch (Exception exception) {
                                    new HuginGUIError(exception);
                                }
                            }
                        }
                    });
                    thread.start();
                    boolean bl = false;
                    while (IEMDiscretizeListener.this.discretizer == null || !IEMDiscretizeListener.this.discretizer.finished() && !IEMDiscretizeListener.this.discretizer.canceled()) {
                        try {
                            Thread.sleep(n2);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (IEMDiscretizeListener.this.abortData) break;
                        if (!(IEMDiscretizeListener.this.discretizer != null && IEMDiscretizeListener.this.discretizer.finished() || bl)) {
                            bl = true;
                            JPanel jPanel = new JPanel(new BorderLayout());
                            jPanel.add((Component)new JLabel("Performing discretization. Please wait..."), "North");
                            JButton jButton = new JButton("Cancel");
                            jButton.addActionListener(new ActionListener(){

                                public void actionPerformed(ActionEvent actionEvent) {
                                    jDialog.dispose();
                                }
                            });
                            jLabel = new JLabel("Reading data...");
                            jPanel.add((Component)jLabel, "Center");
                            jPanel.add((Component)jButton, "South");
                            jDialog.getContentPane().add(jPanel);
                            jDialog.pack();
                            jDialog.setSize(400, 100);
                            HuginGUIUtils.centerComponent(Hugin.mainFrame, (Window)jDialog);
                            n2 = 250;
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    jDialog.setVisible(true);
                                }
                            });
                        }
                        if (jLabel == null || IEMDiscretizeListener.this.discretizer == null) continue;
                        jLabel.setText("Number of intervals = " + (IEMDiscretizeListener.this.discretizer.getCutsMade() + 1) + ", Cuts evaluated = " + IEMDiscretizeListener.this.discretizer.getTriedCuts());
                        jLabel.repaint();
                    }
                    if (jDialog != null) {
                        jDialog.dispose();
                    }
                    try {
                        if (IEMDiscretizeListener.this.discretizer != null && IEMDiscretizeListener.this.discretizer.finished() && !IEMDiscretizeListener.this.discretizer.canceled()) {
                            DataPreprocessingPanel.this.dataStream.addPreProcess(new DiscretizeProcess(string, IEMDiscretizeListener.this.discretizer.getIntervals()));
                        }
                        if (IEMDiscretizeListener.this.discretizer != null) {
                            IEMDiscretizeListener.this.discretizer.cancel();
                        }
                    }
                    catch (PreProcessingException preProcessingException) {
                        new HuginGUIError(preProcessingException);
                    }
                    DataPreprocessingPanel.this.enableAllComponents();
                    DataPreprocessingPanel.this.updateProcessesForSelected();
                    IEMDiscretizeListener.this.discretizer = null;
                }
            });
            thread.start();
        }
    }

    private class AutoIntervalListener
    implements ActionListener {
        private AutoIntervalListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AutoIntervalDialog autoIntervalDialog = new AutoIntervalDialog((JDialog)DataPreprocessingPanel.this.getTopLevelAncestor());
            autoIntervalDialog.pack();
            autoIntervalDialog.setLocation(DataPreprocessingPanel.this.getTopLevelAncestor().getX() + (DataPreprocessingPanel.this.getTopLevelAncestor().getWidth() - autoIntervalDialog.getWidth()) / 2, DataPreprocessingPanel.this.getTopLevelAncestor().getY() + (DataPreprocessingPanel.this.getTopLevelAncestor().getHeight() - autoIntervalDialog.getHeight()) / 2);
            autoIntervalDialog.setVisible(true);
            DiscretizeProcess.Interval[] intervalArray = autoIntervalDialog.getIntervals();
            if (intervalArray != null) {
                DataPreprocessingPanel.this.tableModel.setIntervals(intervalArray);
                try {
                    DataPreprocessingPanel.this.dataStream.addPreProcess(new DiscretizeProcess(DataPreprocessingPanel.this.variable.getSelectedName(), intervalArray));
                }
                catch (PreProcessingException preProcessingException) {
                    WizardError.showError(HuginGUIConstants.get("str_error"), preProcessingException.getMessage(), DataPreprocessingPanel.this);
                }
            }
        }
    }

    private class RemoveIntervalListener
    implements ActionListener {
        private RemoveIntervalListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                DataPreprocessingPanel.this.tableModel.removeInterval(DataPreprocessingPanel.this.intervals.getSelectedRow());
                if (DataPreprocessingPanel.this.tableModel.getRowCount() > 0) {
                    DataPreprocessingPanel.this.dataStream.addPreProcess(new DiscretizeProcess(DataPreprocessingPanel.this.variable.getSelectedName(), DataPreprocessingPanel.this.tableModel.getIntervals()));
                } else {
                    DataPreprocessingPanel.this.dataStream.removePreProcess(new DiscretizeProcess(DataPreprocessingPanel.this.variable.getSelectedName()));
                }
                DataPreprocessingPanel.this.fromValue.setText("");
                DataPreprocessingPanel.this.toValue.setText("");
                DataPreprocessingPanel.this.removeInterval.setEnabled(false);
                DataPreprocessingPanel.this.clearStatus();
            }
            catch (InvalidDiscretizationException invalidDiscretizationException) {
                WizardError.showError(HuginGUIConstants.get("str_error"), invalidDiscretizationException.getMessage(), DataPreprocessingPanel.this);
            }
            catch (PreProcessingException preProcessingException) {
                WizardError.showError(HuginGUIConstants.get("str_error"), preProcessingException.getMessage(), DataPreprocessingPanel.this);
            }
        }
    }

    private class AddIntervalListener
    implements ActionListener {
        private AddIntervalListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                int n = DataPreprocessingPanel.this.tableModel.insertInterval(DataPreprocessingPanel.this.fromValue.getNumber(), DataPreprocessingPanel.this.toValue.getNumber());
                if (n >= 0) {
                    DataPreprocessingPanel.this.dataStream.addPreProcess(new DiscretizeProcess(DataPreprocessingPanel.this.variable.getSelectedName(), DataPreprocessingPanel.this.tableModel.getIntervals()));
                    DataPreprocessingPanel.this.clearStatus();
                    DataPreprocessingPanel.this.fromValue.setText("");
                    DataPreprocessingPanel.this.toValue.setText("");
                    DataPreprocessingPanel.this.addInterval.setEnabled(false);
                    DataPreprocessingPanel.this.removeInterval.setEnabled(false);
                    DataPreprocessingPanel.this.intervals.clearSelection();
                    Rectangle rectangle = new Rectangle(0, (n - 1) * DataPreprocessingPanel.this.intervals.getRowHeight(), 10, 3 * DataPreprocessingPanel.this.intervals.getRowHeight());
                    DataPreprocessingPanel.this.intervals.scrollRectToVisible(rectangle);
                } else {
                    WizardError.showError(HuginGUIConstants.get("str_error"), "Illegal interval:\nOverlap detected", DataPreprocessingPanel.this);
                }
            }
            catch (PreProcessingException preProcessingException) {
                WizardError.showError(HuginGUIConstants.get("str_error"), preProcessingException.getMessage(), DataPreprocessingPanel.this);
            }
        }
    }

    private class UseIntervalListener
    implements ActionListener {
        private UseIntervalListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DataPreprocessingPanel.this.intervals.setEnabled(DataPreprocessingPanel.this.useIntervals.isSelected());
            DataPreprocessingPanel.this.fromValue.setEnabled(DataPreprocessingPanel.this.useIntervals.isSelected());
            DataPreprocessingPanel.this.toValue.setEnabled(DataPreprocessingPanel.this.useIntervals.isSelected());
            DataPreprocessingPanel.this.fromLabel.setEnabled(DataPreprocessingPanel.this.useIntervals.isSelected());
            DataPreprocessingPanel.this.toLabel.setEnabled(DataPreprocessingPanel.this.useIntervals.isSelected());
            try {
                DataPreprocessingPanel.this.removeInterval.setEnabled(DataPreprocessingPanel.this.useIntervals.isSelected() && DataPreprocessingPanel.this.intervals.getSelectedRow() >= 0);
                DataPreprocessingPanel.this.addInterval.setEnabled(DataPreprocessingPanel.this.useIntervals.isSelected() && Double.parseDouble(DataPreprocessingPanel.this.fromValue.getText()) < Double.parseDouble(DataPreprocessingPanel.this.toValue.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private class IntervalTableModel
    extends DefaultTableModel {
        String[] names = new String[]{"From", "To"};
        Vector<DiscretizeProcess.Interval> data = new Vector();

        public int getColumnCount() {
            return this.names.length;
        }

        public String getColumnName(int n) {
            return this.names[n];
        }

        public int getRowCount() {
            return this.data == null ? 0 : this.data.size();
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Object getValueAt(int n, int n2) {
            DiscretizeProcess.Interval interval = this.data.get(n);
            switch (n2) {
                case 0: {
                    return new Double(interval.lower);
                }
                case 1: {
                    return new Double(interval.upper);
                }
            }
            return HuginGUIConstants.get("str_empty");
        }

        public int insertInterval(double d, double d2) {
            DiscretizeProcess.Interval interval;
            if (d >= d2) {
                return -1;
            }
            if (this.data.size() == 0) {
                this.data.add(new DiscretizeProcess.Interval(d, d2));
                DataPreprocessingPanel.this.intervals.setRowSelectionInterval(0, 0);
                this.fireTableStructureChanged();
                return 0;
            }
            int n = 0;
            do {
                interval = this.data.get(n++);
            } while (interval.upper <= d && n < this.data.size());
            if (n == this.data.size() && interval.upper <= d) {
                this.data.add(new DiscretizeProcess.Interval(d, d2));
                DataPreprocessingPanel.this.intervals.setRowSelectionInterval(n, n);
                this.fireTableStructureChanged();
                return n - 1;
            }
            --n;
            if (this.data.get((int)n).lower < d2) {
                return -1;
            }
            this.data.add(this.data.lastElement());
            for (int i = this.data.size() - 2; i >= n; --i) {
                this.data.setElementAt(this.data.get(i), i + 1);
            }
            this.data.setElementAt(new DiscretizeProcess.Interval(d, d2), n);
            DataPreprocessingPanel.this.intervals.setRowSelectionInterval(n, n);
            this.fireTableStructureChanged();
            return n;
        }

        public void removeInterval(int n) {
            this.data.remove(n);
            this.fireTableStructureChanged();
        }

        public void clear() {
            this.data.clear();
            this.fireTableStructureChanged();
        }

        public DiscretizeProcess.Interval[] getIntervals() {
            DiscretizeProcess.Interval[] intervalArray = new DiscretizeProcess.Interval[this.data.size()];
            for (int i = 0; i < intervalArray.length; ++i) {
                intervalArray[i] = this.data.get(i);
            }
            return intervalArray;
        }

        public void setIntervals(DiscretizeProcess.Interval[] intervalArray) {
            this.clear();
            for (int i = 0; i < intervalArray.length; ++i) {
                this.insertInterval(intervalArray[i].lower, intervalArray[i].upper);
            }
        }
    }

    private class SaveListener
    implements ActionListener {
        private SaveListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                HuginFileLoader huginFileLoader = new HuginFileLoader(1, Hugin.mainFrame.getMostRecentDataFile(), 4);
                if (huginFileLoader.showSaveDialog(DataPreprocessingPanel.this) != 0) {
                    return;
                }
                File file = huginFileLoader.getSelectedFile();
                PrintStream printStream = new PrintStream(new FileOutputStream(file));
                DataPreprocessingPanel.this.dataStream.reset();
                printStream.println(DataPreprocessingPanel.this.dataStream.printRealNames());
                Case case_ = DataPreprocessingPanel.this.dataStream.readCase();
                while (case_ != null) {
                    printStream.println(case_);
                    case_ = DataPreprocessingPanel.this.dataStream.readCase();
                }
                printStream.close();
            }
            catch (Exception exception) {
                WizardError.showError(HuginGUIConstants.get("str_error"), exception.getMessage(), DataPreprocessingPanel.this);
            }
            finally {
                try {
                    DataPreprocessingPanel.this.dataStream.reset();
                    if (DataPreprocessingPanel.this.viewer != null) {
                        DataPreprocessingPanel.this.viewer.setStream(DataPreprocessingPanel.this.dataStream);
                    }
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
            }
        }
    }

    private class PreviewListener
    implements ActionListener {
        private PreviewListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                DataPreprocessingPanel.this.dataStream.reset();
                DataPreprocessingPanel.this.viewer = new DataStreamViewer((JDialog)DataPreprocessingPanel.this.getTopLevelAncestor(), DataPreprocessingPanel.this.dataStream, 100);
                DataPreprocessingPanel.this.viewer.pack();
                DataPreprocessingPanel.this.viewer.setVisible(true);
            }
            catch (InvalidDataSourceException invalidDataSourceException) {
                if (DataPreprocessingPanel.this.viewer != null) {
                    DataPreprocessingPanel.this.viewer.dispose();
                }
                String string = invalidDataSourceException.getMessage();
                string = string.substring(0, string.lastIndexOf(" "));
                new HuginGUIError(string + " " + DataPreprocessingPanel.this.dataStream.getLineNumber());
            }
            catch (Exception exception) {
                if (DataPreprocessingPanel.this.viewer != null) {
                    DataPreprocessingPanel.this.viewer.dispose();
                }
                new HuginGUIError(exception.getMessage());
            }
        }
    }

    private class InputReplaceListener
    extends KeyAdapter {
        private InputReplaceListener() {
        }

        public void keyReleased(KeyEvent keyEvent) {
            DataPreprocessingPanel.this.addReplace.setEnabled(DataPreprocessingPanel.this.replaceFromValue.getText().length() > 0 && DataPreprocessingPanel.this.replaceToValue.getText().length() > 0);
        }
    }

    private class RemoveReplaceListener
    implements ActionListener {
        private RemoveReplaceListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                DataPreprocessingPanel.this.dataStream.removePreProcess(new ReplaceProcess(DataPreprocessingPanel.this.variable.getSelectedName(), DataPreprocessingPanel.this.replaceFromValue.getText(), DataPreprocessingPanel.this.replaceToValue.getText()));
                DataPreprocessingPanel.this.replaceModel.removeReplace(DataPreprocessingPanel.this.replace.getSelectedRow());
                DataPreprocessingPanel.this.replaceFromValue.setText("");
                DataPreprocessingPanel.this.replaceToValue.setText("");
                DataPreprocessingPanel.this.removeReplace.setEnabled(false);
                DataPreprocessingPanel.this.addReplace.setEnabled(false);
                DataPreprocessingPanel.this.writeStatus(HuginGUIConstants.get("str_removed_replace_from_ARG0", new String[]{(String)DataPreprocessingPanel.this.variable.getSelectedItem()}));
            }
            catch (PreProcessingException preProcessingException) {
                WizardError.showError(HuginGUIConstants.get("str_error"), HuginGUIConstants.get("str_unable_to_add_preprocess_ARG0", new String[]{preProcessingException.getMessage()}), DataPreprocessingPanel.this);
            }
        }
    }

    private class AddReplaceListener
    implements ActionListener {
        private AddReplaceListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (DataPreprocessingPanel.this.replaceModel.insertReplace(DataPreprocessingPanel.this.replaceFromValue.getText(), DataPreprocessingPanel.this.replaceToValue.getText())) {
                    DataPreprocessingPanel.this.dataStream.addPreProcess(new ReplaceProcess(DataPreprocessingPanel.this.variable.getSelectedName(), DataPreprocessingPanel.this.replaceFromValue.getText(), DataPreprocessingPanel.this.replaceToValue.getText()));
                    DataPreprocessingPanel.this.writeStatus(HuginGUIConstants.get("str_replacing_ARG0_with_ARG1_in_ARG2", new String[]{DataPreprocessingPanel.this.replaceFromValue.getText(), DataPreprocessingPanel.this.replaceToValue.getText(), (String)DataPreprocessingPanel.this.variable.getSelectedItem()}));
                    DataPreprocessingPanel.this.replaceFromValue.setText("");
                    DataPreprocessingPanel.this.replaceToValue.setText("");
                    DataPreprocessingPanel.this.addReplace.setEnabled(false);
                    DataPreprocessingPanel.this.removeReplace.setEnabled(false);
                    DataPreprocessingPanel.this.replace.clearSelection();
                    DataPreprocessingPanel.this.replace.scrollRectToVisible(new Rectangle(0, DataPreprocessingPanel.this.replace.getRowCount() * DataPreprocessingPanel.this.replace.getRowHeight(), 10, DataPreprocessingPanel.this.replace.getRowHeight()));
                } else {
                    WizardError.showError(HuginGUIConstants.get("str_error"), "Specified from value is already used in another replace", DataPreprocessingPanel.this);
                }
            }
            catch (PreProcessingException preProcessingException) {
                WizardError.showError(HuginGUIConstants.get("str_error"), HuginGUIConstants.get("str_unable_to_add_preprocess_ARG0", new String[]{preProcessingException.getMessage()}), DataPreprocessingPanel.this);
            }
        }
    }

    private class LoadPreprocessListener
    implements ActionListener {
        private LoadPreprocessListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block14: {
                boolean bl = DataPreprocessingPanel.this.dataStream.getCaseTemplate().getMode() != 1;
                Object var3_3 = null;
                try {
                    JFileChooser jFileChooser = new JFileChooser(Hugin.mainFrame.getMostRecentDataFile());
                    File file = null;
                    if (jFileChooser.showOpenDialog(Hugin.mainFrame) == 0) {
                        file = jFileChooser.getSelectedFile();
                    }
                    if (file == null) break block14;
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    Document document = documentBuilder.parse(new InputSource(new FileInputStream(file)));
                    Element element = (Element)document.getElementsByTagName("preprocesses").item(0);
                    NodeList nodeList = element.getChildNodes();
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        boolean bl2;
                        Object object;
                        Object object2;
                        Object object3;
                        Node node = nodeList.item(i);
                        if (!(node instanceof Element)) continue;
                        Element element2 = (Element)node;
                        String string = null;
                        try {
                            if (bl && element2.getTagName().equals("discretize")) {
                                string = element2.getAttribute("name");
                                object3 = new Vector();
                                object2 = element2.getChildNodes();
                                for (int j = 0; j < object2.getLength(); ++j) {
                                    Element element3;
                                    object = object2.item(j);
                                    if (!(object instanceof Element) || !(element3 = (Element)object).getTagName().equals("interval")) continue;
                                    double d = Double.parseDouble(element3.getAttribute("lower"));
                                    double d2 = Double.parseDouble(element3.getAttribute("upper"));
                                    ((Vector)object3).add(new DiscretizeProcess.Interval(d, d2));
                                }
                                DiscretizeProcess.Interval[] intervalArray = new DiscretizeProcess.Interval[((Vector)object3).size()];
                                for (int j = 0; j < ((Vector)object3).size(); ++j) {
                                    intervalArray[j] = (DiscretizeProcess.Interval)((Vector)object3).get(j);
                                }
                                System.out.println("" + ((Vector)object3).size());
                                System.out.println("" + intervalArray.length);
                                object = new DiscretizeProcess(string, intervalArray);
                                bl2 = true;
                                for (PreProcess preProcess : DataPreprocessingPanel.this.dataStream.getAllProcesses()) {
                                    if (!preProcess.equals(object)) continue;
                                    bl2 = false;
                                }
                                if (bl2) {
                                    DataPreprocessingPanel.this.dataStream.addPreProcess((PreProcess)object);
                                }
                            }
                        }
                        catch (Exception exception) {
                            new HuginGUIError("Error creating discretize process for '" + string + "': " + exception.getMessage());
                            exception.printStackTrace();
                        }
                        try {
                            if (!element2.getTagName().equals("replace") || !element2.getTagName().equals("replace")) continue;
                            string = element2.getAttribute("name");
                            object3 = element2.getAttribute("from");
                            object2 = element2.getAttribute("to");
                            boolean bl3 = Boolean.parseBoolean(element2.getAttribute("caseSensitive"));
                            object = new ReplaceProcess(string, (String)object3, (String)object2);
                            ((ReplaceProcess)object).setCaseSensitive(bl3);
                            bl2 = true;
                            for (PreProcess preProcess : DataPreprocessingPanel.this.dataStream.getAllProcesses()) {
                                if (!preProcess.equals(object)) continue;
                                bl2 = false;
                            }
                            if (!bl2) continue;
                            DataPreprocessingPanel.this.dataStream.addPreProcess((PreProcess)object);
                            continue;
                        }
                        catch (Exception exception) {
                            new HuginGUIError("Error creating replace process for '" + string + "': " + exception.getMessage());
                        }
                    }
                    DataPreprocessingPanel.this.updateProcessesForSelected();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    new HuginGUIError("Error loading processes: " + exception.getMessage());
                }
            }
        }
    }

    private class SavePreprocessListener
    implements ActionListener {
        private SavePreprocessListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block6: {
                try {
                    Object object;
                    JFileChooser jFileChooser = new JFileChooser();
                    File file = null;
                    if (jFileChooser.showSaveDialog(Hugin.mainFrame) == 0) {
                        file = jFileChooser.getSelectedFile();
                    }
                    if (file == null) break block6;
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    Document document = documentBuilder.newDocument();
                    Element element = document.createElement("preprocesses");
                    document.appendChild(element);
                    for (PreProcess object22 : DataPreprocessingPanel.this.dataStream.getAllProcesses()) {
                        Element element2;
                        if (object22 instanceof DiscretizeProcess) {
                            object = (DiscretizeProcess)object22;
                            element2 = document.createElement("discretize");
                            element.appendChild(element2);
                            element2.setAttribute("name", ((DiscretizeProcess)object).name);
                            for (int i = 0; i < ((DiscretizeProcess)object).intervals.length; ++i) {
                                Element element3 = document.createElement("interval");
                                element2.appendChild(element3);
                                element3.setAttribute("lower", "" + ((DiscretizeProcess)object).intervals[i].lower);
                                element3.setAttribute("upper", "" + ((DiscretizeProcess)object).intervals[i].upper);
                            }
                            continue;
                        }
                        if (!(object22 instanceof ReplaceProcess)) continue;
                        object = (ReplaceProcess)object22;
                        element2 = document.createElement("replace");
                        element.appendChild(element2);
                        element2.setAttribute("name", ((ReplaceProcess)object).name);
                        element2.setAttribute("from", ((ReplaceProcess)object).replace);
                        element2.setAttribute("to", ((ReplaceProcess)object).replaceWith);
                        element2.setAttribute("caseSensitive", "" + ((ReplaceProcess)object).caseSensitive);
                    }
                    document.normalizeDocument();
                    DOMSource dOMSource = new DOMSource(document);
                    Transformer transformer = TransformerFactory.newInstance().newTransformer();
                    transformer.setOutputProperty("method", "xml");
                    transformer.setOutputProperty("encoding", "UTF-8");
                    transformer.setOutputProperty("indent", "yes");
                    transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                    object = new StreamResult(file);
                    transformer.transform(dOMSource, (Result)object);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    new HuginGUIError(exception.getMessage());
                }
            }
        }
    }

    private class UseReplaceListener
    implements ActionListener {
        private UseReplaceListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DataPreprocessingPanel.this.replace.setEnabled(DataPreprocessingPanel.this.useReplace.isSelected());
            DataPreprocessingPanel.this.replaceFromValue.setEnabled(DataPreprocessingPanel.this.useReplace.isSelected());
            DataPreprocessingPanel.this.replaceToValue.setEnabled(DataPreprocessingPanel.this.useReplace.isSelected());
            DataPreprocessingPanel.this.replaceFromLabel.setEnabled(DataPreprocessingPanel.this.useReplace.isSelected());
            DataPreprocessingPanel.this.replaceToLabel.setEnabled(DataPreprocessingPanel.this.useReplace.isSelected());
            DataPreprocessingPanel.this.removeReplace.setEnabled(DataPreprocessingPanel.this.useReplace.isSelected() && DataPreprocessingPanel.this.replace.getSelectedRow() >= 0);
            DataPreprocessingPanel.this.addReplace.setEnabled(DataPreprocessingPanel.this.useReplace.isSelected() && DataPreprocessingPanel.this.replaceFromValue.getText().length() > 0 && DataPreprocessingPanel.this.replaceToValue.getText().length() > 0);
        }
    }

    private class ReplaceTableModel
    extends DefaultTableModel {
        String[] names = new String[]{"From", "To"};
        Vector<String> data = new Vector();

        public int getColumnCount() {
            return this.names.length;
        }

        public String getColumnName(int n) {
            return this.names[n];
        }

        public int getRowCount() {
            return this.data == null ? 0 : this.data.size() / 2;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Object getValueAt(int n, int n2) {
            return this.data.get(n * 2 + n2);
        }

        public boolean insertReplace(String string, String string2) {
            int n = this.data.indexOf(string);
            while (n >= 0) {
                if (n % 2 == 0) {
                    return false;
                }
                n = this.data.indexOf(string, n + 1);
            }
            this.data.add(string);
            this.data.add(string2);
            this.fireTableStructureChanged();
            return true;
        }

        public void removeReplace(int n) {
            this.data.remove(2 * n);
            this.data.remove(2 * n);
            this.fireTableStructureChanged();
        }

        public void clear() {
            this.data.clear();
            this.fireTableStructureChanged();
        }
    }

    private class CheckVariable
    extends JPanel {
        JCheckBox check;
        String variableName;
        JTextField name;
        int index;

        public CheckVariable(String string, int n) {
            this.setLayout(new BorderLayout(5, 0));
            this.variableName = string;
            this.index = n;
            this.check = new JCheckBox();
            this.check.setSelected(true);
            this.check.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (CheckVariable.this.check.isSelected()) {
                        DataPreprocessingPanel.this.variableModel.enableIndex(CheckVariable.this.index);
                        try {
                            DataPreprocessingPanel.this.dataStream.removePreProcess(new ExcludeProcess(CheckVariable.this.variableName));
                            int n = DataPreprocessingPanel.this.dataStream.getCaseTemplate().getDomain().getNodes().size();
                            int n2 = DataPreprocessingPanel.this.dataStream.getCaseTemplate().getVariables().length;
                            DataPreprocessingPanel.this.writeStatus(HuginGUIConstants.get("str_ARG0_included_in_variable_set_ARG1_ARG2", new String[]{CheckVariable.this.variableName, "" + n2, "" + n}));
                        }
                        catch (PreProcessingException preProcessingException) {
                            WizardError.showError(HuginGUIConstants.get("str_error"), preProcessingException.getMessage(), DataPreprocessingPanel.this);
                        }
                        catch (ExceptionHugin exceptionHugin) {
                            new HuginGUIError(exceptionHugin);
                        }
                    } else {
                        DataPreprocessingPanel.this.variableModel.disableIndex(CheckVariable.this.index);
                        try {
                            DataPreprocessingPanel.this.dataStream.addPreProcess(new ExcludeProcess(CheckVariable.this.variableName));
                            int n = DataPreprocessingPanel.this.dataStream.getCaseTemplate().getDomain().getNodes().size();
                            int n3 = DataPreprocessingPanel.this.dataStream.getCaseTemplate().getVariables().length;
                            DataPreprocessingPanel.this.writeStatus(HuginGUIConstants.get("str_ARG0_excluded_from_variable_set_ARG1_ARG2", new String[]{CheckVariable.this.variableName, "" + n3, "" + n}));
                        }
                        catch (PreProcessingException preProcessingException) {
                            WizardError.showError(HuginGUIConstants.get("str_error"), preProcessingException.getMessage(), DataPreprocessingPanel.this);
                        }
                        catch (ExceptionHugin exceptionHugin) {
                            new HuginGUIError(exceptionHugin);
                        }
                    }
                    DataPreprocessingPanel.this.buttons[DataPreprocessingPanel.this.nextButtonIndex].setEnabled(DataPreprocessingPanel.this.variableModel.getSize() > 0);
                    DataPreprocessingPanel.this.previewData.setEnabled(DataPreprocessingPanel.this.variableModel.getSize() > 0);
                }
            });
            this.name = new JTextField(string);
            this.name.setBorder(null);
            this.name.setEditable(false);
            this.name.setBackground(this.getBackground());
            this.add((Component)this.check, "West");
            this.add(this.name);
        }

        public void setEnableComponents(boolean bl) {
            this.check.setEnabled(bl);
            this.name.setEnabled(bl);
        }

        public String getName() {
            return this.variableName;
        }

        public void setSelected(boolean bl) {
            this.check.setSelected(bl);
        }

        public boolean isSelected() {
            return this.check.isSelected();
        }

        public void silentSelect(boolean bl) {
            this.check.setSelected(bl);
            try {
                if (bl) {
                    DataPreprocessingPanel.this.dataStream.removePreProcess(new ExcludeProcess(this.variableName));
                } else {
                    DataPreprocessingPanel.this.dataStream.addPreProcess(new ExcludeProcess(this.variableName));
                }
            }
            catch (PreProcessingException preProcessingException) {
                WizardError.showError(HuginGUIConstants.get("str_error"), preProcessingException.getMessage(), DataPreprocessingPanel.this);
            }
        }

        public Insets getInsets() {
            return new Insets(-3, 0, -3, 0);
        }
    }

    private class VariableComboBoxModel
    extends DefaultComboBoxModel {
        String[][] names;
        boolean[] enabled;
        int itemCount;

        public VariableComboBoxModel(String[][] stringArray) {
            int n;
            this.names = new String[stringArray.length][stringArray[0].length];
            for (n = 0; n < stringArray.length; ++n) {
                for (int i = 0; i < stringArray[n].length; ++i) {
                    this.names[n][i] = stringArray[n][i];
                }
            }
            this.enabled = new boolean[stringArray.length];
            for (n = 0; n < this.enabled.length; ++n) {
                this.enabled[n] = true;
            }
            this.itemCount = stringArray.length;
        }

        public int getSize() {
            return this.itemCount;
        }

        public Object getElementAt(int n) {
            int n2 = 0;
            int n3 = 0;
            while (n >= n2 && n3 < this.enabled.length) {
                if (!this.enabled[n3++]) continue;
                ++n2;
            }
            if (this.names[n3 - 1][1] == null || this.names[n3 - 1][1].length() == 0) {
                return this.names[n3 - 1][0];
            }
            return this.names[n3 - 1][1];
        }

        public Object getNameAt(int n) {
            int n2 = 0;
            int n3 = 0;
            while (n >= n2 && n3 < this.enabled.length) {
                if (!this.enabled[n3++]) continue;
                ++n2;
            }
            if (n3 - 1 < 0 || n3 - 1 > this.names.length) {
                return null;
            }
            return this.names[n3 - 1][0];
        }

        public void disableIndex(int n) {
            this.enabled[n] = false;
            --this.itemCount;
            this.fireIntervalRemoved(this, n, n);
        }

        public void enableIndex(int n) {
            this.enabled[n] = true;
            ++this.itemCount;
            this.fireIntervalAdded(this, n, n);
        }

        public void disableAll() {
            for (int i = 0; i < this.enabled.length; ++i) {
                this.enabled[i] = false;
            }
            this.itemCount = 0;
            this.fireIntervalRemoved(this, 0, this.enabled.length - 1);
        }

        public void enableAll() {
            for (int i = 0; i < this.enabled.length; ++i) {
                this.enabled[i] = true;
            }
            this.itemCount = this.names.length;
            this.fireIntervalAdded(this, 0, this.enabled.length - 1);
        }

        public boolean hasEnabledVariables() {
            for (int i = 0; i < this.enabled.length; ++i) {
                if (!this.enabled[i]) continue;
                return true;
            }
            return false;
        }
    }

    private class VariableComboBox
    extends JComboBox {
        private VariableComboBox() {
        }

        public String getSelectedName() {
            return (String)((VariableComboBoxModel)this.getModel()).getNameAt(this.getSelectedIndex());
        }
    }

    private class AddExternalPreprocessListener
    implements ActionListener {
        PreProcess selectedPlugin = null;
        JDialog preprocessUI = null;
        boolean addPreprocess;
        JPanel theInterface = null;

        private AddExternalPreprocessListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Serializable serializable;
                this.selectedPlugin = (PreProcess)ClassLoader.getSystemClassLoader().loadClass((String)DataPreprocessingPanel.this.plugins.getSelectedItem()).newInstance();
                if (this.selectedPlugin.providesInterface()) {
                    if (this.preprocessUI == null) {
                        this.createSkeleton();
                    }
                    this.preprocessUI.setTitle((String)DataPreprocessingPanel.this.plugins.getSelectedItem());
                    this.changeInterface(this.selectedPlugin.getInterface());
                    this.preprocessUI.pack();
                    serializable = this.preprocessUI.getOwner();
                    this.preprocessUI.setLocation(((Component)serializable).getX() + (((Component)serializable).getWidth() - this.preprocessUI.getWidth()) / 2, ((Component)serializable).getY() + (((Component)serializable).getHeight() - this.preprocessUI.getHeight()) / 2);
                    this.preprocessUI.setVisible(true);
                }
                if (this.addPreprocess) {
                    serializable = DataPreprocessingPanel.this.dataStream.getProcessesForVariable(DataPreprocessingPanel.this.variable.getSelectedName());
                    if (!this.selectedPlugin.multiplePreprocessesAllowed()) {
                        Class<?> clazz = this.selectedPlugin.getClass();
                        Iterator<PreProcess> iterator = ((Vector)serializable).iterator();
                        while (iterator.hasNext()) {
                            PreProcess preProcess = iterator.next();
                            if (!preProcess.getClass().equals(clazz)) continue;
                            DataPreprocessingPanel.this.dataStream.removePreProcess(preProcess);
                            ((Vector)serializable).remove(preProcess);
                        }
                    }
                    this.selectedPlugin.setName(DataPreprocessingPanel.this.variable.getSelectedName());
                    DataPreprocessingPanel.this.dataStream.addPreProcess(this.selectedPlugin);
                    ((Vector)serializable).add(this.selectedPlugin);
                    DataPreprocessingPanel.this.processList.setListData(serializable);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                new HuginGUIError(HuginGUIConstants.get("str_class_not_found_ARG0", new String[]{classNotFoundException.getMessage()}));
            }
            catch (InstantiationException instantiationException) {
                new HuginGUIError(instantiationException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                new HuginGUIError(illegalAccessException.getMessage());
            }
            catch (PreProcessingException preProcessingException) {
                new HuginGUIError(preProcessingException.getMessage());
            }
        }

        private void createSkeleton() {
            this.preprocessUI = new JDialog((JDialog)DataPreprocessingPanel.this.getTopLevelAncestor(), (String)DataPreprocessingPanel.this.plugins.getSelectedItem(), true);
            this.preprocessUI.getContentPane().setLayout(new BorderLayout());
            JPanel jPanel = new JPanel(new FlowLayout());
            JButton jButton = new JButton(HuginGUIConstants.get("OK_button"));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (AddExternalPreprocessListener.this.selectedPlugin.storeValues()) {
                        AddExternalPreprocessListener.this.addPreprocess = true;
                        AddExternalPreprocessListener.this.preprocessUI.dispose();
                    } else {
                        new HuginGUIError(AddExternalPreprocessListener.this.selectedPlugin.getErrorMessage());
                    }
                }
            });
            JButton jButton2 = new JButton(HuginGUIConstants.get("cancel_button"));
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AddExternalPreprocessListener.this.addPreprocess = false;
                    AddExternalPreprocessListener.this.preprocessUI.dispose();
                }
            });
            jPanel.add(jButton);
            jPanel.add(jButton2);
            this.preprocessUI.getContentPane().add((Component)jPanel, "South");
        }

        public void changeInterface(JPanel jPanel) {
            if (this.theInterface != null) {
                this.preprocessUI.getContentPane().remove(this.theInterface);
            }
            this.preprocessUI.getContentPane().add(jPanel);
            this.theInterface = jPanel;
        }
    }
}

