/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.Node;
import COM.hugin.HGUI.Case;
import COM.hugin.HGUI.CasePreprocess;
import COM.hugin.HGUI.DataSource;
import COM.hugin.HGUI.DataSourceException;
import COM.hugin.HGUI.DiscretizeProcess;
import COM.hugin.HGUI.ExcludeProcess;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.InvalidDataException;
import COM.hugin.HGUI.InvalidDataSourceException;
import COM.hugin.HGUI.NoDataSourceException;
import COM.hugin.HGUI.NodeGroup;
import COM.hugin.HGUI.PreProcess;
import COM.hugin.HGUI.PreProcessingException;
import COM.hugin.HGUI.TextfileDataSource;
import COM.hugin.HGUI.Variable;
import java.util.LinkedList;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataStream {
    private DataSource source = null;
    private Case template = null;
    private LinkedList<ExcludeProcess> excludes;
    private LinkedList<PreProcess> preProcesses;
    private LinkedList<CasePreprocess> casePreprocesses;
    private String[] allFields;
    private String name;
    private int missingDataCases = 0;
    boolean stop = false;
    Domain domain = null;
    boolean createNodes = true;
    private int currentCaseCounter = -1;
    private Vector<String[]> multiFields = new Vector();

    public DataStream() {
        this.excludes = new LinkedList();
        this.preProcesses = new LinkedList();
        this.casePreprocesses = new LinkedList();
    }

    public DataStream(DataSource dataSource) throws DataSourceException {
        this(dataSource, null, true);
    }

    public DataStream(DataSource dataSource, Domain domain, boolean bl) throws DataSourceException {
        this();
        this.source = dataSource;
        if (dataSource instanceof TextfileDataSource) {
            this.initialize(domain, bl);
        } else {
            this.domain = domain;
            this.createNodes = bl;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addPreProcess(PreProcess preProcess) throws PreProcessingException {
        String[] stringArray = (String[])this.allFields.clone();
        stringArray = this.getAllFields(stringArray);
        try {
            void var4_12;
            Object object;
            if (preProcess instanceof ExcludeProcess) {
                if (!this.excludes.contains(preProcess)) {
                    this.excludes.add((ExcludeProcess)preProcess);
                    for (ExcludeProcess preProcess2 : this.excludes) {
                        preProcess2.initialize(stringArray);
                        stringArray = preProcess2.process(stringArray);
                    }
                    this.template.reinitialize(stringArray);
                }
            } else {
                if (preProcess instanceof DiscretizeProcess) {
                    int n = this.preProcesses.indexOf(new DiscretizeProcess(preProcess.getNodeName()));
                    if (n >= 0) {
                        DiscretizeProcess i = (DiscretizeProcess)this.preProcesses.get(n);
                        i.replaceIntervals(((DiscretizeProcess)preProcess).getIntervals());
                        this.template.updateVariableNodeIntervals(i.getNodeName(), ((DiscretizeProcess)preProcess).getIntervals());
                    } else {
                        this.preProcesses.add(preProcess);
                        this.template.setVariableNode(preProcess.getNodeName(), ((DiscretizeProcess)preProcess).createIntervalNode(this.template.getDomain()));
                    }
                } else {
                    this.preProcesses.add(0, preProcess);
                }
                object = this.preProcesses.iterator();
                while (object.hasNext()) {
                    PreProcess preProcess2 = (PreProcess)object.next();
                    preProcess2.initialize(stringArray);
                }
            }
            object = new boolean[stringArray.length];
            boolean bl = false;
            while (var4_12 < ((boolean[])object).length) {
                object[var4_12] = stringArray[var4_12] == null;
                ++var4_12;
            }
            this.source.setExcluded((boolean[])object);
        }
        catch (Exception exception) {
            void var4_14;
            exception.printStackTrace();
            boolean bl = false;
            while (var4_14 < this.preProcesses.size()) {
                if (this.preProcesses.get((int)var4_14) == preProcess) {
                    this.preProcesses.remove((int)var4_14);
                    break;
                }
                ++var4_14;
            }
            throw new PreProcessingException(exception.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removePreProcess(PreProcess preProcess) throws PreProcessingException {
        String[] stringArray = (String[])this.allFields.clone();
        stringArray = this.getAllFields(stringArray);
        try {
            void var4_9;
            if (preProcess instanceof ExcludeProcess) {
                this.excludes.remove((ExcludeProcess)preProcess);
            } else {
                this.preProcesses.remove(preProcess);
                if (preProcess instanceof DiscretizeProcess) {
                    this.template.resetVariableNode(preProcess.getNodeName());
                }
                for (PreProcess preProcess2 : this.preProcesses) {
                    preProcess2.initialize(stringArray);
                }
            }
            for (ExcludeProcess excludeProcess : this.excludes) {
                stringArray = excludeProcess.process(stringArray);
            }
            this.template.reinitialize(stringArray);
            Object object = new boolean[stringArray.length];
            boolean bl = false;
            while (var4_9 < ((Object)object).length) {
                object[var4_9] = stringArray[var4_9] == null;
                ++var4_9;
            }
            this.source.setExcluded((boolean[])object);
        }
        catch (Exception exception) {
            throw new PreProcessingException(exception.getMessage());
        }
    }

    public void addCasePreprocess(CasePreprocess casePreprocess) throws ExceptionHugin {
        if (this.casePreprocesses.contains(casePreprocess)) {
            return;
        }
        this.casePreprocesses.add(casePreprocess);
        this.updateCase();
    }

    public void removeCasePreprocess(CasePreprocess casePreprocess) throws ExceptionHugin {
        this.casePreprocesses.remove(casePreprocess);
        this.updateCase();
    }

    private String[] getAllFields(String[] stringArray) {
        for (CasePreprocess casePreprocess : this.casePreprocesses) {
            stringArray = casePreprocess.getNames(stringArray);
        }
        return stringArray;
    }

    private void updateCase() throws ExceptionHugin {
        String[] stringArray = (String[])this.allFields.clone();
        stringArray = this.getAllFields(stringArray);
        this.template.setVariables(stringArray, this.template.getDomain(), this.template.getMode());
        this.currentCaseCounter = -1;
        this.multiFields.clear();
    }

    public void initialize() throws NoDataSourceException, DataSourceException {
        this.initialize(this.domain, this.createNodes);
    }

    public void stop() {
        this.stop = true;
    }

    private boolean containsNull(String[] stringArray) {
        for (String string : stringArray) {
            if (string != null) continue;
            return true;
        }
        return false;
    }

    public void initialize(Domain domain, boolean bl) throws NoDataSourceException, DataSourceException {
        if (!this.stop && this.source == null) {
            throw new NoDataSourceException(HuginGUIConstants.get("str_no_source_given_for_datastream"));
        }
        try {
            if (this.template != null && domain == null) {
                this.template.close();
                this.template = null;
            }
            this.allFields = this.source.getNames();
            for (CasePreprocess iterator : this.casePreprocesses) {
                if (this.stop) break;
                this.allFields = iterator.getNames(this.allFields);
            }
            if (!this.stop && (this.allFields == null || this.allFields.length == 0) || this.containsNull(this.allFields)) {
                throw new DataSourceException(HuginGUIConstants.get("str_invalid_data_source_format"));
            }
            String[] stringArray = (String[])this.allFields.clone();
            for (ExcludeProcess excludeProcess : this.excludes) {
                if (this.stop) break;
                excludeProcess.initialize(stringArray);
                excludeProcess.process(stringArray);
            }
            if (this.stop) {
                return;
            }
            this.template = domain == null ? new Case(stringArray) : new Case(stringArray, domain, bl ? 0 : 1);
            this.allFields = this.template.getFieldNames();
            for (PreProcess preProcess : this.preProcesses) {
                if (!this.stop) {
                    preProcess.initialize(stringArray);
                    if (!(preProcess instanceof DiscretizeProcess)) continue;
                    this.template.setVariableNode(preProcess.getNodeName(), ((DiscretizeProcess)preProcess).createIntervalNode(this.template.getDomain()));
                    continue;
                }
                break;
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            throw new InvalidDataSourceException(HuginGUIConstants.get("str_errors_occured_while_reading_the_data_source_lb") + exceptionHugin.getMessage());
        }
        catch (PreProcessingException preProcessingException) {
            throw new DataSourceException(HuginGUIConstants.get("str_unable_to_use_data_source_ARG0", new String[]{preProcessingException.getMessage()}));
        }
    }

    public Variable[] getExtraVariables() {
        if (this.template != null) {
            return this.template.getMissingVariables();
        }
        return null;
    }

    public long getLineNumber() {
        return this.source.getLineNumber();
    }

    protected DataSource getSource() throws DataSourceException {
        this.reset();
        return this.source;
    }

    public Case readCase() throws NoDataSourceException, DataSourceException, PreProcessingException {
        if (this.source == null || this.template == null) {
            throw new NoDataSourceException(HuginGUIConstants.get("str_no_source_given_for_the_datastream"));
        }
        try {
            Object object;
            String[] stringArray = null;
            while (this.currentCaseCounter < 0) {
                stringArray = this.source.readLine();
                while (stringArray != null && stringArray.length == 0) {
                    stringArray = this.source.readLine();
                }
                if (stringArray == null) {
                    return null;
                }
                this.multiFields.clear();
                object = new Vector();
                this.multiFields.add(stringArray);
                for (CasePreprocess casePreprocess : this.casePreprocesses) {
                    ((Vector)object).clear();
                    for (int i = 0; i < this.multiFields.size(); ++i) {
                        String[][] stringArray2 = casePreprocess.process(this.multiFields.get(i));
                        for (int j = 0; j < stringArray2.length; ++j) {
                            ((Vector)object).add((String[])stringArray2[j]);
                        }
                    }
                    Vector<String[]> vector = object;
                    object = this.multiFields;
                    this.multiFields = vector;
                }
                if (this.casePreprocesses.size() == 0) {
                    this.currentCaseCounter = 0;
                    continue;
                }
                this.currentCaseCounter = this.multiFields != null && this.multiFields.size() == 0 ? -1 : 0;
            }
            if (this.multiFields != null) {
                stringArray = this.multiFields.get(this.currentCaseCounter++);
                if (this.currentCaseCounter == this.multiFields.size()) {
                    this.currentCaseCounter = -1;
                }
            } else {
                this.currentCaseCounter = -1;
            }
            for (ExcludeProcess excludeProcess : this.excludes) {
                excludeProcess.process(stringArray);
            }
            for (PreProcess preProcess : this.preProcesses) {
                preProcess.process(stringArray);
            }
            object = this.template;
            this.missingDataCases += ((Case)object).enterValues(stringArray) ? 1 : 0;
            return object;
        }
        catch (ExceptionHugin exceptionHugin) {
            throw new InvalidDataSourceException(HuginGUIConstants.get("str_errors_occured_while_reading_the_data_source_lb") + exceptionHugin.getMessage());
        }
        catch (InvalidDataException invalidDataException) {
            throw new InvalidDataSourceException(HuginGUIConstants.get("str_errors_occured_while_reading_the_data_source_lb") + invalidDataException.getMessage());
        }
        catch (PreProcessingException preProcessingException) {
            throw new PreProcessingException(HuginGUIConstants.get("str_ARG0_at_line_ARG1", new String[]{preProcessingException.getMessage(), "" + this.source.getLineNumber()}));
        }
    }

    public String printCase(Case case_) {
        return case_.toString();
    }

    protected Case getCaseTemplate() {
        return this.template;
    }

    protected Vector<PreProcess> getProcessesForVariable(String string) {
        Vector<PreProcess> vector = new Vector<PreProcess>();
        for (ExcludeProcess preProcess : this.excludes) {
            if (!preProcess.getNodeName().trim().equals(string.trim())) continue;
            vector.add(preProcess);
        }
        for (PreProcess preProcess : this.preProcesses) {
            if (!preProcess.getNodeName().trim().equals(string.trim())) continue;
            vector.add(preProcess);
        }
        return vector;
    }

    protected Vector<PreProcess> getAllProcesses() {
        Vector<PreProcess> vector = new Vector<PreProcess>(this.excludes.size() + this.preProcesses.size());
        for (ExcludeProcess preProcess : this.excludes) {
            vector.add(preProcess);
        }
        for (PreProcess preProcess : this.preProcesses) {
            vector.add(preProcess);
        }
        return vector;
    }

    protected LinkedList<CasePreprocess> getCasePreprocesses() {
        return this.casePreprocesses;
    }

    protected int getMissingValuesCount() {
        return this.missingDataCases;
    }

    protected String[] getFieldNames() throws PreProcessingException {
        String[] stringArray = (String[])this.allFields.clone();
        stringArray = this.getAllFields(stringArray);
        for (ExcludeProcess excludeProcess : this.excludes) {
            stringArray = excludeProcess.process(stringArray);
        }
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            ++n;
        }
        String[] stringArray2 = new String[n];
        n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            stringArray2[n++] = stringArray[i];
        }
        return stringArray2;
    }

    protected void updateVariables() throws ExceptionHugin {
        this.template.updateVariables();
    }

    protected String printNames() throws ExceptionHugin {
        return this.template.printNames();
    }

    protected String printRealNames() throws ExceptionHugin {
        return this.template.printRealNames();
    }

    public void reset() throws DataSourceException {
        this.source.reset();
        for (CasePreprocess casePreprocess : this.casePreprocesses) {
            casePreprocess.reset();
        }
    }

    public void close() {
        this.close(true);
    }

    public void close(boolean bl) {
        this.excludes.clear();
        this.preProcesses.clear();
        this.casePreprocesses.clear();
        this.casePreprocesses = new LinkedList();
        this.excludes = new LinkedList();
        this.preProcesses = new LinkedList();
        this.source.setExcluded(null);
        try {
            if (bl) {
                this.template.getDomain().delete();
            }
            this.template = null;
        }
        catch (ExceptionHugin exceptionHugin) {
            // empty catch block
        }
    }

    public void updateFields() {
        int n;
        String string;
        String[] stringArray = this.template.getFieldNames();
        for (ExcludeProcess preProcess : this.excludes) {
            string = preProcess.getName();
            for (n = 0; n < this.allFields.length; ++n) {
                if (!string.equals(this.allFields[n])) continue;
                preProcess.setName(stringArray[n]);
            }
        }
        for (PreProcess preProcess : this.preProcesses) {
            string = preProcess.getName();
            for (n = 0; n < this.allFields.length; ++n) {
                if (!string.equals(this.allFields[n])) continue;
                preProcess.setName(stringArray[n]);
            }
        }
    }

    public void setTimeStamped(boolean bl) throws ExceptionHugin {
        Object object2;
        LinkedList<NodeGroup> linkedList = new LinkedList<NodeGroup>();
        Domain domain = this.template.getDomain();
        for (Object object2 : domain.getNodes()) {
            String string = ((Node)object2).getName();
            int n = string.lastIndexOf("_");
            if (n <= 0) continue;
            String string2 = string.substring(n + 1);
            NodeGroup nodeGroup = new NodeGroup("Step_" + string2, Integer.parseInt(string2) % 63);
            if (!linkedList.contains(nodeGroup)) {
                linkedList.add(nodeGroup);
            }
            ((Node)object2).setAttribute("HR_Grp", "" + linkedList.indexOf(nodeGroup));
        }
        Object object3 = "";
        object2 = "";
        for (NodeGroup nodeGroup : linkedList) {
            object3 = (String)object3 + nodeGroup.getName() + '\t';
            int n = nodeGroup.getColorIndex();
            if (n < 10) {
                object2 = (String)object2 + "0" + n;
                continue;
            }
            object2 = (String)object2 + n;
        }
        domain.setAttribute("HR_Groups_UserGroupsNo", "" + linkedList.size());
        domain.setAttribute("HR_Groups_GroupNames", (String)object3);
        domain.setAttribute("HR_Groups_GroupColors", (String)object2);
    }

    public void setSourceName(String string) {
        this.name = string;
    }

    public String getSourceName() {
        return this.name;
    }

    public boolean isEmpty() {
        try {
            return this.getFieldNames().length == 0;
        }
        catch (PreProcessingException preProcessingException) {
            return true;
        }
    }

    public static void main(String[] stringArray) {
        try {
            DataStream dataStream = new DataStream(new TextfileDataSource(stringArray[0]));
            DiscretizeProcess.Interval[] intervalArray = new DiscretizeProcess.Interval[]{new DiscretizeProcess.Interval(0.0, 10.0), new DiscretizeProcess.Interval(10.0, 20.0)};
            dataStream.addPreProcess(new DiscretizeProcess("C1", intervalArray));
            Case case_ = dataStream.readCase();
            while (case_ != null) {
                case_ = dataStream.readCase();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

