/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HGUI.DataSource;
import COM.hugin.HGUI.DataSourceException;
import COM.hugin.HGUI.DatabaseException;
import COM.hugin.HGUI.DatabaseJoin;
import COM.hugin.HGUI.DatabaseTable;
import COM.hugin.HGUI.DatabaseVariable;
import COM.hugin.HGUI.HuginGUIConstants;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DatabaseDataSource
implements DataSource {
    Connection database;
    Statement statement;
    PreparedStatement getAllStatement;
    private static final Class[] parameters = new Class[]{URL.class};
    ResultSet resultSet;
    ResultSetMetaData resultSetMetaData;
    private int totalColumnCount;
    private int lineNumber;
    private int realColumnCount;
    private int[] columnCounts;
    private int[] includeFields;
    private boolean resultSetExhausted = false;
    private boolean resultSetAtBeginning = false;
    String host;
    String port;
    String sid;
    String user;
    String[] tables;
    DatabaseJoin join;
    Vector<NameTableEntry> nameTable = null;
    private boolean[] excluded;

    public void setJoin(DatabaseJoin databaseJoin) {
        this.join = databaseJoin;
    }

    public void setTables(String[] stringArray) {
        this.tables = stringArray;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith("\"") && !stringArray[i].endsWith("\"")) continue;
            stringArray[i] = stringArray[i].replace("\"", "");
        }
    }

    @Override
    public void setExcluded(boolean[] blArray) {
        this.excluded = blArray;
    }

    @Override
    public String[] readLine() throws DataSourceException {
        if (this.tables == null || this.tables.length == 0) {
            throw new DataSourceException(HuginGUIConstants.get("str_db_source_has_not_been_initialized_no_tb_to_select"));
        }
        try {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            if (this.statement == null) {
                this.statement = this.database.createStatement();
                DatabaseMetaData databaseMetaData = this.database.getMetaData();
                this.getColumnCounts(databaseMetaData);
                this.includeFields = this.includeFields();
                this.realColumnCount = this.getRealColumnCount(this.includeFields);
                String string = "Select * from ";
                for (int i = 0; i < this.tables.length - 1; ++i) {
                    string = string + this.tables[i] + ",";
                }
                string = string + this.tables[this.tables.length - 1];
                if (this.join != null) {
                    string = string + " where " + this.join;
                }
                this.resultSet = this.statement.executeQuery(string);
                this.resultSetMetaData = this.resultSet.getMetaData();
            }
            if (this.resultSetExhausted) {
                return null;
            }
            if (!this.resultSet.next()) {
                this.resultSetExhausted = true;
                return null;
            }
            this.resultSetAtBeginning = false;
            String[] stringArray = new String[this.realColumnCount];
            for (int i = 1; i <= this.totalColumnCount; ++i) {
                if (this.excluded != null && this.excluded[n3] && this.includeFields[i - 1] == i - 1) {
                    stringArray[n3++] = "";
                    continue;
                }
                if (this.includeFields[i - 1] == i - 1) {
                    stringArray[n3++] = this.resultSet.getString(i);
                }
                if (i != n2 + this.columnCounts[n]) continue;
                n2 += this.columnCounts[n++];
            }
            ++this.lineNumber;
            return stringArray;
        }
        catch (Exception exception) {
            try {
                this.statement.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            this.statement = null;
            throw new DataSourceException(HuginGUIConstants.get("str_at_row_") + this.lineNumber + " : " + exception.getMessage());
        }
    }

    @Override
    public String[] getNames() throws DataSourceException {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        try {
            int n3;
            this.statement = this.database.createStatement();
            DatabaseMetaData databaseMetaData = this.database.getMetaData();
            this.getColumnCounts(databaseMetaData);
            this.includeFields = this.includeFields();
            this.realColumnCount = this.getRealColumnCount(this.includeFields);
            String string = "Select * from ";
            for (n3 = 0; n3 < this.tables.length - 1; ++n3) {
                string = string + this.tables[n3].replace("\"", "") + ",";
            }
            string = string + this.tables[this.tables.length - 1];
            if (this.join != null) {
                string = string + " where " + this.join;
            }
            this.resultSet = this.statement.executeQuery(string);
            this.resultSetMetaData = this.resultSet.getMetaData();
            this.resultSetAtBeginning = true;
            this.resultSetExhausted = false;
            this.nameTable = new Vector(this.realColumnCount);
            for (n3 = 1; n3 <= this.totalColumnCount; ++n3) {
                if (this.includeFields[n3 - 1] == n3 - 1) {
                    this.nameTable.add(new NameTableEntry(this.resultSetMetaData.getColumnName(n3), this.tables[n]));
                }
                if (n3 != n2 + this.columnCounts[n]) continue;
                n2 += this.columnCounts[n++];
            }
            String[] stringArray = this.makeLabels(this.nameTable);
            return stringArray;
        }
        catch (SQLException sQLException) {
            try {
                this.statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.statement = null;
            throw new DataSourceException(sQLException.getMessage());
        }
    }

    private String[] makeLabels(Vector<NameTableEntry> vector) {
        for (int i = 0; i < vector.size(); ++i) {
            NameTableEntry nameTableEntry = vector.get(i);
            int n = vector.indexOf(nameTableEntry, i + 1);
            if (n < 0) continue;
            NameTableEntry nameTableEntry2 = vector.get(n);
            nameTableEntry2.setFullName();
            nameTableEntry.setFullName();
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = vector.get((int)i).name;
        }
        return stringArray;
    }

    @Override
    public long getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public void reset() throws DataSourceException {
        try {
            if (this.statement == null) {
                return;
            }
            if (this.resultSet.getType() != 1003) {
                this.resultSet.first();
                this.resultSet.previous();
            } else {
                this.statement = this.database.createStatement();
                String string = "Select * from ";
                for (int i = 0; i < this.tables.length - 1; ++i) {
                    string = string + this.tables[i] + ",";
                }
                string = string + this.tables[this.tables.length - 1];
                if (this.join != null) {
                    string = string + " where " + this.join;
                }
                this.resultSet = this.statement.executeQuery(string);
                this.resultSetExhausted = false;
                this.resultSetAtBeginning = true;
            }
        }
        catch (SQLException sQLException) {
            throw new DataSourceException(sQLException.getMessage());
        }
    }

    protected Connection getConnection() {
        return this.database;
    }

    protected String getUser() {
        return this.user;
    }

    protected abstract Vector<DatabaseTable> getTables() throws SQLException;

    @Override
    public void close() throws DataSourceException {
        try {
            this.database.close();
        }
        catch (Exception exception) {
            throw new DataSourceException(exception.getMessage());
        }
    }

    private void getColumnCounts() throws SQLException {
        Statement statement = null;
        try {
            statement = this.database.createStatement();
            this.totalColumnCount = 0;
            this.columnCounts = new int[this.tables.length];
            for (int i = 0; i < this.tables.length; ++i) {
                ResultSet resultSet = statement.executeQuery("select * from " + this.tables[i].replace("\"", ""));
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                this.columnCounts[i] = resultSetMetaData.getColumnCount();
                this.totalColumnCount += this.columnCounts[i];
                resultSet.close();
            }
            statement.close();
        }
        catch (SQLException sQLException) {
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw sQLException;
        }
    }

    private int getRealColumnCount(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != i) continue;
            ++n;
        }
        return n;
    }

    private int[] includeFields() throws SQLException {
        if (this.totalColumnCount == 0) {
            return new int[0];
        }
        try {
            String string;
            String string2;
            int n;
            int[] nArray = new int[this.totalColumnCount];
            String[] stringArray = new String[this.totalColumnCount];
            Statement statement = this.database.createStatement();
            for (int i = 0; i < this.totalColumnCount; ++i) {
                nArray[i] = i;
            }
            String string3 = "select * from ";
            for (n = 0; n < this.tables.length - 1; ++n) {
                string3 = string3 + this.tables[n].replace("\"", "") + ",";
            }
            string3 = string3 + this.tables[this.tables.length - 1].replace("\"", "");
            ResultSet resultSet = statement.executeQuery(string3);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            n = 0;
            int n2 = 0;
            for (int i = 0; i < this.totalColumnCount; ++i) {
                string2 = this.tables[n];
                string = resultSetMetaData.getColumnName(i + 1);
                stringArray[i] = string.toLowerCase().startsWith(string2.toLowerCase()) ? "\"" + string + "\"" : this.tables[n] + ".\"" + resultSetMetaData.getColumnName(i + 1) + "\"";
                if (i != n2 + this.columnCounts[n] - 1) continue;
                n2 += this.columnCounts[n++];
            }
            DatabaseJoin databaseJoin = this.join;
            while (databaseJoin != null) {
                int n3;
                string2 = databaseJoin.getTo().getName() + "." + databaseJoin.getToVariable().getName();
                string = databaseJoin.getFrom().getName() + "." + databaseJoin.getFromVariable().getName();
                int n4 = this.getIndex(string2, stringArray);
                int n5 = this.getIndex(string, stringArray);
                int n6 = this.getIndexValue(nArray, n4);
                if (n6 != (n3 = this.getIndexValue(nArray, n5))) {
                    for (int i = 0; i < nArray.length; ++i) {
                        if (nArray[i] != n3) continue;
                        nArray[i] = n6;
                    }
                }
                databaseJoin = this.join.getNextJoin();
            }
            statement.close();
            return nArray;
        }
        catch (SQLException sQLException) {
            try {
                this.statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.statement = null;
            throw sQLException;
        }
    }

    private int getIndex(String string, String[] stringArray) {
        int n;
        String string2 = "";
        String[] stringArray2 = string.split("\"");
        for (n = 0; n < stringArray2.length; ++n) {
            string2 = string2 + stringArray2[n];
        }
        for (n = 0; n < stringArray.length; ++n) {
            String string3 = "";
            stringArray2 = stringArray[n].split("\"");
            for (int i = 0; i < stringArray2.length; ++i) {
                string3 = string3 + stringArray2[i];
            }
            if (!string2.toLowerCase().equals(string3.toLowerCase()) && string2.toLowerCase() != string3.toLowerCase()) continue;
            return n;
        }
        return -1;
    }

    private int getIndexValue(int[] nArray, int n) {
        if (nArray[n] == n) {
            return n;
        }
        return this.getIndexValue(nArray, nArray[n]);
    }

    protected void fillInVariables(Vector<DatabaseTable> vector) throws SQLException {
        try {
            for (int i = 0; i < vector.size(); ++i) {
                Vector<DatabaseVariable> vector2 = new Vector<DatabaseVariable>();
                DatabaseTable databaseTable = vector.get(i);
                String string = databaseTable.getName();
                if (string.startsWith("\"") || string.endsWith("\"")) {
                    string = string.replace("\"", "");
                }
                ResultSet resultSet = null;
                DatabaseMetaData databaseMetaData = this.database.getMetaData();
                resultSet = databaseMetaData.getColumns(null, null, string, null);
                while (resultSet.next()) {
                    vector2.add(new DatabaseVariable(resultSet.getString("COLUMN_NAME")));
                }
                databaseTable.setVariables(vector2);
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            try {
                this.statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw sQLException;
        }
    }

    protected boolean resultSetExhausted() {
        return this.resultSetExhausted;
    }

    protected boolean resultSetAtBeginning() {
        return this.resultSetAtBeginning;
    }

    private void getColumnCounts(DatabaseMetaData databaseMetaData) throws SQLException {
        try {
            this.totalColumnCount = 0;
            this.columnCounts = new int[this.tables.length];
            for (int i = 0; i < this.tables.length; ++i) {
                ResultSet resultSet = databaseMetaData.getColumns(null, null, this.tables[i].replace("\"", ""), null);
                int n = 0;
                while (resultSet.next()) {
                    ++n;
                }
                this.columnCounts[i] = n;
                this.totalColumnCount += this.columnCounts[i];
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            try {
                this.statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw sQLException;
        }
    }

    public ArrayList<String> loadDrivers(String string) throws DatabaseException {
        File file = new File(string);
        String string2 = System.getProperty("java.class.path");
        ArrayList<String> arrayList = new ArrayList<String>();
        if (file.getName().endsWith(".jar") || file.getName().endsWith(".zip")) {
            try {
                if (string2.indexOf(file.getName()) == -1) {
                    if (this.includesDriver(file)) {
                        this.addFile(file);
                        ArrayList<String> arrayList2 = this.unpack(file);
                        for (int i = 0; i < arrayList2.size(); ++i) {
                            arrayList.add(arrayList2.get(i));
                        }
                    }
                } else {
                    ArrayList<String> arrayList3 = this.unpack(file);
                    for (int i = 0; i < arrayList3.size(); ++i) {
                        arrayList.add(arrayList3.get(i));
                    }
                }
            }
            catch (Exception exception) {
                throw new DatabaseException(exception.getMessage());
            }
        }
        return arrayList;
    }

    private void addFile(File file) throws IOException {
        URL uRL = file.toURI().toURL();
        URLClassLoader uRLClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> clazz = URLClassLoader.class;
        try {
            Method method = clazz.getDeclaredMethod("addURL", parameters);
            method.setAccessible(true);
            method.invoke((Object)uRLClassLoader, uRL);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new IOException("Error, could not add URL to system classloader");
        }
    }

    private boolean includesDriver(File file) throws IOException {
        boolean bl = false;
        String string = file.getPath();
        ZipFile zipFile = new ZipFile(string);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (!zipEntry.getName().endsWith("Driver.class")) continue;
            bl = true;
            return bl;
        }
        zipFile.close();
        return bl;
    }

    private ArrayList<String> unpack(File file) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = file.getPath();
        if (string.endsWith(".jar") || string.endsWith(".zip")) {
            ZipFile zipFile = new ZipFile(string);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                if (!zipEntry.getName().endsWith("Driver.class") || !zipEntry.getName().contains("jdbc")) continue;
                String string2 = zipEntry.getName().replace('/', '.');
                string2 = string2.replaceAll(".class", "");
                arrayList.add(string2);
            }
            zipFile.close();
        }
        return arrayList;
    }

    private class NameTableEntry {
        String table;
        String variable;
        String name;

        public NameTableEntry(String string, String string2) {
            this.table = string2;
            this.variable = string;
            this.name = string;
        }

        public void setFullName() {
            this.name = this.variable + "_" + this.table;
        }

        public boolean equals(Object object) {
            if (!(object instanceof NameTableEntry)) {
                return false;
            }
            return this.variable.equals(((NameTableEntry)object).variable);
        }
    }
}

