/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HGUI.DatabaseTable;
import COM.hugin.HGUI.DatabaseVariable;
import COM.hugin.HGUI.HuginGUIConstants;
import java.util.LinkedList;
import java.util.ListIterator;

public class DatabaseJoin {
    private DatabaseTable to;
    private DatabaseTable from;
    private DatabaseVariable toVar;
    private DatabaseVariable fromVar;
    private LinkedList<Object> elements;
    private ListIterator<Object> current;
    private ListIterator<Object> retriever;
    private String[] operators = new String[]{"and"};
    private boolean addedOperatorLast = true;

    public DatabaseJoin() {
        this.elements = new LinkedList();
        this.current = this.elements.listIterator();
    }

    public DatabaseJoin(DatabaseTable databaseTable, DatabaseTable databaseTable2, DatabaseVariable databaseVariable, DatabaseVariable databaseVariable2) throws InvalidJoinException {
        if (databaseTable == null || databaseTable2 == null || databaseVariable == null || databaseVariable2 == null || databaseTable.toString().trim().length() == 0 || databaseTable2.toString().trim().length() == 0 || databaseVariable.toString().trim().length() == 0 || databaseVariable2.toString().trim().length() == 0) {
            throw new InvalidJoinException(HuginGUIConstants.get("str_invalid_join_empty"));
        }
        this.to = databaseTable;
        this.from = databaseTable2;
        this.toVar = databaseVariable;
        this.fromVar = databaseVariable2;
        this.elements = new LinkedList();
        this.current = this.elements.listIterator();
        this.addedOperatorLast = false;
    }

    protected void setTables(DatabaseTable databaseTable, DatabaseTable databaseTable2) {
        this.from = databaseTable;
        this.to = databaseTable2;
    }

    protected DatabaseTable getFrom() {
        return this.from;
    }

    protected DatabaseTable getTo() {
        return this.to;
    }

    protected DatabaseVariable getFromVariable() {
        return this.fromVar;
    }

    protected DatabaseVariable getToVariable() {
        return this.toVar;
    }

    protected boolean addJoin(DatabaseJoin databaseJoin) {
        if (!this.addedOperatorLast) {
            return false;
        }
        if (this.toVar == null && this.fromVar == null) {
            this.to = databaseJoin.getTo();
            this.from = databaseJoin.getFrom();
            this.toVar = databaseJoin.getToVariable();
            this.fromVar = databaseJoin.getFromVariable();
        } else {
            this.current.add(databaseJoin);
        }
        this.addedOperatorLast = false;
        return true;
    }

    protected boolean addOperator(String string) {
        if (this.addedOperatorLast) {
            return false;
        }
        boolean bl = false;
        string = string.trim().toLowerCase();
        for (int i = 0; i < this.operators.length; ++i) {
            bl = bl || string.equals(this.operators[i]);
        }
        if (!bl) {
            return false;
        }
        this.current.add(string);
        this.addedOperatorLast = true;
        return true;
    }

    protected boolean addedOperatorLast() {
        return this.addedOperatorLast;
    }

    protected int deleteElement() {
        this.current.previous();
        this.current.remove();
        this.addedOperatorLast = !this.addedOperatorLast;
        return this.elements.size();
    }

    protected boolean containsTable(DatabaseTable databaseTable) {
        boolean bl;
        boolean bl2 = bl = databaseTable.equals(this.from) || databaseTable.equals(this.to);
        if (this.elements == null) {
            return bl;
        }
        ListIterator listIterator = this.elements.listIterator();
        while (listIterator.hasNext()) {
            Object e = listIterator.next();
            if (!(e instanceof DatabaseJoin)) continue;
            bl = bl || ((DatabaseJoin)e).containsTable(databaseTable);
        }
        return bl;
    }

    protected DatabaseJoin getNextJoin() {
        if (this.retriever == null) {
            if (this.elements == null || this.elements.size() == 0) {
                return null;
            }
            this.retriever = this.elements.listIterator();
        }
        if (!this.retriever.hasNext()) {
            return null;
        }
        Object object = this.retriever.next();
        while (!(object instanceof DatabaseJoin)) {
            if (!this.retriever.hasNext()) {
                return null;
            }
            object = this.retriever.next();
        }
        return (DatabaseJoin)object;
    }

    public boolean isEmpty() {
        return this.to == null && this.from == null && this.toVar == null && this.fromVar == null && (this.elements == null || this.elements.size() == 0);
    }

    public String toString() {
        String string = "";
        if (this.to != null) {
            string = string + this.to.getName();
            if (this.toVar != null) {
                string = string + ".";
            }
        }
        if (this.toVar != null) {
            string = string + this.toVar.getName();
        }
        if (this.fromVar != null && this.toVar != null) {
            string = string + "=";
        }
        if (this.from != null) {
            string = string + this.from.getName();
            if (this.fromVar != null) {
                string = string + ".";
            }
        }
        if (this.fromVar != null) {
            string = string + this.fromVar.getName();
        }
        string = string + " ";
        ListIterator listIterator = this.elements.listIterator();
        while (listIterator.hasNext()) {
            Object e = listIterator.next();
            if (e instanceof DatabaseJoin) {
                string = string + ((DatabaseJoin)e).toString() + " ";
            }
            if (!(e instanceof String)) continue;
            string = string + (String)e + " ";
        }
        return string.trim().replace("\"", "");
    }

    class InvalidJoinException
    extends Exception {
        public InvalidJoinException(String string) {
            super(string);
        }
    }
}

