/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.BooleanDCNode;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.IntervalDCNode;
import COM.hugin.HAPI.LabelledDCNode;
import COM.hugin.HAPI.NumberedDCNode;
import COM.hugin.HGUI.ChanceNode;
import COM.hugin.HGUI.DiscreteNode;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.NetworkPanel;
import COM.hugin.HGUI.Node;
import java.awt.Point;
import java.awt.geom.Ellipse2D;

public class DiscreteChanceNode
extends ChanceNode
implements DiscreteNode {
    protected static final int LABELLED = 0;
    protected static final int BOOLEAN = 1;
    protected static final int NUMBERED = 2;
    protected static final int INTERVAL = 3;
    private int subtype;

    public DiscreteChanceNode(NetworkPanel networkPanel, Point point, String string) throws ExceptionHugin {
        super(networkPanel, point, string, "");
        this.initialize(0);
    }

    public DiscreteChanceNode(NetworkPanel networkPanel, Point point, String string, String string2, int n) throws ExceptionHugin {
        super(networkPanel, point, string, string2);
        this.initialize(n);
    }

    public DiscreteChanceNode(Node node) {
        super(node);
        this.type = 1;
        this.subtype = ((DiscreteChanceNode)node).subtype;
    }

    public DiscreteChanceNode(NetworkPanel networkPanel, String string, String string2) {
        super(networkPanel, string, string2);
        this.colorAttribute = "HR_Color_DiscreteChance";
        this.type = 1;
        this.subtype = 0;
        this.shape = new Ellipse2D.Float();
        ((Ellipse2D)this.shape).setFrame(this.center.x - this.width / 2.0, this.center.y - this.height / 2.0, this.width, this.height);
    }

    public DiscreteChanceNode(NetworkPanel networkPanel, COM.hugin.HAPI.DiscreteChanceNode discreteChanceNode) {
        super(networkPanel, discreteChanceNode);
        this.colorAttribute = "HR_Color_DiscreteChance";
        this.type = 1;
        this.subtype = discreteChanceNode instanceof LabelledDCNode ? 0 : (discreteChanceNode instanceof BooleanDCNode ? 1 : (discreteChanceNode instanceof NumberedDCNode ? 2 : (discreteChanceNode instanceof IntervalDCNode ? 3 : 0)));
        this.shape = new Ellipse2D.Float();
        ((Ellipse2D)this.shape).setFrame(this.center.x - this.width / 2.0, this.center.y - this.height / 2.0, this.width, this.height);
        this.updateColor();
    }

    private void initialize(int n) throws ExceptionHugin {
        this.colorAttribute = "HR_Color_DiscreteChance";
        switch (n) {
            case 0: {
                String string = HuginGUIConstants.get("NODE_PROPERTIES_state");
                LabelledDCNode labelledDCNode = new LabelledDCNode(this.home);
                this.setAPINode(labelledDCNode);
                labelledDCNode.setNumberOfStates(2);
                labelledDCNode.setStateLabel(0, string + 1);
                labelledDCNode.setStateLabel(1, string + 2);
                break;
            }
            case 1: {
                this.setAPINode(new BooleanDCNode(this.home));
                break;
            }
            case 2: {
                NumberedDCNode numberedDCNode = new NumberedDCNode(this.home);
                this.setAPINode(numberedDCNode);
                numberedDCNode.setNumberOfStates(2);
                numberedDCNode.setStateValue(0, 1.0);
                numberedDCNode.setStateValue(1, 2.0);
                numberedDCNode.setStateLabel(0, "1");
                numberedDCNode.setStateLabel(1, "2");
                break;
            }
            case 3: {
                double d = 0.0;
                double d2 = 1.0;
                double d3 = 1.0;
                double d4 = 2.0;
                String string = HuginGUIUtils.printInterval(d, d3);
                String string2 = HuginGUIUtils.printInterval(d2, d4);
                IntervalDCNode intervalDCNode = new IntervalDCNode(this.home);
                this.setAPINode(intervalDCNode);
                intervalDCNode.setNumberOfStates(2);
                intervalDCNode.setStateValue(0, d);
                intervalDCNode.setStateValue(1, d2);
                intervalDCNode.setStateValue(2, d4);
                intervalDCNode.setStateLabel(0, string);
                intervalDCNode.setStateLabel(1, string2);
                break;
            }
        }
        this.storePosition();
        this.getAPINode().setName(this.name);
        this.getAPINode().setLabel(this.label);
        this.updateColor();
        this.type = 1;
        this.subtype = n;
        this.shape = new Ellipse2D.Float();
        ((Ellipse2D)this.shape).setFrame(this.center.x - this.width / 2.0, this.center.y - this.height / 2.0, this.width, this.height);
    }

    public void setSubtype(int n) {
        if (this.subtype != n) {
            this.panel.containsUnsavedChanges(true);
            this.subtype = n;
        }
    }

    public int getSubtype() {
        return this.subtype;
    }

    public void incrementNumberOfStates() {
        try {
            COM.hugin.HAPI.DiscreteChanceNode discreteChanceNode = (COM.hugin.HAPI.DiscreteChanceNode)this.getAPINode();
            int n = discreteChanceNode.getNumberOfStates();
            switch (this.subtype) {
                case 0: {
                    LabelledDCNode labelledDCNode = (LabelledDCNode)discreteChanceNode;
                    String string = HuginGUIConstants.get("NODE_PROPERTIES_state") + (n + 1);
                    labelledDCNode.setNumberOfStates(n + 1);
                    labelledDCNode.setStateLabel(n, string);
                    break;
                }
                case 1: {
                    new HuginGUIError(HuginGUIConstants.get("str_attempt_to_change_number_st_bool_node"));
                    return;
                }
                case 2: {
                    NumberedDCNode numberedDCNode = (NumberedDCNode)discreteChanceNode;
                    double d = numberedDCNode.getStateValue(n - 1);
                    double d2 = n > 1 ? numberedDCNode.getStateValue(n - 2) : d;
                    double d3 = Math.rint(d2);
                    double d4 = Math.rint(d);
                    int n2 = 0;
                    while (d3 != Math.pow(10.0, n2) * d2 || d4 != Math.pow(10.0, n2) * d) {
                        d3 = Math.rint(Math.pow(10.0, ++n2) * d2);
                        d4 = Math.rint(Math.pow(10.0, n2) * d);
                    }
                    double d5 = d2 != d ? (2.0 * d4 - d3) / Math.pow(10.0, n2) : d + 1.0;
                    numberedDCNode.setNumberOfStates(n + 1);
                    numberedDCNode.setStateValue(n, d5);
                    break;
                }
                case 3: {
                    IntervalDCNode intervalDCNode = (IntervalDCNode)discreteChanceNode;
                    double d = intervalDCNode.getStateValue(n - 1);
                    double d6 = intervalDCNode.getStateValue(n);
                    double d7 = Math.rint(d);
                    double d8 = Math.rint(d6);
                    int n3 = 0;
                    while (d7 != Math.pow(10.0, n3) * d || d8 != Math.pow(10.0, n3) * d6) {
                        d7 = Math.rint(Math.pow(10.0, ++n3) * d);
                        d8 = Math.rint(Math.pow(10.0, n3) * d6);
                    }
                    intervalDCNode.setNumberOfStates(n + 1);
                    intervalDCNode.setStateValue(n, d6);
                    if (d6 != Domain.INFINITY()) {
                        intervalDCNode.setStateValue(n + 1, (2.0 * d8 - d7) / Math.pow(10.0, n3));
                        break;
                    }
                    intervalDCNode.setStateValue(n + 1, Domain.INFINITY());
                }
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin.getMessage() + " : " + HuginGUIConstants.get("Most_likely_cause") + " : " + HuginGUIConstants.get("Node_Table_too_large"));
        }
    }

    public void decrementNumberOfStates() {
        try {
            COM.hugin.HAPI.DiscreteChanceNode discreteChanceNode = (COM.hugin.HAPI.DiscreteChanceNode)this.getAPINode();
            int n = discreteChanceNode.getNumberOfStates();
            if (this.subtype == 3) {
                IntervalDCNode intervalDCNode = (IntervalDCNode)discreteChanceNode;
                double d = intervalDCNode.getStateValue(n - 1);
                intervalDCNode.setStateValue(n, d);
            }
            discreteChanceNode.setNumberOfStates(n - 1);
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
        }
    }

    public int getNumberOfStates() {
        try {
            return ((COM.hugin.HAPI.DiscreteNode)this.getAPINode()).getNumberOfStates();
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
            return 0;
        }
    }

    public String[] getStates() {
        try {
            COM.hugin.HAPI.DiscreteNode discreteNode = (COM.hugin.HAPI.DiscreteNode)this.getAPINode();
            int n = discreteNode.getNumberOfStates();
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = discreteNode.getStateLabel(i);
            }
            return stringArray;
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
            return null;
        }
    }
}

