/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.DiscreteNode;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.ExceptionIO;
import COM.hugin.HAPI.ExceptionInappropriateArguments;
import COM.hugin.HAPI.ExceptionInsufficientStateRange;
import COM.hugin.HAPI.ExceptionInvalidExpression;
import COM.hugin.HAPI.IntervalDCNode;
import COM.hugin.HAPI.IntervalDDNode;
import COM.hugin.HAPI.LabelledDCNode;
import COM.hugin.HAPI.LabelledDDNode;
import COM.hugin.HAPI.Node;
import COM.hugin.HAPI.NumberedDCNode;
import COM.hugin.HAPI.NumberedDDNode;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.NodeTableModel;

public class DiscreteNodeTableModel
extends NodeTableModel {
    private DiscreteNode node;
    private boolean invalidTable;
    boolean isEditable = false;
    private int dataDisplayMode = 0;

    public void setNode(Node node) throws ExceptionHugin {
        this.node = (DiscreteNode)node;
        String string = null;
        if (node != null) {
            string = node.getAttribute("HR_Node_states");
        }
        this.dataDisplayMode = string != null && string.toLowerCase().trim().equals("labels") ? 1 : 0;
        this.generate();
        this.fireTableStructureChanged();
    }

    public void setDisplayMode(int n) throws ExceptionHugin {
        this.dataDisplayMode = n;
        this.node.setAttribute("HR_Node_states", attribValues[n]);
        this.fireTableRowsUpdated(0, this.getRowCount());
    }

    public int getDisplayMode() {
        return this.dataDisplayMode;
    }

    public void setExpressionMode(boolean bl) {
        this.expressionMode = bl;
    }

    public void invalidateModel() {
        this.invalidTable = true;
        this.fireTableRowsUpdated(0, this.getColumnCount());
    }

    public boolean getInvalidTable() {
        return this.invalidTable;
    }

    public void generate() throws ExceptionHugin {
        if (this.node == null) {
            return;
        }
        try {
            if (this.expressionMode) {
                this.node.generateTable();
            }
            this.invalidTable = false;
        }
        catch (ExceptionInvalidExpression exceptionInvalidExpression) {
            this.invalidTable = true;
            exceptionInvalidExpression.fillInStackTrace();
            throw exceptionInvalidExpression;
        }
        catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
            this.invalidTable = true;
            exceptionInappropriateArguments.fillInStackTrace();
            throw exceptionInappropriateArguments;
        }
        catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
            this.invalidTable = true;
            exceptionInsufficientStateRange.fillInStackTrace();
            throw exceptionInsufficientStateRange;
        }
        catch (ExceptionIO exceptionIO) {
            this.invalidTable = true;
            exceptionIO.fillInStackTrace();
            throw exceptionIO;
        }
        finally {
            this.fireTableStructureChanged();
        }
    }

    public Object getValueAt(int n, int n2) {
        if (this.node == null) {
            return "-";
        }
        if (!this.dataMode) {
            try {
                return HuginGUIUtils.getNodeStateLabel(this.node, n);
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }
        if (n2 < 0) {
            return "...";
        }
        if (!this.invalidTable) {
            try {
                return new Double(this.node.getTable().getDataItem(n2 * this.getRowCount() + n));
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }
        return "?";
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n2 < 0) {
            return;
        }
        if (this.node == null) {
            return;
        }
        if (!this.dataMode) {
            try {
                if (this.dataDisplayMode == 1) {
                    this.node.setStateLabel(n, object.toString());
                } else {
                    HuginGUIUtils.Interval interval;
                    if (this.node instanceof LabelledDCNode || this.node instanceof LabelledDDNode) {
                        this.node.setStateLabel(n, object.toString());
                    }
                    if (this.node instanceof NumberedDCNode || this.node instanceof NumberedDDNode) {
                        double d;
                        if (object.toString().trim().equals("inf") || object.toString().trim().equals("-inf")) {
                            d = Double.POSITIVE_INFINITY;
                            if (object.toString().trim().equals("-inf")) {
                                d = Double.NEGATIVE_INFINITY;
                            }
                        } else {
                            d = new Double(object.toString());
                        }
                        if (this.node.getLabel().trim().equals(object.toString().trim())) {
                            this.node.setStateLabel(n, HuginGUIUtils.printDouble(d, 140, false));
                        }
                        if (this.node instanceof NumberedDCNode) {
                            ((NumberedDCNode)this.node).setStateValue(n, d);
                        }
                        if (this.node instanceof NumberedDDNode) {
                            ((NumberedDDNode)this.node).setStateValue(n, d);
                        }
                    }
                    if (this.node instanceof IntervalDCNode) {
                        HuginGUIUtils.Interval interval2 = HuginGUIUtils.getInterval(object.toString().trim());
                        interval = HuginGUIUtils.getInterval(this.node.getStateLabel(n));
                        ((IntervalDCNode)this.node).setStateValue(n, interval2.lower);
                        ((IntervalDCNode)this.node).setStateValue(n + 1, interval2.upper);
                    }
                    if (this.node instanceof IntervalDDNode) {
                        HuginGUIUtils.Interval interval3 = HuginGUIUtils.getInterval(object.toString().trim());
                        interval = HuginGUIUtils.getInterval(this.node.getStateLabel(n));
                        ((IntervalDDNode)this.node).setStateValue(n, interval3.lower);
                        ((IntervalDDNode)this.node).setStateValue(n + 1, interval3.upper);
                    }
                }
                this.fireTableCellUpdated(n, n2);
                this.fireTableRowsUpdated(n - 1, n + 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        try {
            this.node.getTable().setDataItem(n2 * this.getRowCount() + n, Double.parseDouble(object.toString()));
            this.fireModelDataChanged();
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    void setDataVector(Object[][] objectArray) {
        try {
            for (int i = 0; i < objectArray.length && i < this.getRowCount(); ++i) {
                for (int j = 0; j < objectArray.length && j < this.getColumnCount(); ++j) {
                    Object object = objectArray[i][j];
                    this.node.getTable().setDataItem(j * this.getRowCount() + i, Double.parseDouble(object.toString()));
                }
            }
            this.fireModelDataChanged();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setEditable(boolean bl) {
        this.isEditable = bl;
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.isEditable) {
            return n2 >= 0;
        }
        return n2 >= 0 && !this.expressionMode;
    }

    public int getRowCount() {
        if (this.node == null) {
            return 0;
        }
        try {
            return this.node.getNumberOfStates();
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
            return 0;
        }
    }

    public void restore() {
        this.invalidTable = false;
        super.restore();
    }

    public int getColumnCount() {
        if (this.node == null) {
            return 0;
        }
        try {
            return this.node.getTable().getSize() / this.getRowCount();
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
            return 0;
        }
    }

    public void dispose() {
        this.node = null;
    }
}

