/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.DiscreteChanceNode;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.IntervalDCNode;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class DistributionPanel
extends JPanel {
    DiscreteChanceNode node;
    private static final int BARLENGTH = 200;
    private double[] values;
    private double[] stateValues;
    private String[] labels;
    private int precision = 3;
    private boolean adjustWidth = false;
    private boolean update = false;

    DistributionPanel(DiscreteChanceNode discreteChanceNode) {
        this.node = discreteChanceNode;
        this.update = true;
        this.precision = Hugin.mainFrame.preferences.precision;
    }

    DistributionPanel(IntervalDCNode intervalDCNode, double[] dArray, boolean bl) {
        this.node = null;
        this.values = dArray;
        this.adjustWidth = bl;
        this.update = false;
        this.precision = Hugin.mainFrame.preferences.precision;
        this.initLabels(intervalDCNode);
        this.initStateValues(intervalDCNode);
    }

    DistributionPanel(DiscreteChanceNode discreteChanceNode, double[] dArray) {
        this.node = null;
        this.values = dArray;
        this.update = false;
        this.precision = Hugin.mainFrame.preferences.precision;
        this.initLabels(discreteChanceNode);
    }

    DistributionPanel(String[] stringArray, double[] dArray) {
        this.node = null;
        this.values = dArray;
        this.labels = stringArray;
        this.precision = Hugin.mainFrame.preferences.precision;
        this.update = false;
    }

    public void setPrecision(int n) {
        this.precision = n;
    }

    public void setUpdate(boolean bl) {
        this.update = bl;
        if (!bl) {
            this.initLabels(this.node);
            try {
                int n = this.node.getNumberOfStates();
                this.values = new double[n];
                for (int i = 0; i < n; ++i) {
                    this.values[i] = this.node.getBelief(i);
                }
            }
            catch (ExceptionHugin exceptionHugin) {
                new HuginGUIError(exceptionHugin.getMessage());
            }
        }
    }

    private void initLabels(DiscreteChanceNode discreteChanceNode) {
        try {
            int n = discreteChanceNode.getNumberOfStates();
            this.labels = new String[n];
            for (int i = 0; i < n; ++i) {
                this.labels[i] = HuginGUIUtils.getNodeStateLabel(discreteChanceNode, i);
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception.getMessage());
        }
    }

    private void initStateValues(IntervalDCNode intervalDCNode) {
        try {
            int n = intervalDCNode.getNumberOfStates();
            this.stateValues = new double[n + 1];
            for (int i = 0; i <= n; ++i) {
                this.stateValues[i] = intervalDCNode.getStateValue(i);
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception.getMessage());
        }
    }

    private int getNumberOfStates() throws ExceptionHugin {
        if (this.update) {
            return this.node.getNumberOfStates();
        }
        return this.labels.length;
    }

    private double getBelief(int n) throws ExceptionHugin {
        if (this.update) {
            return this.node.getBelief(n);
        }
        return this.values[n];
    }

    private String getLabel(int n) throws ExceptionHugin {
        if (this.update) {
            return HuginGUIUtils.getNodeStateLabel(this.node, n);
        }
        return this.labels[n];
    }

    public Dimension getPreferredSize() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        try {
            int n4 = this.getNumberOfStates();
            for (int i = 0; i < n4; ++i) {
                double d = this.getBelief(i);
                n = Math.max(n, SwingUtilities.computeStringWidth(fontMetrics, this.getLabel(i)));
                n2 = Math.max(n2, SwingUtilities.computeStringWidth(fontMetrics, "" + HuginGUIUtils.printDouble(d, this.precision)));
            }
            n3 = 25 + 20 * n4;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return new Dimension(5 + n + 200 + 5 + n2, n3);
    }

    public void paintComponent(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        try {
            double d;
            int n;
            int n2 = 0;
            int n3 = this.getHeight() - this.getInsets().bottom - 25;
            graphics.setColor(Color.black);
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            for (n = this.getNumberOfStates() - 1; n >= 0; --n) {
                d = this.getBelief(n);
                graphics.drawString(this.getLabel(n), 5, n3);
                n2 = Math.max(n2, SwingUtilities.computeStringWidth(fontMetrics, this.getLabel(n)));
                n3 -= 20;
            }
            if (this.getNumberOfStates() > 0) {
                graphics.drawLine(n2 + 5, n3, n2 + 5, this.getHeight() - this.getInsets().bottom - 15);
                graphics.drawLine(n2, this.getHeight() - this.getInsets().bottom - 20, n2 + 200 + 10, this.getHeight() - this.getInsets().bottom - 20);
                graphics.setColor(Color.gray);
                for (n = 50; n <= 200; n += 50) {
                    graphics.drawLine(n2 + 5 + n, n3, n2 + 5 + n, this.getHeight() - this.getInsets().bottom - 15);
                }
                graphics.drawString("0", n2 + 5 - SwingUtilities.computeStringWidth(fontMetrics, "0") / 2, this.getHeight() - this.getInsets().bottom);
                graphics.drawString("", n2 + 5 + 50 - SwingUtilities.computeStringWidth(fontMetrics, "0") / 2, this.getHeight() - this.getInsets().bottom);
                graphics.drawString("1/2", n2 + 5 + 100 - SwingUtilities.computeStringWidth(fontMetrics, "1/2") / 2, this.getHeight() - this.getInsets().bottom);
                graphics.drawString("", n2 + 5 + 150 - SwingUtilities.computeStringWidth(fontMetrics, "0") / 2, this.getHeight() - this.getInsets().bottom);
                graphics.drawString("1", n2 + 5 + 200 - SwingUtilities.computeStringWidth(fontMetrics, "1") / 2, this.getHeight() - this.getInsets().bottom);
            }
            n3 = this.getHeight() - this.getInsets().bottom - 25;
            for (n = this.getNumberOfStates() - 1; n >= 0; --n) {
                d = this.getBelief(n);
                String string = HuginGUIUtils.printDouble(d, this.precision);
                graphics.setColor(Color.black);
                graphics.drawString("" + string, n2 + 5 + 200 + 5, n3);
                graphics.setColor(Color.green);
                int n4 = n2 + 5 + 1;
                int n5 = n3 - 12;
                int n6 = (int)(200.0 * d);
                int n7 = 15;
                if (this.adjustWidth) {
                    double d2 = this.stateValues[n + 1] - this.stateValues[n];
                    graphics.fillRect(n4, n5, n6, n7);
                } else {
                    graphics.fillRect(n4, n5, n6, n7);
                }
                n3 -= 20;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

