/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.BooleanDCNode;
import COM.hugin.HAPI.BooleanDDNode;
import COM.hugin.HAPI.Class;
import COM.hugin.HAPI.ContinuousChanceNode;
import COM.hugin.HAPI.DiscreteChanceNode;
import COM.hugin.HAPI.DiscreteDecisionNode;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.LabelledDCNode;
import COM.hugin.HAPI.LabelledDDNode;
import COM.hugin.HAPI.NetworkModel;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HAPI.NumberedDCNode;
import COM.hugin.HAPI.NumberedDDNode;
import COM.hugin.HAPI.UtilityNode;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginFileLoader;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIFrame;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.ImageExporter;
import COM.hugin.HGUI.InstanceNode;
import COM.hugin.HGUI.NetworkPanel;
import COM.hugin.HGUI.Node;
import COM.hugin.HGUI.NodeGroup;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Documentor {
    public static File path;
    static String htmlEnabled;
    NetworkPanel panel;
    String imagePathName;
    protected static final int DOCUMENTATION_ALL = 0;
    protected static final int DOCUMENTATION_NET = 1;
    protected static final int DOCUMENTATION_TABLE = 2;
    public static boolean generateDoc;
    static LinkedList<NetworkModel> documentedClasses;

    public Documentor(NetworkPanel networkPanel) {
        this.panel = networkPanel;
    }

    public String document() throws ExceptionHugin, FileNotFoundException {
        HuginFileLoader huginFileLoader = new HuginFileLoader(10, Hugin.mainFrame.getMostRecentDataFile(), 5);
        if (huginFileLoader.showSaveDialog(Hugin.mainFrame) == 0) {
            File file;
            path = huginFileLoader.getSelectedFile();
            String string = path.getPath();
            int n = string.lastIndexOf(System.getProperty("file.separator"));
            if (n >= 0) {
                string = string.substring(n + 1);
            }
            if ((n = string.lastIndexOf(".")) > 0) {
                string = string.substring(0, n);
            }
            if ((file = path.getParentFile()) == null) {
                file = new File("/");
            }
            this.imagePathName = string + "_images";
            String string2 = this.document(this.panel.getHome(), 0);
            PrintWriter printWriter = null;
            try {
                printWriter = new PrintWriter(path, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                new HuginGUIError(unsupportedEncodingException.getMessage() + HuginGUIConstants.get("str_lb_lb_using_default_encoding"));
                printWriter = new PrintWriter(path);
            }
            printWriter.println(string2);
            printWriter.close();
            file = new File(file.getPath() + "/" + this.imagePathName);
            file.mkdir();
            try {
                Documentor.generateImages(this.panel, file.getPath() + "/");
            }
            catch (Exception exception) {
                new HuginGUIError(HuginGUIConstants.get("str_unable_to_generate_images_lb") + exception.getMessage());
            }
            return path.toString();
        }
        return null;
    }

    protected String document(NetworkModel networkModel, int n) throws ExceptionHugin {
        String string = networkModel instanceof Domain ? "Domain" : ((Class)networkModel).getName();
        String string2 = "<html><head><title>" + HuginGUIConstants.get("str_network_docuementation_") + string + "</title></head>\n";
        string2 = string2 + "<body>\n";
        TableOfContents tableOfContents = new TableOfContents(3);
        String string3 = this.documentModel(networkModel, n, tableOfContents);
        if (generateDoc) {
            string2 = string2 + tableOfContents + "<p>\n\n";
        }
        string2 = string2 + string3;
        string2 = string2 + "\n\n<HR>\n";
        string2 = string2 + "<center>" + HuginGUIConstants.get("str_created_on_") + new Date() + "</center>\n";
        string2 = string2 + "</body><html>";
        return string2;
    }

    protected String documentModel(NetworkModel networkModel, int n, TableOfContents tableOfContents) throws ExceptionHugin {
        Object object;
        Iterator iterator;
        Object object2;
        Iterator iterator2;
        Cloneable cloneable2;
        documentedClasses.add(networkModel);
        String string = networkModel instanceof Domain ? "Domain" : ((Class)networkModel).getName();
        String string2 = "Class-" + string;
        String string3 = "<Table width=100% bgcolor=#aaaaee><tr><td>\n";
        string3 = string3 + tableOfContents.addEntry(1, string, string2) + "\n";
        string3 = string3 + "</td></tr></table>\n";
        string3 = string3 + "<table width=100%><tr><td width=3%></td><td>\n";
        String string4 = networkModel.getAttribute("HR_Desc");
        htmlEnabled = networkModel.getAttribute("HR_Html_Desc");
        string3 = string4 == null || string4.trim().length() == 0 ? string3 + HuginGUIConstants.get("str_no_description") + "<p>\n\n" : string3 + string4 + "<p>\n\n";
        string3 = string3 + "<p>\n";
        string3 = string3 + HuginGUIConstants.get("str_the_model_is_depicted_below_") + "<p>\n";
        string3 = string3 + "<image SRC=\"" + this.imagePathName + "/" + string + ".bmp\" BORDER=\"0\" ALT=\"" + string + "\"" + "USEMAP=#" + string + "_image_map><p>\n";
        string3 = string3 + "<MAP NAME=\"" + string + "_image_map\">";
        NetworkPanel networkPanel = HuginGUIFrame.getProjectFrame(networkModel).getNetworkPanel();
        double d = networkPanel.getScaleFactor();
        Rectangle rectangle = networkPanel.getBoundingBox();
        Point point = new Point((int)rectangle.getX(), (int)rectangle.getY());
        for (Cloneable cloneable2 : networkModel.getNodes()) {
            if (((COM.hugin.HAPI.Node)cloneable2).getMaster() != null) continue;
            string3 = string3 + Documentor.getAreaFor((COM.hugin.HAPI.Node)cloneable2, point, d) + "\n";
        }
        string3 = string3 + " </MAP>";
        LinkedList linkedList = new LinkedList();
        cloneable2 = new ArrayList();
        String string5 = networkModel.getAttribute("HR_Groups_IDs");
        if (string5 == null) {
            string5 = "";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string5, ",");
        while (stringTokenizer.hasMoreTokens()) {
            iterator2 = stringTokenizer.nextToken();
            object2 = networkModel.getAttribute("HR_Group_" + (String)((Object)iterator2) + "_Name");
            iterator = networkModel.getAttribute("HR_Group_" + (String)((Object)iterator2) + "_Color");
            object = networkModel.getAttribute("HR_Group_" + (String)((Object)iterator2) + "_Description");
            try {
                int n2 = Integer.parseInt((String)((Object)iterator2));
                int n3 = Integer.parseInt((String)((Object)iterator));
                NodeGroup nodeGroup = new NodeGroup((String)object2, n3, n2);
                nodeGroup.setDescription((String)object);
                linkedList.add(nodeGroup);
            }
            catch (Exception exception) {}
        }
        try {
            if (linkedList.size() > 0) {
                string3 = string3 + "<table bgcolor=#ccccee width=100%><tr><td>" + tableOfContents.addEntry(2, "Groups", "Groups") + "</td></tr></table>\n";
                string3 = string3 + "<table width=100%><tr><td width=3%></td><td>\n";
                string3 = string3 + HuginGUIConstants.get("str_the_nodes_can_be_ass_to_the_following_grp_");
                string3 = string3 + "<TABLE>\n";
                iterator2 = linkedList.iterator();
                while (iterator2.hasNext()) {
                    object2 = (NodeGroup)iterator2.next();
                    iterator = ((NodeGroup)object2).getColor();
                    object = Integer.toHexString(((Color)((Object)iterator)).getRed());
                    String string6 = Integer.toHexString(((Color)((Object)iterator)).getGreen());
                    String string7 = Integer.toHexString(((Color)((Object)iterator)).getBlue());
                    if (((String)object).length() == 1) {
                        object = "0" + (String)object;
                    }
                    if (string6.length() == 1) {
                        string6 = "0" + string6;
                    }
                    if (string7.length() == 1) {
                        string7 = "0" + string7;
                    }
                    string3 = string3 + "<TR><TD WIDTH=10></TD><TD BORDER=\"1\" BGCOLOR=\"#" + (String)object + string6 + string7 + "\" WIDTH=10></TD>" + "<TD>" + object2 + "</TD></TR>\n";
                }
                string3 = string3 + "\n</TABLE>\n";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        cloneable2 = new ArrayList<COM.hugin.HAPI.Node>(networkModel.getNodes());
        iterator2 = new Comparator<COM.hugin.HAPI.Node>(){

            @Override
            public int compare(COM.hugin.HAPI.Node node, COM.hugin.HAPI.Node node2) {
                try {
                    return HuginGUIUtils.compareNodes(node, node2, 1);
                }
                catch (Exception exception) {
                    return -1;
                }
            }
        };
        Collections.sort(cloneable2, iterator2);
        if (linkedList.size() > 0) {
            object2 = new NodeGroup("", 0);
            iterator = ((ArrayList)cloneable2).iterator();
            while (iterator.hasNext()) {
                object = (COM.hugin.HAPI.Node)iterator.next();
                if (((COM.hugin.HAPI.Node)object).getMaster() != null) continue;
                NodeGroup nodeGroup = Documentor.getGroupFor((COM.hugin.HAPI.Node)object, linkedList);
                if (object2 != null && !((NodeGroup)object2).equals(nodeGroup)) {
                    string3 = string3 + "</UL>\n";
                    object2 = nodeGroup;
                    if (object2 != null) {
                        string3 = string3 + "<table bgcolor=#ddddee width=100%><tr><td>" + tableOfContents.addEntry(3, ((NodeGroup)object2).getName(), "group-" + ((NodeGroup)object2).getName()) + "</td></tr></table>\n";
                        String string8 = ((NodeGroup)object2).getDescription();
                        string3 = string8 == null || string8.trim().length() == 0 ? string3 + "No description\n<p>\n" : string3 + string8 + "\n<p>\n";
                        string3 = string3 + HuginGUIConstants.get("str_the_following_nodes_are_assigned_to_") + ((NodeGroup)object2).getName() + ":\n";
                        string3 = string3 + "<UL>\n";
                    } else {
                        string3 = string3 + "<table bgcolor=#ddddee width=100%><tr><td>" + tableOfContents.addEntry(3, HuginGUIConstants.get("NODE_PROPERTIES_no_group"), "group-" + HuginGUIConstants.get("NODE_PROPERTIES_no_group")) + "</td></tr></table>\n";
                        string3 = string3 + HuginGUIConstants.get("str_the_following_nodes_are_not_part_of_any_group_lb");
                        string3 = string3 + "<UL>\n";
                    }
                }
                string3 = string3 + "<LI><a href=\"#" + ((COM.hugin.HAPI.Node)object).getHome() + "-" + ((COM.hugin.HAPI.Node)object).getName() + "\">" + HuginGUIUtils.getNodeTitle((COM.hugin.HAPI.Node)object, 0) + "</a>\n";
            }
            string3 = string3 + "</UL>\n";
        }
        string2 = string + "-Nodes";
        string3 = string3 + "</td></tr></table>\n";
        string3 = string3 + "<table bgcolor=#ccccee width=100%><tr><td>" + tableOfContents.addEntry(2, "Nodes", string2) + "</td></tr></table>\n";
        string3 = string3 + "<table width=100%><tr><td width=3%></td><td>\n";
        int n4 = 1;
        iterator = ((ArrayList)cloneable2).iterator();
        while (iterator.hasNext()) {
            object = (COM.hugin.HAPI.Node)iterator.next();
            if (((COM.hugin.HAPI.Node)object).getMaster() != null) continue;
            if (object instanceof DiscreteChanceNode) {
                string3 = string3 + Documentor.documentDCNode((DiscreteChanceNode)object, tableOfContents);
            } else if (object instanceof DiscreteDecisionNode) {
                string3 = string3 + Documentor.documentDDNode((DiscreteDecisionNode)object, tableOfContents);
            } else if (object instanceof ContinuousChanceNode) {
                string3 = string3 + Documentor.documentCCNode((ContinuousChanceNode)object, tableOfContents);
            } else if (object instanceof UtilityNode) {
                string3 = string3 + Documentor.documentUTNode((UtilityNode)object, tableOfContents);
            } else if (object instanceof COM.hugin.HAPI.InstanceNode) {
                string3 = string3 + this.documentInstanceNode((COM.hugin.HAPI.InstanceNode)object, n, tableOfContents);
            }
            ++n4;
        }
        iterator = ((ArrayList)cloneable2).iterator();
        while (iterator.hasNext()) {
            Class clazz;
            object = (COM.hugin.HAPI.Node)iterator.next();
            if (!(object instanceof COM.hugin.HAPI.InstanceNode) || documentedClasses.contains(clazz = ((COM.hugin.HAPI.InstanceNode)object).getInstanceClass())) continue;
            string3 = string3 + this.documentModel(clazz, n, tableOfContents) + "</td></tr></table>\n";
        }
        string3 = string3 + "</td></tr></table>\n";
        return string3;
    }

    private static NodeGroup getGroupFor(COM.hugin.HAPI.Node node, LinkedList<NodeGroup> linkedList) throws ExceptionHugin {
        String string = node.getAttribute("HR_Group");
        if (string != null) {
            try {
                return linkedList.get(linkedList.indexOf(new NodeGroup("", Integer.parseInt(string))));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static String documentDCNode(DiscreteChanceNode discreteChanceNode, TableOfContents tableOfContents) throws ExceptionHugin {
        String string = "";
        String string2 = discreteChanceNode.getHome() + "-" + discreteChanceNode.getName();
        string = string + "<table bgcolor=#ddddee width=100%><tr><td>" + tableOfContents.addEntry(3, HuginGUIUtils.getNodeTitle((COM.hugin.HAPI.Node)discreteChanceNode, 0), string2) + "</td></tr></table>\n";
        String string3 = "";
        string3 = htmlEnabled != null && htmlEnabled.equals("0") ? discreteChanceNode.getAttribute("HR_Desc") : discreteChanceNode.getAttribute("HR_HTML_Desc");
        string = string3 == null || string3.trim().length() == 0 ? string + HuginGUIConstants.get("str_no_description") + "<p>\n\n" : string + string3 + "<p>\n\n";
        string = string + "<table border=\"0\">\n";
        string = string + "<tr><td>Name</td><td>= <it>" + discreteChanceNode.getName() + "</it></td></tr>\n";
        string = string + "<tr><td>Label</td><td>= " + discreteChanceNode.getLabel() + "</td></tr>\n";
        string = string + "<tr><td>Type</td><td>" + HuginGUIConstants.get("str_eq_discrete") + (discreteChanceNode instanceof LabelledDCNode ? HuginGUIConstants.get("str_labelled") : (discreteChanceNode instanceof BooleanDCNode ? HuginGUIConstants.get("str_boolean") : (discreteChanceNode instanceof NumberedDCNode ? HuginGUIConstants.get("str_numbered") : HuginGUIConstants.get("str_Interval")))) + HuginGUIConstants.get("str__node") + "</td></tr>\n";
        string = string + "</table>";
        string = string + "<H4>" + HuginGUIConstants.get("str_states") + "</H4>\n";
        string = string + "<table border=\"0\">\n";
        int n = discreteChanceNode.getNumberOfStates();
        for (int i = 0; i < n; ++i) {
            string = string + "<tr><td>" + HuginGUIUtils.getNodeStateLabel(discreteChanceNode, i) + "</td><td>";
            string3 = discreteChanceNode.getAttribute("HR_State_" + i);
            string = string3 == null || string3.trim().length() == 0 ? string + ": " + HuginGUIConstants.get("str_no_description") + "</td></tr>\n" : string + ": " + string3 + "</td></tr>\n";
        }
        string = string + "</table>\n";
        NodeList nodeList = discreteChanceNode.getParents();
        string = string + Documentor.documentParents(nodeList);
        return string;
    }

    private static String documentDDNode(DiscreteDecisionNode discreteDecisionNode, TableOfContents tableOfContents) throws ExceptionHugin {
        String string = "";
        String string2 = discreteDecisionNode.getHome() + "-" + discreteDecisionNode.getName();
        string = string + "<table bgcolor=#ddddee width=100%><tr><td>" + tableOfContents.addEntry(3, HuginGUIUtils.getNodeTitle((COM.hugin.HAPI.Node)discreteDecisionNode, 0), string2) + "</td></tr></table>\n";
        String string3 = "";
        string3 = htmlEnabled != null && htmlEnabled.equals("0") ? discreteDecisionNode.getAttribute("HR_Desc") : discreteDecisionNode.getAttribute("HR_HTML_Desc");
        string = string3 == null || string3.trim().length() == 0 ? string + HuginGUIConstants.get("str_no_description") + "<p>\n\n" : string + string3 + "<p>\n\n";
        string = string + "<table border=\"0\">\n";
        string = string + "<tr><td>" + HuginGUIConstants.get("str_name") + "</td><td>= " + discreteDecisionNode.getName() + "</td></tr>\n";
        string = string + "<tr><td>" + HuginGUIConstants.get("str_label") + "</td><td>= " + discreteDecisionNode.getLabel() + "</td></tr>\n";
        string = string + "<tr><td>" + HuginGUIConstants.get("str_type") + "</td><td>= " + HuginGUIConstants.get("str_discrete") + " " + (discreteDecisionNode instanceof LabelledDDNode ? HuginGUIConstants.get("str_labelled") : (discreteDecisionNode instanceof BooleanDDNode ? HuginGUIConstants.get("str_boolean") : (discreteDecisionNode instanceof NumberedDDNode ? HuginGUIConstants.get("str_numbered") : HuginGUIConstants.get("str_Interval")))) + HuginGUIConstants.get("str__node") + "</td></tr>\n";
        string = string + "</table>";
        string = string + "<H4>" + HuginGUIConstants.get("str_states") + "</H4>\n";
        string = string + "<table border=\"0\">\n";
        int n = discreteDecisionNode.getNumberOfStates();
        for (int i = 0; i < n; ++i) {
            string = string + "<tr><td>" + HuginGUIUtils.getNodeStateLabel(discreteDecisionNode, i) + "</td><td>";
            string3 = discreteDecisionNode.getAttribute("HR_State_" + i);
            string = string3 == null || string3.trim().length() == 0 ? string + ": " + HuginGUIConstants.get("str_no_description") + "</td></tr>\n" : string + ": " + string3 + "</td></tr>\n";
        }
        string = string + "</table>\n";
        NodeList nodeList = discreteDecisionNode.getParents();
        string = string + Documentor.documentParents(nodeList);
        return string;
    }

    private static String documentCCNode(ContinuousChanceNode continuousChanceNode, TableOfContents tableOfContents) throws ExceptionHugin {
        String string = "";
        String string2 = continuousChanceNode.getHome() + "-" + continuousChanceNode.getName();
        string = string + "<table bgcolor=#ddddee width=100%><tr><td>" + tableOfContents.addEntry(3, HuginGUIUtils.getNodeTitle((COM.hugin.HAPI.Node)continuousChanceNode, 0), string2) + "</td></tr></table>\n";
        String string3 = "";
        string3 = htmlEnabled != null && htmlEnabled.equals("0") ? continuousChanceNode.getAttribute("HR_Desc") : continuousChanceNode.getAttribute("HR_HTML_Desc");
        string = string3 == null || string3.trim().length() == 0 ? string + HuginGUIConstants.get("str_no_description") + "<p>\n\n" : string + string3 + "<p>\n\n";
        string = string + "<table border=\"0\">\n";
        string = string + "<tr><td>Name</td><td>= <it>" + continuousChanceNode.getName() + "</it></td></tr>\n";
        string = string + "<tr><td>Label</td><td>= " + continuousChanceNode.getLabel() + "</td></tr>\n";
        string = string + "</table>";
        NodeList nodeList = continuousChanceNode.getParents();
        string = string + Documentor.documentParents(nodeList);
        return string;
    }

    private static String documentUTNode(UtilityNode utilityNode, TableOfContents tableOfContents) throws ExceptionHugin {
        String string = "";
        String string2 = utilityNode.getHome() + "-" + utilityNode.getName();
        string = string + "<table bgcolor=#ddddee width=100%><tr><td>" + tableOfContents.addEntry(3, HuginGUIUtils.getNodeTitle((COM.hugin.HAPI.Node)utilityNode, 0), string2) + "</td></tr></table>\n";
        String string3 = "";
        string3 = htmlEnabled != null && htmlEnabled.equals("0") ? utilityNode.getAttribute("HR_Desc") : utilityNode.getAttribute("HR_HTML_Desc");
        string = string3 == null || string3.trim().length() == 0 ? string + HuginGUIConstants.get("str_no_description") + "<p>\n\n" : string + string3 + "<p>\n\n";
        string = string + "<table border=\"0\">\n";
        string = string + "<tr><td>Name</td><td>= <it>" + utilityNode.getName() + "</it></td></tr>\n";
        string = string + "<tr><td>Label</td><td>= " + utilityNode.getLabel() + "</td></tr>\n";
        string = string + "</table>";
        NodeList nodeList = utilityNode.getParents();
        string = string + Documentor.documentParents(nodeList);
        return string;
    }

    private String documentInstanceNode(COM.hugin.HAPI.InstanceNode instanceNode, int n, TableOfContents tableOfContents) throws ExceptionHugin {
        String string = "";
        String string2 = instanceNode.getHome() + "-" + instanceNode.getName();
        string = string + "<table bgcolor=#ddddee width=100%><tr><td>" + tableOfContents.addEntry(3, HuginGUIUtils.getNodeTitle((COM.hugin.HAPI.Node)instanceNode, 0), string2) + "</td></tr></table>\n";
        String string3 = "";
        string3 = htmlEnabled != null && htmlEnabled.equals("0") ? instanceNode.getAttribute("HR_Desc") : instanceNode.getAttribute("HR_HTML_Desc");
        string = string3 == null || string3.trim().length() == 0 ? string + HuginGUIConstants.get("str_no_description") + "<p>\n\n" : string + string3 + "<p>\n\n";
        String string4 = instanceNode.getInstanceClass().getName();
        string = string + "<a href=\"#Class-" + string4 + "\"><image SRC=\"" + this.imagePathName + "/node-" + instanceNode.getName() + ".bmp\" BORDER=\"0\" ALT=\"" + HuginGUIUtils.getNodeTitle((COM.hugin.HAPI.Node)instanceNode, 2) + "\"></a><p>\n";
        string = string + "<table border=\"0\">\n";
        string = string + "<tr><td>" + HuginGUIConstants.get("str_name") + "</td><td> = " + instanceNode.getName() + "</td></tr>\n";
        string = string + "<tr><td>" + HuginGUIConstants.get("str_label") + "</td><td> = " + instanceNode.getLabel() + "</td></tr>\n";
        string = string + "<tr><td>" + HuginGUIConstants.get("str_instantiated_from_") + "</td><td> " + "<a href=\"#Class-" + string4 + "\">" + string4 + "</a></td></tr>\n";
        string = string + "</table>\n";
        return string;
    }

    private static String documentParents(NodeList nodeList) throws ExceptionHugin {
        String string = "";
        if (nodeList.size() > 0) {
            string = string + "<H4>" + HuginGUIConstants.get("str_parents") + "</H4>\n";
            string = string + "<UL>\n";
            for (COM.hugin.HAPI.Node node : nodeList) {
                COM.hugin.HAPI.Node node2 = node.getMaster();
                if (node2 != null) {
                    string = string + "<LI><a href=\"#" + node2.getHome() + "-" + node2.getName() + "\">" + HuginGUIUtils.getNodeTitle(node.getInstance(), 0) + "." + HuginGUIUtils.getNodeTitle(node2, 0) + "</a>\n";
                    continue;
                }
                string = string + "<LI><a href=\"#" + node.getHome() + "-" + node.getName() + "\">" + HuginGUIUtils.getNodeTitle(node, 0) + "</a>\n";
            }
            string = string + "</UL>\n";
        }
        return string;
    }

    public static void generateImages(NetworkPanel networkPanel, String string) throws ExceptionHugin, FileNotFoundException, UnsupportedEncodingException {
        String string2 = networkPanel.getHome() instanceof Domain ? "Domain" : ((Class)networkPanel.getHome()).getName();
        File file = new File(string + string2 + ".bmp");
        ImageExporter.printPanel2BMP(networkPanel, file);
        for (Node node : networkPanel.nodeList) {
            if (!(node instanceof InstanceNode)) continue;
            file = new File(string + "node-" + node.getAPINode().getName() + ".bmp");
            ImageExporter.printNode2BMP(node, file);
            NetworkPanel networkPanel2 = HuginGUIFrame.getProjectFrame(((COM.hugin.HAPI.InstanceNode)node.getAPINode()).getInstanceClass()).getNetworkPanel();
            Documentor.generateImages(networkPanel2, string);
        }
    }

    private static String getAreaFor(COM.hugin.HAPI.Node node, Point point, double d) throws ExceptionHugin {
        Point2D point2D = node.getPosition();
        int n = (int)(point2D.getX() - point.getX());
        int n2 = (int)(point2D.getY() - point.getY());
        Dimension dimension = HuginGUIUtils.getNodeSize(node);
        return " <AREA COORDS=\"" + (int)(((double)n - dimension.getWidth() / 2.0) / d) + "," + (int)(((double)n2 - dimension.getHeight() / 2.0) / d) + "," + (int)(((double)n + dimension.getWidth() / 2.0) / d) + "," + (int)(((double)n2 + dimension.getHeight() / 2.0) / d) + "," + "\" href=\"#" + node.getHome() + "-" + node.getName() + "\" ALT=\"" + HuginGUIUtils.getNodeTitle(node, 0) + "\">";
    }

    static {
        generateDoc = false;
        documentedClasses = new LinkedList();
    }

    private static class TableOfContents {
        private int levels = 3;
        private LinkedList<Entry> entries;
        private int[] currentEntry;
        boolean showIndex = false;

        public TableOfContents(int n) {
            if (n >= 0) {
                this.levels = n;
            }
            this.currentEntry = new int[n];
            for (int i = 0; i < n; ++i) {
                this.currentEntry[i] = 0;
            }
            this.entries = new LinkedList();
        }

        public String addEntry(int n, String string, String string2) {
            int n2 = n - 1;
            this.currentEntry[n2] = this.currentEntry[n2] + 1;
            for (int i = n; i < this.currentEntry.length; ++i) {
                this.currentEntry[i] = 0;
            }
            Entry entry = new Entry(this.printEntry(), string, string2);
            this.entries.add(entry);
            return "<H" + n + "><a name=" + string2 + ">" + (this.showIndex ? entry.getIndex() + " " : "") + entry.getTitle() + "</a></H" + n + ">";
        }

        private String printEntry() {
            int n;
            String string = "";
            for (n = this.currentEntry.length - 1; n >= 0 && this.currentEntry[n] == 0; --n) {
            }
            for (int i = 0; i <= n; ++i) {
                string = string + this.currentEntry[i] + ".";
            }
            return string;
        }

        public String toString() {
            String string = "<H1>" + HuginGUIConstants.get("str_table_of_contents") + "</H1>\n<TABLE>\n";
            for (Entry entry : this.entries) {
                string = string + "<TR><TD>" + (this.showIndex ? entry.getIndex() : "") + "<a href=\"#" + entry.getAnchor() + "\">" + entry.getTitle() + "</a></TD></TR>\n";
            }
            return string + "</TABLE>\n\n";
        }

        private class Entry {
            private String index;
            private String title;
            private String anchor;

            public Entry(String string, String string2, String string3) {
                this.index = string;
                this.title = string2;
                this.anchor = string3;
            }

            public String getIndex() {
                return this.index;
            }

            public String getTitle() {
                return this.title;
            }

            public String getAnchor() {
                return this.anchor;
            }
        }
    }
}

