/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.Class;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.ExceptionInvalidExpression;
import COM.hugin.HAPI.ExceptionMemory;
import COM.hugin.HAPI.Node;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.LogFileView;
import COM.hugin.HGUI.NumberField;
import COM.hugin.HGUI.NumberFieldInt;
import COM.hugin.HGUI.WizardPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class EMLearningPanel
extends WizardPanel {
    int nextButtonIndex = -1;
    Domain domain = null;
    int missingCases;
    NumberField convergenceThreshold;
    NumberFieldInt numberOfIterations;
    JTextArea emInfo;
    JCheckBox skipEM;

    public EMLearningPanel(Domain domain, JButton[] jButtonArray, int n, int n2) {
        super("EM-Learning", jButtonArray);
        this.setImage(Toolkit.getDefaultToolkit().createImage(ClassLoader.getSystemResource("images/em_learning.jpg")));
        this.nextButtonIndex = n;
        this.domain = domain;
        this.missingCases = n2;
        this.setInterior(this.createInterior());
        this.addComponents();
    }

    private Component createInterior() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 10));
        this.numberOfIterations = new NumberFieldInt(new Integer(0));
        this.numberOfIterations.setHorizontalAlignment(4);
        this.numberOfIterations.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                boolean bl = EMLearningPanel.this.enableFinish();
                EMLearningPanel.this.buttons[EMLearningPanel.this.nextButtonIndex].setEnabled(bl);
                EMLearningPanel.this.emInfo.setEnabled(bl);
            }
        });
        jPanel2.add(new JLabel("Number of iterations"));
        jPanel2.add(this.numberOfIterations);
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 5, 10));
        this.convergenceThreshold = new NumberField(new Double(1.0E-4));
        this.convergenceThreshold.setHorizontalAlignment(4);
        this.convergenceThreshold.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                boolean bl = EMLearningPanel.this.enableFinish();
                EMLearningPanel.this.buttons[EMLearningPanel.this.nextButtonIndex].setEnabled(bl);
                EMLearningPanel.this.emInfo.setEnabled(bl);
            }
        });
        jPanel3.add(new JLabel("Convergence threshold"));
        jPanel3.add(this.convergenceThreshold);
        JPanel jPanel4 = new JPanel(new GridLayout(2, 1));
        jPanel4.add(jPanel2);
        jPanel4.add(jPanel3);
        JPanel jPanel5 = new JPanel(new FlowLayout(0, 5, 50));
        jPanel5.add(jPanel4);
        JPanel jPanel6 = new JPanel(new BorderLayout());
        this.emInfo = new JTextArea("The Learning Wizard is now ready to perform the last part of the learning process: The EM-Learning.\nIn this process, the Learning Wizard will extract the conditional distributions from the data.");
        this.emInfo.setLineWrap(true);
        this.emInfo.setWrapStyleWord(true);
        this.emInfo.setEditable(false);
        this.emInfo.setBackground(jPanel.getBackground());
        jPanel6.add((Component)this.emInfo, "North");
        LogFileView logFileView = null;
        try {
            logFileView = new LogFileView(this.domain);
            jPanel6.add(logFileView);
        }
        catch (Exception exception) {
            new HuginGUIError(exception.getMessage());
        }
        this.skipEM = new JCheckBox("Skip EM-learning");
        jPanel.add((Component)jPanel5, "North");
        jPanel.add(jPanel6);
        jPanel.add((Component)this.skipEM, "South");
        return jPanel;
    }

    public void back() {
        this.previous.reInitialize();
    }

    public int getNumberOfIterations() {
        return this.numberOfIterations.getInt();
    }

    public double getConvergenceThreshold() {
        return this.convergenceThreshold.getNumber();
    }

    public void learnTables() throws ExceptionHugin {
        if (this.skipEM.isSelected()) {
            return;
        }
        HuginGUIUtils.configureDomain(this.domain);
        this.domain.setMaxNumberOfEMIterations(this.getNumberOfIterations());
        this.domain.setLogLikelihoodTolerance(this.getConvergenceThreshold());
        boolean bl = false;
        if (this.domain.isCompiled()) {
            this.domain.initialize();
        }
        while (!bl) {
            int n;
            bl = true;
            try {
                this.domain.generateTables();
                if (this.domain.isCompiled()) continue;
                String string = this.domain.getAttribute("HR_Compile_TriangMethod");
                n = 0;
                if (string != null && string.length() > 0) {
                    n = Integer.parseInt(string);
                }
                switch (n) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.domain.triangulate(Domain.H_TM_CLIQUE_SIZE);
                        break;
                    }
                    case 2: {
                        this.domain.triangulate(Domain.H_TM_CLIQUE_WEIGHT);
                        break;
                    }
                    case 3: {
                        this.domain.triangulate(Domain.H_TM_FILL_IN_SIZE);
                        break;
                    }
                    case 4: {
                        this.domain.triangulate(Domain.H_TM_FILL_IN_WEIGHT);
                        break;
                    }
                    case 5: {
                        String string2 = this.domain.getAttribute("HR_Compile_MaxMinimalSeparators");
                        int n2 = Integer.parseInt("100000");
                        if (string2 != null) {
                            n2 = Integer.parseInt(string2);
                        }
                        this.domain.setMaxNumberOfSeparators(n2);
                        this.domain.triangulate(Domain.H_TM_TOTAL_WEIGHT);
                        break;
                    }
                    case 7: {
                        this.domain.triangulate(Domain.H_TM_BEST_GREEDY);
                    }
                }
                HuginGUIUtils.configureDomain(this.domain);
                this.domain.compile();
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                n = JOptionPane.showConfirmDialog(Hugin.mainFrame, HuginGUIConstants.get("MISCELLANEOUS_Erase_expressions"), HuginGUIConstants.get("str_question"), 0, 3, null);
                if (n == 1) {
                    throw exceptionInvalidExpression;
                }
                for (Node node : this.domain.getNodes()) {
                    if (node.getModel() == null) continue;
                    node.getModel().delete();
                }
                bl = false;
            }
        }
        try {
            this.domain.saveToMemory();
        }
        catch (ExceptionMemory exceptionMemory) {
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        System.out.println("num cases " + this.domain.getNumberOfCases());
        if (this.domain.getUserData() instanceof Class) {
            this.domain.learnClassTables();
        } else {
            this.domain.learnTables();
        }
        Hugin.mainFrame.statusBar.write(HuginGUIConstants.get("EMLearning_log_likelihood") + HuginGUIUtils.printDouble(this.domain.getLogLikelihood(), 1) + "\n" + HuginGUIConstants.get("EMLearning_AIC") + HuginGUIUtils.printDouble(this.domain.getAIC(), 1) + "\n" + HuginGUIConstants.get("EMLearning_BIC") + HuginGUIUtils.printDouble(this.domain.getBIC(), 1), true);
    }

    public Domain getDomain() {
        return this.domain;
    }

    private boolean enableFinish() {
        return this.numberOfIterations.isNumber() && this.convergenceThreshold.isNumber() && this.convergenceThreshold.getNumber() > 0.0;
    }
}

