/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HGUI.CaseFileViewer;
import COM.hugin.HGUI.DataStream;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginFileLoader;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.PastingTextField;
import COM.hugin.HGUI.Preferences;
import COM.hugin.HGUI.TextfileDataSource;
import COM.hugin.HGUI.TitledPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class EMLearningSetupPane
extends JDialog {
    EMLearningSetupPane self = this;
    PastingTextField numberIterations;
    PastingTextField convergensThreshold;
    Domain domain;
    JButton view_data;
    JButton ok;
    JButton clear_data;
    File file;
    JLabel fileNameLabel;
    Preferences preferences;
    boolean pressedOK = false;

    public EMLearningSetupPane(Domain domain, Preferences preferences) {
        super(Hugin.mainFrame, HuginGUIConstants.get("EMLearning"), true);
        this.domain = domain;
        this.preferences = preferences;
        try {
            TitledPanel titledPanel = new TitledPanel(HuginGUIConstants.get("EMLearning_parameters_for_learning"));
            JPanel jPanel = new JPanel(new GridLayout(3, 2, 5, 5));
            jPanel.add(new JLabel(HuginGUIConstants.get("StructuralLearning_data_file")));
            this.fileNameLabel = new JLabel("");
            jPanel.add(this.fileNameLabel);
            this.numberIterations = new PastingTextField("" + domain.getMaxNumberOfEMIterations());
            this.numberIterations.setHorizontalAlignment(4);
            this.convergensThreshold = new PastingTextField("" + domain.getLogLikelihoodTolerance());
            this.convergensThreshold.setHorizontalAlignment(4);
            jPanel.add(new JLabel(HuginGUIConstants.get("EMLearning_number_of_iterations")));
            jPanel.add(this.numberIterations);
            jPanel.add(new JLabel(HuginGUIConstants.get("EMLearning_convergens_threshold")));
            jPanel.add(this.convergensThreshold);
            JPanel jPanel2 = new JPanel(new GridLayout(2, 1));
            JPanel jPanel3 = new JPanel(new FlowLayout(1, 5, 5));
            JPanel jPanel4 = new JPanel(new FlowLayout(1, 5, 5));
            this.view_data = new JButton(HuginGUIConstants.get("EMLearning_view_data"));
            this.view_data.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JDialog jDialog = new JDialog(EMLearningSetupPane.this.self, HuginGUIConstants.get("str_case_view"), true);
                    CaseFileViewer caseFileViewer = new CaseFileViewer(jDialog, EMLearningSetupPane.this.domain);
                    jDialog.setContentPane(caseFileViewer);
                    jDialog.pack();
                    jDialog.setLocation(EMLearningSetupPane.this.self.getX() + 100, EMLearningSetupPane.this.self.getY() + 50);
                    jDialog.setVisible(true);
                }
            });
            final HuginFileLoader huginFileLoader = new HuginFileLoader(1, Hugin.mainFrame.getMostRecentDataFile(), 0);
            JButton jButton = new JButton(HuginGUIConstants.get("EMLearning_select_file"));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    huginFileLoader.setLocation(100, 100);
                    int n = huginFileLoader.showDialog(EMLearningSetupPane.this.self);
                    if (n == 0) {
                        EMLearningSetupPane.this.file = huginFileLoader.getSelectedFile();
                        EMLearningSetupPane.this.fileNameLabel.setText(EMLearningSetupPane.this.file.getName());
                        try {
                            DataStream dataStream = new DataStream(new TextfileDataSource(EMLearningSetupPane.this.file.getPath()), EMLearningSetupPane.this.domain, false);
                            HuginGUIUtils.insertCases(dataStream, false);
                            EMLearningSetupPane.this.view_data.setEnabled(true);
                            EMLearningSetupPane.this.ok.setEnabled(true);
                            EMLearningSetupPane.this.clear_data.setEnabled(true);
                            EMLearningSetupPane.this.getRootPane().setDefaultButton(EMLearningSetupPane.this.ok);
                            Hugin.mainFrame.setMostRecentDataFile(EMLearningSetupPane.this.file);
                        }
                        catch (Exception exception) {
                            new HuginGUIError(exception.getMessage());
                        }
                    }
                }
            });
            this.clear_data = new JButton(HuginGUIConstants.get("str_clear_data"));
            this.clear_data.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        EMLearningSetupPane.this.domain.setNumberOfCases(0);
                        EMLearningSetupPane.this.fileNameLabel.setText("");
                        EMLearningSetupPane.this.clear_data.setEnabled(false);
                        EMLearningSetupPane.this.view_data.setEnabled(false);
                        EMLearningSetupPane.this.ok.setEnabled(false);
                    }
                    catch (Exception exception) {
                        new HuginGUIError(exception);
                    }
                }
            });
            this.ok = new JButton(HuginGUIConstants.get("OK_button"));
            this.ok.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        int n = new Integer(EMLearningSetupPane.this.numberIterations.getText());
                        double d = new Double(EMLearningSetupPane.this.convergensThreshold.getText());
                        if (n < 0 || d < 0.0) {
                            new HuginGUIError(HuginGUIConstants.get("EMLearning_bad_number_value"));
                            return;
                        }
                        EMLearningSetupPane.this.domain.setMaxNumberOfEMIterations(n);
                        EMLearningSetupPane.this.domain.setLogLikelihoodTolerance(d);
                        try {
                            EMLearningSetupPane.this.domain.saveToMemory();
                        }
                        catch (OutOfMemoryError outOfMemoryError) {
                            // empty catch block
                        }
                        HuginGUIUtils.configureDomain(EMLearningSetupPane.this.domain);
                        if (Hugin.mainFrame.getSelectedProjectFrame().getNetworkPanel().getHomeClass() != null) {
                            EMLearningSetupPane.this.domain.learnClassTables();
                        } else {
                            EMLearningSetupPane.this.domain.learnTables();
                        }
                        Hugin.mainFrame.getSelectedProjectFrame().getNetworkPanel().containsUnsavedChanges(true);
                        EMLearningSetupPane.this.pressedOK = true;
                        EMLearningSetupPane.this.self.dispose();
                    }
                    catch (NumberFormatException numberFormatException) {
                        new HuginGUIError(HuginGUIConstants.get("EMLearning_bad_number_value"));
                    }
                    catch (ExceptionHugin exceptionHugin) {
                        new HuginGUIError(exceptionHugin.getMessage());
                    }
                }
            });
            JButton jButton2 = new JButton(HuginGUIConstants.get("cancel_button"));
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    EMLearningSetupPane.this.self.dispose();
                }
            });
            try {
                this.view_data.setEnabled(this.domain.getNumberOfCases() > 0);
                this.ok.setEnabled(this.domain.getNumberOfCases() > 0);
                this.clear_data.setEnabled(this.domain.getNumberOfCases() > 0);
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
            jPanel3.add(jButton);
            jPanel3.add(this.view_data);
            jPanel3.add(this.clear_data);
            jPanel4.add(this.ok);
            jPanel4.add(jButton2);
            jPanel2.add(jPanel3);
            jPanel2.add(jPanel4);
            titledPanel.setLayout(new BorderLayout(0, 5));
            titledPanel.add((Component)jPanel, "Center");
            titledPanel.add((Component)jPanel2, "South");
            Container container = this.getContentPane();
            container.setLayout(new BorderLayout(0, 5));
            container.add((Component)titledPanel, "Center");
            this.getRootPane().setDefaultButton(jButton);
            this.setResizable(false);
            if (System.getProperty("os.name").equals("Linux")) {
                this.setSize((int)this.getPreferredSize().getWidth() + 10, (int)this.getPreferredSize().getHeight() + 30);
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception.getMessage());
        }
    }

    public boolean pressedOK() {
        return this.pressedOK;
    }
}

