/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.ContinuousChanceNode;
import COM.hugin.HAPI.DiscreteChanceNode;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.ExceptionObjectNotAlive;
import COM.hugin.HAPI.Node;
import COM.hugin.HAPI.Table;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.NodeTableModel;

public class ExperienceTableModel
extends NodeTableModel {
    private Table table;
    private boolean dataMode;

    public ExperienceTableModel(Node node) throws ExceptionHugin {
        this.dataMode = true;
        this.setNode(node);
    }

    public ExperienceTableModel(Node node, boolean bl) throws ExceptionHugin {
        this.setNode(node);
        this.dataMode = bl;
    }

    public void setNode(Node node) throws ExceptionHugin {
        this.node = node;
        if (node instanceof DiscreteChanceNode) {
            this.table = ((DiscreteChanceNode)node).getExperienceTable();
        }
        if (node instanceof ContinuousChanceNode) {
            this.table = ((ContinuousChanceNode)node).getExperienceTable();
        }
        this.fireTableStructureChanged();
    }

    public Object getValueAt(int n, int n2) {
        if (!this.dataMode) {
            return HuginGUIConstants.get("str_experience");
        }
        if (n2 < 0) {
            return "...";
        }
        if (this.node == null) {
            return "-";
        }
        try {
            return new Double(this.table.getDataItem(n2 * this.getRowCount() + n));
        }
        catch (Exception exception) {
            if (exception instanceof ExceptionObjectNotAlive) {
                return "(not alive?)";
            }
            new HuginGUIError(exception);
            return "?";
        }
    }

    public void setValueAt(Object object, int n, int n2) {
        if (!this.dataMode || n2 < 0 || this.node == null) {
            return;
        }
        try {
            this.table.setDataItem(n2 * this.getRowCount() + n, Double.parseDouble(object.toString()));
            this.fireTableCellUpdated(n, n2);
            this.fireModelDataChanged();
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 >= 0 && this.dataMode;
    }

    public int getRowCount() {
        return this.node == null ? 0 : 1;
    }

    public int getColumnCount() {
        if (!this.dataMode) {
            return 1;
        }
        if (this.node == null) {
            return 0;
        }
        try {
            return this.table.getSize() / this.getRowCount();
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
            return 0;
        }
    }
}

