/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.BooleanExpression;
import COM.hugin.HAPI.EqualsExpression;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.ExceptionInvalidExpression;
import COM.hugin.HAPI.ExceptionParse;
import COM.hugin.HAPI.ExceptionSyntax;
import COM.hugin.HAPI.Expression;
import COM.hugin.HAPI.FunctionNode;
import COM.hugin.HAPI.IfExpression;
import COM.hugin.HAPI.LabelExpression;
import COM.hugin.HAPI.Model;
import COM.hugin.HAPI.Node;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HAPI.NumberExpression;
import COM.hugin.HAPI.UtilityNode;
import COM.hugin.HGUI.ExpressionBuilderPanel;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.NodeTableModel;
import java.util.HashMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionTableModel
extends NodeTableModel {
    private Node node;
    private boolean dataMode = true;
    protected static final String SYNTAX_ID = "HR_Syntax_Error:";
    private static HashMap<String, String> mapping = null;

    @Override
    public void setNode(Node node) {
        this.node = node;
        try {
            if (node.getModel() == null) {
                new Model(node, new NodeList());
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        this.fireTableStructureChanged();
    }

    @Override
    public void setDataMode(boolean bl) {
        this.dataMode = bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object getValueAt(int n, int n2) {
        if (this.node == null) {
            return "-";
        }
        if (!this.dataMode) {
            return HuginGUIConstants.get("str_expression");
        }
        if (n2 < 0) {
            return "...";
        }
        Expression expression = this.node.getModel().getExpression(n2);
        if (expression == null) return HuginGUIConstants.get("str_undefined");
        try {
            while (!ExpressionTableModel.isValidExpression(expression)) {
                String string = this.node instanceof UtilityNode || this.node instanceof FunctionNode ? ExpressionTableModel.extractInvalidExpression(expression, true) : ExpressionTableModel.extractInvalidExpression(expression);
                if (string.indexOf(SYNTAX_ID) < 0) return HuginGUIUtils.convertOctals(string);
                expression = Expression.stringToExpression(string, this.node.getModel(), null);
            }
            return HuginGUIUtils.convertOctals(expression.expressionToString());
        }
        catch (Exception exception) {
            try {
                return HuginGUIUtils.convertOctals(expression.expressionToString());
            }
            catch (Exception exception2) {
                new HuginGUIError(exception2);
                return "?";
            }
        }
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        boolean bl = false;
        if (n2 < 0 || this.node == null || !this.dataMode) {
            return;
        }
        try {
            String string = this.mapOperators(object.toString());
            if (string.trim().length() == 0) {
                string = " ";
            }
            Expression expression = Expression.stringToExpression(string, this.node.getModel(), null);
            bl = this.node.getModel().getExpression(n2) == null || !string.equals(this.node.getModel().getExpression(n2).expressionToString());
            this.node.getModel().setExpression(n2, expression);
            if (bl) {
                this.fireTableCellUpdated(n, n2);
                this.fireModelDataChanged();
            }
        }
        catch (ExceptionParse exceptionParse) {
            try {
                Expression expression = this.node instanceof UtilityNode || this.node instanceof FunctionNode ? ExpressionTableModel.createValidExpression(object.toString(), true) : ExpressionTableModel.createValidExpression(object.toString());
                this.node.getModel().setExpression(n2, expression);
                this.fireTableCellUpdated(n, n2);
                this.fireModelDataChanged();
            }
            catch (Exception exception) {
                new HuginGUIError(HuginGUIConstants.get("str_unable_to_store_expression_lb") + object.toString() + "\n" + HuginGUIConstants.get("str_due_to_a_syntax_error"));
            }
        }
        catch (ExceptionSyntax exceptionSyntax) {
            try {
                Expression expression = this.node instanceof UtilityNode || this.node instanceof FunctionNode ? ExpressionTableModel.createValidExpression(object.toString(), true) : ExpressionTableModel.createValidExpression(object.toString());
                this.node.getModel().setExpression(n2, expression);
                this.fireTableCellUpdated(n, n2);
                this.fireModelDataChanged();
            }
            catch (Exception exception) {
                new HuginGUIError(HuginGUIConstants.get("str_unable_to_store_expression_lb") + object.toString() + "\n" + HuginGUIConstants.get("str_due_to_a_syntax_error"));
            }
        }
        catch (ExceptionInvalidExpression exceptionInvalidExpression) {
            try {
                Expression expression = this.node instanceof UtilityNode || this.node instanceof FunctionNode ? ExpressionTableModel.createValidExpression(object.toString(), true) : ExpressionTableModel.createValidExpression(object.toString());
                this.node.getModel().setExpression(n2, expression);
                this.fireTableCellUpdated(n, n2);
                this.fireModelDataChanged();
            }
            catch (Exception exception) {
                new HuginGUIError(HuginGUIConstants.get("str_unable_to_store_expression_lb") + object.toString() + "\n" + HuginGUIConstants.get("str_the_expression_is_invalid"));
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    protected boolean isValidExpression(int n) {
        try {
            Expression expression = this.node.getModel().getExpression(n);
            return ExpressionTableModel.isValidExpression(expression);
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean isExpressionUndefined(int n) {
        try {
            Expression expression = this.node.getModel().getExpression(n);
            if (expression == null) {
                return true;
            }
        }
        catch (Exception exception) {
            return true;
        }
        return false;
    }

    protected static boolean isValidExpression(Expression expression) {
        try {
            if (expression != null && expression instanceof IfExpression) {
                if (((Expression)((IfExpression)expression).getOperands().get(1)).expressionToString().equals("\"HR_Syntax_Error:\"")) {
                    return false;
                }
                Expression expression2 = (Expression)((IfExpression)expression).getOperands().get(0);
                if (expression2 instanceof EqualsExpression && ((Expression)((EqualsExpression)expression2).getOperands().get(0)).expressionToString().equals("\"HR_Syntax_Error:\"")) {
                    return false;
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private Node getNode() {
        return this.node;
    }

    protected static Expression createValidExpression(String string) {
        string = ExpressionTableModel.extractInvalidExpression(string, false);
        try {
            return new IfExpression((Expression)new BooleanExpression(true), (Expression)new LabelExpression(SYNTAX_ID), new LabelExpression(string));
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
            return null;
        }
    }

    protected static Expression createValidExpression(String string, boolean bl) {
        if (!bl) {
            return ExpressionTableModel.createValidExpression(string);
        }
        try {
            string = ExpressionTableModel.extractInvalidExpression(string, true);
            return new IfExpression((Expression)new EqualsExpression((Expression)new LabelExpression(SYNTAX_ID), new LabelExpression(string)), (Expression)new NumberExpression(0.0), new NumberExpression(0.0));
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
            return null;
        }
    }

    protected static String extractInvalidExpression(String string, boolean bl) {
        ExpressionBuilderPanel.InvalidExpression invalidExpression;
        if (string.indexOf(SYNTAX_ID) != -1 && (invalidExpression = new ExpressionBuilderPanel.InvalidExpression(string)).getName().equals("if")) {
            Vector<String> vector;
            String string2;
            ExpressionBuilderPanel.InvalidExpression invalidExpression2;
            Vector<String> vector2 = invalidExpression.getArguments();
            if (!bl) {
                if (vector2.size() == 3 && (string = vector2.get(2)).length() > 1) {
                    string = string.substring(1, string.length() - 1);
                }
            } else if (vector2.size() > 0 && (invalidExpression2 = new ExpressionBuilderPanel.InvalidExpression(string2 = vector2.get(0))).getName().equals("==") && (vector = invalidExpression2.getArguments()).size() == 2 && (string = vector.get(1)).length() > 1) {
                string = string.substring(1, string.length() - 1);
            }
        }
        return string;
    }

    protected static String extractInvalidExpression(Expression expression) throws ExceptionHugin {
        String string = ((Expression)((IfExpression)expression).getOperands().get(2)).expressionToString();
        string = string.substring(1, string.length() - 1);
        string = HuginGUIUtils.convertOctals(string);
        char[] cArray = string.toCharArray();
        string = "";
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '\\') continue;
            string = string + cArray[i];
        }
        return string;
    }

    protected static String extractInvalidExpression(Expression expression, boolean bl) throws ExceptionHugin {
        if (!bl) {
            return ExpressionTableModel.extractInvalidExpression(expression);
        }
        String string = ((Expression)((EqualsExpression)((IfExpression)expression).getOperands().get(0)).getOperands().get(1)).expressionToString();
        string = string.substring(1, string.length() - 1);
        string = HuginGUIUtils.convertOctals(string);
        char[] cArray = string.toCharArray();
        string = "";
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '\\') continue;
            string = string + cArray[i];
        }
        return string;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 >= 0 && this.dataMode;
    }

    @Override
    public int getRowCount() {
        if (this.node == null) {
            return 0;
        }
        return 1;
    }

    @Override
    public int getColumnCount() {
        if (this.node == null) {
            return 0;
        }
        try {
            if (this.node.getModel() == null) {
                return 0;
            }
            return this.node.getModel().getSize();
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
            return 0;
        }
    }

    private String mapOperators(String string) {
        int n;
        int n2;
        if (mapping == null) {
            ExpressionTableModel.initMap();
        }
        int n3 = string.indexOf("(");
        int n4 = string.indexOf(",");
        int n5 = -1;
        String string2 = "";
        while (n3 >= 0) {
            String string3;
            String string4;
            int n6 = n2 = n4 >= 0 && n4 < n3 ? 1 : 0;
            if (n2 != 0) {
                n3 = n4;
            }
            String string5 = string.substring(n5 + 1, n3);
            if (n2 == 0 && (string4 = mapping.get((string3 = string5.trim()).toLowerCase())) != null) {
                string5 = this.replace(string5, string3, string4);
            }
            string2 = string2 + string5 + (n2 != 0 ? "," : "(");
            n5 = n3;
            n3 = string.indexOf("(", n5 + 1);
            n4 = string.indexOf(",", n5 + 1);
        }
        n2 = (string2 = string2 + string.substring(n5 + 1)).toLowerCase().indexOf("true");
        if (n2 >= 0) {
            string2 = string2.substring(0, n2) + "true" + string2.substring(n2 + "true".length());
        }
        if ((n = string2.toLowerCase().indexOf("false")) >= 0) {
            string2 = string2.substring(0, n) + "false" + string2.substring(n + "false".length());
        }
        return string2;
    }

    private String replace(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        String string4 = string.substring(0, n) + string3 + string.substring(n + string2.length());
        return string4;
    }

    private static void initMap() {
        mapping = new HashMap();
        mapping.put("abs", "abs");
        mapping.put("and", "and");
        mapping.put("beta", "Beta");
        mapping.put("binomial", "Binomial");
        mapping.put("ceil", "ceil");
        mapping.put("cos", "cos");
        mapping.put("cosh", "cosh");
        mapping.put("distribution", "Distribution");
        mapping.put("exp", "exp");
        mapping.put("exponential", "Exponential");
        mapping.put("floor", "floor");
        mapping.put("gamma", "Gamma");
        mapping.put("geometric", "Geometric");
        mapping.put("if", "if");
        mapping.put("log", "log");
        mapping.put("log2", "log2");
        mapping.put("log10", "log10");
        mapping.put("max", "max");
        mapping.put("min", "min");
        mapping.put("mod", "mod");
        mapping.put("negativebinomial", "NegativeBinomial");
        mapping.put("noisyor", "NoisyOR");
        mapping.put("normal", "Normal");
        mapping.put("not", "not");
        mapping.put("or", "or");
        mapping.put("poisson", "Poisson");
        mapping.put("sin", "sin");
        mapping.put("sinh", "sinh");
        mapping.put("sqrt", "sqrt");
        mapping.put("tan", "tan");
        mapping.put("tanh", "tanh");
        mapping.put("uniform", "Uniform");
        mapping.put("weibull", "Weibull");
        mapping.put("truncate", "truncate");
        mapping.put("lognormal", "LogNormal");
        mapping.put("pert", "PERT");
        mapping.put("triangular", "Triangular");
    }

    public static HashMap<String, String> getOperatorMap2() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("+", "+");
        hashMap.put("-", "-");
        hashMap.put("*", "*");
        hashMap.put("/", "/");
        hashMap.put("^", "power");
        hashMap.put("==", "==");
        hashMap.put("<", "<");
        hashMap.put(">", ">");
        hashMap.put("!=", "!=");
        hashMap.put("<=", "<=");
        hashMap.put(">=", ">=");
        return hashMap;
    }

    public static HashMap<String, String> getOperatorMap() {
        if (mapping == null) {
            ExpressionTableModel.initMap();
        }
        return mapping;
    }
}

