/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.DiscreteChanceNode;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.FunctionNode;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HGUI.DataAnalyzerDialog;
import COM.hugin.HGUI.HuginAnalysisDialog;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIFrame;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.HuginProjectFrame;
import COM.hugin.HGUI.HuginTableModel;
import COM.hugin.HGUI.LearningWizard;
import COM.hugin.HGUI.Node;
import COM.hugin.HGUI.NumberField;
import COM.hugin.HGUI.TableSorter;
import COM.hugin.HGUI.TitledPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FeatureSelectionAnalyzer
extends DataAnalyzerDialog {
    private JPanel dataPane;
    private JPanel setupPane;
    private JPanel runPane;
    private JPanel resultsPane;
    private JComboBox targetNode;
    private NumberField threshold;
    private HuginTableModel resultsTableModel = null;
    private JButton runButton;
    HuginAnalysisDialog.NodeWrapper selected = null;
    private HuginGUIFrame guiFrame;
    JPanel outputPanel;
    JTable resultsTable;
    TableSorter resultSorter;

    public FeatureSelectionAnalyzer(HuginProjectFrame huginProjectFrame, HuginGUIFrame huginGUIFrame) {
        super(huginProjectFrame, HuginGUIConstants.get("FSA_Title"));
        this.guiFrame = huginGUIFrame;
        this.streamData = null;
        this.helpPages = new String[]{"help/FSA_DataSource.htm", "help/FSA_Setup.htm", "help/FSA_Run.htm"};
        try {
            this.configureDomain();
            if (!this.domain.isCompiled()) {
                this.domain.compile();
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
        }
        this.tabbedPane = new JTabbedPane();
        this.createDataPane();
        this.createSetupPane();
        this.createRunPane();
        this.tabbedPane.addTab(HuginGUIConstants.get("AW_Tab_data_acquisition"), this.dataPane);
        this.tabbedPane.addTab(HuginGUIConstants.get("FSA_Tab_setup"), this.setupPane);
        this.tabbedPane.addTab(HuginGUIConstants.get("FSA_Tab_run"), this.runPane);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.tabbedPane, "Center");
        jPanel.add((Component)this.getBottomPanel(), "South");
        this.setContentPane(jPanel);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                FeatureSelectionAnalyzer.this.projectFrame.getNetworkPanel().updateBackpointers();
            }
        });
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new DataAnalyzerDialog.CloseListener(this, this.domain, huginProjectFrame.getNetworkPanel()));
    }

    protected void updatePanes() {
        int n = this.tabbedPane.indexOfTab(HuginGUIConstants.get("FSA_Tab_setup"));
        this.tabbedPane.remove(n);
        this.createSetupPane();
        this.tabbedPane.insertTab(HuginGUIConstants.get("FSA_Tab_setup"), null, this.setupPane, null, n);
        n = this.tabbedPane.indexOfTab(HuginGUIConstants.get("FSA_Tab_run"));
        this.tabbedPane.remove(n);
        this.createRunPane();
        this.tabbedPane.insertTab(HuginGUIConstants.get("FSA_Tab_run"), null, this.runPane, null, n);
    }

    private void createDataPane() {
        this.dataPane = new TitledPanel(HuginGUIConstants.get("AW_Data_title"));
        this.dataFileLabel = new JLabel(HuginGUIConstants.get("AW_Data_file") + "---");
        this.dataNumberOfCasesLabel = new JLabel(HuginGUIConstants.get("AW_Data_number_of_cases") + "0", 4);
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.add(this.dataFileLabel);
        jPanel.add(this.dataNumberOfCasesLabel);
        this.viewDataPane = new JScrollPane();
        this.viewDataPane.setPreferredSize(new Dimension(450, 300));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 4));
        JButton jButton = new JButton(HuginGUIConstants.get("AW_Data_database"));
        jButton.setToolTipText(HuginGUIConstants.get("SA_ToolTip_Load_Cases"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LearningWizard learningWizard = new LearningWizard(FeatureSelectionAnalyzer.this.wizardWindow, ((FeatureSelectionAnalyzer)FeatureSelectionAnalyzer.this).guiFrame.preferences, FeatureSelectionAnalyzer.this.domain, new DataAnalyzerDialog.DomainCasesListener(FeatureSelectionAnalyzer.this));
                learningWizard.setLocation(100, 100);
                learningWizard.setVisible(true);
                try {
                    FeatureSelectionAnalyzer.this.runButton.setEnabled(FeatureSelectionAnalyzer.this.domain.getNumberOfCases() > 0);
                }
                catch (ExceptionHugin exceptionHugin) {
                    new HuginGUIError(exceptionHugin);
                }
            }
        });
        this.clearData = new JButton(HuginGUIConstants.get("AW_Data_clear_data"));
        this.clearData.setToolTipText(HuginGUIConstants.get("AW_ToolTip_Clear_Data"));
        this.clearData.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FeatureSelectionAnalyzer.this.clearData();
                FeatureSelectionAnalyzer.this.runButton.setEnabled(false);
            }
        });
        this.clearData.setEnabled(false);
        jPanel2.add(jButton);
        jPanel2.add(this.clearData);
        this.dataPane.setLayout(new BorderLayout());
        this.dataPane.add((Component)jPanel, "North");
        this.dataPane.add((Component)this.viewDataPane, "Center");
        this.dataPane.add((Component)jPanel2, "South");
    }

    private void createSetupPane() {
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 10, 5));
        Vector<HuginAnalysisDialog.NodeWrapper> vector = new Vector<HuginAnalysisDialog.NodeWrapper>();
        try {
            for (COM.hugin.HAPI.Node node : this.domain.getNodes()) {
                if (!(node instanceof DiscreteChanceNode)) continue;
                vector.add(new HuginAnalysisDialog.NodeWrapper(node));
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
        }
        this.targetNode = new JComboBox(vector);
        JLabel jLabel = new JLabel(HuginGUIConstants.get("Select_target_node"));
        jPanel.add(jLabel);
        jPanel.add(this.targetNode);
        this.setupPane = new TitledPanel(HuginGUIConstants.get("FSA_setup_title"));
        this.setupPane.setLayout(new FlowLayout(0));
        this.setupPane.add(jPanel);
    }

    private void createRunPane() {
        this.outputPanel = this.getOutputPanel();
        JScrollPane jScrollPane = new JScrollPane(this.outputPanel);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("FSA_perform_feature_selection")));
        this.runButton = this.getRunButton();
        this.runButton.setEnabled(false);
        JPanel jPanel = new JPanel(new FlowLayout(2));
        jPanel.add((Component)this.runButton, "East");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JTextArea jTextArea = new JTextArea(2, 20);
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setDisabledTextColor(Color.black);
        jTextArea.setBackground(this.getBackground());
        jTextArea.append(HuginGUIConstants.get("FSA_description"));
        jPanel2.add(jTextArea);
        this.runPane = new JPanel(new BorderLayout());
        this.runPane.add((Component)jScrollPane, "Center");
        this.runPane.add((Component)jPanel, "South");
        this.runPane.add((Component)jPanel2, "North");
    }

    protected JButton getCloseButton() {
        JButton jButton = new JButton(HuginGUIConstants.get("MISCELLANEOUS_Close"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FeatureSelectionAnalyzer.this.dispose();
            }
        });
        return jButton;
    }

    protected JButton getRunButton() {
        JButton jButton = new JButton(HuginGUIConstants.get("FSA_Tab_run"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    FeatureSelectionAnalyzer.this.selected = (HuginAnalysisDialog.NodeWrapper)FeatureSelectionAnalyzer.this.targetNode.getSelectedItem();
                    DiscreteChanceNode discreteChanceNode = (DiscreteChanceNode)FeatureSelectionAnalyzer.this.selected.node;
                    NodeList nodeList = new NodeList();
                    for (Object object : FeatureSelectionAnalyzer.this.domain.getNodes()) {
                        if (object instanceof FunctionNode) continue;
                        nodeList.add(object);
                    }
                    FeatureSelectionAnalyzer.this.resultsTableModel.resize(nodeList.size() - 1, 2);
                    FeatureSelectionAnalyzer.this.resultsTableModel.setColumnName(0, HuginGUIConstants.get("str_node"));
                    FeatureSelectionAnalyzer.this.resultsTableModel.setColumnName(1, "p-" + HuginGUIConstants.get("str_Value"));
                    int n = 0;
                    for (COM.hugin.HAPI.Node node : nodeList) {
                        if (!(node instanceof DiscreteChanceNode) || node == discreteChanceNode) continue;
                        DiscreteChanceNode discreteChanceNode2 = (DiscreteChanceNode)node;
                        double d = discreteChanceNode.computeProbabilityOfIndependence(discreteChanceNode2);
                        Double d2 = new Double(HuginGUIUtils.printDouble(d, FeatureSelectionAnalyzer.this.projectFrame.guiFrame.preferences.precision));
                        FeatureSelectionAnalyzer.this.resultsTableModel.setValueAt(d2, n, 1);
                        String string = HuginGUIUtils.getNodeTitle((COM.hugin.HAPI.Node)discreteChanceNode2, (short)0);
                        FeatureSelectionAnalyzer.this.resultsTableModel.setValueAt(discreteChanceNode2.getGUINode(), n, 0);
                        ++n;
                        FeatureSelectionAnalyzer.this.resultsTableModel.fireTableStructureChanged();
                    }
                }
                catch (Exception exception) {
                    new HuginGUIError(exception.getMessage());
                }
            }
        });
        return jButton;
    }

    private JPanel getOutputPanel() {
        this.resultsTableModel = new HuginTableModel("p-" + HuginGUIConstants.get("str_Value"));
        this.resultSorter = new TableSorter(this.resultsTableModel);
        this.resultsTable = new JTable(this.resultSorter);
        this.resultsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int[] nArray = FeatureSelectionAnalyzer.this.resultsTable.getSelectedRows();
                FeatureSelectionAnalyzer.this.projectFrame.getNetworkPanel().deselectAllNodes();
                for (int i = 0; i < nArray.length; ++i) {
                    FeatureSelectionAnalyzer.this.projectFrame.getNetworkPanel().selectNode((Node)FeatureSelectionAnalyzer.this.resultSorter.getValueAt(nArray[i], 0));
                }
            }
        });
        this.resultSorter.setTableHeader(this.resultsTable.getTableHeader());
        this.resultsTable.setPreferredScrollableViewportSize(new Dimension(500, 200));
        HuginAnalysisDialog.DoubleTableRenderer doubleTableRenderer = new HuginAnalysisDialog.DoubleTableRenderer(this.projectFrame.guiFrame.preferences.precision);
        this.resultsTable.setDefaultRenderer(Double.class, doubleTableRenderer);
        JScrollPane jScrollPane = new JScrollPane(this.resultsTable, 22, 31);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("FSA_Tab_results")));
        JPanel jPanel = new JPanel();
        jPanel.add(jScrollPane);
        return jPanel;
    }

    public void createResultsPane() {
        JLabel jLabel = new JLabel("PIS");
        JTextArea jTextArea = new JTextArea("---");
        jTextArea.setBackground(this.getBackground());
        jTextArea.setEditable(false);
        JPanel jPanel = new JPanel(new GridLayout(3, 2, 10, 5));
        jPanel.add(jLabel);
        jPanel.add(jTextArea);
        this.resultsPane = new TitledPanel(HuginGUIConstants.get("FSA_results_title"));
        this.resultsPane.setLayout(new FlowLayout(0));
        this.resultsPane.add(jPanel);
    }
}

