/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HGUI.HuginFileLoader;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIFrame;
import COM.hugin.HGUI.HuginGUIUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class FileLauncher
extends JDialog {
    private final String appSeparator = ",";
    private final String extSeparator = ";";
    private HuginGUIFrame guiFrame;
    private JPanel mainPanel;
    private File file = null;
    private String ext = "";
    private JTextField appField;
    JButton open;
    private String osName = System.getProperty("os.name").toLowerCase();

    public FileLauncher(Frame frame, HuginGUIFrame huginGUIFrame, File file) {
        super(frame, HuginGUIConstants.get("Launcher_Title"), true);
        this.file = file;
        this.guiFrame = huginGUIFrame;
        this.initializeDefaults();
        this.initialize(frame);
    }

    public FileLauncher(Dialog dialog, HuginGUIFrame huginGUIFrame, File file) {
        super(dialog, HuginGUIConstants.get("Launcher_Title"), true);
        this.file = file;
        this.guiFrame = huginGUIFrame;
        this.initializeDefaults();
        this.initialize(dialog);
    }

    private boolean hasDefault() {
        String string = this.appField.getText();
        return string != null && string.length() > 1;
    }

    private void initialize(Component component) {
        this.mainPanel = new JPanel(new BorderLayout(5, 5));
        this.mainPanel.setBorder(BorderFactory.createTitledBorder(this.file.getName()));
        this.open = new JButton(HuginGUIConstants.get("Launcher_Open"));
        this.open.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileLauncher.this.setDefaultApplication(FileLauncher.this.appField.getText());
                FileLauncher.this.launchFile();
            }
        });
        JButton jButton = new JButton(HuginGUIConstants.get("Launcher_Select"));
        jButton.addActionListener(new ApplicationListener());
        JButton jButton2 = new JButton(HuginGUIConstants.get("Launcher_Close"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileLauncher.this.dispose();
            }
        });
        JButton jButton3 = new JButton(HuginGUIConstants.get("Launcher_Clear"));
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((FileLauncher)FileLauncher.this).guiFrame.preferences.defaultapplications = "";
                FileLauncher.this.appField.setText("");
            }
        });
        JPanel jPanel = new JPanel(new GridLayout(1, 3));
        jPanel.add(this.open);
        jPanel.add(jButton2);
        JPanel jPanel2 = new JPanel(new BorderLayout(5, 5));
        jPanel2.add((Component)jPanel, "East");
        jPanel2.add((Component)jButton3, "West");
        jPanel2.add((Component)new JSeparator(), "North");
        this.mainPanel.add((Component)jPanel2, "South");
        this.appField.addKeyListener(new ReturnKeyListener());
        jPanel = new JPanel(new BorderLayout(5, 5));
        String string = System.getProperty("os.name").toLowerCase();
        String string2 = HuginGUIConstants.get("Launcher_msg2", new String[]{this.ext});
        if (string.indexOf("windows") > -1) {
            string2 = HuginGUIConstants.get("Launcher_msg1");
        }
        jPanel.add((Component)new JLabel(string2), "North");
        jPanel.add((Component)this.appField, "Center");
        jPanel.add((Component)jButton, "East");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel, "North");
        this.mainPanel.add(jPanel3);
        this.setLayout(new GridLayout(1, 1));
        this.getContentPane().add(this.mainPanel);
        this.pack();
        HuginGUIUtils.centerComponent(component, (Window)this);
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.setVisible(true);
    }

    private void initializeDefaults() {
        this.ext = this.getExtension(this.file);
        this.appField = new JTextField(this.getDefaultApplication(), 25);
    }

    private String getDefaultApplication() {
        String string = this.guiFrame.preferences.defaultapplications;
        if (string != null && this.ext != null) {
            String[] stringArray;
            for (String string2 : stringArray = string.split(",")) {
                String[] stringArray2 = string2.split(";");
                if (stringArray2.length != 2 || !stringArray2[1].equals(this.ext)) continue;
                return stringArray2[0];
            }
        }
        return null;
    }

    private void setDefaultApplication(String string) {
        String string2 = "";
        String string3 = this.guiFrame.preferences.defaultapplications;
        if (string3 != null && this.ext != null && string3.length() > 1) {
            String[] stringArray = string3.split(",");
            boolean bl = false;
            for (String string4 : stringArray) {
                String[] stringArray2 = string4.split(";");
                if (stringArray2.length <= 1) continue;
                if (stringArray2[1].equals(this.ext)) {
                    stringArray2[0] = string;
                    this.appField.setText(string);
                    bl = true;
                }
                if (!(string2 = string2 + "," + stringArray2[0] + ";" + stringArray2[1]).startsWith(",")) continue;
                string2 = string2.substring(1);
            }
            if (!bl) {
                string2 = string2 + "," + string + ";" + this.ext;
            }
            this.guiFrame.preferences.defaultapplications = string2;
        } else if (this.ext != null) {
            this.guiFrame.preferences.defaultapplications = string + ";" + this.ext;
            this.appField.setText(string);
        }
    }

    public String getExtension(File file) {
        String string = null;
        String string2 = file.getName();
        int n = string2.lastIndexOf(46);
        if (n > 0 && n < string2.length() - 1) {
            string = string2.substring(n).toLowerCase();
        }
        return string;
    }

    private void launchFile() {
        try {
            String string = System.getProperty("os.name").toLowerCase();
            if (string.indexOf("windows") > -1) {
                if (this.hasDefault()) {
                    String[] stringArray = new String[]{this.appField.getText(), this.file.getPath()};
                    Runtime.getRuntime().exec(stringArray);
                } else {
                    Runtime.getRuntime().exec("cmd /C \"start /D\"" + this.file.getParent() + "\" \"" + this.file.getName() + "\" \"" + this.file.getName() + "\"\"");
                }
                this.dispose();
            } else if (this.hasDefault()) {
                if (string.indexOf("linux") > -1) {
                    String[] stringArray = new String[]{this.appField.getText(), this.file.getPath()};
                    Runtime.getRuntime().exec(stringArray);
                    this.dispose();
                } else if (string.indexOf("mac") > -1) {
                    Runtime.getRuntime().exec("open -a " + this.appField.getText() + " \"" + this.file.getPath() + "\"");
                    this.dispose();
                }
            } else {
                new HuginGUIError(HuginGUIConstants.get("str_please_specify_default_application", new String[]{this.ext}));
            }
        }
        catch (Exception exception) {
            new HuginGUIError(HuginGUIConstants.get("str_unable_to_open_file", new String[]{this.file.getName()}));
        }
    }

    class ReturnKeyListener
    extends KeyAdapter {
        public void keyTyped(KeyEvent keyEvent) {
            JTextField jTextField = (JTextField)keyEvent.getSource();
            char c = keyEvent.getKeyChar();
            if (c == '\n') {
                FileLauncher.this.setDefaultApplication(jTextField.getText());
                FileLauncher.this.launchFile();
                keyEvent.consume();
            }
        }
    }

    class ApplicationListener
    implements ActionListener {
        String defaults = "";
        File application = new File("");

        ApplicationListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            File file;
            HuginFileLoader huginFileLoader;
            int n;
            String string = "";
            if (FileLauncher.this.hasDefault()) {
                string = FileLauncher.this.appField.getText();
            }
            if ((n = (huginFileLoader = new HuginFileLoader(11, file = new File(string), 0)).showDialog(FileLauncher.this)) == 0) {
                this.application = huginFileLoader.getSelectedFile();
                if (this.application != null) {
                    FileLauncher.this.setDefaultApplication(this.application.getPath());
                }
            }
        }
    }
}

