/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.PastingTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FontSelector
extends JButton {
    private String[] styles = new String[]{HuginGUIConstants.get("str_plain"), HuginGUIConstants.get("str_bold"), HuginGUIConstants.get("str_italic"), HuginGUIConstants.get("str_bold_italic")};
    public Font theFont;
    private static final String[] HIDEFONTS = new String[]{".bold", ".italic"};

    public FontSelector(Font font, final String string) {
        try {
            int n = font.getSize();
        }
        catch (Exception exception) {
            int n = 12;
        }
        try {
            int n = font.getStyle();
        }
        catch (Exception exception) {
            boolean bl = false;
        }
        this.theFont = font;
        this.setText(string);
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals(string)) {
                    FontSelector.this.changeFont(new SelectorFrame(FontSelector.this.theFont, 150, 150).getSelectedFont());
                    FontSelector.this.fireActionPerformed(new ActionEvent(this, 0, "Changed"));
                }
            }
        });
    }

    public void save() {
        Font font = this.getFont();
    }

    private void changeFont(Font font) {
        if (font != null) {
            this.theFont = font;
        }
    }

    public static String[] getAvailableFontFamilyNames() {
        String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        Vector<String> vector = new Vector<String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            for (n = 0; n < HIDEFONTS.length && stringArray[i].indexOf(HIDEFONTS[n]) < 0; ++n) {
            }
            if (n != HIDEFONTS.length) continue;
            vector.addElement(stringArray[i]);
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        vector = null;
        return objectArray;
    }

    class SelectorFrame
    extends JDialog
    implements ListSelectionListener,
    ActionListener {
        private String[] sizes;
        private boolean fontSelected;
        private JLabel example;
        private JButton ok;
        private JButton cancel;
        private JList fontsList;
        private JList sizesList;
        private JList stylesList;
        private PastingTextField fontsField;
        private PastingTextField sizesField;
        private PastingTextField stylesField;

        SelectorFrame(Font font, int n, int n2) {
            super(JOptionPane.getFrameForComponent(FontSelector.this), HuginGUIConstants.get("MISCELLANEOUS_Font_selector"), true);
            this.sizes = new String[]{"9", "10", "12", "14", "16", "18", "24"};
            this.fontSelected = false;
            this.getContentPane().setLayout(new BorderLayout());
            this.fontsField = new PastingTextField(10);
            this.fontsList = new JList<String>(FontSelector.getAvailableFontFamilyNames());
            JPanel jPanel = this.createTextFieldAndListPanel(HuginGUIConstants.get("str_family"), this.fontsField, this.fontsList);
            this.fontsField.setText(font.getName());
            this.fontsField.setEnabled(false);
            this.sizesField = new PastingTextField(10);
            this.sizesList = new JList<String>(this.sizes);
            JPanel jPanel2 = this.createTextFieldAndListPanel(HuginGUIConstants.get("str_size"), this.sizesField, this.sizesList);
            this.sizesList.setSelectedValue(String.valueOf(font.getSize()), true);
            this.sizesField.setText(String.valueOf(font.getSize()));
            this.stylesField = new PastingTextField(10);
            this.stylesList = new JList<String>(FontSelector.this.styles);
            JPanel jPanel3 = this.createTextFieldAndListPanel(HuginGUIConstants.get("str_style"), this.stylesField, this.stylesList);
            this.stylesList.setSelectedIndex(font.getStyle());
            this.stylesField.setText((String)this.stylesList.getSelectedValue());
            this.stylesField.setEnabled(false);
            this.fontsList.addListSelectionListener(this);
            this.sizesList.addListSelectionListener(this);
            this.stylesList.addListSelectionListener(this);
            JPanel jPanel4 = new JPanel(new GridLayout(1, 3, 6, 6));
            jPanel4.add(jPanel);
            jPanel4.add(jPanel2);
            jPanel4.add(jPanel3);
            JPanel jPanel5 = new JPanel();
            jPanel5.setBorder(new TitledBorder(HuginGUIConstants.get("str_preview")));
            this.example = new JLabel(HuginGUIConstants.get("str_example"));
            jPanel5.add(this.example);
            JPanel jPanel6 = new JPanel();
            this.ok = new JButton(HuginGUIConstants.get("OK_BUTTON_LABEL"));
            jPanel6.add(this.ok);
            this.cancel = new JButton(HuginGUIConstants.get("CANCEL_BUTTON_LABEL"));
            jPanel6.add(this.cancel);
            this.ok.addActionListener(this);
            this.cancel.addActionListener(this);
            this.preview();
            this.getContentPane().add((Component)jPanel4, "North");
            this.getContentPane().add((Component)jPanel5, "Center");
            this.getContentPane().add((Component)jPanel6, "South");
            Dimension dimension = this.getPreferredSize();
            dimension.height = 30;
            this.example.setPreferredSize(dimension);
            this.getRootPane().setDefaultButton(this.ok);
            this.setDefaultCloseOperation(2);
            this.fontsList.setSelectedValue(font.getName(), true);
            this.setLocation(n, n2);
            this.pack();
            this.setResizable(false);
            this.setVisible(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.cancel) {
                this.dispose();
            } else if (object == this.ok) {
                this.fontSelected = true;
                this.dispose();
            }
        }

        public Font getSelectedFont() {
            return this.fontSelected ? this.buildFont() : null;
        }

        private Font buildFont() {
            int n;
            try {
                n = Integer.parseInt(this.sizesField.getText());
            }
            catch (Exception exception) {
                n = 12;
            }
            return new Font(this.fontsField.getText(), this.stylesList.getSelectedIndex(), n);
        }

        private void preview() {
            Font font = this.buildFont();
            this.example.setFont(font);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            String string;
            Object object = listSelectionEvent.getSource();
            if (object == this.fontsList) {
                String string2 = (String)this.fontsList.getSelectedValue();
                if (string2 != null) {
                    this.fontsField.setText(string2);
                }
            } else if (object == this.sizesList) {
                String string3 = (String)this.sizesList.getSelectedValue();
                if (string3 != null) {
                    this.sizesField.setText(string3);
                }
            } else if (object == this.stylesList && (string = (String)this.stylesList.getSelectedValue()) != null) {
                this.stylesField.setText(string);
            }
            this.preview();
        }

        private JPanel createTextFieldAndListPanel(String string, PastingTextField pastingTextField, JList jList) {
            GridBagLayout gridBagLayout = new GridBagLayout();
            JPanel jPanel = new JPanel(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            JLabel jLabel = new JLabel(string);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jPanel.add(jLabel);
            gridBagConstraints.gridy = 1;
            Component component = Box.createVerticalStrut(6);
            gridBagLayout.setConstraints(component, gridBagConstraints);
            jPanel.add(component);
            gridBagConstraints.gridy = 2;
            gridBagLayout.setConstraints(pastingTextField, gridBagConstraints);
            jPanel.add(pastingTextField);
            gridBagConstraints.gridy = 3;
            component = Box.createVerticalStrut(6);
            gridBagLayout.setConstraints(component, gridBagConstraints);
            jPanel.add(component);
            gridBagConstraints.gridy = 4;
            gridBagConstraints.gridheight = 0;
            JScrollPane jScrollPane = new JScrollPane(jList);
            jScrollPane.setPreferredSize(new Dimension(200, 150));
            gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
            jPanel.add(jScrollPane);
            jPanel.setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("str_grid")));
            return jPanel;
        }
    }
}

