/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.ContinuousChanceNode;
import COM.hugin.HAPI.DiscreteChanceNode;
import COM.hugin.HAPI.DiscreteDecisionNode;
import COM.hugin.HAPI.DiscreteNode;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.FunctionNode;
import COM.hugin.HAPI.Node;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HAPI.NumberedDCNode;
import COM.hugin.HAPI.NumberedDDNode;
import COM.hugin.HAPI.Table;
import COM.hugin.HAPI.UtilityNode;
import COM.hugin.HGUI.ContinuousChanceNodeTableModel;
import COM.hugin.HGUI.DiscreteChanceNodeTableModel;
import COM.hugin.HGUI.DiscreteDecisionNodeTableModel;
import COM.hugin.HGUI.FunctionNodeTableModel;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.NodeTableColumnModel;
import COM.hugin.HGUI.NodeTableExportPanel;
import COM.hugin.HGUI.NodeTableFrame;
import COM.hugin.HGUI.NodeTableHeader;
import COM.hugin.HGUI.NodeTableModel;
import COM.hugin.HGUI.UtilityNodeTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class GenericTable
extends JTable {
    Node node;
    LinkedList<ColumnListener> columnListeners;
    LinkedList<TableTabbedListener> tabListeners;
    LinkedList<NodeTableFrame.TableChangeListener> changeListeners;
    LinkedList<TableNeedsScrollListener> scrollListeners;
    boolean isEditable = true;
    public static final int DELIMITED = 0;
    public static final int LATEX = 1;
    public static final int EXCEL = 2;

    public GenericTable(Node node) throws ExceptionHugin {
        this.setNode(node);
        ((NodeTableColumnModel)this.columnModel).setNode(node);
        ((NodeTableColumnModel)this.columnModel).addColumnStateListener(new NodeTableColumnModel.ColumnStateListener(){

            public void columnCollapsing(int n) {
                GenericTable.this.stopEditing();
            }

            public void columnCollapsed(int n) {
                GenericTable.this.fireColumnCollapsed();
            }

            public void columnExpanded(int n) {
                GenericTable.this.fireColumnExpanded();
            }
        });
        ((NodeTableModel)this.dataModel).setNode(node);
        ((NodeTableModel)this.dataModel).setDataMode(true);
        ((NodeTableModel)this.dataModel).getColumnCount();
        ((NodeTableModel)this.dataModel).addTableModelListener(new TableModelListener(){

            public void tableDataChanged() {
                GenericTable.this.fireTableChanged();
            }
        });
        this.columnListeners = new LinkedList();
        this.tabListeners = new LinkedList();
        this.scrollListeners = new LinkedList();
        this.changeListeners = new LinkedList();
        this.getTableHeader().setDefaultRenderer(new LoweredHeaderRenderer(this.getTableHeader().getDefaultRenderer()));
        this.addKeyListener(new CellSelectionListener());
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                GenericTable.this.stopEditing();
            }
        });
        this.manageFocus();
    }

    public GenericTable(Node node, NodeList nodeList) throws ExceptionHugin {
        this(node, nodeList, true);
    }

    public GenericTable(Node node, NodeList nodeList, boolean bl) throws ExceptionHugin {
        this.setNode(node);
        ((NodeTableColumnModel)this.columnModel).setNodeList(nodeList, false);
        ((NodeTableModel)this.dataModel).setNode(node);
        ((NodeTableModel)this.dataModel).setDataMode(false);
        ((NodeTableModel)this.dataModel).addTableModelListener(new TableModelListener(){

            public void tableDataChanged() {
                GenericTable.this.fireTableChanged();
            }
        });
        bl = bl && ((NodeTableModel)this.dataModel).getDisplayMode() == 0;
        this.columnListeners = new LinkedList();
        this.tabListeners = new LinkedList();
        this.scrollListeners = new LinkedList();
        this.changeListeners = new LinkedList();
        this.setCellEditor(new GenericTableCellEditor(bl));
        this.setDefaultEditor(Object.class, new GenericTableCellEditor(bl));
        this.addKeyListener(new CellSelectionListener());
        this.setDefaultRenderer(Object.class, new GenericTableCellRenderer(bl));
        this.manageFocus();
    }

    public GenericTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        super(tableModel, tableColumnModel);
        this.columnListeners = new LinkedList();
        this.tabListeners = new LinkedList();
        this.scrollListeners = new LinkedList();
        this.changeListeners = new LinkedList();
        this.addKeyListener(new CellSelectionListener());
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                GenericTable.this.stopEditing();
            }
        });
        this.manageFocus();
    }

    protected void setNode(Node node) throws ExceptionHugin {
        this.node = node;
        if (node instanceof DiscreteChanceNode) {
            this.setModel(new DiscreteChanceNodeTableModel());
        } else if (node instanceof DiscreteDecisionNode) {
            this.setModel(new DiscreteDecisionNodeTableModel());
        } else if (node instanceof UtilityNode) {
            this.setModel(new UtilityNodeTableModel());
        } else if (node instanceof ContinuousChanceNode) {
            this.setModel(new ContinuousChanceNodeTableModel());
        } else if (node instanceof FunctionNode) {
            this.setModel(new FunctionNodeTableModel());
        }
    }

    public boolean isCellEditable(int n, int n2) {
        if (!this.isEditable) {
            return false;
        }
        return super.isCellEditable(n, n2);
    }

    public void setEditable(boolean bl) {
        this.isEditable = bl;
    }

    protected void changeNode(Node node) throws ExceptionHugin {
        NodeTableModel nodeTableModel = (NodeTableModel)this.getModel();
        boolean bl = nodeTableModel.getExpressionMode();
        boolean bl2 = nodeTableModel.getDataMode();
        this.setNode(node);
        ((NodeTableModel)this.dataModel).setNode(node);
        ((NodeTableModel)this.dataModel).addTableModelListener(new TableModelListener(){

            public void tableDataChanged() {
                GenericTable.this.fireTableChanged();
            }
        });
        ((NodeTableColumnModel)this.columnModel).setNode(node);
        nodeTableModel = (NodeTableModel)this.getModel();
        nodeTableModel.setExpressionMode(bl);
        nodeTableModel.setDataMode(bl2);
        this.configureEnclosingScrollPane();
    }

    protected void changeNode(Node node, NodeList nodeList) throws ExceptionHugin {
        this.setNode(node);
        int n = ((NodeTableColumnModel)this.columnModel).getTotalColumnWidth();
        ((NodeTableModel)this.dataModel).setNode(node);
        ((NodeTableModel)this.dataModel).setDataMode(false);
        ((NodeTableColumnModel)this.columnModel).setNodeList(nodeList, false);
        ((NodeTableModel)this.dataModel).addTableModelListener(new TableModelListener(){

            public void tableDataChanged() {
                GenericTable.this.fireTableChanged();
            }
        });
        this.setColumnWidth(n);
    }

    public void invalidateModel() {
        if (this.getModel() != null && this.getModel() instanceof NodeTableModel) {
            ((NodeTableModel)this.getModel()).invalidateModel();
        }
    }

    private void manageFocus() {
        this.setFocusCycleRoot(true);
        this.setKeyboardMapping();
    }

    private void setKeyboardMapping() {
        InputMap inputMap = this.getInputMap();
        ActionMap actionMap = this.getActionMap();
        String string = "GenericTable.PASTE";
        inputMap.put(KeyStroke.getKeyStroke(86, 2), string);
        actionMap.put(string, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    GenericTable.this.invalidate();
                    GenericTable.this.pasteSelection();
                    GenericTable.this.repaint();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        string = "GenericTable.COPY";
        inputMap.put(KeyStroke.getKeyStroke(67, 2), string);
        actionMap.put(string, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                GenericTable.this.copySelection();
            }
        });
    }

    public void createDefaultColumnsFromModel() {
        TableModel tableModel = this.getModel();
        if (tableModel != null) {
            Vector<TableColumn> vector = ((NodeTableColumnModel)this.columnModel).getColumnsVector();
            vector.clear();
            if (tableModel.getColumnCount() > 0) {
                this.addColumn(new TableColumn());
            }
        }
    }

    protected TableColumnModel createDefaultColumnModel() {
        NodeTableColumnModel nodeTableColumnModel = new NodeTableColumnModel();
        return nodeTableColumnModel;
    }

    protected TableModel createDefaultDataModel() {
        NodeTableModel nodeTableModel = new NodeTableModel();
        return nodeTableModel;
    }

    protected JTableHeader createDefaultTableHeader() {
        NodeTableHeader nodeTableHeader = new NodeTableHeader((NodeTableColumnModel)this.columnModel);
        return nodeTableHeader;
    }

    public void stopEditing() {
        if (this.cellEditor != null) {
            this.cellEditor.stopCellEditing();
        }
        this.removeEditor();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        Color color = UIManager.getDefaults().getColor("Table.background");
        if (!bl) {
            color = new Color(color.getRed() - 30, color.getGreen() - 30, color.getBlue() - 30);
        }
        this.setBackground(color);
    }

    public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
        Component component = tableCellEditor.getTableCellEditorComponent(this, this.getValueAt(n, n2), true, n, n2);
        if (component instanceof JTextField && ((JTextField)component).getText().length() > 0) {
            ((JTextField)component).setCaretPosition(((JTextField)component).getText().length() - 1);
            ((JTextField)component).getCaret().setVisible(true);
            ((JTextField)component).setSelectionStart(0);
            ((JTextField)component).setSelectionEnd(((JTextField)component).getText().length());
            ((JTextField)component).getCaret().setSelectionVisible(true);
        }
        this.repaint(this.getCellRect(n, n2, true));
        return component;
    }

    public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
        if (this.cellEditor != null && (n != this.getEditingRow() || n2 != this.getEditingColumn())) {
            this.cellEditor.cancelCellEditing();
        }
        super.changeSelection(n, n2, bl, bl2);
        if (!bl2) {
            this.editCellAt(n, n2);
        }
    }

    public boolean editCellAt(int n, int n2) {
        if (n2 < 0 && ((NodeTableColumnModel)this.getColumnModel()).hasAnchor()) {
            try {
                this.fireTableNeedsScroll(n2);
                return super.editCellAt(n, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (n2 > this.getColumnCount()) {
            try {
                this.fireTableNeedsScroll(1 + n2 - this.getColumnCount());
                return super.editCellAt(n, this.getColumnCount() - 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.editCellAt(n, n2);
    }

    public void addTableTabbedListener(TableTabbedListener tableTabbedListener) {
        this.tabListeners.add(tableTabbedListener);
    }

    public void removeTableTabbedListener(TableTabbedListener tableTabbedListener) {
        this.tabListeners.remove(tableTabbedListener);
    }

    private void fireTableTabbed(boolean bl, boolean bl2) {
        for (TableTabbedListener tableTabbedListener : this.tabListeners) {
            tableTabbedListener.tableTabbed(bl, bl2);
        }
    }

    public void addTableNeedsScrollListener(TableNeedsScrollListener tableNeedsScrollListener) {
        this.scrollListeners.add(tableNeedsScrollListener);
    }

    public void removeTableNeedsScrollListener(TableNeedsScrollListener tableNeedsScrollListener) {
        this.scrollListeners.remove(tableNeedsScrollListener);
    }

    private void fireTableNeedsScroll(int n) {
        for (TableNeedsScrollListener tableNeedsScrollListener : this.scrollListeners) {
            tableNeedsScrollListener.tableNeedsScroll(n);
        }
    }

    public void addTableChangeListener(NodeTableFrame.TableChangeListener tableChangeListener) {
        this.changeListeners.add(tableChangeListener);
    }

    public void removeTableChangeListener(NodeTableFrame.TableChangeListener tableChangeListener) {
        this.changeListeners.remove(tableChangeListener);
    }

    private void fireTableChanged() {
        if (this.changeListeners != null) {
            for (NodeTableFrame.TableChangeListener tableChangeListener : this.changeListeners) {
                tableChangeListener.tableChanged();
            }
        }
    }

    public int getWidth() {
        return this.columnModel.getTotalColumnWidth();
    }

    protected int getTrueColumnCount() {
        return ((NodeTableColumnModel)this.columnModel).getTrueColumnCount();
    }

    public Dimension getPreferredSize() {
        return new Dimension(((NodeTableColumnModel)this.columnModel).getMaxTotalColumnWidth(), this.getRowCount() * this.getRowHeight());
    }

    public void setViewPosition(int n) throws ExceptionHugin {
        ((NodeTableColumnModel)this.columnModel).setViewPosition(n);
    }

    public int getViewPosition() {
        return ((NodeTableColumnModel)this.columnModel).getViewPosition();
    }

    public void setColumnWidth(int n) {
        ((NodeTableColumnModel)this.columnModel).setColumnWidth(n);
    }

    public boolean canCopy() {
        return this.getSelectedColumn() >= 0 && this.getSelectedRow() >= 0;
    }

    public boolean canPaste() {
        boolean bl = false;
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(null);
        return this.hasSelection() && transferable != null;
    }

    public boolean hasSelection() {
        return this.getSelectedColumn() >= 0 && this.getSelectedRow() >= 0;
    }

    public boolean copySelection() {
        int n;
        int[] nArray = this.getSelectedColumns();
        int[] nArray2 = this.getSelectedRows();
        if (nArray2.length == 0 || nArray.length == 0) {
            return false;
        }
        int n2 = nArray[0];
        int n3 = nArray2[0];
        for (n = 1; n < nArray.length; ++n) {
            if (nArray[n] == n2 + n) continue;
            return false;
        }
        for (n = 1; n < nArray2.length; ++n) {
            if (nArray2[n] == n3 + n) continue;
            return false;
        }
        String string = "";
        NodeTableModel nodeTableModel = (NodeTableModel)this.getModel();
        for (n3 = 0; n3 < nArray2.length; ++n3) {
            for (n2 = 0; n2 < nArray.length; ++n2) {
                string = string + nodeTableModel.getValueAt(nArray2[n3], nArray[n2]);
                if (n2 == nArray.length - 1) continue;
                string = string + "\t";
            }
            if (n3 == nArray2.length - 1) continue;
            string = string + "\n";
        }
        StringSelection stringSelection = new StringSelection(string);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
        stringSelection = null;
        string = null;
        return true;
    }

    public boolean pasteSelection() throws IOException, UnsupportedFlavorException {
        int n;
        int n2;
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(null);
        DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
        String string = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this).getTransferData(DataFlavor.stringFlavor);
        string = string.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        int n3 = stringTokenizer.countTokens();
        if (((NodeTableModel)this.dataModel).getDataMode()) {
            stringTokenizer = new StringTokenizer(string);
        }
        int n4 = stringTokenizer.countTokens() / n3;
        String[][] stringArray = new String[n3][n4];
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n4; ++n) {
                stringArray[n2][n] = stringTokenizer.nextToken();
            }
        }
        n2 = this.getSelectedColumn() + this.getViewPosition();
        n = this.getSelectedRow();
        if (n < 0 || n2 < 0) {
            return false;
        }
        this.stopEditing();
        int n5 = Math.min(this.getRowCount() - n, stringArray.length);
        int n6 = Math.min(this.getTrueColumnCount() - n2, stringArray[0].length);
        NodeTableModel nodeTableModel = (NodeTableModel)this.getModel();
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n6; ++j) {
                nodeTableModel.setValueAt(stringArray[i][j], n + i, n2 + j);
            }
        }
        return true;
    }

    public boolean bufferContainsMultipleCells() throws IOException, UnsupportedFlavorException {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(null);
        DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
        if (!dataFlavorArray[0].getDefaultRepresentationClass().equals(InputStream.class)) {
            return false;
        }
        String string = (String)transferable.getTransferData(dataFlavorArray[0]);
        StringTokenizer stringTokenizer = new StringTokenizer(string = string.trim(), "\n");
        int n = stringTokenizer.countTokens();
        if (n > 1) {
            return true;
        }
        stringTokenizer = new StringTokenizer(string);
        int n2 = stringTokenizer.countTokens() / n;
        return n2 > 1;
    }

    public void store() {
        ((NodeTableModel)this.getModel()).store();
    }

    public void restore() {
        ((NodeTableModel)this.getModel()).restore();
    }

    public void normalize() throws ExceptionHugin {
        this.stopEditing();
        NodeTableModel nodeTableModel = (NodeTableModel)this.getModel();
        for (int i = 0; i < nodeTableModel.getColumnCount(); ++i) {
            int n;
            double d = 0.0;
            for (n = 0; n < nodeTableModel.getRowCount(); ++n) {
                d += ((Double)nodeTableModel.getValueAt(n, i)).doubleValue();
            }
            for (n = 0; n < nodeTableModel.getRowCount(); ++n) {
                nodeTableModel.setValueAt(new Double((Double)nodeTableModel.getValueAt(n, i) / d), n, i);
            }
        }
        this.repaint();
    }

    public void reset(int n) throws ExceptionHugin {
        this.stopEditing();
        NodeTableModel nodeTableModel = (NodeTableModel)this.getModel();
        for (int i = 0; i < nodeTableModel.getColumnCount(); ++i) {
            for (int j = 0; j < nodeTableModel.getRowCount(); ++j) {
                nodeTableModel.setValueAt(new Double(n), j, i);
            }
        }
        this.repaint();
    }

    public void randomize(Table table) throws ExceptionHugin {
        this.stopEditing();
        int n = this.getRowCount();
        double[] dArray = new double[n];
        Random random = new Random();
        NodeTableModel nodeTableModel = (NodeTableModel)this.getModel();
        for (int i = 0; i < nodeTableModel.getColumnCount(); ++i) {
            int n2;
            if (table != null && table.getDataItem(i) != 0.0) continue;
            double d = 0.0;
            for (n2 = 0; n2 < nodeTableModel.getRowCount(); ++n2) {
                dArray[n2] = Math.abs(random.nextDouble() % 100.0) + 0.01;
                d += dArray[n2];
            }
            for (n2 = 0; n2 < nodeTableModel.getRowCount(); ++n2) {
                nodeTableModel.setValueAt(new Double(dArray[n2] / d), n2, i);
            }
        }
    }

    public void export(PrintWriter printWriter, NodeTableExportPanel nodeTableExportPanel) throws ExceptionHugin, IOException {
        switch (nodeTableExportPanel.getOperation()) {
            case 0: {
                this.exportToDelimited(printWriter, nodeTableExportPanel.getDelimiter());
                break;
            }
            case 1: {
                this.exportToLatex(printWriter);
            }
        }
    }

    protected void exportToDelimited(PrintWriter printWriter, String string) throws ExceptionHugin {
        if (this.node instanceof ContinuousChanceNode) {
            this.printContNodeTable(printWriter, string);
            return;
        }
        double[] dArray = this.node.getTable().getData();
        int n = this.getRowCount();
        int n2 = ((NodeTableColumnModel)this.getColumnModel()).getFullColumnCount();
        if (this.node instanceof UtilityNode) {
            printWriter.println("Utility");
        } else {
            printWriter.println("CPT");
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                printWriter.print(dArray[i + n * j] + (j < n2 - 1 ? string : ""));
            }
            printWriter.println();
        }
    }

    private void printContNodeTable(PrintWriter printWriter, String string) throws ExceptionHugin {
        int n = this.getRowCount();
        int n2 = ((NodeTableColumnModel)this.getColumnModel()).getFullColumnCount();
        NodeList nodeList = this.node.getTable().getNodes();
        for (int i = 0; i < n2; ++i) {
            printWriter.print(((ContinuousChanceNode)this.node).getAlpha(i) + (i < n2 - 1 ? string : ""));
        }
        printWriter.println();
        for (Node node : nodeList) {
            if (!(node instanceof ContinuousChanceNode) || node == this.node) continue;
            for (int i = 0; i < n2; ++i) {
                printWriter.print(((ContinuousChanceNode)this.node).getBeta((ContinuousChanceNode)node, i) + (i < n2 - 1 ? string : ""));
            }
            printWriter.println();
        }
        for (int i = 0; i < n2; ++i) {
            printWriter.print(((ContinuousChanceNode)this.node).getGamma(i) + (i < n2 - 1 ? string : ""));
        }
        printWriter.println();
    }

    protected void exportToLatex(PrintWriter printWriter) throws ExceptionHugin {
        if (this.node instanceof ContinuousChanceNode) {
            this.latexPrintContNodeTable((ContinuousChanceNode)this.node, printWriter);
        } else {
            this.latexPrintNodeTable(this.node, printWriter);
        }
    }

    private void latexPrintNodeTable(Node node, PrintWriter printWriter) throws ExceptionHugin {
        int n = this.printLatexHeader(node.getParents(), printWriter);
        double[] dArray = node.getTable().getData();
        boolean bl = node instanceof UtilityNode;
        int n2 = GenericTable.getNumberOfStates(node);
        for (int i = 0; i < n2; ++i) {
            printWriter.print(GenericTable.getStateLabel(node, i));
            if (bl) {
                printWriter.print("Utility");
            }
            for (int j = 0; j < n; ++j) {
                printWriter.print(" & " + dArray[i + n2 * j]);
            }
            printWriter.println("\\\\\\hline");
        }
    }

    private void latexPrintContNodeTable(ContinuousChanceNode continuousChanceNode, PrintWriter printWriter) throws ExceptionHugin {
        NodeList nodeList = continuousChanceNode.getParents();
        int n = this.printLatexHeader(nodeList, printWriter);
        Table table = continuousChanceNode.getTable();
        printWriter.print(HuginGUIConstants.get("MISCELLANEOUS_Mean"));
        for (int i = 0; i < n; ++i) {
            printWriter.print(" & " + continuousChanceNode.getAlpha(i));
        }
        printWriter.println("\\\\\\hline");
        for (Node node : table.getNodes()) {
            if (!(node instanceof ContinuousChanceNode) || node == continuousChanceNode) continue;
            printWriter.print(GenericTable.getNodeName(node));
            for (int i = 0; i < n; ++i) {
                printWriter.print(" & " + continuousChanceNode.getBeta((ContinuousChanceNode)node, i));
            }
            printWriter.println("\\\\\\hline");
        }
        printWriter.print(HuginGUIConstants.get("MISCELLANEOUS_Variance"));
        for (int i = 0; i < n; ++i) {
            printWriter.print(" & " + continuousChanceNode.getGamma(i));
        }
        printWriter.println("\\\\\\hline");
    }

    protected int printLatexHeader(NodeList nodeList, PrintWriter printWriter) throws ExceptionHugin {
        int n = this.getRowCount();
        int n2 = ((NodeTableColumnModel)this.getColumnModel()).getFullColumnCount();
        printWriter.print("\\begin{tabular}{l|");
        for (int i = 0; i < n2; ++i) {
            printWriter.print("|r");
        }
        printWriter.println("}");
        ListIterator listIterator = nodeList.listIterator();
        while (listIterator.hasNext()) {
            if (!(listIterator.next() instanceof ContinuousChanceNode)) continue;
            listIterator.remove();
        }
        int[] nArray = this.getParentStates(nodeList);
        int n3 = 1;
        int n4 = nArray[0];
        for (Node node : nodeList) {
            DiscreteNode discreteNode = (DiscreteNode)node;
            int n5 = GenericTable.getNumberOfStates(discreteNode);
            printWriter.print(GenericTable.getNodeName(discreteNode));
            int n6 = n4 / nArray[n3 - 1];
            for (int i = 0; i < n6; ++i) {
                for (int j = 0; j < n5; ++j) {
                    printWriter.print(" & \\multicolumn{" + nArray[n3] + "}{c" + (j < n5 - 1 || i < n6 - 1 ? "|" : "") + "}{" + GenericTable.getStateLabel(discreteNode, j) + "}");
                }
            }
            printWriter.println("\\\\\\hline");
            n4 = nArray[n3 - 1];
            ++n3;
        }
        printWriter.println("\\hline");
        return n2;
    }

    protected int[] getParentStates(NodeList nodeList) throws ExceptionHugin {
        int[] nArray = new int[nodeList.size() + 1];
        int n = nArray.length - 1;
        nArray[n--] = 1;
        int n2 = 1;
        ListIterator listIterator = nodeList.listIterator(nodeList.size());
        while (listIterator.hasPrevious()) {
            Node node = (Node)listIterator.previous();
            if (node instanceof DiscreteNode) {
                n2 = ((DiscreteNode)node).getNumberOfStates();
            }
            nArray[n] = nArray[n + 1] * n2;
            --n;
        }
        return nArray;
    }

    protected static int getNumberOfStates(Node node) throws ExceptionHugin {
        if (node instanceof DiscreteNode) {
            return ((DiscreteNode)node).getNumberOfStates();
        }
        return 1;
    }

    protected static String getStateLabel(Node node, int n) throws ExceptionHugin {
        String string = "";
        if (node instanceof DiscreteNode) {
            string = ((DiscreteNode)node).getStateLabel(n);
        }
        return GenericTable.replaceInString(string);
    }

    protected static String getNodeName(Node node) throws ExceptionHugin {
        String string = node.getName();
        return GenericTable.replaceInString(string);
    }

    protected static String getNodeLabel(Node node) throws ExceptionHugin {
        String string = node.getLabel();
        return GenericTable.replaceInString(string);
    }

    private static String replaceInString(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        String string2 = "";
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (stringBuffer.charAt(i) == '_') {
                string2 = string2 + "\\";
            }
            string2 = string2 + stringBuffer.charAt(i);
        }
        return string2;
    }

    public void setVisibleColumns(int n) {
        ((NodeTableColumnModel)this.columnModel).setVisibleColumns(n);
    }

    public void addColumnListener(ColumnListener columnListener) {
        this.columnListeners.add(columnListener);
    }

    public void removeColumnListener(ColumnListener columnListener) {
        this.columnListeners.remove(columnListener);
    }

    protected void expandAllColumns() throws ExceptionHugin {
        ((NodeTableColumnModel)this.getColumnModel()).expandAll();
    }

    protected void fireColumnCollapsed() {
        for (ColumnListener columnListener : this.columnListeners) {
            columnListener.columnCollapsed();
        }
    }

    protected void fireColumnExpanded() {
        for (ColumnListener columnListener : this.columnListeners) {
            columnListener.columnExpanded();
        }
    }

    public void setStateDisplayMode(int n) throws ExceptionHugin {
        ((NodeTableModel)this.getModel()).setDisplayMode(n);
        ((GenericTableCellEditor)this.getCellEditor(0, 0)).setNumerical(n == 0);
        ((GenericTableCellRenderer)this.getCellRenderer(0, 0)).setNumerical(n == 0);
    }

    public void setPrecision(int n) throws ExceptionHugin {
        this.node.setAttribute("HR_TablePrecision", "" + n);
    }

    public int getPrecision() {
        try {
            String string = this.node.getAttribute("HR_TablePrecision");
            if (string == null || string.trim().length() == 0) {
                string = this.node.getHome().getAttribute("HR_Node_TablePrecision");
            }
            if (string == null || string.trim().length() == 0) {
                string = "6";
            }
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return 6;
        }
    }

    public void setForceDecimals(boolean bl) throws ExceptionHugin {
        this.node.setAttribute("HR_ForceDecimalView", "" + bl);
    }

    public boolean getForceDecimals() {
        try {
            String string = this.node.getAttribute("HR_ForceDecimalView");
            if (string == null || string.trim().length() == 0) {
                string = this.node.getHome().getAttribute("HR_Node_ForceDecimalView");
            }
            return string.equals("true");
        }
        catch (Exception exception) {
            return false;
        }
    }

    private class LoweredHeaderRenderer
    implements TableCellRenderer {
        TableCellRenderer defaultRenderer;

        public LoweredHeaderRenderer(TableCellRenderer tableCellRenderer) {
            this.defaultRenderer = tableCellRenderer;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = this.defaultRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            ((JComponent)component).setBorder(BorderFactory.createEtchedBorder(1));
            return component;
        }
    }

    private class CellSelectionListener
    extends KeyAdapter {
        private CellSelectionListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            boolean bl;
            int n;
            int n2;
            if (keyEvent.getKeyChar() == '\t') {
                n2 = GenericTable.this.getEditingRow();
                n = GenericTable.this.getEditingColumn();
                if (n == GenericTable.this.getColumnCount() - 1 && !keyEvent.isShiftDown()) {
                    GenericTable.this.cellEditor.stopCellEditing();
                    bl = GenericTable.this.getViewPosition() + n == GenericTable.this.getTrueColumnCount() - 1;
                    GenericTable.this.fireTableTabbed(bl, true);
                    if (bl) {
                        if (n2 == GenericTable.this.getRowCount() - 1) {
                            GenericTable.this.changeSelection(0, 0, false, false);
                            GenericTable.this.editCellAt(0, 0);
                        } else {
                            GenericTable.this.changeSelection(n2 + 1, 0, false, false);
                            GenericTable.this.editCellAt(n2 + 1, 0);
                        }
                    } else {
                        GenericTable.this.editCellAt(n2, n);
                    }
                    keyEvent.consume();
                }
                if (n == 0 && keyEvent.isShiftDown()) {
                    GenericTable.this.cellEditor.stopCellEditing();
                    bl = GenericTable.this.getViewPosition() == 0;
                    GenericTable.this.fireTableTabbed(bl, false);
                    if (bl) {
                        if (n2 == 0) {
                            GenericTable.this.changeSelection(GenericTable.this.getRowCount() - 1, GenericTable.this.getColumnCount() - 1, false, false);
                            GenericTable.this.editCellAt(GenericTable.this.getRowCount() - 1, GenericTable.this.getColumnCount() - 1);
                        } else {
                            GenericTable.this.changeSelection(n2 - 1, GenericTable.this.getColumnCount() - 1, false, false);
                            GenericTable.this.editCellAt(n2 - 1, GenericTable.this.getColumnCount() - 1);
                        }
                    } else {
                        GenericTable.this.editCellAt(n2, n);
                    }
                    keyEvent.consume();
                }
            }
            if (keyEvent.getKeyCode() == 10) {
                n2 = GenericTable.this.getEditingRow();
                n = GenericTable.this.getEditingColumn();
                if (n == GenericTable.this.getColumnCount() - 1 && n2 == GenericTable.this.getRowCount() - 1 && !keyEvent.isShiftDown()) {
                    GenericTable.this.cellEditor.stopCellEditing();
                    bl = GenericTable.this.getViewPosition() + n == GenericTable.this.getTrueColumnCount() - 1;
                    GenericTable.this.fireTableTabbed(bl, true);
                    if (bl) {
                        GenericTable.this.changeSelection(0, 0, false, false);
                        GenericTable.this.editCellAt(0, 0);
                    } else {
                        GenericTable.this.changeSelection(0, n, false, false);
                        GenericTable.this.editCellAt(0, n);
                    }
                    keyEvent.consume();
                }
                if (n == 0 && n2 == 0 && keyEvent.isShiftDown()) {
                    GenericTable.this.cellEditor.stopCellEditing();
                    bl = GenericTable.this.getViewPosition() == 0;
                    GenericTable.this.fireTableTabbed(bl, false);
                    if (bl) {
                        GenericTable.this.changeSelection(GenericTable.this.getRowCount() - 1, GenericTable.this.getColumnCount() - 1, false, false);
                        GenericTable.this.editCellAt(GenericTable.this.getRowCount() - 1, GenericTable.this.getColumnCount() - 1);
                    } else {
                        GenericTable.this.changeSelection(GenericTable.this.getRowCount() - 1, n, false, false);
                        GenericTable.this.editCellAt(GenericTable.this.getRowCount() - 1, n);
                    }
                    keyEvent.consume();
                }
            }
            if (keyEvent.getKeyCode() == 37 || keyEvent.getKeyCode() == 39) {
                if (GenericTable.this.editorComp != null) {
                    GenericTable.this.editorComp.dispatchEvent(keyEvent);
                }
                keyEvent.consume();
            }
        }
    }

    private class GenericTableCellRenderer
    extends DefaultTableCellRenderer {
        boolean numerical;

        public GenericTableCellRenderer(boolean bl) {
            this.numerical = bl;
        }

        public void setNumerical(boolean bl) {
            this.numerical = bl;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            try {
                if (this.numerical && (GenericTable.this.node instanceof NumberedDCNode || GenericTable.this.node instanceof NumberedDDNode)) {
                    if (jTable instanceof GenericTable) {
                        return super.getTableCellRendererComponent(jTable, HuginGUIUtils.printDouble(Double.parseDouble(object.toString()), ((GenericTable)jTable).getPrecision(), true), bl, bl2, n, n2);
                    }
                    return super.getTableCellRendererComponent(jTable, HuginGUIUtils.printDouble(Double.parseDouble(object.toString()), ((GenericTable)jTable).getPrecision(), true), bl, bl2, n, n2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                String string = object.toString();
                if (!string.equals("inf") && !string.equals("-inf")) {
                    if (HuginGUIUtils.printDouble(Double.POSITIVE_INFINITY).equals(string)) {
                        return super.getTableCellRendererComponent(jTable, "inf", bl, bl2, n, n2);
                    }
                    if (HuginGUIUtils.printDouble(Double.NEGATIVE_INFINITY).equals(string)) {
                        return super.getTableCellRendererComponent(jTable, "-inf", bl, bl2, n, n2);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }

    private class GenericTableCellEditor
    extends DefaultCellEditor {
        JTextField field;
        boolean numerical;

        public GenericTableCellEditor(boolean bl) {
            super(new JTextField());
            this.numerical = bl;
            this.field = new JTextField(){

                public void paintComponent(Graphics graphics) {
                    super.paintComponent(graphics);
                    Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                    if (component != GenericTable.this && component != this) {
                        GenericTableCellEditor.this.stopCellEditing();
                    }
                }
            };
            this.field.setMargin(new Insets(0, 0, 0, 0));
            this.field.setBorder(BorderFactory.createLineBorder(Color.black));
        }

        public void setNumerical(boolean bl) {
            this.numerical = bl;
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (object != null && this.numerical && (GenericTable.this.node instanceof NumberedDCNode || GenericTable.this.node instanceof NumberedDDNode)) {
                String string = object.toString();
                if (string.equals(HuginGUIUtils.printDouble(Double.POSITIVE_INFINITY))) {
                    object = "inf";
                } else if (string.equals(HuginGUIUtils.printDouble(Double.NEGATIVE_INFINITY))) {
                    object = "-inf";
                } else if (!string.equals("inf") && !string.equals("-inf")) {
                    object = HuginGUIUtils.printDouble(new Double(string));
                }
            }
            this.field.setText(object == null ? "" : object.toString());
            return this.field;
        }

        public Object getCellEditorValue() {
            return this.field.getText();
        }
    }

    public static interface ColumnListener
    extends EventListener {
        public void columnCollapsed();

        public void columnExpanded();
    }

    static class TableModelListener {
        TableModelListener() {
        }

        public void tableDataChanged() {
        }
    }

    public static interface TableNeedsScrollListener
    extends EventListener {
        public void tableNeedsScroll(int var1);
    }

    public static interface TableTabbedListener
    extends EventListener {
        public void tableTabbed(boolean var1, boolean var2);
    }
}

