/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HGUI.GraphItem;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.swing.JPanel;

public class Graph
extends JPanel {
    private static final int vNumGap = 15;
    private static final int hNumGap = 22;
    private static final int padding = 10;
    public int top;
    public int bottom;
    public int left;
    public int right;
    int titleHeight;
    int labelWidth;
    FontMetrics fm;
    String title;
    int min;
    int max;
    int actualMax;
    int hIncrement;
    int vIncrement;
    public static final int precision = 10000;
    Vector<GraphItem> items;

    public Graph(String string, int n, int n2) {
        this.title = string;
        this.min = n;
        this.max = 10000;
        this.actualMax = n2;
        this.items = new Vector();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        int n5;
        super.setBounds(n, n2, n3, n4);
        this.fm = this.getFontMetrics(this.getFont());
        this.titleHeight = this.fm.getHeight();
        this.labelWidth = Math.max(this.fm.stringWidth(new Integer(this.min).toString()), this.fm.stringWidth(new Integer(this.max).toString())) + 2;
        this.top = 10 + this.titleHeight;
        this.bottom = this.getSize().height - 10 - 10;
        this.left = 32;
        this.right = this.getSize().width - 10;
        this.hIncrement = (this.right - this.left) / 10;
        this.vIncrement = (this.bottom - this.top) / 10;
        if (this.hIncrement * 10 < this.right - this.left) {
            n5 = this.right - this.left - this.hIncrement * 10;
            this.right -= n5;
        }
        if (this.vIncrement * 10 < this.bottom - this.top) {
            n5 = this.bottom - this.top - this.vIncrement * 10;
            this.bottom -= n5;
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        BasicStroke basicStroke = new BasicStroke(2.0f, 0, 2);
        Stroke stroke = graphics2D.getStroke();
        this.fm = this.getFontMetrics(this.getFont());
        graphics2D.setColor(Color.gray);
        graphics2D.setFont(new Font("sanserif", 1, 12));
        graphics2D.drawString(this.title, (this.getSize().width - this.fm.stringWidth(this.title)) / 2, 10);
        graphics2D.setFont(new Font("sanserif", 0, 10));
        graphics2D.drawString(this.formatDouble(new Double(this.min)), this.left - 22, this.bottom + 15);
        graphics2D.setColor(Color.BLACK);
        graphics2D.setStroke(basicStroke);
        graphics2D.drawLine(this.left, this.top, this.left, this.bottom);
        graphics2D.drawLine(this.left, this.bottom, this.right, this.bottom);
        graphics2D.setStroke(stroke);
        int n = this.left;
        int n2 = this.bottom;
        Double d = new Double(0.0);
        graphics2D.setColor(Color.BLACK);
        for (int i = 0; i < 10; ++i) {
            n += this.hIncrement;
            n2 -= this.vIncrement;
            Double d2 = new Double(this.actualMax);
            d = d + d2 / 10.0;
            String string = this.formatDouble(d);
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawLine(n, this.bottom + 3, n, this.bottom - 3);
            graphics2D.setColor(Color.gray);
            graphics2D.drawString(string, n - 7, this.bottom + 15);
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawLine(this.left - 3, n2, this.left + 3, n2);
            graphics2D.setColor(Color.gray);
            graphics2D.drawString(string, this.left - 22, n2 + 5);
        }
    }

    private String formatDouble(Double d) {
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMinimumFractionDigits(1);
        decimalFormat.setMaximumFractionDigits(1);
        return decimalFormat.format(d);
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void addItem(String string, int n, Color color) {
        this.items.addElement(new GraphItem(string, n, color));
    }

    public void addItem(String string, int n) {
        this.items.addElement(new GraphItem(string, n, Color.black));
    }

    public void removeItem(String string) {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!this.items.elementAt((int)i).title.equals(string)) continue;
            this.items.removeElementAt(i);
        }
    }
}

