/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.NetworkModel;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HAPI.UtilityNode;
import COM.hugin.HGUI.BeliefBarPanel;
import COM.hugin.HGUI.ContinuousChanceNode;
import COM.hugin.HGUI.DiscreteChanceNode;
import COM.hugin.HGUI.FillingFlowLayout;
import COM.hugin.HGUI.HelpPanel;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.HuginProjectFrame;
import COM.hugin.HGUI.NetworkPanel;
import COM.hugin.HGUI.Node;
import COM.hugin.HGUI.VerticalFlowLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HuginAnalysisDialog
extends JDialog {
    HuginProjectFrame projectFrame;
    GroupDefiner groupDefiner;
    GroupOfNodes[] groups;
    BeliefBarPanel beliefPanel;
    Dimension minimum = new Dimension(600, 300);
    JCheckBox[] checks;
    JButton defineGroup;
    JButton addToGroup;
    JButton removeFromGroup;
    JList customGroup;
    Vector<ListItem> customGroupData;
    HelpPanel helpPanel;
    String helpPage = null;
    protected static int maxTitleLength = 25;
    protected int listTabSize = 6;
    protected double sufficiency = 0.02;
    protected double importance = 0.05;
    JButton ok;
    JButton cancel;
    JButton perform;
    JButton help;
    protected static final int OK_PERFORM_CANCEL = 0;
    protected static final int CLOSE_PERFORM = 1;

    HuginAnalysisDialog(HuginProjectFrame huginProjectFrame, String string, boolean bl) {
        super(Hugin.mainFrame, string, bl);
        this.projectFrame = huginProjectFrame;
        this.beliefPanel = huginProjectFrame.getBeliefBarPanel();
        this.setUpListeners();
        this.helpPanel = new HelpPanel(this);
    }

    HuginAnalysisDialog(JDialog jDialog, HuginProjectFrame huginProjectFrame, String string, boolean bl) {
        super(jDialog, string, bl);
        this.projectFrame = huginProjectFrame;
        this.beliefPanel = huginProjectFrame.getBeliefBarPanel();
        this.setUpListeners();
        this.helpPanel = new HelpPanel(this);
    }

    HuginAnalysisDialog(HuginProjectFrame huginProjectFrame, String string) {
        super((Frame)Hugin.mainFrame, string);
        this.projectFrame = huginProjectFrame;
        this.beliefPanel = huginProjectFrame.getBeliefBarPanel();
        this.setUpListeners();
        this.helpPanel = new HelpPanel(this);
    }

    protected void setUpListeners() {
        this.projectFrame.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
                HuginAnalysisDialog.this.dispose();
            }
        });
        this.projectFrame.addModeChangeListener(new HuginProjectFrame.ModeChangeListener(){

            public void modeChanged(int n) {
                HuginAnalysisDialog.this.dispose();
            }
        });
    }

    protected abstract JPanel createContent() throws ExceptionHugin;

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.setSize(this.minimum.getWidth(), this.minimum.getHeight());
        return dimension;
    }

    protected JPanel createInfoVarsTab() throws ExceptionHugin {
        JPanel jPanel = new JPanel(new BorderLayout());
        String[] stringArray = this.getGroupNames(this.projectFrame.getNetworkPanel().getHome());
        JPanel jPanel2 = new JPanel(new GridLayout(stringArray.length + 2, 1));
        this.checks = new JCheckBox[stringArray.length + 2];
        this.groups = new GroupOfNodes[stringArray.length + 1];
        this.checks[0] = new JCheckBox(HuginGUIConstants.get("VOI_No_Group"));
        this.groups[0] = new GroupOfNodes(HuginGUIConstants.get("VOI_No_Group"), this.projectFrame.getNetworkPanel().nodeList, this.includeCG());
        jPanel2.add(this.checks[0]);
        for (int i = 1; i < this.checks.length - 1; ++i) {
            this.checks[i] = new JCheckBox(stringArray[i - 1]);
            this.groups[i] = new GroupOfNodes(stringArray[i - 1], this.projectFrame.getNetworkPanel().nodeList, this.includeCG());
            jPanel2.add(this.checks[i]);
        }
        this.checks[this.checks.length - 1] = new JCheckBox(HuginGUIConstants.get("VOI_Custom_Group"));
        this.checks[this.checks.length - 1].addActionListener(new EnableCustomGroupListener());
        jPanel2.add(this.checks[this.checks.length - 1]);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel2, "North");
        JLabel jLabel = new JLabel(HuginGUIConstants.get("Include_groups"));
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)jLabel, "North");
        jPanel4.add(new JScrollPane(jPanel3));
        this.customGroupData = new Vector();
        this.customGroup = new JList<ListItem>(this.customGroupData);
        this.customGroup.setBorder(BorderFactory.createLoweredBevelBorder());
        this.customGroup.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                HuginAnalysisDialog.this.removeFromGroup.setEnabled(HuginAnalysisDialog.this.customGroup.getSelectedIndex() >= 0);
            }
        });
        this.customGroup.setEnabled(false);
        JPanel jPanel5 = new JPanel(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.customGroup);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("Custom_group")));
        jPanel5.add(jScrollPane);
        this.defineGroup = new JButton(HuginGUIConstants.get("Define"));
        this.defineGroup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HuginAnalysisDialog.this.groupDefiner.setGroup(HuginAnalysisDialog.this.customGroupData);
                HuginAnalysisDialog.this.groupDefiner.setMode(1);
                HuginAnalysisDialog.this.groupDefiner.pack();
                HuginGUIUtils.placeNextTo(HuginAnalysisDialog.this, HuginAnalysisDialog.this.groupDefiner);
                HuginAnalysisDialog.this.groupDefiner.setVisible(true);
            }
        });
        this.defineGroup.setEnabled(false);
        this.removeFromGroup = new JButton(HuginGUIConstants.get("Remove"));
        this.removeFromGroup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = HuginAnalysisDialog.this.customGroup.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    HuginAnalysisDialog.this.customGroupData.remove(objectArray[i]);
                }
                HuginAnalysisDialog.this.customGroup.setListData(HuginAnalysisDialog.this.customGroupData);
            }
        });
        this.removeFromGroup.setEnabled(false);
        JPanel jPanel6 = new JPanel(new FlowLayout());
        jPanel6.add(this.removeFromGroup);
        jPanel6.add(this.defineGroup);
        jPanel5.add((Component)jPanel6, "South");
        JSplitPane jSplitPane = new JSplitPane(1, jPanel4, jPanel5);
        jPanel.add(jSplitPane);
        return jPanel;
    }

    protected String[] getGroupNames(NetworkModel networkModel) throws ExceptionHugin {
        String string = networkModel.getAttribute("HR_Groups_IDs");
        if (string == null || string.trim().length() == 0) {
            int n;
            String string2 = networkModel.getAttribute("HR_Groups_UserGroupsNo");
            int n2 = n = string2 == null || string2.length() == 0 ? 0 : Integer.parseInt(string2);
            if (n == 0) {
                return new String[0];
            }
            String string3 = networkModel.getAttribute("HR_Groups_GroupNames");
            if (string3 == null || string3.length() == 0) {
                return new String[0];
            }
            String[] stringArray = new String[n];
            int n3 = string3.indexOf(9);
            int n4 = 0;
            while (n3 >= 0 && n4 < stringArray.length) {
                stringArray[n4++] = string3.substring(0, n3);
                string3 = string3.substring(n3 + 1);
                n3 = string3.indexOf(9);
            }
            if (n4 < stringArray.length) {
                stringArray[n4] = string3;
            }
            return stringArray;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken());
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = networkModel.getAttribute("HR_Group_" + (String)vector.get(i) + "_Name");
        }
        return stringArray;
    }

    public void setGroup(Vector<ListItem> vector, int n) {
        switch (n) {
            case 1: {
                this.customGroupData = new Vector<ListItem>(vector);
                this.customGroup.setListData(this.customGroupData);
            }
        }
    }

    protected Vector<ListItem> customGroupNodes(COM.hugin.HAPI.Node node) {
        return this.customGroupNodes(node, false);
    }

    protected Vector<ListItem> customGroupNodes(COM.hugin.HAPI.Node node, boolean bl) {
        Vector<ListItem> vector = new Vector<ListItem>();
        BeliefBarPanel beliefBarPanel = this.projectFrame.getBeliefBarPanel();
        try {
            for (COM.hugin.HAPI.Node node2 : beliefBarPanel.getDomain().getNodes()) {
                if (node2 == node) continue;
                if (node2 instanceof COM.hugin.HAPI.DiscreteChanceNode) {
                    vector.add(new ListItem((COM.hugin.HAPI.DiscreteChanceNode)node2));
                    continue;
                }
                if (!bl || !(node2 instanceof COM.hugin.HAPI.ContinuousChanceNode)) continue;
                vector.add(new ListItem((COM.hugin.HAPI.ContinuousChanceNode)node2));
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin.getMessage());
        }
        return vector;
    }

    protected JPanel getButtonPanel(int n) {
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        JPanel jPanel3 = new JPanel(new FlowLayout(2));
        this.ok = this.getOKButton();
        this.perform = this.getPerformButton();
        this.cancel = this.getCancelButton();
        if (n == 0) {
            jPanel3.add(this.ok);
        }
        if (n == 0 || n == 1) {
            jPanel3.add(this.perform);
        }
        if (n == 0 || n == 1) {
            jPanel3.add(this.cancel);
        }
        if (n == 1) {
            this.cancel.setText(HuginGUIConstants.get("CLOSE_BUTTON_LABEL"));
        }
        this.help = this.getHelpButton();
        jPanel2.add(this.help);
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        return jPanel;
    }

    protected JButton getOKButton() {
        JButton jButton = new JButton(HuginGUIConstants.get("OK_button"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    HuginAnalysisDialog.this.dispose();
                    HuginAnalysisDialog.this.projectFrame.getNetworkPanel().containsUnsavedChanges(true);
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
            }
        });
        return jButton;
    }

    protected JButton getCancelButton() {
        JButton jButton = new JButton(HuginGUIConstants.get("cancel_button"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HuginAnalysisDialog.this.dispose();
            }
        });
        return jButton;
    }

    protected JButton getHelpButton() {
        JButton jButton = new JButton(HuginGUIConstants.get("help_button"));
        jButton.addActionListener(new HelpListener(this.helpPage));
        return jButton;
    }

    protected abstract JButton getPerformButton();

    protected void enterEvidence(Vector<EvidenceListItem> vector) throws ExceptionHugin {
        for (int i = 0; i < vector.size(); ++i) {
            EvidenceListItem evidenceListItem = vector.get(i);
            evidenceListItem.enterEvidence();
        }
    }

    protected NodeList getEvidenceNodes() {
        NodeList nodeList = new NodeList();
        try {
            for (COM.hugin.HAPI.Node node : this.beliefPanel.getDomain().getNodes()) {
                if (node instanceof UtilityNode || !node.evidenceIsEntered()) continue;
                nodeList.add(node);
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin.getMessage());
        }
        return nodeList;
    }

    protected Vector<EvidenceListItem> getEvidence() {
        Vector<EvidenceListItem> vector = new Vector<EvidenceListItem>();
        try {
            for (COM.hugin.HAPI.Node node : this.beliefPanel.getDomain().getNodes()) {
                if (node instanceof UtilityNode || !node.evidenceIsEntered()) continue;
                if (node instanceof COM.hugin.HAPI.DiscreteChanceNode) {
                    vector.add(new DiscreteEvidenceListItem((COM.hugin.HAPI.DiscreteChanceNode)node));
                }
                if (!(node instanceof COM.hugin.HAPI.ContinuousChanceNode)) continue;
                vector.add(new ContinuousEvidenceListItem((COM.hugin.HAPI.ContinuousChanceNode)node));
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            exceptionHugin.printStackTrace();
            new HuginGUIError(exceptionHugin.getMessage());
        }
        return vector;
    }

    protected void enterSelectedEvidence(JList jList) throws ExceptionHugin {
        DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
        for (int i = 0; i < defaultListModel.size(); ++i) {
            if (!jList.isSelectedIndex(i)) continue;
            EvidenceListItem evidenceListItem = (EvidenceListItem)defaultListModel.get(i);
            evidenceListItem.enterEvidence();
        }
    }

    protected Vector<EvidenceListItem> getEvidenceVector(JList jList) throws ExceptionHugin {
        DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
        Vector<EvidenceListItem> vector = new Vector<EvidenceListItem>();
        for (int i = 0; i < defaultListModel.getSize(); ++i) {
            if (!jList.isSelectedIndex(i)) continue;
            vector.add((EvidenceListItem)defaultListModel.getElementAt(i));
        }
        return vector;
    }

    protected String getSelectedEvidence(JList jList) throws ExceptionHugin {
        String string = "";
        DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
        for (int i = 0; i < defaultListModel.getSize(); ++i) {
            if (!jList.isSelectedIndex(i)) continue;
            string = string + (EvidenceListItem)defaultListModel.getElementAt(i) + " ";
        }
        return string;
    }

    protected void generateSubsets(int[] nArray, int n, Vector<EvidenceListItem> vector, Vector<int[]> vector2, int n2, int n3) {
        if (n == vector.size()) {
            if (vector.size() > 0 && n2 <= n3) {
                int[] nArray2 = new int[vector.size()];
                for (int i = 0; i < vector.size(); ++i) {
                    nArray2[i] = nArray[i];
                }
                vector2.add(nArray2);
            }
        } else {
            for (int i = 0; i < 2; ++i) {
                nArray[n] = i;
                this.generateSubsets(nArray, n + 1, vector, vector2, n2 + i, n3);
            }
        }
    }

    protected JTextArea getTextArea() {
        return this.getTextArea(8, 20);
    }

    protected JTextArea getTextArea(int n, int n2) {
        JTextArea jTextArea = new JTextArea(n, n2);
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setDisabledTextColor(Color.black);
        jTextArea.setBackground(this.getBackground());
        jTextArea.setTabSize(this.listTabSize);
        return jTextArea;
    }

    protected double costOfOmission(double[] dArray, double[] dArray2) {
        double d = 0.0;
        if (dArray.length != dArray2.length) {
            return Double.POSITIVE_INFINITY;
        }
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] == 0.0) continue;
            if (dArray2[i] == 0.0) {
                return Double.POSITIVE_INFINITY;
            }
            d += dArray[i] * Math.log(dArray[i] / dArray2[i]);
        }
        return d;
    }

    protected double d(double d, double d2) {
        if (d2 == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        return Math.abs(d / d2 - 1.0);
    }

    protected boolean isSufficient(double d, double d2, double d3) {
        return this.d(d, d2) < d3;
    }

    protected boolean isImportant(double d, double d2, double d3) {
        return this.d(d, d2) > d3;
    }

    protected boolean isFindingIrrelevant(Vector<EvidenceListItem> vector, Vector<int[]> vector2, double[] dArray, int n, double d) {
        for (int i = 0; i < vector2.size(); ++i) {
            int[] nArray = vector2.get(i);
            if (nArray[n] != 0) continue;
            int n2 = 1;
            for (int j = n + 1; j < vector.size(); ++j) {
                n2 *= 2;
            }
            double d2 = dArray[i];
            double d3 = dArray[i + n2];
            if (this.isSufficient(d2, d3, d)) continue;
            return false;
        }
        return true;
    }

    int promptUser(int n) {
        if (n > 100) {
            return JOptionPane.showConfirmDialog(this, HuginGUIConstants.get("SE_Confirm_propagations_message1") + n + " " + HuginGUIConstants.get("SE_Confirm_propagations_message2") + "\n" + HuginGUIConstants.get("SE_Confirm_propagations_message3"), HuginGUIConstants.get("SE_Confirm_propagations"), 0, 2, null);
        }
        return 0;
    }

    protected JPanel getEvidenceSelectionPanel(JList jList) {
        DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
        Vector<EvidenceListItem> vector = this.getEvidence();
        for (int i = 0; i < vector.size(); ++i) {
            defaultListModel.addElement(vector.get(i));
        }
        jList.setBorder(BorderFactory.createLoweredBevelBorder());
        jList.addListSelectionListener(new MyListSelectionListener(jList){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = this.list.getSelectedIndex();
            }
        });
        jList.setEnabled(true);
        JPanel jPanel = new JPanel(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(jList);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("SE_selected_evidence")));
        jPanel.add(jScrollPane);
        JButton jButton = new JButton(HuginGUIConstants.get("clear_button"));
        jButton.addActionListener(new MyActionListener(jList){

            public void actionPerformed(ActionEvent actionEvent) {
                this.list.clearSelection();
            }
        });
        JButton jButton2 = new JButton(HuginGUIConstants.get("selectAll_button"));
        jButton2.addActionListener(new MyActionListener(jList){

            public void actionPerformed(ActionEvent actionEvent) {
                this.list.addSelectionInterval(0, this.list.getModel().getSize() - 1);
            }
        });
        JPanel jPanel2 = new JPanel(new FlowLayout());
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel.add(jScrollPane);
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    protected boolean includeCG() {
        return false;
    }

    protected static class DoubleTableRenderer
    extends JLabel
    implements TableCellRenderer {
        int precision = 2;

        public DoubleTableRenderer(int n) {
            this.precision = n;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            try {
                if (object instanceof Double) {
                    if ((object = HuginGUIUtils.printDouble((Double)object, this.precision)) == null) {
                        this.setText("0.0");
                    } else {
                        this.setText(object.toString());
                    }
                } else {
                    this.setText(object.toString());
                }
            }
            catch (Exception exception) {
                this.setText("?");
            }
            return this;
        }
    }

    protected static class NodeWrapper {
        COM.hugin.HAPI.Node node;
        String nodeTitle;

        public NodeWrapper(COM.hugin.HAPI.Node node) {
            this.node = node;
            try {
                this.nodeTitle = HuginGUIUtils.getNodeTitle(node);
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }

        public String toString() {
            String string = this.nodeTitle;
            if (string.length() > maxTitleLength) {
                string = string.substring(0, maxTitleLength);
            }
            return string;
        }
    }

    protected static class NodeListModel
    extends DefaultComboBoxModel {
        ArrayList<NodeWrapper> nodes;

        public NodeListModel(COM.hugin.HAPI.Node node) {
            this.discreteNodes(node);
        }

        public void discreteNodes(COM.hugin.HAPI.Node node) {
            try {
                this.nodes = new ArrayList();
                if (node == null) {
                    return;
                }
                for (COM.hugin.HAPI.Node node2 : node.getHome().getNodes()) {
                    if (node2 == node || !node.getClass().equals(node2.getClass())) continue;
                    this.nodes.add(new NodeWrapper(node2));
                }
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }

        public NodeListModel(Domain domain, COM.hugin.HAPI.Node node) {
            try {
                this.nodes = new ArrayList();
                if (domain == null) {
                    return;
                }
                for (COM.hugin.HAPI.Node node2 : domain.getNodes()) {
                    if (node2 == node || !(node2 instanceof COM.hugin.HAPI.DiscreteChanceNode) || node2.evidenceIsEntered()) continue;
                    this.nodes.add(new NodeWrapper(node2));
                }
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }

        public int getSize() {
            return this.nodes.size();
        }

        public Object getElementAt(int n) {
            return this.nodes.get(n);
        }
    }

    abstract class MyListSelectionListener
    implements ListSelectionListener {
        JList list;

        MyListSelectionListener(JList jList) {
            this.list = jList;
        }
    }

    abstract class MyActionListener
    implements ActionListener {
        JList list;

        MyActionListener(JList jList) {
            this.list = jList;
        }
    }

    protected class ContinuousEvidenceListItem
    extends EvidenceListItem {
        boolean hasEvidence;
        double value;

        public ContinuousEvidenceListItem(COM.hugin.HAPI.ContinuousChanceNode continuousChanceNode) throws ExceptionHugin {
            this.hasEvidence = false;
            this.node = continuousChanceNode;
            this.empty = false;
            if (continuousChanceNode.evidenceIsEntered()) {
                this.value = continuousChanceNode.getEnteredValue();
                this.hasEvidence = true;
            }
        }

        public boolean isContinuous() {
            return true;
        }

        public void retractEvidence() throws ExceptionHugin {
            COM.hugin.HAPI.ContinuousChanceNode continuousChanceNode = (COM.hugin.HAPI.ContinuousChanceNode)this.node;
            continuousChanceNode.retractFindings();
        }

        public void enterEvidence() throws ExceptionHugin {
            COM.hugin.HAPI.ContinuousChanceNode continuousChanceNode = (COM.hugin.HAPI.ContinuousChanceNode)this.node;
            if (this.hasEvidence) {
                continuousChanceNode.retractFindings();
                continuousChanceNode.enterValue(this.value);
            }
        }

        public String toString() {
            if (this.empty) {
                return " ";
            }
            try {
                return HuginGUIUtils.getNodeTitle(this.node);
            }
            catch (Exception exception) {
                return "-------";
            }
        }
    }

    protected class DiscreteEvidenceListItem
    extends EvidenceListItem {
        boolean hasEvidence;
        double[] findings;

        public DiscreteEvidenceListItem(COM.hugin.HAPI.DiscreteChanceNode discreteChanceNode) throws ExceptionHugin {
            this.hasEvidence = false;
            this.node = discreteChanceNode;
            this.empty = false;
            if (discreteChanceNode.evidenceIsEntered()) {
                int n = discreteChanceNode.getNumberOfStates();
                this.findings = new double[n];
                this.hasEvidence = true;
                for (int i = 0; i < n; ++i) {
                    this.findings[i] = discreteChanceNode.getEnteredFinding(i);
                }
            }
        }

        public boolean isDiscrete() {
            return true;
        }

        public void retractEvidence() throws ExceptionHugin {
            COM.hugin.HAPI.DiscreteChanceNode discreteChanceNode = (COM.hugin.HAPI.DiscreteChanceNode)this.node;
            discreteChanceNode.retractFindings();
        }

        public void enterEvidence() throws ExceptionHugin {
            COM.hugin.HAPI.DiscreteChanceNode discreteChanceNode = (COM.hugin.HAPI.DiscreteChanceNode)this.node;
            if (this.hasEvidence) {
                discreteChanceNode.retractFindings();
                int n = discreteChanceNode.getNumberOfStates();
                for (int i = 0; i < n; ++i) {
                    discreteChanceNode.enterFinding(i, this.findings[i]);
                }
            }
        }

        public String toString() {
            if (this.empty) {
                return " ";
            }
            try {
                return HuginGUIUtils.getNodeTitle(this.node);
            }
            catch (Exception exception) {
                return "-------";
            }
        }
    }

    protected class EvidenceListItem
    extends ListItem {
        protected EvidenceListItem() {
        }

        public void enterEvidence() throws ExceptionHugin {
        }

        public void retractEvidence() throws ExceptionHugin {
        }

        public boolean isDiscrete() {
            return false;
        }

        public boolean isContinuous() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ListItem
    implements Comparable<ListItem>,
    Cloneable {
        protected COM.hugin.HAPI.Node node;
        boolean empty;

        public ListItem() {
        }

        public ListItem(COM.hugin.HAPI.Node node) {
            this.node = node;
            this.empty = false;
        }

        public String toString() {
            if (this.empty) {
                return " ";
            }
            try {
                return HuginGUIUtils.getNodeTitle(this.node);
            }
            catch (Exception exception) {
                return "-------";
            }
        }

        public boolean isEmpty() {
            return this.empty;
        }

        public COM.hugin.HAPI.Node getNode() {
            return this.node;
        }

        public boolean equals(Object object) {
            return object instanceof ListItem && ((ListItem)object).getNode().equals(this.node);
        }

        @Override
        public int compareTo(ListItem listItem) {
            try {
                return HuginGUIUtils.compareNodes(this.getNode(), listItem.getNode(), 0);
            }
            catch (Exception exception) {
                return -1;
            }
        }

        public void setEmpty(boolean bl) {
            this.empty = bl;
        }

        public Object clone() {
            return new ListItem(this.getNode());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class GroupOfNodes {
        String name = "";
        NodeList nodeList = new NodeList();

        GroupOfNodes(String string, AbstractList<Node> abstractList, boolean bl) {
            this.name = string;
            boolean bl2 = string.equals(HuginGUIConstants.get("VOI_No_Group"));
            for (Node node : abstractList) {
                if (!(node instanceof DiscreteChanceNode) && (!bl || !(node instanceof ContinuousChanceNode)) || (!bl2 || node.getGroupName() != null && !node.getGroupName().equals("") && !node.getGroupName().equalsIgnoreCase(HuginGUIConstants.get("VOI_No_Group"))) && (node.getGroupName() == null || !node.getGroupName().equals(string))) continue;
                try {
                    COM.hugin.HAPI.Node node2 = HuginAnalysisDialog.this.beliefPanel.getDomain().getNodeByName(node.getName());
                    if (node2 == null) continue;
                    this.nodeList.add(node2);
                }
                catch (ExceptionHugin exceptionHugin) {
                    exceptionHugin.printStackTrace();
                }
            }
        }

        protected String getName() {
            return this.name;
        }

        protected NodeList getNodes() {
            return this.nodeList;
        }
    }

    protected class EnableCustomGroupListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = HuginAnalysisDialog.this.checks[HuginAnalysisDialog.this.checks.length - 1].isSelected();
            HuginAnalysisDialog.this.customGroup.setEnabled(bl);
            HuginAnalysisDialog.this.defineGroup.setEnabled(bl);
            HuginAnalysisDialog.this.removeFromGroup.setEnabled(bl && HuginAnalysisDialog.this.customGroup.getSelectedIndex() >= 0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class GroupDefiner
    extends JDialog {
        JList customGroup;
        JList allNodes;
        Vector<ListItem> groupData;
        Vector<ListItem> nodeData;
        NetworkPanel.SelectionListener listener;
        NetworkPanel panel;
        COM.hugin.HAPI.Node target;
        JButton add;
        JButton remove;
        JButton addAll;
        JButton removeAll;
        JButton ok;
        JButton cancel;
        int mode;
        public static final int MODE_EVIDENCE = 0;
        public static final int MODE_GROUP = 1;

        public GroupDefiner(JDialog jDialog, NetworkPanel networkPanel, COM.hugin.HAPI.Node node) {
            super((Dialog)jDialog, HuginGUIConstants.get("Custom_Group"));
            this.target = null;
            this.mode = 1;
            this.groupData = new Vector();
            this.nodeData = new Vector();
            this.target = node;
            this.panel = networkPanel;
            this.nodeData = HuginAnalysisDialog.this.customGroupNodes(node);
            Collections.sort(this.nodeData);
            this.listener = new NetworkPanel.SelectionListener(){

                public void selectionChanged(NetworkPanel.SelectionEvent selectionEvent) {
                }
            };
            networkPanel.addSelectionListener(this.listener);
            JPanel jPanel = new JPanel(new BorderLayout());
            JPanel jPanel2 = new JPanel(new FillingFlowLayout());
            this.customGroup = new JList<ListItem>(this.groupData);
            this.allNodes = new JList();
            JPanel jPanel3 = new JPanel(new VerticalFlowLayout());
            this.add = new JButton(">>"){

                public Insets getInsets() {
                    return new Insets(5, 5, 5, 5);
                }
            };
            this.add.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Object[] objectArray = GroupDefiner.this.allNodes.getSelectedValues();
                    for (int i = 0; i < objectArray.length; ++i) {
                        if (!(objectArray[i] instanceof ListItem) || GroupDefiner.this.groupData.contains((ListItem)objectArray[i])) continue;
                        GroupDefiner.this.groupData.add((ListItem)objectArray[i]);
                        GroupDefiner.this.nodeData.remove((ListItem)objectArray[i]);
                    }
                    Collections.sort(GroupDefiner.this.groupData);
                    GroupDefiner.this.customGroup.setListData(GroupDefiner.this.groupData);
                    GroupDefiner.this.allNodes.setListData(GroupDefiner.this.nodeData);
                }
            });
            this.addAll = new JButton(HuginGUIConstants.get("Add_All")){

                public Insets getInsets() {
                    return new Insets(5, 5, 5, 5);
                }
            };
            this.addAll.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    for (int i = 0; i < GroupDefiner.this.nodeData.size(); ++i) {
                        ListItem listItem = GroupDefiner.this.nodeData.get(i);
                        if (GroupDefiner.this.groupData.contains(listItem)) continue;
                        GroupDefiner.this.groupData.add(listItem);
                    }
                    GroupDefiner.this.nodeData.clear();
                    Collections.sort(GroupDefiner.this.groupData);
                    GroupDefiner.this.customGroup.setListData(GroupDefiner.this.groupData);
                    GroupDefiner.this.allNodes.setListData(GroupDefiner.this.nodeData);
                }
            });
            this.remove = new JButton("<<"){

                public Insets getInsets() {
                    return new Insets(5, 5, 5, 5);
                }
            };
            this.remove.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Object[] objectArray = GroupDefiner.this.customGroup.getSelectedValues();
                    for (int i = 0; i < objectArray.length; ++i) {
                        if (!(objectArray[i] instanceof ListItem)) continue;
                        GroupDefiner.this.nodeData.add((ListItem)objectArray[i]);
                        GroupDefiner.this.groupData.remove((ListItem)objectArray[i]);
                    }
                    Collections.sort(GroupDefiner.this.nodeData);
                    GroupDefiner.this.customGroup.setListData(GroupDefiner.this.groupData);
                    GroupDefiner.this.allNodes.setListData(GroupDefiner.this.nodeData);
                }
            });
            this.removeAll = new JButton(HuginGUIConstants.get("Clear")){

                public Insets getInsets() {
                    return new Insets(5, 5, 5, 5);
                }
            };
            this.removeAll.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    GroupDefiner.this.clear();
                }
            });
            jPanel3.add(this.add);
            jPanel3.add(this.remove);
            jPanel3.add(this.addAll);
            jPanel3.add(this.removeAll);
            jPanel2.add(new JScrollPane(this.allNodes));
            jPanel2.add(jPanel3);
            jPanel2.add(new JScrollPane(this.customGroup));
            JPanel jPanel4 = new JPanel(new FlowLayout());
            this.ok = new JButton(HuginGUIConstants.get("OK_button"));
            this.ok.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    HuginAnalysisDialog.this.setGroup(GroupDefiner.this.groupData, GroupDefiner.this.mode);
                    GroupDefiner.this.dispose();
                }
            });
            this.cancel = new JButton(HuginGUIConstants.get("cancel_button"));
            this.cancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    GroupDefiner.this.dispose();
                }
            });
            jPanel4.add(this.ok);
            jPanel4.add(this.cancel);
            jPanel.add(jPanel2);
            jPanel.add((Component)jPanel4, "South");
            this.setContentPane(jPanel);
            this.addWindowListener(new WindowAdapter(){

                public void windowClosed(WindowEvent windowEvent) {
                    if (GroupDefiner.this.listener != null) {
                        GroupDefiner.this.panel.removeSelectionListener(GroupDefiner.this.listener);
                    }
                }
            });
            this.allNodes.setListData(this.nodeData);
        }

        public void setGroup(Vector<ListItem> vector) {
            this.clear();
            for (int i = 0; i < vector.size(); ++i) {
                ListItem listItem = vector.get(i);
                this.groupData.add(listItem);
                this.nodeData.remove(listItem);
            }
            Collections.sort(this.groupData);
            this.customGroup.setListData(this.groupData);
            Collections.sort(this.nodeData);
            this.allNodes.setListData(this.nodeData);
        }

        public void setExcludeGroup(Vector<ListItem> vector) {
            for (int i = 0; i < vector.size(); ++i) {
                ListItem listItem = vector.get(i);
                this.groupData.remove(listItem);
                this.nodeData.remove(listItem);
            }
            this.customGroup.setListData(this.groupData);
            this.allNodes.setListData(this.nodeData);
        }

        private void clear() {
            for (int i = 0; i < this.groupData.size(); ++i) {
                ListItem listItem = this.groupData.get(i);
                if (this.nodeData.contains(listItem)) continue;
                this.nodeData.add(listItem);
            }
            this.groupData.clear();
            Collections.sort(this.groupData);
            this.customGroup.setListData(this.groupData);
            this.allNodes.setListData(this.nodeData);
        }

        public Vector<ListItem> getGroup() {
            return this.groupData;
        }

        public void setMode(int n) {
            this.mode = n;
        }
    }

    protected class HelpListener
    implements ActionListener {
        String helpPage;

        public HelpListener(String string) {
            this.helpPage = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HuginAnalysisDialog.this.helpPanel.setHelpPage(this.helpPage);
            if (!HuginAnalysisDialog.this.helpPanel.isVisible()) {
                int n = HuginAnalysisDialog.this.getX() - HuginAnalysisDialog.this.helpPanel.getWidth();
                if (n < 5 && (n = HuginAnalysisDialog.this.getX() + HuginAnalysisDialog.this.getWidth()) + HuginAnalysisDialog.this.helpPanel.getWidth() > Toolkit.getDefaultToolkit().getScreenSize().width - 5) {
                    n = 5;
                }
                HuginAnalysisDialog.this.helpPanel.setLocation(n, HuginAnalysisDialog.this.getY());
                HuginAnalysisDialog.this.helpPanel.setVisible(true);
            }
        }
    }
}

