/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIFrame;
import COM.hugin.HGUI.HuginProjectFrame;
import COM.hugin.HGUI.NetworkNamingPane;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.basic.BasicFileChooserUI;

public class HuginFileLoader
extends JFileChooser
implements PropertyChangeListener {
    static final int NO_HUGIN_FILE = -1;
    static final int NETWORK_FILE = 0;
    static final int DATA_FILE = 1;
    static final int HKB_FILE = 2;
    static final int NET_FILE = 3;
    static final int NET_57_FILE = 4;
    static final int HKB_57_FILE = 5;
    static final int SAVE_AS_FILE = 6;
    static final int GIF_FILE = 7;
    static final int BMP_FILE = 8;
    static final int CASE_FILE = 9;
    static final int HTML_FILE = 10;
    static final int ALL_FILES = 11;
    static final int PASSWD_HKB = 12;
    static final int NUM_FILE = 13;
    static final int GIF_JPG_PNG = 14;
    static final int JAR_ZIP = 15;
    static final int PDF_FILE = 16;
    static final int SAVE_CLASSCOLLECTION = 100;
    static final int DIRECTORY = 101;
    protected static final int SELECT = 0;
    protected static final int OPEN_NET = 1;
    protected static final int SAVE_NET = 2;
    protected static final int SAVE_CASES = 3;
    protected static final int SAVE_DATA = 4;
    protected static final int SAVE = 5;
    private String title = "";
    private String approveButtonText = "";
    private int fileType;
    HuginProjectFrame project = null;
    private boolean saveMode = false;
    private SecurityManager oldSecurityManager;
    String[][] extensions = new String[][]{{".oobn", ".net", ".hkb"}, {".dat"}, {".hkb"}, {".oobn"}, {".net"}, {".hkb"}, {".none"}, {".gif"}, {".bmp"}, {".hcs", ".dat"}, {".html"}, {""}, {".hkb"}, {".num"}, {".gif", ".jpg", ".png"}, {".jar", ".zip"}, {".pdf"}};

    public HuginFileLoader(int n, int n2) {
        this.setDialogTitle(this.setTitle(n2));
        if (n == 6) {
            HuginFileFilter huginFileFilter = new HuginFileFilter(3);
            this.addChoosableFileFilter(huginFileFilter);
            this.addChoosableFileFilter(new HuginFileFilter(4));
            this.addChoosableFileFilter(new HuginFileFilter(5));
            this.addChoosableFileFilter(new HuginFileFilter(12));
            this.setFileFilter(huginFileFilter);
            this.setFileView(new HuginFileView());
        } else if (n == 3) {
            HuginFileFilter huginFileFilter = new HuginFileFilter(3);
            this.addChoosableFileFilter(huginFileFilter);
            this.addChoosableFileFilter(new HuginFileFilter(4));
            this.addChoosableFileFilter(new HuginFileFilter(5));
            if (n2 == 2) {
                this.addChoosableFileFilter(new HuginFileFilter(12));
            }
            this.setFileFilter(huginFileFilter);
            this.setFileView(new HuginFileView());
        } else if (n != 11) {
            this.addChoosableFileFilter(new HuginFileFilter(n));
            this.setFileView(new HuginFileView());
        }
        this.fileType = n;
        this.oldSecurityManager = System.getSecurityManager();
        System.setSecurityManager(this.oldSecurityManager);
        this.addPropertyChangeListener(this);
    }

    public HuginFileLoader(int n, int n2, HuginGUIFrame huginGUIFrame) {
        this.setDialogTitle(this.setTitle(n2));
        if (n == 100) {
            HuginFileFilter huginFileFilter = new HuginFileFilter(3);
            this.addChoosableFileFilter(huginFileFilter);
            this.setFileView(new HuginFileView());
            this.setCurrentDirectory(huginGUIFrame.getMostRecentFile());
        } else if (n != 11) {
            this.addChoosableFileFilter(new HuginFileFilter(n));
            this.setFileView(new HuginFileView());
        }
        this.fileType = n;
        this.oldSecurityManager = System.getSecurityManager();
        System.setSecurityManager(this.oldSecurityManager);
        this.addPropertyChangeListener(this);
    }

    public HuginFileLoader(int n, File file, int n2) {
        super(file);
        this.setDialogTitle(this.setTitle(n2));
        if (n == 6) {
            HuginFileFilter huginFileFilter = new HuginFileFilter(3);
            this.addChoosableFileFilter(huginFileFilter);
            this.addChoosableFileFilter(new HuginFileFilter(4));
            this.addChoosableFileFilter(new HuginFileFilter(5));
            this.addChoosableFileFilter(new HuginFileFilter(12));
            this.setFileFilter(huginFileFilter);
            this.setFileView(new HuginFileView());
        } else if (n == 3) {
            HuginFileFilter huginFileFilter = new HuginFileFilter(3);
            this.addChoosableFileFilter(huginFileFilter);
            this.addChoosableFileFilter(new HuginFileFilter(4));
            this.addChoosableFileFilter(new HuginFileFilter(5));
            if (n2 == 2) {
                this.addChoosableFileFilter(new HuginFileFilter(12));
            }
            this.setFileFilter(huginFileFilter);
            this.setFileView(new HuginFileView());
        } else if (n == 101) {
            this.setFileSelectionMode(1);
        } else if (n != 11) {
            this.addChoosableFileFilter(new HuginFileFilter(n));
            this.setFileView(new HuginFileView());
        }
        this.fileType = n;
        this.oldSecurityManager = System.getSecurityManager();
        System.setSecurityManager(this.oldSecurityManager);
        this.addPropertyChangeListener(this);
    }

    public HuginFileLoader(int n, HuginProjectFrame huginProjectFrame, int n2) {
        Object object;
        this.setDialogTitle(this.setTitle(n2));
        if (n == 6) {
            object = new HuginFileFilter(3);
            this.addChoosableFileFilter((FileFilter)object);
            this.addChoosableFileFilter(new HuginFileFilter(4));
            this.addChoosableFileFilter(new HuginFileFilter(5));
            this.addChoosableFileFilter(new HuginFileFilter(12));
            this.setFileFilter((FileFilter)object);
            this.setFileView(new HuginFileView());
        } else if (n == 3) {
            object = new HuginFileFilter(3);
            this.addChoosableFileFilter((FileFilter)object);
            this.addChoosableFileFilter(new HuginFileFilter(4));
            this.addChoosableFileFilter(new HuginFileFilter(5));
            if (n2 == 2) {
                this.addChoosableFileFilter(new HuginFileFilter(12));
            }
            this.setFileFilter((FileFilter)object);
            this.setFileView(new HuginFileView());
        } else if (n != 11) {
            this.addChoosableFileFilter(new HuginFileFilter(n));
            this.setFileView(new HuginFileView());
        }
        this.setDefaultName(huginProjectFrame.getShortFileName());
        this.fileType = n;
        this.project = huginProjectFrame;
        object = huginProjectFrame.getFileName();
        int n3 = ((String)object).lastIndexOf(System.getProperty("file.separator"));
        if (n3 > 0) {
            object = ((String)object).substring(0, n3);
        }
        if (object == null || ((String)object).trim().length() == 0) {
            this.setCurrentDirectory(huginProjectFrame.guiFrame.getMostRecentFile());
        } else {
            this.setCurrentDirectory(new File((String)object));
        }
        this.oldSecurityManager = System.getSecurityManager();
        System.setSecurityManager(this.oldSecurityManager);
        this.addPropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("fileFilterChanged")) {
            try {
                final BasicFileChooserUI basicFileChooserUI = (BasicFileChooserUI)this.getUI();
                final String string = basicFileChooserUI.getFileName();
                Runnable runnable = new Runnable(){

                    public void run() {
                        basicFileChooserUI.setFileName(string);
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    private String setTitle(int n) {
        if (n == 0) {
            this.title = HuginGUIConstants.get("MISCELLANEOUS_select_file_title");
            this.approveButtonText = HuginGUIConstants.get("MISCELLANEOUS_select_file_approve_button_text");
        } else if (n == 1) {
            this.title = HuginGUIConstants.get("MISCELLANEOUS_open_net_title");
            this.approveButtonText = HuginGUIConstants.get("MISCELLANEOUS_open_file_approve_button_text");
        } else if (n == 2) {
            this.title = HuginGUIConstants.get("MISCELLANEOUS_save_net_title");
            this.approveButtonText = HuginGUIConstants.get("MISCELLANEOUS_save_file_approve_button_text");
        } else if (n == 3) {
            this.title = HuginGUIConstants.get("MISCELLANEOUS_save_cases_title");
            this.approveButtonText = HuginGUIConstants.get("MISCELLANEOUS_save_file_approve_button_text");
        } else if (n == 4) {
            this.title = HuginGUIConstants.get("MISCELLANEOUS_save_data_title");
            this.approveButtonText = HuginGUIConstants.get("MISCELLANEOUS_save_file_approve_button_text");
        } else if (n == 5) {
            this.title = HuginGUIConstants.get("MISCELLANEOUS_save_file_approve_button_text");
            this.approveButtonText = HuginGUIConstants.get("MISCELLANEOUS_save_file_approve_button_text");
        } else {
            this.title = "";
            this.approveButtonText = HuginGUIConstants.get("MISCELLANEOUS_select_file_approve_button_text");
        }
        return this.title;
    }

    public void setSelectedFile(File file) {
        if (file == null) {
            return;
        }
        if (this.fileType == 101 && file.isDirectory()) {
            super.setSelectedFile(file);
        }
        if (!file.isDirectory()) {
            super.setSelectedFile(file);
        }
    }

    public int getSelectedFileType() {
        if (this.fileType == 11 || !(this.getFileFilter() instanceof HuginFileFilter)) {
            return 11;
        }
        return ((HuginFileFilter)this.getFileFilter()).type;
    }

    private void setDefaultName(String string) {
        this.setSelectedFile(new File(this.getCurrentDirectory(), string));
    }

    public int showDialog(Component component) {
        return super.showDialog(component, this.approveButtonText);
    }

    public int showSaveDialog(Component component) {
        this.extensions[9][1] = "";
        this.saveMode = true;
        int n = super.showSaveDialog(Hugin.mainFrame);
        this.saveMode = false;
        return n;
    }

    public int showOpenDialog(Component component) {
        return super.showOpenDialog(Hugin.mainFrame);
    }

    public void approveSelection() {
        int n;
        File file = this.getSelectedFile();
        if (file == null) {
            return;
        }
        this.fileType = this.getSelectedFileType();
        if (this.saveMode) {
            int n2;
            String string = this.extensions[this.fileType][0];
            if (file.getName().indexOf(".") < 0) {
                file = new File(file.getAbsolutePath() + string);
            }
            if (file.exists() && (n2 = JOptionPane.showConfirmDialog(Hugin.mainFrame, HuginGUIConstants.get("MISCELLANEOUS_overwrite_file"), this.title, 0, 3, null)) == 1) {
                return;
            }
            this.setSelectedFile(file);
        }
        if ((n = NetworkNamingPane.nameStatus(file.getName(), this.fileType, this.project)) == 0) {
            super.approveSelection();
        } else {
            NetworkNamingPane.illegalName(this, n);
        }
    }

    public String getExtension(File file) {
        String string = "";
        String string2 = file.getName();
        int n = string2.lastIndexOf(46);
        if (n > 0 && n < string2.length() - 1) {
            string = string2.substring(n).toLowerCase();
        }
        return string;
    }

    private class HuginFileView
    extends FileView {
        ImageIcon huginIcon = new ImageIcon(ClassLoader.getSystemResource("icons/fileIcon.gif"));
        ImageIcon hkbIcon = new ImageIcon(ClassLoader.getSystemResource("icons/fileIconHkb.gif"));
        ImageIcon datIcon = new ImageIcon(ClassLoader.getSystemResource("icons/datIcon.gif"));
        ImageIcon caseIcon = new ImageIcon(ClassLoader.getSystemResource("icons/caseIcon.gif"));

        private HuginFileView() {
        }

        public String getName(File file) {
            return null;
        }

        public String getDescription(File file) {
            return null;
        }

        public Boolean isTraversable(File file) {
            return null;
        }

        public String getTypeDescription(File file) {
            if (file.isDirectory()) {
                return null;
            }
            String string = HuginFileLoader.this.getExtension(file);
            if (string.equals(".oobn")) {
                return "A Hugin OOBN";
            }
            if (string.equals(".net")) {
                return "A Hugin network";
            }
            if (string.equals(".hkb")) {
                return "A compiled Hugin network";
            }
            if (string.equals(".dat")) {
                return "A data file";
            }
            if (string.equals(".hcs")) {
                return "A Hugin case file";
            }
            return null;
        }

        public Icon getIcon(File file) {
            if (file.isDirectory()) {
                return super.getIcon(file);
            }
            String string = HuginFileLoader.this.getExtension(file);
            if (string.equals(".oobn")) {
                return this.huginIcon;
            }
            if (string.equals(".net")) {
                return this.huginIcon;
            }
            if (string.equals(".hkb")) {
                return this.hkbIcon;
            }
            if (string.equals(".dat")) {
                return this.datIcon;
            }
            if (string.equals(".hcs")) {
                return this.caseIcon;
            }
            return super.getIcon(file);
        }
    }

    private class HuginFileFilter
    extends FileFilter {
        int type;

        public HuginFileFilter(int n) {
            this.type = n;
        }

        public boolean accept(File file) {
            if (file.isDirectory() || this.type == 11) {
                return true;
            }
            String string = HuginFileLoader.this.getExtension(file);
            if (string != null) {
                boolean bl = false;
                for (int i = 0; i < HuginFileLoader.this.extensions[this.type].length; ++i) {
                    bl = bl || string.equals(HuginFileLoader.this.extensions[this.type][i]);
                }
                return bl;
            }
            return false;
        }

        public String getDescription() {
            switch (this.type) {
                case 0: {
                    return "*.oobn, *.net, *.hkb";
                }
                case 1: {
                    return "*.dat";
                }
                case 2: {
                    return "*.hkb";
                }
                case 3: {
                    return "*.oobn (OOBN format)";
                }
                case 4: {
                    return "*.net (net format)";
                }
                case 5: {
                    return "*.hkb (net format)";
                }
                case 7: {
                    return "*.gif";
                }
                case 8: {
                    return "*.bmp";
                }
                case 16: {
                    return "*.pdf";
                }
                case 9: {
                    return HuginFileLoader.this.saveMode ? "*.hcs" : "*.hcs, *.dat";
                }
                case 10: {
                    return "*.html";
                }
                case 12: {
                    return "Password protected hkb";
                }
                case 13: {
                    return "*.num";
                }
                case 14: {
                    return "*.gif, *.jpg, *.png";
                }
                case 15: {
                    return "*.jar, *.zip";
                }
            }
            return "Unknown";
        }
    }
}

