/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginProjectFrame;
import COM.hugin.HGUI.TitledPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class HuginGUIErrorList
extends JDialog {
    private LinkedList<HuginGUIError> errors = new LinkedList();
    private ListIterator<HuginGUIError> current;
    private int iteratorIndex = -1;
    private int size = 0;
    private HuginProjectFrame project;
    JButton next;
    JButton previous;
    JButton close;
    int index;
    Container cont;
    TitledPanel currentError;
    HuginGUIError showing;

    public HuginGUIErrorList(HuginProjectFrame huginProjectFrame) {
        super(Hugin.mainFrame, HuginGUIConstants.get("MISCELLANEOUS_Error_list"), true);
        this.project = huginProjectFrame;
    }

    private void setLength(int n) {
        if (n < this.size) {
            this.reduceSize(n);
        }
        if (n > this.size) {
            this.enlargeSize(n);
        }
    }

    private void reduceSize(int n) {
        if (n < this.errors.size()) {
            LinkedList<HuginGUIError> linkedList = new LinkedList<HuginGUIError>();
            while (linkedList.size() < n) {
                linkedList.addFirst(this.errors.get(this.iteratorIndex--));
                if (this.iteratorIndex >= 0) continue;
                this.iteratorIndex = this.errors.size() - 1;
            }
            this.errors = linkedList;
            this.iteratorIndex = this.errors.size() - 1;
            this.current = this.errors.listIterator(this.iteratorIndex + 1);
        }
        this.size = n;
    }

    private void enlargeSize(int n) {
        if (this.iteratorIndex < this.errors.size() - 1) {
            LinkedList<HuginGUIError> linkedList = new LinkedList<HuginGUIError>();
            while (linkedList.size() < this.errors.size()) {
                linkedList.addFirst(this.errors.get(this.iteratorIndex--));
                if (this.iteratorIndex >= 0) continue;
                this.iteratorIndex = this.errors.size() - 1;
            }
            this.errors = linkedList;
            this.iteratorIndex = this.errors.size() - 1;
            this.current = this.errors.listIterator(this.iteratorIndex + 1);
        }
        this.size = n;
    }

    public int getLength() {
        return this.size;
    }

    public void add(HuginGUIError huginGUIError) {
        if (this.project.guiFrame.preferences.error_list_size != this.size) {
            this.setLength(this.project.guiFrame.preferences.error_list_size);
        }
        if (this.project.guiFrame.preferences.error_list_size == 0) {
            return;
        }
        if (this.errors.size() == 0) {
            this.errors.add(huginGUIError);
            this.current = this.errors.listIterator();
            this.current.next();
            this.iteratorIndex = 0;
        } else if (this.errors.size() < this.size) {
            this.current.add(huginGUIError);
            ++this.iteratorIndex;
        } else {
            if (!this.current.hasNext()) {
                this.current = this.errors.listIterator();
                this.iteratorIndex = -1;
            }
            ++this.iteratorIndex;
            this.current.next();
            this.current.set(huginGUIError);
        }
    }

    public void showList() {
        if (this.project.guiFrame.preferences.error_list_size != this.size) {
            this.setLength(this.project.guiFrame.preferences.error_list_size);
        }
        this.index = this.iteratorIndex;
        this.cont = this.getContentPane();
        this.cont.removeAll();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.next = new JButton(HuginGUIConstants.get("MISCELLANEOUS_Next"));
        this.next.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = true;
                ++HuginGUIErrorList.this.index;
                if (HuginGUIErrorList.this.index == HuginGUIErrorList.this.iteratorIndex || HuginGUIErrorList.this.index == HuginGUIErrorList.this.errors.size() - 1 && HuginGUIErrorList.this.iteratorIndex == 0) {
                    bl = false;
                }
                if (HuginGUIErrorList.this.index >= HuginGUIErrorList.this.errors.size()) {
                    HuginGUIErrorList.this.index = 0;
                }
                HuginGUIErrorList.this.showing = (HuginGUIError)HuginGUIErrorList.this.errors.get(HuginGUIErrorList.this.index);
                HuginGUIErrorList.this.cont.remove(HuginGUIErrorList.this.currentError);
                HuginGUIErrorList.this.currentError = HuginGUIErrorList.this.showing.getDisplayPanel();
                HuginGUIErrorList.this.cont.add(HuginGUIErrorList.this.currentError);
                HuginGUIErrorList.this.next.setEnabled(bl);
                HuginGUIErrorList.this.previous.setEnabled(true);
                HuginGUIErrorList.this.pack();
            }
        });
        this.previous = new JButton(HuginGUIConstants.get("MISCELLANEOUS_Previous"));
        this.previous.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = true;
                --HuginGUIErrorList.this.index;
                if (HuginGUIErrorList.this.index == HuginGUIErrorList.this.iteratorIndex + 1 || HuginGUIErrorList.this.index == 0 && HuginGUIErrorList.this.iteratorIndex == HuginGUIErrorList.this.errors.size() - 1) {
                    bl = false;
                }
                if (HuginGUIErrorList.this.index < 0) {
                    HuginGUIErrorList.this.index = HuginGUIErrorList.this.errors.size() - 1;
                }
                HuginGUIErrorList.this.showing = (HuginGUIError)HuginGUIErrorList.this.errors.get(HuginGUIErrorList.this.index);
                HuginGUIErrorList.this.cont.remove(HuginGUIErrorList.this.currentError);
                HuginGUIErrorList.this.currentError = HuginGUIErrorList.this.showing.getDisplayPanel();
                HuginGUIErrorList.this.cont.add(HuginGUIErrorList.this.currentError);
                HuginGUIErrorList.this.next.setEnabled(true);
                HuginGUIErrorList.this.previous.setEnabled(bl);
                HuginGUIErrorList.this.pack();
            }
        });
        this.close = new JButton(HuginGUIConstants.get("MISCELLANEOUS_Close"));
        this.close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HuginGUIErrorList.this.dispose();
            }
        });
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.previous);
        jPanel.add(this.next);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.close);
        this.cont.setLayout(new BorderLayout());
        this.cont.add((Component)jPanel, "South");
        this.next.setEnabled(false);
        if (this.index == -1) {
            this.cont.add(new JLabel(HuginGUIConstants.get("MISCELLANEOUS_No_Errors")));
            this.previous.setEnabled(false);
        } else {
            this.currentError = this.errors.get(this.index).getDisplayPanel();
            this.cont.add(this.currentError);
            this.previous.setEnabled(this.index != this.iteratorIndex + 1 && (this.index != 0 || this.iteratorIndex != this.errors.size() - 1));
        }
        this.pack();
        if (this.project.getWidth() > 0) {
            this.setLocation(this.project.guiFrame.getX() + this.project.getX() + (this.project.getWidth() / 2 - 125), this.project.guiFrame.getY() + this.project.getY() + (this.project.getHeight() / 2 - 100));
        } else {
            this.setLocation(this.project.guiFrame.getX() + (this.project.guiFrame.getWidth() / 2 - 125), this.project.guiFrame.getY() + (this.project.guiFrame.getHeight() / 2 - 100));
        }
        this.setVisible(true);
    }
}

