/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.Attribute;
import COM.hugin.HAPI.BooleanDCNode;
import COM.hugin.HAPI.BooleanDDNode;
import COM.hugin.HAPI.Class;
import COM.hugin.HAPI.Clique;
import COM.hugin.HAPI.ContinuousChanceNode;
import COM.hugin.HAPI.DiscreteChanceNode;
import COM.hugin.HAPI.DiscreteDecisionNode;
import COM.hugin.HAPI.DiscreteNode;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.Expression;
import COM.hugin.HAPI.IntervalDCNode;
import COM.hugin.HAPI.IntervalDDNode;
import COM.hugin.HAPI.JunctionTree;
import COM.hugin.HAPI.LabelledDCNode;
import COM.hugin.HAPI.LabelledDDNode;
import COM.hugin.HAPI.Model;
import COM.hugin.HAPI.NetworkModel;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HAPI.NormalDistribution;
import COM.hugin.HAPI.NumberExpression;
import COM.hugin.HAPI.NumberedDCNode;
import COM.hugin.HAPI.NumberedDDNode;
import COM.hugin.HAPI.Table;
import COM.hugin.HAPI.UtilityNode;
import COM.hugin.HGUI.BeliefBarPanel;
import COM.hugin.HGUI.CDVTLink;
import COM.hugin.HGUI.Case;
import COM.hugin.HGUI.DataSourceException;
import COM.hugin.HGUI.DataStream;
import COM.hugin.HGUI.HelpPanel;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIFrame;
import COM.hugin.HGUI.HuginProjectFrame;
import COM.hugin.HGUI.HuginTipWindow;
import COM.hugin.HGUI.InstanceNode;
import COM.hugin.HGUI.Link;
import COM.hugin.HGUI.NetworkPanel;
import COM.hugin.HGUI.Node;
import COM.hugin.HGUI.PasswordDialog;
import COM.hugin.HGUI.PreProcessingException;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HuginGUIUtils {
    private static Pattern octPattern = Pattern.compile("(\\\\[0-7]{1,3}+)+");
    public static int convertThreshold = 6;
    public static int maxNegConvertThreshold = 4;
    private static NumberFormat formatter = NumberFormat.getNumberInstance();
    public static final int TITLE_TYPE_LABEL = 0;
    public static final int TITLE_TYPE_NAME = 1;
    public static final int TITLE_TYPE_LABEL_NAME = 2;
    public static final int TITLE_TYPE_NAME_LABEL = 3;
    public static final short TITLE_MODE_SIMPLE = 0;
    public static final short TITLE_MODE_MULTI_LINE = 1;
    public static int INTERVAL_TYPE_NOT;
    public static int INTERVAL_TYPE_VALID;
    public static int INTERVAL_TYPE_INVALID;
    public static final int COMPARE_MODE_TITLE = 0;
    public static final int COMPARE_MODE_ALL = 1;
    private static boolean threadResume;
    private static String tbMutexObj;
    private static ThreadBreaker tb;

    public static void setRunningAndValidateAPIVersion() {
        boolean bl = false;
        boolean bl2 = bl = System.getProperty("os.name").trim().toLowerCase().indexOf("win") >= 0;
        if (bl) {
            NetworkModel.setRunning();
        }
        String string = NetworkModel.getNativeID();
        String string2 = NetworkModel.getJavaID();
        if (string == null || string2 == null || !string.equals(string2)) {
            JOptionPane.showMessageDialog(Hugin.mainFrame, HuginGUIConstants.get("lib_mismatch_descr", new String[]{string, string2}), HuginGUIConstants.get("lib_mismatch_title"), 0);
            System.exit(0);
        }
    }

    public static void convertLegacyLinkConfigurationAttributes(NetworkModel networkModel) throws ExceptionHugin {
        for (COM.hugin.HAPI.Node node : networkModel.getNodes()) {
            LinkedList<Attribute> linkedList = node.getAttributes();
            for (Attribute attribute : linkedList) {
                String string;
                String string2;
                String string3;
                String string4 = attribute.getKey();
                String string5 = attribute.getValue();
                if (string4.indexOf("HR_LinkMode_from_") == 0) {
                    string3 = string4.substring(17, string4.indexOf("_to_"));
                    string2 = string4.substring(string4.indexOf("_to_")).trim();
                    string = string5.trim();
                    if (string == "") {
                        string = "0";
                    }
                    HuginGUIUtils.setLinkModeInstance(node, string3, string2, string);
                    node.setAttribute(string4, null);
                    continue;
                }
                if (string4.indexOf("HR_LinkMode_") == 0) {
                    string3 = string4.substring(12).trim();
                    string2 = string5.trim();
                    if (string2 == "") {
                        string2 = "0";
                    }
                    HuginGUIUtils.setLinkMode(node, string3, string2);
                    node.setAttribute(string4, null);
                    continue;
                }
                if (string4.indexOf("HR_LinkControlPoints_from_") == 0) {
                    string3 = string4.substring(26, string4.indexOf("_to_"));
                    string2 = string4.substring(string4.indexOf("_to_")).trim();
                    string = string5.trim();
                    if (string != "") {
                        HuginGUIUtils.setLinkControlPointsInstance(node, string3, string2, string);
                    }
                    node.setAttribute(string4, null);
                    continue;
                }
                if (string4.indexOf("HR_LinkControlPoints_") != 0) continue;
                string3 = string4.substring(21).trim();
                string2 = string5.trim();
                if (string2 != "") {
                    HuginGUIUtils.setLinkControlPoints(node, string3, string2);
                }
                node.setAttribute(string4, null);
            }
        }
    }

    public static String convertOctals(String string) {
        Matcher matcher = octPattern.matcher(string);
        String string2 = "";
        int n = 0;
        while (matcher.find()) {
            string2 = string2 + string.substring(n, matcher.start());
            try {
                string2 = string2 + NetworkModel.removeEscapeSequences(matcher.group());
            }
            catch (Exception exception) {
                string2 = string2 + matcher.group();
            }
            n = matcher.end();
        }
        string2 = string2 + string.substring(n);
        return string2;
    }

    public static String getLinkMode(COM.hugin.HAPI.Node node, String string) throws ExceptionHugin {
        String string2 = node.getAttribute("HR_LinkMode");
        if (string2 == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "[]");
        while (stringTokenizer.hasMoreTokens()) {
            String string3;
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), ":");
            if (!stringTokenizer2.hasMoreTokens()) continue;
            String string4 = stringTokenizer2.nextToken();
            String string5 = string3 = stringTokenizer2.hasMoreTokens() ? stringTokenizer2.nextToken() : "0";
            if (!string4.equals(string)) continue;
            return string3;
        }
        return null;
    }

    public static void setLinkMode(COM.hugin.HAPI.Node node, String string, String string2) throws ExceptionHugin {
        String string3 = node.getAttribute("HR_LinkMode");
        String string4 = "";
        boolean bl = false;
        if (string3 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "[]");
            while (stringTokenizer.hasMoreTokens()) {
                String string5;
                StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), ":");
                if (!stringTokenizer2.hasMoreTokens()) continue;
                String string6 = stringTokenizer2.nextToken();
                String string7 = string5 = stringTokenizer2.hasMoreTokens() ? stringTokenizer2.nextToken() : "0";
                if (string6.equals(string)) {
                    if (string2 != null) {
                        string4 = string4 + "[" + string6 + ":" + string2 + "]";
                    }
                    bl = true;
                    continue;
                }
                string4 = string4 + "[" + string6 + ":" + string5 + "]";
            }
        }
        if (!bl && string2 != null) {
            string4 = string4 + "[" + string + ":" + string2 + "]";
        }
        if (string4.length() >= 0) {
            node.setAttribute("HR_LinkMode", string4);
        } else {
            node.setAttribute("HR_LinkMode", null);
        }
    }

    public static String getLinkControlPoints(COM.hugin.HAPI.Node node, String string) throws ExceptionHugin {
        String string2 = node.getAttribute("HR_LinkControlPoints");
        if (string2 == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "[]");
        while (stringTokenizer.hasMoreTokens()) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), ":");
            if (!stringTokenizer2.hasMoreTokens()) continue;
            String string3 = stringTokenizer2.nextToken();
            String string4 = "";
            if (stringTokenizer2.hasMoreTokens()) {
                string4 = stringTokenizer2.nextToken();
            }
            if (!string3.equals(string)) continue;
            return string4;
        }
        return null;
    }

    public static void setLinkControlPoints(COM.hugin.HAPI.Node node, String string, String string2) throws ExceptionHugin {
        String string3 = node.getAttribute("HR_LinkControlPoints");
        String string4 = "";
        boolean bl = false;
        if (string3 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "[]");
            while (stringTokenizer.hasMoreTokens()) {
                StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), ":");
                if (!stringTokenizer2.hasMoreTokens()) continue;
                String string5 = stringTokenizer2.nextToken();
                String string6 = "";
                if (stringTokenizer2.hasMoreTokens()) {
                    string6 = stringTokenizer2.nextToken();
                }
                if (string5.equals(string)) {
                    if (string2 != null) {
                        string4 = string4 + "[" + string5 + ":" + string2 + "]";
                    }
                    bl = true;
                    continue;
                }
                string4 = string4 + "[" + string5 + ":" + string6 + "]";
            }
        }
        if (!bl && string2 != null) {
            string4 = string4 + "[" + string + ":" + string2 + "]";
        }
        if (string4.length() >= 0) {
            node.setAttribute("HR_LinkControlPoints", string4);
        } else {
            node.setAttribute("HR_LinkControlPoints", null);
        }
    }

    public static String getLinkModeInstance(COM.hugin.HAPI.Node node, String string, String string2) throws ExceptionHugin {
        String string3 = node.getAttribute("HR_LinkModeInstance");
        if (string3 == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, "[]");
        while (stringTokenizer.hasMoreTokens()) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), ";:");
            if (!stringTokenizer2.hasMoreTokens()) continue;
            String string4 = stringTokenizer2.nextToken();
            String string5 = "";
            String string6 = "";
            if (stringTokenizer2.hasMoreTokens()) {
                string5 = stringTokenizer2.nextToken();
                if (stringTokenizer2.hasMoreTokens()) {
                    string6 = stringTokenizer2.nextToken();
                }
            }
            if (!string5.equals(string2) || !string4.equals(string)) continue;
            return string6;
        }
        return null;
    }

    public static void setLinkModeInstance(COM.hugin.HAPI.Node node, String string, String string2, String string3) throws ExceptionHugin {
        String string4 = node.getAttribute("HR_LinkModeInstance");
        String string5 = "";
        boolean bl = false;
        if (string4 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string4, "[]");
            while (stringTokenizer.hasMoreTokens()) {
                StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), ";:");
                if (!stringTokenizer2.hasMoreTokens()) continue;
                String string6 = stringTokenizer2.nextToken();
                String string7 = stringTokenizer2.nextToken();
                String string8 = stringTokenizer2.nextToken();
                if (string7.equals(string2) && string6.equals(string)) {
                    if (string3 != null) {
                        string5 = string5 + "[" + string6 + ";" + string7 + ":" + string3 + "]";
                    }
                    bl = true;
                    continue;
                }
                string5 = string5 + "[" + string6 + ";" + string7 + ":" + string8 + "]";
            }
        }
        if (!bl && string3 != null) {
            string5 = string5 + "[" + string + ";" + string2 + ":" + string3 + "]";
        }
        if (string5.length() >= 0) {
            node.setAttribute("HR_LinkModeInstance", string5);
        } else {
            node.setAttribute("HR_LinkModeInstance", null);
        }
    }

    public static String getLinkControlPointsInstance(COM.hugin.HAPI.Node node, String string, String string2) throws ExceptionHugin {
        String string3 = node.getAttribute("HR_LinkControlPointsInstance");
        if (string3 == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, "[]");
        while (stringTokenizer.hasMoreTokens()) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), ";:");
            if (!stringTokenizer2.hasMoreTokens()) continue;
            String string4 = stringTokenizer2.nextToken();
            String string5 = stringTokenizer2.nextToken();
            String string6 = stringTokenizer2.nextToken();
            if (!string5.equals(string2) || !string4.equals(string)) continue;
            return string6;
        }
        return null;
    }

    public static void setLinkControlPointsInstance(COM.hugin.HAPI.Node node, String string, String string2, String string3) throws ExceptionHugin {
        String string4 = node.getAttribute("HR_LinkControlPointsInstance");
        String string5 = "";
        boolean bl = false;
        if (string4 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string4, "[]");
            while (stringTokenizer.hasMoreTokens()) {
                StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), ";:");
                if (!stringTokenizer2.hasMoreTokens()) continue;
                String string6 = stringTokenizer2.nextToken();
                String string7 = stringTokenizer2.nextToken();
                String string8 = stringTokenizer2.nextToken();
                if (string7.equals(string2) && string6.equals(string)) {
                    if (string3 != null) {
                        string5 = string5 + "[" + string6 + ";" + string7 + ":" + string3 + "]";
                    }
                    bl = true;
                    continue;
                }
                string5 = string5 + "[" + string6 + ";" + string7 + ":" + string8 + "]";
            }
        }
        if (!bl && string3 != null) {
            string5 = string5 + "[" + string + ";" + string2 + ":" + string3 + "]";
        }
        if (string5.length() >= 0) {
            node.setAttribute("HR_LinkControlPointsInstance", string5);
        } else {
            node.setAttribute("HR_LinkControlPointsInstance", null);
        }
    }

    public static String formatDouble(double d) {
        try {
            DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance();
            DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
            decimalFormatSymbols.setDecimalSeparator('.');
            decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
            decimalFormat.setGroupingUsed(false);
            if (Math.abs(d) >= 1.0E-4) {
                decimalFormat.setMaximumFractionDigits(4);
            } else {
                decimalFormat.applyPattern("0E0");
            }
            return decimalFormat.format(d);
        }
        catch (NumberFormatException numberFormatException) {
            return "0.0";
        }
    }

    public static String printDouble(double d) {
        return HuginGUIUtils.printDouble(d, 140, true, false);
    }

    public static String printDouble(double d, int n) {
        return HuginGUIUtils.printDouble(d, n, true, false);
    }

    public static String printDouble(double d, int n, boolean bl) {
        return HuginGUIUtils.printDouble(d, n, bl, false);
    }

    public static String printDouble(double d, int n, boolean bl, boolean bl2) {
        return HuginGUIUtils.printDouble(d, n, bl, bl2, false);
    }

    public static String printDouble(double d, int n, boolean bl, boolean bl2, boolean bl3) {
        int n2;
        if (n < 0) {
            bl3 = false;
        }
        if (d == -Domain.INFINITY()) {
            return "-inf";
        }
        if (d == Domain.INFINITY()) {
            return "inf";
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "-inf";
        }
        if (d == Double.POSITIVE_INFINITY) {
            return "inf";
        }
        int n3 = Math.min(n, maxNegConvertThreshold);
        if (bl && (Math.abs(d) > Math.pow(10.0, convertThreshold) || Math.abs(d) < Math.pow(10.0, -n3) && d != 0.0)) {
            if (formatter instanceof DecimalFormat) {
                ((DecimalFormat)formatter).applyPattern("0.0#E0###");
                if (d < 1.0E-99 && Hugin.mainFrame.preferences.precision > 4) {
                    n -= Hugin.mainFrame.preferences.precision - 4;
                }
                if (d < 1.0E-9 && Hugin.mainFrame.preferences.precision > 5) {
                    n -= Hugin.mainFrame.preferences.precision - 5;
                }
            }
            formatter.setMaximumFractionDigits(n);
            return formatter.format(d);
        }
        if (!bl2 && d == (double)((int)d)) {
            return "" + (int)d;
        }
        String string = "#0.#";
        if (n < 0) {
            n = 200;
        }
        if (bl2) {
            if (n == 0) {
                string = "#0";
            } else {
                string = "#0.";
                for (int i = 0; i < n; ++i) {
                    string = string + "0";
                }
            }
        }
        if (formatter instanceof DecimalFormat) {
            ((DecimalFormat)formatter).applyPattern(string);
        }
        formatter.setMaximumFractionDigits(n);
        String string2 = formatter.format(d);
        if (!bl3 && string2.matches(".*\\W.*00000.*") && (n2 = string2.lastIndexOf(".")) != -1 && (n2 = string2.indexOf("00000", n2)) != -1 && (string2 = string2.substring(0, n2)).charAt(string2.length() - 1) == HuginGUIConstants.DECIMAL_SEPARATOR) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    public static String printDoubleScientific(double d) {
        if (d == Double.NEGATIVE_INFINITY) {
            return "-inf";
        }
        if (d == Double.POSITIVE_INFINITY) {
            return "inf";
        }
        if (d == -Domain.INFINITY()) {
            return "-inf";
        }
        if (d == Domain.INFINITY()) {
            return "inf";
        }
        if (formatter instanceof DecimalFormat) {
            ((DecimalFormat)formatter).applyPattern("0.000000E0#");
        }
        formatter.setMaximumIntegerDigits(1);
        formatter.setMaximumFractionDigits(Hugin.mainFrame.preferences.precision);
        return formatter.format(d);
    }

    public static String printInterval(double d, double d2) {
        return HuginGUIUtils.printDouble(d, 6, true) + " - " + HuginGUIUtils.printDouble(d2, 6, true);
    }

    public static String printInterval(double d, double d2, int n) {
        return HuginGUIUtils.printDouble(d, n, true) + " - " + HuginGUIUtils.printDouble(d2, n, true);
    }

    public static String printInterval(Interval interval) {
        return HuginGUIUtils.printDouble(interval.lower, 6, true) + " - " + HuginGUIUtils.printDouble(interval.upper, 6, true);
    }

    protected static boolean getInterval(String string, Interval interval) {
        int n = (string = string.toLowerCase().trim()).indexOf("-", 1);
        if (n > 10000 || n < 1) {
            return false;
        }
        if (string.charAt(n - 1) == 'e') {
            n = string.indexOf("-", n + 1);
        }
        try {
            if (n < 0) {
                interval.lower = Double.parseDouble(string);
                interval.upper = interval.lower + 1.0;
            } else {
                interval.lower = string.substring(0, n).trim().equals("-inf") || string.substring(0, n).trim().equals("-inf") || string.substring(0, n).trim().equals("-Infinity".toLowerCase()) ? -Domain.INFINITY() : Double.parseDouble(string.substring(0, n));
                interval.upper = string.substring(n + 1).trim().equals("inf") || string.substring(n + 1).trim().equals("inf") || string.substring(n + 1).trim().equals("Infinity".toLowerCase()) ? Domain.INFINITY() : Double.parseDouble(string.substring(n + 1));
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    protected static Interval getInterval(String string) {
        Interval interval = new Interval();
        if (HuginGUIUtils.getInterval(string, interval)) {
            return interval;
        }
        return null;
    }

    protected static boolean checkInterval(String string) {
        int n = (string = string.toLowerCase().trim()).indexOf("-", 1);
        if (n > 10000) {
            return false;
        }
        if (string.charAt(n - 1) == 'e') {
            n = string.indexOf("-", n + 1);
        }
        try {
            if (n < 0) {
                Double.parseDouble(string);
            } else {
                if (!(string.substring(0, n).trim().equals("-inf") || string.substring(0, n).trim().equals("-inf") || string.substring(0, n).trim().equals("-Infinity".toLowerCase()))) {
                    Double.parseDouble(string.substring(0, n));
                }
                if (!(string.substring(n + 1).trim().equals("inf") || string.substring(n + 1).trim().equals("inf") || string.substring(n + 1).trim().equals("Infinity".toLowerCase()))) {
                    Double.parseDouble(string.substring(n + 1));
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static String getNodeTitle(COM.hugin.HAPI.Node node, int n, short s) throws ExceptionHugin {
        String string = "";
        switch (n) {
            case 0: {
                string = node.getLabel();
                if (string != null && string.length() != 0) break;
                string = node.getName();
                break;
            }
            case 1: {
                string = node.getName();
                break;
            }
            case 2: {
                string = node.getLabel();
                if (string == null || string.length() == 0) {
                    string = node.getName();
                    break;
                }
                string = string + " (" + node.getName() + ")";
                break;
            }
            case 3: {
                string = node.getLabel();
                string = string == null || string.length() == 0 ? node.getName() : node.getName() + " (" + string + ")";
            }
        }
        if (s == 0) {
            string = string.replace('\n', ' ');
        }
        return string;
    }

    public static String getNodeTitle(COM.hugin.HAPI.Node node, int n) throws ExceptionHugin {
        return HuginGUIUtils.getNodeTitle(node, n, (short)0);
    }

    public static String getNodeTitle(COM.hugin.HAPI.Node node) throws ExceptionHugin {
        return HuginGUIUtils.getNodeTitle(node, (short)0);
    }

    public static String getNodeTitle(COM.hugin.HAPI.Node node, short s) throws ExceptionHugin {
        int n = 0;
        String string = node.getHome().getAttribute("HR_Node_Label_Style");
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return HuginGUIUtils.getNodeTitle(node, n, s);
    }

    public static Domain createDomain(Class clazz) throws ExceptionHugin {
        return clazz.createDomain();
    }

    public static boolean classIsInstantiated(Class clazz) {
        if (clazz == null) {
            return false;
        }
        boolean bl = true;
        try {
            bl = clazz.getInstances().size() > 0;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public static boolean allDecisionsInstantiated(Domain domain) {
        if (domain == null) {
            return false;
        }
        try {
            for (COM.hugin.HAPI.Node node : domain.getNodes()) {
                if (!(node instanceof DiscreteDecisionNode) || ((DiscreteDecisionNode)node).getPropagatedState() >= 0) continue;
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static LinkedList<NetworkPanel> getContainers(Class clazz) throws ExceptionHugin {
        JInternalFrame[] jInternalFrameArray = Hugin.mainFrame.desktop.getAllFrames();
        LinkedList<NetworkPanel> linkedList = new LinkedList<NetworkPanel>();
        for (COM.hugin.HAPI.Node node : clazz.getInstances()) {
            COM.hugin.HAPI.InstanceNode instanceNode = (COM.hugin.HAPI.InstanceNode)node;
            for (int i = 0; i < jInternalFrameArray.length; ++i) {
                NetworkPanel networkPanel = ((HuginProjectFrame)jInternalFrameArray[i]).getNetworkPanel();
                if (instanceNode.getHome() != networkPanel.getHome()) continue;
                linkedList.add(networkPanel);
            }
        }
        return linkedList;
    }

    public static boolean reportIllegalBindings(NetworkPanel networkPanel) throws ExceptionHugin {
        if (networkPanel == null) {
            return false;
        }
        Class clazz = networkPanel.getHomeClass();
        for (Node node : networkPanel.nodeList) {
            if (!(node instanceof InstanceNode)) continue;
            for (Node node2 : ((InstanceNode)node).inputs) {
                Node node3;
                if (node2.getParents().size() <= 0 || (node3 = node2.getParents().get(0)).consistentWith(node2)) continue;
                String string = HuginGUIConstants.get("str_actual_input_parent_ARG0_is_incompatible_with_formal_input_ARG1_of_ARG2", new String[]{HuginGUIUtils.getNodeTitle(node3.getAPINode()), HuginGUIUtils.getNodeTitle(node2.getAPINode()), HuginGUIUtils.getNodeTitle(node.getAPINode())});
                Hugin.mainFrame.statusBar.write(string, true);
            }
            Class clazz2 = ((COM.hugin.HAPI.InstanceNode)node.getAPINode()).getInstanceClass();
            HuginGUIUtils.reportIllegalBindings(HuginGUIFrame.getNetworkPanel(clazz2));
        }
        return false;
    }

    public static void performNodeTyping(Domain domain, NetworkPanel networkPanel) throws ExceptionHugin {
        int n = domain.getNumberOfCases();
        for (COM.hugin.HAPI.Node node : domain.getNodes()) {
            int n2;
            Object object;
            String string;
            DiscreteChanceNode discreteChanceNode = (DiscreteChanceNode)node;
            if (HuginGUIUtils.nodeIsBoolean(discreteChanceNode)) {
                BooleanDCNode booleanDCNode = (BooleanDCNode)HuginGUIUtils.setNodeType(domain, discreteChanceNode, 1);
                if (booleanDCNode == discreteChanceNode) break;
                if (networkPanel != null) {
                    networkPanel.getNode(discreteChanceNode).setAPINode(booleanDCNode);
                }
                HuginGUIUtils.transferCases(discreteChanceNode, booleanDCNode, n);
                string = discreteChanceNode.getName();
                discreteChanceNode.delete();
                booleanDCNode.setName(string);
                continue;
            }
            if (HuginGUIUtils.nodeIsNumerical(discreteChanceNode)) {
                int n3;
                object = new double[discreteChanceNode.getNumberOfStates()];
                for (n3 = 0; n3 < ((double[])object).length; ++n3) {
                    try {
                        object[n3] = Double.parseDouble(discreteChanceNode.getStateLabel(n3));
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        object[n3] = -1.0;
                    }
                }
                Arrays.sort((double[])object);
                NumberedDCNode numberedDCNode = (NumberedDCNode)HuginGUIUtils.setNodeType(domain, discreteChanceNode, 2);
                if (numberedDCNode == discreteChanceNode) break;
                if (networkPanel != null) {
                    networkPanel.getNode(discreteChanceNode).setAPINode(numberedDCNode);
                }
                n3 = ((double[])object).length;
                int n4 = 0;
                for (n2 = 0; n2 < ((double[])object).length; ++n2) {
                    if (n2 > 0 && object[n2] == object[n4 - 1]) {
                        --n3;
                        continue;
                    }
                    numberedDCNode.setStateValue(n4, (double)object[n2]);
                    numberedDCNode.setStateLabel(n4, "" + (double)object[n2]);
                    object[n4] = object[n2];
                    ++n4;
                }
                numberedDCNode.setNumberOfStates(n3);
                HuginGUIUtils.transferCases(discreteChanceNode, numberedDCNode, n);
                string = discreteChanceNode.getName();
                discreteChanceNode.delete();
                numberedDCNode.setName(string);
                continue;
            }
            int n5 = HuginGUIUtils.nodeIsInterval(discreteChanceNode);
            if (n5 == INTERVAL_TYPE_VALID) {
                double[] dArray = new double[discreteChanceNode.getNumberOfStates() * 2];
                for (n2 = 0; n2 < dArray.length - 1; n2 += 2) {
                    try {
                        String string2 = discreteChanceNode.getStateLabel(n2 / 2);
                        dArray[n2] = Double.parseDouble(string2.substring(0, string2.trim().indexOf("-", 1)));
                        dArray[n2 + 1] = Double.parseDouble(string2.substring(string2.trim().indexOf("-", 1) + 1));
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        dArray[n2] = -1.0;
                        dArray[n2 + 1] = -1.0;
                    }
                }
                Arrays.sort(dArray);
                object = (IntervalDCNode)HuginGUIUtils.setNodeType(domain, discreteChanceNode, 3);
                if (object == discreteChanceNode) break;
                if (networkPanel != null) {
                    Node node2 = networkPanel.getNode(discreteChanceNode);
                    if (node2 == null) {
                        node2 = networkPanel.getNode(discreteChanceNode.getName());
                    }
                    node2.setAPINode((COM.hugin.HAPI.Node)object);
                }
                n2 = ((DiscreteNode)object).getNumberOfStates();
                for (int i = 0; i < n2; ++i) {
                    ((IntervalDCNode)object).setStateValue(i, dArray[i * 2]);
                    ((DiscreteNode)object).setStateLabel(i, HuginGUIUtils.printInterval(dArray[i * 2], dArray[i * 2 + 1]));
                }
                ((IntervalDCNode)object).setStateValue(n2, dArray[dArray.length - 1]);
                if (object == discreteChanceNode) continue;
                HuginGUIUtils.transferCases(discreteChanceNode, (DiscreteChanceNode)object, n);
                string = discreteChanceNode.getName();
                discreteChanceNode.delete();
                ((COM.hugin.HAPI.Node)object).setName(string);
                continue;
            }
            if (n5 != INTERVAL_TYPE_INVALID) continue;
        }
    }

    public static DiscreteChanceNode setNodeType(Domain domain, DiscreteChanceNode discreteChanceNode, int n) {
        int n2 = -1;
        if (discreteChanceNode instanceof LabelledDCNode) {
            n2 = 0;
        } else if (discreteChanceNode instanceof BooleanDCNode) {
            n2 = 1;
        } else if (discreteChanceNode instanceof IntervalDCNode) {
            n2 = 3;
        } else if (discreteChanceNode instanceof NumberedDCNode) {
            n2 = 2;
        }
        if (n2 == n || n2 == -1) {
            return discreteChanceNode;
        }
        DiscreteChanceNode discreteChanceNode2 = null;
        try {
            if (n == 0) {
                discreteChanceNode2 = new LabelledDCNode(domain);
            } else if (n == 1) {
                discreteChanceNode2 = new BooleanDCNode(domain);
            } else if (n == 2) {
                discreteChanceNode2 = new NumberedDCNode(domain);
            } else if (n == 3) {
                discreteChanceNode2 = new IntervalDCNode(domain);
            }
            if (n == 1) {
                discreteChanceNode2.setStateLabel(1, HuginGUIConstants.get("NODE_PROPERTIES_true"));
                discreteChanceNode2.setStateLabel(0, HuginGUIConstants.get("NODE_PROPERTIES_false"));
            } else {
                int n3 = discreteChanceNode.getNumberOfStates();
                discreteChanceNode2.setNumberOfStates(n3);
                for (int i = 0; i < n3; ++i) {
                    if (n == 0) {
                        discreteChanceNode2.setStateLabel(i, HuginGUIConstants.get("NODE_PROPERTIES_state") + (i + 1));
                        continue;
                    }
                    if (n == 2) {
                        ((NumberedDCNode)discreteChanceNode2).setStateValue(i, i + 1);
                        discreteChanceNode2.setStateLabel(i, HuginGUIUtils.printDouble(i + 1));
                        continue;
                    }
                    if (n != 3) continue;
                    ((IntervalDCNode)discreteChanceNode2).setStateValue(i, i);
                    if (i + 1 == n3) {
                        ((IntervalDCNode)discreteChanceNode2).setStateValue(i + 1, i + 1);
                    }
                    discreteChanceNode2.setStateLabel(i, HuginGUIUtils.printInterval(i, i + 1));
                }
            }
            discreteChanceNode2.setPosition(discreteChanceNode.getPosition());
            discreteChanceNode2.setLabel(discreteChanceNode.getLabel());
            for (COM.hugin.HAPI.Node node : domain.getNodes()) {
                DiscreteChanceNode discreteChanceNode3 = (DiscreteChanceNode)node;
                if (discreteChanceNode == discreteChanceNode3 || discreteChanceNode.getEdgeConstraint(discreteChanceNode3) == NetworkModel.H_CONSTRAINT_NONE) continue;
                discreteChanceNode2.setEdgeConstraint(discreteChanceNode3, discreteChanceNode.getEdgeConstraint(discreteChanceNode3));
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        return discreteChanceNode2;
    }

    public static boolean nodeIsBoolean(DiscreteChanceNode discreteChanceNode) throws ExceptionHugin {
        if (discreteChanceNode.getNumberOfStates() != 2) {
            return false;
        }
        String string = discreteChanceNode.getStateLabel(0).toLowerCase();
        String string2 = discreteChanceNode.getStateLabel(1).toLowerCase();
        if (string.equals(HuginGUIConstants.get("NODE_PROPERTIES_true").toLowerCase())) {
            return string2.equals(HuginGUIConstants.get("NODE_PROPERTIES_false").toLowerCase());
        }
        if (string.equals(HuginGUIConstants.get("NODE_PROPERTIES_false").toLowerCase())) {
            return string2.equals(HuginGUIConstants.get("NODE_PROPERTIES_true").toLowerCase());
        }
        return false;
    }

    public static boolean valuesAreNumerical(String[] stringArray) {
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                Double.parseDouble(stringArray[i]);
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public static boolean nodeIsNumerical(DiscreteChanceNode discreteChanceNode) throws ExceptionHugin {
        String[] stringArray = new String[discreteChanceNode.getNumberOfStates()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = discreteChanceNode.getStateLabel(i);
        }
        return HuginGUIUtils.valuesAreNumerical(stringArray);
    }

    public static int valuesAreInterval(String[] stringArray) {
        int n;
        double[] dArray = new double[stringArray.length * 2];
        try {
            for (n = 0; n < stringArray.length; ++n) {
                double d;
                String string = stringArray[n].trim();
                if (string.length() == 0) {
                    return INTERVAL_TYPE_NOT;
                }
                boolean bl = string.charAt(0) == '-';
                int n2 = string.indexOf("-", bl ? 1 : 0);
                if (n2 < 0) {
                    return INTERVAL_TYPE_NOT;
                }
                double d2 = Double.parseDouble(string.substring(0, n2));
                if (d2 >= (d = Double.parseDouble(string.substring(n2 + 1)))) {
                    return INTERVAL_TYPE_NOT;
                }
                dArray[n * 2] = d2;
                dArray[n * 2 + 1] = d;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return INTERVAL_TYPE_NOT;
        }
        Arrays.sort(dArray);
        for (n = 1; n < stringArray.length; ++n) {
            if (dArray[n * 2] == dArray[n * 2 - 1]) continue;
            return INTERVAL_TYPE_INVALID;
        }
        return INTERVAL_TYPE_VALID;
    }

    public static int nodeIsInterval(DiscreteChanceNode discreteChanceNode) throws ExceptionHugin {
        String[] stringArray = new String[discreteChanceNode.getNumberOfStates()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = discreteChanceNode.getStateLabel(i);
        }
        return HuginGUIUtils.valuesAreInterval(stringArray);
    }

    public static void transferCases(DiscreteChanceNode discreteChanceNode, DiscreteChanceNode discreteChanceNode2, int n) throws ExceptionHugin {
        block12: {
            block13: {
                block11: {
                    if (!(discreteChanceNode instanceof LabelledDCNode)) {
                        return;
                    }
                    if (!(discreteChanceNode2 instanceof BooleanDCNode)) break block11;
                    for (int i = 0; i < n; ++i) {
                        if (!discreteChanceNode.caseIsSet(i)) continue;
                        String string = discreteChanceNode.getStateLabel(discreteChanceNode.getCaseState(i));
                        if (string.toLowerCase().equals(discreteChanceNode2.getStateLabel(0).toLowerCase())) {
                            discreteChanceNode2.setCaseState(i, 0);
                            continue;
                        }
                        discreteChanceNode2.setCaseState(i, 1);
                    }
                    break block12;
                }
                if (!(discreteChanceNode2 instanceof NumberedDCNode)) break block13;
                int[] nArray = new int[discreteChanceNode.getNumberOfStates()];
                Arrays.fill(nArray, -1);
                for (int i = 0; i < n; ++i) {
                    if (!discreteChanceNode.caseIsSet(i)) continue;
                    try {
                        int n2 = discreteChanceNode.getCaseState(i);
                        int n3 = nArray[n2];
                        if (n3 < 0) {
                            double d = Double.parseDouble(discreteChanceNode.getStateLabel(n2));
                            nArray[n2] = n3 = ((NumberedDCNode)discreteChanceNode2).getStateIndex(d);
                        }
                        if (n3 < 0) continue;
                        discreteChanceNode2.setCaseState(i, n3);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                break block12;
            }
            if (!(discreteChanceNode2 instanceof IntervalDCNode)) break block12;
            int[] nArray = new int[discreteChanceNode.getNumberOfStates()];
            Arrays.fill(nArray, -1);
            for (int i = 0; i < n; ++i) {
                if (!discreteChanceNode.caseIsSet(i)) continue;
                try {
                    int n4 = discreteChanceNode.getCaseState(i);
                    int n5 = nArray[n4];
                    if (n5 < 0) {
                        String string = discreteChanceNode.getStateLabel(n4);
                        double d = Double.parseDouble(string.substring(0, string.indexOf("-", 1)));
                        nArray[n4] = n5 = ((IntervalDCNode)discreteChanceNode2).getStateIndex(d);
                    }
                    if (n5 < 0) continue;
                    discreteChanceNode2.setCaseState(i, n5);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    protected static void writeCliqueSize(Domain domain) throws ExceptionHugin {
        long l = 0L;
        for (JunctionTree junctionTree : domain.getJunctionTrees()) {
            l += HuginGUIUtils.calculateJTSize(junctionTree);
        }
        Hugin.mainFrame.statusBar.write(HuginGUIConstants.get("MISCELLANEOUS_total_cost_of_triangulation") + l);
    }

    private static long calculateJTSize(JunctionTree junctionTree) throws ExceptionHugin {
        long l = 0L;
        for (Clique clique : junctionTree.getCliques()) {
            l += HuginGUIUtils.calculateCliqueSize(clique);
        }
        return l;
    }

    protected static long calculateCliqueSize(Clique clique) throws ExceptionHugin {
        return HuginGUIUtils.calculateNodesSize(clique.getMembers());
    }

    protected static long calculateNodesSize(NodeList nodeList) throws ExceptionHugin {
        long l = 0L;
        long l2 = 1L;
        for (COM.hugin.HAPI.Node node : nodeList) {
            if (node instanceof DiscreteNode) {
                l2 *= (long)((DiscreteNode)node).getNumberOfStates();
                continue;
            }
            if (!(node instanceof ContinuousChanceNode)) continue;
            ++l;
        }
        return l2 * (1L + l * (l + 3L) / 2L);
    }

    protected static void insertCases(DataStream dataStream, boolean bl) throws ExceptionHugin, PreProcessingException, DataSourceException {
        try {
            dataStream.reset();
            Case case_ = dataStream.readCase();
            if (case_ == null) {
                throw new PreProcessingException(HuginGUIConstants.get("str_the_data_set_is_empty_and_cannot_be_used_for_learning"));
            }
            boolean bl2 = false;
            while (case_ != null) {
                if (bl) {
                    case_.insertOrCreate();
                } else {
                    case_.insert();
                }
                case_ = dataStream.readCase();
            }
        }
        catch (PreProcessingException preProcessingException) {
            try {
                dataStream.reset();
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
            throw preProcessingException;
        }
        catch (ExceptionHugin exceptionHugin) {
            try {
                dataStream.reset();
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
            throw exceptionHugin;
        }
        catch (DataSourceException dataSourceException) {
            try {
                dataStream.reset();
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
            throw dataSourceException;
        }
    }

    protected static NodeList getOutputClones(COM.hugin.HAPI.Node node) throws ExceptionHugin {
        NodeList nodeList = new NodeList();
        for (COM.hugin.HAPI.Node node2 : node.getHomeClass().getInstances()) {
            COM.hugin.HAPI.InstanceNode instanceNode = (COM.hugin.HAPI.InstanceNode)node2;
            nodeList.add(instanceNode.getOutput(node));
        }
        return nodeList;
    }

    protected static HashMap<COM.hugin.HAPI.InstanceNode, COM.hugin.HAPI.Node> getOutputCloneMap(COM.hugin.HAPI.Node node) throws ExceptionHugin {
        HashMap<COM.hugin.HAPI.InstanceNode, COM.hugin.HAPI.Node> hashMap = new HashMap<COM.hugin.HAPI.InstanceNode, COM.hugin.HAPI.Node>();
        for (COM.hugin.HAPI.Node node2 : node.getHomeClass().getInstances()) {
            COM.hugin.HAPI.InstanceNode instanceNode = (COM.hugin.HAPI.InstanceNode)node2;
            hashMap.put(instanceNode, instanceNode.getOutput(node));
        }
        return hashMap;
    }

    public static void beep() {
        if (Hugin.mainFrame != null && Hugin.mainFrame.preferences.beep_on_errors) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public static void beep(String string) {
        if (Hugin.mainFrame != null) {
            HuginGUIUtils.beep();
            Hugin.mainFrame.statusBar.write(string);
        }
    }

    public static boolean importSettings(NetworkModel networkModel, NetworkModel networkModel2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) throws ExceptionHugin {
        Object object;
        Object object2;
        boolean bl8 = false;
        int n = 0;
        int n2 = 0;
        if (bl4) {
            object2 = networkModel.getNodeSize();
            n = (int)((networkModel2.getNodeSize().getX() - ((Point2D)object2).getX()) / 2.0);
            n2 = (int)((networkModel2.getNodeSize().getY() - ((Point2D)object2).getY()) / 2.0);
            networkModel2.setNodeSize((Point2D)object2);
        }
        if (bl5) {
            networkModel2.setAttribute("HR_Groups_GroupColors", networkModel.getAttribute("HR_Groups_GroupColors"));
            networkModel2.setAttribute("HR_Groups_GroupNames", networkModel.getAttribute("HR_Groups_GroupNames"));
            networkModel2.setAttribute("HR_Groups_UserGroupsNo", networkModel.getAttribute("HR_Groups_UserGroupsNo"));
            networkModel2.setAttribute("HR_Groups_IDs", networkModel.getAttribute("HR_Groups_IDs"));
            object2 = networkModel.getAttribute("HR_Groups_IDs");
            if (object2 != null) {
                String[] stringArray = ((String)object2).split(",");
                for (int i = 0; i < stringArray.length; ++i) {
                    object = "HR_Group_" + stringArray[i];
                    networkModel2.setAttribute((String)object + "_Description", networkModel.getAttribute((String)object + "_Description"));
                    networkModel2.setAttribute((String)object + "_Color", networkModel.getAttribute((String)object + "_Color"));
                    networkModel2.setAttribute((String)object + "_Name", networkModel.getAttribute((String)object + "_Name"));
                }
            }
        }
        if (bl2) {
            networkModel2.setAttribute("HR_Desc", networkModel.getAttribute("HR_Desc"));
        }
        object2 = networkModel.getNodes();
        int n3 = 0;
        if (bl && bl7) {
            Iterator iterator = ((AbstractSequentialList)object2).iterator();
            while (iterator.hasNext()) {
                object = (COM.hugin.HAPI.Node)iterator.next();
                n3 = Math.max(n3, (int)((COM.hugin.HAPI.Node)object).getPosition().getY());
            }
            n3 = (int)((double)n3 + networkModel2.getNodeSize().getY());
        }
        if (bl6) {
            HuginGUIUtils.clearConstraints(networkModel2);
        }
        Iterator iterator = ((AbstractSequentialList)object2).iterator();
        while (iterator.hasNext()) {
            object = (COM.hugin.HAPI.Node)iterator.next();
            COM.hugin.HAPI.Node node = networkModel2.getNodeByName(((COM.hugin.HAPI.Node)object).getName());
            if (node == null) continue;
            if (bl) {
                Point2D point2D = ((COM.hugin.HAPI.Node)object).getPosition();
                if (bl7) {
                    point2D.setLocation(point2D.getX() + (double)n, (double)n3 - (point2D.getY() + (double)n2));
                } else {
                    point2D.setLocation(point2D.getX() + (double)n, point2D.getY() + (double)n2);
                }
                node.setPosition(point2D);
            }
            if (bl3) {
                node.setLabel(((COM.hugin.HAPI.Node)object).getLabel());
            }
            if (bl5) {
                node.setAttribute("HR_Grp", ((COM.hugin.HAPI.Node)object).getAttribute("HR_Grp"));
                node.setAttribute("HR_Group", ((COM.hugin.HAPI.Node)object).getAttribute("HR_Group"));
            }
            if (bl2) {
                node.setAttribute("HR_Desc", ((COM.hugin.HAPI.Node)object).getAttribute("HR_Desc"));
            }
            if (bl4) {
                node.setAttribute("HR_NodeSize", ((COM.hugin.HAPI.Node)object).getAttribute("HR_NodeSize"));
            }
            if (bl6) {
                for (Attribute attribute : ((COM.hugin.HAPI.Node)object).getAttributes()) {
                    String string = attribute.getKey();
                    if (string.indexOf("HR_Constraint_") != 0 || networkModel2.getNodeByName(string.substring(14)) == null) continue;
                    node.setAttribute(string, attribute.getValue());
                }
            }
            bl8 = true;
        }
        return bl8;
    }

    private static void clearConstraints(NetworkModel networkModel) throws ExceptionHugin {
        for (COM.hugin.HAPI.Node node : networkModel.getNodes()) {
            for (Attribute attribute : node.getAttributes()) {
                String string = attribute.getKey();
                if (string.indexOf("HR_Constraint_") != 0) continue;
                node.setAttribute(string, null);
            }
        }
    }

    public static void centerComponent(Component component, Window window) {
        int n = component.getWidth() / 2 - window.getPreferredSize().width / 2;
        int n2 = component.getHeight() / 2 - window.getPreferredSize().height / 2;
        Point point = new Point(Math.max(0, n), Math.max(0, n2));
        SwingUtilities.convertPointToScreen(point, component);
        window.setLocation(point);
    }

    public static void centerComponent(Window window, Window window2) {
        int n = window.getWidth() / 2 - window2.getPreferredSize().width / 2;
        int n2 = window.getHeight() / 2 - window2.getPreferredSize().height / 2;
        int n3 = Math.max(0, window.getX() + n);
        int n4 = Math.max(0, window.getY() + n2);
        window2.setLocation(n3, n4);
    }

    public static void placeNextTo(Component component, Component component2) {
        Point point = new Point(0, 0);
        SwingUtilities.convertPointToScreen(point, component);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = 0;
        int n2 = 0;
        if (dimension.width - (point.x + component.getWidth()) > 25) {
            n = point.x + component.getWidth();
            n += Math.min(dimension.width - (n + component2.getWidth()), 0);
        } else {
            n = Math.max(0, point.x - component2.getWidth());
        }
        n2 = point.y + Math.min(dimension.height - (point.y + component2.getHeight()), 0);
        n2 = Math.max(0, n2);
        component2.setLocation(n, n2);
    }

    public static double parseDouble(String string, String string2, String string3) {
        return Double.parseDouble(string.substring(string.indexOf(string2) + 1, string.indexOf(string3)).trim());
    }

    public static String getLegalName(String string, NetworkModel networkModel) throws ExceptionHugin {
        int n;
        char[] cArray = string.toCharArray();
        for (n = 1; n < string.length(); ++n) {
            if (HuginGUIUtils.legalChar(cArray[n], n == 0)) continue;
            cArray[n] = 95;
        }
        String string2 = new String(cArray);
        if (networkModel != null) {
            n = 2;
            while (HuginGUIUtils.nameExists(string2, networkModel)) {
                string2 = new String(cArray) + "_" + n++;
            }
        }
        return string2;
    }

    private static boolean legalChar(char c, boolean bl) {
        if (bl) {
            return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
        }
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_';
    }

    private static boolean nameExists(String string, NetworkModel networkModel) throws ExceptionHugin {
        return networkModel.getNodeByName(string) != null;
    }

    protected static String getNodeStateLabel(COM.hugin.HAPI.Node node, int n) throws ExceptionHugin {
        String string = node.getAttribute("HR_Node_states");
        if (string != null && string.toLowerCase().trim().equals("labels") && node instanceof DiscreteNode) {
            return ((DiscreteNode)node).getStateLabel(n);
        }
        if (node instanceof LabelledDCNode || node instanceof LabelledDDNode) {
            return ((DiscreteNode)node).getStateLabel(n);
        }
        if (node instanceof BooleanDCNode || node instanceof BooleanDDNode) {
            return HuginGUIConstants.get(n == 0 ? "NODE_PROPERTIES_false" : "NODE_PROPERTIES_true");
        }
        if (node instanceof NumberedDCNode) {
            double d = ((NumberedDCNode)node).getStateValue(n);
            return HuginGUIUtils.printDouble(d);
        }
        if (node instanceof IntervalDCNode) {
            return HuginGUIUtils.printInterval(((IntervalDCNode)node).getStateValue(n), ((IntervalDCNode)node).getStateValue(n + 1));
        }
        if (node instanceof NumberedDDNode) {
            double d = ((NumberedDDNode)node).getStateValue(n);
            return HuginGUIUtils.printDouble(d);
        }
        if (node instanceof IntervalDDNode) {
            return HuginGUIUtils.printInterval(((IntervalDDNode)node).getStateValue(n), ((IntervalDDNode)node).getStateValue(n + 1));
        }
        System.err.println("3");
        return "";
    }

    protected static Point layoutNodes(NodeList nodeList, int n, int n2, int n3, int n4) throws ExceptionHugin {
        int n5 = 0;
        int n6 = 0;
        Point2D.Float float_ = new Point2D.Float();
        int n7 = 0;
        int n8 = 0;
        int n9 = (int)Math.sqrt(nodeList.size());
        for (COM.hugin.HAPI.Node node : nodeList) {
            if (n7 >= n9) {
                n7 = 0;
                ++n8;
            }
            n5 = (n8 + 1) % 2 == 0 ? 90 : 50;
            n6 = (n7 + 1) % 2 == 0 ? 50 : 30;
            int n10 = n7 * n3 + n5;
            int n11 = n8 * n4 + n6;
            ((Point2D)float_).setLocation((float)n + (float)n10, (float)n2 + (float)n11);
            node.setPosition(float_);
            ++n7;
        }
        return new Point(n + n9 * n3 + n5, n2 + n8 * n4 + n6);
    }

    public static int max(int[] nArray) {
        int n = Integer.MIN_VALUE;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= n) continue;
            n = nArray[i];
        }
        return n;
    }

    public static String getStateName(DiscreteNode discreteNode, int n) throws ExceptionHugin {
        if (discreteNode instanceof LabelledDCNode) {
            return discreteNode.getStateLabel(n);
        }
        if (discreteNode instanceof BooleanDCNode) {
            return n == 0 ? "false" : "true";
        }
        if (discreteNode instanceof NumberedDCNode) {
            return "" + ((NumberedDCNode)discreteNode).getStateValue(n);
        }
        if (discreteNode instanceof IntervalDCNode) {
            IntervalDCNode intervalDCNode = (IntervalDCNode)discreteNode;
            Object var3_3 = null;
            if (intervalDCNode.getStateValue(n) == -Domain.INFINITY() && intervalDCNode.getStateValue(n + 1) == Domain.INFINITY()) {
                return "0.0";
            }
            if (intervalDCNode.getStateValue(n) == -Domain.INFINITY()) {
                return "" + 0.999 * intervalDCNode.getStateValue(n + 1);
            }
            if (intervalDCNode.getStateValue(n + 1) == Domain.INFINITY()) {
                return "" + 1.001 * intervalDCNode.getStateValue(n);
            }
            double d = ((IntervalDCNode)discreteNode).getStateValue(n);
            double d2 = ((IntervalDCNode)discreteNode).getStateValue(n + 1);
            return "" + (d + d2) / 2.0;
        }
        return "N/A";
    }

    public static boolean showTipWindow(Component component, String string, String string2, boolean bl) {
        HuginTipWindow huginTipWindow = new HuginTipWindow(string, string2, bl);
        huginTipWindow.pack();
        HuginGUIUtils.centerComponent(component, (Window)huginTipWindow);
        huginTipWindow.setVisible(true);
        return huginTipWindow.showAgain();
    }

    public static String getPassword(Component component, String string) {
        PasswordDialog passwordDialog = new PasswordDialog(string);
        passwordDialog.pack();
        HuginGUIUtils.centerComponent(component, (Window)passwordDialog);
        passwordDialog.setVisible(true);
        return passwordDialog.getPassword();
    }

    public static int compareNodes(COM.hugin.HAPI.Node node, COM.hugin.HAPI.Node node2, int n) throws ExceptionHugin {
        switch (n) {
            case 0: {
                return HuginGUIUtils.getNodeTitle(node).compareTo(HuginGUIUtils.getNodeTitle(node2));
            }
            case 1: {
                int n2 = -1;
                int n3 = -1;
                try {
                    n2 = Integer.parseInt(node.getAttribute("HR_Group"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    n3 = Integer.parseInt(node2.getAttribute("HR_Group"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n2 != n3) {
                    return -n2 - -n3;
                }
                if (node instanceof DiscreteChanceNode && !(node2 instanceof DiscreteChanceNode)) {
                    return 1;
                }
                if (node instanceof DiscreteDecisionNode) {
                    if (node2 instanceof DiscreteChanceNode) {
                        return -1;
                    }
                    if (!(node2 instanceof DiscreteDecisionNode)) {
                        return 1;
                    }
                }
                if (node instanceof UtilityNode) {
                    if (node2 instanceof DiscreteNode) {
                        return -1;
                    }
                    if (!(node2 instanceof UtilityNode)) {
                        return 1;
                    }
                }
                if (node instanceof ContinuousChanceNode) {
                    if (node2 instanceof DiscreteNode || node2 instanceof UtilityNode) {
                        return -1;
                    }
                    if (!(node2 instanceof ContinuousChanceNode)) {
                        return 1;
                    }
                }
                return HuginGUIUtils.compareNodes(node, node2, 0);
            }
        }
        return -1;
    }

    public static int compareNodes(Node node, Node node2, int n) throws ExceptionHugin {
        return HuginGUIUtils.compareNodes(node.getAPINode(), node2.getAPINode(), n);
    }

    public static boolean isValidNodeGroup(NetworkModel networkModel, int n, NetworkModel.Kind kind, NetworkModel.Category category) {
        try {
            for (COM.hugin.HAPI.Node node : networkModel.getNodes()) {
                String string = node.getAttribute("HR_Grp");
                if (string == null || Integer.parseInt(string) != n || kind != null && node.getKind() != kind || category != null && node.getCategory() != category) continue;
                return true;
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
        }
        return false;
    }

    public static Model reorderModelNodes(Node node, Model model, NodeList nodeList) throws ExceptionHugin {
        int n = 1;
        COM.hugin.HAPI.Node[] nodeArray = new COM.hugin.HAPI.Node[nodeList.size()];
        int[] nArray = new int[nodeList.size()];
        int n2 = 0;
        for (COM.hugin.HAPI.Node node2 : nodeList) {
            if (node2 instanceof DiscreteNode) {
                n *= ((DiscreteNode)node2).getNumberOfStates();
            }
            nodeArray[n2++] = node2;
        }
        Vector<Expression> vector = new Vector<Expression>(n);
        if (nArray.length == 0) {
            vector.setSize(1);
            if (model != null) {
                vector.add(0, model.getExpression(0));
            }
        } else {
            nArray[nodeArray.length - 1] = 1;
            for (int i = nodeArray.length - 2; i >= 0; --i) {
                if (!(nodeArray[i + 1] instanceof DiscreteNode)) continue;
                nArray[i] = nArray[i + 1] * ((DiscreteNode)nodeArray[i + 1]).getNumberOfStates();
            }
            vector.setSize(n);
            for (int i = 0; i < n; ++i) {
                Map<COM.hugin.HAPI.Node, Integer> map = HuginGUIUtils.buildExpressionID(i, nodeArray, nArray);
                vector.add(i, HuginGUIUtils.getExpressionFromID(model, map));
            }
        }
        Model model2 = node.getModel(nodeList);
        for (int i = 0; i < n; ++i) {
            Expression expression = (Expression)vector.get(i);
            if (expression == null) continue;
            try {
                model2.setExpression(i, expression);
                continue;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }
        return model2;
    }

    private static Map<COM.hugin.HAPI.Node, Integer> buildExpressionID(int n, COM.hugin.HAPI.Node[] nodeArray, int[] nArray) throws ExceptionHugin {
        HashMap<COM.hugin.HAPI.Node, Integer> hashMap = new HashMap<COM.hugin.HAPI.Node, Integer>();
        for (int i = 0; i < nodeArray.length; ++i) {
            hashMap.put(nodeArray[i], new Integer(n / nArray[i]));
            n %= nArray[i];
        }
        return hashMap;
    }

    private static Expression getExpressionFromID(Model model, Map<COM.hugin.HAPI.Node, Integer> map) throws ExceptionHugin {
        if (model == null) {
            return null;
        }
        int n = 0;
        int n2 = 1;
        NodeList nodeList = model.getNodes();
        ListIterator listIterator = nodeList.listIterator(nodeList.size());
        while (listIterator.hasPrevious()) {
            COM.hugin.HAPI.Node node = (COM.hugin.HAPI.Node)listIterator.previous();
            Integer n3 = map.get(node);
            if (n3 != null) {
                n += n3 * n2;
            }
            if (!(node instanceof DiscreteNode)) continue;
            n2 *= ((DiscreteNode)node).getNumberOfStates();
        }
        return model.getExpression(n);
    }

    public static Dimension getNodeSize(COM.hugin.HAPI.Node node) throws ExceptionHugin {
        String string = node.getAttribute("HR_NodeSize");
        if (string != null) {
            return new Dimension((int)HuginGUIUtils.parseDouble(string, "(", ","), (int)HuginGUIUtils.parseDouble(string, ",", ")"));
        }
        Point2D point2D = node.getHome().getNodeSize();
        return new Dimension((int)point2D.getX(), (int)point2D.getY());
    }

    public static String getHtmlHelpDir() {
        String string;
        String string2 = Hugin.mainFrame.getHuginHome();
        if (System.getProperty("mrj.version") != null) {
            string = ClassLoader.getSystemClassLoader().getResource("icons/empty.gif").toString();
            string2 = string.substring(string.indexOf("/"), string.indexOf(".app/Contents")) + ".app/Contents/Resources/";
            string2 = string2.replaceAll("%20", " ");
        }
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        string = System.getProperty("file.separator");
        if (!string2.substring(string2.length() - 1).equals(string)) {
            string2 = string2 + string;
        }
        return string2 + "htmlhelp" + string;
    }

    public static Image createRotatedImage(Component component, String string, FontMetrics fontMetrics, Font font, Color color, Color color2) {
        if (fontMetrics == null) {
            return null;
        }
        int n = fontMetrics.stringWidth(string) + 2;
        int n2 = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + 2;
        Image image = component.createImage(n, n2);
        Graphics graphics = image.getGraphics();
        graphics.setColor(color);
        graphics.fillRect(0, 0, n, n2);
        graphics.setColor(color2);
        graphics.setFont(font);
        graphics.drawString(string, 1, fontMetrics.getMaxAscent() + 1);
        graphics.dispose();
        int[] nArray = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int[] nArray2 = new int[n * n2];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                nArray2[j * n2 + i] = nArray[i * n + (n - j - 1)];
            }
        }
        MemoryImageSource memoryImageSource = new MemoryImageSource(n2, n, ColorModel.getRGBdefault(), nArray2, 0, n2);
        Image image2 = component.createImage(memoryImageSource);
        MediaTracker mediaTracker = new MediaTracker(component);
        mediaTracker.addImage(image2, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return image2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkedList<Node> nominateReplacementParents(Node node, Node node2) {
        LinkedList<Node> linkedList = new LinkedList<Node>();
        try {
            NetworkPanel networkPanel = node.panel;
            NodeList nodeList = node.getAPINode().getParents();
            for (COM.hugin.HAPI.Node node3 : networkPanel.getHome().getNodes()) {
                boolean bl = true;
                if (node3.equals(node.getAPINode())) {
                    bl = false;
                }
                if (node3.equals(node2.getAPINode())) {
                    bl = false;
                }
                if (!node2.consistentWith(networkPanel.getNode(node3))) {
                    bl = false;
                }
                if (node.directedPath(networkPanel.getNode(node3))) {
                    bl = false;
                }
                if (nodeList.contains(node3)) {
                    bl = false;
                }
                if (bl) {
                    linkedList.add(networkPanel.getNode(node3));
                }
                Collections.sort(linkedList);
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        finally {
            return linkedList;
        }
    }

    public static HashSet<Node> getAllAncestors(HuginProjectFrame huginProjectFrame, Node node) {
        HashSet<Node> hashSet = new HashSet<Node>();
        for (Link link : huginProjectFrame.getNetworkPanel().linkList) {
            if (link.child != node || hashSet.contains(link.parent)) continue;
            hashSet.add(link.parent);
            hashSet.addAll(HuginGUIUtils.getAllAncestors(huginProjectFrame, link.parent));
        }
        return hashSet;
    }

    public static void propagateAllCDVTLinks(HuginProjectFrame huginProjectFrame) {
        NetworkPanel networkPanel = huginProjectFrame.getNetworkPanel();
        BeliefBarPanel beliefBarPanel = huginProjectFrame.getBeliefBarPanel();
        ArrayList<CDVTLink> arrayList = new ArrayList<CDVTLink>();
        for (Link object : networkPanel.linkList) {
            if (!(object instanceof CDVTLink)) continue;
            arrayList.add((CDVTLink)object);
        }
        ArrayList arrayList2 = new ArrayList();
        try {
            for (CDVTLink cDVTLink : arrayList) {
                int n = 0;
                for (int i = 0; i < arrayList2.size(); ++i) {
                    if (!HuginGUIUtils.getAllAncestors(huginProjectFrame, cDVTLink.parent).contains(((CDVTLink)arrayList2.get((int)i)).child)) continue;
                    n = i + 1;
                }
                arrayList2.add(n, cDVTLink);
            }
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                CDVTLink cDVTLink;
                cDVTLink = (CDVTLink)iterator.next();
                if (beliefBarPanel.getDomainNodeFor(cDVTLink.parent.getAPINode()).evidenceIsEntered()) {
                    HuginGUIUtils.setDCStateFromCC(cDVTLink.child, cDVTLink.parent, huginProjectFrame);
                    continue;
                }
                if (beliefBarPanel.getDomainNodeFor(cDVTLink.child.getAPINode()).evidenceIsEntered()) continue;
                HuginGUIUtils.doPMI(huginProjectFrame, cDVTLink.parent, cDVTLink.child, false);
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin.getMessage());
        }
    }

    public static void setDCStateFromCC(Node node, Node node2, HuginProjectFrame huginProjectFrame) throws ExceptionHugin {
        BeliefBarPanel beliefBarPanel = huginProjectFrame.getBeliefBarPanel();
        IntervalDCNode intervalDCNode = (IntervalDCNode)beliefBarPanel.getDomainNodeFor(node.getAPINode());
        ContinuousChanceNode continuousChanceNode = (ContinuousChanceNode)beliefBarPanel.getDomainNodeFor(node2.getAPINode());
        double d = continuousChanceNode.getEnteredValue();
        int n = 0;
        int n2 = intervalDCNode.getNumberOfStates();
        for (int i = 0; i < n2; ++i) {
            if (!(d >= intervalDCNode.getStateValue(i)) || !(d <= intervalDCNode.getStateValue(i + 1))) continue;
            n = i;
        }
        intervalDCNode.selectState(n);
        Domain domain = beliefBarPanel.getDomain();
        HuginGUIUtils.configureDomain(domain);
        Domain.Equilibrium equilibrium = Domain.H_EQUILIBRIUM_SUM;
        Domain.EvidenceMode evidenceMode = Domain.H_EVIDENCE_MODE_NORMAL;
        domain.propagate(equilibrium, evidenceMode);
        beliefBarPanel.propagateIfNecessary();
        beliefBarPanel.repaint();
        ((HuginProjectFrame)huginProjectFrame.guiFrame.desktop.getSelectedFrame()).getNetworkPanel().repaint();
    }

    public static boolean addPMI(HuginProjectFrame huginProjectFrame, Node node, Node node2) throws ExceptionHugin {
        NetworkPanel networkPanel = huginProjectFrame.getNetworkPanel();
        Node node3 = null;
        Node node4 = null;
        if (node.getAPINode() instanceof IntervalDCNode) {
            node3 = node;
            node4 = node2;
        } else {
            node3 = node2;
            node4 = node;
        }
        if (node3.directedPath(node4)) {
            return false;
        }
        if (node3.getAPINode().getAttribute("HR_CDVT_parent") != null) {
            return false;
        }
        CDVTLink cDVTLink = new CDVTLink(node4, node3);
        networkPanel.linkList.add(cDVTLink);
        networkPanel.repaint();
        node3.hideTable();
        return true;
    }

    public static void doPMI(HuginProjectFrame huginProjectFrame, Node node, Node node2, boolean bl) throws ExceptionHugin {
        try {
            ContinuousChanceNode continuousChanceNode;
            IntervalDCNode intervalDCNode;
            NetworkPanel networkPanel = huginProjectFrame.getNetworkPanel();
            COM.hugin.HAPI.Node node3 = node.getAPINode();
            COM.hugin.HAPI.Node node4 = node2.getAPINode();
            BeliefBarPanel beliefBarPanel = huginProjectFrame.getBeliefBarPanel();
            Domain domain = beliefBarPanel.getDomain();
            Domain domain2 = new Domain();
            Domain.Equilibrium equilibrium = Domain.H_EQUILIBRIUM_SUM;
            Domain.EvidenceMode evidenceMode = Domain.H_EVIDENCE_MODE_NORMAL;
            Node node5 = null;
            Node node6 = null;
            if (node3 instanceof IntervalDCNode) {
                intervalDCNode = (IntervalDCNode)beliefBarPanel.getDomainNodeFor(node3);
                node6 = node;
            } else {
                intervalDCNode = (IntervalDCNode)beliefBarPanel.getDomainNodeFor(node4);
                node6 = node2;
            }
            if (node3 instanceof ContinuousChanceNode) {
                continuousChanceNode = (ContinuousChanceNode)beliefBarPanel.getDomainNodeFor(node3);
                node5 = node;
            } else {
                continuousChanceNode = (ContinuousChanceNode)beliefBarPanel.getDomainNodeFor(node4);
                node5 = node2;
            }
            IntervalDCNode intervalDCNode2 = new IntervalDCNode(domain2);
            intervalDCNode2.setNumberOfStates(intervalDCNode.getNumberOfStates());
            for (int i = 0; i <= intervalDCNode.getNumberOfStates(); ++i) {
                intervalDCNode2.setStateValue(i, intervalDCNode.getStateValue(i));
            }
            Table table = continuousChanceNode.getDistribution();
            NumberedDCNode numberedDCNode = new NumberedDCNode(domain2);
            int n = table.getSize();
            numberedDCNode.setNumberOfStates(n);
            intervalDCNode2.addParent(numberedDCNode);
            NodeList nodeList = new NodeList();
            nodeList.add(numberedDCNode);
            Model model = new Model(intervalDCNode2, nodeList);
            for (int i = 0; i < n; ++i) {
                numberedDCNode.setStateValue(i, i);
                numberedDCNode.getTable().setDataItem(i, table.getDataItem(i));
                double d = table.getMean(i, continuousChanceNode);
                double d2 = table.getVariance(i, continuousChanceNode);
                NumberExpression numberExpression = new NumberExpression(d);
                NumberExpression numberExpression2 = new NumberExpression(d2);
                Expression expression = null;
                expression = d2 != 0.0 ? new NormalDistribution((Expression)numberExpression, numberExpression2) : numberExpression;
                model.setExpression(i, expression);
            }
            intervalDCNode2.generateTable();
            intervalDCNode2.reverseEdge(numberedDCNode);
            numberedDCNode.delete();
            intervalDCNode.getTable().setData(intervalDCNode2.getTable().getData());
            domain2.delete();
            if (bl) {
                CDVTLink cDVTLink = new CDVTLink(node5, node6);
                networkPanel.linkList.add(cDVTLink);
            }
            HuginGUIUtils.configureDomain(domain);
            if (!bl) {
                domain.propagate(equilibrium, evidenceMode);
                beliefBarPanel.propagateIfNecessary();
            } else {
                beliefBarPanel.propagate(equilibrium, evidenceMode);
            }
            beliefBarPanel.repaint();
            ((HuginProjectFrame)huginProjectFrame.guiFrame.desktop.getSelectedFrame()).getNetworkPanel().repaint();
        }
        catch (ExceptionHugin exceptionHugin) {
            exceptionHugin.printStackTrace();
            throw exceptionHugin;
        }
    }

    public static void createCaseFromEnteredEvidence(Domain domain) {
        try {
            int n = domain.newCase();
            block2: for (COM.hugin.HAPI.Node node : domain.getNodes()) {
                COM.hugin.HAPI.Node node2;
                if (node instanceof DiscreteNode) {
                    node2 = (DiscreteNode)node;
                    if (!node2.evidenceIsEntered()) continue;
                    int n2 = ((DiscreteNode)node2).getNumberOfStates();
                    for (int i = 0; i < n2; ++i) {
                        if (!(((DiscreteNode)node2).getEnteredFinding(i) > 0.0)) continue;
                        ((DiscreteNode)node2).setCaseState(n, i);
                        continue block2;
                    }
                    continue;
                }
                if (!(node instanceof ContinuousChanceNode) || !(node2 = (ContinuousChanceNode)node).evidenceIsEntered()) continue;
                ((ContinuousChanceNode)node2).setCaseValue(n, ((ContinuousChanceNode)node2).getEnteredValue());
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
        }
    }

    public static void simulateMAR(Domain domain, File file, int n, int n2, int n3, boolean bl) {
        try {
            int n4;
            COM.hugin.HAPI.Node node42;
            int n5;
            Object object22;
            if (n3 == 0) {
                HuginGUIUtils.simulateMCAR(domain, file, n, n2, bl);
                return;
            }
            NodeList nodeList = domain.getNodes();
            NodeList nodeList2 = new NodeList();
            for (Object object22 : nodeList) {
                boolean bl2 = false;
                if (object22 instanceof DiscreteNode) {
                    bl2 = true;
                }
                if (!bl2) continue;
                nodeList2.add(object22);
            }
            nodeList = nodeList2;
            int n6 = nodeList.size();
            object22 = new int[n6][n];
            long l = 0L;
            long l2 = (long)((double)(nodeList.size() * n) * ((double)n2 / 100.0));
            double d = (double)n3 / (double)n6;
            Random random = new Random();
            domain.seedRandom((int)random.nextLong());
            HuginGUIUtils.configureDomain(domain);
            domain.propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
            for (int i = 0; i < n; ++i) {
                domain.simulate();
                n5 = 0;
                for (COM.hugin.HAPI.Node node2 : nodeList) {
                    node42 = (DiscreteNode)node2;
                    object22[n5++][i] = ((DiscreteNode)node42).getSampledState();
                }
            }
            while (l < l2) {
                random.setSeed(System.currentTimeMillis());
                n5 = Math.abs(random.nextInt() % n6);
                int n7 = 0;
                LinkedList<NodeInstantiation> linkedList = new LinkedList<NodeInstantiation>();
                while (linkedList.size() == 0) {
                    n7 = 0;
                    Iterator iterator = nodeList.iterator();
                    while (iterator.hasNext()) {
                        COM.hugin.HAPI.Node node3 = node42 = (COM.hugin.HAPI.Node)iterator.next();
                        if (Math.random() < d && n7 != n5) {
                            random.setSeed(System.currentTimeMillis());
                            linkedList.add(new NodeInstantiation(n7, Math.abs(random.nextInt() % ((DiscreteNode)node3).getNumberOfStates())));
                        }
                        ++n7;
                    }
                }
                double d2 = Math.random();
                for (n4 = 0; n4 < n; ++n4) {
                    boolean bl3 = true;
                    for (NodeInstantiation object3 : linkedList) {
                        bl3 = bl3 && object22[object3.nodeNumber][n4] == object3.stateIndex;
                    }
                    if (!bl3 || !(d2 < Math.random())) continue;
                    object22[n5][n4] = -1;
                    ++l;
                }
            }
            n5 = 1;
            PrintWriter printWriter = null;
            if (file != null) {
                printWriter = new PrintWriter(file, "UTF-8");
                for (COM.hugin.HAPI.Node node42 : nodeList) {
                    if (n5 != 0) {
                        n5 = 0;
                    } else {
                        printWriter.print(",");
                    }
                    printWriter.print(node42.getName());
                }
                printWriter.println("");
            }
            for (int i = 0; i < n; ++i) {
                n5 = 1;
                int n8 = 0;
                n4 = -1;
                if (file == null) {
                    n4 = domain.newCase();
                }
                for (COM.hugin.HAPI.Node node : nodeList) {
                    String string;
                    DiscreteNode discreteNode = (DiscreteNode)node;
                    if (object22[n8][i] >= 0) {
                        string = HuginGUIUtils.getStateName(discreteNode, (int)object22[n8][i]);
                        if (!bl && discreteNode instanceof LabelledDCNode) {
                            string = "\"" + string + "\"";
                        }
                        if (file == null) {
                            discreteNode.setCaseState(n4, (int)object22[n8][i]);
                        }
                    } else {
                        String string2 = string = bl ? "N/A" : "";
                    }
                    if (file != null) {
                        if (n5 == 0) {
                            printWriter.print("," + string);
                        } else {
                            printWriter.print(string);
                            n5 = 0;
                        }
                    }
                    ++n8;
                }
                if (file == null) continue;
                printWriter.println("");
            }
            if (file != null) {
                printWriter.close();
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin.getMessage());
        }
        catch (IOException iOException) {
            new HuginGUIError(HuginGUIConstants.get("str_unable_save_file_check_permissions_disk_space"));
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    public static void simulateMCAR(Domain domain, File file, int n, int n2, boolean bl) {
        try {
            Object object2;
            NodeList nodeList = domain.getNodes();
            NodeList nodeList2 = new NodeList();
            for (Object object2 : nodeList) {
                boolean bl2 = false;
                if (object2 instanceof DiscreteNode || object2 instanceof ContinuousChanceNode) {
                    bl2 = true;
                }
                if (!bl2) continue;
                nodeList2.add(object2);
            }
            nodeList = nodeList2;
            Object object3 = null;
            if (file != null) {
                object3 = new PrintWriter(file, "UTF-8");
                object2 = "";
                for (Object object4 : nodeList) {
                    ((PrintWriter)object3).print((String)object2);
                    ((PrintWriter)object3).print(((COM.hugin.HAPI.Node)object4).getName());
                    object2 = ",";
                }
                ((PrintWriter)object3).println("");
            }
            domain.seedRandom((int)new Random().nextLong());
            HuginGUIUtils.configureDomain(domain);
            domain.propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
            for (int i = 0; i < n; ++i) {
                Object object4;
                object4 = "";
                domain.simulate();
                int n3 = -1;
                if (file == null) {
                    n3 = domain.newCase();
                }
                for (COM.hugin.HAPI.Node node : nodeList) {
                    String string;
                    int n4 = -1;
                    double d = 0.0;
                    if (node instanceof DiscreteNode) {
                        string = HuginGUIUtils.getStateName((DiscreteNode)node, ((DiscreteNode)node).getSampledState());
                        n4 = ((DiscreteNode)node).getSampledState();
                    } else {
                        if (!(node instanceof ContinuousChanceNode)) break;
                        string = "" + ((ContinuousChanceNode)node).getSampledValue();
                    }
                    int n5 = (int)(Math.random() * 100.0);
                    if (n5 < n2) {
                        object2 = bl ? "N/A" : "";
                    } else {
                        if (!bl && node instanceof LabelledDCNode) {
                            string = "\"" + string + "\"";
                        }
                        object2 = string;
                        if (file == null) {
                            if (node instanceof DiscreteNode) {
                                ((DiscreteNode)node).setCaseState(n3, n4);
                            } else if (node instanceof ContinuousChanceNode) {
                                ((ContinuousChanceNode)node).setCaseValue(n3, d);
                            }
                        }
                    }
                    object2 = (String)object4 + (String)object2;
                    if (file != null) {
                        ((PrintWriter)object3).print((String)object2);
                    }
                    object4 = ",";
                }
                if (file == null) continue;
                ((PrintWriter)object3).println("");
            }
            if (file != null) {
                ((PrintWriter)object3).close();
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin.getMessage());
        }
        catch (IOException iOException) {
            new HuginGUIError(HuginGUIConstants.get("str_unable_save_file_check_permissions_disk_space"));
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    public static String printInf(double d) {
        if (d == NetworkModel.INFINITY()) {
            return "inf";
        }
        if (d == -NetworkModel.INFINITY()) {
            return "-inf";
        }
        return "" + d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pauseEventQueue() {
        String string = tbMutexObj;
        synchronized (string) {
            if (!SwingUtilities.isEventDispatchThread() && threadResume) {
                tb = new ThreadBreaker();
                SwingUtilities.invokeLater(tb);
                while (threadResume) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resumeEventQueue() {
        String string = tbMutexObj;
        synchronized (string) {
            threadResume = true;
            try {
                ThreadBreaker threadBreaker = tb;
                synchronized (threadBreaker) {
                    tb.notify();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            while (!threadResume) {
                try {
                    Thread.sleep(10L);
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void configureDomain(Domain domain) throws ExceptionHugin {
        if (domain != null) {
            domain.setConcurrencyLevel(Hugin.mainFrame.preferences.level_of_concurrency);
            domain.setGrainSize(Hugin.mainFrame.preferences.grain_size);
        }
    }

    protected static Double average(DiscreteChanceNode discreteChanceNode, NetworkPanel networkPanel, boolean bl) {
        return HuginGUIUtils.average(discreteChanceNode, networkPanel, bl, null);
    }

    protected static Double average(DiscreteChanceNode discreteChanceNode, NetworkPanel networkPanel, boolean bl, String string) {
        if (discreteChanceNode instanceof IntervalDCNode) {
            return HuginGUIUtils.average((IntervalDCNode)discreteChanceNode, networkPanel, bl, string);
        }
        if (discreteChanceNode instanceof NumberedDCNode) {
            return HuginGUIUtils.average((NumberedDCNode)discreteChanceNode, networkPanel, bl, string);
        }
        return Double.NaN;
    }

    protected static Double variance(DiscreteChanceNode discreteChanceNode, NetworkPanel networkPanel) {
        if (discreteChanceNode instanceof IntervalDCNode) {
            return HuginGUIUtils.variance((IntervalDCNode)discreteChanceNode, networkPanel);
        }
        if (discreteChanceNode instanceof NumberedDCNode) {
            return HuginGUIUtils.variance((NumberedDCNode)discreteChanceNode, networkPanel);
        }
        return Double.NaN;
    }

    protected static Double average(IntervalDCNode intervalDCNode, NetworkPanel networkPanel, boolean bl, String string) {
        try {
            double d;
            double d2;
            int n = networkPanel.guiFrame.preferences.precision;
            boolean bl2 = false;
            double d3 = 0.0;
            int n2 = intervalDCNode.getNumberOfStates();
            int n3 = 0;
            int n4 = n2;
            String string2 = "";
            if (intervalDCNode.getNumberOfStates() == 1 && intervalDCNode.getStateValue(0) == -Domain.INFINITY() && intervalDCNode.getStateValue(1) == Domain.INFINITY()) {
                return new Double(0.0);
            }
            if (intervalDCNode.getStateValue(0) == -Domain.INFINITY()) {
                d2 = intervalDCNode.getStateValue(1);
                d = 0.0;
                d = d2 > 0.0 ? 0.999 * d2 : (d2 < 0.0 ? 1.001 * d2 : -1.0);
                d3 += d * intervalDCNode.getBelief(0);
                n3 = 1;
                string2 = string2 + HuginGUIUtils.printDouble(d, n) + " * " + HuginGUIUtils.printDouble(intervalDCNode.getBelief(0), n);
                if (n2 > 1) {
                    string2 = string2 + " + ";
                }
            }
            if (intervalDCNode.getStateValue(n2) == Domain.INFINITY()) {
                d2 = intervalDCNode.getStateValue(n2 - 1);
                d = 0.0;
                d = d2 > 0.0 ? 1.001 * d2 : (d2 < 0.0 ? 0.999 * d2 : 1.0);
                d3 += d * intervalDCNode.getBelief(n2 - 1);
                n4 = n2 - 1;
                string2 = string2 + HuginGUIUtils.printDouble(d, n) + " * " + HuginGUIUtils.printDouble(intervalDCNode.getBelief(n2 - 1), n);
                if (n3 < n4) {
                    string2 = string2 + " + ";
                }
            }
            for (int i = n3; i < n4; ++i) {
                double d4 = intervalDCNode.getStateValue(i);
                double d5 = intervalDCNode.getStateValue(i + 1);
                double d6 = intervalDCNode.getBelief(i);
                d3 += ((d5 - d4) / 2.0 + d4) * d6;
                string2 = string2 + "" + HuginGUIUtils.printDouble((d5 - d4) / 2.0 + d4, n) + " * " + HuginGUIUtils.printDouble(d6, n);
                if (i >= n4 - 1) continue;
                string2 = string2 + " + ";
            }
            if (bl) {
                networkPanel.writeStatus(HuginGUIConstants.get("Avg") + " (" + string + ") = " + string2);
            }
            return new Double(d3);
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin.getMessage());
            return Double.NaN;
        }
    }

    protected static Double average(NumberedDCNode numberedDCNode, NetworkPanel networkPanel, boolean bl, String string) {
        try {
            int n = networkPanel.guiFrame.preferences.precision;
            double d = 0.0;
            String string2 = "";
            int n2 = numberedDCNode.getNumberOfStates();
            for (int i = 0; i < n2; ++i) {
                double d2 = numberedDCNode.getStateValue(i);
                double d3 = numberedDCNode.getBelief(i);
                if (Math.abs(d2) != Domain.INFINITY()) {
                    d += d2 * d3;
                    string2 = string2 + "" + HuginGUIUtils.printDouble(d2, n) + " * " + HuginGUIUtils.printDouble(d3, n);
                    if (i >= n2 - 1) continue;
                    string2 = string2 + " + ";
                    continue;
                }
                if (bl) {
                    networkPanel.writeStatus(HuginGUIConstants.get("Avg") + " (" + string + ") is NaN");
                }
                return Double.NaN;
            }
            if (bl) {
                networkPanel.writeStatus(HuginGUIConstants.get("Avg") + " (" + string + ") = " + string2);
            }
            return new Double(d);
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin.getMessage());
            return Double.NaN;
        }
    }

    protected static Double variance(IntervalDCNode intervalDCNode, NetworkPanel networkPanel) {
        try {
            double d;
            double d2;
            boolean bl = false;
            Double d3 = HuginGUIUtils.average(intervalDCNode, networkPanel, false) * HuginGUIUtils.average(intervalDCNode, networkPanel, false);
            Double d4 = 0.0;
            int n = intervalDCNode.getNumberOfStates();
            int n2 = 0;
            int n3 = n;
            if (intervalDCNode.getNumberOfStates() == 1 && intervalDCNode.getStateValue(0) == -Domain.INFINITY() && intervalDCNode.getStateValue(1) == Domain.INFINITY()) {
                return new Double(0.0);
            }
            if (intervalDCNode.getStateValue(0) == -Domain.INFINITY()) {
                d2 = intervalDCNode.getStateValue(1);
                d = 0.0;
                d = d2 > 0.0 ? 0.999 * d2 : (d2 < 0.0 ? 1.001 * d2 : 1.0);
                d4 = d4 + d * d * intervalDCNode.getBelief(0);
                n2 = 1;
            }
            if (intervalDCNode.getStateValue(n) == Domain.INFINITY()) {
                d2 = intervalDCNode.getStateValue(n - 1);
                d = 0.0;
                d = d2 > 0.0 ? 1.001 * d2 : (d2 < 0.0 ? 0.999 * d2 : 1.0);
                d4 = d4 + d * d * intervalDCNode.getBelief(n - 1);
                n3 = n - 1;
            }
            for (int i = n2; i < n3; ++i) {
                double d5 = intervalDCNode.getStateValue(i);
                double d6 = intervalDCNode.getStateValue(i + 1);
                double d7 = intervalDCNode.getBelief(i);
                d4 = d4 + ((d6 - d5) / 2.0 + d5) * ((d6 - d5) / 2.0 + d5) * d7;
            }
            return new Double(d4 - HuginGUIUtils.average(intervalDCNode, networkPanel, false) * HuginGUIUtils.average(intervalDCNode, networkPanel, false));
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin.getMessage());
            return Double.NaN;
        }
    }

    protected static Double variance(NumberedDCNode numberedDCNode, NetworkPanel networkPanel) {
        try {
            Double d = HuginGUIUtils.average(numberedDCNode, networkPanel, false);
            if (!d.isNaN()) {
                double d2 = 0.0;
                int n = numberedDCNode.getNumberOfStates();
                for (int i = 0; i < n; ++i) {
                    double d3 = numberedDCNode.getStateValue(i);
                    double d4 = numberedDCNode.getBelief(i);
                    if (Math.abs(d3) != Domain.INFINITY()) {
                        d2 += d3 * d3 * d4;
                        continue;
                    }
                    return Double.NaN;
                }
                return new Double(d2 - d * d);
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin.getMessage());
        }
        return Double.NaN;
    }

    public static String getCptIndexDescription(Table table, int n) {
        String string = "";
        try {
            NodeList nodeList = table.getNodes();
            if (nodeList.size() > 0) {
                DiscreteNode discreteNode = (DiscreteNode)nodeList.getLast();
                int[] nArray = new int[nodeList.size()];
                table.getConfiguration(nArray, n);
                int n2 = nArray[nArray.length - 1];
                string = "P(" + HuginGUIUtils.getNodeTitle((COM.hugin.HAPI.Node)discreteNode, (short)0) + " = " + HuginGUIUtils.getNodeStateLabel(discreteNode, n2) + " | ";
                int n3 = -1;
                for (COM.hugin.HAPI.Node node : nodeList) {
                    if (++n3 == nodeList.size() - 1) {
                        string = string.substring(0, string.length() - 2) + ")";
                        continue;
                    }
                    string = string + HuginGUIUtils.getNodeTitle(node, (short)0) + " = " + HuginGUIUtils.getNodeStateLabel(node, nArray[n3]) + ", ";
                }
            }
            return string;
        }
        catch (ExceptionHugin exceptionHugin) {
            return "error";
        }
        catch (Exception exception) {
            return "error";
        }
    }

    public static void saveCases(File file, NodeList nodeList, int[] nArray) {
        try {
            int n = nArray.length;
            boolean bl = true;
            PrintWriter printWriter = null;
            if (file == null) {
                return;
            }
            printWriter = new PrintWriter(file, "UTF-8");
            for (COM.hugin.HAPI.Node node : nodeList) {
                if (bl) {
                    bl = false;
                } else {
                    printWriter.print(",");
                }
                printWriter.print(node.getName());
            }
            printWriter.println("");
            for (int i = 0; i < nArray.length; ++i) {
                bl = true;
                int n2 = nArray[i];
                for (COM.hugin.HAPI.Node node : nodeList) {
                    Object object;
                    if (node instanceof ContinuousChanceNode) {
                        object = ((ContinuousChanceNode)node).caseIsSet(nArray[i]) ? "" + ((ContinuousChanceNode)node).getCaseValue(nArray[i]) : "";
                    } else if (node instanceof DiscreteChanceNode) {
                        DiscreteChanceNode discreteChanceNode = (DiscreteChanceNode)node;
                        if (discreteChanceNode.caseIsSet(n2)) {
                            int n3 = discreteChanceNode.getCaseState(nArray[i]);
                            object = HuginGUIUtils.getStateName(discreteChanceNode, n3);
                            if (discreteChanceNode instanceof LabelledDCNode) {
                                object = "\"" + (String)object + "\"";
                            }
                        } else {
                            object = "";
                        }
                    } else {
                        object = "";
                    }
                    if (!bl) {
                        System.out.print("," + (String)object);
                        printWriter.print("," + (String)object);
                        continue;
                    }
                    System.out.print((String)object);
                    printWriter.print((String)object);
                    bl = false;
                }
                System.out.println("");
                printWriter.println("");
            }
            printWriter.close();
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin.getMessage());
        }
        catch (IOException iOException) {
            new HuginGUIError(HuginGUIConstants.get("str_unable_save_file_check_permissions_disk_space"));
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    public static double parseDouble(String string) throws NumberFormatException {
        if ((string = string.toLowerCase()).equals("-inf") || string.equals("-inf") || string.equals("-Infinity".toLowerCase()) || string.equals(("" + -Domain.INFINITY()).toLowerCase())) {
            return -Domain.INFINITY();
        }
        if (string.equals("inf") || string.equals("inf") || string.equals("Infinity".toLowerCase()) || string.equals(("" + Domain.INFINITY()).toLowerCase())) {
            return Domain.INFINITY();
        }
        return Double.parseDouble(string);
    }

    public static void updateFromModel(NetworkModel networkModel, NetworkModel networkModel2) {
        try {
            for (COM.hugin.HAPI.Node node : networkModel2.getNodes()) {
                Table table;
                Table table2;
                COM.hugin.HAPI.Node node2 = networkModel.getNodeByName(node.getName());
                if (node instanceof DiscreteChanceNode) {
                    if (((DiscreteChanceNode)node).hasExperienceTable()) {
                        ((DiscreteChanceNode)node2).getExperienceTable().update(((DiscreteChanceNode)node).getExperienceTable());
                    } else {
                        ((DiscreteChanceNode)node2).getExperienceTable().delete();
                    }
                    if (((DiscreteChanceNode)node).hasFadingTable()) {
                        ((DiscreteChanceNode)node2).getFadingTable().update(((DiscreteChanceNode)node).getFadingTable());
                    } else {
                        ((DiscreteChanceNode)node2).getFadingTable().delete();
                    }
                }
                if (node instanceof DiscreteNode) {
                    table2 = ((DiscreteNode)node).getTable();
                    table = ((DiscreteNode)node2).getTable();
                    if (table2.getSize() == table.getSize()) {
                        table.update(table2);
                    }
                }
                if (!(node instanceof ContinuousChanceNode)) continue;
                table2 = ((ContinuousChanceNode)node).getTable();
                table = ((ContinuousChanceNode)node2).getTable();
                if (table2.getSize() != table.getSize()) continue;
                table.update(table2);
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    public static String rightJustify(String string, int n) {
        while (string.length() < n) {
            string = " " + string;
        }
        return string;
    }

    public static String round(double d, int n) {
        try {
            BigDecimal bigDecimal = new BigDecimal(d);
            return bigDecimal.setScale(n, 4).toString();
        }
        catch (NumberFormatException numberFormatException) {
            return "" + d;
        }
    }

    public static int getNumericAttribute(NetworkModel networkModel, String string) {
        int n = 0;
        try {
            String string2 = networkModel.getAttribute(string);
            n = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public static void setUseSampledValue(Domain domain, boolean bl) throws ExceptionHugin {
        domain.setAttribute("HR_Temp_Use_Sampled_Value", bl ? "1" : null);
    }

    public static boolean getUseSampledValue(Domain domain) throws ExceptionHugin {
        String string = domain.getAttribute("HR_Temp_Use_Sampled_Value");
        return string != null && string.equals("1");
    }

    static {
        formatter.setGroupingUsed(false);
        DecimalFormatSymbols decimalFormatSymbols = ((DecimalFormat)formatter).getDecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        ((DecimalFormat)formatter).setDecimalFormatSymbols(decimalFormatSymbols);
        INTERVAL_TYPE_NOT = 0;
        INTERVAL_TYPE_VALID = 1;
        INTERVAL_TYPE_INVALID = 2;
        threadResume = true;
        tbMutexObj = "abc";
        tb = null;
    }

    public static class PolicyBackup {
        private static String incompatibleError = "Incompatible NetworkModel";
        private HashMap<String, String> nodeSignatures = new HashMap();
        private HashMap<String, double[]> policies = new HashMap();

        public PolicyBackup(NetworkModel networkModel) throws ExceptionHugin {
            for (COM.hugin.HAPI.Node node : networkModel.getNodes()) {
                if (!(node instanceof DiscreteDecisionNode)) continue;
                DiscreteDecisionNode discreteDecisionNode = (DiscreteDecisionNode)node;
                this.nodeSignatures.put(discreteDecisionNode.getName(), PolicyBackup.getSignature(discreteDecisionNode));
                this.policies.put(discreteDecisionNode.getName(), discreteDecisionNode.getTable().getData());
            }
        }

        public boolean compatible(NetworkModel networkModel) throws ExceptionHugin {
            int n = 0;
            for (COM.hugin.HAPI.Node node : networkModel.getNodes()) {
                if (!(node instanceof DiscreteDecisionNode)) continue;
                ++n;
                DiscreteDecisionNode discreteDecisionNode = (DiscreteDecisionNode)node;
                String string = this.nodeSignatures.get(discreteDecisionNode.getName());
                if (string != null && string.equals(PolicyBackup.getSignature(discreteDecisionNode))) continue;
                return false;
            }
            return n == this.nodeSignatures.size();
        }

        public void restorePolicies(NetworkModel networkModel) throws Exception {
            if (!this.compatible(networkModel)) {
                throw new Exception(incompatibleError);
            }
            for (COM.hugin.HAPI.Node node : networkModel.getNodes()) {
                if (!(node instanceof DiscreteDecisionNode)) continue;
                DiscreteDecisionNode discreteDecisionNode = (DiscreteDecisionNode)node;
                discreteDecisionNode.getTable().setData(this.policies.get(discreteDecisionNode.getName()));
            }
        }

        public static String getSignature(DiscreteDecisionNode discreteDecisionNode) throws ExceptionHugin {
            return discreteDecisionNode.getName() + " : " + discreteDecisionNode.getClass().toString() + " : " + discreteDecisionNode.getNumberOfStates() + " : " + discreteDecisionNode.getTable().getSize();
        }
    }

    private static class ThreadBreaker
    implements Runnable {
        private ThreadBreaker() {
        }

        public synchronized void run() {
            threadResume = false;
            while (!threadResume) {
                try {
                    this.wait();
                }
                catch (Exception exception) {}
            }
            EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
            LinkedList<Object> linkedList = new LinkedList<Object>();
            while (eventQueue.peekEvent() != null) {
                try {
                    AWTEvent aWTEvent = eventQueue.getNextEvent();
                    if (aWTEvent instanceof ComponentEvent) continue;
                    linkedList.add(aWTEvent);
                }
                catch (Exception exception) {}
            }
            for (AWTEvent aWTEvent : linkedList) {
                eventQueue.postEvent(aWTEvent);
            }
        }
    }

    private static class NodeInstantiation {
        public int nodeNumber;
        public int stateIndex;

        public NodeInstantiation(int n, int n2) {
            this.nodeNumber = n;
            this.stateIndex = n2;
        }
    }

    public static class HelpListener
    implements ActionListener {
        private String helpPage;
        private HelpPanel helpPanel;

        public HelpListener(HelpPanel helpPanel, String string) {
            this.helpPanel = helpPanel;
            this.helpPage = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.helpPanel.setHelpPage(this.helpPage);
            if (!this.helpPanel.isVisible()) {
                Container container = ((JComponent)actionEvent.getSource()).getTopLevelAncestor();
                int n = container.getY();
                int n2 = container.getX() - this.helpPanel.getWidth();
                if (n2 < 5 && (n2 = container.getX() + container.getWidth()) + this.helpPanel.getWidth() > Toolkit.getDefaultToolkit().getScreenSize().width - 5) {
                    n2 = 5;
                }
                if (n < 5 || n + this.helpPanel.getHeight() > Toolkit.getDefaultToolkit().getScreenSize().height - 5) {
                    n = 5;
                }
                this.helpPanel.setLocation(n2, n);
                this.helpPanel.setVisible(true);
            }
        }
    }

    public static class Interval {
        double lower;
        double upper;

        public Interval() {
        }

        public Interval(double d, double d2) {
            this.lower = d;
            this.upper = d2;
        }

        public String toString() {
            return HuginGUIUtils.printInterval(this);
        }

        public boolean equals(Object object) {
            return object instanceof Interval && ((Interval)object).upper == this.upper && ((Interval)object).lower == this.lower;
        }
    }
}

