/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIFrame;
import COM.hugin.HGUI.HuginGUIUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HuginHelpButton
extends JButton {
    private HelpFinderPanel helpFrame = new HelpFinderPanel();
    private Component oldGlass;
    private JDialog htmlViewer;
    private JEditorPane htmlDisplay;
    private LinkedList<URL> history;
    JButton forward;
    JButton back;
    boolean pressed = false;
    private int historyIndex = -1;

    public HuginHelpButton(HuginGUIFrame huginGUIFrame) {
        super(new ImageIcon(ClassLoader.getSystemResource("icons/help.gif")));
        this.htmlViewer = this.createHtmlViewer(huginGUIFrame);
        this.history = new LinkedList();
    }

    private JDialog createHtmlViewer(HuginGUIFrame huginGUIFrame) {
        JDialog jDialog = new JDialog(huginGUIFrame, HuginGUIConstants.get("HELP_BUTTON_LABEL"), false);
        JPanel jPanel = new JPanel(new BorderLayout());
        this.htmlDisplay = new JEditorPane(){

            protected InputStream getStream(URL uRL) throws IOException {
                return new SortingStream(super.getStream(uRL));
            }
        };
        this.htmlDisplay.setEditable(false);
        this.htmlDisplay.addHyperlinkListener(new LinkListener());
        this.htmlDisplay.setMargin(new Insets(0, 10, 0, 10));
        this.htmlDisplay.setBackground(new Color(255, 255, 204));
        JScrollPane jScrollPane = new JScrollPane(this.htmlDisplay);
        jScrollPane.setPreferredSize(new Dimension(500, 400));
        JButton jButton = new JButton(HuginGUIConstants.get("str_close"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HuginHelpButton.this.htmlViewer.dispose();
                HuginHelpButton.this.history.clear();
                HuginHelpButton.this.historyIndex = -1;
                HuginHelpButton.this.back.setEnabled(false);
                HuginHelpButton.this.forward.setEnabled(false);
            }
        });
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new FlowLayout(2));
        jPanel3.add(jButton);
        jPanel2.add((Component)jPanel3, "East");
        JPanel jPanel4 = new JPanel(new FlowLayout(0));
        this.back = new JButton(HuginGUIConstants.get("str_back"));
        this.back.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    URL uRL = HuginHelpButton.this.historyBack();
                    HuginHelpButton.this.htmlDisplay.setPage(uRL);
                }
                catch (Exception exception) {
                    new HuginGUIError(HuginGUIConstants.get("str_unable_to_display_prev_page_lb") + exception.getMessage());
                }
            }
        });
        this.back.setEnabled(false);
        this.forward = new JButton(HuginGUIConstants.get("str_forward"));
        this.forward.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    URL uRL = HuginHelpButton.this.historyForward();
                    HuginHelpButton.this.htmlDisplay.setPage(uRL);
                }
                catch (Exception exception) {
                    new HuginGUIError(HuginGUIConstants.get("str_unable_to_display_next_page_lb") + exception.getMessage());
                }
            }
        });
        this.forward.setEnabled(false);
        jPanel4.add(this.back);
        jPanel4.add(this.forward);
        jPanel2.add((Component)jPanel4, "West");
        jPanel.add(jScrollPane);
        jPanel.add((Component)jPanel2, "South");
        jDialog.setContentPane(jPanel);
        jDialog.pack();
        return jDialog;
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiersEx() & 0x400) == 1024) {
            if (!this.pressed) {
                this.mousePressed(mouseEvent);
            }
            this.pressed = true;
        } else {
            if (this.pressed) {
                this.mouseReleased(mouseEvent);
            }
            this.pressed = false;
        }
        mouseEvent.consume();
    }

    public void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (this.pressed) {
            this.mouseDragged(mouseEvent);
        }
        mouseEvent.consume();
    }

    private void mousePressed(MouseEvent mouseEvent) {
        this.oldGlass = Hugin.mainFrame.getGlassPane();
        Hugin.mainFrame.setGlassPane(this.helpFrame);
        this.helpFrame.setPosition(mouseEvent.getX(), mouseEvent.getY());
        this.helpFrame.setVisible(true);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        String string = this.helpFrame.getHelpFile(mouseEvent.getX(), mouseEvent.getY());
        if (string != null) {
            try {
                String string2 = HuginGUIUtils.getHtmlHelpDir();
                if (string2 == null || string2.length() == 0) {
                    new HuginGUIError(HuginGUIConstants.get("str_unable_to_display_help_huginhome_not_set"));
                    this.helpFrame.setVisible(false);
                    Hugin.mainFrame.setGlassPane(this.oldGlass);
                    return;
                }
                string = "file://localhost/" + string2 + string;
                string = string.replace('\\', '/');
                URL uRL = new URL(string);
                this.htmlDisplay.setPage(uRL);
                if (!this.htmlViewer.isVisible()) {
                    this.history.clear();
                    this.historyIndex = -1;
                    HuginGUIUtils.placeNextTo(Hugin.mainFrame, this.htmlViewer);
                }
                if (this.htmlDisplay.getPage().equals(uRL)) {
                    this.historyAdd(uRL);
                }
                this.htmlViewer.setVisible(true);
            }
            catch (Exception exception) {
                new HuginGUIError(HuginGUIConstants.get("str_unable_to_display_help_page_") + string + "\n" + exception.getMessage());
            }
        }
        this.helpFrame.setVisible(false);
        Hugin.mainFrame.setGlassPane(this.oldGlass);
        mouseEvent.consume();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.helpFrame.setPosition(mouseEvent.getX(), mouseEvent.getY());
        mouseEvent.consume();
    }

    private void historyAdd(URL uRL) {
        if (this.history.size() > 0 && uRL.equals(this.history.get(this.historyIndex))) {
            return;
        }
        if (this.history.size() > 0 && this.historyIndex >= 0 && this.historyIndex < this.history.size()) {
            while (this.history.size() > this.historyIndex + 1) {
                this.history.remove(this.history.size() - 1);
            }
        }
        this.history.add(uRL);
        ++this.historyIndex;
        this.back.setEnabled(this.historyCanGoBack());
        this.forward.setEnabled(this.historyCanGoForward());
    }

    private URL historyBack() {
        if (this.historyIndex > 0) {
            --this.historyIndex;
        }
        this.back.setEnabled(this.historyCanGoBack());
        this.forward.setEnabled(this.historyCanGoForward());
        return this.history.get(this.historyIndex);
    }

    private boolean historyCanGoBack() {
        return this.historyIndex > 0 && this.history.size() > 0;
    }

    private URL historyForward() {
        if (this.historyIndex < this.history.size() - 1) {
            ++this.historyIndex;
        }
        this.back.setEnabled(this.historyCanGoBack());
        this.forward.setEnabled(this.historyCanGoForward());
        return this.history.get(this.historyIndex);
    }

    private boolean historyCanGoForward() {
        return this.historyIndex < this.history.size() - 1;
    }

    public static interface FinalHelpComponent {
    }

    private class SortingStream
    extends BufferedInputStream {
        private InputStream stream;
        private byte[][] matches;

        public SortingStream(InputStream inputStream) {
            super(inputStream);
            this.matches = new byte[][]{"<link rel=stylesheet href=\"pane.css\" type=\"text/css\">".getBytes(), "<a href=\"javascript:history.go(-1)\">back</a>".getBytes()};
            this.stream = inputStream;
        }

        public int available() throws IOException {
            return this.stream.available();
        }

        public void close() throws IOException {
            this.stream.close();
        }

        public void mark(int n) {
            this.stream.mark(n);
        }

        public boolean markSupported() {
            return this.stream.markSupported();
        }

        public int read() throws IOException {
            return super.read();
        }

        public int read(byte[] byArray) {
            return 0;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = super.read(byArray, n, n2);
            int n4 = 0;
            for (int i = 0; i < this.matches.length; ++i) {
                n4 = this.removeFromResult(n3, byArray, this.matches[i]);
                n3 = n3 == -1 ? -1 : n3 - n4;
            }
            return n3;
        }

        private int removeFromResult(int n, byte[] byArray, byte[] byArray2) {
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                if (n2 >= byArray2.length) {
                    byArray[i - byArray2.length] = byArray[i];
                }
                if (n2 >= byArray2.length || byArray[i] != byArray2[n2] && byArray[i] + 32 != byArray2[n2]) continue;
                ++n2;
            }
            return n2 >= byArray2.length ? byArray2.length : 0;
        }

        public void reset() throws IOException {
            this.stream.reset();
        }

        public long skip(long l) throws IOException {
            return this.stream.skip(l);
        }
    }

    private class HelpFinderPanel
    extends JPanel {
        private Rectangle dirty;
        private Rectangle size;
        private Rectangle marking;
        private Rectangle oldMarking;
        int width;
        int height;
        private Image img;
        private Image activeImg;
        private Image symbol;
        private Point cursorPoint;
        RepaintManager repainter;
        RepaintManager oldRepainter;
        private LinkedList<Component> menuStack;
        Color markingColor;
        String helpFile;

        public HelpFinderPanel() {
            this.setOpaque(false);
            this.symbol = new ImageIcon(ClassLoader.getSystemResource("icons/helpIcon.png")).getImage();
            this.width = this.symbol.getWidth(this);
            this.height = this.symbol.getHeight(this);
            this.size = new Rectangle(0, 0, this.width, this.height);
            this.repainter = new RepaintManager(){

                public void addDirtyRegion(JComponent jComponent, int n, int n2, int n3, int n4) {
                    if (jComponent instanceof HelpFinderPanel) {
                        super.addDirtyRegion(jComponent, (int)HelpFinderPanel.this.dirty.getX(), (int)HelpFinderPanel.this.dirty.getY(), (int)HelpFinderPanel.this.dirty.getWidth(), (int)HelpFinderPanel.this.dirty.getHeight());
                    } else {
                        super.addDirtyRegion(jComponent, n, n2, n3, n4);
                    }
                }
            };
            this.menuStack = new LinkedList();
            this.markingColor = UIManager.getDefaults().getColor("MenuItem.selectionBackground");
            this.oldMarking = null;
        }

        public void setVisible(boolean bl) {
            if (bl) {
                this.oldRepainter = RepaintManager.currentManager(Hugin.mainFrame);
                RepaintManager.setCurrentManager(this.repainter);
            } else {
                if (this.oldRepainter != null) {
                    RepaintManager.setCurrentManager(this.oldRepainter);
                }
                ListIterator<Component> listIterator = this.menuStack.listIterator(this.menuStack.size());
                while (listIterator.hasPrevious()) {
                    listIterator.previous().setVisible(false);
                    listIterator.remove();
                }
            }
            super.setVisible(bl);
        }

        public String getHelpFile(int n, int n2) {
            this.cursorPoint = SwingUtilities.convertPoint(HuginHelpButton.this, n, n2, this);
            Component component = this.getActiveComponent(this.cursorPoint, Hugin.mainFrame.getLayeredPane());
            return Hugin.helpManager.getHelpFile(component);
        }

        public void setPosition(int n, int n2) {
            this.cursorPoint = SwingUtilities.convertPoint(HuginHelpButton.this, n, n2, this);
            this.size.setLocation((int)(this.cursorPoint.getX() - (double)(this.width / 2)), (int)(this.cursorPoint.getY() - (double)(this.height / 2)));
            if (this.dirty == null) {
                this.dirty = (Rectangle)this.size.clone();
            } else {
                this.dirty.add(this.size);
            }
            this.oldMarking = this.marking;
            this.marking = this.handleActiveComponent(this.cursorPoint);
            if (this.marking == null && this.oldMarking != null || this.marking != null && !this.marking.equals(this.oldMarking)) {
                if (this.marking != null) {
                    this.dirty.add(this.marking);
                }
                if (this.oldMarking != null) {
                    this.dirty.add(this.oldMarking);
                }
            }
            this.repaint();
        }

        public Dimension getSize() {
            return new Dimension(20, 20);
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
        }

        public void paintComponent(Graphics graphics) {
            Point point = SwingUtilities.convertPoint(this, this.cursorPoint, Hugin.mainFrame.getLayeredPane());
            if (this.marking != null) {
                graphics.setColor(this.markingColor);
                graphics.drawRect((int)this.marking.getX() + 1, (int)this.marking.getY() + 1, (int)this.marking.getWidth() - 2, (int)this.marking.getHeight() - 2);
                graphics.drawRect((int)this.marking.getX() + 2, (int)this.marking.getY() + 2, (int)this.marking.getWidth() - 4, (int)this.marking.getHeight() - 4);
                graphics.drawRect((int)this.marking.getX() + 3, (int)this.marking.getY() + 3, (int)this.marking.getWidth() - 6, (int)this.marking.getHeight() - 6);
            }
            graphics.drawImage(this.symbol, (int)this.size.getX(), (int)this.size.getY(), this);
            this.dirty = (Rectangle)this.size.clone();
            if (this.marking == null && this.oldMarking != null || this.marking != null && !this.marking.equals(this.oldMarking)) {
                if (this.marking != null) {
                    this.dirty.add(this.marking);
                }
                this.oldMarking = this.marking;
            }
        }

        private Rectangle handleActiveComponent(Point point) {
            int n;
            Component component = this.getActiveComponent(point, Hugin.mainFrame.getLayeredPane());
            int n2 = -1;
            Component component2 = component;
            Rectangle rectangle = null;
            if (Hugin.helpManager.isObjectRegistered(component)) {
                if (component.getParent() instanceof JViewport) {
                    JViewport jViewport = (JViewport)component.getParent();
                    Dimension dimension = jViewport.getExtentSize();
                    rectangle = SwingUtilities.convertRectangle(jViewport, new Rectangle(0, 0, (int)dimension.getWidth(), (int)dimension.getHeight()), Hugin.mainFrame.getLayeredPane());
                } else {
                    rectangle = SwingUtilities.convertRectangle(component.getParent(), component.getBounds(), Hugin.mainFrame.getLayeredPane());
                }
            }
            while (this.menuStack.size() > 0 && n2 < 0 && component2 != null) {
                n2 = this.menuStack.indexOf(component2);
                if (n2 >= 0) continue;
                component2 = component2.getParent();
            }
            if (component instanceof JMenu && this.menuStack.size() > 0 && ((JMenu)component).getPopupMenu().equals(this.menuStack.getLast())) {
                ++n2;
            }
            for (n = this.menuStack.size() - 1; n > n2; --n) {
                this.menuStack.remove(n).setVisible(false);
            }
            if (component instanceof JMenu) {
                if (((JMenu)component).isPopupMenuVisible()) {
                    return rectangle;
                }
                n = ((JMenu)component).isEnabled() ? 1 : 0;
                ((JMenu)component).setEnabled(true);
                ((JMenu)component).setPopupMenuVisible(true);
                if (n == 0) {
                    ((JMenu)component).setEnabled(false);
                }
                this.menuStack.add(((JMenu)component).getPopupMenu());
            }
            return rectangle;
        }

        private Component getActiveComponent(Point point, Component component) {
            Component component2 = component.getComponentAt(point);
            if (component2 != null && component2 != component) {
                if (component2 instanceof FinalHelpComponent) {
                    return component2;
                }
                if (component2 instanceof JRootPane) {
                    component2 = ((JRootPane)component2).getLayeredPane();
                }
                Point point2 = SwingUtilities.convertPoint(component, point, component2);
                return this.getActiveComponent(point2, component2);
            }
            return component;
        }
    }

    private class LinkListener
    implements HyperlinkListener {
        private LinkListener() {
        }

        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                try {
                    HuginHelpButton.this.htmlDisplay.setPage(hyperlinkEvent.getURL());
                    if (HuginHelpButton.this.htmlDisplay.getPage().equals(hyperlinkEvent.getURL())) {
                        HuginHelpButton.this.historyAdd(hyperlinkEvent.getURL());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

