/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginFileLoader;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class HyperlinkEventHandler {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CreateHyperlinkListener
    implements ActionListener {
        LinkedList<Link> linkList = new LinkedList();
        File file;
        JDialog self;
        JEditorPane editor;
        int position;

        public CreateHyperlinkListener(JDialog jDialog, JEditorPane jEditorPane, int n) {
            this.self = jDialog;
            this.editor = jEditorPane;
            this.position = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            int n;
            Object object2;
            String string = ((JMenuItem)actionEvent.getSource()).getName();
            String string2 = this.editor.getSelectedText();
            if (string2 == null) {
                return;
            }
            if (string2.length() == 0) {
                return;
            }
            String string3 = this.editor.getText();
            String string4 = "";
            Link link = this.getLink((HTMLDocument)this.editor.getDocument(), this.position);
            if (link != null) {
                this.editor.setSelectionStart(link.getBegin());
                this.editor.setSelectionEnd(link.getEnd());
                string2 = this.editor.getSelectedText();
            }
            if (string.equals("remove")) {
                if (link != null) {
                    string4 = string2;
                    this.editor.replaceSelection(string2);
                }
                return;
            }
            if (string.equals("http")) {
                object2 = "";
                if (link != null) {
                    object2 = link.getType() == 1 ? this.getUrl(link.getPath()) : this.getUrl("www.");
                    if (object2 == null) {
                        return;
                    }
                } else {
                    object2 = this.getUrl("www.");
                }
                if (object2 != null && ((String)object2).length() > 3) {
                    string4 = "<a href=\"http://" + (String)object2 + "\">" + string2 + "</a>";
                }
            } else {
                object2 = Hugin.mainFrame.getMostRecentDataFile();
                if (link != null && link.getType() == 0) {
                    object2 = new File(link.getPath());
                }
                HuginFileLoader huginFileLoader = new HuginFileLoader(11, (File)object2, 0);
                if (!((File)object2).isDirectory()) {
                    huginFileLoader.setSelectedFile((File)object2);
                }
                huginFileLoader.setLocation(100, 100);
                n = huginFileLoader.showDialog(this.self);
                if (n == 1) {
                    return;
                }
                if (n == -1) {
                    string4 = string2;
                    this.editor.replaceSelection(string2);
                    return;
                }
                if (n == 0) {
                    object = huginFileLoader.getSelectedFile().getPath();
                    string4 = "<a href=\"file://" + (String)object + "\">" + string2 + "</a>";
                }
            }
            if (string4.length() == 0 && link == null) {
                string4 = string2;
                this.editor.replaceSelection(string2);
            } else if (string4.length() > 0) {
                int n2 = this.editor.getSelectionStart();
                int n3 = this.editor.getSelectionEnd();
                n = this.editor.getCaretPosition();
                this.editor.replaceSelection("");
                object = (HTMLDocument)this.editor.getDocument();
                HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)this.editor.getEditorKit();
                try {
                    if (n2 == 1) {
                        hTMLEditorKit.insertHTML((HTMLDocument)object, n2, string4, 2, 2, HTML.Tag.A);
                    } else {
                        hTMLEditorKit.insertHTML((HTMLDocument)object, n2, string4, 0, 0, HTML.Tag.A);
                    }
                }
                catch (BadLocationException badLocationException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.editor.repaint();
        }

        private LinkedList<Link> parseHtml(String string) {
            String string2 = string;
            String string3 = string2.toLowerCase();
            int n = string3.indexOf("<a href=\"");
            while (n >= 0) {
                int n2 = string3.indexOf("\"", n + 9);
                String string4 = string2.substring(n + 9, n2);
                n = n2 + 2;
                n2 = string3.indexOf("</a>", n);
                String string5 = string2.substring(n, n2);
                this.linkList.add(new Link(string5, string4, 1, 1));
                n = string3.indexOf("<a href=\"", n2);
            }
            return this.linkList;
        }

        private Link getLink(String string, int n) {
            String string2 = string;
            for (int i = 0; i < this.linkList.size(); ++i) {
                Link link = this.linkList.get(i);
                String string3 = link.getName().replaceAll("\\\n", " ").replaceAll(" ", "");
                if (!string3.equals(string2 = string2.replaceAll("\\\n", " ").replaceAll(" ", ""))) continue;
                return link;
            }
            return null;
        }

        private Link getLink(HTMLDocument hTMLDocument, int n) {
            HTMLDocument hTMLDocument2 = hTMLDocument;
            Element element = hTMLDocument2.getCharacterElement(n);
            int n2 = element.getStartOffset();
            int n3 = element.getEndOffset();
            AttributeSet attributeSet = element.getAttributes();
            AttributeSet attributeSet2 = (AttributeSet)attributeSet.getAttribute(HTML.Tag.A);
            String string = attributeSet2 != null ? (String)attributeSet2.getAttribute(HTML.Attribute.HREF) : null;
            boolean bl = false;
            if (string != null) {
                String string2 = string;
                return new Link("", string2, n2, n3);
            }
            return null;
        }

        private String getUrl(String string) {
            return (String)JOptionPane.showInputDialog(this.self, HuginGUIConstants.get("EVENT_MSG_URL"), HuginGUIConstants.get("ADD_URL_LINK"), -1, null, null, string);
        }

        private class Link {
            String name;
            String path;
            int FILE = 0;
            int HTTP = 1;
            int type;
            int begin;
            int end;

            public Link(String string, String string2, int n, int n2) {
                this.name = string;
                this.path = string2;
                this.begin = n;
                this.end = n2;
                if (string2.startsWith("file")) {
                    this.type = this.FILE;
                }
                if (string2.startsWith("http")) {
                    this.type = this.HTTP;
                }
            }

            public String getName() {
                return this.name;
            }

            public String getPath() {
                return this.path.substring(7);
            }

            public int getType() {
                return this.type;
            }

            public int getBegin() {
                return this.begin;
            }

            public int getEnd() {
                return this.end;
            }
        }
    }

    static class LinkListener
    extends MouseAdapter {
        JPopupMenu popup;
        JEditorPane htmlPane;
        JDialog dialog;

        public LinkListener(JEditorPane jEditorPane, JDialog jDialog) {
            this.htmlPane = jEditorPane;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (this.htmlPane.isEditable()) {
                this.showPopup(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.htmlPane.isEditable()) {
                this.showPopup(mouseEvent);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        private void showPopup(MouseEvent mouseEvent) {
            Point point;
            int n = -1;
            if (!this.htmlPane.isEditable() || (n = this.htmlPane.viewToModel(point = new Point(mouseEvent.getX(), mouseEvent.getY()))) >= 0) {
                // empty if block
            }
            this.createPopup(n);
            if (mouseEvent.isPopupTrigger()) {
                this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        private void createPopup(int n) {
            this.popup = new JPopupMenu();
            JMenuItem jMenuItem = new JMenuItem(HuginGUIConstants.get("ADD_HYPERLINK"));
            jMenuItem.addActionListener(new CreateHyperlinkListener(this.dialog, this.htmlPane, n));
            jMenuItem.setName("file");
            this.popup.add(jMenuItem);
            JMenuItem jMenuItem2 = new JMenuItem(HuginGUIConstants.get("ADD_URL_LINK"));
            jMenuItem2.addActionListener(new CreateHyperlinkListener(this.dialog, this.htmlPane, n));
            jMenuItem2.setName("http");
            this.popup.add(jMenuItem2);
            JMenuItem jMenuItem3 = new JMenuItem(HuginGUIConstants.get("REMOVE_LINK"));
            jMenuItem3.addActionListener(new CreateHyperlinkListener(this.dialog, this.htmlPane, n));
            jMenuItem3.setName("remove");
            this.popup.add(jMenuItem3);
        }
    }

    static class DescHyperlinkListener
    implements HyperlinkListener {
        DescHyperlinkListener() {
        }

        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                Hugin.mainFrame.getStatusBar().write(hyperlinkEvent.getURL().toString());
            }
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.EXITED) {
                Hugin.mainFrame.getStatusBar().write("");
            }
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                try {
                    if (Hugin.mainFrame.preferences.default_browser.length() > 0) {
                        if (System.getProperty("mrj.version") != null) {
                            String[] stringArray = Hugin.mainFrame.preferences.default_browser.split("/");
                            String[] stringArray2 = new String[]{"open", "-a", stringArray[stringArray.length - 1], hyperlinkEvent.getURL().toString().replace(" ", "%20")};
                            Runtime.getRuntime().exec(stringArray2);
                        } else {
                            String[] stringArray = new String[]{Hugin.mainFrame.preferences.default_browser, hyperlinkEvent.getURL().toString()};
                            Runtime.getRuntime().exec(stringArray);
                        }
                    } else {
                        new HuginGUIError(HuginGUIConstants.get("str_please_specify_browser_in_prefs_pane"));
                    }
                }
                catch (Exception exception) {
                    new HuginGUIError(HuginGUIConstants.get("str_unable_to_launch_specified_browser_ARG0", new String[]{exception.getMessage()}));
                }
            }
        }
    }

    static class NodeKeyListener
    implements KeyListener {
        JEditorPane htmlPane;

        public NodeKeyListener(JEditorPane jEditorPane) {
            this.htmlPane = jEditorPane;
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            int n2 = this.htmlPane.getCaretPosition();
            if (n == 10) {
                keyEvent.consume();
                HTMLDocument hTMLDocument = (HTMLDocument)this.htmlPane.getDocument();
                HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)this.htmlPane.getEditorKit();
                int n3 = this.htmlPane.getSelectionStart();
                try {
                    hTMLEditorKit.insertHTML(hTMLDocument, n3, "<br>", 0, 0, HTML.Tag.BR);
                    this.htmlPane.setCaretPosition(n3 + 1);
                }
                catch (BadLocationException badLocationException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.htmlPane.repaint();
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }
}

