/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class I18nMonitor
extends JPanel {
    private JDialog window;
    private Properties props = new Properties();
    private boolean changed = false;
    private String language = "";
    private String country = "";
    private int localeNumber = 0;
    private JLabel viewString = new JLabel("  ");
    private ArrayList<String> sortedKeyList = null;
    private JList inspectList = null;
    private JList missingList = null;
    private static boolean running = false;

    public I18nMonitor() {
        if (!running) {
            running = true;
            this.window = new JDialog(Hugin.mainFrame);
            this.window.setTitle("i18n monitor");
            this.window.getContentPane().setLayout(new GridLayout(1, 1));
            this.window.getContentPane().add(this);
            this.window.pack();
            this.window.setDefaultCloseOperation(2);
            this.window.setLocation(new Point(100, 100));
            this.window.setVisible(true);
            this.refresh();
            this.window.addWindowListener(new WindowListener(){

                public void windowActivated(WindowEvent windowEvent) {
                }

                public void windowClosed(WindowEvent windowEvent) {
                    running = false;
                }

                public void windowClosing(WindowEvent windowEvent) {
                    if (I18nMonitor.this.changed) {
                        Object[] objectArray = new String[]{"Save changes", "Discard changes"};
                        int n = JOptionPane.showOptionDialog(I18nMonitor.this.window, "Properties have been editet. Do you wish to save the changes before closing?", "Discard changes?", 0, 3, null, objectArray, objectArray[0]);
                        if (n == 0) {
                            try {
                                String string = "_" + I18nMonitor.this.language + "_" + I18nMonitor.this.country;
                                String string2 = "Constants" + string + ".xml";
                                I18nMonitor.this.props.storeToXML(new FileOutputStream(new File("classes" + File.separatorChar + "i18n" + File.separatorChar + string2)), "");
                                I18nMonitor.this.changed = false;
                                HuginGUIConstants.setLanguage(I18nMonitor.this.localeNumber);
                                Hugin.mainFrame.reInitializeMenues();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }

                public void windowDeactivated(WindowEvent windowEvent) {
                }

                public void windowDeiconified(WindowEvent windowEvent) {
                }

                public void windowIconified(WindowEvent windowEvent) {
                }

                public void windowOpened(WindowEvent windowEvent) {
                }
            });
        }
    }

    public void refresh() {
        if (this.changed) {
            Object[] objectArray = new String[]{"Discard changes and refresh", "Cancel"};
            int n = JOptionPane.showOptionDialog(this.window, "Properties have been editet. Refreshing window will discard all changes.", "Discard changes?", 0, 3, null, objectArray, objectArray[0]);
            if (n == 0) {
                this.localeNumber = HuginGUIConstants.getLocaleNumber();
                this.language = HuginGUIConstants.getCurrentLocale().getLanguage();
                this.country = HuginGUIConstants.getCurrentLocale().getCountry();
                this.reInitialize();
                this.changed = false;
            }
        } else {
            this.localeNumber = HuginGUIConstants.getLocaleNumber();
            this.language = HuginGUIConstants.getCurrentLocale().getLanguage();
            this.country = HuginGUIConstants.getCurrentLocale().getCountry();
            this.reInitialize();
        }
    }

    public void reInitialize() {
        this.props.clear();
        String string = "_" + this.language + "_" + this.country;
        String string2 = "Constants" + string + ".xml";
        try {
            this.props.loadFromXML(new FileInputStream(new File("classes" + File.separatorChar + "i18n" + File.separatorChar + string2)));
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        this.removeAll();
        this.setLayout(new GridLayout(1, 1));
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
        jPanel2.add(new JLabel("Locale:"));
        jPanel2.add(new JLabel(this.language + "_" + this.country));
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)new JLabel("Missing string lookups:"), "North");
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        for (String object22 : HuginGUIConstants.missingProperties) {
            defaultListModel.addElement(object22);
        }
        this.missingList = new JList(defaultListModel);
        this.missingList.setSelectionMode(0);
        jPanel3.add(new JScrollPane(this.missingList));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        JButton jButton = new JButton("Add string");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)I18nMonitor.this.missingList.getSelectedValue();
                if (string != null) {
                    ((DefaultListModel)I18nMonitor.this.missingList.getModel()).removeElementAt(I18nMonitor.this.missingList.getSelectedIndex());
                    I18nMonitor.this.sortedKeyList.add(string);
                    Collections.sort(I18nMonitor.this.sortedKeyList);
                    int n = I18nMonitor.this.sortedKeyList.indexOf(string);
                    I18nMonitor.this.props.put(string, "\"edit this string\"");
                    ((DefaultListModel)I18nMonitor.this.inspectList.getModel()).add(n, string);
                    I18nMonitor.this.inspectList.setSelectedValue(string, true);
                    I18nMonitor.this.changed = true;
                }
            }
        });
        jPanel4.add(jButton);
        jPanel3.add((Component)jPanel4, "East");
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add((Component)new JLabel("Inspect strings:"), "North");
        DefaultListModel<String> defaultListModel2 = new DefaultListModel<String>();
        this.sortedKeyList = new ArrayList();
        Object object = this.props.keys();
        while (object.hasMoreElements()) {
            this.sortedKeyList.add((String)object.nextElement());
        }
        Collections.sort(this.sortedKeyList);
        for (String string3 : this.sortedKeyList) {
            defaultListModel2.addElement(string3);
        }
        this.inspectList = new JList(defaultListModel2);
        this.inspectList.setSelectionMode(0);
        jPanel5.add(new JScrollPane(this.inspectList));
        this.inspectList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                try {
                    I18nMonitor.this.viewString.setText(I18nMonitor.this.props.getProperty((String)((JList)listSelectionEvent.getSource()).getSelectedValue()));
                }
                catch (Exception exception) {
                    I18nMonitor.this.viewString.setText("  ");
                }
            }
        });
        jPanel5.add((Component)this.viewString, "South");
        object = new JPanel();
        ((Container)object).setLayout(new BoxLayout((Container)object, 1));
        JButton jButton2 = new JButton("Edit string");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)I18nMonitor.this.inspectList.getSelectedValue();
                if (string != null) {
                    JPanel jPanel = new JPanel(new BorderLayout());
                    jPanel.add((Component)new JLabel("Important: Text must have surrounding quotationmarks"), "North");
                    final JTextArea jTextArea = new JTextArea(I18nMonitor.this.props.getProperty(string), 10, 50);
                    jPanel.add(new JScrollPane(jTextArea));
                    final JDialog jDialog = new JDialog(I18nMonitor.this.window, "Edit String: " + string, true);
                    JButton jButton = new JButton("Ok");
                    jButton.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            jDialog.dispose();
                        }
                    });
                    JButton jButton2 = new JButton("Cancel");
                    jButton2.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            jTextArea.setText("");
                            jDialog.dispose();
                        }
                    });
                    JPanel jPanel2 = new JPanel(new FlowLayout());
                    jPanel2.add(jButton);
                    jPanel2.add(jButton2);
                    jPanel.add((Component)jPanel2, "South");
                    jDialog.add(jPanel);
                    jDialog.pack();
                    jDialog.addWindowListener(new WindowListener(){

                        public void windowActivated(WindowEvent windowEvent) {
                        }

                        public void windowClosed(WindowEvent windowEvent) {
                        }

                        public void windowClosing(WindowEvent windowEvent) {
                            jTextArea.setText("");
                        }

                        public void windowDeactivated(WindowEvent windowEvent) {
                        }

                        public void windowDeiconified(WindowEvent windowEvent) {
                        }

                        public void windowIconified(WindowEvent windowEvent) {
                        }

                        public void windowOpened(WindowEvent windowEvent) {
                        }
                    });
                    jDialog.setVisible(true);
                    String string2 = jTextArea.getText();
                    if (string2 != null && string2.length() > 0) {
                        I18nMonitor.this.props.put(string, string2);
                        I18nMonitor.this.viewString.setText(I18nMonitor.this.props.getProperty(string));
                        I18nMonitor.this.changed = true;
                    }
                }
            }
        });
        JButton jButton3 = new JButton("New string");
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = JOptionPane.showInputDialog(I18nMonitor.this.window, "Enter name of new string", "");
                if (string != null && string.length() > 0) {
                    if (I18nMonitor.this.props.getProperty(string) == null) {
                        I18nMonitor.this.sortedKeyList.add(string);
                        Collections.sort(I18nMonitor.this.sortedKeyList);
                        int n = I18nMonitor.this.sortedKeyList.indexOf(string);
                        I18nMonitor.this.props.put(string, "\"edit this string\"");
                        ((DefaultListModel)I18nMonitor.this.inspectList.getModel()).add(n, string);
                        I18nMonitor.this.changed = true;
                    }
                    I18nMonitor.this.inspectList.setSelectedValue(string, true);
                    I18nMonitor.this.viewString.setText(I18nMonitor.this.props.getProperty(string));
                }
            }
        });
        ((Container)object).add(jButton2);
        ((Container)object).add(jButton3);
        JButton jButton4 = new JButton("Delete string");
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = I18nMonitor.this.inspectList.getSelectedIndex();
                String string = (String)I18nMonitor.this.inspectList.getSelectedValue();
                if (string != null) {
                    ((DefaultListModel)I18nMonitor.this.inspectList.getModel()).removeElement(string);
                    I18nMonitor.this.props.remove(string);
                    I18nMonitor.this.inspectList.setSelectedIndex(n);
                    I18nMonitor.this.changed = true;
                }
            }
        });
        ((Container)object).add(jButton4);
        jPanel5.add((Component)object, "East");
        JPanel jPanel6 = new JPanel(new GridLayout(2, 1));
        jPanel6.add(jPanel3);
        jPanel6.add(jPanel5);
        jPanel.add(jPanel6);
        JPanel jPanel7 = new JPanel(new FlowLayout(2));
        JButton jButton5 = new JButton("Refresh");
        jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                I18nMonitor.this.refresh();
            }
        });
        jPanel7.add(jButton5);
        JButton jButton6 = new JButton("Save " + string2);
        jButton6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (I18nMonitor.this.changed) {
                    try {
                        String string = "_" + I18nMonitor.this.language + "_" + I18nMonitor.this.country;
                        String string2 = "Constants" + string + ".xml";
                        I18nMonitor.this.props.storeToXML(new FileOutputStream(new File("classes" + File.separatorChar + "i18n" + File.separatorChar + string2)), "");
                        I18nMonitor.this.changed = false;
                        HuginGUIConstants.setLanguage(I18nMonitor.this.localeNumber);
                        Hugin.mainFrame.reInitializeMenues();
                    }
                    catch (Exception exception) {
                        new HuginGUIError(exception);
                    }
                }
            }
        });
        jPanel7.add(jButton6);
        jPanel.add((Component)jPanel7, "South");
        this.add(jPanel);
        this.window.pack();
    }
}

